# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Extension(pulumi.CustomResource):
    database: pulumi.Output[str]
    """
    Which database to create the extension on. Defaults to provider database.
    """
    name: pulumi.Output[str]
    """
    The name of the extension.
    """
    schema: pulumi.Output[str]
    """
    Sets the schema of an extension.
    """
    version: pulumi.Output[str]
    """
    Sets the version number of the extension.
    """
    def __init__(__self__, resource_name, opts=None, database=None, name=None, schema=None, version=None, __props__=None, __name__=None, __opts__=None):
        """
        The ``.Extension`` resource creates and manages an extension on a PostgreSQL
        server.


        ## Usage

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        my_extension = postgresql.Extension("myExtension")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database: Which database to create the extension on. Defaults to provider database.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input[str] schema: Sets the schema of an extension.
        :param pulumi.Input[str] version: Sets the version number of the extension.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['database'] = database
            __props__['name'] = name
            __props__['schema'] = schema
            __props__['version'] = version
        super(Extension, __self__).__init__(
            'postgresql:index/extension:Extension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, database=None, name=None, schema=None, version=None):
        """
        Get an existing Extension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database: Which database to create the extension on. Defaults to provider database.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input[str] schema: Sets the schema of an extension.
        :param pulumi.Input[str] version: Sets the version number of the extension.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["database"] = database
        __props__["name"] = name
        __props__["schema"] = schema
        __props__["version"] = version
        return Extension(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

