~~~
# Code blocks in the markdown content file, direct
# the building of page elements to be filled.
# Start at the first page in the document
page = doc[1]
box = page.select('main')
~~~

# PageBot Version 0.6

## What is PageBot?

PageBot is a page layout program, that enables designers to create high quality documents using code. 
It is available both as Python library context for [DrawBot](https://www.drawbot.com) and as part of a collection of stand-alone desktop applications that can be created from it. 

Initiated by [TYPETR](https://typetr.typenetwork.com), the aim is to create a system for scriptable applications generating high quality typographic documents for a variety of output media, that support high quality fonts.

PageBot is available under MIT Open Source license from [github.com/PageBot/PageBot](https://github.com/PageBot/PageBot)

A manual, generated automatically with PageBot, is at [typenetwork.github.io/PageBot](https://typenetwork.github.io/PageBot)

An example website generated automatically with PageBot, is at [designdesign.space](http://designdesign.space) which also includes entry points for studies and workshops how to work with PageBot.

The TYPETR Upgrade website [upgrade.typenetwork.com](https://upgrade.typenetwork.com) is an example where the webiste and all illustrations/animations are generated by PageBot scripts.


## Current status

Although publicly available as Open Source under an MIT license, PageBot is still in a testing/alpha phase.
More examples need to be created to fully test all functions.

~~~
page = page.next # Go to the next page and select the box
box = page.select('main')
~~~

## Functionality

An overview of PageBot functions reads like this:

* Various types of Element objects can be placed on a page or inside other Element objects.
* Grids can be defined through style measurements and views.
* Page templates (or templates for any other element combination) can be defined and applied.
* Automatic layout conditions for elements, like even distribution across or floating down parent elements.
* Specialized views on a Document, such as plain pages, spreads and other layout of page groups, optional with crop-marks, registration-mark, color-strips, file name, etc. The result of all views can be placed on pages as illustration.
* Graphics - using all Drawbot drawing tools.
* All image filtering supplied by Drawbot ImageObject.
* Access and modify images on pixel-level.
* Cascading styles, where Element values inherit from parent Elements, similar to CSS behavior.   
* Text flows are using the macOS FormattedString for all typographic parameters.
* Random Text generator for headlines and articles.
* Read text from MarkDown and XML (.MD .XML)
* Support large amount of text processing functions:
   * centered, left, right and justified
   * Text to fit a box and elastic box to fit text
   * Tabular setting
   * Text Flow from one element to another. 
   * Variable Font UI access and instance creation, as the whole "fonttools" Python library is available.
   * Access to all font metrics.
   * Outline Font access modification.
   * Space, groups and kerning access and modifcation.
   * OT layout and feature access and modification.
* 3D Positioning of points, for future usage.
* Motion Graphics, export as animated .gif and .mov files, keyframing timeline, 
* Export to PDF, PNG, JPG, SVG, (animated) GIF, MOV, XML, through programmable views.
* Build web sites, pre-compiling all images used into the formats that can be displayed by browsers (.PNG .JPG .SVG)
* Automatic table of contents, image references, quote references, etc. from composed documents.

## License

All PageBot source code is available as open source under the MIT license. 

However, some other separate works are aggregated in this repository for convenience, and available under their own licenses. 

See LICENSE files for details. 

~~~
page = page.next # Go to the next page and select the box
box = page.select('main')
~~~

## Future developments

* Element classes supporting various types of graphs, info-graphics, maps, PageBot document layout, Variable Font axes layout, font metrics.
* Views for thumbnail page overview, combined booklet-sheets for print, site-maps, etc.
* Add export of text to MarkDown .md files.
* Add export to online documents, such as HTML/CSS/JS for specific designs of web pages, such as Kirby.
* Export to WordPress® PHP sites.
* Export to Ruby®/Sketchup® data files.
* Add export to Angular® files.
* Export to InDesign® and Illustrator®, as close as possible translating PageBot elements to the native file format of these applications.
* Time line, definition and editing, length and fps.
* Integrate the PageBot manual builder with other export functions of the library.
* Add more unit-tests to guarantee the integrity of the library and output consistency.
* Automatic support of ornament frames, in connection to the Element borders and the layout of exiting (TN) border fonts.

## Types of publications to develop

* PageBot stationary and publications as scripted templates
* Specimens for TN library
* Recreation of legacy type specimens as PageBot templates
* Magazines
* Newspapers
* Newsletters
* Books
* Parametric corporate identities, including their styleguides, stationary and business card templates.
* Parametric advertizements (connecting to existing ad-systems)
* Online documents, such as single page websites
* Wayfindng templates for signs and maps
* T-Shirt templates
* Templates with embedded information for graphic- and typographic education.
