# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alfort']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'alfort',
    'version': '0.1.9',
    'description': 'Elm-like interactive application framework for Python',
    'long_description': '# Alfort\n[![Build][build-shiled]][build-url]\n[![Version][version-shield]][version-url]\n[![Downloads][download-shield]][download-url]\n[![Contributors][contributors-shield]][contributors-url]\n[![Issues][issues-shield]][issues-url]\n[![Codecov][codecov-shield]][codecov-url]\n[![Apache License 2.0 License][license-shield]][license-url]\n\nAlfort is simple and plain ELM-like interactive applicaiton framework for Python.\nAlfort is motivated to provide declaretive UI framework independent from any backends.\n\nAlfort is developping now. So there will be breaking changes.\n\n## Features\n* Rendering with Virtual DOM (this feature is truely inspired from hyperapp)\n* Elm-like Movel-View-Update architecture\n* Independent from Real DOM\n* Simple implementation (under 1k loc)\n\n## Installation\n```bash\n$ pip install alfort\n```\n\n## Example\nCode\n```python\nfrom typing import Callable\nfrom enum import Enum, auto\n\nfrom click import prompt\n\nfrom alfort import Alfort, Dispatch, Effect\nfrom alfort.vdom import Node, Patch, PatchText, Props, VDOM\n\n\nhandlers: dict[str, Callable[[], None]] = {}\n\n\nclass Msg(Enum):\n    Up = auto()\n    Down = auto()\n\n\nclass TextNode(Node):\n    def __init__(self, text: str) -> None:\n        print(text)\n\n    def apply(self, patch: Patch) -> None:\n        match patch:\n            case PatchText(new_text):\n                print(new_text)\n            case _:\n                raise ValueError(f"Invalid patch: {patch}")\n\n\nclass AlfortSimpleCounter(Alfort[int, Msg, TextNode]):\n    def create_text(\n        self,\n        text: str,\n        dispatch: Dispatch[Msg],\n    ) -> TextNode:\n        handlers["u"] = lambda: dispatch(Msg.Up)\n        handlers["d"] = lambda: dispatch(Msg.Down)\n        return TextNode(text)\n\n    def create_element(\n        self,\n        tag: str,\n        props: Props,\n        children: list[TextNode],\n        dispatch: Dispatch[Msg],\n    ) -> TextNode:\n        raise ValueError("create_element should not be called")\n\n    def main(\n        self,\n    ) -> None:\n        self._main()\n        while True:\n            c = prompt("press u or d")\n            if handle := handlers.get(c):\n                handle()\n\n\ndef main() -> None:\n    def view(state: int) -> VDOM:\n        return f"Count: {state}"\n\n    def init() -> tuple[int, list[Effect[Msg]]]:\n        return (0, [])\n\n    def update(msg: Msg, state: int) -> tuple[int, list[Effect[Msg]]]:\n        match msg:\n            case Msg.Up:\n                return (state + 1, [])\n            case Msg.Down:\n                return (state - 1, [])\n\n    app = AlfortSimpleCounter(init=init, view=view, update=update)\n    app.main()\n\n\nif __name__ == "__main__":\n    main()\n```\n\nOutput\n```\nCount: 0\npress u or d: u\nCount: 1\npress u or d: u\nCount: 2\npress u or d: u\nCount: 3\npress u or d: d\nCount: 2\npress u or d: d\nCount: 1\n```\n\nIf you need more exmplaes, please check the [examples](https://github.com/ar90n/alfort/tree/main/examples).\n\n## Concept\nAlfort is inspired by TEA(The Elm Architecture). So Alfort makes you create an interactive application with `View`, `Model` and `Update`. If you need more specification about TEA, please see this [documentation](https://guide.elm-lang.org/architecture/).\n\nTherefore, Alfort doesn\'t support Command. So Alfort uses functions whose type is `Callable[[Callable[[Msg], None]], Coroutine[None, None, Any]]` to achieve side effect.\nYou can run some tasks which have side effects in this function.  And, if you need, you can pass the result of side effect as Message to `dicpatch` which is given as an argument.\nThis idea is inspired by [hyperapp](https://github.com/jorgebucaran/hyperapp).\n\nFor now, Alfort doesn\'t support the following features.\n\n* Event subscription\n* Virtual DOM comparison by key\n* Port to the outside of runtime.\n\nAlfort doesn\'t provide Real DOM or other Widgets manupulation.\nBut there is an iterface between your concrete target and Alfort\'s Virtual DOM.\nIt is `Patche`.  So you have to implement some codes to handle some patches.\n[alfort-dom](https://github.com/ar90n/alfort-dom) is an implementation for manupulation DOM.\n\n## For development\n### Install Poery plugins\n```bash\n$ poetry self add "poethepoet[poetry_plugin]"\n```\n\n### Run tests\n```bash\n$ poetry poe test\n```\n\n### Run linter and formatter\n```bash\n$ poetry poe check\n```\n\n## See Also\n* [Elm](https://elm-lang.org/)\n* [hyperapp](https://elm-lang.org/)\n\n## License\n[Apache-2.0](https://github.com/ar90n/alfort/blob/main/LICENSE)\n\n[download-shield]: https://img.shields.io/pypi/dm/alfort?style=flat\n[download-url]: https://pypi.org/project/alfort/\n[version-shield]: https://img.shields.io/pypi/v/alfort?style=flat\n[version-url]: https://pypi.org/project/alfort/\n[build-shiled]: https://img.shields.io/github/workflow/status/ar90n/alfort/CI%20testing/main\n[build-url]: https://github.com/ar90n/alfort/actions/workflows/ci-testing.yml\n[contributors-shield]: https://img.shields.io/github/contributors/ar90n/alfort.svg?style=flat\n[contributors-url]: https://github.com/ar90n/alfort/graphs/contributors\n[issues-shield]: https://img.shields.io/github/issues/ar90n/alfort.svg?style=flat\n[issues-url]: https://github.com/ar90n/alfort/issues\n[license-shield]: https://img.shields.io/github/license/ar90n/alfort.svg?style=flat\n[license-url]: https://github.com/ar90n/alfort/blob/master/LICENSE.txt\n[codecov-shield]: https://codecov.io/gh/ar90n/alfort/branch/main/graph/badge.svg?token=8GKU96ODLY\n[codecov-url]: https://codecov.io/gh/ar90n/alfort\n',
    'author': 'Masahiro Wada',
    'author_email': 'argon.argon.argon@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ar90n/alfort',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
