# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cbdevtools']

package_data = \
{'': ['*']}

install_requires = \
['orpyste>=1.3.2-beta.0,<2.0.0', 'pytest>=6.2.4,<7.0.0']

setup_kwargs = {
    'name': 'cbdevtools',
    'version': '0.0.11b0',
    'description': '"Common Box of Dev Tools" proposing small scripts that can be helpful.',
    'long_description': 'The `Python` module `cbdevtools`\n================================\n\n\n> **I beg your pardon for my english...**\n>\n> English is not my native language, so be nice if you notice misunderstandings, misspellings, or grammatical errors in my documents and codes.\n\n\nLast version: 0.0.11-beta\n-------------------------\n\nThis version **0.0.11-beta** was made on **2022-08-11** .\n\n\nAbout `cbdevtools`\n-----------------\n\nThis project is a *"Common Box of Dev Tools"* (the name comes also from "Christophe BAL Dev Tools"). `cbdevtools` proposes small scripts that can be helpful... at least for the author of this package. :-)\n\n\n### Append one package to `sys.path`\n\nThe function `addfindsrc.addfindsrc` adds one project folder to the system path.\n\n\nLet\'s see one fictive example with the following tree structure.\n\n~~~\n+ mymod\n    + doc\n    + dist\n    + src\n        * __init__.py\n        * ...\n    + tools\n        + debug\n            * cli.py\n~~~\n\nThe `Python` script `tools/debug/cli.py` can easily load the local\n`Python` module `src` thanks to the module `addfindsrc` as it is shwon in the following code.\n\n~~~python\nfrom cbdevtools.addfindsrc import addfindsrc\n\naddfindsrc(\n    file    = __file__,\n    project = \'mymod\',\n)\n\nfrom src import *\n~~~\n\nIf you need to have the path of the project added, just use the value returned by `addfindsrc.addfindsrc`.\n\n\n***WARNING!*** *The directory of the project to add must contain the file `__file__`.*\n\n\n### Selective version of the standard `dir(obj)`\n\nBuilding automatically some `Python` scripts needs sometimes to play with `dir(obj)` of some classes, methods and functions. The function `shortdir.shortdir` can be helpful in this kind of situation.\n\nLets\' consider the following code where the use of regexes allows enough flexibility to ignore some names.\n\n~~~python\nfrom pprint              import pprint\nfrom cbdevtools.shortdir import (\n    shortdir,\n    re_compile, # Just an alias for ``re.compile``.\n    PATTERN_UNDERSCORE # Pattern matching ``-...``.\n)\n\nprint("shortdir(1) =")\npprint(shortdir(1))\nprint()\n\nfor toignore in [\n    [],\n    [\'imag\', \'real\'],\n    [\'as_.+\', \'from_.+\']\n]:\n    toignore = [re_compile(s) for s in toignore]\n\n    # For none empty list, we want also to ignore\n    # the dunder methods.\n    if toignore:\n        toignore.append(PATTERN_UNDERSCORE)\n\n    print(f"{toignore = }")\n\n    print("shortdir(1, toignore) =")\n    pprint(shortdir(1, toignore))\n    print()\n~~~\n\nLaunched in a terminal, this code produces the following output (the printings have been formatted, and truncated a little by hand to ease the reading).\n\n~~~python\nshortdir(1) = # Dunder methods ignored by default.\n[\'as_integer_ratio\',\n \'bit_length\',\n \'conjugate\',\n \'denominator\',\n \'from_bytes\',\n \'imag\',\n \'numerator\',\n \'real\',\n \'to_bytes\']\n\ntoignore = [] # To keep all the dunder methods.\nshortdir(1, toignore) =\n[\'__abs__\',\n \'__add__\',\n \'__and__\',\n ..., #  Some other dunder methods.\n \'as_integer_ratio\',\n \'bit_length\',\n \'conjugate\',\n \'denominator\',\n \'from_bytes\',\n \'imag\',\n \'numerator\',\n \'real\',\n \'to_bytes\']\n\ntoignore = [\n    re.compile(\'imag\'),\n    re.compile(\'real\'),\n    re.compile(\'_.*\')\n]\nshortdir(1, toignore) =\n[\'as_integer_ratio\',\n \'bit_length\',\n \'conjugate\',\n \'denominator\',\n \'from_bytes\',\n \'numerator\',\n \'to_bytes\']\n\ntoignore = [\n    re.compile(\'as_.+\'),\n    re.compile(\'from_.+\'),\n    re.compile(\'_.*\')\n]\nshortdir(1, toignore) =\n[\'bit_length\',\n \'conjugate\',\n \'denominator\',\n \'imag\',\n \'numerator\',\n \'real\',\n \'to_bytes\']\n~~~\n\n\n### Signature of a callable object\n\nTo produce good quality code, it is very important to know the signature of a function, or a method. The purpose of the fucntion `.easysign`is to give an eays-to-use dictionary giving all the informations about a signature.\n\nLet\'s start with the code above where we use `pprint` to obtain well formatted output.\n\n~~~python\nfrom pprint              import pprint\nfrom cbdevtools.easysign import easysign\n\ndef funcOK(a:int, b: int = 1) -> str:\n    ...\n\npprint(easysign(funcOK))\n~~~\n\nLaunched in a terminal, we obtain the output below showing that the dictionary returned is very easy to use.\n\n~~~\n{\'optional\': [\'b\'],\n \'params\': {\'a\': {\'default\': None, \'typing\': \'int\'},\n            \'b\': {\'default\': \'1\', \'typing\': \'int\'}},\n \'return\': \'str\'}\n~~~\n\n***WARNING!*** *When nothing has been indicated in the original code, the value `None` is used.*\n\n\nThe signature of a method is also easy to obtain as it is done in the following code.\n\n~~~python\nclass Test:\n    def nothing(self):\n        ...\n    def noparam(self) -> str:\n        ...\n    def partialsign(self, a: str, b):\n        ...\n    def paramOK(self, a, b: bool = True) -> str:\n        ...\n\nmytest = Test()\n\nfor name in [\n    "nothing",\n    "noparam",\n    "partialsign",\n    "paramOK",\n]:\n    print(f"easysign(mytest.{name})")\n    pprint(\n        easysign(\n            mytest.__getattribute__(name)\n        )\n    )\n    print()\n~~~\n\nHere is the corresponding output.\n\n~~~\neasysign(mytest.nothing)\n{\'optional\': [], \'params\': {}, \'return\': None}\n\neasysign(mytest.noparam)\n{\'optional\': [], \'params\': {}, \'return\': \'str\'}\n\neasysign(mytest.partialsign)\n{\'optional\': [],\n \'params\': {\'a\': {\'default\': None, \'typing\': \'str\'},\n            \'b\': {\'default\': None, \'typing\': None}},\n \'return\': None}\n\neasysign(mytest.paramOK)\n{\'optional\': [\'b\'],\n \'params\': {\'a\': {\'default\': None, \'typing\': None},\n            \'b\': {\'default\': \'True\', \'typing\': \'bool\'}},\n \'return\': \'str\'}\n~~~\n\n\nTo end this section, you have to know that using `easysign(1)` will raise the following error.\n\n~~~\n[...]\nTypeError: 1 is not a callable object\n~~~\n\n\n### Using `orpyste` datas with `pytest`\n\n\nThe author of this package uses [orpyste](https://github.com/bc-python-OLD-IT-WILL-BE-REMOVED/orpyste) to work with ready-to-make `PEUF` data files in his tests.\n\nTo avoid problem with `pytest`, a fixture `peuf_fixture` is proposed wich follows the convention that the name of the `PEUF` file is obtained by removing the prefix `test_` from the name of the testing file Here is a real example of use with the following partial tree structure.\n\n~~~\n+ TeXitEasy\n    + src\n        * __init__.py\n        * escape.py\n    + tests\n        + escape\n            + fstringit.peuf\n            + test_fstringit.py\n\n~~~\n\n\nThe `Python` testing file `test_fstringit.py` is associated to the `PEUF` file `fstringit.peuf` where the prefix\n`test_` has been removed. Using the datas stored in this `PEUF` file becomes very easy: here is the code used where\n`tests` is an intuitive dictionary version of the `PEUF` file.\n\n~~~python\nfrom cbdevtools import *\n\naddfindsrc(\n    file    = __file__,\n    project = \'TeXitEasy\',\n)\n\nfrom src.escape import fstringit\n\ndef test_latex_use_fstringit(peuf_fixture):\n    tests = peuf_fixture(__file__)\n\n    for infos in tests.values():\n        found  = fstringit(infos[\'source\'])\n        wanted = infos[\'fstring\']\n\n        assert wanted == found\n~~~',
    'author': 'Christophe BAL',
    'author_email': None,
    'maintainer': 'Christophe BAL',
    'maintainer_email': None,
    'url': 'https://github.com/projetmbc/tools-for-dev/tree/master/cbdevtools',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
