"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.NeptuneMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class NeptuneMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static freeLocalStorageMinimum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'FreeLocalStorage',
            dimensionsMap: dimensions,
            statistic: 'Minimum',
        };
    }
    static freeableMemoryMinimum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'FreeableMemory',
            dimensionsMap: dimensions,
            statistic: 'Minimum',
        };
    }
    static gremlinErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static gremlinRequestsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinRequests',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static gremlinRequestsPerSecAverage(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'GremlinRequestsPerSec',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static http413Sum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'Http413',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static http500Sum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'Http500',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static loaderRequestsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'LoaderRequests',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static networkReceiveThroughputSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'NetworkReceiveThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static sparqlErrorsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'SparqlErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static sparqlRequestsPerSecSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'SparqlRequestsPerSec',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static volumeBytesUsedSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeBytesUsed',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static volumeReadIoPsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeReadIOPs',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static volumeWriteIoPsSum(dimensions) {
        return {
            namespace: 'AWS/Neptune',
            metricName: 'VolumeWriteIOPs',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.NeptuneMetrics = NeptuneMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVwdHVuZS1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJuZXB0dW5lLWNhbm5lZC1tZXRyaWNzLmdlbmVyYXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsK0VBQStFOzs7QUFFL0UsNEJBQTRCLENBQUMsaUVBQWlFO0FBRTlGLE1BQWEsY0FBYztJQUNsQixNQUFNLENBQUMscUJBQXFCLENBQUMsVUFBMkM7UUFDN0UsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxnQkFBZ0I7WUFDNUIsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLHVCQUF1QixDQUFDLFVBQTJDO1FBQy9FLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxVQUEyQztRQUM3RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsVUFBMkM7UUFDeEUsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxlQUFlO1lBQzNCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxVQUEyQztRQUMxRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsNEJBQTRCLENBQUMsVUFBMkM7UUFDcEYsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSx1QkFBdUI7WUFDbkMsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLFVBQVUsQ0FBQyxVQUEyQztRQUNsRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLFNBQVM7WUFDckIsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLFVBQVUsQ0FBQyxVQUEyQztRQUNsRSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLFNBQVM7WUFDckIsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLGlCQUFpQixDQUFDLFVBQTJDO1FBQ3pFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsZ0JBQWdCO1lBQzVCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQywyQkFBMkIsQ0FBQyxVQUEyQztRQUNuRixPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLDBCQUEwQjtZQUN0QyxhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsZUFBZSxDQUFDLFVBQTJDO1FBQ3ZFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsY0FBYztZQUMxQixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsdUJBQXVCLENBQUMsVUFBMkM7UUFDL0UsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxzQkFBc0I7WUFDbEMsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0lBQ00sTUFBTSxDQUFDLGtCQUFrQixDQUFDLFVBQTJDO1FBQzFFLE9BQU87WUFDTCxTQUFTLEVBQUUsYUFBYTtZQUN4QixVQUFVLEVBQUUsaUJBQWlCO1lBQzdCLGFBQWEsRUFBRSxVQUFVO1lBQ3pCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUM7S0FDSDtJQUNNLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxVQUEyQztRQUN6RSxPQUFPO1lBQ0wsU0FBUyxFQUFFLGFBQWE7WUFDeEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUUsVUFBVTtZQUN6QixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO0tBQ0g7SUFDTSxNQUFNLENBQUMsa0JBQWtCLENBQUMsVUFBMkM7UUFDMUUsT0FBTztZQUNMLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxpQkFBaUI7WUFDN0IsYUFBYSxFQUFFLFVBQVU7WUFDekIsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQztLQUNIO0NBQ0Y7QUF6SEQsd0NBeUhDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTItMjAyMiBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmV4cG9ydCBjbGFzcyBOZXB0dW5lTWV0cmljcyB7XG4gIHB1YmxpYyBzdGF0aWMgY3B1VXRpbGl6YXRpb25BdmVyYWdlKGRpbWVuc2lvbnM6IHsgREJDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL05lcHR1bmUnLFxuICAgICAgbWV0cmljTmFtZTogJ0NQVVV0aWxpemF0aW9uJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgZnJlZUxvY2FsU3RvcmFnZU1pbmltdW0oZGltZW5zaW9uczogeyBEQkNsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvTmVwdHVuZScsXG4gICAgICBtZXRyaWNOYW1lOiAnRnJlZUxvY2FsU3RvcmFnZScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnTWluaW11bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGZyZWVhYmxlTWVtb3J5TWluaW11bShkaW1lbnNpb25zOiB7IERCQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9OZXB0dW5lJyxcbiAgICAgIG1ldHJpY05hbWU6ICdGcmVlYWJsZU1lbW9yeScsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnTWluaW11bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGdyZW1saW5FcnJvcnNTdW0oZGltZW5zaW9uczogeyBEQkNsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvTmVwdHVuZScsXG4gICAgICBtZXRyaWNOYW1lOiAnR3JlbWxpbkVycm9ycycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgZ3JlbWxpblJlcXVlc3RzU3VtKGRpbWVuc2lvbnM6IHsgREJDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL05lcHR1bmUnLFxuICAgICAgbWV0cmljTmFtZTogJ0dyZW1saW5SZXF1ZXN0cycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgZ3JlbWxpblJlcXVlc3RzUGVyU2VjQXZlcmFnZShkaW1lbnNpb25zOiB7IERCQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9OZXB0dW5lJyxcbiAgICAgIG1ldHJpY05hbWU6ICdHcmVtbGluUmVxdWVzdHNQZXJTZWMnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyBodHRwNDEzU3VtKGRpbWVuc2lvbnM6IHsgREJDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL05lcHR1bmUnLFxuICAgICAgbWV0cmljTmFtZTogJ0h0dHA0MTMnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIGh0dHA1MDBTdW0oZGltZW5zaW9uczogeyBEQkNsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvTmVwdHVuZScsXG4gICAgICBtZXRyaWNOYW1lOiAnSHR0cDUwMCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgbG9hZGVyUmVxdWVzdHNTdW0oZGltZW5zaW9uczogeyBEQkNsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvTmVwdHVuZScsXG4gICAgICBtZXRyaWNOYW1lOiAnTG9hZGVyUmVxdWVzdHMnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIG5ldHdvcmtSZWNlaXZlVGhyb3VnaHB1dFN1bShkaW1lbnNpb25zOiB7IERCQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9OZXB0dW5lJyxcbiAgICAgIG1ldHJpY05hbWU6ICdOZXR3b3JrUmVjZWl2ZVRocm91Z2hwdXQnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHNwYXJxbEVycm9yc1N1bShkaW1lbnNpb25zOiB7IERCQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9OZXB0dW5lJyxcbiAgICAgIG1ldHJpY05hbWU6ICdTcGFycWxFcnJvcnMnLFxuICAgICAgZGltZW5zaW9uc01hcDogZGltZW5zaW9ucyxcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgfTtcbiAgfVxuICBwdWJsaWMgc3RhdGljIHNwYXJxbFJlcXVlc3RzUGVyU2VjU3VtKGRpbWVuc2lvbnM6IHsgREJDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL05lcHR1bmUnLFxuICAgICAgbWV0cmljTmFtZTogJ1NwYXJxbFJlcXVlc3RzUGVyU2VjJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyB2b2x1bWVCeXRlc1VzZWRTdW0oZGltZW5zaW9uczogeyBEQkNsdXN0ZXJJZGVudGlmaWVyOiBzdHJpbmcgfSkge1xuICAgIHJldHVybiB7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvTmVwdHVuZScsXG4gICAgICBtZXRyaWNOYW1lOiAnVm9sdW1lQnl0ZXNVc2VkJyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IGRpbWVuc2lvbnMsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgIH07XG4gIH1cbiAgcHVibGljIHN0YXRpYyB2b2x1bWVSZWFkSW9Qc1N1bShkaW1lbnNpb25zOiB7IERCQ2x1c3RlcklkZW50aWZpZXI6IHN0cmluZyB9KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9OZXB0dW5lJyxcbiAgICAgIG1ldHJpY05hbWU6ICdWb2x1bWVSZWFkSU9QcycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG4gIHB1YmxpYyBzdGF0aWMgdm9sdW1lV3JpdGVJb1BzU3VtKGRpbWVuc2lvbnM6IHsgREJDbHVzdGVySWRlbnRpZmllcjogc3RyaW5nIH0pIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL05lcHR1bmUnLFxuICAgICAgbWV0cmljTmFtZTogJ1ZvbHVtZVdyaXRlSU9QcycsXG4gICAgICBkaW1lbnNpb25zTWFwOiBkaW1lbnNpb25zLFxuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICB9O1xuICB9XG59XG4iXX0=