from typing import Type, TypedDict

from .payloads import (
    AvrApriltagsFpsPayload,
    _AvrApriltagsFpsCallable,
    AvrApriltagsRawPayload,
    _AvrApriltagsRawCallable,
    AvrApriltagsSelectedPayload,
    _AvrApriltagsSelectedCallable,
    AvrApriltagsVisiblePayload,
    _AvrApriltagsVisibleCallable,
    AvrAutonomousBuildingDropPayload,
    _AvrAutonomousBuildingDropCallable,
    AvrAutonomousEnablePayload,
    _AvrAutonomousEnableCallable,
    AvrFcmAttitudeEulerPayload,
    _AvrFcmAttitudeEulerCallable,
    AvrFcmBatteryPayload,
    _AvrFcmBatteryCallable,
    AvrFcmEventsPayload,
    _AvrFcmEventsCallable,
    AvrFcmGpsInfoPayload,
    _AvrFcmGpsInfoCallable,
    AvrFcmHilGpsStatsPayload,
    _AvrFcmHilGpsStatsCallable,
    AvrFcmLocationGlobalPayload,
    _AvrFcmLocationGlobalCallable,
    AvrFcmLocationHomePayload,
    _AvrFcmLocationHomeCallable,
    AvrFcmLocationLocalPayload,
    _AvrFcmLocationLocalCallable,
    AvrFcmStatusPayload,
    _AvrFcmStatusCallable,
    AvrFcmVelocityPayload,
    _AvrFcmVelocityCallable,
    AvrFusionAttitudeEulerPayload,
    _AvrFusionAttitudeEulerCallable,
    AvrFusionAttitudeHeadingPayload,
    _AvrFusionAttitudeHeadingCallable,
    AvrFusionAttitudeQuatPayload,
    _AvrFusionAttitudeQuatCallable,
    AvrFusionClimbratePayload,
    _AvrFusionClimbrateCallable,
    AvrFusionCoursePayload,
    _AvrFusionCourseCallable,
    AvrFusionGeoPayload,
    _AvrFusionGeoCallable,
    AvrFusionGroundspeedPayload,
    _AvrFusionGroundspeedCallable,
    AvrFusionHilGpsPayload,
    _AvrFusionHilGpsCallable,
    AvrFusionPositionNedPayload,
    _AvrFusionPositionNedCallable,
    AvrFusionVelocityNedPayload,
    _AvrFusionVelocityNedCallable,
    AvrPcmFireLaserPayload,
    _AvrPcmFireLaserCallable,
    AvrPcmSetBaseColorPayload,
    _AvrPcmSetBaseColorCallable,
    AvrPcmSetLaserOffPayload,
    _AvrPcmSetLaserOffCallable,
    AvrPcmSetLaserOnPayload,
    _AvrPcmSetLaserOnCallable,
    AvrPcmSetServoAbsPayload,
    _AvrPcmSetServoAbsCallable,
    AvrPcmSetServoMaxPayload,
    _AvrPcmSetServoMaxCallable,
    AvrPcmSetServoMinPayload,
    _AvrPcmSetServoMinCallable,
    AvrPcmSetServoOpenClosePayload,
    _AvrPcmSetServoOpenCloseCallable,
    AvrPcmSetServoPctPayload,
    _AvrPcmSetServoPctCallable,
    AvrPcmSetTempColorPayload,
    _AvrPcmSetTempColorCallable,
    AvrStatusLightApriltagsPayload,
    _AvrStatusLightApriltagsCallable,
    AvrStatusLightFcmPayload,
    _AvrStatusLightFcmCallable,
    AvrStatusLightPcmPayload,
    _AvrStatusLightPcmCallable,
    AvrStatusLightThermalPayload,
    _AvrStatusLightThermalCallable,
    AvrStatusLightVioPayload,
    _AvrStatusLightVioCallable,
    AvrThermalReadingPayload,
    _AvrThermalReadingCallable,
    AvrVioConfidencePayload,
    _AvrVioConfidenceCallable,
    AvrVioHeadingPayload,
    _AvrVioHeadingCallable,
    AvrVioOrientationEulPayload,
    _AvrVioOrientationEulCallable,
    AvrVioOrientationQuatPayload,
    _AvrVioOrientationQuatCallable,
    AvrVioPositionNedPayload,
    _AvrVioPositionNedCallable,
    AvrVioResyncPayload,
    _AvrVioResyncCallable,
    AvrVioVelocityNedPayload,
    _AvrVioVelocityNedCallable,
)


# List of MQTT topics
MQTTTopics = [
    "avr/apriltags/fps",
    "avr/apriltags/raw",
    "avr/apriltags/selected",
    "avr/apriltags/visible",
    "avr/autonomous/building/drop",
    "avr/autonomous/enable",
    "avr/fcm/attitude/euler",
    "avr/fcm/battery",
    "avr/fcm/events",
    "avr/fcm/gps_info",
    "avr/fcm/hil_gps_stats",
    "avr/fcm/location/global",
    "avr/fcm/location/home",
    "avr/fcm/location/local",
    "avr/fcm/status",
    "avr/fcm/velocity",
    "avr/fusion/attitude/euler",
    "avr/fusion/attitude/heading",
    "avr/fusion/attitude/quat",
    "avr/fusion/climbrate",
    "avr/fusion/course",
    "avr/fusion/geo",
    "avr/fusion/groundspeed",
    "avr/fusion/hil_gps",
    "avr/fusion/position/ned",
    "avr/fusion/velocity/ned",
    "avr/pcm/fire_laser",
    "avr/pcm/set_base_color",
    "avr/pcm/set_laser_off",
    "avr/pcm/set_laser_on",
    "avr/pcm/set_servo_abs",
    "avr/pcm/set_servo_max",
    "avr/pcm/set_servo_min",
    "avr/pcm/set_servo_open_close",
    "avr/pcm/set_servo_pct",
    "avr/pcm/set_temp_color",
    "avr/status/light/apriltags",
    "avr/status/light/fcm",
    "avr/status/light/pcm",
    "avr/status/light/thermal",
    "avr/status/light/vio",
    "avr/thermal/reading",
    "avr/vio/confidence",
    "avr/vio/heading",
    "avr/vio/orientation/eul",
    "avr/vio/orientation/quat",
    "avr/vio/position/ned",
    "avr/vio/resync",
    "avr/vio/velocity/ned",
]

# List of MQTT payload types
MQTTPayloads = [
    AvrApriltagsFpsPayload,
    AvrApriltagsRawPayload,
    AvrApriltagsSelectedPayload,
    AvrApriltagsVisiblePayload,
    AvrAutonomousBuildingDropPayload,
    AvrAutonomousEnablePayload,
    AvrFcmAttitudeEulerPayload,
    AvrFcmBatteryPayload,
    AvrFcmEventsPayload,
    AvrFcmGpsInfoPayload,
    AvrFcmHilGpsStatsPayload,
    AvrFcmLocationGlobalPayload,
    AvrFcmLocationHomePayload,
    AvrFcmLocationLocalPayload,
    AvrFcmStatusPayload,
    AvrFcmVelocityPayload,
    AvrFusionAttitudeEulerPayload,
    AvrFusionAttitudeHeadingPayload,
    AvrFusionAttitudeQuatPayload,
    AvrFusionClimbratePayload,
    AvrFusionCoursePayload,
    AvrFusionGeoPayload,
    AvrFusionGroundspeedPayload,
    AvrFusionHilGpsPayload,
    AvrFusionPositionNedPayload,
    AvrFusionVelocityNedPayload,
    AvrPcmFireLaserPayload,
    AvrPcmSetBaseColorPayload,
    AvrPcmSetLaserOffPayload,
    AvrPcmSetLaserOnPayload,
    AvrPcmSetServoAbsPayload,
    AvrPcmSetServoMaxPayload,
    AvrPcmSetServoMinPayload,
    AvrPcmSetServoOpenClosePayload,
    AvrPcmSetServoPctPayload,
    AvrPcmSetTempColorPayload,
    AvrStatusLightApriltagsPayload,
    AvrStatusLightFcmPayload,
    AvrStatusLightPcmPayload,
    AvrStatusLightThermalPayload,
    AvrStatusLightVioPayload,
    AvrThermalReadingPayload,
    AvrVioConfidencePayload,
    AvrVioHeadingPayload,
    AvrVioOrientationEulPayload,
    AvrVioOrientationQuatPayload,
    AvrVioPositionNedPayload,
    AvrVioResyncPayload,
    AvrVioVelocityNedPayload,
]

# TypedDict of topics to callback function signature
_MQTTTopicCallableTypedDict = TypedDict(
    "_MQTTTopicCallableTypedDict",
    {
        "avr/apriltags/fps": _AvrApriltagsFpsCallable,
        "avr/apriltags/raw": _AvrApriltagsRawCallable,
        "avr/apriltags/selected": _AvrApriltagsSelectedCallable,
        "avr/apriltags/visible": _AvrApriltagsVisibleCallable,
        "avr/autonomous/building/drop": _AvrAutonomousBuildingDropCallable,
        "avr/autonomous/enable": _AvrAutonomousEnableCallable,
        "avr/fcm/attitude/euler": _AvrFcmAttitudeEulerCallable,
        "avr/fcm/battery": _AvrFcmBatteryCallable,
        "avr/fcm/events": _AvrFcmEventsCallable,
        "avr/fcm/gps_info": _AvrFcmGpsInfoCallable,
        "avr/fcm/hil_gps_stats": _AvrFcmHilGpsStatsCallable,
        "avr/fcm/location/global": _AvrFcmLocationGlobalCallable,
        "avr/fcm/location/home": _AvrFcmLocationHomeCallable,
        "avr/fcm/location/local": _AvrFcmLocationLocalCallable,
        "avr/fcm/status": _AvrFcmStatusCallable,
        "avr/fcm/velocity": _AvrFcmVelocityCallable,
        "avr/fusion/attitude/euler": _AvrFusionAttitudeEulerCallable,
        "avr/fusion/attitude/heading": _AvrFusionAttitudeHeadingCallable,
        "avr/fusion/attitude/quat": _AvrFusionAttitudeQuatCallable,
        "avr/fusion/climbrate": _AvrFusionClimbrateCallable,
        "avr/fusion/course": _AvrFusionCourseCallable,
        "avr/fusion/geo": _AvrFusionGeoCallable,
        "avr/fusion/groundspeed": _AvrFusionGroundspeedCallable,
        "avr/fusion/hil_gps": _AvrFusionHilGpsCallable,
        "avr/fusion/position/ned": _AvrFusionPositionNedCallable,
        "avr/fusion/velocity/ned": _AvrFusionVelocityNedCallable,
        "avr/pcm/fire_laser": _AvrPcmFireLaserCallable,
        "avr/pcm/set_base_color": _AvrPcmSetBaseColorCallable,
        "avr/pcm/set_laser_off": _AvrPcmSetLaserOffCallable,
        "avr/pcm/set_laser_on": _AvrPcmSetLaserOnCallable,
        "avr/pcm/set_servo_abs": _AvrPcmSetServoAbsCallable,
        "avr/pcm/set_servo_max": _AvrPcmSetServoMaxCallable,
        "avr/pcm/set_servo_min": _AvrPcmSetServoMinCallable,
        "avr/pcm/set_servo_open_close": _AvrPcmSetServoOpenCloseCallable,
        "avr/pcm/set_servo_pct": _AvrPcmSetServoPctCallable,
        "avr/pcm/set_temp_color": _AvrPcmSetTempColorCallable,
        "avr/status/light/apriltags": _AvrStatusLightApriltagsCallable,
        "avr/status/light/fcm": _AvrStatusLightFcmCallable,
        "avr/status/light/pcm": _AvrStatusLightPcmCallable,
        "avr/status/light/thermal": _AvrStatusLightThermalCallable,
        "avr/status/light/vio": _AvrStatusLightVioCallable,
        "avr/thermal/reading": _AvrThermalReadingCallable,
        "avr/vio/confidence": _AvrVioConfidenceCallable,
        "avr/vio/heading": _AvrVioHeadingCallable,
        "avr/vio/orientation/eul": _AvrVioOrientationEulCallable,
        "avr/vio/orientation/quat": _AvrVioOrientationQuatCallable,
        "avr/vio/position/ned": _AvrVioPositionNedCallable,
        "avr/vio/resync": _AvrVioResyncCallable,
        "avr/vio/velocity/ned": _AvrVioVelocityNedCallable,
    },
    total=False
)

# Actual dictionary of topics to callback function signature
MQTTTopicCallable: _MQTTTopicCallableTypedDict = {
    "avr/apriltags/fps": _AvrApriltagsFpsCallable,
    "avr/apriltags/raw": _AvrApriltagsRawCallable,
    "avr/apriltags/selected": _AvrApriltagsSelectedCallable,
    "avr/apriltags/visible": _AvrApriltagsVisibleCallable,
    "avr/autonomous/building/drop": _AvrAutonomousBuildingDropCallable,
    "avr/autonomous/enable": _AvrAutonomousEnableCallable,
    "avr/fcm/attitude/euler": _AvrFcmAttitudeEulerCallable,
    "avr/fcm/battery": _AvrFcmBatteryCallable,
    "avr/fcm/events": _AvrFcmEventsCallable,
    "avr/fcm/gps_info": _AvrFcmGpsInfoCallable,
    "avr/fcm/hil_gps_stats": _AvrFcmHilGpsStatsCallable,
    "avr/fcm/location/global": _AvrFcmLocationGlobalCallable,
    "avr/fcm/location/home": _AvrFcmLocationHomeCallable,
    "avr/fcm/location/local": _AvrFcmLocationLocalCallable,
    "avr/fcm/status": _AvrFcmStatusCallable,
    "avr/fcm/velocity": _AvrFcmVelocityCallable,
    "avr/fusion/attitude/euler": _AvrFusionAttitudeEulerCallable,
    "avr/fusion/attitude/heading": _AvrFusionAttitudeHeadingCallable,
    "avr/fusion/attitude/quat": _AvrFusionAttitudeQuatCallable,
    "avr/fusion/climbrate": _AvrFusionClimbrateCallable,
    "avr/fusion/course": _AvrFusionCourseCallable,
    "avr/fusion/geo": _AvrFusionGeoCallable,
    "avr/fusion/groundspeed": _AvrFusionGroundspeedCallable,
    "avr/fusion/hil_gps": _AvrFusionHilGpsCallable,
    "avr/fusion/position/ned": _AvrFusionPositionNedCallable,
    "avr/fusion/velocity/ned": _AvrFusionVelocityNedCallable,
    "avr/pcm/fire_laser": _AvrPcmFireLaserCallable,
    "avr/pcm/set_base_color": _AvrPcmSetBaseColorCallable,
    "avr/pcm/set_laser_off": _AvrPcmSetLaserOffCallable,
    "avr/pcm/set_laser_on": _AvrPcmSetLaserOnCallable,
    "avr/pcm/set_servo_abs": _AvrPcmSetServoAbsCallable,
    "avr/pcm/set_servo_max": _AvrPcmSetServoMaxCallable,
    "avr/pcm/set_servo_min": _AvrPcmSetServoMinCallable,
    "avr/pcm/set_servo_open_close": _AvrPcmSetServoOpenCloseCallable,
    "avr/pcm/set_servo_pct": _AvrPcmSetServoPctCallable,
    "avr/pcm/set_temp_color": _AvrPcmSetTempColorCallable,
    "avr/status/light/apriltags": _AvrStatusLightApriltagsCallable,
    "avr/status/light/fcm": _AvrStatusLightFcmCallable,
    "avr/status/light/pcm": _AvrStatusLightPcmCallable,
    "avr/status/light/thermal": _AvrStatusLightThermalCallable,
    "avr/status/light/vio": _AvrStatusLightVioCallable,
    "avr/thermal/reading": _AvrThermalReadingCallable,
    "avr/vio/confidence": _AvrVioConfidenceCallable,
    "avr/vio/heading": _AvrVioHeadingCallable,
    "avr/vio/orientation/eul": _AvrVioOrientationEulCallable,
    "avr/vio/orientation/quat": _AvrVioOrientationQuatCallable,
    "avr/vio/position/ned": _AvrVioPositionNedCallable,
    "avr/vio/resync": _AvrVioResyncCallable,
    "avr/vio/velocity/ned": _AvrVioVelocityNedCallable,
}


# TypedDict of topics to associated payloads
_MQTTTopicPayloadTypedDict = TypedDict(
    "_MQTTTopicPayloadTypedDict",
    {
        "avr/apriltags/fps": AvrApriltagsFpsPayload,
        "avr/apriltags/raw": AvrApriltagsRawPayload,
        "avr/apriltags/selected": AvrApriltagsSelectedPayload,
        "avr/apriltags/visible": AvrApriltagsVisiblePayload,
        "avr/autonomous/building/drop": AvrAutonomousBuildingDropPayload,
        "avr/autonomous/enable": AvrAutonomousEnablePayload,
        "avr/fcm/attitude/euler": AvrFcmAttitudeEulerPayload,
        "avr/fcm/battery": AvrFcmBatteryPayload,
        "avr/fcm/events": AvrFcmEventsPayload,
        "avr/fcm/gps_info": AvrFcmGpsInfoPayload,
        "avr/fcm/hil_gps_stats": AvrFcmHilGpsStatsPayload,
        "avr/fcm/location/global": AvrFcmLocationGlobalPayload,
        "avr/fcm/location/home": AvrFcmLocationHomePayload,
        "avr/fcm/location/local": AvrFcmLocationLocalPayload,
        "avr/fcm/status": AvrFcmStatusPayload,
        "avr/fcm/velocity": AvrFcmVelocityPayload,
        "avr/fusion/attitude/euler": AvrFusionAttitudeEulerPayload,
        "avr/fusion/attitude/heading": AvrFusionAttitudeHeadingPayload,
        "avr/fusion/attitude/quat": AvrFusionAttitudeQuatPayload,
        "avr/fusion/climbrate": AvrFusionClimbratePayload,
        "avr/fusion/course": AvrFusionCoursePayload,
        "avr/fusion/geo": AvrFusionGeoPayload,
        "avr/fusion/groundspeed": AvrFusionGroundspeedPayload,
        "avr/fusion/hil_gps": AvrFusionHilGpsPayload,
        "avr/fusion/position/ned": AvrFusionPositionNedPayload,
        "avr/fusion/velocity/ned": AvrFusionVelocityNedPayload,
        "avr/pcm/fire_laser": AvrPcmFireLaserPayload,
        "avr/pcm/set_base_color": AvrPcmSetBaseColorPayload,
        "avr/pcm/set_laser_off": AvrPcmSetLaserOffPayload,
        "avr/pcm/set_laser_on": AvrPcmSetLaserOnPayload,
        "avr/pcm/set_servo_abs": AvrPcmSetServoAbsPayload,
        "avr/pcm/set_servo_max": AvrPcmSetServoMaxPayload,
        "avr/pcm/set_servo_min": AvrPcmSetServoMinPayload,
        "avr/pcm/set_servo_open_close": AvrPcmSetServoOpenClosePayload,
        "avr/pcm/set_servo_pct": AvrPcmSetServoPctPayload,
        "avr/pcm/set_temp_color": AvrPcmSetTempColorPayload,
        "avr/status/light/apriltags": AvrStatusLightApriltagsPayload,
        "avr/status/light/fcm": AvrStatusLightFcmPayload,
        "avr/status/light/pcm": AvrStatusLightPcmPayload,
        "avr/status/light/thermal": AvrStatusLightThermalPayload,
        "avr/status/light/vio": AvrStatusLightVioPayload,
        "avr/thermal/reading": AvrThermalReadingPayload,
        "avr/vio/confidence": AvrVioConfidencePayload,
        "avr/vio/heading": AvrVioHeadingPayload,
        "avr/vio/orientation/eul": AvrVioOrientationEulPayload,
        "avr/vio/orientation/quat": AvrVioOrientationQuatPayload,
        "avr/vio/position/ned": AvrVioPositionNedPayload,
        "avr/vio/resync": AvrVioResyncPayload,
        "avr/vio/velocity/ned": AvrVioVelocityNedPayload,
    },
    total=False
)

# TypedDict of topics to associated payload types
_MQTTTopicPayloadTypeTypedDict = TypedDict(
    "_MQTTTopicPayloadTypeTypedDict",
    {
        "avr/apriltags/fps": Type[AvrApriltagsFpsPayload],
        "avr/apriltags/raw": Type[AvrApriltagsRawPayload],
        "avr/apriltags/selected": Type[AvrApriltagsSelectedPayload],
        "avr/apriltags/visible": Type[AvrApriltagsVisiblePayload],
        "avr/autonomous/building/drop": Type[AvrAutonomousBuildingDropPayload],
        "avr/autonomous/enable": Type[AvrAutonomousEnablePayload],
        "avr/fcm/attitude/euler": Type[AvrFcmAttitudeEulerPayload],
        "avr/fcm/battery": Type[AvrFcmBatteryPayload],
        "avr/fcm/events": Type[AvrFcmEventsPayload],
        "avr/fcm/gps_info": Type[AvrFcmGpsInfoPayload],
        "avr/fcm/hil_gps_stats": Type[AvrFcmHilGpsStatsPayload],
        "avr/fcm/location/global": Type[AvrFcmLocationGlobalPayload],
        "avr/fcm/location/home": Type[AvrFcmLocationHomePayload],
        "avr/fcm/location/local": Type[AvrFcmLocationLocalPayload],
        "avr/fcm/status": Type[AvrFcmStatusPayload],
        "avr/fcm/velocity": Type[AvrFcmVelocityPayload],
        "avr/fusion/attitude/euler": Type[AvrFusionAttitudeEulerPayload],
        "avr/fusion/attitude/heading": Type[AvrFusionAttitudeHeadingPayload],
        "avr/fusion/attitude/quat": Type[AvrFusionAttitudeQuatPayload],
        "avr/fusion/climbrate": Type[AvrFusionClimbratePayload],
        "avr/fusion/course": Type[AvrFusionCoursePayload],
        "avr/fusion/geo": Type[AvrFusionGeoPayload],
        "avr/fusion/groundspeed": Type[AvrFusionGroundspeedPayload],
        "avr/fusion/hil_gps": Type[AvrFusionHilGpsPayload],
        "avr/fusion/position/ned": Type[AvrFusionPositionNedPayload],
        "avr/fusion/velocity/ned": Type[AvrFusionVelocityNedPayload],
        "avr/pcm/fire_laser": Type[AvrPcmFireLaserPayload],
        "avr/pcm/set_base_color": Type[AvrPcmSetBaseColorPayload],
        "avr/pcm/set_laser_off": Type[AvrPcmSetLaserOffPayload],
        "avr/pcm/set_laser_on": Type[AvrPcmSetLaserOnPayload],
        "avr/pcm/set_servo_abs": Type[AvrPcmSetServoAbsPayload],
        "avr/pcm/set_servo_max": Type[AvrPcmSetServoMaxPayload],
        "avr/pcm/set_servo_min": Type[AvrPcmSetServoMinPayload],
        "avr/pcm/set_servo_open_close": Type[AvrPcmSetServoOpenClosePayload],
        "avr/pcm/set_servo_pct": Type[AvrPcmSetServoPctPayload],
        "avr/pcm/set_temp_color": Type[AvrPcmSetTempColorPayload],
        "avr/status/light/apriltags": Type[AvrStatusLightApriltagsPayload],
        "avr/status/light/fcm": Type[AvrStatusLightFcmPayload],
        "avr/status/light/pcm": Type[AvrStatusLightPcmPayload],
        "avr/status/light/thermal": Type[AvrStatusLightThermalPayload],
        "avr/status/light/vio": Type[AvrStatusLightVioPayload],
        "avr/thermal/reading": Type[AvrThermalReadingPayload],
        "avr/vio/confidence": Type[AvrVioConfidencePayload],
        "avr/vio/heading": Type[AvrVioHeadingPayload],
        "avr/vio/orientation/eul": Type[AvrVioOrientationEulPayload],
        "avr/vio/orientation/quat": Type[AvrVioOrientationQuatPayload],
        "avr/vio/position/ned": Type[AvrVioPositionNedPayload],
        "avr/vio/resync": Type[AvrVioResyncPayload],
        "avr/vio/velocity/ned": Type[AvrVioVelocityNedPayload],
    },
    total=False
)

# Actual dictionary of topics to associated payload types
MQTTTopicPayload: _MQTTTopicPayloadTypeTypedDict = {
    "avr/apriltags/fps": AvrApriltagsFpsPayload,
    "avr/apriltags/raw": AvrApriltagsRawPayload,
    "avr/apriltags/selected": AvrApriltagsSelectedPayload,
    "avr/apriltags/visible": AvrApriltagsVisiblePayload,
    "avr/autonomous/building/drop": AvrAutonomousBuildingDropPayload,
    "avr/autonomous/enable": AvrAutonomousEnablePayload,
    "avr/fcm/attitude/euler": AvrFcmAttitudeEulerPayload,
    "avr/fcm/battery": AvrFcmBatteryPayload,
    "avr/fcm/events": AvrFcmEventsPayload,
    "avr/fcm/gps_info": AvrFcmGpsInfoPayload,
    "avr/fcm/hil_gps_stats": AvrFcmHilGpsStatsPayload,
    "avr/fcm/location/global": AvrFcmLocationGlobalPayload,
    "avr/fcm/location/home": AvrFcmLocationHomePayload,
    "avr/fcm/location/local": AvrFcmLocationLocalPayload,
    "avr/fcm/status": AvrFcmStatusPayload,
    "avr/fcm/velocity": AvrFcmVelocityPayload,
    "avr/fusion/attitude/euler": AvrFusionAttitudeEulerPayload,
    "avr/fusion/attitude/heading": AvrFusionAttitudeHeadingPayload,
    "avr/fusion/attitude/quat": AvrFusionAttitudeQuatPayload,
    "avr/fusion/climbrate": AvrFusionClimbratePayload,
    "avr/fusion/course": AvrFusionCoursePayload,
    "avr/fusion/geo": AvrFusionGeoPayload,
    "avr/fusion/groundspeed": AvrFusionGroundspeedPayload,
    "avr/fusion/hil_gps": AvrFusionHilGpsPayload,
    "avr/fusion/position/ned": AvrFusionPositionNedPayload,
    "avr/fusion/velocity/ned": AvrFusionVelocityNedPayload,
    "avr/pcm/fire_laser": AvrPcmFireLaserPayload,
    "avr/pcm/set_base_color": AvrPcmSetBaseColorPayload,
    "avr/pcm/set_laser_off": AvrPcmSetLaserOffPayload,
    "avr/pcm/set_laser_on": AvrPcmSetLaserOnPayload,
    "avr/pcm/set_servo_abs": AvrPcmSetServoAbsPayload,
    "avr/pcm/set_servo_max": AvrPcmSetServoMaxPayload,
    "avr/pcm/set_servo_min": AvrPcmSetServoMinPayload,
    "avr/pcm/set_servo_open_close": AvrPcmSetServoOpenClosePayload,
    "avr/pcm/set_servo_pct": AvrPcmSetServoPctPayload,
    "avr/pcm/set_temp_color": AvrPcmSetTempColorPayload,
    "avr/status/light/apriltags": AvrStatusLightApriltagsPayload,
    "avr/status/light/fcm": AvrStatusLightFcmPayload,
    "avr/status/light/pcm": AvrStatusLightPcmPayload,
    "avr/status/light/thermal": AvrStatusLightThermalPayload,
    "avr/status/light/vio": AvrStatusLightVioPayload,
    "avr/thermal/reading": AvrThermalReadingPayload,
    "avr/vio/confidence": AvrVioConfidencePayload,
    "avr/vio/heading": AvrVioHeadingPayload,
    "avr/vio/orientation/eul": AvrVioOrientationEulPayload,
    "avr/vio/orientation/quat": AvrVioOrientationQuatPayload,
    "avr/vio/position/ned": AvrVioPositionNedPayload,
    "avr/vio/resync": AvrVioResyncPayload,
    "avr/vio/velocity/ned": AvrVioVelocityNedPayload,
}