# Generated by Django 3.1.8 on 2021-06-04 00:25


from django.db import migrations


def create_user_input_types(apps, schema_editor):
    """
    Initialize the database with the WorkflowStepUserInputType that we have schemas available for.
    """
    WorkflowStepUserInputType = apps.get_model(
        "django_workflow_system", "WorkflowStepUserInputType"
    )

    # True/False Question
    WorkflowStepUserInputType.objects.get_or_create(
        name="true_false_question",
        json_schema={
            "$schema": "http://json-schema.org/draft-07/schema",
            "$id": "http://github.com/crcresearch/",
            "type": "object",
            "title": "User Input: True/False Question",
            "description": "A schema representing a true/false question user input.",
            "required": ["label", "inputOptions", "meta"],
            "properties": {
                "id": {
                    "type": "string",
                    "title": "A user input identifier.",
                    "description": "This value may be managed outside of the object specification and so is optional.",
                    "examples": ["4125-1351-1251-asfd"],
                },
                "label": {
                    "type": "string",
                    "title": "UI Label for Input",
                    "description": "Label that should be displayed by user interfaces for this input.",
                    "examples": ["The label to display for the input/question."],
                },
                "inputOptions": {
                    "type": "array",
                    "title": "Question Options",
                    "description": "The options to be displayed to the user for this question.",
                    "minItems": 2,
                    "maxItems": 2,
                    "uniqueItems": True,
                    "items": {"type": "boolean"},
                },
                "correctInput": {
                    "description": "Indicates which answer is the correct one.",
                    "type": "boolean",
                },
                "meta": {
                    "type": "object",
                    "required": ["inputRequired", "correctInputRequired"],
                    "properties": {
                        "inputRequired": {
                            "type": "boolean",
                            "description": "Whether or not an answer should be required from the user.",
                        },
                        "correctInputRequired": {
                            "type": "boolean",
                            "description": "Whether or not the correct answer should be required from the user.",
                        },
                    },
                },
            },
        },
        example_specification={
            "label": "Is the sky blue?",
            "inputOptions": [True, False],
            "correctInput": True,
            "meta": {"inputRequired": True, "correctInputRequired": True},
        },
    )

    # Free Form Question
    WorkflowStepUserInputType.objects.get_or_create(
        name="free_form_question",
        json_schema={
            "$schema": "http://json-schema.org/draft-07/schema",
            "type": "object",
            "title": "User Input: Freeform Question",
            "description": "A schema representing a free form question user input.",
            "required": ["label", "meta"],
            "properties": {
                "id": {
                    "type": "string",
                    "title": "A user input identifier.",
                    "description": "This value may be managed outside of the object specification and so is optional.",
                    "examples": ["4125-1351-1251-asfd"],
                },
                "label": {
                    "type": "string",
                    "title": "UI Label for Input",
                    "description": "Label that should be displayed by user interfaces for this input.",
                    "examples": ["The label to display for the input/question."],
                },
                "meta": {
                    "type": "object",
                    "required": ["inputRequired", "correctInputRequired"],
                    "properties": {
                        "inputRequired": {
                            "type": "boolean",
                            "description": "Whether or not an answer should be required from the user.",
                        },
                        "correctInputRequired": {
                            "type": "boolean",
                            "description": "Whether or not the correct answer should be required from the user.",
                            "const": False,
                        },
                    },
                },
            },
        },
        example_specification={
            "label": "What was the most interesting part of your day?",
            "meta": {"inputRequired": True, "correctInputRequired": False},
        },
    )


class Migration(migrations.Migration):

    dependencies = [
        ("django_workflow_system", "0006_auto_20210723_1204"),
    ]

    operations = [
        migrations.RunPython(create_user_input_types),
    ]
