# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AclEntryResponse',
    'BackupConfigurationResponse',
    'BackupRetentionSettingsResponse',
    'DatabaseFlagsResponse',
    'DenyMaintenancePeriodResponse',
    'DiskEncryptionConfigurationResponse',
    'DiskEncryptionStatusResponse',
    'InsightsConfigResponse',
    'InstanceFailoverReplicaResponse',
    'InstanceReferenceResponse',
    'IpConfigurationResponse',
    'IpMappingResponse',
    'LocationPreferenceResponse',
    'MaintenanceWindowResponse',
    'MySqlReplicaConfigurationResponse',
    'OnPremisesConfigurationResponse',
    'OperationErrorResponse',
    'PasswordStatusResponse',
    'PasswordValidationPolicyResponse',
    'ReplicaConfigurationResponse',
    'SettingsResponse',
    'SqlActiveDirectoryConfigResponse',
    'SqlOutOfDiskReportResponse',
    'SqlScheduledMaintenanceResponse',
    'SqlServerAuditConfigResponse',
    'SqlServerDatabaseDetailsResponse',
    'SqlServerUserDetailsResponse',
    'SslCertResponse',
    'UserPasswordValidationPolicyResponse',
]

@pulumi.output_type
class AclEntryResponse(dict):
    """
    An entry for an Access Control list.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_time: str,
                 kind: str,
                 name: str,
                 value: str):
        """
        An entry for an Access Control list.
        :param str expiration_time: The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param str kind: This is always `sql#aclEntry`.
        :param str name: Optional. A label to identify this entry.
        :param str value: The allowlisted value for the access control list.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#aclEntry`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. A label to identify this entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BackupConfigurationResponse(dict):
    """
    Database instance backup configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionSettings":
            suggest = "backup_retention_settings"
        elif key == "binaryLogEnabled":
            suggest = "binary_log_enabled"
        elif key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"
        elif key == "replicationLogArchivingEnabled":
            suggest = "replication_log_archiving_enabled"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transactionLogRetentionDays":
            suggest = "transaction_log_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_settings: 'outputs.BackupRetentionSettingsResponse',
                 binary_log_enabled: bool,
                 enabled: bool,
                 kind: str,
                 location: str,
                 point_in_time_recovery_enabled: bool,
                 replication_log_archiving_enabled: bool,
                 start_time: str,
                 transaction_log_retention_days: int):
        """
        Database instance backup configuration.
        :param 'BackupRetentionSettingsResponse' backup_retention_settings: Backup retention settings.
        :param bool binary_log_enabled: (MySQL only) Whether binary log is enabled. If backup configuration is disabled, binarylog must be disabled as well.
        :param bool enabled: Whether this configuration is enabled.
        :param str kind: This is always `sql#backupConfiguration`.
        :param str location: Location of the backup
        :param bool point_in_time_recovery_enabled: (Postgres only) Whether point in time recovery is enabled.
        :param bool replication_log_archiving_enabled: Reserved for future use.
        :param str start_time: Start time for the daily backup configuration in UTC timezone in the 24 hour format - `HH:MM`.
        :param int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "replication_log_archiving_enabled", replication_log_archiving_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> 'outputs.BackupRetentionSettingsResponse':
        """
        Backup retention settings.
        """
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> bool:
        """
        (MySQL only) Whether binary log is enabled. If backup configuration is disabled, binarylog must be disabled as well.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether this configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#backupConfiguration`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Location of the backup
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> bool:
        """
        (Postgres only) Whether point in time recovery is enabled.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="replicationLogArchivingEnabled")
    def replication_log_archiving_enabled(self) -> bool:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "replication_log_archiving_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time for the daily backup configuration in UTC timezone in the 24 hour format - `HH:MM`.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> int:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class BackupRetentionSettingsResponse(dict):
    """
    We currently only support backup retention by specifying the number of backups we will retain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainedBackups":
            suggest = "retained_backups"
        elif key == "retentionUnit":
            suggest = "retention_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupRetentionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupRetentionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupRetentionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: str):
        """
        We currently only support backup retention by specifying the number of backups we will retain.
        :param int retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit is 'COUNT', we will retain this many backups.
        :param str retention_unit: The unit that 'retained_backups' represents.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> str:
        """
        The unit that 'retained_backups' represents.
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class DatabaseFlagsResponse(dict):
    """
    Database flags for Cloud SQL instances.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Database flags for Cloud SQL instances.
        :param str name: The name of the flag. These flags are passed at instance startup, so include both server options and system variables. Flags are specified with underscores, not hyphens. For more information, see [Configuring Database Flags](https://cloud.google.com/sql/docs/mysql/flags) in the Cloud SQL documentation.
        :param str value: The value of the flag. Boolean flags are set to `on` for true and `off` for false. This field must be omitted if the flag doesn't take a value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the flag. These flags are passed at instance startup, so include both server options and system variables. Flags are specified with underscores, not hyphens. For more information, see [Configuring Database Flags](https://cloud.google.com/sql/docs/mysql/flags) in the Cloud SQL documentation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the flag. Boolean flags are set to `on` for true and `off` for false. This field must be omitted if the flag doesn't take a value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DenyMaintenancePeriodResponse(dict):
    """
    Deny maintenance Periods. This specifies a date range during when all CSA rollout will be denied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DenyMaintenancePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DenyMaintenancePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DenyMaintenancePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: str,
                 start_date: str,
                 time: str):
        """
        Deny maintenance Periods. This specifies a date range during when all CSA rollout will be denied.
        :param str end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param str start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param str time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the no maintenance interval recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class DiskEncryptionConfigurationResponse(dict):
    """
    Disk encryption configuration for an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 kms_key_name: str):
        """
        Disk encryption configuration for an instance.
        :param str kind: This is always `sql#diskEncryptionConfiguration`.
        :param str kms_key_name: Resource name of KMS key for disk encryption
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#diskEncryptionConfiguration`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Resource name of KMS key for disk encryption
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class DiskEncryptionStatusResponse(dict):
    """
    Disk encryption status for an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 kms_key_version_name: str):
        """
        Disk encryption status for an instance.
        :param str kind: This is always `sql#diskEncryptionStatus`.
        :param str kms_key_version_name: KMS key version used to encrypt the Cloud SQL instance resource
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#diskEncryptionStatus`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> str:
        """
        KMS key version used to encrypt the Cloud SQL instance resource
        """
        return pulumi.get(self, "kms_key_version_name")


@pulumi.output_type
class InsightsConfigResponse(dict):
    """
    Insights configuration. This specifies when Cloud SQL Insights feature is enabled and optional configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryInsightsEnabled":
            suggest = "query_insights_enabled"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_insights_enabled: bool,
                 query_plans_per_minute: int,
                 query_string_length: int,
                 record_application_tags: bool,
                 record_client_address: bool):
        """
        Insights configuration. This specifies when Cloud SQL Insights feature is enabled and optional configuration.
        :param bool query_insights_enabled: Whether Query Insights feature is enabled.
        :param int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. Default is 5.
        :param int query_string_length: Maximum query length stored in bytes. Default value: 1024 bytes. Range: 256-4500 bytes. Query length more than this field value will be truncated to this value. When unset, query length will be the default value. Changing query length will restart the database.
        :param bool record_application_tags: Whether Query Insights will record application tags from query when enabled.
        :param bool record_client_address: Whether Query Insights will record client address when enabled.
        """
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> bool:
        """
        Whether Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. Default is 5.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> int:
        """
        Maximum query length stored in bytes. Default value: 1024 bytes. Range: 256-4500 bytes. Query length more than this field value will be truncated to this value. When unset, query length will be the default value. Changing query length will restart the database.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> bool:
        """
        Whether Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> bool:
        """
        Whether Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class InstanceFailoverReplicaResponse(dict):
    """
    The name and status of the failover replica.
    """
    def __init__(__self__, *,
                 available: bool,
                 name: str):
        """
        The name and status of the failover replica.
        :param bool available: The availability status of the failover replica. A false status indicates that the failover replica is out of sync. The primary instance can only failover to the failover replica when the status is true.
        :param str name: The name of the failover replica. If specified at instance creation, a failover replica is created for the instance. The name doesn't include the project ID.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def available(self) -> bool:
        """
        The availability status of the failover replica. A false status indicates that the failover replica is out of sync. The primary instance can only failover to the failover replica when the status is true.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the failover replica. If specified at instance creation, a failover replica is created for the instance. The name doesn't include the project ID.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceReferenceResponse(dict):
    """
    Reference to another Cloud SQL instance.
    """
    def __init__(__self__, *,
                 name: str,
                 project: str,
                 region: str):
        """
        Reference to another Cloud SQL instance.
        :param str name: The name of the Cloud SQL instance being referenced. This does not include the project ID.
        :param str project: The project ID of the Cloud SQL instance being referenced. The default is the same project ID as the instance references it.
        :param str region: The region of the Cloud SQL instance being referenced.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud SQL instance being referenced. This does not include the project ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project ID of the Cloud SQL instance being referenced. The default is the same project ID as the instance references it.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the Cloud SQL instance being referenced.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class IpConfigurationResponse(dict):
    """
    IP Management configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "requireSsl":
            suggest = "require_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: str,
                 authorized_networks: Sequence['outputs.AclEntryResponse'],
                 ipv4_enabled: bool,
                 private_network: str,
                 require_ssl: bool):
        """
        IP Management configuration.
        :param str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?.`
        :param Sequence['AclEntryResponse'] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP. In 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).
        :param bool ipv4_enabled: Whether the instance is assigned a public IP address or not.
        :param str private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `/projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: Whether SSL connections over IP are enforced or not.
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?.`
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.AclEntryResponse']:
        """
        The list of external networks that are allowed to connect to the instance using the IP. In 'CIDR' notation, also known as 'slash' notation (for example: `157.197.200.0/24`).
        """
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> bool:
        """
        Whether the instance is assigned a public IP address or not.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `/projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class IpMappingResponse(dict):
    """
    Database instance IP Mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "timeToRetire":
            suggest = "time_to_retire"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str,
                 time_to_retire: str,
                 type: str):
        """
        Database instance IP Mapping.
        :param str ip_address: The IP address assigned.
        :param str time_to_retire: The due time for this IP to be retired in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`. This field is only available when the IP is scheduled to be retired.
        :param str type: The type of this IP address. A `PRIMARY` address is a public address that can accept incoming connections. A `PRIVATE` address is a private address that can accept incoming connections. An `OUTGOING` address is the source address of connections originating from the instance, if supported.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address assigned.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> str:
        """
        The due time for this IP to be retired in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`. This field is only available when the IP is scheduled to be retired.
        """
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this IP address. A `PRIMARY` address is a public address that can accept incoming connections. A `PRIVATE` address is a private address that can accept incoming connections. An `OUTGOING` address is the source address of connections originating from the instance, if supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LocationPreferenceResponse(dict):
    """
    Preferred location. This specifies where a Cloud SQL instance is located. Note that if the preferred location is not available, the instance will be located as close as possible within the region. Only one location may be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followGaeApplication":
            suggest = "follow_gae_application"
        elif key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationPreferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationPreferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationPreferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_gae_application: str,
                 kind: str,
                 secondary_zone: str,
                 zone: str):
        """
        Preferred location. This specifies where a Cloud SQL instance is located. Note that if the preferred location is not available, the instance will be located as close as possible within the region. Only one location may be specified.
        :param str follow_gae_application: The App Engine application to follow, it must be in the same region as the Cloud SQL instance. WARNING: Changing this might restart the instance.
        :param str kind: This is always `sql#locationPreference`.
        :param str secondary_zone: The preferred Compute Engine zone for the secondary/failover (for example: us-central1-a, us-central1-b, etc.).
        :param str zone: The preferred Compute Engine zone (for example: us-central1-a, us-central1-b, etc.). WARNING: Changing this might restart the instance.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> str:
        """
        The App Engine application to follow, it must be in the same region as the Cloud SQL instance. WARNING: Changing this might restart the instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#locationPreference`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> str:
        """
        The preferred Compute Engine zone for the secondary/failover (for example: us-central1-a, us-central1-b, etc.).
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The preferred Compute Engine zone (for example: us-central1-a, us-central1-b, etc.). WARNING: Changing this might restart the instance.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    Maintenance window. This specifies when a Cloud SQL instance is restarted for system maintenance purposes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTrack":
            suggest = "update_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: int,
                 hour: int,
                 kind: str,
                 update_track: str):
        """
        Maintenance window. This specifies when a Cloud SQL instance is restarted for system maintenance purposes.
        :param int day: day of week (1-7), starting on Monday.
        :param int hour: hour of day - 0 to 23.
        :param str kind: This is always `sql#maintenanceWindow`.
        :param str update_track: Maintenance timing setting: `canary` (Earlier) or `stable` (Later). [Learn more](https://cloud.google.com/sql/docs/mysql/instance-settings#maintenance-timing-2ndgen).
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        day of week (1-7), starting on Monday.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> int:
        """
        hour of day - 0 to 23.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#maintenanceWindow`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> str:
        """
        Maintenance timing setting: `canary` (Earlier) or `stable` (Later). [Learn more](https://cloud.google.com/sql/docs/mysql/instance-settings#maintenance-timing-2ndgen).
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class MySqlReplicaConfigurationResponse(dict):
    """
    Read-replica configuration specific to MySQL databases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "connectRetryInterval":
            suggest = "connect_retry_interval"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "masterHeartbeatPeriod":
            suggest = "master_heartbeat_period"
        elif key == "sslCipher":
            suggest = "ssl_cipher"
        elif key == "verifyServerCertificate":
            suggest = "verify_server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MySqlReplicaConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MySqlReplicaConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MySqlReplicaConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 connect_retry_interval: int,
                 dump_file_path: str,
                 kind: str,
                 master_heartbeat_period: str,
                 password: str,
                 ssl_cipher: str,
                 username: str,
                 verify_server_certificate: bool):
        """
        Read-replica configuration specific to MySQL databases.
        :param str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param str client_certificate: PEM representation of the replica's x509 certificate.
        :param str client_key: PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        :param int connect_retry_interval: Seconds to wait between connect retries. MySQL's default is 60 seconds.
        :param str dump_file_path: Path to a SQL dump file in Google Cloud Storage from which the replica instance is to be created. The URI is in the form gs://bucketName/fileName. Compressed gzip files (.gz) are also supported. Dumps have the binlog co-ordinates from which replication begins. This can be accomplished by setting --master-data to 1 when using mysqldump.
        :param str kind: This is always `sql#mysqlReplicaConfiguration`.
        :param str master_heartbeat_period: Interval in milliseconds between replication heartbeats.
        :param str password: The password for the replication connection.
        :param str ssl_cipher: A list of permissible ciphers to use for SSL encryption.
        :param str username: The username for the replication connection.
        :param bool verify_server_certificate: Whether or not to check the primary instance's Common Name value in the certificate that it sends during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> int:
        """
        Seconds to wait between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        """
        Path to a SQL dump file in Google Cloud Storage from which the replica instance is to be created. The URI is in the form gs://bucketName/fileName. Compressed gzip files (.gz) are also supported. Dumps have the binlog co-ordinates from which replication begins. This can be accomplished by setting --master-data to 1 when using mysqldump.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#mysqlReplicaConfiguration`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> str:
        """
        Interval in milliseconds between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> str:
        """
        A list of permissible ciphers to use for SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username for the replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> bool:
        """
        Whether or not to check the primary instance's Common Name value in the certificate that it sends during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class OnPremisesConfigurationResponse(dict):
    """
    On-premises instance configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "hostPort":
            suggest = "host_port"
        elif key == "sourceInstance":
            suggest = "source_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremisesConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremisesConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremisesConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 dump_file_path: str,
                 host_port: str,
                 kind: str,
                 password: str,
                 source_instance: 'outputs.InstanceReferenceResponse',
                 username: str):
        """
        On-premises instance configuration.
        :param str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param str client_certificate: PEM representation of the replica's x509 certificate.
        :param str client_key: PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        :param str dump_file_path: The dump file to create the Cloud SQL replica.
        :param str host_port: The host and port of the on-premises instance in host:port format
        :param str kind: This is always `sql#onPremisesConfiguration`.
        :param str password: The password for connecting to on-premises instance.
        :param 'InstanceReferenceResponse' source_instance: The reference to Cloud SQL instance if the source is Cloud SQL.
        :param str username: The username for connecting to on-premises instance.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "host_port", host_port)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "source_instance", source_instance)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        """
        The dump file to create the Cloud SQL replica.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> str:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#onPremisesConfiguration`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for connecting to on-premises instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sourceInstance")
    def source_instance(self) -> 'outputs.InstanceReferenceResponse':
        """
        The reference to Cloud SQL instance if the source is Cloud SQL.
        """
        return pulumi.get(self, "source_instance")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username for connecting to on-premises instance.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class OperationErrorResponse(dict):
    """
    Database instance operation error.
    """
    def __init__(__self__, *,
                 code: str,
                 kind: str,
                 message: str):
        """
        Database instance operation error.
        :param str code: Identifies the specific error that occurred.
        :param str kind: This is always `sql#operationError`.
        :param str message: Additional information about the error encountered.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Identifies the specific error that occurred.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#operationError`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Additional information about the error encountered.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class PasswordStatusResponse(dict):
    """
    Read-only password status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordExpirationTime":
            suggest = "password_expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PasswordStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PasswordStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PasswordStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locked: bool,
                 password_expiration_time: str):
        """
        Read-only password status.
        :param bool locked: If true, user does not have login privileges.
        :param str password_expiration_time: The expiration time of the current password.
        """
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "password_expiration_time", password_expiration_time)

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        If true, user does not have login privileges.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="passwordExpirationTime")
    def password_expiration_time(self) -> str:
        """
        The expiration time of the current password.
        """
        return pulumi.get(self, "password_expiration_time")


@pulumi.output_type
class PasswordValidationPolicyResponse(dict):
    """
    Database instance local user password validation policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disallowUsernameSubstring":
            suggest = "disallow_username_substring"
        elif key == "enablePasswordPolicy":
            suggest = "enable_password_policy"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "passwordChangeInterval":
            suggest = "password_change_interval"
        elif key == "reuseInterval":
            suggest = "reuse_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PasswordValidationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PasswordValidationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PasswordValidationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 complexity: str,
                 disallow_username_substring: bool,
                 enable_password_policy: bool,
                 min_length: int,
                 password_change_interval: str,
                 reuse_interval: int):
        """
        Database instance local user password validation policy
        :param str complexity: The complexity of the password.
        :param bool disallow_username_substring: Disallow username as a part of the password.
        :param bool enable_password_policy: Whether the password policy is enabled or not.
        :param int min_length: Minimum number of characters allowed.
        :param str password_change_interval: Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        :param int reuse_interval: Number of previous passwords that cannot be reused.
        """
        pulumi.set(__self__, "complexity", complexity)
        pulumi.set(__self__, "disallow_username_substring", disallow_username_substring)
        pulumi.set(__self__, "enable_password_policy", enable_password_policy)
        pulumi.set(__self__, "min_length", min_length)
        pulumi.set(__self__, "password_change_interval", password_change_interval)
        pulumi.set(__self__, "reuse_interval", reuse_interval)

    @property
    @pulumi.getter
    def complexity(self) -> str:
        """
        The complexity of the password.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="disallowUsernameSubstring")
    def disallow_username_substring(self) -> bool:
        """
        Disallow username as a part of the password.
        """
        return pulumi.get(self, "disallow_username_substring")

    @property
    @pulumi.getter(name="enablePasswordPolicy")
    def enable_password_policy(self) -> bool:
        """
        Whether the password policy is enabled or not.
        """
        return pulumi.get(self, "enable_password_policy")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> int:
        """
        Minimum number of characters allowed.
        """
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="passwordChangeInterval")
    def password_change_interval(self) -> str:
        """
        Minimum interval after which the password can be changed. This flag is only supported for PostgresSQL.
        """
        return pulumi.get(self, "password_change_interval")

    @property
    @pulumi.getter(name="reuseInterval")
    def reuse_interval(self) -> int:
        """
        Number of previous passwords that cannot be reused.
        """
        return pulumi.get(self, "reuse_interval")


@pulumi.output_type
class ReplicaConfigurationResponse(dict):
    """
    Read-replica configuration for connecting to the primary instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverTarget":
            suggest = "failover_target"
        elif key == "mysqlReplicaConfiguration":
            suggest = "mysql_replica_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_target: bool,
                 kind: str,
                 mysql_replica_configuration: 'outputs.MySqlReplicaConfigurationResponse'):
        """
        Read-replica configuration for connecting to the primary instance.
        :param bool failover_target: Specifies if the replica is the failover target. If the field is set to `true`, the replica will be designated as a failover replica. In case the primary instance fails, the replica instance will be promoted as the new primary instance. Only one replica can be specified as failover target, and the replica has to be in different zone with the primary instance.
        :param str kind: This is always `sql#replicaConfiguration`.
        :param 'MySqlReplicaConfigurationResponse' mysql_replica_configuration: MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named `master.info` in the data directory.
        """
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "mysql_replica_configuration", mysql_replica_configuration)

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> bool:
        """
        Specifies if the replica is the failover target. If the field is set to `true`, the replica will be designated as a failover replica. In case the primary instance fails, the replica instance will be promoted as the new primary instance. Only one replica can be specified as failover target, and the replica has to be in different zone with the primary instance.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#replicaConfiguration`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="mysqlReplicaConfiguration")
    def mysql_replica_configuration(self) -> 'outputs.MySqlReplicaConfigurationResponse':
        """
        MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named `master.info` in the data directory.
        """
        return pulumi.get(self, "mysql_replica_configuration")


@pulumi.output_type
class SettingsResponse(dict):
    """
    Database instance settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "activeDirectoryConfig":
            suggest = "active_directory_config"
        elif key == "authorizedGaeApplications":
            suggest = "authorized_gae_applications"
        elif key == "availabilityType":
            suggest = "availability_type"
        elif key == "backupConfiguration":
            suggest = "backup_configuration"
        elif key == "connectorEnforcement":
            suggest = "connector_enforcement"
        elif key == "crashSafeReplicationEnabled":
            suggest = "crash_safe_replication_enabled"
        elif key == "dataDiskSizeGb":
            suggest = "data_disk_size_gb"
        elif key == "dataDiskType":
            suggest = "data_disk_type"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "databaseReplicationEnabled":
            suggest = "database_replication_enabled"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "denyMaintenancePeriods":
            suggest = "deny_maintenance_periods"
        elif key == "insightsConfig":
            suggest = "insights_config"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "locationPreference":
            suggest = "location_preference"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "passwordValidationPolicy":
            suggest = "password_validation_policy"
        elif key == "pricingPlan":
            suggest = "pricing_plan"
        elif key == "replicationType":
            suggest = "replication_type"
        elif key == "settingsVersion":
            suggest = "settings_version"
        elif key == "sqlServerAuditConfig":
            suggest = "sql_server_audit_config"
        elif key == "storageAutoResize":
            suggest = "storage_auto_resize"
        elif key == "storageAutoResizeLimit":
            suggest = "storage_auto_resize_limit"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_policy: str,
                 active_directory_config: 'outputs.SqlActiveDirectoryConfigResponse',
                 authorized_gae_applications: Sequence[str],
                 availability_type: str,
                 backup_configuration: 'outputs.BackupConfigurationResponse',
                 collation: str,
                 connector_enforcement: str,
                 crash_safe_replication_enabled: bool,
                 data_disk_size_gb: str,
                 data_disk_type: str,
                 database_flags: Sequence['outputs.DatabaseFlagsResponse'],
                 database_replication_enabled: bool,
                 deletion_protection_enabled: bool,
                 deny_maintenance_periods: Sequence['outputs.DenyMaintenancePeriodResponse'],
                 insights_config: 'outputs.InsightsConfigResponse',
                 ip_configuration: 'outputs.IpConfigurationResponse',
                 kind: str,
                 location_preference: 'outputs.LocationPreferenceResponse',
                 maintenance_window: 'outputs.MaintenanceWindowResponse',
                 password_validation_policy: 'outputs.PasswordValidationPolicyResponse',
                 pricing_plan: str,
                 replication_type: str,
                 settings_version: str,
                 sql_server_audit_config: 'outputs.SqlServerAuditConfigResponse',
                 storage_auto_resize: bool,
                 storage_auto_resize_limit: str,
                 tier: str,
                 time_zone: str,
                 user_labels: Mapping[str, str]):
        """
        Database instance settings.
        :param str activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is RUNNABLE. Valid values: * `ALWAYS`: The instance is on, and remains so even in the absence of connection requests. * `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        :param 'SqlActiveDirectoryConfigResponse' active_directory_config: Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        :param Sequence[str] authorized_gae_applications: The App Engine app IDs that can access this instance. (Deprecated) Applied to First Generation instances only.
        :param str availability_type: Availability type. Potential values: * `ZONAL`: The instance serves data from only one zone. Outages in that zone affect data accessibility. * `REGIONAL`: The instance can serve data from more than one zone in a region (it is highly available)./ For more information, see [Overview of the High Availability Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
        :param 'BackupConfigurationResponse' backup_configuration: The daily backup configuration for the instance.
        :param str collation: The name of server Instance collation.
        :param str connector_enforcement: Specifies if connections must use Cloud SQL connectors. Option values include the following: `NOT_REQUIRED` (Cloud SQL instances can be connected without Cloud SQL Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL Connectors). Note that using REQUIRED disables all existing authorized networks. If this field is not specified when creating a new instance, NOT_REQUIRED is used. If this field is not specified when patching or updating an existing instance, it is left unchanged in the instance.
        :param bool crash_safe_replication_enabled: Configuration specific to read replica instances. Indicates whether database flags for crash-safe replication are enabled. This property was only applicable to First Generation instances.
        :param str data_disk_size_gb: The size of data disk, in GB. The data disk size minimum is 10GB.
        :param str data_disk_type: The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for First Generation instances.
        :param Sequence['DatabaseFlagsResponse'] database_flags: The database flags passed to the instance at startup.
        :param bool database_replication_enabled: Configuration specific to read replica instances. Indicates whether replication is enabled or not. WARNING: Changing this restarts the instance.
        :param bool deletion_protection_enabled: Configuration to protect against accidental instance deletion.
        :param Sequence['DenyMaintenancePeriodResponse'] deny_maintenance_periods: Deny maintenance periods
        :param 'InsightsConfigResponse' insights_config: Insights configuration, for now relevant only for Postgres.
        :param 'IpConfigurationResponse' ip_configuration: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled for Second Generation instances.
        :param str kind: This is always `sql#settings`.
        :param 'LocationPreferenceResponse' location_preference: The location preference settings. This allows the instance to be located as near as possible to either an App Engine app or Compute Engine zone for better performance. App Engine co-location was only applicable to First Generation instances.
        :param 'MaintenanceWindowResponse' maintenance_window: The maintenance window for this instance. This specifies when the instance can be restarted for maintenance purposes.
        :param 'PasswordValidationPolicyResponse' password_validation_policy: The local user password validation policy of the instance.
        :param str pricing_plan: The pricing plan for this instance. This can be either `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
        :param str replication_type: The type of replication this instance uses. This can be either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only applicable to First Generation instances.
        :param str settings_version: The version of instance settings. This is a required field for update method to make sure concurrent updates are handled properly. During update, use the most recent settingsVersion value for this instance and do not try to update this value.
        :param 'SqlServerAuditConfigResponse' sql_server_audit_config: SQL Server specific audit configuration.
        :param bool storage_auto_resize: Configuration to increase storage size automatically. The default value is true.
        :param str storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param str tier: The tier (or machine type) for this instance, for example `db-custom-1-3840`. WARNING: Changing this restarts the instance.
        :param str time_zone: Server timezone, relevant only for Cloud SQL for SQL Server.
        :param Mapping[str, str] user_labels: User-provided labels, represented as a dictionary where each label is a single key value pair.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_config", active_directory_config)
        pulumi.set(__self__, "authorized_gae_applications", authorized_gae_applications)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configuration", backup_configuration)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "connector_enforcement", connector_enforcement)
        pulumi.set(__self__, "crash_safe_replication_enabled", crash_safe_replication_enabled)
        pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        pulumi.set(__self__, "data_disk_type", data_disk_type)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "database_replication_enabled", database_replication_enabled)
        pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        pulumi.set(__self__, "insights_config", insights_config)
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "location_preference", location_preference)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "password_validation_policy", password_validation_policy)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "replication_type", replication_type)
        pulumi.set(__self__, "settings_version", settings_version)
        pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        pulumi.set(__self__, "storage_auto_resize", storage_auto_resize)
        pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is RUNNABLE. Valid values: * `ALWAYS`: The instance is on, and remains so even in the absence of connection requests. * `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> 'outputs.SqlActiveDirectoryConfigResponse':
        """
        Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        """
        return pulumi.get(self, "active_directory_config")

    @property
    @pulumi.getter(name="authorizedGaeApplications")
    def authorized_gae_applications(self) -> Sequence[str]:
        """
        The App Engine app IDs that can access this instance. (Deprecated) Applied to First Generation instances only.
        """
        return pulumi.get(self, "authorized_gae_applications")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> str:
        """
        Availability type. Potential values: * `ZONAL`: The instance serves data from only one zone. Outages in that zone affect data accessibility. * `REGIONAL`: The instance can serve data from more than one zone in a region (it is highly available)./ For more information, see [Overview of the High Availability Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> 'outputs.BackupConfigurationResponse':
        """
        The daily backup configuration for the instance.
        """
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter
    def collation(self) -> str:
        """
        The name of server Instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="connectorEnforcement")
    def connector_enforcement(self) -> str:
        """
        Specifies if connections must use Cloud SQL connectors. Option values include the following: `NOT_REQUIRED` (Cloud SQL instances can be connected without Cloud SQL Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL Connectors). Note that using REQUIRED disables all existing authorized networks. If this field is not specified when creating a new instance, NOT_REQUIRED is used. If this field is not specified when patching or updating an existing instance, it is left unchanged in the instance.
        """
        return pulumi.get(self, "connector_enforcement")

    @property
    @pulumi.getter(name="crashSafeReplicationEnabled")
    def crash_safe_replication_enabled(self) -> bool:
        """
        Configuration specific to read replica instances. Indicates whether database flags for crash-safe replication are enabled. This property was only applicable to First Generation instances.
        """
        return pulumi.get(self, "crash_safe_replication_enabled")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> str:
        """
        The size of data disk, in GB. The data disk size minimum is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> str:
        """
        The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for First Generation instances.
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.DatabaseFlagsResponse']:
        """
        The database flags passed to the instance at startup.
        """
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="databaseReplicationEnabled")
    def database_replication_enabled(self) -> bool:
        """
        Configuration specific to read replica instances. Indicates whether replication is enabled or not. WARNING: Changing this restarts the instance.
        """
        return pulumi.get(self, "database_replication_enabled")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> bool:
        """
        Configuration to protect against accidental instance deletion.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Sequence['outputs.DenyMaintenancePeriodResponse']:
        """
        Deny maintenance periods
        """
        return pulumi.get(self, "deny_maintenance_periods")

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> 'outputs.InsightsConfigResponse':
        """
        Insights configuration, for now relevant only for Postgres.
        """
        return pulumi.get(self, "insights_config")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> 'outputs.IpConfigurationResponse':
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled for Second Generation instances.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#settings`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> 'outputs.LocationPreferenceResponse':
        """
        The location preference settings. This allows the instance to be located as near as possible to either an App Engine app or Compute Engine zone for better performance. App Engine co-location was only applicable to First Generation instances.
        """
        return pulumi.get(self, "location_preference")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> 'outputs.MaintenanceWindowResponse':
        """
        The maintenance window for this instance. This specifies when the instance can be restarted for maintenance purposes.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="passwordValidationPolicy")
    def password_validation_policy(self) -> 'outputs.PasswordValidationPolicyResponse':
        """
        The local user password validation policy of the instance.
        """
        return pulumi.get(self, "password_validation_policy")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> str:
        """
        The pricing plan for this instance. This can be either `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> str:
        """
        The type of replication this instance uses. This can be either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only applicable to First Generation instances.
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter(name="settingsVersion")
    def settings_version(self) -> str:
        """
        The version of instance settings. This is a required field for update method to make sure concurrent updates are handled properly. During update, use the most recent settingsVersion value for this instance and do not try to update this value.
        """
        return pulumi.get(self, "settings_version")

    @property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> 'outputs.SqlServerAuditConfigResponse':
        """
        SQL Server specific audit configuration.
        """
        return pulumi.get(self, "sql_server_audit_config")

    @property
    @pulumi.getter(name="storageAutoResize")
    def storage_auto_resize(self) -> bool:
        """
        Configuration to increase storage size automatically. The default value is true.
        """
        return pulumi.get(self, "storage_auto_resize")

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> str:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier (or machine type) for this instance, for example `db-custom-1-3840`. WARNING: Changing this restarts the instance.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Server timezone, relevant only for Cloud SQL for SQL Server.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        """
        User-provided labels, represented as a dictionary where each label is a single key value pair.
        """
        return pulumi.get(self, "user_labels")


@pulumi.output_type
class SqlActiveDirectoryConfigResponse(dict):
    """
    Active Directory configuration, relevant only for Cloud SQL for SQL Server.
    """
    def __init__(__self__, *,
                 domain: str,
                 kind: str):
        """
        Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        :param str domain: The name of the domain (e.g., mydomain.com).
        :param str kind: This is always sql#activeDirectoryConfig.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The name of the domain (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always sql#activeDirectoryConfig.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class SqlOutOfDiskReportResponse(dict):
    """
    This message wraps up the information written by out-of-disk detection job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sqlMinRecommendedIncreaseSizeGb":
            suggest = "sql_min_recommended_increase_size_gb"
        elif key == "sqlOutOfDiskState":
            suggest = "sql_out_of_disk_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlOutOfDiskReportResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlOutOfDiskReportResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlOutOfDiskReportResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sql_min_recommended_increase_size_gb: int,
                 sql_out_of_disk_state: str):
        """
        This message wraps up the information written by out-of-disk detection job.
        :param int sql_min_recommended_increase_size_gb: The minimum recommended increase size in GigaBytes This field is consumed by the frontend * Writers: * the proactive database wellness job for OOD. * Readers:
        :param str sql_out_of_disk_state: This field represents the state generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        """
        pulumi.set(__self__, "sql_min_recommended_increase_size_gb", sql_min_recommended_increase_size_gb)
        pulumi.set(__self__, "sql_out_of_disk_state", sql_out_of_disk_state)

    @property
    @pulumi.getter(name="sqlMinRecommendedIncreaseSizeGb")
    def sql_min_recommended_increase_size_gb(self) -> int:
        """
        The minimum recommended increase size in GigaBytes This field is consumed by the frontend * Writers: * the proactive database wellness job for OOD. * Readers:
        """
        return pulumi.get(self, "sql_min_recommended_increase_size_gb")

    @property
    @pulumi.getter(name="sqlOutOfDiskState")
    def sql_out_of_disk_state(self) -> str:
        """
        This field represents the state generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        """
        return pulumi.get(self, "sql_out_of_disk_state")


@pulumi.output_type
class SqlScheduledMaintenanceResponse(dict):
    """
    Any scheduled maintenance for this instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canDefer":
            suggest = "can_defer"
        elif key == "canReschedule":
            suggest = "can_reschedule"
        elif key == "scheduleDeadlineTime":
            suggest = "schedule_deadline_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlScheduledMaintenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlScheduledMaintenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlScheduledMaintenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 can_defer: bool,
                 can_reschedule: bool,
                 schedule_deadline_time: str,
                 start_time: str):
        """
        Any scheduled maintenance for this instance.
        :param bool can_reschedule: If the scheduled maintenance can be rescheduled.
        :param str schedule_deadline_time: Maintenance cannot be rescheduled to start beyond this deadline.
        :param str start_time: The start time of any upcoming scheduled maintenance for this instance.
        """
        pulumi.set(__self__, "can_defer", can_defer)
        pulumi.set(__self__, "can_reschedule", can_reschedule)
        pulumi.set(__self__, "schedule_deadline_time", schedule_deadline_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="canDefer")
    def can_defer(self) -> bool:
        return pulumi.get(self, "can_defer")

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> bool:
        """
        If the scheduled maintenance can be rescheduled.
        """
        return pulumi.get(self, "can_reschedule")

    @property
    @pulumi.getter(name="scheduleDeadlineTime")
    def schedule_deadline_time(self) -> str:
        """
        Maintenance cannot be rescheduled to start beyond this deadline.
        """
        return pulumi.get(self, "schedule_deadline_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class SqlServerAuditConfigResponse(dict):
    """
    SQL Server specific audit configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInterval":
            suggest = "retention_interval"
        elif key == "uploadInterval":
            suggest = "upload_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerAuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerAuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerAuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 kind: str,
                 retention_interval: str,
                 upload_interval: str):
        """
        SQL Server specific audit configuration.
        :param str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param str kind: This is always sql#sqlServerAuditConfig
        :param str retention_interval: How long to keep generated audit files.
        :param str upload_interval: How often to upload generated audit files.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always sql#sqlServerAuditConfig
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> str:
        """
        How long to keep generated audit files.
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> str:
        """
        How often to upload generated audit files.
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class SqlServerDatabaseDetailsResponse(dict):
    """
    Represents a Sql Server database on the Cloud SQL instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compatibilityLevel":
            suggest = "compatibility_level"
        elif key == "recoveryModel":
            suggest = "recovery_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerDatabaseDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerDatabaseDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerDatabaseDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compatibility_level: int,
                 recovery_model: str):
        """
        Represents a Sql Server database on the Cloud SQL instance.
        :param int compatibility_level: The version of SQL Server with which the database is to be made compatible
        :param str recovery_model: The recovery model of a SQL Server database
        """
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        pulumi.set(__self__, "recovery_model", recovery_model)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> int:
        """
        The version of SQL Server with which the database is to be made compatible
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> str:
        """
        The recovery model of a SQL Server database
        """
        return pulumi.get(self, "recovery_model")


@pulumi.output_type
class SqlServerUserDetailsResponse(dict):
    """
    Represents a Sql Server user on the Cloud SQL instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverRoles":
            suggest = "server_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlServerUserDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlServerUserDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlServerUserDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: bool,
                 server_roles: Sequence[str]):
        """
        Represents a Sql Server user on the Cloud SQL instance.
        :param bool disabled: If the user has been disabled
        :param Sequence[str] server_roles: The server roles for this user
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        If the user has been disabled
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Sequence[str]:
        """
        The server roles for this user
        """
        return pulumi.get(self, "server_roles")


@pulumi.output_type
class SslCertResponse(dict):
    """
    SslCerts Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSerialNumber":
            suggest = "cert_serial_number"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "selfLink":
            suggest = "self_link"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslCertResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslCertResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslCertResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: str,
                 cert_serial_number: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 instance: str,
                 kind: str,
                 self_link: str,
                 sha1_fingerprint: str):
        """
        SslCerts Resource
        :param str cert: PEM representation.
        :param str cert_serial_number: Serial number, as extracted from the certificate.
        :param str common_name: User supplied name. Constrained to [a-zA-Z.-_ ]+.
        :param str create_time: The time when the certificate was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`
        :param str expiration_time: The time when the certificate expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        :param str instance: Name of the database instance.
        :param str kind: This is always `sql#sslCert`.
        :param str self_link: The URI of this resource.
        :param str sha1_fingerprint: Sha1 Fingerprint.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "cert_serial_number", cert_serial_number)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        PEM representation.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="certSerialNumber")
    def cert_serial_number(self) -> str:
        """
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "cert_serial_number")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        User supplied name. Constrained to [a-zA-Z.-_ ]+.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the certificate was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The time when the certificate expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def instance(self) -> str:
        """
        Name of the database instance.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is always `sql#sslCert`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        """
        Sha1 Fingerprint.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class UserPasswordValidationPolicyResponse(dict):
    """
    User level password validation policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedFailedAttempts":
            suggest = "allowed_failed_attempts"
        elif key == "enableFailedAttemptsCheck":
            suggest = "enable_failed_attempts_check"
        elif key == "enablePasswordVerification":
            suggest = "enable_password_verification"
        elif key == "passwordExpirationDuration":
            suggest = "password_expiration_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPasswordValidationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPasswordValidationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPasswordValidationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_failed_attempts: int,
                 enable_failed_attempts_check: bool,
                 enable_password_verification: bool,
                 password_expiration_duration: str,
                 status: 'outputs.PasswordStatusResponse'):
        """
        User level password validation policy.
        :param int allowed_failed_attempts: Number of failed login attempts allowed before user get locked.
        :param bool enable_failed_attempts_check: If true, failed login attempts check will be enabled.
        :param bool enable_password_verification: If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        :param str password_expiration_duration: Expiration duration after password is updated.
        :param 'PasswordStatusResponse' status: Read-only password status.
        """
        pulumi.set(__self__, "allowed_failed_attempts", allowed_failed_attempts)
        pulumi.set(__self__, "enable_failed_attempts_check", enable_failed_attempts_check)
        pulumi.set(__self__, "enable_password_verification", enable_password_verification)
        pulumi.set(__self__, "password_expiration_duration", password_expiration_duration)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="allowedFailedAttempts")
    def allowed_failed_attempts(self) -> int:
        """
        Number of failed login attempts allowed before user get locked.
        """
        return pulumi.get(self, "allowed_failed_attempts")

    @property
    @pulumi.getter(name="enableFailedAttemptsCheck")
    def enable_failed_attempts_check(self) -> bool:
        """
        If true, failed login attempts check will be enabled.
        """
        return pulumi.get(self, "enable_failed_attempts_check")

    @property
    @pulumi.getter(name="enablePasswordVerification")
    def enable_password_verification(self) -> bool:
        """
        If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
        """
        return pulumi.get(self, "enable_password_verification")

    @property
    @pulumi.getter(name="passwordExpirationDuration")
    def password_expiration_duration(self) -> str:
        """
        Expiration duration after password is updated.
        """
        return pulumi.get(self, "password_expiration_duration")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.PasswordStatusResponse':
        """
        Read-only password status.
        """
        return pulumi.get(self, "status")


