# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'DatabaseDatabaseDialect',
    'FreeInstanceMetadataExpireBehavior',
    'InstanceInstanceType',
    'ReplicaInfoType',
]


class DatabaseDatabaseDialect(str, Enum):
    """
    Optional. The dialect of the Cloud Spanner Database.
    """
    DATABASE_DIALECT_UNSPECIFIED = "DATABASE_DIALECT_UNSPECIFIED"
    """
    Default value. This value will create a database with the GOOGLE_STANDARD_SQL dialect.
    """
    GOOGLE_STANDARD_SQL = "GOOGLE_STANDARD_SQL"
    """
    Google standard SQL.
    """
    POSTGRESQL = "POSTGRESQL"
    """
    PostgreSQL supported SQL.
    """


class FreeInstanceMetadataExpireBehavior(str, Enum):
    """
    Specifies the expiration behavior of a free instance. The default of ExpireBehavior is `REMOVE_AFTER_GRACE_PERIOD`. This can be modified during or after creation, and before expiration.
    """
    EXPIRE_BEHAVIOR_UNSPECIFIED = "EXPIRE_BEHAVIOR_UNSPECIFIED"
    """
    Not specified.
    """
    FREE_TO_PROVISIONED = "FREE_TO_PROVISIONED"
    """
    When the free instance expires, upgrade the instance to a provisioned instance.
    """
    REMOVE_AFTER_GRACE_PERIOD = "REMOVE_AFTER_GRACE_PERIOD"
    """
    When the free instance expires, disable the instance, and delete it after the grace period passes if it has not been upgraded.
    """


class InstanceInstanceType(str, Enum):
    """
    The `InstanceType` of the current instance.
    """
    INSTANCE_TYPE_UNSPECIFIED = "INSTANCE_TYPE_UNSPECIFIED"
    """
    Not specified.
    """
    PROVISIONED = "PROVISIONED"
    """
    Provisioned instances have dedicated resources, standard usage limits and support.
    """
    FREE_INSTANCE = "FREE_INSTANCE"
    """
    Free instances provide no guarantee for dedicated resources, [node_count, processing_units] should be 0. They come with stricter usage limits and limited support.
    """


class ReplicaInfoType(str, Enum):
    """
    The type of replica.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Not specified.
    """
    READ_WRITE = "READ_WRITE"
    """
    Read-write replicas support both reads and writes. These replicas: * Maintain a full copy of your data. * Serve reads. * Can vote whether to commit a write. * Participate in leadership election. * Are eligible to become a leader.
    """
    READ_ONLY = "READ_ONLY"
    """
    Read-only replicas only support reads (not writes). Read-only replicas: * Maintain a full copy of your data. * Serve reads. * Do not participate in voting to commit writes. * Are not eligible to become a leader.
    """
    WITNESS = "WITNESS"
    """
    Witness replicas don't support reads but do participate in voting to commit writes. Witness replicas: * Do not maintain a full copy of data. * Do not serve reads. * Vote whether to commit writes. * Participate in leader election but are not eligible to become leader.
    """
