# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetSchemaResult',
    'AwaitableGetSchemaResult',
    'get_schema',
    'get_schema_output',
]

@pulumi.output_type
class GetSchemaResult:
    def __init__(__self__, definition=None, name=None, revision_create_time=None, revision_id=None, type=None):
        if definition and not isinstance(definition, str):
            raise TypeError("Expected argument 'definition' to be a str")
        pulumi.set(__self__, "definition", definition)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if revision_create_time and not isinstance(revision_create_time, str):
            raise TypeError("Expected argument 'revision_create_time' to be a str")
        pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def definition(self) -> str:
        """
        The definition of the schema. This should contain a string representing the full definition of the schema that is a valid schema definition of the type specified in `type`.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the schema. Format is `projects/{project}/schemas/{schema}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> str:
        """
        The timestamp that the revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Immutable. The revision ID of the schema.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the schema definition.
        """
        return pulumi.get(self, "type")


class AwaitableGetSchemaResult(GetSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemaResult(
            definition=self.definition,
            name=self.name,
            revision_create_time=self.revision_create_time,
            revision_id=self.revision_id,
            type=self.type)


def get_schema(project: Optional[str] = None,
               schema_id: Optional[str] = None,
               view: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemaResult:
    """
    Gets a schema.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['schemaId'] = schema_id
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:pubsub/v1:getSchema', __args__, opts=opts, typ=GetSchemaResult).value

    return AwaitableGetSchemaResult(
        definition=__ret__.definition,
        name=__ret__.name,
        revision_create_time=__ret__.revision_create_time,
        revision_id=__ret__.revision_id,
        type=__ret__.type)


@_utilities.lift_output_func(get_schema)
def get_schema_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                      schema_id: Optional[pulumi.Input[str]] = None,
                      view: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSchemaResult]:
    """
    Gets a schema.
    """
    ...
