# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ExecutionArgs', 'Execution']

@pulumi.input_type
class ExecutionArgs:
    def __init__(__self__, *,
                 execution_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 execution_template: Optional[pulumi.Input['ExecutionTemplateArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 output_notebook_file: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Execution resource.
        :param pulumi.Input[str] execution_id: Required. User-defined unique ID of this execution.
        :param pulumi.Input[str] description: A brief description of this execution.
        :param pulumi.Input['ExecutionTemplateArgs'] execution_template: execute metadata including name, hardware spec, region, labels, etc.
        :param pulumi.Input[str] output_notebook_file: Output notebook file generated by this execution
        """
        pulumi.set(__self__, "execution_id", execution_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_template is not None:
            pulumi.set(__self__, "execution_template", execution_template)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if output_notebook_file is not None:
            pulumi.set(__self__, "output_notebook_file", output_notebook_file)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> pulumi.Input[str]:
        """
        Required. User-defined unique ID of this execution.
        """
        return pulumi.get(self, "execution_id")

    @execution_id.setter
    def execution_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of this execution.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionTemplate")
    def execution_template(self) -> Optional[pulumi.Input['ExecutionTemplateArgs']]:
        """
        execute metadata including name, hardware spec, region, labels, etc.
        """
        return pulumi.get(self, "execution_template")

    @execution_template.setter
    def execution_template(self, value: Optional[pulumi.Input['ExecutionTemplateArgs']]):
        pulumi.set(self, "execution_template", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="outputNotebookFile")
    def output_notebook_file(self) -> Optional[pulumi.Input[str]]:
        """
        Output notebook file generated by this execution
        """
        return pulumi.get(self, "output_notebook_file")

    @output_notebook_file.setter
    def output_notebook_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_notebook_file", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Execution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 execution_template: Optional[pulumi.Input[pulumi.InputType['ExecutionTemplateArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 output_notebook_file: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Execution in a given project and location.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A brief description of this execution.
        :param pulumi.Input[str] execution_id: Required. User-defined unique ID of this execution.
        :param pulumi.Input[pulumi.InputType['ExecutionTemplateArgs']] execution_template: execute metadata including name, hardware spec, region, labels, etc.
        :param pulumi.Input[str] output_notebook_file: Output notebook file generated by this execution
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Execution in a given project and location.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 execution_template: Optional[pulumi.Input[pulumi.InputType['ExecutionTemplateArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 output_notebook_file: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExecutionArgs.__new__(ExecutionArgs)

            __props__.__dict__["description"] = description
            if execution_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_id'")
            __props__.__dict__["execution_id"] = execution_id
            __props__.__dict__["execution_template"] = execution_template
            __props__.__dict__["location"] = location
            __props__.__dict__["output_notebook_file"] = output_notebook_file
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["job_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["execution_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Execution, __self__).__init__(
            'google-native:notebooks/v1:Execution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Execution':
        """
        Get an existing Execution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ExecutionArgs.__new__(ExecutionArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["execution_id"] = None
        __props__.__dict__["execution_template"] = None
        __props__.__dict__["job_uri"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["output_notebook_file"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["update_time"] = None
        return Execution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the Execution was instantiated.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A brief description of this execution.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name used for UI purposes. Name can only contain alphanumeric characters and underscores '_'.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> pulumi.Output[str]:
        """
        Required. User-defined unique ID of this execution.
        """
        return pulumi.get(self, "execution_id")

    @property
    @pulumi.getter(name="executionTemplate")
    def execution_template(self) -> pulumi.Output['outputs.ExecutionTemplateResponse']:
        """
        execute metadata including name, hardware spec, region, labels, etc.
        """
        return pulumi.get(self, "execution_template")

    @property
    @pulumi.getter(name="jobUri")
    def job_uri(self) -> pulumi.Output[str]:
        """
        The URI of the external job used to execute the notebook.
        """
        return pulumi.get(self, "job_uri")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the execute. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputNotebookFile")
    def output_notebook_file(self) -> pulumi.Output[str]:
        """
        Output notebook file generated by this execution
        """
        return pulumi.get(self, "output_notebook_file")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the underlying AI Platform job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the Execution was last updated.
        """
        return pulumi.get(self, "update_time")

