# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['ChannelConnectionArgs', 'ChannelConnection']

@pulumi.input_type
class ChannelConnectionArgs:
    def __init__(__self__, *,
                 channel: pulumi.Input[str],
                 channel_connection_id: pulumi.Input[str],
                 activation_token: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ChannelConnection resource.
        :param pulumi.Input[str] channel: The name of the connected subscriber Channel. This is a weak reference to avoid cross project and cross accounts references. This must be in `projects/{project}/location/{location}/channels/{channel_id}` format.
        :param pulumi.Input[str] channel_connection_id: Required. The user-provided ID to be assigned to the channel connection.
        :param pulumi.Input[str] activation_token: Input only. Activation token for the channel. The token will be used during the creation of ChannelConnection to bind the channel with the provider project. This field will not be stored in the provider resource.
        :param pulumi.Input[str] name: The name of the connection.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "channel_connection_id", channel_connection_id)
        if activation_token is not None:
            pulumi.set(__self__, "activation_token", activation_token)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Input[str]:
        """
        The name of the connected subscriber Channel. This is a weak reference to avoid cross project and cross accounts references. This must be in `projects/{project}/location/{location}/channels/{channel_id}` format.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter(name="channelConnectionId")
    def channel_connection_id(self) -> pulumi.Input[str]:
        """
        Required. The user-provided ID to be assigned to the channel connection.
        """
        return pulumi.get(self, "channel_connection_id")

    @channel_connection_id.setter
    def channel_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_connection_id", value)

    @property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Activation token for the channel. The token will be used during the creation of ChannelConnection to bind the channel with the provider project. This field will not be stored in the provider resource.
        """
        return pulumi.get(self, "activation_token")

    @activation_token.setter
    def activation_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_token", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ChannelConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_token: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 channel_connection_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a new ChannelConnection in a particular project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_token: Input only. Activation token for the channel. The token will be used during the creation of ChannelConnection to bind the channel with the provider project. This field will not be stored in the provider resource.
        :param pulumi.Input[str] channel: The name of the connected subscriber Channel. This is a weak reference to avoid cross project and cross accounts references. This must be in `projects/{project}/location/{location}/channels/{channel_id}` format.
        :param pulumi.Input[str] channel_connection_id: Required. The user-provided ID to be assigned to the channel connection.
        :param pulumi.Input[str] name: The name of the connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a new ChannelConnection in a particular project and location.

        :param str resource_name: The name of the resource.
        :param ChannelConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_token: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 channel_connection_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelConnectionArgs.__new__(ChannelConnectionArgs)

            __props__.__dict__["activation_token"] = activation_token
            if channel is None and not opts.urn:
                raise TypeError("Missing required property 'channel'")
            __props__.__dict__["channel"] = channel
            if channel_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'channel_connection_id'")
            __props__.__dict__["channel_connection_id"] = channel_connection_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["channel_connection_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ChannelConnection, __self__).__init__(
            'google-native:eventarc/v1:ChannelConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ChannelConnection':
        """
        Get an existing ChannelConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelConnectionArgs.__new__(ChannelConnectionArgs)

        __props__.__dict__["activation_token"] = None
        __props__.__dict__["channel"] = None
        __props__.__dict__["channel_connection_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["update_time"] = None
        return ChannelConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> pulumi.Output[str]:
        """
        Input only. Activation token for the channel. The token will be used during the creation of ChannelConnection to bind the channel with the provider project. This field will not be stored in the provider resource.
        """
        return pulumi.get(self, "activation_token")

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[str]:
        """
        The name of the connected subscriber Channel. This is a weak reference to avoid cross project and cross accounts references. This must be in `projects/{project}/location/{location}/channels/{channel_id}` format.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="channelConnectionId")
    def channel_connection_id(self) -> pulumi.Output[str]:
        """
        Required. The user-provided ID to be assigned to the channel connection.
        """
        return pulumi.get(self, "channel_connection_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Server assigned ID of the resource. The server guarantees uniqueness and immutability until deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

