# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AvroFileFormatResponse',
    'BackfillAllStrategyResponse',
    'BackfillNoneStrategyResponse',
    'BigQueryDestinationConfigResponse',
    'BigQueryProfileResponse',
    'DatasetTemplateResponse',
    'DestinationConfigResponse',
    'DropLargeObjectsResponse',
    'ErrorResponse',
    'ForwardSshTunnelConnectivityResponse',
    'GcsDestinationConfigResponse',
    'GcsProfileResponse',
    'JsonFileFormatResponse',
    'MysqlColumnResponse',
    'MysqlDatabaseResponse',
    'MysqlProfileResponse',
    'MysqlRdbmsResponse',
    'MysqlSourceConfigResponse',
    'MysqlSslConfigResponse',
    'MysqlTableResponse',
    'OracleColumnResponse',
    'OracleProfileResponse',
    'OracleRdbmsResponse',
    'OracleSchemaResponse',
    'OracleSourceConfigResponse',
    'OracleTableResponse',
    'PostgresqlColumnResponse',
    'PostgresqlProfileResponse',
    'PostgresqlRdbmsResponse',
    'PostgresqlSchemaResponse',
    'PostgresqlSourceConfigResponse',
    'PostgresqlTableResponse',
    'PrivateConnectivityResponse',
    'SingleTargetDatasetResponse',
    'SourceConfigResponse',
    'SourceHierarchyDatasetsResponse',
    'StaticServiceIpConnectivityResponse',
    'StreamLargeObjectsResponse',
    'VpcPeeringConfigResponse',
]

@pulumi.output_type
class AvroFileFormatResponse(dict):
    """
    AVRO file format configuration.
    """
    def __init__(__self__):
        """
        AVRO file format configuration.
        """
        pass


@pulumi.output_type
class BackfillAllStrategyResponse(dict):
    """
    Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlExcludedObjects":
            suggest = "mysql_excluded_objects"
        elif key == "oracleExcludedObjects":
            suggest = "oracle_excluded_objects"
        elif key == "postgresqlExcludedObjects":
            suggest = "postgresql_excluded_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackfillAllStrategyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackfillAllStrategyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackfillAllStrategyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_excluded_objects: 'outputs.MysqlRdbmsResponse',
                 oracle_excluded_objects: 'outputs.OracleRdbmsResponse',
                 postgresql_excluded_objects: 'outputs.PostgresqlRdbmsResponse'):
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        :param 'MysqlRdbmsResponse' mysql_excluded_objects: MySQL data source objects to avoid backfilling.
        :param 'OracleRdbmsResponse' oracle_excluded_objects: Oracle data source objects to avoid backfilling.
        :param 'PostgresqlRdbmsResponse' postgresql_excluded_objects: PostgreSQL data source objects to avoid backfilling.
        """
        pulumi.set(__self__, "mysql_excluded_objects", mysql_excluded_objects)
        pulumi.set(__self__, "oracle_excluded_objects", oracle_excluded_objects)
        pulumi.set(__self__, "postgresql_excluded_objects", postgresql_excluded_objects)

    @property
    @pulumi.getter(name="mysqlExcludedObjects")
    def mysql_excluded_objects(self) -> 'outputs.MysqlRdbmsResponse':
        """
        MySQL data source objects to avoid backfilling.
        """
        return pulumi.get(self, "mysql_excluded_objects")

    @property
    @pulumi.getter(name="oracleExcludedObjects")
    def oracle_excluded_objects(self) -> 'outputs.OracleRdbmsResponse':
        """
        Oracle data source objects to avoid backfilling.
        """
        return pulumi.get(self, "oracle_excluded_objects")

    @property
    @pulumi.getter(name="postgresqlExcludedObjects")
    def postgresql_excluded_objects(self) -> 'outputs.PostgresqlRdbmsResponse':
        """
        PostgreSQL data source objects to avoid backfilling.
        """
        return pulumi.get(self, "postgresql_excluded_objects")


@pulumi.output_type
class BackfillNoneStrategyResponse(dict):
    """
    Backfill strategy to disable automatic backfill for the Stream's objects.
    """
    def __init__(__self__):
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        pass


@pulumi.output_type
class BigQueryDestinationConfigResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataFreshness":
            suggest = "data_freshness"
        elif key == "singleTargetDataset":
            suggest = "single_target_dataset"
        elif key == "sourceHierarchyDatasets":
            suggest = "source_hierarchy_datasets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigQueryDestinationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigQueryDestinationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigQueryDestinationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_freshness: str,
                 single_target_dataset: 'outputs.SingleTargetDatasetResponse',
                 source_hierarchy_datasets: 'outputs.SourceHierarchyDatasetsResponse'):
        """
        :param str data_freshness: The guaranteed data freshness (in seconds) when querying tables created by the stream. Editing this field will only affect new tables created in the future, but existing tables will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
        :param 'SingleTargetDatasetResponse' single_target_dataset: Single destination dataset.
        :param 'SourceHierarchyDatasetsResponse' source_hierarchy_datasets: Source hierarchy datasets.
        """
        pulumi.set(__self__, "data_freshness", data_freshness)
        pulumi.set(__self__, "single_target_dataset", single_target_dataset)
        pulumi.set(__self__, "source_hierarchy_datasets", source_hierarchy_datasets)

    @property
    @pulumi.getter(name="dataFreshness")
    def data_freshness(self) -> str:
        """
        The guaranteed data freshness (in seconds) when querying tables created by the stream. Editing this field will only affect new tables created in the future, but existing tables will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
        """
        return pulumi.get(self, "data_freshness")

    @property
    @pulumi.getter(name="singleTargetDataset")
    def single_target_dataset(self) -> 'outputs.SingleTargetDatasetResponse':
        """
        Single destination dataset.
        """
        return pulumi.get(self, "single_target_dataset")

    @property
    @pulumi.getter(name="sourceHierarchyDatasets")
    def source_hierarchy_datasets(self) -> 'outputs.SourceHierarchyDatasetsResponse':
        """
        Source hierarchy datasets.
        """
        return pulumi.get(self, "source_hierarchy_datasets")


@pulumi.output_type
class BigQueryProfileResponse(dict):
    """
    BigQuery warehouse profile.
    """
    def __init__(__self__):
        """
        BigQuery warehouse profile.
        """
        pass


@pulumi.output_type
class DatasetTemplateResponse(dict):
    """
    Dataset template used for dynamic dataset creation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetIdPrefix":
            suggest = "dataset_id_prefix"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id_prefix: str,
                 kms_key_name: str,
                 location: str):
        """
        Dataset template used for dynamic dataset creation.
        :param str dataset_id_prefix: If supplied, every created dataset will have its name prefixed by the provided value. The prefix and name will be separated by an underscore. i.e. _.
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}. See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.
        :param str location: The geographic location where the dataset should reside. See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        pulumi.set(__self__, "dataset_id_prefix", dataset_id_prefix)
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="datasetIdPrefix")
    def dataset_id_prefix(self) -> str:
        """
        If supplied, every created dataset will have its name prefixed by the provided value. The prefix and name will be separated by an underscore. i.e. _.
        """
        return pulumi.get(self, "dataset_id_prefix")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}. See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geographic location where the dataset should reside. See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class DestinationConfigResponse(dict):
    """
    The configuration of the stream destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestinationConfig":
            suggest = "bigquery_destination_config"
        elif key == "destinationConnectionProfile":
            suggest = "destination_connection_profile"
        elif key == "gcsDestinationConfig":
            suggest = "gcs_destination_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DestinationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DestinationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DestinationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination_config: 'outputs.BigQueryDestinationConfigResponse',
                 destination_connection_profile: str,
                 gcs_destination_config: 'outputs.GcsDestinationConfigResponse'):
        """
        The configuration of the stream destination.
        :param 'BigQueryDestinationConfigResponse' bigquery_destination_config: BigQuery destination configuration.
        :param str destination_connection_profile: Destination connection profile resource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        :param 'GcsDestinationConfigResponse' gcs_destination_config: A configuration for how data should be loaded to Cloud Storage.
        """
        pulumi.set(__self__, "bigquery_destination_config", bigquery_destination_config)
        pulumi.set(__self__, "destination_connection_profile", destination_connection_profile)
        pulumi.set(__self__, "gcs_destination_config", gcs_destination_config)

    @property
    @pulumi.getter(name="bigqueryDestinationConfig")
    def bigquery_destination_config(self) -> 'outputs.BigQueryDestinationConfigResponse':
        """
        BigQuery destination configuration.
        """
        return pulumi.get(self, "bigquery_destination_config")

    @property
    @pulumi.getter(name="destinationConnectionProfile")
    def destination_connection_profile(self) -> str:
        """
        Destination connection profile resource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        """
        return pulumi.get(self, "destination_connection_profile")

    @property
    @pulumi.getter(name="gcsDestinationConfig")
    def gcs_destination_config(self) -> 'outputs.GcsDestinationConfigResponse':
        """
        A configuration for how data should be loaded to Cloud Storage.
        """
        return pulumi.get(self, "gcs_destination_config")


@pulumi.output_type
class DropLargeObjectsResponse(dict):
    """
    Configuration to drop large object values.
    """
    def __init__(__self__):
        """
        Configuration to drop large object values.
        """
        pass


@pulumi.output_type
class ErrorResponse(dict):
    """
    Represent a user-facing Error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorTime":
            suggest = "error_time"
        elif key == "errorUuid":
            suggest = "error_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Mapping[str, str],
                 error_time: str,
                 error_uuid: str,
                 message: str,
                 reason: str):
        """
        Represent a user-facing Error.
        :param Mapping[str, str] details: Additional information about the error.
        :param str error_time: The time when the error occurred.
        :param str error_uuid: A unique identifier for this specific error, allowing it to be traced throughout the system in logs and API responses.
        :param str message: A message containing more information about the error that occurred.
        :param str reason: A title that explains the reason for the error.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "error_time", error_time)
        pulumi.set(__self__, "error_uuid", error_uuid)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def details(self) -> Mapping[str, str]:
        """
        Additional information about the error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="errorTime")
    def error_time(self) -> str:
        """
        The time when the error occurred.
        """
        return pulumi.get(self, "error_time")

    @property
    @pulumi.getter(name="errorUuid")
    def error_uuid(self) -> str:
        """
        A unique identifier for this specific error, allowing it to be traced throughout the system in logs and API responses.
        """
        return pulumi.get(self, "error_uuid")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A message containing more information about the error that occurred.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A title that explains the reason for the error.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ForwardSshTunnelConnectivityResponse(dict):
    """
    Forward SSH Tunnel connectivity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardSshTunnelConnectivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardSshTunnelConnectivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardSshTunnelConnectivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 password: str,
                 port: int,
                 private_key: str,
                 username: str):
        """
        Forward SSH Tunnel connectivity.
        :param str hostname: Hostname for the SSH tunnel.
        :param str password: Input only. SSH password.
        :param int port: Port for the SSH tunnel, default value is 22.
        :param str private_key: Input only. SSH private key.
        :param str username: Username for the SSH tunnel.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Input only. SSH password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for the SSH tunnel, default value is 22.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        Input only. SSH private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GcsDestinationConfigResponse(dict):
    """
    Google Cloud Storage destination configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroFileFormat":
            suggest = "avro_file_format"
        elif key == "fileRotationInterval":
            suggest = "file_rotation_interval"
        elif key == "fileRotationMb":
            suggest = "file_rotation_mb"
        elif key == "jsonFileFormat":
            suggest = "json_file_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsDestinationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsDestinationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsDestinationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 avro_file_format: 'outputs.AvroFileFormatResponse',
                 file_rotation_interval: str,
                 file_rotation_mb: int,
                 json_file_format: 'outputs.JsonFileFormatResponse',
                 path: str):
        """
        Google Cloud Storage destination configuration
        :param 'AvroFileFormatResponse' avro_file_format: AVRO file format configuration.
        :param str file_rotation_interval: The maximum duration for which new events are added before a file is closed and a new file is created.
        :param int file_rotation_mb: The maximum file size to be saved in the bucket.
        :param 'JsonFileFormatResponse' json_file_format: JSON file format configuration.
        :param str path: Path inside the Cloud Storage bucket to write data to.
        """
        pulumi.set(__self__, "avro_file_format", avro_file_format)
        pulumi.set(__self__, "file_rotation_interval", file_rotation_interval)
        pulumi.set(__self__, "file_rotation_mb", file_rotation_mb)
        pulumi.set(__self__, "json_file_format", json_file_format)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="avroFileFormat")
    def avro_file_format(self) -> 'outputs.AvroFileFormatResponse':
        """
        AVRO file format configuration.
        """
        return pulumi.get(self, "avro_file_format")

    @property
    @pulumi.getter(name="fileRotationInterval")
    def file_rotation_interval(self) -> str:
        """
        The maximum duration for which new events are added before a file is closed and a new file is created.
        """
        return pulumi.get(self, "file_rotation_interval")

    @property
    @pulumi.getter(name="fileRotationMb")
    def file_rotation_mb(self) -> int:
        """
        The maximum file size to be saved in the bucket.
        """
        return pulumi.get(self, "file_rotation_mb")

    @property
    @pulumi.getter(name="jsonFileFormat")
    def json_file_format(self) -> 'outputs.JsonFileFormatResponse':
        """
        JSON file format configuration.
        """
        return pulumi.get(self, "json_file_format")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path inside the Cloud Storage bucket to write data to.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GcsProfileResponse(dict):
    """
    Cloud Storage bucket profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootPath":
            suggest = "root_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 root_path: str):
        """
        Cloud Storage bucket profile.
        :param str bucket: The Cloud Storage bucket name.
        :param str root_path: The root path inside the Cloud Storage bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "root_path", root_path)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> str:
        """
        The root path inside the Cloud Storage bucket.
        """
        return pulumi.get(self, "root_path")


@pulumi.output_type
class JsonFileFormatResponse(dict):
    """
    JSON file format configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaFileFormat":
            suggest = "schema_file_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JsonFileFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JsonFileFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JsonFileFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression: str,
                 schema_file_format: str):
        """
        JSON file format configuration.
        :param str compression: Compression of the loaded JSON file.
        :param str schema_file_format: The schema file format along JSON data files.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "schema_file_format", schema_file_format)

    @property
    @pulumi.getter
    def compression(self) -> str:
        """
        Compression of the loaded JSON file.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="schemaFileFormat")
    def schema_file_format(self) -> str:
        """
        The schema file format along JSON data files.
        """
        return pulumi.get(self, "schema_file_format")


@pulumi.output_type
class MysqlColumnResponse(dict):
    """
    MySQL Column.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collation: str,
                 column: str,
                 data_type: str,
                 length: int,
                 nullable: bool,
                 ordinal_position: int,
                 primary_key: bool):
        """
        MySQL Column.
        :param str collation: Column collation.
        :param str column: Column name.
        :param str data_type: The MySQL data type. Full data types list can be found here: https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        :param int length: Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param bool primary_key: Whether or not the column represents a primary key.
        """
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "nullable", nullable)
        pulumi.set(__self__, "ordinal_position", ordinal_position)
        pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter
    def collation(self) -> str:
        """
        Column collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        The MySQL data type. Full data types list can be found here: https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> bool:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> int:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> bool:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")


@pulumi.output_type
class MysqlDatabaseResponse(dict):
    """
    MySQL database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlTables":
            suggest = "mysql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDatabaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDatabaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDatabaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 mysql_tables: Sequence['outputs.MysqlTableResponse']):
        """
        MySQL database.
        :param str database: Database name.
        :param Sequence['MysqlTableResponse'] mysql_tables: Tables in the database.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "mysql_tables", mysql_tables)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="mysqlTables")
    def mysql_tables(self) -> Sequence['outputs.MysqlTableResponse']:
        """
        Tables in the database.
        """
        return pulumi.get(self, "mysql_tables")


@pulumi.output_type
class MysqlProfileResponse(dict):
    """
    MySQL database profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslConfig":
            suggest = "ssl_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 password: str,
                 port: int,
                 ssl_config: 'outputs.MysqlSslConfigResponse',
                 username: str):
        """
        MySQL database profile.
        :param str hostname: Hostname for the MySQL connection.
        :param str password: Input only. Password for the MySQL connection.
        :param int port: Port for the MySQL connection, default value is 3306.
        :param 'MysqlSslConfigResponse' ssl_config: SSL configuration for the MySQL connection.
        :param str username: Username for the MySQL connection.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "ssl_config", ssl_config)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the MySQL connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Input only. Password for the MySQL connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for the MySQL connection, default value is 3306.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> 'outputs.MysqlSslConfigResponse':
        """
        SSL configuration for the MySQL connection.
        """
        return pulumi.get(self, "ssl_config")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the MySQL connection.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MysqlRdbmsResponse(dict):
    """
    MySQL database structure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlDatabases":
            suggest = "mysql_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlRdbmsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlRdbmsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlRdbmsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_databases: Sequence['outputs.MysqlDatabaseResponse']):
        """
        MySQL database structure
        :param Sequence['MysqlDatabaseResponse'] mysql_databases: Mysql databases on the server
        """
        pulumi.set(__self__, "mysql_databases", mysql_databases)

    @property
    @pulumi.getter(name="mysqlDatabases")
    def mysql_databases(self) -> Sequence['outputs.MysqlDatabaseResponse']:
        """
        Mysql databases on the server
        """
        return pulumi.get(self, "mysql_databases")


@pulumi.output_type
class MysqlSourceConfigResponse(dict):
    """
    MySQL source configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentCdcTasks":
            suggest = "max_concurrent_cdc_tasks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlSourceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlSourceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlSourceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_objects: 'outputs.MysqlRdbmsResponse',
                 include_objects: 'outputs.MysqlRdbmsResponse',
                 max_concurrent_cdc_tasks: int):
        """
        MySQL source configuration
        :param 'MysqlRdbmsResponse' exclude_objects: MySQL objects to exclude from the stream.
        :param 'MysqlRdbmsResponse' include_objects: MySQL objects to retrieve from the source.
        :param int max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        pulumi.set(__self__, "exclude_objects", exclude_objects)
        pulumi.set(__self__, "include_objects", include_objects)
        pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> 'outputs.MysqlRdbmsResponse':
        """
        MySQL objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> 'outputs.MysqlRdbmsResponse':
        """
        MySQL objects to retrieve from the source.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> int:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")


@pulumi.output_type
class MysqlSslConfigResponse(dict):
    """
    MySQL SSL configuration information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "caCertificateSet":
            suggest = "ca_certificate_set"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientCertificateSet":
            suggest = "client_certificate_set"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clientKeySet":
            suggest = "client_key_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlSslConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlSslConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlSslConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 ca_certificate_set: bool,
                 client_certificate: str,
                 client_certificate_set: bool,
                 client_key: str,
                 client_key_set: bool):
        """
        MySQL SSL configuration information.
        :param str ca_certificate: Input only. PEM-encoded certificate of the CA that signed the source database server's certificate.
        :param bool ca_certificate_set: Indicates whether the ca_certificate field is set.
        :param str client_certificate: Input only. PEM-encoded certificate that will be used by the replica to authenticate against the source database server. If this field is used then the 'client_key' and the 'ca_certificate' fields are mandatory.
        :param bool client_certificate_set: Indicates whether the client_certificate field is set.
        :param str client_key: Input only. PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' and the 'ca_certificate' fields are mandatory.
        :param bool client_key_set: Indicates whether the client_key field is set.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "ca_certificate_set", ca_certificate_set)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_certificate_set", client_certificate_set)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "client_key_set", client_key_set)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Input only. PEM-encoded certificate of the CA that signed the source database server's certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="caCertificateSet")
    def ca_certificate_set(self) -> bool:
        """
        Indicates whether the ca_certificate field is set.
        """
        return pulumi.get(self, "ca_certificate_set")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        Input only. PEM-encoded certificate that will be used by the replica to authenticate against the source database server. If this field is used then the 'client_key' and the 'ca_certificate' fields are mandatory.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateSet")
    def client_certificate_set(self) -> bool:
        """
        Indicates whether the client_certificate field is set.
        """
        return pulumi.get(self, "client_certificate_set")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        Input only. PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' and the 'ca_certificate' fields are mandatory.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clientKeySet")
    def client_key_set(self) -> bool:
        """
        Indicates whether the client_key field is set.
        """
        return pulumi.get(self, "client_key_set")


@pulumi.output_type
class MysqlTableResponse(dict):
    """
    MySQL table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlColumns":
            suggest = "mysql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_columns: Sequence['outputs.MysqlColumnResponse'],
                 table: str):
        """
        MySQL table.
        :param Sequence['MysqlColumnResponse'] mysql_columns: MySQL columns in the database. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param str table: Table name.
        """
        pulumi.set(__self__, "mysql_columns", mysql_columns)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="mysqlColumns")
    def mysql_columns(self) -> Sequence['outputs.MysqlColumnResponse']:
        """
        MySQL columns in the database. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "mysql_columns")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class OracleColumnResponse(dict):
    """
    Oracle Column.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: str,
                 data_type: str,
                 encoding: str,
                 length: int,
                 nullable: bool,
                 ordinal_position: int,
                 precision: int,
                 primary_key: bool,
                 scale: int):
        """
        Oracle Column.
        :param str column: Column name.
        :param str data_type: The Oracle data type.
        :param str encoding: Column encoding.
        :param int length: Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param int precision: Column precision.
        :param bool primary_key: Whether or not the column represents a primary key.
        :param int scale: Column scale.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "nullable", nullable)
        pulumi.set(__self__, "ordinal_position", ordinal_position)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "primary_key", primary_key)
        pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        The Oracle data type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def encoding(self) -> str:
        """
        Column encoding.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> bool:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> int:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> int:
        """
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> bool:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> int:
        """
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class OracleProfileResponse(dict):
    """
    Oracle database profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionAttributes":
            suggest = "connection_attributes"
        elif key == "databaseService":
            suggest = "database_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_attributes: Mapping[str, str],
                 database_service: str,
                 hostname: str,
                 password: str,
                 port: int,
                 username: str):
        """
        Oracle database profile.
        :param Mapping[str, str] connection_attributes: Connection string attributes
        :param str database_service: Database for the Oracle connection.
        :param str hostname: Hostname for the Oracle connection.
        :param str password: Password for the Oracle connection.
        :param int port: Port for the Oracle connection, default value is 1521.
        :param str username: Username for the Oracle connection.
        """
        pulumi.set(__self__, "connection_attributes", connection_attributes)
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionAttributes")
    def connection_attributes(self) -> Mapping[str, str]:
        """
        Connection string attributes
        """
        return pulumi.get(self, "connection_attributes")

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> str:
        """
        Database for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the Oracle connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the Oracle connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for the Oracle connection, default value is 1521.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the Oracle connection.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class OracleRdbmsResponse(dict):
    """
    Oracle database structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleSchemas":
            suggest = "oracle_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleRdbmsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleRdbmsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleRdbmsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_schemas: Sequence['outputs.OracleSchemaResponse']):
        """
        Oracle database structure.
        :param Sequence['OracleSchemaResponse'] oracle_schemas: Oracle schemas/databases in the database server.
        """
        pulumi.set(__self__, "oracle_schemas", oracle_schemas)

    @property
    @pulumi.getter(name="oracleSchemas")
    def oracle_schemas(self) -> Sequence['outputs.OracleSchemaResponse']:
        """
        Oracle schemas/databases in the database server.
        """
        return pulumi.get(self, "oracle_schemas")


@pulumi.output_type
class OracleSchemaResponse(dict):
    """
    Oracle schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleTables":
            suggest = "oracle_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_tables: Sequence['outputs.OracleTableResponse'],
                 schema: str):
        """
        Oracle schema.
        :param Sequence['OracleTableResponse'] oracle_tables: Tables in the schema.
        :param str schema: Schema name.
        """
        pulumi.set(__self__, "oracle_tables", oracle_tables)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="oracleTables")
    def oracle_tables(self) -> Sequence['outputs.OracleTableResponse']:
        """
        Tables in the schema.
        """
        return pulumi.get(self, "oracle_tables")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class OracleSourceConfigResponse(dict):
    """
    Oracle data source configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropLargeObjects":
            suggest = "drop_large_objects"
        elif key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentCdcTasks":
            suggest = "max_concurrent_cdc_tasks"
        elif key == "streamLargeObjects":
            suggest = "stream_large_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleSourceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleSourceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleSourceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drop_large_objects: 'outputs.DropLargeObjectsResponse',
                 exclude_objects: 'outputs.OracleRdbmsResponse',
                 include_objects: 'outputs.OracleRdbmsResponse',
                 max_concurrent_cdc_tasks: int,
                 stream_large_objects: 'outputs.StreamLargeObjectsResponse'):
        """
        Oracle data source configuration
        :param 'DropLargeObjectsResponse' drop_large_objects: Drop large object values.
        :param 'OracleRdbmsResponse' exclude_objects: Oracle objects to exclude from the stream.
        :param 'OracleRdbmsResponse' include_objects: Oracle objects to include in the stream.
        :param int max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        :param 'StreamLargeObjectsResponse' stream_large_objects: Stream large object values.
        """
        pulumi.set(__self__, "drop_large_objects", drop_large_objects)
        pulumi.set(__self__, "exclude_objects", exclude_objects)
        pulumi.set(__self__, "include_objects", include_objects)
        pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)
        pulumi.set(__self__, "stream_large_objects", stream_large_objects)

    @property
    @pulumi.getter(name="dropLargeObjects")
    def drop_large_objects(self) -> 'outputs.DropLargeObjectsResponse':
        """
        Drop large object values.
        """
        return pulumi.get(self, "drop_large_objects")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> 'outputs.OracleRdbmsResponse':
        """
        Oracle objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> 'outputs.OracleRdbmsResponse':
        """
        Oracle objects to include in the stream.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> int:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")

    @property
    @pulumi.getter(name="streamLargeObjects")
    def stream_large_objects(self) -> 'outputs.StreamLargeObjectsResponse':
        """
        Stream large object values.
        """
        return pulumi.get(self, "stream_large_objects")


@pulumi.output_type
class OracleTableResponse(dict):
    """
    Oracle table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleColumns":
            suggest = "oracle_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OracleTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OracleTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OracleTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_columns: Sequence['outputs.OracleColumnResponse'],
                 table: str):
        """
        Oracle table.
        :param Sequence['OracleColumnResponse'] oracle_columns: Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param str table: Table name.
        """
        pulumi.set(__self__, "oracle_columns", oracle_columns)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="oracleColumns")
    def oracle_columns(self) -> Sequence['outputs.OracleColumnResponse']:
        """
        Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "oracle_columns")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class PostgresqlColumnResponse(dict):
    """
    PostgreSQL Column.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: str,
                 data_type: str,
                 length: int,
                 nullable: bool,
                 ordinal_position: int,
                 precision: int,
                 primary_key: bool,
                 scale: int):
        """
        PostgreSQL Column.
        :param str column: Column name.
        :param str data_type: The PostgreSQL data type.
        :param int length: Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param int precision: Column precision.
        :param bool primary_key: Whether or not the column represents a primary key.
        :param int scale: Column scale.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "nullable", nullable)
        pulumi.set(__self__, "ordinal_position", ordinal_position)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "primary_key", primary_key)
        pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        The PostgreSQL data type.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> int:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> bool:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> int:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> int:
        """
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> bool:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> int:
        """
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class PostgresqlProfileResponse(dict):
    """
    PostgreSQL database profile.
    """
    def __init__(__self__, *,
                 database: str,
                 hostname: str,
                 password: str,
                 port: int,
                 username: str):
        """
        PostgreSQL database profile.
        :param str database: Database for the PostgreSQL connection.
        :param str hostname: Hostname for the PostgreSQL connection.
        :param str password: Password for the PostgreSQL connection.
        :param int port: Port for the PostgreSQL connection, default value is 5432.
        :param str username: Username for the PostgreSQL connection.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database for the PostgreSQL connection.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the PostgreSQL connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the PostgreSQL connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for the PostgreSQL connection, default value is 5432.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the PostgreSQL connection.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PostgresqlRdbmsResponse(dict):
    """
    PostgreSQL database structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlSchemas":
            suggest = "postgresql_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlRdbmsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlRdbmsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlRdbmsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_schemas: Sequence['outputs.PostgresqlSchemaResponse']):
        """
        PostgreSQL database structure.
        :param Sequence['PostgresqlSchemaResponse'] postgresql_schemas: PostgreSQL schemas in the database server.
        """
        pulumi.set(__self__, "postgresql_schemas", postgresql_schemas)

    @property
    @pulumi.getter(name="postgresqlSchemas")
    def postgresql_schemas(self) -> Sequence['outputs.PostgresqlSchemaResponse']:
        """
        PostgreSQL schemas in the database server.
        """
        return pulumi.get(self, "postgresql_schemas")


@pulumi.output_type
class PostgresqlSchemaResponse(dict):
    """
    PostgreSQL schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlTables":
            suggest = "postgresql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_tables: Sequence['outputs.PostgresqlTableResponse'],
                 schema: str):
        """
        PostgreSQL schema.
        :param Sequence['PostgresqlTableResponse'] postgresql_tables: Tables in the schema.
        :param str schema: Schema name.
        """
        pulumi.set(__self__, "postgresql_tables", postgresql_tables)
        pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="postgresqlTables")
    def postgresql_tables(self) -> Sequence['outputs.PostgresqlTableResponse']:
        """
        Tables in the schema.
        """
        return pulumi.get(self, "postgresql_tables")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class PostgresqlSourceConfigResponse(dict):
    """
    PostgreSQL data source configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "replicationSlot":
            suggest = "replication_slot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlSourceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlSourceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlSourceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_objects: 'outputs.PostgresqlRdbmsResponse',
                 include_objects: 'outputs.PostgresqlRdbmsResponse',
                 publication: str,
                 replication_slot: str):
        """
        PostgreSQL data source configuration
        :param 'PostgresqlRdbmsResponse' exclude_objects: PostgreSQL objects to exclude from the stream.
        :param 'PostgresqlRdbmsResponse' include_objects: PostgreSQL objects to include in the stream.
        :param str publication: The name of the publication that includes the set of all tables that are defined in the stream's include_objects.
        :param str replication_slot: The name of the logical replication slot that's configured with the pgoutput plugin.
        """
        pulumi.set(__self__, "exclude_objects", exclude_objects)
        pulumi.set(__self__, "include_objects", include_objects)
        pulumi.set(__self__, "publication", publication)
        pulumi.set(__self__, "replication_slot", replication_slot)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> 'outputs.PostgresqlRdbmsResponse':
        """
        PostgreSQL objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> 'outputs.PostgresqlRdbmsResponse':
        """
        PostgreSQL objects to include in the stream.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter
    def publication(self) -> str:
        """
        The name of the publication that includes the set of all tables that are defined in the stream's include_objects.
        """
        return pulumi.get(self, "publication")

    @property
    @pulumi.getter(name="replicationSlot")
    def replication_slot(self) -> str:
        """
        The name of the logical replication slot that's configured with the pgoutput plugin.
        """
        return pulumi.get(self, "replication_slot")


@pulumi.output_type
class PostgresqlTableResponse(dict):
    """
    PostgreSQL table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlColumns":
            suggest = "postgresql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgresqlTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgresqlTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgresqlTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_columns: Sequence['outputs.PostgresqlColumnResponse'],
                 table: str):
        """
        PostgreSQL table.
        :param Sequence['PostgresqlColumnResponse'] postgresql_columns: PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param str table: Table name.
        """
        pulumi.set(__self__, "postgresql_columns", postgresql_columns)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="postgresqlColumns")
    def postgresql_columns(self) -> Sequence['outputs.PostgresqlColumnResponse']:
        """
        PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "postgresql_columns")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class PrivateConnectivityResponse(dict):
    """
    Private Connectivity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateConnection":
            suggest = "private_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateConnectivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateConnectivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateConnectivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_connection: str):
        """
        Private Connectivity
        :param str private_connection: A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> str:
        """
        A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        return pulumi.get(self, "private_connection")


@pulumi.output_type
class SingleTargetDatasetResponse(dict):
    """
    A single target dataset to which all data will be streamed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleTargetDatasetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleTargetDatasetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleTargetDatasetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str):
        """
        A single target dataset to which all data will be streamed.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class SourceConfigResponse(dict):
    """
    The configuration of the stream source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlSourceConfig":
            suggest = "mysql_source_config"
        elif key == "oracleSourceConfig":
            suggest = "oracle_source_config"
        elif key == "postgresqlSourceConfig":
            suggest = "postgresql_source_config"
        elif key == "sourceConnectionProfile":
            suggest = "source_connection_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_source_config: 'outputs.MysqlSourceConfigResponse',
                 oracle_source_config: 'outputs.OracleSourceConfigResponse',
                 postgresql_source_config: 'outputs.PostgresqlSourceConfigResponse',
                 source_connection_profile: str):
        """
        The configuration of the stream source.
        :param 'MysqlSourceConfigResponse' mysql_source_config: MySQL data source configuration.
        :param 'OracleSourceConfigResponse' oracle_source_config: Oracle data source configuration.
        :param 'PostgresqlSourceConfigResponse' postgresql_source_config: PostgreSQL data source configuration.
        :param str source_connection_profile: Source connection profile resoource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        """
        pulumi.set(__self__, "mysql_source_config", mysql_source_config)
        pulumi.set(__self__, "oracle_source_config", oracle_source_config)
        pulumi.set(__self__, "postgresql_source_config", postgresql_source_config)
        pulumi.set(__self__, "source_connection_profile", source_connection_profile)

    @property
    @pulumi.getter(name="mysqlSourceConfig")
    def mysql_source_config(self) -> 'outputs.MysqlSourceConfigResponse':
        """
        MySQL data source configuration.
        """
        return pulumi.get(self, "mysql_source_config")

    @property
    @pulumi.getter(name="oracleSourceConfig")
    def oracle_source_config(self) -> 'outputs.OracleSourceConfigResponse':
        """
        Oracle data source configuration.
        """
        return pulumi.get(self, "oracle_source_config")

    @property
    @pulumi.getter(name="postgresqlSourceConfig")
    def postgresql_source_config(self) -> 'outputs.PostgresqlSourceConfigResponse':
        """
        PostgreSQL data source configuration.
        """
        return pulumi.get(self, "postgresql_source_config")

    @property
    @pulumi.getter(name="sourceConnectionProfile")
    def source_connection_profile(self) -> str:
        """
        Source connection profile resoource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        """
        return pulumi.get(self, "source_connection_profile")


@pulumi.output_type
class SourceHierarchyDatasetsResponse(dict):
    """
    Destination datasets are created so that hierarchy of the destination data objects matches the source hierarchy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetTemplate":
            suggest = "dataset_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceHierarchyDatasetsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceHierarchyDatasetsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceHierarchyDatasetsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_template: 'outputs.DatasetTemplateResponse'):
        """
        Destination datasets are created so that hierarchy of the destination data objects matches the source hierarchy.
        """
        pulumi.set(__self__, "dataset_template", dataset_template)

    @property
    @pulumi.getter(name="datasetTemplate")
    def dataset_template(self) -> 'outputs.DatasetTemplateResponse':
        return pulumi.get(self, "dataset_template")


@pulumi.output_type
class StaticServiceIpConnectivityResponse(dict):
    """
    Static IP address connectivity.
    """
    def __init__(__self__):
        """
        Static IP address connectivity.
        """
        pass


@pulumi.output_type
class StreamLargeObjectsResponse(dict):
    """
    Configuration to stream large object values.
    """
    def __init__(__self__):
        """
        Configuration to stream large object values.
        """
        pass


@pulumi.output_type
class VpcPeeringConfigResponse(dict):
    """
    The VPC Peering configuration is used to create VPC peering between Datastream and the consumer's VPC.
    """
    def __init__(__self__, *,
                 subnet: str,
                 vpc: str):
        """
        The VPC Peering configuration is used to create VPC peering between Datastream and the consumer's VPC.
        :param str subnet: A free subnet for peering. (CIDR of /29)
        :param str vpc: Fully qualified name of the VPC that Datastream will peer to. Format: `projects/{project}/global/{networks}/{name}`
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        A free subnet for peering. (CIDR of /29)
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        Fully qualified name of the VPC that Datastream will peer to. Format: `projects/{project}/global/{networks}/{name}`
        """
        return pulumi.get(self, "vpc")


