# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    def __init__(__self__, asset_status=None, create_time=None, description=None, discovery_spec=None, display_name=None, labels=None, name=None, resource_spec=None, state=None, type=None, uid=None, update_time=None):
        if asset_status and not isinstance(asset_status, dict):
            raise TypeError("Expected argument 'asset_status' to be a dict")
        pulumi.set(__self__, "asset_status", asset_status)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if discovery_spec and not isinstance(discovery_spec, dict):
            raise TypeError("Expected argument 'discovery_spec' to be a dict")
        pulumi.set(__self__, "discovery_spec", discovery_spec)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_spec and not isinstance(resource_spec, dict):
            raise TypeError("Expected argument 'resource_spec' to be a dict")
        pulumi.set(__self__, "resource_spec", resource_spec)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="assetStatus")
    def asset_status(self) -> 'outputs.GoogleCloudDataplexV1AssetStatusResponse':
        """
        Aggregated status of the underlying assets of the zone.
        """
        return pulumi.get(self, "asset_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the zone was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the zone.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoverySpec")
    def discovery_spec(self) -> 'outputs.GoogleCloudDataplexV1ZoneDiscoverySpecResponse':
        """
        Optional. Specification of the discovery feature applied to data in this zone.
        """
        return pulumi.get(self, "discovery_spec")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. User defined labels for the zone.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The relative resource name of the zone, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSpec")
    def resource_spec(self) -> 'outputs.GoogleCloudDataplexV1ZoneResourceSpecResponse':
        """
        Specification of the resources that are referenced by the assets within this zone.
        """
        return pulumi.get(self, "resource_spec")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the zone.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Immutable. The type of the zone.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        System generated globally unique ID for the zone. This ID will be different if the zone is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the zone was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            asset_status=self.asset_status,
            create_time=self.create_time,
            description=self.description,
            discovery_spec=self.discovery_spec,
            display_name=self.display_name,
            labels=self.labels,
            name=self.name,
            resource_spec=self.resource_spec,
            state=self.state,
            type=self.type,
            uid=self.uid,
            update_time=self.update_time)


def get_zone(lake_id: Optional[str] = None,
             location: Optional[str] = None,
             project: Optional[str] = None,
             zone: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    Retrieves a zone resource.
    """
    __args__ = dict()
    __args__['lakeId'] = lake_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataplex/v1:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        asset_status=__ret__.asset_status,
        create_time=__ret__.create_time,
        description=__ret__.description,
        discovery_spec=__ret__.discovery_spec,
        display_name=__ret__.display_name,
        labels=__ret__.labels,
        name=__ret__.name,
        resource_spec=__ret__.resource_spec,
        state=__ret__.state,
        type=__ret__.type,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_zone)
def get_zone_output(lake_id: Optional[pulumi.Input[str]] = None,
                    location: Optional[pulumi.Input[str]] = None,
                    project: Optional[pulumi.Input[Optional[str]]] = None,
                    zone: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetZoneResult]:
    """
    Retrieves a zone resource.
    """
    ...
