# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAssetResult',
    'AwaitableGetAssetResult',
    'get_asset',
    'get_asset_output',
]

@pulumi.output_type
class GetAssetResult:
    def __init__(__self__, create_time=None, description=None, discovery_spec=None, discovery_status=None, display_name=None, labels=None, name=None, resource_spec=None, resource_status=None, security_status=None, state=None, uid=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if discovery_spec and not isinstance(discovery_spec, dict):
            raise TypeError("Expected argument 'discovery_spec' to be a dict")
        pulumi.set(__self__, "discovery_spec", discovery_spec)
        if discovery_status and not isinstance(discovery_status, dict):
            raise TypeError("Expected argument 'discovery_status' to be a dict")
        pulumi.set(__self__, "discovery_status", discovery_status)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_spec and not isinstance(resource_spec, dict):
            raise TypeError("Expected argument 'resource_spec' to be a dict")
        pulumi.set(__self__, "resource_spec", resource_spec)
        if resource_status and not isinstance(resource_status, dict):
            raise TypeError("Expected argument 'resource_status' to be a dict")
        pulumi.set(__self__, "resource_status", resource_status)
        if security_status and not isinstance(security_status, dict):
            raise TypeError("Expected argument 'security_status' to be a dict")
        pulumi.set(__self__, "security_status", security_status)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the asset was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the asset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoverySpec")
    def discovery_spec(self) -> 'outputs.GoogleCloudDataplexV1AssetDiscoverySpecResponse':
        """
        Optional. Specification of the discovery feature applied to data referenced by this asset. When this spec is left unset, the asset will use the spec set on the parent zone.
        """
        return pulumi.get(self, "discovery_spec")

    @property
    @pulumi.getter(name="discoveryStatus")
    def discovery_status(self) -> 'outputs.GoogleCloudDataplexV1AssetDiscoveryStatusResponse':
        """
        Status of the discovery feature applied to data referenced by this asset.
        """
        return pulumi.get(self, "discovery_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. User defined labels for the asset.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The relative resource name of the asset, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceSpec")
    def resource_spec(self) -> 'outputs.GoogleCloudDataplexV1AssetResourceSpecResponse':
        """
        Specification of the resource that is referenced by this asset.
        """
        return pulumi.get(self, "resource_spec")

    @property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> 'outputs.GoogleCloudDataplexV1AssetResourceStatusResponse':
        """
        Status of the resource referenced by this asset.
        """
        return pulumi.get(self, "resource_status")

    @property
    @pulumi.getter(name="securityStatus")
    def security_status(self) -> 'outputs.GoogleCloudDataplexV1AssetSecurityStatusResponse':
        """
        Status of the security policy applied to resource referenced by this asset.
        """
        return pulumi.get(self, "security_status")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        System generated globally unique ID for the asset. This ID will be different if the asset is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the asset was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetAssetResult(GetAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetResult(
            create_time=self.create_time,
            description=self.description,
            discovery_spec=self.discovery_spec,
            discovery_status=self.discovery_status,
            display_name=self.display_name,
            labels=self.labels,
            name=self.name,
            resource_spec=self.resource_spec,
            resource_status=self.resource_status,
            security_status=self.security_status,
            state=self.state,
            uid=self.uid,
            update_time=self.update_time)


def get_asset(asset_id: Optional[str] = None,
              lake_id: Optional[str] = None,
              location: Optional[str] = None,
              project: Optional[str] = None,
              zone: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetResult:
    """
    Retrieves an asset resource.
    """
    __args__ = dict()
    __args__['assetId'] = asset_id
    __args__['lakeId'] = lake_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataplex/v1:getAsset', __args__, opts=opts, typ=GetAssetResult).value

    return AwaitableGetAssetResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        discovery_spec=__ret__.discovery_spec,
        discovery_status=__ret__.discovery_status,
        display_name=__ret__.display_name,
        labels=__ret__.labels,
        name=__ret__.name,
        resource_spec=__ret__.resource_spec,
        resource_status=__ret__.resource_status,
        security_status=__ret__.security_status,
        state=__ret__.state,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_asset)
def get_asset_output(asset_id: Optional[pulumi.Input[str]] = None,
                     lake_id: Optional[pulumi.Input[str]] = None,
                     location: Optional[pulumi.Input[str]] = None,
                     project: Optional[pulumi.Input[Optional[str]]] = None,
                     zone: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssetResult]:
    """
    Retrieves an asset resource.
    """
    ...
