# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CompositeFilterArgs',
    'DataSourceRestrictionArgs',
    'DateArgs',
    'FacetOptionsArgs',
    'FilterOptionsArgs',
    'FilterArgs',
    'GSuitePrincipalArgs',
    'QueryInterpretationConfigArgs',
    'ScoringConfigArgs',
    'SortOptionsArgs',
    'SourceConfigArgs',
    'SourceCrowdingConfigArgs',
    'SourceScoringConfigArgs',
    'SourceArgs',
    'ValueFilterArgs',
    'ValueArgs',
]

@pulumi.input_type
class CompositeFilterArgs:
    def __init__(__self__, *,
                 logic_operator: Optional[pulumi.Input['CompositeFilterLogicOperator']] = None,
                 sub_filters: Optional[pulumi.Input[Sequence[pulumi.Input['FilterArgs']]]] = None):
        """
        :param pulumi.Input['CompositeFilterLogicOperator'] logic_operator: The logic operator of the sub filter.
        :param pulumi.Input[Sequence[pulumi.Input['FilterArgs']]] sub_filters: Sub filters.
        """
        if logic_operator is not None:
            pulumi.set(__self__, "logic_operator", logic_operator)
        if sub_filters is not None:
            pulumi.set(__self__, "sub_filters", sub_filters)

    @property
    @pulumi.getter(name="logicOperator")
    def logic_operator(self) -> Optional[pulumi.Input['CompositeFilterLogicOperator']]:
        """
        The logic operator of the sub filter.
        """
        return pulumi.get(self, "logic_operator")

    @logic_operator.setter
    def logic_operator(self, value: Optional[pulumi.Input['CompositeFilterLogicOperator']]):
        pulumi.set(self, "logic_operator", value)

    @property
    @pulumi.getter(name="subFilters")
    def sub_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FilterArgs']]]]:
        """
        Sub filters.
        """
        return pulumi.get(self, "sub_filters")

    @sub_filters.setter
    def sub_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FilterArgs']]]]):
        pulumi.set(self, "sub_filters", value)


@pulumi.input_type
class DataSourceRestrictionArgs:
    def __init__(__self__, *,
                 filter_options: Optional[pulumi.Input[Sequence[pulumi.Input['FilterOptionsArgs']]]] = None,
                 source: Optional[pulumi.Input['SourceArgs']] = None):
        """
        Restriction on Datasource.
        :param pulumi.Input[Sequence[pulumi.Input['FilterOptionsArgs']]] filter_options: Filter options restricting the results. If multiple filters are present, they are grouped by object type before joining. Filters with the same object type are joined conjunctively, then the resulting expressions are joined disjunctively. The maximum number of elements is 20. NOTE: Suggest API supports only few filters at the moment: "objecttype", "type" and "mimetype". For now, schema specific filters cannot be used to filter suggestions.
        :param pulumi.Input['SourceArgs'] source: The source of restriction.
        """
        if filter_options is not None:
            pulumi.set(__self__, "filter_options", filter_options)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="filterOptions")
    def filter_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FilterOptionsArgs']]]]:
        """
        Filter options restricting the results. If multiple filters are present, they are grouped by object type before joining. Filters with the same object type are joined conjunctively, then the resulting expressions are joined disjunctively. The maximum number of elements is 20. NOTE: Suggest API supports only few filters at the moment: "objecttype", "type" and "mimetype". For now, schema specific filters cannot be used to filter suggestions.
        """
        return pulumi.get(self, "filter_options")

    @filter_options.setter
    def filter_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FilterOptionsArgs']]]]):
        pulumi.set(self, "filter_options", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        The source of restriction.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class DateArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 month: Optional[pulumi.Input[int]] = None,
                 year: Optional[pulumi.Input[int]] = None):
        """
        Represents a whole calendar date, for example a date of birth. The time of day and time zone are either specified elsewhere or are not significant. The date is relative to the [Proleptic Gregorian Calendar](https://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar). The date must be a valid calendar date between the year 1 and 9999.
        :param pulumi.Input[int] day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param pulumi.Input[int] month: Month of date. Must be from 1 to 12.
        :param pulumi.Input[int] year: Year of date. Must be from 1 to 9999.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if year is not None:
            pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def month(self) -> Optional[pulumi.Input[int]]:
        """
        Month of date. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter
    def year(self) -> Optional[pulumi.Input[int]]:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")

    @year.setter
    def year(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "year", value)


@pulumi.input_type
class FacetOptionsArgs:
    def __init__(__self__, *,
                 num_facet_buckets: Optional[pulumi.Input[int]] = None,
                 object_type: Optional[pulumi.Input[str]] = None,
                 operator_name: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None):
        """
        Specifies operators to return facet results for. There will be one FacetResult for every source_name/object_type/operator_name combination.
        :param pulumi.Input[int] num_facet_buckets: Maximum number of facet buckets that should be returned for this facet. Defaults to 10. Maximum value is 100.
        :param pulumi.Input[str] object_type: If object_type is set, only those objects of that type will be used to compute facets. If empty, then all objects will be used to compute facets.
        :param pulumi.Input[str] operator_name: The name of the operator chosen for faceting. @see cloudsearch.SchemaPropertyOptions
        :param pulumi.Input[str] source_name: Source name to facet on. Format: datasources/{source_id} If empty, all data sources will be used.
        """
        if num_facet_buckets is not None:
            pulumi.set(__self__, "num_facet_buckets", num_facet_buckets)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if operator_name is not None:
            pulumi.set(__self__, "operator_name", operator_name)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="numFacetBuckets")
    def num_facet_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of facet buckets that should be returned for this facet. Defaults to 10. Maximum value is 100.
        """
        return pulumi.get(self, "num_facet_buckets")

    @num_facet_buckets.setter
    def num_facet_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_facet_buckets", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[str]]:
        """
        If object_type is set, only those objects of that type will be used to compute facets. If empty, then all objects will be used to compute facets.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_type", value)

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the operator chosen for faceting. @see cloudsearch.SchemaPropertyOptions
        """
        return pulumi.get(self, "operator_name")

    @operator_name.setter
    def operator_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator_name", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Source name to facet on. Format: datasources/{source_id} If empty, all data sources will be used.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)


@pulumi.input_type
class FilterOptionsArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input['FilterArgs']] = None,
                 object_type: Optional[pulumi.Input[str]] = None):
        """
        Filter options to be applied on query.
        :param pulumi.Input['FilterArgs'] filter: Generic filter to restrict the search, such as `lang:en`, `site:xyz`.
        :param pulumi.Input[str] object_type: If object_type is set, only objects of that type are returned. This should correspond to the name of the object that was registered within the definition of schema. The maximum length is 256 characters.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['FilterArgs']]:
        """
        Generic filter to restrict the search, such as `lang:en`, `site:xyz`.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['FilterArgs']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[str]]:
        """
        If object_type is set, only objects of that type are returned. This should correspond to the name of the object that was registered within the definition of schema. The maximum length is 256 characters.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_type", value)


@pulumi.input_type
class FilterArgs:
    def __init__(__self__, *,
                 composite_filter: Optional[pulumi.Input['CompositeFilterArgs']] = None,
                 value_filter: Optional[pulumi.Input['ValueFilterArgs']] = None):
        """
        A generic way of expressing filters in a query, which supports two approaches: **1. Setting a ValueFilter.** The name must match an operator_name defined in the schema for your data source. **2. Setting a CompositeFilter.** The filters are evaluated using the logical operator. The top-level operators can only be either an AND or a NOT. AND can appear only at the top-most level. OR can appear only under a top-level AND.
        """
        if composite_filter is not None:
            pulumi.set(__self__, "composite_filter", composite_filter)
        if value_filter is not None:
            pulumi.set(__self__, "value_filter", value_filter)

    @property
    @pulumi.getter(name="compositeFilter")
    def composite_filter(self) -> Optional[pulumi.Input['CompositeFilterArgs']]:
        return pulumi.get(self, "composite_filter")

    @composite_filter.setter
    def composite_filter(self, value: Optional[pulumi.Input['CompositeFilterArgs']]):
        pulumi.set(self, "composite_filter", value)

    @property
    @pulumi.getter(name="valueFilter")
    def value_filter(self) -> Optional[pulumi.Input['ValueFilterArgs']]:
        return pulumi.get(self, "value_filter")

    @value_filter.setter
    def value_filter(self, value: Optional[pulumi.Input['ValueFilterArgs']]):
        pulumi.set(self, "value_filter", value)


@pulumi.input_type
class GSuitePrincipalArgs:
    def __init__(__self__, *,
                 gsuite_domain: Optional[pulumi.Input[bool]] = None,
                 gsuite_group_email: Optional[pulumi.Input[str]] = None,
                 gsuite_user_email: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] gsuite_domain: This principal represents all users of the Google Workspace domain of the customer.
        :param pulumi.Input[str] gsuite_group_email: This principal references a Google Workspace group name.
        :param pulumi.Input[str] gsuite_user_email: This principal references a Google Workspace user account.
        """
        if gsuite_domain is not None:
            pulumi.set(__self__, "gsuite_domain", gsuite_domain)
        if gsuite_group_email is not None:
            pulumi.set(__self__, "gsuite_group_email", gsuite_group_email)
        if gsuite_user_email is not None:
            pulumi.set(__self__, "gsuite_user_email", gsuite_user_email)

    @property
    @pulumi.getter(name="gsuiteDomain")
    def gsuite_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        This principal represents all users of the Google Workspace domain of the customer.
        """
        return pulumi.get(self, "gsuite_domain")

    @gsuite_domain.setter
    def gsuite_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gsuite_domain", value)

    @property
    @pulumi.getter(name="gsuiteGroupEmail")
    def gsuite_group_email(self) -> Optional[pulumi.Input[str]]:
        """
        This principal references a Google Workspace group name.
        """
        return pulumi.get(self, "gsuite_group_email")

    @gsuite_group_email.setter
    def gsuite_group_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gsuite_group_email", value)

    @property
    @pulumi.getter(name="gsuiteUserEmail")
    def gsuite_user_email(self) -> Optional[pulumi.Input[str]]:
        """
        This principal references a Google Workspace user account.
        """
        return pulumi.get(self, "gsuite_user_email")

    @gsuite_user_email.setter
    def gsuite_user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gsuite_user_email", value)


@pulumi.input_type
class QueryInterpretationConfigArgs:
    def __init__(__self__, *,
                 force_disable_supplemental_results: Optional[pulumi.Input[bool]] = None,
                 force_verbatim_mode: Optional[pulumi.Input[bool]] = None):
        """
        Default options to interpret user query.
        :param pulumi.Input[bool] force_disable_supplemental_results: Set this flag to disable supplemental results retrieval, setting a flag here will not retrieve supplemental results for queries associated with a given search application. If this flag is set to True, it will take precedence over the option set at Query level. For the default value of False, query level flag will set the correct interpretation for supplemental results.
        :param pulumi.Input[bool] force_verbatim_mode: Enable this flag to turn off all internal optimizations like natural language (NL) interpretation of queries, supplemental results retrieval, and usage of synonyms including custom ones. If this flag is set to True, it will take precedence over the option set at Query level. For the default value of False, query level flag will set the correct interpretation for verbatim mode.
        """
        if force_disable_supplemental_results is not None:
            pulumi.set(__self__, "force_disable_supplemental_results", force_disable_supplemental_results)
        if force_verbatim_mode is not None:
            pulumi.set(__self__, "force_verbatim_mode", force_verbatim_mode)

    @property
    @pulumi.getter(name="forceDisableSupplementalResults")
    def force_disable_supplemental_results(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this flag to disable supplemental results retrieval, setting a flag here will not retrieve supplemental results for queries associated with a given search application. If this flag is set to True, it will take precedence over the option set at Query level. For the default value of False, query level flag will set the correct interpretation for supplemental results.
        """
        return pulumi.get(self, "force_disable_supplemental_results")

    @force_disable_supplemental_results.setter
    def force_disable_supplemental_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_disable_supplemental_results", value)

    @property
    @pulumi.getter(name="forceVerbatimMode")
    def force_verbatim_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this flag to turn off all internal optimizations like natural language (NL) interpretation of queries, supplemental results retrieval, and usage of synonyms including custom ones. If this flag is set to True, it will take precedence over the option set at Query level. For the default value of False, query level flag will set the correct interpretation for verbatim mode.
        """
        return pulumi.get(self, "force_verbatim_mode")

    @force_verbatim_mode.setter
    def force_verbatim_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_verbatim_mode", value)


@pulumi.input_type
class ScoringConfigArgs:
    def __init__(__self__, *,
                 disable_freshness: Optional[pulumi.Input[bool]] = None,
                 disable_personalization: Optional[pulumi.Input[bool]] = None):
        """
        Scoring configurations for a source while processing a Search or Suggest request.
        :param pulumi.Input[bool] disable_freshness: Whether to use freshness as a ranking signal. By default, freshness is used as a ranking signal. Note that this setting is not available in the Admin UI.
        :param pulumi.Input[bool] disable_personalization: Whether to personalize the results. By default, personal signals will be used to boost results.
        """
        if disable_freshness is not None:
            pulumi.set(__self__, "disable_freshness", disable_freshness)
        if disable_personalization is not None:
            pulumi.set(__self__, "disable_personalization", disable_personalization)

    @property
    @pulumi.getter(name="disableFreshness")
    def disable_freshness(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use freshness as a ranking signal. By default, freshness is used as a ranking signal. Note that this setting is not available in the Admin UI.
        """
        return pulumi.get(self, "disable_freshness")

    @disable_freshness.setter
    def disable_freshness(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_freshness", value)

    @property
    @pulumi.getter(name="disablePersonalization")
    def disable_personalization(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to personalize the results. By default, personal signals will be used to boost results.
        """
        return pulumi.get(self, "disable_personalization")

    @disable_personalization.setter
    def disable_personalization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_personalization", value)


@pulumi.input_type
class SortOptionsArgs:
    def __init__(__self__, *,
                 operator_name: Optional[pulumi.Input[str]] = None,
                 sort_order: Optional[pulumi.Input['SortOptionsSortOrder']] = None):
        """
        :param pulumi.Input[str] operator_name: The name of the operator corresponding to the field to sort on. The corresponding property must be marked as sortable.
        :param pulumi.Input['SortOptionsSortOrder'] sort_order: Ascending is the default sort order
        """
        if operator_name is not None:
            pulumi.set(__self__, "operator_name", operator_name)
        if sort_order is not None:
            pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the operator corresponding to the field to sort on. The corresponding property must be marked as sortable.
        """
        return pulumi.get(self, "operator_name")

    @operator_name.setter
    def operator_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator_name", value)

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[pulumi.Input['SortOptionsSortOrder']]:
        """
        Ascending is the default sort order
        """
        return pulumi.get(self, "sort_order")

    @sort_order.setter
    def sort_order(self, value: Optional[pulumi.Input['SortOptionsSortOrder']]):
        pulumi.set(self, "sort_order", value)


@pulumi.input_type
class SourceConfigArgs:
    def __init__(__self__, *,
                 crowding_config: Optional[pulumi.Input['SourceCrowdingConfigArgs']] = None,
                 scoring_config: Optional[pulumi.Input['SourceScoringConfigArgs']] = None,
                 source: Optional[pulumi.Input['SourceArgs']] = None):
        """
        Configurations for a source while processing a Search or Suggest request.
        :param pulumi.Input['SourceCrowdingConfigArgs'] crowding_config: The crowding configuration for the source.
        :param pulumi.Input['SourceScoringConfigArgs'] scoring_config: The scoring configuration for the source.
        :param pulumi.Input['SourceArgs'] source: The source for which this configuration is to be used.
        """
        if crowding_config is not None:
            pulumi.set(__self__, "crowding_config", crowding_config)
        if scoring_config is not None:
            pulumi.set(__self__, "scoring_config", scoring_config)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="crowdingConfig")
    def crowding_config(self) -> Optional[pulumi.Input['SourceCrowdingConfigArgs']]:
        """
        The crowding configuration for the source.
        """
        return pulumi.get(self, "crowding_config")

    @crowding_config.setter
    def crowding_config(self, value: Optional[pulumi.Input['SourceCrowdingConfigArgs']]):
        pulumi.set(self, "crowding_config", value)

    @property
    @pulumi.getter(name="scoringConfig")
    def scoring_config(self) -> Optional[pulumi.Input['SourceScoringConfigArgs']]:
        """
        The scoring configuration for the source.
        """
        return pulumi.get(self, "scoring_config")

    @scoring_config.setter
    def scoring_config(self, value: Optional[pulumi.Input['SourceScoringConfigArgs']]):
        pulumi.set(self, "scoring_config", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        The source for which this configuration is to be used.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class SourceCrowdingConfigArgs:
    def __init__(__self__, *,
                 num_results: Optional[pulumi.Input[int]] = None,
                 num_suggestions: Optional[pulumi.Input[int]] = None):
        """
        Set search results crowding limits. Crowding is a situation in which multiple results from the same source or host "crowd out" other results, diminishing the quality of search for users. To foster better search quality and source diversity in search results, you can set a condition to reduce repetitive results by source.
        :param pulumi.Input[int] num_results: Maximum number of results allowed from a datasource in a result page as long as results from other sources are not exhausted. Value specified must not be negative. A default value is used if this value is equal to 0. To disable crowding, set the value greater than 100.
        :param pulumi.Input[int] num_suggestions: Maximum number of suggestions allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        """
        if num_results is not None:
            pulumi.set(__self__, "num_results", num_results)
        if num_suggestions is not None:
            pulumi.set(__self__, "num_suggestions", num_suggestions)

    @property
    @pulumi.getter(name="numResults")
    def num_results(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of results allowed from a datasource in a result page as long as results from other sources are not exhausted. Value specified must not be negative. A default value is used if this value is equal to 0. To disable crowding, set the value greater than 100.
        """
        return pulumi.get(self, "num_results")

    @num_results.setter
    def num_results(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_results", value)

    @property
    @pulumi.getter(name="numSuggestions")
    def num_suggestions(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of suggestions allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        """
        return pulumi.get(self, "num_suggestions")

    @num_suggestions.setter
    def num_suggestions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_suggestions", value)


@pulumi.input_type
class SourceScoringConfigArgs:
    def __init__(__self__, *,
                 source_importance: Optional[pulumi.Input['SourceScoringConfigSourceImportance']] = None):
        """
        Set the scoring configuration. This allows modifying the ranking of results for a source.
        :param pulumi.Input['SourceScoringConfigSourceImportance'] source_importance: Importance of the source.
        """
        if source_importance is not None:
            pulumi.set(__self__, "source_importance", source_importance)

    @property
    @pulumi.getter(name="sourceImportance")
    def source_importance(self) -> Optional[pulumi.Input['SourceScoringConfigSourceImportance']]:
        """
        Importance of the source.
        """
        return pulumi.get(self, "source_importance")

    @source_importance.setter
    def source_importance(self, value: Optional[pulumi.Input['SourceScoringConfigSourceImportance']]):
        pulumi.set(self, "source_importance", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 predefined_source: Optional[pulumi.Input['SourcePredefinedSource']] = None):
        """
        Defines sources for the suggest/search APIs.
        :param pulumi.Input[str] name: Source name for content indexed by the Indexing API.
        :param pulumi.Input['SourcePredefinedSource'] predefined_source: Predefined content source for Google Apps.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if predefined_source is not None:
            pulumi.set(__self__, "predefined_source", predefined_source)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Source name for content indexed by the Indexing API.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="predefinedSource")
    def predefined_source(self) -> Optional[pulumi.Input['SourcePredefinedSource']]:
        """
        Predefined content source for Google Apps.
        """
        return pulumi.get(self, "predefined_source")

    @predefined_source.setter
    def predefined_source(self, value: Optional[pulumi.Input['SourcePredefinedSource']]):
        pulumi.set(self, "predefined_source", value)


@pulumi.input_type
class ValueFilterArgs:
    def __init__(__self__, *,
                 operator_name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input['ValueArgs']] = None):
        """
        :param pulumi.Input[str] operator_name: The `operator_name` applied to the query, such as *price_greater_than*. The filter can work against both types of filters defined in the schema for your data source: 1. `operator_name`, where the query filters results by the property that matches the value. 2. `greater_than_operator_name` or `less_than_operator_name` in your schema. The query filters the results for the property values that are greater than or less than the supplied value in the query.
        :param pulumi.Input['ValueArgs'] value: The value to be compared with.
        """
        if operator_name is not None:
            pulumi.set(__self__, "operator_name", operator_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> Optional[pulumi.Input[str]]:
        """
        The `operator_name` applied to the query, such as *price_greater_than*. The filter can work against both types of filters defined in the schema for your data source: 1. `operator_name`, where the query filters results by the property that matches the value. 2. `greater_than_operator_name` or `less_than_operator_name` in your schema. The query filters the results for the property values that are greater than or less than the supplied value in the query.
        """
        return pulumi.get(self, "operator_name")

    @operator_name.setter
    def operator_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator_name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['ValueArgs']]:
        """
        The value to be compared with.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['ValueArgs']]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ValueArgs:
    def __init__(__self__, *,
                 boolean_value: Optional[pulumi.Input[bool]] = None,
                 date_value: Optional[pulumi.Input['DateArgs']] = None,
                 double_value: Optional[pulumi.Input[float]] = None,
                 integer_value: Optional[pulumi.Input[str]] = None,
                 string_value: Optional[pulumi.Input[str]] = None,
                 timestamp_value: Optional[pulumi.Input[str]] = None):
        """
        Definition of a single value with generic type.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if date_value is not None:
            pulumi.set(__self__, "date_value", date_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)
        if timestamp_value is not None:
            pulumi.set(__self__, "timestamp_value", timestamp_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "boolean_value")

    @boolean_value.setter
    def boolean_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boolean_value", value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> Optional[pulumi.Input['DateArgs']]:
        return pulumi.get(self, "date_value")

    @date_value.setter
    def date_value(self, value: Optional[pulumi.Input['DateArgs']]):
        pulumi.set(self, "date_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "integer_value")

    @integer_value.setter
    def integer_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integer_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timestamp_value")

    @timestamp_value.setter
    def timestamp_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_value", value)


