# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkerPoolResult',
    'AwaitableGetWorkerPoolResult',
    'get_worker_pool',
    'get_worker_pool_output',
]

@pulumi.output_type
class GetWorkerPoolResult:
    def __init__(__self__, create_time=None, delete_time=None, name=None, project=None, regions=None, service_account_email=None, status=None, update_time=None, worker_config=None, worker_count=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if service_account_email and not isinstance(service_account_email, str):
            raise TypeError("Expected argument 'service_account_email' to be a str")
        pulumi.set(__self__, "service_account_email", service_account_email)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if worker_config and not isinstance(worker_config, dict):
            raise TypeError("Expected argument 'worker_config' to be a dict")
        pulumi.set(__self__, "worker_config", worker_config)
        if worker_count and not isinstance(worker_count, str):
            raise TypeError("Expected argument 'worker_count' to be a str")
        pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the request to create the `WorkerPool` was received.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        Time at which the request to delete the `WorkerPool` was received.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User-defined name of the `WorkerPool`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project ID of the GCP project for which the `WorkerPool` is created.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        List of regions to create the `WorkerPool`. Regions can't be empty. If Cloud Build adds a new GCP region in the future, the existing `WorkerPool` will not be enabled in the new region automatically; you must add the new region to the `regions` field to enable the `WorkerPool` in that region.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        The service account used to manage the `WorkerPool`. The service account must have the Compute Instance Admin (Beta) permission at the project level.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        WorkerPool Status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Time at which the request to update the `WorkerPool` was received.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> 'outputs.WorkerConfigResponse':
        """
        Configuration to be used for a creating workers in the `WorkerPool`.
        """
        return pulumi.get(self, "worker_config")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> str:
        """
        Total number of workers to be created across all requested regions.
        """
        return pulumi.get(self, "worker_count")


class AwaitableGetWorkerPoolResult(GetWorkerPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkerPoolResult(
            create_time=self.create_time,
            delete_time=self.delete_time,
            name=self.name,
            project=self.project,
            regions=self.regions,
            service_account_email=self.service_account_email,
            status=self.status,
            update_time=self.update_time,
            worker_config=self.worker_config,
            worker_count=self.worker_count)


def get_worker_pool(project: Optional[str] = None,
                    worker_pool_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkerPoolResult:
    """
    Returns information about a `WorkerPool`.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['workerPoolId'] = worker_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:cloudbuild/v1alpha1:getWorkerPool', __args__, opts=opts, typ=GetWorkerPoolResult).value

    return AwaitableGetWorkerPoolResult(
        create_time=__ret__.create_time,
        delete_time=__ret__.delete_time,
        name=__ret__.name,
        project=__ret__.project,
        regions=__ret__.regions,
        service_account_email=__ret__.service_account_email,
        status=__ret__.status,
        update_time=__ret__.update_time,
        worker_config=__ret__.worker_config,
        worker_count=__ret__.worker_count)


@_utilities.lift_output_func(get_worker_pool)
def get_worker_pool_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                           worker_pool_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkerPoolResult]:
    """
    Returns information about a `WorkerPool`.
    """
    ...
