# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDatastoreResult',
    'AwaitableGetDatastoreResult',
    'get_datastore',
    'get_datastore_output',
]

@pulumi.output_type
class GetDatastoreResult:
    def __init__(__self__, create_time=None, datastore_config=None, display_name=None, last_update_time=None, org=None, self=None, target_type=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if datastore_config and not isinstance(datastore_config, dict):
            raise TypeError("Expected argument 'datastore_config' to be a dict")
        pulumi.set(__self__, "datastore_config", datastore_config)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if last_update_time and not isinstance(last_update_time, str):
            raise TypeError("Expected argument 'last_update_time' to be a str")
        pulumi.set(__self__, "last_update_time", last_update_time)
        if org and not isinstance(org, str):
            raise TypeError("Expected argument 'org' to be a str")
        pulumi.set(__self__, "org", org)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Datastore create time, in milliseconds since the epoch of 1970-01-01T00:00:00Z
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="datastoreConfig")
    def datastore_config(self) -> 'outputs.GoogleCloudApigeeV1DatastoreConfigResponse':
        """
        Datastore Configurations.
        """
        return pulumi.get(self, "datastore_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name in UI
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> str:
        """
        Datastore last update time, in milliseconds since the epoch of 1970-01-01T00:00:00Z
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def org(self) -> str:
        """
        Organization that the datastore belongs to
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        Resource link of Datastore. Example: `/organizations/{org}/analytics/datastores/{uuid}`
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        Destination storage type. Supported types `gcs` or `bigquery`.
        """
        return pulumi.get(self, "target_type")


class AwaitableGetDatastoreResult(GetDatastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatastoreResult(
            create_time=self.create_time,
            datastore_config=self.datastore_config,
            display_name=self.display_name,
            last_update_time=self.last_update_time,
            org=self.org,
            self=self.self,
            target_type=self.target_type)


def get_datastore(datastore_id: Optional[str] = None,
                  organization_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatastoreResult:
    """
    Get a Datastore
    """
    __args__ = dict()
    __args__['datastoreId'] = datastore_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getDatastore', __args__, opts=opts, typ=GetDatastoreResult).value

    return AwaitableGetDatastoreResult(
        create_time=__ret__.create_time,
        datastore_config=__ret__.datastore_config,
        display_name=__ret__.display_name,
        last_update_time=__ret__.last_update_time,
        org=__ret__.org,
        self=__ret__.self,
        target_type=__ret__.target_type)


@_utilities.lift_output_func(get_datastore)
def get_datastore_output(datastore_id: Optional[pulumi.Input[str]] = None,
                         organization_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatastoreResult]:
    """
    Get a Datastore
    """
    ...
