# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAliasResult',
    'AwaitableGetAliasResult',
    'get_alias',
    'get_alias_output',
]

@pulumi.output_type
class GetAliasResult:
    def __init__(__self__, alias=None, certs_info=None, type=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if certs_info and not isinstance(certs_info, dict):
            raise TypeError("Expected argument 'certs_info' to be a dict")
        pulumi.set(__self__, "certs_info", certs_info)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        Resource ID for this alias. Values must match the regular expression `[^/]{1,255}`.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="certsInfo")
    def certs_info(self) -> 'outputs.GoogleCloudApigeeV1CertificateResponse':
        """
        Chain of certificates under this alias.
        """
        return pulumi.get(self, "certs_info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of alias.
        """
        return pulumi.get(self, "type")


class AwaitableGetAliasResult(GetAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAliasResult(
            alias=self.alias,
            certs_info=self.certs_info,
            type=self.type)


def get_alias(alias_id: Optional[str] = None,
              environment_id: Optional[str] = None,
              keystore_id: Optional[str] = None,
              organization_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAliasResult:
    """
    Gets an alias.
    """
    __args__ = dict()
    __args__['aliasId'] = alias_id
    __args__['environmentId'] = environment_id
    __args__['keystoreId'] = keystore_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getAlias', __args__, opts=opts, typ=GetAliasResult).value

    return AwaitableGetAliasResult(
        alias=__ret__.alias,
        certs_info=__ret__.certs_info,
        type=__ret__.type)


@_utilities.lift_output_func(get_alias)
def get_alias_output(alias_id: Optional[pulumi.Input[str]] = None,
                     environment_id: Optional[pulumi.Input[str]] = None,
                     keystore_id: Optional[pulumi.Input[str]] = None,
                     organization_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAliasResult]:
    """
    Gets an alias.
    """
    ...
