#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    "expects",
    "aws-cdk.core>=1.108.0",
    "aws-cdk.aws_s3>=1.108.0"
]

test_requirements = ['pytest>=3', ]

setup(
    author="Ahmed Elgamal",
    author_email='eng.ahmed.srour@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Python package to provide a unit testing framework for AWS CDK in python",
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='cdk_expects_matcher',
    name='cdk_expects_matcher',
    packages=find_packages(include=['cdk_expects_matcher', 'cdk_expects_matcher.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/elgamala/cdk_expects_matcher',
    version='0.1.1',
    zip_safe=False,
)
