"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositeECRRepositoryAspect = exports.StepFunctionsSageMakerTrainingJob = exports.ECSTaskDefinition = exports.ECRRepositoryAspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_stepfunctions_tasks_1 = require("aws-cdk-lib/aws-stepfunctions-tasks");
const FN_SUB = 'Fn::Sub';
/**
 * Abtract aspect for ECR repository.
 *
 * You must provide the account id in props or set BSS_IMAGE_ASSET_ACCOUNT_ID in env
 *
 * @stability stable
 */
class ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        var _e;
        this.account = (_e = props.imageAssetAccountId) !== null && _e !== void 0 ? _e : process.env.BSS_IMAGE_ASSET_ACCOUNT_ID;
    }
    /**
     * @stability stable
     */
    getRepoName(imageUri) {
        const matches = /\d{12}\.dkr\.ecr\..*\/(.*):.*/g.exec(imageUri);
        if (matches) {
            return matches[1];
        }
        return undefined;
    }
    /**
     * @stability stable
     */
    crossAccountECRPolicy(stack, repoName) {
        const policy = ECRRepositoryAspect._repoPolicies.get(repoName);
        if (policy) {
            return policy;
        }
        const newPolicy = new aws_iam_1.Policy(stack, `CrossAccountECR-${repoName}`, {
            statements: [
                new aws_iam_1.PolicyStatement({
                    actions: [
                        'ecr:BatchCheckLayerAvailability',
                        'ecr:GetDownloadUrlForLayer',
                        'ecr:BatchGetImage',
                    ],
                    resources: [
                        aws_cdk_lib_1.Arn.format({
                            account: this.account,
                            service: 'ecr',
                            resource: 'repository',
                            resourceName: repoName,
                        }, stack),
                    ],
                }),
            ],
        });
        ECRRepositoryAspect._repoPolicies.set(repoName, newPolicy);
        return newPolicy;
    }
}
exports.ECRRepositoryAspect = ECRRepositoryAspect;
_a = JSII_RTTI_SYMBOL_1;
ECRRepositoryAspect[_a] = { fqn: "cdk-bootstrapless-synthesizer.ECRRepositoryAspect", version: "2.1.5" };
/**
 * @internal
 */
ECRRepositoryAspect._repoPolicies = new Map();
/**
 * Process the image assets in ECS task definition.
 *
 * @stability stable
 */
class ECSTaskDefinition extends ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        super(props);
    }
    /**
     * @stability stable
     */
    hasBeReplaced(prop) {
        if (typeof prop.image === 'object' && FN_SUB in prop.image &&
            prop.image[FN_SUB].indexOf(this.account) > -1) {
            return prop.image[FN_SUB];
        }
        else if (prop.image && prop.image && prop.image.indexOf(this.account) > -1) {
            return prop.image;
        }
        return undefined;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct) {
        if (construct instanceof aws_ecs_1.TaskDefinition) {
            const containers = construct.stack.resolve(construct.node.defaultChild.containerDefinitions);
            let imageUri = undefined;
            if (containers instanceof Array) {
                for (const container of containers) {
                    if (container) {
                        imageUri = this.hasBeReplaced(container);
                        if (imageUri) {
                            break;
                        }
                    }
                }
            }
            else if (containers) {
                imageUri = this.hasBeReplaced(containers);
            }
            if (imageUri) {
                const repoName = this.getRepoName(imageUri);
                if (repoName) {
                    construct.executionRole.attachInlinePolicy(this.crossAccountECRPolicy(construct.stack, repoName));
                }
            }
        }
    }
}
exports.ECSTaskDefinition = ECSTaskDefinition;
_b = JSII_RTTI_SYMBOL_1;
ECSTaskDefinition[_b] = { fqn: "cdk-bootstrapless-synthesizer.ECSTaskDefinition", version: "2.1.5" };
/**
 * Process the image assets in SageMaker training job in Step Functions.
 *
 * @stability stable
 */
class StepFunctionsSageMakerTrainingJob extends ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        super(props);
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct) {
        if (construct instanceof aws_stepfunctions_tasks_1.SageMakerCreateTrainingJob) {
            const stack = aws_cdk_lib_1.Stack.of(construct);
            const state = construct.toStateJson();
            const image = stack.resolve(state.Parameters.AlgorithmSpecification.TrainingImage);
            if (FN_SUB in image) {
                const repoName = this.getRepoName(image[FN_SUB]);
                if (repoName) {
                    construct.role.attachInlinePolicy(this.crossAccountECRPolicy(stack, repoName));
                }
            }
        }
    }
}
exports.StepFunctionsSageMakerTrainingJob = StepFunctionsSageMakerTrainingJob;
_c = JSII_RTTI_SYMBOL_1;
StepFunctionsSageMakerTrainingJob[_c] = { fqn: "cdk-bootstrapless-synthesizer.StepFunctionsSageMakerTrainingJob", version: "2.1.5" };
/**
 * Default ECR asset aspect, support using ECR assets in below services,.
 *
 * - ECS task definition
 * - SageMaker training job in Step Functions
 *
 * @stability stable
 */
class CompositeECRRepositoryAspect extends ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        super(props);
        this._aspects = [
            new ECSTaskDefinition(props),
            new StepFunctionsSageMakerTrainingJob(props),
        ];
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct) {
        for (const _aspect of this._aspects) {
            _aspect.visit(construct);
        }
    }
}
exports.CompositeECRRepositoryAspect = CompositeECRRepositoryAspect;
_d = JSII_RTTI_SYMBOL_1;
CompositeECRRepositoryAspect[_d] = { fqn: "cdk-bootstrapless-synthesizer.CompositeECRRepositoryAspect", version: "2.1.5" };
//# sourceMappingURL=data:application/json;base64,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