# coding: utf-8

"""
    validateapi

    The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class IPIntelligenceResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_bot': 'bool',
        'is_tor_node': 'bool',
        'is_threat': 'bool',
        'is_eu': 'bool',
        'location': 'GeolocateResponse',
        'currency_code': 'str',
        'currency_name': 'str',
        'region_area': 'str',
        'subregion_area': 'str'
    }

    attribute_map = {
        'is_bot': 'IsBot',
        'is_tor_node': 'IsTorNode',
        'is_threat': 'IsThreat',
        'is_eu': 'IsEU',
        'location': 'Location',
        'currency_code': 'CurrencyCode',
        'currency_name': 'CurrencyName',
        'region_area': 'RegionArea',
        'subregion_area': 'SubregionArea'
    }

    def __init__(self, is_bot=None, is_tor_node=None, is_threat=None, is_eu=None, location=None, currency_code=None, currency_name=None, region_area=None, subregion_area=None):  # noqa: E501
        """IPIntelligenceResponse - a model defined in Swagger"""  # noqa: E501

        self._is_bot = None
        self._is_tor_node = None
        self._is_threat = None
        self._is_eu = None
        self._location = None
        self._currency_code = None
        self._currency_name = None
        self._region_area = None
        self._subregion_area = None
        self.discriminator = None

        if is_bot is not None:
            self.is_bot = is_bot
        if is_tor_node is not None:
            self.is_tor_node = is_tor_node
        if is_threat is not None:
            self.is_threat = is_threat
        if is_eu is not None:
            self.is_eu = is_eu
        if location is not None:
            self.location = location
        if currency_code is not None:
            self.currency_code = currency_code
        if currency_name is not None:
            self.currency_name = currency_name
        if region_area is not None:
            self.region_area = region_area
        if subregion_area is not None:
            self.subregion_area = subregion_area

    @property
    def is_bot(self):
        """Gets the is_bot of this IPIntelligenceResponse.  # noqa: E501

        True if the IP address is a known bot, otherwise false  # noqa: E501

        :return: The is_bot of this IPIntelligenceResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_bot

    @is_bot.setter
    def is_bot(self, is_bot):
        """Sets the is_bot of this IPIntelligenceResponse.

        True if the IP address is a known bot, otherwise false  # noqa: E501

        :param is_bot: The is_bot of this IPIntelligenceResponse.  # noqa: E501
        :type: bool
        """

        self._is_bot = is_bot

    @property
    def is_tor_node(self):
        """Gets the is_tor_node of this IPIntelligenceResponse.  # noqa: E501

        True if the IP address is a known Tor exit node, otherwise false  # noqa: E501

        :return: The is_tor_node of this IPIntelligenceResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_tor_node

    @is_tor_node.setter
    def is_tor_node(self, is_tor_node):
        """Sets the is_tor_node of this IPIntelligenceResponse.

        True if the IP address is a known Tor exit node, otherwise false  # noqa: E501

        :param is_tor_node: The is_tor_node of this IPIntelligenceResponse.  # noqa: E501
        :type: bool
        """

        self._is_tor_node = is_tor_node

    @property
    def is_threat(self):
        """Gets the is_threat of this IPIntelligenceResponse.  # noqa: E501

        True if the IP address is a known threat IP, otherwise false  # noqa: E501

        :return: The is_threat of this IPIntelligenceResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_threat

    @is_threat.setter
    def is_threat(self, is_threat):
        """Sets the is_threat of this IPIntelligenceResponse.

        True if the IP address is a known threat IP, otherwise false  # noqa: E501

        :param is_threat: The is_threat of this IPIntelligenceResponse.  # noqa: E501
        :type: bool
        """

        self._is_threat = is_threat

    @property
    def is_eu(self):
        """Gets the is_eu of this IPIntelligenceResponse.  # noqa: E501

        True if the IP address is in the European Union, otherwise false  # noqa: E501

        :return: The is_eu of this IPIntelligenceResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_eu

    @is_eu.setter
    def is_eu(self, is_eu):
        """Sets the is_eu of this IPIntelligenceResponse.

        True if the IP address is in the European Union, otherwise false  # noqa: E501

        :param is_eu: The is_eu of this IPIntelligenceResponse.  # noqa: E501
        :type: bool
        """

        self._is_eu = is_eu

    @property
    def location(self):
        """Gets the location of this IPIntelligenceResponse.  # noqa: E501

        Returns the location of the IP address  # noqa: E501

        :return: The location of this IPIntelligenceResponse.  # noqa: E501
        :rtype: GeolocateResponse
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this IPIntelligenceResponse.

        Returns the location of the IP address  # noqa: E501

        :param location: The location of this IPIntelligenceResponse.  # noqa: E501
        :type: GeolocateResponse
        """

        self._location = location

    @property
    def currency_code(self):
        """Gets the currency_code of this IPIntelligenceResponse.  # noqa: E501

        ISO 4217 currency code for the IP address location  # noqa: E501

        :return: The currency_code of this IPIntelligenceResponse.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this IPIntelligenceResponse.

        ISO 4217 currency code for the IP address location  # noqa: E501

        :param currency_code: The currency_code of this IPIntelligenceResponse.  # noqa: E501
        :type: str
        """

        self._currency_code = currency_code

    @property
    def currency_name(self):
        """Gets the currency_name of this IPIntelligenceResponse.  # noqa: E501

        Name of the currency in English  # noqa: E501

        :return: The currency_name of this IPIntelligenceResponse.  # noqa: E501
        :rtype: str
        """
        return self._currency_name

    @currency_name.setter
    def currency_name(self, currency_name):
        """Sets the currency_name of this IPIntelligenceResponse.

        Name of the currency in English  # noqa: E501

        :param currency_name: The currency_name of this IPIntelligenceResponse.  # noqa: E501
        :type: str
        """

        self._currency_name = currency_name

    @property
    def region_area(self):
        """Gets the region_area of this IPIntelligenceResponse.  # noqa: E501

        Region (continent) in which the country is located; possible values are None, Europe, Americas, Asia, Africa, Oceania  # noqa: E501

        :return: The region_area of this IPIntelligenceResponse.  # noqa: E501
        :rtype: str
        """
        return self._region_area

    @region_area.setter
    def region_area(self, region_area):
        """Sets the region_area of this IPIntelligenceResponse.

        Region (continent) in which the country is located; possible values are None, Europe, Americas, Asia, Africa, Oceania  # noqa: E501

        :param region_area: The region_area of this IPIntelligenceResponse.  # noqa: E501
        :type: str
        """

        self._region_area = region_area

    @property
    def subregion_area(self):
        """Gets the subregion_area of this IPIntelligenceResponse.  # noqa: E501

        Subregion in which the country is located; possible values are None, NorthernEurope, WesternEurope, SouthernEurope, EasternEurope, CentralAmerica, NorthernAmerica, SouthAmerica, EasternAfrica, MiddleAfrica, NorthernAfrica , SouthernAfrica , WesternAfrica , CentralAsia , EasternAsia , SouthernAsia , SouthEasternAsia , WesternAsia , Southern , Middle , AustraliaandNewZealand , Melanesia , Polynesia , Micronesia , Caribbean,  # noqa: E501

        :return: The subregion_area of this IPIntelligenceResponse.  # noqa: E501
        :rtype: str
        """
        return self._subregion_area

    @subregion_area.setter
    def subregion_area(self, subregion_area):
        """Sets the subregion_area of this IPIntelligenceResponse.

        Subregion in which the country is located; possible values are None, NorthernEurope, WesternEurope, SouthernEurope, EasternEurope, CentralAmerica, NorthernAmerica, SouthAmerica, EasternAfrica, MiddleAfrica, NorthernAfrica , SouthernAfrica , WesternAfrica , CentralAsia , EasternAsia , SouthernAsia , SouthEasternAsia , WesternAsia , Southern , Middle , AustraliaandNewZealand , Melanesia , Polynesia , Micronesia , Caribbean,  # noqa: E501

        :param subregion_area: The subregion_area of this IPIntelligenceResponse.  # noqa: E501
        :type: str
        """

        self._subregion_area = subregion_area

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(IPIntelligenceResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IPIntelligenceResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
