"""
========================================================================
errors.py
========================================================================

Author : Shunning Jiang
Date   : Jul 4, 2017
"""
class PassOrderError( Exception ):
  """ Raise when applying a pass to a component and some required variable
      generated by other passes is missing """
  def __init__( self, var ):
    return super().__init__( f"Please first apply other passes to generate model.{var}" )

class ModelTypeError( Exception ):
  """ Raise when a pass cannot be applied to some component type """
  def __init__( self, typename ):
    return super().__init__( f"This pass can only be applied to {typename}" )

class TranslationError( Exception ):
  """ Raise when translation goes wrong """
  def __init__( self, blk, x ):
    return super().__init__( f"{blk.__name__} {x}" )

class InvalidPassOption( Exception ):
  """ Raised when the given pass option is not valid. """
  def __init__( self, opt, pas ):
    return super().__init__(f"\n{opt} is not a valid option of pass {pas}!")

class InvalidPassOptionValue( Exception ):
  """ Raised when the given pass option value is not valid. """
  def __init__( self, opt, val, pas, msg ):
    return super().__init__(f"\n{val} is not a valid value for option {opt}"
                            f" of pass {pas} because {msg}.")

class PlaceholderConfigError( Exception ):
  """ Raised when a placeholder is incorrectly configured. """
  def __init__( self, obj, msg ):
    return super().__init__(f"Error while configuring {obj}:\n - {msg}")
