#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.project import ProjectFragment, QUERY as ProjectFragmentQuery

from ..input.edit_project_input import EditProjectInput


# fmt: off
QUERY: List[str] = ProjectFragmentQuery + ["""
mutation EditProjectMutation($input: EditProjectInput!) {
  editProject(input: $input) {
    ...ProjectFragment
  }
} 
"""
]


class EditProjectMutation:
    @dataclass(frozen=True)
    class EditProjectMutationData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class Project(ProjectFragment):
            pass

        editProject: Project

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditProjectInput) -> EditProjectMutationData.Project:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EditProjectMutationData.from_dict(response_text)
        return res.editProject

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditProjectInput) -> EditProjectMutationData.Project:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.EditProjectMutationData.from_dict(response_text)
        return res.editProject
