from test_all import test_function, test_dependencies

from tests.data.geolayers import (
    geolayer_fr_dept_data_only,
    geolayer_fr_dept_data_and_geometry,
    geolayer_fr_dept_data_and_geometry_4326_precision_6,
    geolayer_idf_reseau_ferre,
)

from tests.data.fields_metadata import geolayer_data_fields_metadata_complete

from geoformat.conversion.feature_conversion import feature_serialize

from geoformat.conversion.geolayer_conversion import (
    create_geolayer_from_i_feat_list,
    reproject_geolayer,
    multi_geometry_to_single_geometry_geolayer,
)

create_geolayer_from_i_feat_list_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": 0,
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    1: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    2: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                1: {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}},
            },
        },
    },
    3: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                95: {
                    "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}
                },
            },
        },
    },
    4: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": True,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: feature_serialize(
                    {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}
                ),
                95: feature_serialize(
                    {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}}
                ),
            },
        },
    },
}

reproject_geolayer_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": None,
        "precision": 6,
        "return_value": geolayer_fr_dept_data_and_geometry_4326_precision_6,
    },
    1: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": 2154,
        "precision": 6,
        "return_value": geolayer_fr_dept_data_and_geometry_4326_precision_6,
    },
}

multi_geometry_to_single_geometry_geolayer_parameters = {
    0: {
        "geolayer": geolayer_idf_reseau_ferre,
        "return_value": {
            "metadata": {
                "name": "traces-du-reseau-ferre-idf",
                "fields": {
                    "reseau": {"type": "String", "width": 0, "index": 0},
                    "val": {"type": "Integer", "index": 1},
                    "metro": {"type": "Integer", "index": 2},
                    "res_com": {"type": "String", "width": 0, "index": 3},
                    "rer": {"type": "Integer", "index": 4},
                    "extcode": {"type": "String", "width": 0, "index": 5},
                    "geo_point_2d": {
                        "type": "RealList",
                        "width": 0,
                        "precision": 0,
                        "index": 6,
                    },
                    "indice_lig": {"type": "String", "width": 0, "index": 7},
                    "idf": {"type": "Integer", "index": 8},
                    "train": {"type": "Integer", "index": 9},
                    "fer": {"type": "Integer", "index": 10},
                    "mode": {"type": "String", "width": 0, "index": 11},
                    "tramway": {"type": "Integer", "index": 12},
                    "idrefligc": {"type": "String", "width": 0, "index": 13},
                    "navette": {"type": "Integer", "index": 14},
                    "idrefliga": {"type": "String", "width": 0, "index": 15},
                    "shape_leng": {
                        "type": "Real",
                        "width": 0,
                        "precision": 0,
                        "index": 16,
                    },
                },
                "geometry_ref": {
                    "type": {"LineString"},
                    "crs": 'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AXIS["Latitude",NORTH],AXIS["Longitude",EAST],AUTHORITY["EPSG","4326"]]',
                    "extent": (
                        1.149003549412462,
                        47.95742785371423,
                        3.514336465015477,
                        49.42620159228318,
                    ),
                },
            },
            "features": {
                0: {
                    "attributes": {
                        "reseau": "LA VERRIERE-LA DEFENSE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE U",
                        "rer": 0,
                        "extcode": "800:U",
                        "geo_point_2d": [48.79486075047856, 2.1040231487081065],
                        "indice_lig": "U",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01741",
                        "navette": 0,
                        "idrefliga": "A01855",
                        "shape_leng": 5003.12924709,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.071847005929401,
                            48.79197130289541,
                            2.136050489663708,
                            48.798774681352754,
                        ),
                        "coordinates": [
                            [2.071847005929401, 48.79870763528835],
                            [2.071930959217986, 48.79871552851866],
                            [2.072216710538763, 48.7987359766609],
                            [2.072579474675331, 48.79875781412333],
                            [2.072862898980037, 48.79877217510979],
                            [2.07339670251307, 48.798774681352754],
                            [2.073713874486058, 48.798774514434655],
                            [2.074120918822997, 48.79876825942257],
                            [2.074570257201611, 48.79874411437348],
                            [2.075095898700846, 48.79870575443047],
                            [2.075455455431691, 48.79866970976342],
                            [2.075887224661105, 48.79862123822052],
                            [2.076227752121453, 48.79857975186269],
                            [2.076626900075734, 48.798521310787564],
                            [2.07716506105974, 48.79843081224707],
                            [2.07764852043101, 48.798316933934665],
                            [2.078167738891175, 48.798203905116274],
                            [2.078658217708944, 48.798076532368164],
                            [2.079083828515797, 48.79795614915085],
                            [2.07970072398773, 48.79775767757964],
                            [2.08020225629617, 48.79758035736656],
                            [2.080682237327531, 48.79739108945262],
                            [2.082831239058495, 48.79647994934646],
                            [2.08407821011798, 48.79595569704254],
                            [2.084495051075953, 48.79578292818973],
                            [2.084798183357852, 48.795662251920504],
                            [2.085068779097173, 48.79556529741404],
                            [2.085472803759792, 48.795432945457634],
                            [2.085851533812421, 48.795317192821884],
                            [2.086342037093098, 48.795175510300744],
                            [2.086926168987106, 48.795034032056186],
                            [2.087503001665491, 48.794911569452395],
                            [2.088104956144356, 48.79480581469834],
                            [2.088696007853362, 48.794719067792464],
                            [2.089301405013185, 48.794644244904084],
                            [2.089913909264423, 48.794588469047525],
                            [2.09054429876811, 48.794556522554586],
                            [2.091113408132319, 48.79453633626861],
                            [2.09172199049859, 48.79454478562203],
                            [2.092341270622694, 48.79457466828989],
                            [2.093068461780212, 48.79463095098126],
                            [2.093925150711385, 48.79471843643121],
                            [2.094774639817521, 48.794805900752586],
                            [2.098176203113287, 48.7951604600855],
                            [2.101567045015145, 48.79550775765459],
                            [2.10300329181604, 48.795658232499086],
                            [2.103510872100985, 48.79570448052273],
                            [2.103986129960595, 48.795731624861844],
                            [2.104472236811199, 48.795749272395476],
                            [2.104962034435666, 48.79574789032003],
                            [2.105455511439231, 48.79572985839365],
                            [2.105949086909674, 48.79569041070288],
                            [2.106424732283703, 48.79563426936188],
                            [2.106914848316776, 48.7955638785091],
                            [2.107390620647533, 48.795479181062994],
                            [2.107816052636528, 48.795377724667944],
                            [2.108270390515862, 48.79525491057731],
                            [2.108728360406763, 48.79512496420476],
                            [2.109154025991882, 48.79497115721885],
                            [2.109680764025691, 48.79476520547845],
                            [2.110294111936995, 48.794518974053865],
                            [2.110961593718655, 48.79424667472427],
                            [2.111369258162332, 48.794088065982855],
                            [2.111697533309683, 48.79396498860572],
                            [2.112061828922531, 48.79383960199691],
                            [2.112483806336287, 48.79370005213547],
                            [2.112801132518071, 48.793607882006135],
                            [2.113176151228948, 48.79349916875279],
                            [2.11369172125704, 48.793366936094806],
                            [2.114286612721081, 48.79321344201142],
                            [2.114690340145993, 48.79312619386876],
                            [2.115083250085545, 48.79304130261554],
                            [2.115443696458172, 48.792968243717226],
                            [2.11591216526011, 48.79289777277563],
                            [2.116330153700183, 48.792841477695944],
                            [2.11687422424131, 48.79277590713132],
                            [2.117843448911033, 48.79266118584478],
                            [2.120895214199257, 48.79230058968553],
                            [2.12276515961669, 48.79208045968901],
                            [2.123371895057395, 48.792006960314865],
                            [2.123854964587829, 48.79198209806883],
                            [2.124117106316824, 48.79197237837199],
                            [2.124505010430262, 48.79197130289541],
                            [2.124978607028827, 48.791982975227185],
                            [2.125773213019912, 48.79204200359494],
                            [2.126103812899514, 48.792074090135145],
                            [2.126404451834651, 48.79211061667671],
                            [2.126827479735518, 48.79217254796331],
                            [2.127227320272672, 48.79224612597793],
                            [2.12760129539878, 48.792321452990265],
                            [2.127994261423026, 48.792412101522544],
                            [2.128362701359944, 48.79250989839397],
                            [2.128830302441107, 48.79265463765974],
                            [2.129149705918469, 48.79276223361234],
                            [2.129462265955019, 48.792878809983584],
                            [2.130050581171206, 48.79312718041466],
                            [2.130828967598358, 48.7934927980301],
                            [2.13206509185052, 48.79409304530295],
                            [2.132487588843224, 48.794289846410095],
                            [2.133002509056168, 48.794520084339],
                            [2.13335716335117, 48.7946664018369],
                            [2.13369969439922, 48.79478212009287],
                            [2.13399604854809, 48.79487347462278],
                            [2.134304686413588, 48.794956757804414],
                            [2.134637837020887, 48.79503738448375],
                            [2.135009117560278, 48.7951135822115],
                            [2.1359721799146, 48.79526816122795],
                            [2.136050489663708, 48.79528024627206],
                        ],
                    },
                },
                1: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.705597373499494, 2.2254005317983756],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 2050.60936272,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.212262378017492,
                            48.70508587906037,
                            2.237314364639455,
                            48.708140583645324,
                        ),
                        "coordinates": [
                            [2.212262378017492, 48.705968984822285],
                            [2.212463435358097, 48.7059409026929],
                            [2.21268724018887, 48.70590061682936],
                            [2.21313889652569, 48.70580601699101],
                            [2.2139705366341, 48.70562503440158],
                            [2.21412414672051, 48.70559372612131],
                            [2.21448574534873, 48.705518576519175],
                            [2.214753101604864, 48.70547513211355],
                            [2.215098957101641, 48.70542776015219],
                            [2.215411294805012, 48.70540446183589],
                            [2.21579511124345, 48.7053877346906],
                            [2.216155296477162, 48.705396683340126],
                            [2.216664258131225, 48.70542720158098],
                            [2.217309054069744, 48.70547927455073],
                            [2.217856807928669, 48.705524104727324],
                            [2.218270877698805, 48.70555023408847],
                            [2.218646153215624, 48.70556347287892],
                            [2.219131461438564, 48.705563976273424],
                            [2.219530524215565, 48.70555154109456],
                            [2.219916671575999, 48.705527668643256],
                            [2.220279048117843, 48.70549632588],
                            [2.220787528230438, 48.705452342498944],
                            [2.221404500232453, 48.705398114753784],
                            [2.221777916835139, 48.70537544306055],
                            [2.222281071919556, 48.705353053871605],
                            [2.222522646715806, 48.70535329724141],
                            [2.222780927950786, 48.70536623094234],
                            [2.223100626178597, 48.70538671135744],
                            [2.2234348745451, 48.70541988019707],
                            [2.223784206743701, 48.70546020088952],
                            [2.224521669657798, 48.70555229806244],
                            [2.224849437954961, 48.705589738318835],
                            [2.225134106662692, 48.705611432924556],
                            [2.225315262409366, 48.705623031733],
                            [2.225666833114333, 48.705627659137704],
                            [2.226061586993946, 48.7056123407807],
                            [2.226508153904358, 48.705575657036505],
                            [2.227223540004041, 48.70550639166542],
                            [2.228055231596783, 48.705428054089694],
                            [2.230479608507602, 48.70520822772064],
                            [2.231785518993102, 48.705106925287254],
                            [2.232030111795038, 48.70509276272904],
                            [2.232367080077087, 48.70508587906037],
                            [2.232633368097813, 48.70509241794143],
                            [2.232985227129844, 48.7051116251601],
                            [2.233319399032826, 48.705142504493764],
                            [2.233646265589325, 48.70518263391184],
                            [2.233945566079325, 48.70523300053064],
                            [2.234260663427292, 48.70529083904784],
                            [2.234532270974559, 48.705354032942694],
                            [2.234771262858926, 48.70542169251568],
                            [2.234989856661979, 48.705497427676136],
                            [2.235241018388028, 48.7055938749017],
                            [2.235528143905083, 48.70572966872062],
                            [2.235758663732209, 48.705864068411316],
                            [2.23597118018682, 48.70599829836783],
                            [2.236163648551814, 48.70612282278379],
                            [2.236322992223034, 48.70625715775707],
                            [2.236447839147068, 48.7063843241211],
                            [2.236596332216985, 48.70655291164955],
                            [2.236688518249153, 48.70670486080525],
                            [2.236832098804893, 48.706926207989866],
                            [2.236934942988355, 48.70713582962608],
                            [2.237045871456509, 48.707379629124354],
                            [2.237203919574737, 48.70784289350996],
                            [2.237314364639455, 48.708140583645324],
                        ],
                    },
                },
                2: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.56843332780098, 2.5188146833364926],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 4173.15137828,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.492713002881577,
                            48.56448587191694,
                            2.54265182270078,
                            48.571143418979055,
                        ),
                        "coordinates": [
                            [2.54265182270078, 48.56448587191694],
                            [2.542632112539303, 48.564963414971864],
                            [2.542548622110391, 48.56541679511847],
                            [2.542347785796335, 48.56599898228977],
                            [2.542081640061914, 48.56651564101072],
                            [2.541657294782628, 48.56711351973032],
                            [2.54123239143263, 48.567577407131346],
                            [2.540624772726035, 48.5680928806298],
                            [2.53988357818143, 48.568551810802504],
                            [2.539177442853698, 48.56891850547845],
                            [2.538442439305356, 48.5692217649704],
                            [2.537212189861203, 48.5696500679459],
                            [2.536029553548685, 48.569985912843855],
                            [2.534501212524553, 48.570353692811175],
                            [2.533270427801306, 48.570587844658014],
                            [2.532153247834778, 48.57076963016007],
                            [2.530839530357968, 48.57093825246705],
                            [2.529358977223124, 48.571065777994775],
                            [2.528108508755293, 48.5711245515006],
                            [2.527051654550542, 48.571143418979055],
                            [2.526023163579781, 48.57113794820847],
                            [2.525353919016563, 48.57111352904154],
                            [2.524578454516361, 48.57107290979653],
                            [2.523227071119833, 48.57096093721537],
                            [2.52229171681967, 48.57085725996125],
                            [2.521321013856532, 48.57072035999768],
                            [2.520530537789475, 48.57058495841179],
                            [2.519692553507267, 48.570425347875485],
                            [2.518831442561021, 48.57023968922527],
                            [2.518029778485811, 48.57003929826953],
                            [2.517221512393022, 48.56981421907329],
                            [2.516532437797655, 48.56960938470932],
                            [2.515884056068005, 48.56941527270209],
                            [2.515180061745829, 48.56920325957478],
                            [2.513819555121602, 48.568790837286585],
                            [2.511992462634034, 48.568234339678334],
                            [2.511103988065934, 48.56795334421567],
                            [2.509283741714297, 48.567400390289585],
                            [2.507724066054226, 48.56696032090451],
                            [2.507001610867432, 48.56678012842227],
                            [2.506296194312994, 48.566623448382046],
                            [2.505065119235051, 48.56638068715553],
                            [2.503092653791063, 48.56605537309182],
                            [2.501107961458334, 48.565730636943755],
                            [2.500068272789582, 48.56556158869476],
                            [2.499576253141722, 48.56550114838491],
                            [2.499055348099611, 48.56545447725449],
                            [2.498566604637839, 48.5654198649025],
                            [2.498006045002383, 48.565409459716705],
                            [2.49749653457783, 48.56541303173543],
                            [2.496974707104717, 48.565445512721226],
                            [2.496107840693743, 48.56552587153183],
                            [2.495372418654648, 48.56561323421448],
                            [2.494651908737701, 48.56571545710675],
                            [2.493967602843918, 48.56584013429816],
                            [2.493239680856003, 48.565997491801305],
                            [2.492713002881577, 48.5661178207362],
                        ],
                    },
                },
                3: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.12137306210128, 2.7670868898131036],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 5856.19123313,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.762728388543796,
                            48.09650277877714,
                            2.774122167142249,
                            48.14721803991587,
                        ),
                        "coordinates": [
                            [2.762728388543796, 48.14721803991587],
                            [2.76273124070775, 48.14692600279808],
                            [2.762737587948206, 48.14608701359404],
                            [2.762731355484866, 48.145190522916145],
                            [2.762737017123065, 48.1442706069449],
                            [2.762732068918912, 48.143366918204336],
                            [2.762740038379433, 48.142561194296455],
                            [2.762749366108946, 48.1415981038468],
                            [2.762761928003978, 48.14069974419957],
                            [2.762767771373231, 48.13980141098956],
                            [2.762772377652811, 48.13891567061274],
                            [2.762774289639833, 48.13802904155212],
                            [2.762780581342609, 48.13718376005438],
                            [2.762787334268553, 48.136234168354456],
                            [2.762786065436448, 48.13528910318546],
                            [2.76279185536933, 48.13438447673979],
                            [2.762795723004767, 48.13341151679277],
                            [2.76279800660798, 48.132568949314575],
                            [2.762797785334969, 48.132383712904534],
                            [2.762792466697309, 48.131754286685364],
                            [2.762804865578496, 48.13083704575186],
                            [2.762810212589824, 48.12988026735892],
                            [2.762817913102712, 48.12888391545409],
                            [2.762827917607845, 48.12768343432905],
                            [2.762832292342056, 48.1266115614433],
                            [2.762836012496911, 48.12546235950826],
                            [2.762851370833684, 48.12410090014393],
                            [2.762868537246985, 48.12374834587039],
                            [2.76289268551721, 48.12342723794915],
                            [2.762916575377397, 48.12323471695812],
                            [2.762954784014198, 48.12298819005845],
                            [2.763002490295106, 48.1227533162626],
                            [2.763085704013368, 48.12242928620231],
                            [2.763185215189774, 48.12212677610113],
                            [2.763290507295784, 48.12187280062092],
                            [2.763414432253781, 48.12159897224304],
                            [2.763561048419426, 48.12130887231516],
                            [2.763766242014921, 48.12095830301011],
                            [2.764018198635113, 48.12057968062769],
                            [2.764182768967725, 48.12034885962159],
                            [2.764403459228069, 48.12008455388772],
                            [2.764634866271736, 48.11981751016425],
                            [2.76494501251472, 48.11949261621677],
                            [2.765250188618764, 48.11921539968384],
                            [2.765536821318116, 48.11896882477002],
                            [2.765879582481076, 48.11869056363751],
                            [2.766161189825298, 48.11848537094358],
                            [2.771079631821379, 48.11361145787937],
                            [2.773060532582075, 48.10992778590111],
                            [2.774122167142249, 48.10575752160171],
                            [2.773713826426943, 48.10085776549668],
                            [2.77230261766097, 48.09650277877714],
                        ],
                    },
                },
                4: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.627581714147084, 2.4614413777361728],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 2070.25939143,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.452289891181863,
                            48.620290259939715,
                            2.470234997616056,
                            48.6344790233052,
                        ),
                        "coordinates": [
                            [2.470234997616056, 48.620290259939715],
                            [2.468818696186112, 48.62113191977028],
                            [2.467965403141835, 48.62168767432524],
                            [2.467572035679736, 48.62198516100947],
                            [2.467231905661427, 48.622294864345484],
                            [2.46694904647745, 48.62257012837191],
                            [2.466558981773188, 48.62298087986408],
                            [2.46627143006039, 48.62332269211523],
                            [2.465862972716693, 48.623782684008845],
                            [2.465388180929839, 48.624296705067536],
                            [2.465014848470467, 48.624707194205996],
                            [2.464154585799172, 48.625671278782264],
                            [2.463336122330352, 48.626548981301895],
                            [2.462809711454819, 48.62705585563435],
                            [2.462357661382666, 48.62746822226067],
                            [2.461502077649284, 48.628173293134275],
                            [2.461114852369585, 48.62847677224858],
                            [2.460592158762573, 48.628859532855465],
                            [2.459371922687139, 48.62969717926501],
                            [2.458893787414651, 48.630004345456435],
                            [2.458331659466724, 48.630362859058614],
                            [2.457540381851508, 48.63087297212455],
                            [2.456852507432761, 48.63131765985182],
                            [2.45591124343995, 48.6319368225547],
                            [2.454889751910423, 48.63260747395128],
                            [2.453991025272698, 48.63323631275906],
                            [2.453204787772405, 48.63379445345111],
                            [2.452816068915519, 48.63407992000851],
                            [2.452289891181863, 48.6344790233052],
                        ],
                    },
                },
                5: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.74657775229024, 2.2243940870104537],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1712.81148115,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.215860857351649,
                            48.74018152105127,
                            2.230961125063006,
                            48.751023275119756,
                        ),
                        "coordinates": [
                            [2.215860857351649, 48.751023275119756],
                            [2.216402248560275, 48.750780173208625],
                            [2.217980125073538, 48.75006061337667],
                            [2.218118985524632, 48.749997809315595],
                            [2.218995689410336, 48.74960843478377],
                            [2.219758055068794, 48.749258504004665],
                            [2.220043940273481, 48.74912660465951],
                            [2.220626584775005, 48.74886371316532],
                            [2.221063566104835, 48.748665418788136],
                            [2.223321959610476, 48.74762813211571],
                            [2.225376013529548, 48.74671200282293],
                            [2.226267659665766, 48.746277623305524],
                            [2.226881707520914, 48.74592660266426],
                            [2.227102294945866, 48.745790125055635],
                            [2.227343334682708, 48.74562848859509],
                            [2.227569399736954, 48.74547313097266],
                            [2.227745087109964, 48.74534740153055],
                            [2.227934420668569, 48.74519920270087],
                            [2.228396181947704, 48.74483363897137],
                            [2.228806262351471, 48.74446892324872],
                            [2.229040656326748, 48.744230838090324],
                            [2.229230612579832, 48.74401993036308],
                            [2.229362350347043, 48.74386333868691],
                            [2.229640486712221, 48.743514682361436],
                            [2.229779598120949, 48.74331967081882],
                            [2.229880556496796, 48.74316239332066],
                            [2.23004289796115, 48.7429125476522],
                            [2.230229415721035, 48.74259773622583],
                            [2.230408768999338, 48.74222584475121],
                            [2.230601520702954, 48.74174041653679],
                            [2.230741137079111, 48.74130439882057],
                            [2.230834485527692, 48.740885424204855],
                            [2.23090742321191, 48.74047362506254],
                            [2.230961125063006, 48.74018152105127],
                        ],
                    },
                },
                6: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.33084189358218, 2.0166602802282845],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 4670.22185495,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.003525000097989,
                            48.31129627475171,
                            2.032239773386701,
                            48.34841601424845,
                        ),
                        "coordinates": [
                            [2.003525000097989, 48.31129627475171],
                            [2.003702807903224, 48.31159108385618],
                            [2.004722623312976, 48.313281883838236],
                            [2.007146685603181, 48.317312264918264],
                            [2.008417155259732, 48.319414448638945],
                            [2.009705521170246, 48.32152380785578],
                            [2.01086534372533, 48.32346943213367],
                            [2.011736612274597, 48.324898131021094],
                            [2.012605233723637, 48.32632681662795],
                            [2.013400506828508, 48.327635686299296],
                            [2.014195810049701, 48.32894634975154],
                            [2.014989810912541, 48.33025610555778],
                            [2.016451072961751, 48.33267830627975],
                            [2.016966737620091, 48.33345041450526],
                            [2.017363815686869, 48.333997375021305],
                            [2.018107851003259, 48.334916698222614],
                            [2.018738537174137, 48.33563606750387],
                            [2.019187325847652, 48.33611572415417],
                            [2.01986819957429, 48.33679476317343],
                            [2.020834847680739, 48.33771739075223],
                            [2.022855454137321, 48.339637501705546],
                            [2.025174120794123, 48.341806589740145],
                            [2.026486340842052, 48.34302234619641],
                            [2.027392249474961, 48.34390521382073],
                            [2.030102887187705, 48.34645565124682],
                            [2.031337488389282, 48.34757753545706],
                            [2.032239773386701, 48.34841601424845],
                        ],
                    },
                },
                7: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [49.028171202330086, 2.4701018555958556],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1608.78315616,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.462168966135235,
                            49.023161999031025,
                            2.478033365115083,
                            49.033182769031264,
                        ),
                        "coordinates": [
                            [2.478033365115083, 49.033182769031264],
                            [2.476579460789503, 49.03226199604023],
                            [2.475261556334177, 49.031422443060364],
                            [2.472731440110162, 49.02982654697679],
                            [2.470186920742401, 49.028194922678715],
                            [2.467773230317047, 49.026717749750894],
                            [2.466044492685873, 49.02562045194961],
                            [2.46386288351023, 49.02425238540592],
                            [2.463418001262921, 49.02396601912603],
                            [2.462168966135235, 49.023161999031025],
                        ],
                    },
                },
                8: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.36147836978959, 2.046068678082501],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 3552.93433795,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.032239773386701,
                            48.34841601424845,
                            2.059912347637065,
                            48.37452501337592,
                        ),
                        "coordinates": [
                            [2.032239773386701, 48.34841601424845],
                            [2.032290730648379, 48.348463366712274],
                            [2.033314534971492, 48.34941472547342],
                            [2.034586205685321, 48.35062221533428],
                            [2.036000109636696, 48.35196945113331],
                            [2.03649655270448, 48.35242848434254],
                            [2.038173676289573, 48.35402927874207],
                            [2.041204466390754, 48.35690022587377],
                            [2.043246881117582, 48.35882484895548],
                            [2.044995558703508, 48.36045308376973],
                            [2.045858458667284, 48.361273617026804],
                            [2.048530531464787, 48.36381542186702],
                            [2.049617806785911, 48.36482893668195],
                            [2.051554696353337, 48.36666649291564],
                            [2.052284587349211, 48.36734662380235],
                            [2.053687616445963, 48.368661111550495],
                            [2.054500011607147, 48.36943995220021],
                            [2.055492001109102, 48.37037391450988],
                            [2.056547321687121, 48.371386507416794],
                            [2.059557757949159, 48.37419956338156],
                            [2.059901437730507, 48.374514999081164],
                            [2.059912347637065, 48.37452501337592],
                        ],
                    },
                },
                9: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.60716009644471, 2.465222640174841],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 556.533229431,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.462456492779697,
                            48.60555582637839,
                            2.467812581880024,
                            48.60904470232516,
                        ),
                        "coordinates": [
                            [2.462456492779697, 48.60555582637839],
                            [2.462964808935407, 48.605790758221325],
                            [2.463694338541454, 48.606133236247146],
                            [2.464153553682927, 48.60636679027209],
                            [2.464518853336865, 48.606576642856105],
                            [2.464836893889323, 48.60678149903763],
                            [2.465211605728296, 48.6070487469428],
                            [2.46552522948962, 48.60727769606698],
                            [2.465931400444536, 48.60756750906768],
                            [2.466198279382182, 48.607754277049374],
                            [2.466470203844905, 48.60795671799666],
                            [2.466689001631515, 48.60813991768482],
                            [2.466994759314531, 48.608388662159996],
                            [2.467812581880024, 48.60904470232516],
                        ],
                    },
                },
                10: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.507195562132665, 2.364828653284794],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 5732.12017965,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.351858421416974,
                            48.484957377176464,
                            2.370518497736708,
                            48.53150198648683,
                        ),
                        "coordinates": [
                            [2.370518497736708, 48.53150198648683],
                            [2.369782967672895, 48.53066504028073],
                            [2.369001172633517, 48.52977500533413],
                            [2.368330547109638, 48.529080072980506],
                            [2.367777821720014, 48.528536177487275],
                            [2.367502816369961, 48.528262880639495],
                            [2.366725234340153, 48.527496027113514],
                            [2.366577566830953, 48.52733330139564],
                            [2.366377066753841, 48.5271112386537],
                            [2.366085781009335, 48.52675251246034],
                            [2.365797185119591, 48.5263578157052],
                            [2.365527502691939, 48.5258830797868],
                            [2.365339088279061, 48.52547037005822],
                            [2.365111283629784, 48.524820268284145],
                            [2.365031179501694, 48.52441112819864],
                            [2.364978156520305, 48.5240100751952],
                            [2.364964484315445, 48.523769079280754],
                            [2.364967039213341, 48.52344932961314],
                            [2.364993830967873, 48.52299481547527],
                            [2.365036979124143, 48.52269085731438],
                            [2.365143638651926, 48.522186350233426],
                            [2.365228775069171, 48.5219255452245],
                            [2.365416684347494, 48.52147946904553],
                            [2.365534319755073, 48.52124113750787],
                            [2.365641136882604, 48.52102708781103],
                            [2.366645950297917, 48.519396482601294],
                            [2.3673058723346, 48.518324397306635],
                            [2.368061787731844, 48.51712189082662],
                            [2.368277584646867, 48.516764806757415],
                            [2.368641864037752, 48.51616582359326],
                            [2.369079939104525, 48.51542921187838],
                            [2.369253820816311, 48.51505096019996],
                            [2.369386734396402, 48.51472770794959],
                            [2.369533949372972, 48.514241170238925],
                            [2.369664837787011, 48.51363143927057],
                            [2.369787433543211, 48.512763626643135],
                            [2.369978162457463, 48.5105532116889],
                            [2.369997077479935, 48.51024039511414],
                            [2.370003512251351, 48.51000286210088],
                            [2.370002144288867, 48.50975980813285],
                            [2.369995085938944, 48.50954065007167],
                            [2.369937890880547, 48.50900561195673],
                            [2.369796752618062, 48.50841394662481],
                            [2.369537500880608, 48.50758836341424],
                            [2.369380396622795, 48.50705799832348],
                            [2.369006115904586, 48.50585850499112],
                            [2.368595237760598, 48.5045385224811],
                            [2.36815047528607, 48.50309445156857],
                            [2.367703032548536, 48.50165127876548],
                            [2.36725696807109, 48.50020810444684],
                            [2.367112382576333, 48.49984106916265],
                            [2.366913456411754, 48.49935725482325],
                            [2.366702763364148, 48.49890523911615],
                            [2.366513145671601, 48.49856032453469],
                            [2.366319442232059, 48.498231801353015],
                            [2.366169333496484, 48.49798638982355],
                            [2.36600795161212, 48.49774179142645],
                            [2.365563790660651, 48.49711692663012],
                            [2.365317361664009, 48.49680584957771],
                            [2.365062811931172, 48.496485779970264],
                            [2.364440049266327, 48.49580969899613],
                            [2.364131397662917, 48.495503129780765],
                            [2.363278612314385, 48.494743468035274],
                            [2.362910448732153, 48.49444680148072],
                            [2.362333400496063, 48.494008826775286],
                            [2.360905896234596, 48.492926400915344],
                            [2.360345671354884, 48.49250229133352],
                            [2.3590099049025, 48.49150169810289],
                            [2.357672839996874, 48.490501090766955],
                            [2.356338532882637, 48.489500466070396],
                            [2.355568554680084, 48.488916985041335],
                            [2.354954207128473, 48.488445880003944],
                            [2.354415282544769, 48.488006780108776],
                            [2.353970528329367, 48.487615769430754],
                            [2.353507032163732, 48.48716504628661],
                            [2.353043474664347, 48.48666745900562],
                            [2.352695683414058, 48.4862457610922],
                            [2.352489974259953, 48.48595263472164],
                            [2.352080440525532, 48.485345166827706],
                            [2.351858421416974, 48.484957377176464],
                        ],
                    },
                },
                11: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.575356963680164, 2.4557352317571963],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 4383.55009934,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.432098533660357,
                            48.57059685871919,
                            2.473503765153183,
                            48.58715390715936,
                        ),
                        "coordinates": [
                            [2.473490366344224, 48.58715390715936],
                            [2.473503765153183, 48.58660174499059],
                            [2.473477967577842, 48.58609009670576],
                            [2.473426522034749, 48.5856791706745],
                            [2.47336458051269, 48.5852701077813],
                            [2.473238468550363, 48.5847522866102],
                            [2.473008896263801, 48.584068226036216],
                            [2.472554554, 48.5829644803769],
                            [2.472098872864541, 48.58185893675706],
                            [2.471782128496486, 48.58109168417483],
                            [2.471601538045066, 48.58067288962167],
                            [2.470845717704695, 48.579020567157265],
                            [2.470653489963128, 48.57859544514867],
                            [2.470071506012449, 48.577323682399395],
                            [2.469903331796089, 48.57698671694772],
                            [2.469663733800497, 48.57656312847582],
                            [2.469532139375638, 48.57636193441902],
                            [2.469339685405699, 48.57609474713919],
                            [2.46914552082931, 48.57584994723141],
                            [2.468864615746486, 48.57553197299926],
                            [2.468636357052715, 48.57530652595332],
                            [2.468410813631614, 48.57508287347395],
                            [2.468188058652502, 48.5748879927555],
                            [2.467826865926937, 48.57461054094352],
                            [2.46746435479674, 48.57434567947425],
                            [2.467066633378702, 48.57408805170524],
                            [2.466684267494194, 48.57386812441463],
                            [2.466331265847153, 48.573685095230076],
                            [2.46600548419132, 48.57352633399355],
                            [2.465536073280723, 48.57331374481202],
                            [2.46500980155598, 48.57312010367917],
                            [2.464427996674808, 48.57293461570908],
                            [2.463866999630313, 48.572786716768185],
                            [2.463288930688561, 48.57267197959238],
                            [2.462874242531003, 48.572604533978755],
                            [2.462413381839517, 48.57255019270054],
                            [2.461570332466472, 48.57247199157937],
                            [2.459800236543603, 48.57231836099495],
                            [2.459247284028652, 48.5722829919008],
                            [2.458759425643469, 48.572268232035064],
                            [2.458197087730036, 48.57227333428105],
                            [2.457786564366662, 48.572298055247636],
                            [2.457355746800001, 48.57233628450668],
                            [2.45674481876237, 48.572422364342316],
                            [2.455959253824132, 48.57257876824822],
                            [2.455485288112232, 48.57270876004451],
                            [2.45500864079603, 48.57285224277212],
                            [2.45080310992175, 48.5743160633727],
                            [2.449960778851302, 48.57455971079759],
                            [2.449432564347195, 48.57468613525646],
                            [2.448436949140885, 48.574866076264016],
                            [2.448023760738403, 48.57492313810675],
                            [2.4474777667121, 48.57497942809493],
                            [2.446853140865172, 48.57502140509936],
                            [2.446145800606674, 48.575040077569184],
                            [2.444530399814989, 48.575003861495986],
                            [2.443898831249863, 48.57496849230246],
                            [2.443046282880645, 48.57488926386505],
                            [2.44244008760732, 48.57479735317022],
                            [2.44212043190075, 48.57474894823654],
                            [2.441788396927756, 48.574681897648844],
                            [2.441435635241651, 48.57460817034715],
                            [2.441155146993709, 48.574541216907335],
                            [2.440882632503369, 48.5744767218846],
                            [2.440253470169857, 48.57429025526651],
                            [2.439801902675254, 48.57413779373232],
                            [2.439084453555834, 48.5738470867982],
                            [2.43877930408544, 48.573724164859755],
                            [2.438116028813668, 48.573412719770445],
                            [2.43715842595586, 48.57296034970965],
                            [2.436040075175235, 48.572449650493795],
                            [2.43546748977633, 48.57218824526225],
                            [2.434950375884485, 48.57195152557246],
                            [2.434413160759013, 48.57168965158499],
                            [2.433745652909737, 48.57136986008346],
                            [2.432854891688207, 48.57094795904131],
                            [2.432098533660357, 48.57059685871919],
                        ],
                    },
                },
                12: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.3817678729322, 2.916855356028169],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 3199.11206586,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.89720177783042,
                            48.378795760781145,
                            2.936180968314843,
                            48.38468131279181,
                        ),
                        "coordinates": [
                            [2.936180968314843, 48.37999957527981],
                            [2.934908556263945, 48.379945094509075],
                            [2.934343402316594, 48.379929026804426],
                            [2.933842607430669, 48.37991261717875],
                            [2.933459832304337, 48.379897964936035],
                            [2.933157302729277, 48.37989332873406],
                            [2.932801772400575, 48.37989332923899],
                            [2.93242317332602, 48.37991248760334],
                            [2.932130556722254, 48.37993920900663],
                            [2.931816363911015, 48.37996784078308],
                            [2.931475343709777, 48.380011002165496],
                            [2.931094127435304, 48.380079553223744],
                            [2.930753457159952, 48.38015238580757],
                            [2.930507066845852, 48.38021015008532],
                            [2.930194983432587, 48.380300100632155],
                            [2.929715062684075, 48.38046988255187],
                            [2.929434323656812, 48.38058825958691],
                            [2.929204632763628, 48.38068568513686],
                            [2.928933018224873, 48.38081025617642],
                            [2.928742953438621, 48.3809147184292],
                            [2.928539247592428, 48.381040783223526],
                            [2.928328928634067, 48.381178572711065],
                            [2.928024858464159, 48.38137980032377],
                            [2.927668765441012, 48.38163435595594],
                            [2.927108123670214, 48.382059040917014],
                            [2.926566179767029, 48.38246743799783],
                            [2.926227487066166, 48.382734476547334],
                            [2.925909485554005, 48.3829915370427],
                            [2.925637750952431, 48.38318899265284],
                            [2.925414180158933, 48.38334932773829],
                            [2.92524529691606, 48.38346162197285],
                            [2.925099641314644, 48.38354336785668],
                            [2.924907807347333, 48.383651556280014],
                            [2.924705270747713, 48.383762181997376],
                            [2.924532683984613, 48.38384807734107],
                            [2.924397436514429, 48.38391036365294],
                            [2.924180741558208, 48.38400429320013],
                            [2.923977196053016, 48.38408860788371],
                            [2.923761866950689, 48.384166358723384],
                            [2.923512300819755, 48.38424614823105],
                            [2.923288373686647, 48.38431359860544],
                            [2.922951933961305, 48.38440527022479],
                            [2.922534453300523, 48.38449376339217],
                            [2.922158610434262, 48.38456405507815],
                            [2.921832421999865, 48.38460890860832],
                            [2.921611496116461, 48.38463574838564],
                            [2.921354286696245, 48.3846585178601],
                            [2.921099994891111, 48.38466840001788],
                            [2.920868220456624, 48.38467692466362],
                            [2.920699223899258, 48.38468131279181],
                            [2.920363051268959, 48.384680351499355],
                            [2.920028102554904, 48.38466859131676],
                            [2.91972815803245, 48.384648556221045],
                            [2.91943887893585, 48.38461677429952],
                            [2.919160347576653, 48.38458044036269],
                            [2.918847900699907, 48.38452989292958],
                            [2.918543449407775, 48.384470310259694],
                            [2.918199632145059, 48.38439204404506],
                            [2.917601013362818, 48.384227858525406],
                            [2.91460179522727, 48.38333856956497],
                            [2.913402941151773, 48.38298228759372],
                            [2.912252856898915, 48.3826392340088],
                            [2.911478017965539, 48.3824084683481],
                            [2.910349661136737, 48.38207427864092],
                            [2.90822976955379, 48.38144384091659],
                            [2.906347054415935, 48.380891304257396],
                            [2.904515728287218, 48.380342974026526],
                            [2.904028119760863, 48.3802067139952],
                            [2.903482404342524, 48.38006521621463],
                            [2.902885087702344, 48.37991727784598],
                            [2.902313083661703, 48.379782984696476],
                            [2.901508007465895, 48.37961615019661],
                            [2.899424697247027, 48.37921917323933],
                            [2.897377939078802, 48.37882826848556],
                            [2.89720177783042, 48.378795760781145],
                        ],
                    },
                },
                13: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.41422607564345, 2.390506570940111],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 5068.48366431,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.376672818506992,
                            48.393641547740856,
                            2.399724480290099,
                            48.43449061286291,
                        ),
                        "coordinates": [
                            [2.376672818506992, 48.43449061286291],
                            [2.377944361246022, 48.43345812219093],
                            [2.378518238881933, 48.43293994641521],
                            [2.378781513148704, 48.4326673784374],
                            [2.379494207695649, 48.431744487689556],
                            [2.381156877356871, 48.42938243404588],
                            [2.381463213559586, 48.428948878777035],
                            [2.381661584969088, 48.428666437886505],
                            [2.3816939894959, 48.428639447553635],
                            [2.38226341505357, 48.42778673729532],
                            [2.382426691276003, 48.42755196921832],
                            [2.382677674533057, 48.42719037197099],
                            [2.382881437217691, 48.42690792709255],
                            [2.383727474170215, 48.42570619052647],
                            [2.384994411388416, 48.42388738918657],
                            [2.385258807151863, 48.423462834034645],
                            [2.385793002554799, 48.42262720690158],
                            [2.386727780968657, 48.4211430486371],
                            [2.387779805202364, 48.4194322208155],
                            [2.388044169631636, 48.41902204748705],
                            [2.388323374475548, 48.41859837748569],
                            [2.388503250786556, 48.41832255481767],
                            [2.388711868392753, 48.418049661742565],
                            [2.389587466667926, 48.41697196485423],
                            [2.390650565631598, 48.41568195032109],
                            [2.392110197591911, 48.413897150522224],
                            [2.392264413825362, 48.41371128453138],
                            [2.392657880236009, 48.41323593860022],
                            [2.39307201455852, 48.4127404839023],
                            [2.393537388820268, 48.412182489309586],
                            [2.394729780786517, 48.41074489664629],
                            [2.396344242875188, 48.40878551132365],
                            [2.396685464240191, 48.40837257901008],
                            [2.397096811538713, 48.40787687871588],
                            [2.397799442301978, 48.407018625902886],
                            [2.398654413899097, 48.40595705784972],
                            [2.398872810710566, 48.405636808125315],
                            [2.399081696384446, 48.40527340050349],
                            [2.399232605779722, 48.40499095547699],
                            [2.399308034170875, 48.40482815202271],
                            [2.399395559716458, 48.40462037878873],
                            [2.39951263842496, 48.40428669586576],
                            [2.39962153465357, 48.403890970471544],
                            [2.399677811433466, 48.40353573961727],
                            [2.399724480290099, 48.40305911679867],
                            [2.399722536734974, 48.402587916643235],
                            [2.399688346341769, 48.40224622476595],
                            [2.399624392265597, 48.40186228580065],
                            [2.399481923446543, 48.40132731824217],
                            [2.399300366978953, 48.40084902416577],
                            [2.399101342568212, 48.40043908118435],
                            [2.398956530503003, 48.400183777239924],
                            [2.398698132739097, 48.39980713840452],
                            [2.398454650634904, 48.399477250340354],
                            [2.398115204450287, 48.39907367600658],
                            [2.397643260412243, 48.39853528582518],
                            [2.397102338797336, 48.39789891307257],
                            [2.396469495884509, 48.39716816726632],
                            [2.395485121527657, 48.3960419350061],
                            [2.394707634019301, 48.395130506425716],
                            [2.394047827974065, 48.39437548114887],
                            [2.393410724066637, 48.393641547740856],
                        ],
                    },
                },
                14: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.37935127537549, 2.8078546326901286],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 1374.7591127,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.799307429283779,
                            48.37816709633966,
                            2.815956767081606,
                            48.38235800575609,
                        ),
                        "coordinates": [
                            [2.799307429283779, 48.37859776792736],
                            [2.799803327928466, 48.378487925384775],
                            [2.800366205602521, 48.37839574452107],
                            [2.800948063452046, 48.37831294951513],
                            [2.801847561834057, 48.37822022703036],
                            [2.802327896533707, 48.378190193475696],
                            [2.803018317163776, 48.37816954367282],
                            [2.803611332627112, 48.37816709633966],
                            [2.8044930312979, 48.37819312775507],
                            [2.805257482986111, 48.37823942142173],
                            [2.805934010057579, 48.378313709972595],
                            [2.806594191757865, 48.37842092050679],
                            [2.806910635712471, 48.3784825524816],
                            [2.807186705936732, 48.37853641579208],
                            [2.807551194220757, 48.3786186737446],
                            [2.807903431398984, 48.378695140179275],
                            [2.808287262620804, 48.378793671789765],
                            [2.808628543499887, 48.37888512406479],
                            [2.808902176344857, 48.37896524732036],
                            [2.809241587874725, 48.37906965466149],
                            [2.809650949017997, 48.379208514074946],
                            [2.809885694672334, 48.379293354367505],
                            [2.810210371582848, 48.37941210222083],
                            [2.810473299640536, 48.379523408186195],
                            [2.810726550726919, 48.37963326581886],
                            [2.811046045893848, 48.37977749273188],
                            [2.811350410874251, 48.37991810047534],
                            [2.811656440634826, 48.38007248502223],
                            [2.812060016684274, 48.380291481722075],
                            [2.812336511570756, 48.380447351580074],
                            [2.812648811678011, 48.38061258812495],
                            [2.812975400167187, 48.380777763598246],
                            [2.813505941425138, 48.38105314749179],
                            [2.814195510599813, 48.38142357181096],
                            [2.814697122491966, 48.38168763282923],
                            [2.815956767081606, 48.38235800575609],
                        ],
                    },
                },
                15: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.90262725574345, 2.4679101210146492],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 616.196297122,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.465460481358355,
                            48.90041730406597,
                            2.47012779650017,
                            48.90470320378032,
                        ),
                        "coordinates": [
                            [2.465460481358355, 48.90041730406597],
                            [2.467116481813503, 48.90191711436425],
                            [2.468416665841674, 48.903085921169556],
                            [2.46849252392469, 48.903155394456974],
                            [2.46854066547474, 48.903213797493926],
                            [2.468578771880285, 48.90327533771868],
                            [2.468600085394008, 48.903322086329204],
                            [2.468624986154655, 48.903433294005566],
                            [2.468668730527054, 48.90359736984167],
                            [2.468701368575596, 48.90365262030313],
                            [2.468744056263245, 48.9037048082361],
                            [2.46879614826199, 48.90375314207967],
                            [2.468856858118281, 48.903796889899404],
                            [2.468925260897719, 48.903835387493444],
                            [2.469000321702074, 48.903868051110344],
                            [2.469114836310395, 48.90390315849666],
                            [2.469817504991337, 48.90403647638106],
                            [2.469882876078477, 48.904055703233254],
                            [2.469943027356725, 48.90408128390304],
                            [2.469996551677461, 48.90411261863169],
                            [2.470042191960136, 48.90414897163208],
                            [2.47007888054973, 48.9041894910465],
                            [2.470105756749369, 48.90423322880764],
                            [2.470122191210356, 48.90427915693315],
                            [2.47012779650017, 48.90432620174507],
                            [2.470122443318826, 48.90437325922918],
                            [2.470107545927654, 48.904416477634754],
                            [2.469971544978576, 48.90470320378032],
                        ],
                    },
                },
                16: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.928664240036156, 2.3886083548532833],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 633.55105646,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.384758860075984,
                            48.92740289165737,
                            2.392471119316831,
                            48.92997102620736,
                        ),
                        "coordinates": [
                            [2.392471119316831, 48.92740289165737],
                            [2.391836211901909, 48.92758089052949],
                            [2.391136916896356, 48.92777328656105],
                            [2.390830671891319, 48.92786873110464],
                            [2.390517782334991, 48.92798243261007],
                            [2.389744348724997, 48.92826783726493],
                            [2.388682609351352, 48.92865069816692],
                            [2.387613792493625, 48.929008061775086],
                            [2.38635510926902, 48.92943733823412],
                            [2.385377677582306, 48.92976683203266],
                            [2.384758860075984, 48.92997102620736],
                        ],
                    },
                },
                17: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.91138369912571, 2.4366617245490527],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 384.982043229,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.435420992985438,
                            48.90966636535197,
                            2.437487802213591,
                            48.912704975295874,
                        ),
                        "coordinates": [
                            [2.437487802213591, 48.90966636535197],
                            [2.436754109878076, 48.911425903113],
                            [2.436551200634872, 48.91192895909945],
                            [2.436515311974023, 48.91200686649315],
                            [2.43646662616851, 48.91208822992942],
                            [2.436407781849653, 48.91216662372897],
                            [2.436339191544517, 48.91224149585091],
                            [2.436261337057295, 48.91231232335641],
                            [2.43617476268792, 48.91237860878022],
                            [2.436080077902407, 48.912439885539676],
                            [2.435977943612283, 48.912495725064915],
                            [2.435869078996207, 48.9125457368318],
                            [2.435779008047241, 48.912580822333695],
                            [2.435420992985438, 48.912704975295874],
                        ],
                    },
                },
                18: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.04534072858193, 2.106172270618482],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 155.514119079,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.105110703444507,
                            49.04530962796638,
                            2.107233059674136,
                            49.04539401994291,
                        ),
                        "coordinates": [
                            [2.107233059674136, 49.04539401994291],
                            [2.106582403517276, 49.045354551360596],
                            [2.105934758426439, 49.04532512796745],
                            [2.105610917541017, 49.04531443254045],
                            [2.105221049327595, 49.04530962796638],
                            [2.105110703444507, 49.045311648350264],
                        ],
                    },
                },
                19: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.379019778726, 2.7978126302895676],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 242.866386249,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.796343615000022,
                            48.37859776792736,
                            2.799307429283779,
                            48.37952262366741,
                        ),
                        "coordinates": [
                            [2.796343615000022, 48.37952262366741],
                            [2.797000319222841, 48.379261615476885],
                            [2.797352123268005, 48.37914233984695],
                            [2.797712535958334, 48.379027793970415],
                            [2.798227371862114, 48.37887612293043],
                            [2.798788288699348, 48.378724651131996],
                            [2.799307429283779, 48.37859776792736],
                        ],
                    },
                },
                20: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.4485479385079, 2.7215062118150843],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 8032.72570966,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.692033259866399,
                            48.416377033006604,
                            2.738210817166725,
                            48.4755230723766,
                        ),
                        "coordinates": [
                            [2.726661533081673, 48.416377033006604],
                            [2.726986658138678, 48.417140693732],
                            [2.727345798186738, 48.41781992946304],
                            [2.72756299250814, 48.418171315205484],
                            [2.727769356616908, 48.418508461065514],
                            [2.728040486983366, 48.41890010574532],
                            [2.728327871012224, 48.4192457453491],
                            [2.728747401941021, 48.419711375333925],
                            [2.72916444440831, 48.42015199572559],
                            [2.729615026131733, 48.420587471154015],
                            [2.731704867667564, 48.422457844225114],
                            [2.732971511748013, 48.42357568931441],
                            [2.733394952468326, 48.42398786445735],
                            [2.733732765200332, 48.42433469227287],
                            [2.734369037023407, 48.42500510323783],
                            [2.734742799502794, 48.42543221475421],
                            [2.735127207635353, 48.425881012242726],
                            [2.735648973640984, 48.42658958823863],
                            [2.736210954113941, 48.4274257138859],
                            [2.736730454016712, 48.42835461167416],
                            [2.737135656378466, 48.42918139628824],
                            [2.737510994353277, 48.430158460754086],
                            [2.73783011986764, 48.43120137002651],
                            [2.738021024736048, 48.43209275809406],
                            [2.73815117113718, 48.432989757189816],
                            [2.738204246230493, 48.433711674231525],
                            [2.738210817166725, 48.43453267473404],
                            [2.738141759308018, 48.4355284000061],
                            [2.73807930659066, 48.435998933932474],
                            [2.737904590944704, 48.436964459468705],
                            [2.737792210896972, 48.43744506188221],
                            [2.737644851044388, 48.43794557219136],
                            [2.737409615252215, 48.43861185773486],
                            [2.737328729907203, 48.438806384111295],
                            [2.73713516648589, 48.43927648216298],
                            [2.736854910517911, 48.43989166840407],
                            [2.736499659938606, 48.44059434617139],
                            [2.73594322006713, 48.4414919727546],
                            [2.735877769268981, 48.44158932353692],
                            [2.735823015788552, 48.44167224811111],
                            [2.735551768498164, 48.44206438251455],
                            [2.735162575327905, 48.44258192873389],
                            [2.734750956827061, 48.443080217028324],
                            [2.73436322948491, 48.44353345843046],
                            [2.733928996334741, 48.44399900105242],
                            [2.733462333564197, 48.44446645460683],
                            [2.732945792565143, 48.44495206555066],
                            [2.732644783463515, 48.445234763087655],
                            [2.732307339435341, 48.44552621654909],
                            [2.731796479442139, 48.44592818242115],
                            [2.730798450089744, 48.446724808273025],
                            [2.730018583174712, 48.4473567337031],
                            [2.7290885349158, 48.448103017909496],
                            [2.728259830237224, 48.448783030154914],
                            [2.724639493027038, 48.451705498734896],
                            [2.722789500915932, 48.453194701843216],
                            [2.721497028570242, 48.45423954633243],
                            [2.720205861987529, 48.455285269735846],
                            [2.718913282743654, 48.456330084394196],
                            [2.715445018169386, 48.45912404962778],
                            [2.713398167495356, 48.460757639459445],
                            [2.712165878245331, 48.461766206352465],
                            [2.709699680779072, 48.46376711696281],
                            [2.708385183253715, 48.46483256670907],
                            [2.707918179574805, 48.46521748545662],
                            [2.707472557188555, 48.465552641976224],
                            [2.706746521306709, 48.4660689450631],
                            [2.70624991460592, 48.46640604810272],
                            [2.705774523643334, 48.46672145861911],
                            [2.703917070452122, 48.46789743379212],
                            [2.702652340069023, 48.46871256264989],
                            [2.701567007157238, 48.46940499589657],
                            [2.701093226192951, 48.46971137063555],
                            [2.700167154487338, 48.470306060098345],
                            [2.699601805454366, 48.470668476723255],
                            [2.698619207161681, 48.471305600481685],
                            [2.698328470599237, 48.47149537441684],
                            [2.697796766943694, 48.471838790344904],
                            [2.697426598303561, 48.472079172956064],
                            [2.696527280390612, 48.47264497231067],
                            [2.69559027026669, 48.4732378607693],
                            [2.695053138658947, 48.473583978661615],
                            [2.694416366210666, 48.47399245821119],
                            [2.694007081165644, 48.47425183793106],
                            [2.693121255546687, 48.47482386183596],
                            [2.692269154612462, 48.47537853176761],
                            [2.692033259866399, 48.4755230723766],
                        ],
                    },
                },
                21: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.74114985174119, 2.2932186867638236],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 3269.47188174,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.273483464396533,
                            48.734716586800225,
                            2.312711013515798,
                            48.747941901886946,
                        ),
                        "coordinates": [
                            [2.273483464396533, 48.734716586800225],
                            [2.274031620340385, 48.73489774142893],
                            [2.275473449753474, 48.73538233747892],
                            [2.276333671280968, 48.73566876733563],
                            [2.276904428808763, 48.73586780974144],
                            [2.277130016218571, 48.73594616481338],
                            [2.277400450874468, 48.736038931251876],
                            [2.278114751585832, 48.73629061184682],
                            [2.278288585868304, 48.73634661778088],
                            [2.278468848814772, 48.736401603656944],
                            [2.278655448101448, 48.73645132616507],
                            [2.278824707294772, 48.736493872116554],
                            [2.27896942208531, 48.73652677404454],
                            [2.27917117419971, 48.73656756304211],
                            [2.279459465816022, 48.73662002100706],
                            [2.279772100456614, 48.73667323497265],
                            [2.280207071036519, 48.73674719326826],
                            [2.280557756121379, 48.73681571212309],
                            [2.28079833681008, 48.736868888460535],
                            [2.281050094857402, 48.736934177101105],
                            [2.281649451204855, 48.73708723570982],
                            [2.282179988699193, 48.737229321493196],
                            [2.282715905060216, 48.73736076879698],
                            [2.28346081322031, 48.73755968148079],
                            [2.28402909496622, 48.73771125523257],
                            [2.284358003944237, 48.73781302524864],
                            [2.284654278956173, 48.73792107484667],
                            [2.284907058945396, 48.738018311686574],
                            [2.285234579335344, 48.738152452980955],
                            [2.285793129839512, 48.73838651607704],
                            [2.286662910560374, 48.73874121723714],
                            [2.287618993349294, 48.73913942065063],
                            [2.288441910765133, 48.73948119063661],
                            [2.289417744531419, 48.73987458505421],
                            [2.290606959593062, 48.74037507043785],
                            [2.290952185464527, 48.74051010131528],
                            [2.291393925343595, 48.74066945042673],
                            [2.291777456021941, 48.74079103458878],
                            [2.292338621659828, 48.74096568480165],
                            [2.293081974937282, 48.74118454072133],
                            [2.293736004545056, 48.741369098253784],
                            [2.295511505203764, 48.741870524410345],
                            [2.297202400269014, 48.74233887743137],
                            [2.300400244584853, 48.74318740057063],
                            [2.301246714029321, 48.74344721845134],
                            [2.302263413507445, 48.74375938173845],
                            [2.302933781349519, 48.7439711063506],
                            [2.303303545232317, 48.74409981029637],
                            [2.303797013418046, 48.74428070792639],
                            [2.304335176901581, 48.74448769775749],
                            [2.304745197893997, 48.74467102201594],
                            [2.304981031273856, 48.744791829642836],
                            [2.305547870507395, 48.74508334955477],
                            [2.306037219836903, 48.7453568609457],
                            [2.306682871457191, 48.74576170539381],
                            [2.307403275670077, 48.746247498851424],
                            [2.308134578430528, 48.746719802528396],
                            [2.308449949484962, 48.746909627458685],
                            [2.308724546587425, 48.74706347071359],
                            [2.309017596454245, 48.74720002578425],
                            [2.309251525322473, 48.74729439605155],
                            [2.309557930520907, 48.74741258935359],
                            [2.309762132361388, 48.7474767165459],
                            [2.310015491351156, 48.74756048434858],
                            [2.310271728727082, 48.74763037994978],
                            [2.310543117409528, 48.74769384872567],
                            [2.310818322496114, 48.74775190717779],
                            [2.311142616636978, 48.747811629750544],
                            [2.31142748001463, 48.747856358817074],
                            [2.311790727320648, 48.747898337007165],
                            [2.312197969687264, 48.74792673771592],
                            [2.312529148392644, 48.74793905512518],
                            [2.312711013515798, 48.747941901886946],
                        ],
                    },
                },
                22: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.128051381836364, 2.223634602836481],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 3625.59315599,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.210019869292197,
                            49.114783970085064,
                            2.242677776778168,
                            49.13600056459098,
                        ),
                        "coordinates": [
                            [2.242677776778168, 49.13600056459098],
                            [2.241404282416625, 49.1355703825226],
                            [2.240852323823804, 49.13538647153163],
                            [2.239903183445893, 49.135070030821836],
                            [2.239733353511173, 49.13501323374128],
                            [2.238975968880641, 49.134760794546416],
                            [2.23626698026539, 49.13385738564339],
                            [2.236053332870124, 49.133786156468716],
                            [2.234913897603343, 49.1334038604228],
                            [2.233299268950995, 49.13286285319506],
                            [2.232265317849512, 49.13251839510503],
                            [2.230411092950836, 49.131898893401264],
                            [2.227976310400957, 49.13107917438867],
                            [2.225163674043916, 49.130132239341],
                            [2.224399589170243, 49.12987879906107],
                            [2.223561565325184, 49.129602798510454],
                            [2.222749622606446, 49.129311530450956],
                            [2.222014466740057, 49.12900324716752],
                            [2.22145734679115, 49.128744598056585],
                            [2.219669739220031, 49.12788668171439],
                            [2.218502185456426, 49.1273387281673],
                            [2.216959664985112, 49.126601524850045],
                            [2.21657232880148, 49.1264167691166],
                            [2.215867501979152, 49.126067111456834],
                            [2.215692350594532, 49.12596890618907],
                            [2.215155950925862, 49.12566978102914],
                            [2.21467847964165, 49.12536981698402],
                            [2.214511599403723, 49.12525363348429],
                            [2.214258536460963, 49.12508070339735],
                            [2.213887936254705, 49.12478714432074],
                            [2.213618539565318, 49.12457282931554],
                            [2.213059357801466, 49.1240803267129],
                            [2.212499109566168, 49.12347181356781],
                            [2.212317456009334, 49.123241404054305],
                            [2.211986931907959, 49.12282288389816],
                            [2.211543402886758, 49.12212366657644],
                            [2.211261266494421, 49.1215406304532],
                            [2.211214921604879, 49.12144615593669],
                            [2.211086443078509, 49.12114608550616],
                            [2.210991765668457, 49.12083980317458],
                            [2.210890299210122, 49.12033340171316],
                            [2.210767574732576, 49.11956708727531],
                            [2.210635861786001, 49.11856695283363],
                            [2.21050845506467, 49.117492183205364],
                            [2.210364598647382, 49.116423690022614],
                            [2.210244763764672, 49.11560611982857],
                            [2.210087426728598, 49.1149908444586],
                            [2.210019869292197, 49.114783970085064],
                        ],
                    },
                },
                23: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T2",
                        "rer": 0,
                        "extcode": "100112012:T2",
                        "geo_point_2d": [48.8629041109497, 2.2209433949796162],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01390",
                        "navette": 0,
                        "idrefliga": "A01192",
                        "shape_leng": 1218.02571756,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.220352142320904,
                            48.85747140891035,
                            2.221790167679187,
                            48.86823878484656,
                        ),
                        "coordinates": [
                            [2.220603560028727, 48.85747140891035],
                            [2.220796099243322, 48.858379764558386],
                            [2.220844099807766, 48.858684461158816],
                            [2.220870845109435, 48.858903911665365],
                            [2.220877333911554, 48.859043306574904],
                            [2.220864171444983, 48.85942728465891],
                            [2.220839133160909, 48.85964398486926],
                            [2.220819751331364, 48.85977346125759],
                            [2.220793615687503, 48.85987595236301],
                            [2.220759780494999, 48.860033371312625],
                            [2.220577919206502, 48.860699401793596],
                            [2.220484145427779, 48.86107797159799],
                            [2.220428615668951, 48.8613202583737],
                            [2.220379185425627, 48.86166509304043],
                            [2.220363693005537, 48.861878206215565],
                            [2.220352142320904, 48.86215427236642],
                            [2.220352920857938, 48.862403373215614],
                            [2.220364692253167, 48.86261471584999],
                            [2.220422318949099, 48.863033837617856],
                            [2.220520827126257, 48.863457497425074],
                            [2.220627705277193, 48.86379933205886],
                            [2.220735896736426, 48.86408298923023],
                            [2.220829177858702, 48.86429008659731],
                            [2.220934122341877, 48.86449658345503],
                            [2.221066149341154, 48.864740022203506],
                            [2.221327686544535, 48.86523528810059],
                            [2.221489206123383, 48.865530414380956],
                            [2.221586754218678, 48.865742251237855],
                            [2.221676348484428, 48.86598741497979],
                            [2.221733521037887, 48.86621588885668],
                            [2.221776211792053, 48.86647052250906],
                            [2.221790167679187, 48.866672780498185],
                            [2.22178248140956, 48.86687739614003],
                            [2.221749515195155, 48.867096261345],
                            [2.221683994746964, 48.86735554410614],
                            [2.22163673149517, 48.86751967136353],
                            [2.221571358838069, 48.8677147112664],
                            [2.221410602618016, 48.86823878484656],
                        ],
                    },
                },
                24: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.76624571222825, 2.1546265860375127],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1535.54348104,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.146831644750671,
                            48.764776012952915,
                            2.163947085881832,
                            48.77042520300475,
                        ),
                        "coordinates": [
                            [2.146831644750671, 48.77042520300475],
                            [2.146839575361204, 48.770321959612254],
                            [2.146873092690811, 48.770093682186655],
                            [2.14693520256974, 48.76985347182722],
                            [2.147032885748731, 48.7695758827279],
                            [2.147161777495458, 48.769310810798224],
                            [2.147427373432981, 48.768871505640504],
                            [2.147572381326453, 48.76866041672841],
                            [2.147691286307381, 48.768515830601466],
                            [2.147863449005765, 48.76831827559078],
                            [2.147993178295162, 48.76818899483355],
                            [2.14829351412852, 48.76791251510234],
                            [2.148440898967235, 48.76779045723079],
                            [2.148595671417843, 48.767662475921256],
                            [2.148751952214536, 48.767556260007716],
                            [2.14907649251712, 48.767352659983054],
                            [2.149560438791216, 48.76708367301127],
                            [2.14979685464987, 48.766972065613906],
                            [2.150079001396661, 48.76686020301495],
                            [2.150327388968289, 48.76676194385585],
                            [2.150697958710484, 48.766630916480445],
                            [2.151146005275975, 48.76650883849901],
                            [2.151387073138179, 48.766445477534695],
                            [2.152968950578792, 48.76613509322431],
                            [2.154530379153004, 48.76583095001423],
                            [2.156517878035001, 48.76544202913235],
                            [2.157218934575256, 48.765306445903285],
                            [2.157745735806253, 48.76520745606435],
                            [2.158269800867355, 48.765112055896395],
                            [2.158906826270819, 48.765000643720605],
                            [2.159421272692855, 48.76493130235175],
                            [2.160116648983136, 48.764858642212516],
                            [2.160764321506296, 48.764811983998186],
                            [2.161308536428679, 48.76478584523993],
                            [2.163872745041115, 48.764777178118926],
                            [2.163947085881832, 48.764776012952915],
                        ],
                    },
                },
                25: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T2",
                        "rer": 0,
                        "extcode": "100112012:T2",
                        "geo_point_2d": [48.822937011110035, 2.256054955971231],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01390",
                        "navette": 0,
                        "idrefliga": "A01192",
                        "shape_leng": 782.849804392,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.251336154852571,
                            48.82151752250999,
                            2.260539912317944,
                            48.824767024606686,
                        ),
                        "coordinates": [
                            [2.260539912317944, 48.824767024606686],
                            [2.260361800996562, 48.824585850728525],
                            [2.260182095794907, 48.82440305138972],
                            [2.259908714053019, 48.82416455941692],
                            [2.259667912664161, 48.82399623265351],
                            [2.259482862906137, 48.823884597211375],
                            [2.259175292282888, 48.82374050360679],
                            [2.258971134252713, 48.823657631871036],
                            [2.258790101633279, 48.823591861062354],
                            [2.258503435067726, 48.82351179040565],
                            [2.258262086132251, 48.823461658349814],
                            [2.258089172071254, 48.82343060729822],
                            [2.257822094537732, 48.82339155526009],
                            [2.25757837205502, 48.82335361626446],
                            [2.257429907966087, 48.82333021873776],
                            [2.25726420407571, 48.82329679190478],
                            [2.257102108326206, 48.82326098948832],
                            [2.25693642989142, 48.82321328637516],
                            [2.256756095386268, 48.82315520204152],
                            [2.256472963787103, 48.82306507528023],
                            [2.256218416396302, 48.82298485970566],
                            [2.256041450439721, 48.822935274654164],
                            [2.255733787318334, 48.82285681953932],
                            [2.255368947728279, 48.82276573274445],
                            [2.255027248562904, 48.82268185548021],
                            [2.254693718237483, 48.82260068133661],
                            [2.254436434426526, 48.822532150389456],
                            [2.254248598067071, 48.82246906519939],
                            [2.254022664602985, 48.822383198875414],
                            [2.253814453784881, 48.822289794304915],
                            [2.253588554752909, 48.822186212991184],
                            [2.253378991073308, 48.82208713933748],
                            [2.253215668768215, 48.82202586940999],
                            [2.253048253563228, 48.82196909221765],
                            [2.252771933725496, 48.82188525611853],
                            [2.252462920427197, 48.82180769059293],
                            [2.251873487594521, 48.82165707376658],
                            [2.251336154852571, 48.82151752250999],
                        ],
                    },
                },
                26: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T2",
                        "rer": 0,
                        "extcode": "100112012:T2",
                        "geo_point_2d": [48.82549558320644, 2.2280569437156292],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01390",
                        "navette": 0,
                        "idrefliga": "A01192",
                        "shape_leng": 878.449458672,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.225312853267071,
                            48.82230993293686,
                            2.231323159873781,
                            48.829010503694406,
                        ),
                        "coordinates": [
                            [2.231323159873781, 48.82230993293686],
                            [2.231093432592597, 48.822609125995406],
                            [2.230985735061066, 48.822756742992965],
                            [2.230870117837719, 48.82290177535579],
                            [2.230729226056609, 48.823070576885335],
                            [2.230581162715179, 48.82322271764547],
                            [2.230342885458203, 48.82343425704192],
                            [2.23020074747098, 48.8235444420029],
                            [2.229451831903581, 48.824109383985665],
                            [2.229140950957088, 48.824356312591775],
                            [2.228934718487942, 48.82454234745027],
                            [2.228624881845852, 48.824852304299846],
                            [2.228053019357066, 48.82540211807331],
                            [2.227713222595891, 48.8257057496553],
                            [2.227088244535708, 48.82624561542054],
                            [2.226757827914828, 48.826535893977926],
                            [2.226259773336329, 48.82702808523784],
                            [2.225975732623674, 48.827360542420614],
                            [2.225744847312255, 48.827675064752256],
                            [2.225651871516851, 48.82783504479516],
                            [2.225568948585039, 48.8280027939963],
                            [2.225510991577847, 48.82813598036601],
                            [2.225463806945631, 48.828285832849254],
                            [2.225428518470811, 48.82843374591898],
                            [2.225347274716438, 48.82882582988393],
                            [2.225312853267071, 48.829010503694406],
                        ],
                    },
                },
                27: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.921736659128335, 2.4086047925293763],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 361.696596821,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.406622752354694,
                            48.920785969955396,
                            2.410598615094689,
                            48.922711188353,
                        ),
                        "coordinates": [
                            [2.410598615094689, 48.920785969955396],
                            [2.409991799676058, 48.921091218861285],
                            [2.40902538594671, 48.921522870475776],
                            [2.408374933942032, 48.921837923853985],
                            [2.407057468263527, 48.922474234749],
                            [2.406622752354694, 48.922711188353],
                        ],
                    },
                },
                28: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.716884021644645, 2.4470935220619707],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 3717.07077233,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.438093383889102,
                            48.70823782858165,
                            2.462282244689792,
                            48.73011683142026,
                        ),
                        "coordinates": [
                            [2.462282244689792, 48.70823782858165],
                            [2.460983910433233, 48.70879460381943],
                            [2.460264468713545, 48.70910940162476],
                            [2.45989156299872, 48.70928770107002],
                            [2.459540394511254, 48.70947546745735],
                            [2.459186371898107, 48.70968137901128],
                            [2.458828870992446, 48.70990805478701],
                            [2.4581193284077, 48.710365645385814],
                            [2.45788462065311, 48.71051697335805],
                            [2.4573934369007, 48.710810659335635],
                            [2.457066390778859, 48.71098996065503],
                            [2.456146253745974, 48.71147204257776],
                            [2.455711881415892, 48.71166494265567],
                            [2.455406437124127, 48.711790260756786],
                            [2.45442359216518, 48.71220045254005],
                            [2.453762414097586, 48.71245293242585],
                            [2.451625523919498, 48.7133130196957],
                            [2.451142189484145, 48.713502354460644],
                            [2.450760658087116, 48.713643024944055],
                            [2.450474138316585, 48.713735037731645],
                            [2.45012376227197, 48.71383340884293],
                            [2.449712228421354, 48.71392914211516],
                            [2.449243587887568, 48.71401144056516],
                            [2.448787122355311, 48.71407034461838],
                            [2.448427319688785, 48.7141076013759],
                            [2.448015377294803, 48.71412506080166],
                            [2.447647093473568, 48.71411822694539],
                            [2.446926798726546, 48.71408835290434],
                            [2.446281276317311, 48.714072790965105],
                            [2.445407435106446, 48.71404755225977],
                            [2.44471845892446, 48.7140464104308],
                            [2.444150481297779, 48.714070330422494],
                            [2.443659987170575, 48.714105865696325],
                            [2.443169542254486, 48.71416477873885],
                            [2.442869323816343, 48.714213620946566],
                            [2.442552623224028, 48.71426550651059],
                            [2.442255364780425, 48.71434368775591],
                            [2.441614354305444, 48.71453582667013],
                            [2.441231430498669, 48.71467646649414],
                            [2.440803740234079, 48.714856713288114],
                            [2.440404624068385, 48.71505491884784],
                            [2.44005715933288, 48.71526026876353],
                            [2.439504846271283, 48.715639363933136],
                            [2.439275602654027, 48.715844604756086],
                            [2.439032833066198, 48.71608133259323],
                            [2.438822682066663, 48.71632072727946],
                            [2.438653267876831, 48.71654479851283],
                            [2.438431101762117, 48.716906959958216],
                            [2.438249711512178, 48.71729614086154],
                            [2.438178333422549, 48.717559518330255],
                            [2.438116704366139, 48.7179021951341],
                            [2.438093383889102, 48.71822263243712],
                            [2.438108347463893, 48.71850813798271],
                            [2.43815434831925, 48.7187313567867],
                            [2.438233522983043, 48.71911851748304],
                            [2.438364435249654, 48.7194806567947],
                            [2.43852495245468, 48.71982326862533],
                            [2.438704570856386, 48.720127660535574],
                            [2.43895095254639, 48.72041813306976],
                            [2.439645733248798, 48.72115958316324],
                            [2.43999873658582, 48.72144716199589],
                            [2.440384148210437, 48.72175374324625],
                            [2.440884786413756, 48.722131597580464],
                            [2.441352983723824, 48.722469032149334],
                            [2.441752777144327, 48.72276607883646],
                            [2.442040937787661, 48.72298946892722],
                            [2.44223548143611, 48.72315584184236],
                            [2.442469725183576, 48.72338879718654],
                            [2.442657165211647, 48.7235956239343],
                            [2.442844687405979, 48.72384051987785],
                            [2.443028625997199, 48.724090176611114],
                            [2.443194594919307, 48.72434460977975],
                            [2.4434291891175, 48.724736978193924],
                            [2.443839778338836, 48.725681117140645],
                            [2.444123624612847, 48.726203326118146],
                            [2.444202786960045, 48.7263543286648],
                            [2.444305117491671, 48.726533186922836],
                            [2.444408805593823, 48.72671114474048],
                            [2.444523377410538, 48.72689268881358],
                            [2.444943425580544, 48.72755208104018],
                            [2.44541690109799, 48.728360348361576],
                            [2.445687086449872, 48.72883670349414],
                            [2.445830415179587, 48.72911084413214],
                            [2.445921963217562, 48.72932658073056],
                            [2.446005440453732, 48.729580994507565],
                            [2.446054793282373, 48.72977069404581],
                            [2.446105500724956, 48.729957693392315],
                            [2.446135830934545, 48.73011683142026],
                        ],
                    },
                },
                29: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.80659675454427, 2.926148663533012],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 5114.77794539,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.906161397416222,
                            48.78949667687371,
                            2.953730383101934,
                            48.813619747962505,
                        ),
                        "coordinates": [
                            [2.953730383101934, 48.81077532178037],
                            [2.953329211502365, 48.81087793726541],
                            [2.952789100876691, 48.8109998660778],
                            [2.952324895610694, 48.811078507869055],
                            [2.951854017070723, 48.811147814330866],
                            [2.951134958747968, 48.81123811218608],
                            [2.95046067222862, 48.81132537814673],
                            [2.947656093543874, 48.811687566673115],
                            [2.946816530371679, 48.811803417376616],
                            [2.946083033892751, 48.81193038023987],
                            [2.945431494854362, 48.81204659363544],
                            [2.944607032364517, 48.812214664030705],
                            [2.943441809812445, 48.812466379048445],
                            [2.939602450196421, 48.81329431293807],
                            [2.939011335808973, 48.81339456086146],
                            [2.938611363484698, 48.81344999751361],
                            [2.938140520447207, 48.81350871839909],
                            [2.937572957442571, 48.81355704977085],
                            [2.937042075280546, 48.813597393501475],
                            [2.936448304364605, 48.813616795038996],
                            [2.93588630545274, 48.813619747962505],
                            [2.935324105164708, 48.81360604386553],
                            [2.934808596099368, 48.813580195208004],
                            [2.934159799589404, 48.81354476750924],
                            [2.933568659139823, 48.813503208649074],
                            [2.932980950953201, 48.813434338047145],
                            [2.932569371105819, 48.81337073351317],
                            [2.932121129536421, 48.81329682800951],
                            [2.931669677002505, 48.813208264876295],
                            [2.931153569433, 48.81309134838635],
                            [2.93063038464191, 48.81295381949701],
                            [2.929978271724415, 48.81275834916493],
                            [2.929432082661814, 48.81257559445242],
                            [2.928811872222717, 48.81232113420862],
                            [2.928019212768972, 48.81196192678717],
                            [2.927584841926005, 48.811745245852975],
                            [2.927164166842634, 48.81151186247822],
                            [2.926685206783411, 48.81122405228713],
                            [2.92634251858611, 48.81099845987687],
                            [2.9256642643071, 48.81052353423742],
                            [2.925300071307058, 48.81023853707957],
                            [2.924939817954663, 48.80994092680508],
                            [2.923592052916786, 48.808803057183],
                            [2.922736550761754, 48.80807092654039],
                            [2.921069715830944, 48.8066769264118],
                            [2.920660616016986, 48.80636390621538],
                            [2.920067475727485, 48.80593887378623],
                            [2.919624356893845, 48.80565156412965],
                            [2.918827852885868, 48.80518169993301],
                            [2.917996240911639, 48.804735391940746],
                            [2.917063121751383, 48.804240104709315],
                            [2.915817875932205, 48.80355939534779],
                            [2.914634404566135, 48.80293768714485],
                            [2.913450961583915, 48.80231422211566],
                            [2.912102067667015, 48.80158343167483],
                            [2.911372307606685, 48.80115017377197],
                            [2.910578352990439, 48.80063696892352],
                            [2.90977821719795, 48.80008892681216],
                            [2.909333548296815, 48.799775505424456],
                            [2.909064360102315, 48.79956911741686],
                            [2.908585670802458, 48.79915928469009],
                            [2.908092969009444, 48.798670189515406],
                            [2.907814541634286, 48.79836941887951],
                            [2.907625554744399, 48.79813618818794],
                            [2.907417861804971, 48.79784621138876],
                            [2.907276445483669, 48.79762209330325],
                            [2.907126327468852, 48.79735125501844],
                            [2.906807827098722, 48.79675930847902],
                            [2.906632133484097, 48.79639417028809],
                            [2.906469209773402, 48.79596537710317],
                            [2.906311180527012, 48.795348984970815],
                            [2.906226777756416, 48.79492202704146],
                            [2.906179382374182, 48.79453667318341],
                            [2.906161397416222, 48.79427326736863],
                            [2.90617093462054, 48.793818259358204],
                            [2.906224503946948, 48.79330090616567],
                            [2.906317326397706, 48.79276344833569],
                            [2.906430964025943, 48.79232455258264],
                            [2.906526129566338, 48.79200879778995],
                            [2.907387270372533, 48.78949667687371],
                        ],
                    },
                },
                30: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.8111628812768, 3.061798363457108],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 2985.59158757,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            3.042938266046296,
                            48.80850206349516,
                            3.080343011929784,
                            48.81379848212747,
                        ),
                        "coordinates": [
                            [3.080343011929784, 48.80850206349516],
                            [3.077337778782705, 48.80999479199734],
                            [3.076203956715552, 48.81054704631031],
                            [3.075637423893467, 48.81079534474709],
                            [3.074624970621095, 48.811206866164355],
                            [3.074109584200572, 48.811415209083286],
                            [3.073608284995546, 48.81160257434704],
                            [3.073257314184835, 48.811717256529384],
                            [3.072842308029973, 48.81182965276151],
                            [3.072397161657425, 48.81192965196878],
                            [3.072056771736029, 48.811985988283766],
                            [3.07154987570324, 48.81204763426375],
                            [3.071150429905094, 48.81207876106522],
                            [3.07064266552498, 48.812093925838596],
                            [3.070174614624569, 48.81209325355607],
                            [3.069730800639253, 48.81206885645771],
                            [3.06922741406098, 48.81201542050371],
                            [3.068768605683843, 48.811948501513655],
                            [3.068281031903928, 48.81184910701382],
                            [3.067869039132653, 48.81174758022826],
                            [3.067258228455184, 48.81158362811228],
                            [3.066055549972939, 48.811255417993024],
                            [3.064562672837766, 48.81084766964273],
                            [3.063570161269064, 48.810576107919594],
                            [3.063190249204707, 48.81048077320204],
                            [3.062731238120739, 48.81037820479021],
                            [3.062299734494043, 48.810293716266784],
                            [3.061734649862922, 48.81019928447444],
                            [3.061337177726046, 48.810142780910866],
                            [3.060850704234703, 48.810087987868364],
                            [3.060318775992009, 48.81004214102092],
                            [3.059727520435087, 48.810004282581815],
                            [3.059162589014512, 48.809990013659],
                            [3.058539993926606, 48.80999022031065],
                            [3.05795603690172, 48.81001192664627],
                            [3.057420476558753, 48.81005655942325],
                            [3.056979738827774, 48.8100945127738],
                            [3.056536570203853, 48.81014407546588],
                            [3.056114288123208, 48.810204396527894],
                            [3.055736420541823, 48.810271429791825],
                            [3.055361687483528, 48.8103457371135],
                            [3.054923853522874, 48.810442370048946],
                            [3.054450694137266, 48.810562084202886],
                            [3.053470575770452, 48.8108306791563],
                            [3.052621725555496, 48.81107612898464],
                            [3.051925008576484, 48.811273284102455],
                            [3.05109163126128, 48.81150829539009],
                            [3.050282368077969, 48.81173650053079],
                            [3.049613514773414, 48.811926650424],
                            [3.048899124828313, 48.81212859854744],
                            [3.04806640062477, 48.81236457758318],
                            [3.047031617794968, 48.81265700927636],
                            [3.045692455870439, 48.81302268428452],
                            [3.04425523172087, 48.813428793955524],
                            [3.042938266046296, 48.81379848212747],
                        ],
                    },
                },
                31: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.7063564569781, 2.4731877714913058],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 1679.0416788,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.462282244689792,
                            48.70563117036449,
                            2.484245146583624,
                            48.70823782858165,
                        ),
                        "coordinates": [
                            [2.484245146583624, 48.70661094689584],
                            [2.483999090311285, 48.706578257972986],
                            [2.48299836448982, 48.70643143780319],
                            [2.482413004274576, 48.7063340427909],
                            [2.481458498299263, 48.7061728730927],
                            [2.480704140633706, 48.70604107453491],
                            [2.48011354949652, 48.70594646880368],
                            [2.479517385293175, 48.705865980715004],
                            [2.478807926423619, 48.70578953251095],
                            [2.478110095024648, 48.705730431143486],
                            [2.477258683545632, 48.70567275667939],
                            [2.476822478805115, 48.705649914143045],
                            [2.476243636639174, 48.70563623900458],
                            [2.475977319575276, 48.70563117036449],
                            [2.475494992029789, 48.70563445835077],
                            [2.474875455476397, 48.70564420577465],
                            [2.474666234679159, 48.705650755584216],
                            [2.474510000606064, 48.70565634035054],
                            [2.474245076312613, 48.70566385562254],
                            [2.473408270082582, 48.70571792284229],
                            [2.472821455820152, 48.70576988616582],
                            [2.472192567143237, 48.705838983167816],
                            [2.471522957362155, 48.70592341216338],
                            [2.471028580198388, 48.705994141285274],
                            [2.470418799794077, 48.706097377111234],
                            [2.469476054655626, 48.70628194199456],
                            [2.468648054671239, 48.70647714204885],
                            [2.468087275787389, 48.706618079066395],
                            [2.466859775096365, 48.70691715067424],
                            [2.4655133330434, 48.70724299521899],
                            [2.464567693276872, 48.707482698255745],
                            [2.46392409849711, 48.70765877891531],
                            [2.463453002050065, 48.70781128272832],
                            [2.462804681259587, 48.708024074480846],
                            [2.462437563629043, 48.7081712211007],
                            [2.462282244689792, 48.70823782858165],
                        ],
                    },
                },
                32: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.61195541721638, 2.5767288541006903],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 3798.63575937,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.56958354823646,
                            48.595563837991776,
                            2.58394771106125,
                            48.62837555172384,
                        ),
                        "coordinates": [
                            [2.58394771106125, 48.595563837991776],
                            [2.583117344654084, 48.59747915687793],
                            [2.582574627318395, 48.598818573486696],
                            [2.582073603471251, 48.59996344602832],
                            [2.581087273327229, 48.60219500150275],
                            [2.580061588083991, 48.60446708110959],
                            [2.57951153778809, 48.605705508428805],
                            [2.578744745254357, 48.60738457044565],
                            [2.578446637034757, 48.60805855514081],
                            [2.577967609656476, 48.60916120253005],
                            [2.577655265455324, 48.60986376665252],
                            [2.577413868423425, 48.61039962783699],
                            [2.57667563520148, 48.61207861536173],
                            [2.576015382845692, 48.61356708785904],
                            [2.575553905565817, 48.61461020447449],
                            [2.575163322747977, 48.61547472146526],
                            [2.574698130966103, 48.61649880773506],
                            [2.574378699718054, 48.61723944756969],
                            [2.574123182059039, 48.617839572326695],
                            [2.573853385855744, 48.61845638251498],
                            [2.573217440869168, 48.619818948949],
                            [2.572913166623866, 48.620506889587936],
                            [2.57278970824799, 48.62078771955357],
                            [2.572663601230039, 48.62108204337581],
                            [2.572528048157026, 48.62138717766877],
                            [2.572392486483136, 48.62169051357187],
                            [2.572189848438892, 48.62215226050985],
                            [2.572032792067063, 48.622500604154915],
                            [2.571867703899166, 48.622872345615335],
                            [2.571656994738576, 48.62335029486997],
                            [2.571456971374416, 48.62379404918274],
                            [2.571285164909932, 48.62418109122728],
                            [2.570953586615855, 48.62492007805811],
                            [2.570797867899989, 48.625268416959315],
                            [2.570660987433426, 48.62558434382758],
                            [2.570541557777406, 48.625861565249814],
                            [2.570313429010005, 48.6264135510181],
                            [2.57010763665612, 48.62696626527897],
                            [2.569971896368711, 48.627297121567615],
                            [2.569800402378706, 48.62775385935917],
                            [2.569698750821867, 48.62803512581767],
                            [2.56958354823646, 48.62837555172384],
                        ],
                    },
                },
                33: {
                    "attributes": {
                        "reseau": "RER E",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER E",
                        "rer": 1,
                        "extcode": "800:E",
                        "geo_point_2d": [48.862011753167764, 2.486683183549044],
                        "indice_lig": "E",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01729",
                        "navette": 0,
                        "idrefliga": "A01843",
                        "shape_leng": 1774.87225707,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.485192413733974,
                            48.85426899363537,
                            2.489167460948015,
                            48.86991241918608,
                        ),
                        "coordinates": [
                            [2.485761140611789, 48.86991241918608],
                            [2.485403140820869, 48.86804852924353],
                            [2.485296894981928, 48.867494280596155],
                            [2.485237977223209, 48.86708748898079],
                            [2.485204566862315, 48.86676869949371],
                            [2.48519291070255, 48.86648795169036],
                            [2.485192413733974, 48.86632139865094],
                            [2.485195565335754, 48.866169116595756],
                            [2.485205832004424, 48.86598351428096],
                            [2.485219795221389, 48.86582883789328],
                            [2.485237338016089, 48.86566464035502],
                            [2.48525851491468, 48.86550995537428],
                            [2.485286891217929, 48.86535050159098],
                            [2.485322444662407, 48.86517914269481],
                            [2.48536163207203, 48.865017296347084],
                            [2.485400847911842, 48.864864966831185],
                            [2.485454390657542, 48.86467930842683],
                            [2.485511551502227, 48.86449840411123],
                            [2.485575917800938, 48.86431511060469],
                            [2.485650961964073, 48.86408421531657],
                            [2.485915670629444, 48.86336292829613],
                            [2.486530753394955, 48.861634717413814],
                            [2.487149450555291, 48.859923154078274],
                            [2.487764484693475, 48.858206834380155],
                            [2.488286436263018, 48.8567238098652],
                            [2.488872799812502, 48.85509079809266],
                            [2.489137306418753, 48.85435309723007],
                            [2.489167460948015, 48.85426899363537],
                        ],
                    },
                },
                34: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.83918106271761, 2.1451699821754406],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1296.24745061,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.138125058777295,
                            48.83664331803193,
                            2.152697400276265,
                            48.84271995435486,
                        ),
                        "coordinates": [
                            [2.152697400276265, 48.83664331803193],
                            [2.151494450276671, 48.83716336132657],
                            [2.151448055590113, 48.837183969970084],
                            [2.151304790197782, 48.83724398874261],
                            [2.151201096376565, 48.83728698482183],
                            [2.151011429272439, 48.8373694095978],
                            [2.150595324053422, 48.837530601038715],
                            [2.150199753356664, 48.837664846442614],
                            [2.149982900686715, 48.83773013915898],
                            [2.149798805622502, 48.837779297255494],
                            [2.149389755027156, 48.83787394933208],
                            [2.148417688555967, 48.83806928990928],
                            [2.14827453022489, 48.83809962869864],
                            [2.147561473468476, 48.83824772762844],
                            [2.147317431968593, 48.838296782967966],
                            [2.14727925589169, 48.838304813075155],
                            [2.147183822059724, 48.83832353880348],
                            [2.147110194706043, 48.83833960395889],
                            [2.146597544958928, 48.838448461902],
                            [2.14461117078485, 48.83882732423409],
                            [2.144365707474712, 48.8388898605139],
                            [2.144079298144692, 48.83897211019468],
                            [2.143608678111592, 48.83912958650049],
                            [2.14328669413643, 48.839250443934375],
                            [2.142919592427779, 48.839411690719615],
                            [2.142703918167032, 48.83952013581845],
                            [2.142292943197358, 48.839751450500074],
                            [2.14169049027014, 48.840172182428645],
                            [2.138556300228687, 48.84240418422912],
                            [2.138125058777295, 48.84271995435486],
                        ],
                    },
                },
                35: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T4",
                        "rer": 0,
                        "extcode": "800:T4",
                        "geo_point_2d": [48.92909136234755, 2.5174275746191577],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01843",
                        "navette": 0,
                        "idrefliga": "A01761",
                        "shape_leng": 579.755346369,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.515049661053076,
                            48.92664020200147,
                            2.519103763829303,
                            48.93093418298108,
                        ),
                        "coordinates": [
                            [2.519103763829303, 48.92664020200147],
                            [2.51906853702209, 48.926880573079195],
                            [2.519011538134676, 48.92709242687639],
                            [2.518940174352807, 48.92732571662312],
                            [2.518829209567769, 48.92759238140457],
                            [2.518725242726364, 48.92779717134455],
                            [2.518621176026457, 48.92797578813974],
                            [2.518502684983046, 48.928159186781215],
                            [2.518366160674937, 48.92834975109646],
                            [2.518222362070218, 48.92852605130038],
                            [2.518089309729086, 48.92867854115958],
                            [2.517913044745209, 48.92886440999888],
                            [2.517362540898407, 48.92941252991702],
                            [2.517193415230611, 48.92957697317273],
                            [2.516894626256906, 48.92983441301489],
                            [2.516584964309326, 48.9300823540995],
                            [2.516372465360181, 48.93023734420043],
                            [2.516095058540809, 48.93041860950493],
                            [2.51581759837837, 48.93058559970386],
                            [2.515572481458548, 48.930709709364464],
                            [2.515049661053076, 48.93093418298108],
                        ],
                    },
                },
                36: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.95568359366042, 3.0755669614314884],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 7364.99319997,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            3.026111294286066,
                            48.95045023942411,
                            3.124909020747328,
                            48.95947688730028,
                        ),
                        "coordinates": [
                            [3.026111294286066, 48.959164063062694],
                            [3.028700339714932, 48.959193407815334],
                            [3.033946724675614, 48.95925150744609],
                            [3.036649619814603, 48.95928211943009],
                            [3.045346964591205, 48.95937421664601],
                            [3.054158214157287, 48.959469220501],
                            [3.054984354226941, 48.95947688730028],
                            [3.055621642034194, 48.95946860277293],
                            [3.056213158979291, 48.95944346934821],
                            [3.056849887850346, 48.959396634586696],
                            [3.057479831969095, 48.95933056502685],
                            [3.058148361922584, 48.95923426809352],
                            [3.058836055738936, 48.95911428921469],
                            [3.059672640722872, 48.95894625269894],
                            [3.06121578830073, 48.958615266944285],
                            [3.066240709199769, 48.95754471309947],
                            [3.069939562176635, 48.95675655335456],
                            [3.070561972051204, 48.95662407343478],
                            [3.071194070612321, 48.956487243887274],
                            [3.071657652190732, 48.95639004146513],
                            [3.072286557106454, 48.95625750909456],
                            [3.072928493980969, 48.95612703193325],
                            [3.073473295421727, 48.95602501605137],
                            [3.073933935981002, 48.95594923815714],
                            [3.077012249740354, 48.95545238059269],
                            [3.081461644560318, 48.954742722850455],
                            [3.084169028973149, 48.95430512396928],
                            [3.084719225170145, 48.954228242540474],
                            [3.085264437290602, 48.95415638618454],
                            [3.085876360562912, 48.954096069899954],
                            [3.086699114158378, 48.9540511101323],
                            [3.089247190882916, 48.953947043576704],
                            [3.0902886086884, 48.95390854339689],
                            [3.09109494003099, 48.95387824503366],
                            [3.091878339602421, 48.95384887334951],
                            [3.093106365654227, 48.95378500340465],
                            [3.093460417621238, 48.95376102214178],
                            [3.094061543767709, 48.95371114683146],
                            [3.094882389551664, 48.953635015922984],
                            [3.095445459643547, 48.95357465254015],
                            [3.095937671185737, 48.95351142518824],
                            [3.097449368054931, 48.953299843715264],
                            [3.10039458288502, 48.95289379700788],
                            [3.103709434527481, 48.95242926121986],
                            [3.104407135569551, 48.952332250555486],
                            [3.105514713256113, 48.95216891903031],
                            [3.106833856894506, 48.951948789644746],
                            [3.107848778818346, 48.95175569470668],
                            [3.108771581874937, 48.95156240587081],
                            [3.110671654770488, 48.951167342277074],
                            [3.111304695356839, 48.951036599676925],
                            [3.111977229784618, 48.95091534073006],
                            [3.112423718937953, 48.950842354777215],
                            [3.112889737442756, 48.950771518644686],
                            [3.113397872871054, 48.95071248301526],
                            [3.11399370778419, 48.95064846998484],
                            [3.114476089073836, 48.95060687892097],
                            [3.114938396771792, 48.950575416264996],
                            [3.115476616716733, 48.95054676620583],
                            [3.116558532170003, 48.95051607115102],
                            [3.118356037172339, 48.95047880705511],
                            [3.11937238606898, 48.95046019309725],
                            [3.119852731638431, 48.95045023942411],
                            [3.120520409928101, 48.95045232628279],
                            [3.120968117863072, 48.95045758289322],
                            [3.121426100081013, 48.950472761382535],
                            [3.122393058777563, 48.95052941163141],
                            [3.122856415399733, 48.95056453520726],
                            [3.123439016891862, 48.95062382107558],
                            [3.124103346364604, 48.95070058178538],
                            [3.124909020747328, 48.95081998757722],
                        ],
                    },
                },
                37: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.819380272260695, 2.195423262875548],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1940.22611855,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.188259860000294,
                            48.81257171717766,
                            2.200721257947835,
                            48.8272387754095,
                        ),
                        "coordinates": [
                            [2.188259860000294, 48.81257171717766],
                            [2.18977173089294, 48.81447792661163],
                            [2.189817854884192, 48.814536438585144],
                            [2.189880267957558, 48.814612058709386],
                            [2.190284571652338, 48.81511257772727],
                            [2.190527497518925, 48.81538986762242],
                            [2.190691712957203, 48.81557712747344],
                            [2.190853279230943, 48.815739204791704],
                            [2.190918445474538, 48.81580583450609],
                            [2.191009444196634, 48.81588598697984],
                            [2.191078696426578, 48.81595262175729],
                            [2.191165605292646, 48.81603456771417],
                            [2.191514647029684, 48.816348861240286],
                            [2.191794485413418, 48.81658033139004],
                            [2.192138224509382, 48.81684785422946],
                            [2.192414098347767, 48.81703975029532],
                            [2.192805540364206, 48.81729474083723],
                            [2.192855834424884, 48.81732627963286],
                            [2.192893897575333, 48.81734880930482],
                            [2.193312595117685, 48.817598437267954],
                            [2.193729974448492, 48.817834572803044],
                            [2.194971361017204, 48.81850069086825],
                            [2.196381503666261, 48.81923166825301],
                            [2.196910272897255, 48.81954639257153],
                            [2.197231024107471, 48.819776987004445],
                            [2.197574853164364, 48.820040767528695],
                            [2.197934923038173, 48.82033167379007],
                            [2.198174690283779, 48.82055047437471],
                            [2.198313907605619, 48.820678356718965],
                            [2.198752519384207, 48.82113302449515],
                            [2.198838023237781, 48.82123834372864],
                            [2.199055191565388, 48.82150119528909],
                            [2.199333237856536, 48.821911601361165],
                            [2.199532563556481, 48.82222658902717],
                            [2.19958265460223, 48.82233456299452],
                            [2.1997298831254, 48.82262274037754],
                            [2.199854742676403, 48.82293380849898],
                            [2.199943941533043, 48.82317547081763],
                            [2.200026192789215, 48.82348347348516],
                            [2.200124394198703, 48.82392693510873],
                            [2.200140507601999, 48.82401058753482],
                            [2.200155270760345, 48.824089741149876],
                            [2.200267917081906, 48.82472926231235],
                            [2.200305389839422, 48.82497031358611],
                            [2.200478604419895, 48.82587429509449],
                            [2.200486644086928, 48.82592286563294],
                            [2.200498723526633, 48.82598762794323],
                            [2.200530897228218, 48.82617561531387],
                            [2.20059528646788, 48.826535403866295],
                            [2.200655619224576, 48.826885294333515],
                            [2.200674388675792, 48.82699412916455],
                            [2.20068917234138, 48.82706698869271],
                            [2.200721257947835, 48.8272387754095],
                        ],
                    },
                },
                38: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.068221426069414, 2.1978835203495612],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 2447.39113016,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.191244759191911,
                            49.058047811766336,
                            2.205446725524735,
                            49.07769904281828,
                        ),
                        "coordinates": [
                            [2.205446725524735, 49.07769904281828],
                            [2.204806727457009, 49.076869223928355],
                            [2.204322398107003, 49.07626255546574],
                            [2.203960892017576, 49.07579901173805],
                            [2.203532532177559, 49.07525625346355],
                            [2.202823274165091, 49.07431838432103],
                            [2.201955752901646, 49.07320047018822],
                            [2.201905277492038, 49.073138361020604],
                            [2.201551951653985, 49.072703595241045],
                            [2.201285864157705, 49.07240292447033],
                            [2.201053799286954, 49.07217513339117],
                            [2.200840933229804, 49.07199714229422],
                            [2.200585334631, 49.07180497681357],
                            [2.199721874369569, 49.07123200988989],
                            [2.199231398855944, 49.07090858371576],
                            [2.198981381682828, 49.07074371599094],
                            [2.198411674778181, 49.070368932452475],
                            [2.198201305190892, 49.07022209627837],
                            [2.197996237373011, 49.07006409660289],
                            [2.197836720840645, 49.06991590232351],
                            [2.197479085492922, 49.069573744650654],
                            [2.197339987685086, 49.069393720721195],
                            [2.197237709526699, 49.06926140263168],
                            [2.197018298629368, 49.06892660566757],
                            [2.196791150255154, 49.06849227104825],
                            [2.196597907141723, 49.068034912117156],
                            [2.196364166987325, 49.06744740008892],
                            [2.196182006672561, 49.06701282765043],
                            [2.19570086437753, 49.065838684046795],
                            [2.195464448275426, 49.065237678375695],
                            [2.194906996078088, 49.06396091947925],
                            [2.194683838791784, 49.0635146037255],
                            [2.194418348118311, 49.06303855851216],
                            [2.194090139366126, 49.0624832980704],
                            [2.193606484260956, 49.06173719645499],
                            [2.193211377727299, 49.06113418879083],
                            [2.192827330256025, 49.0604961220893],
                            [2.192339642569011, 49.05973831951797],
                            [2.191980077380003, 49.059158732968434],
                            [2.191557772949955, 49.05851162012874],
                            [2.191283914193455, 49.05810839809772],
                            [2.191244759191911, 49.058047811766336],
                        ],
                    },
                },
                39: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [49.02582179995458, 2.0854330285425045],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 3199.48278728,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.078284568034463,
                            49.014133684983044,
                            2.091284826714122,
                            49.03646398072535,
                        ),
                        "coordinates": [
                            [2.079534939997374, 49.03646398072535],
                            [2.080630001149099, 49.035737394307],
                            [2.080866042491933, 49.03558504482191],
                            [2.082089687714947, 49.03488273695746],
                            [2.082608216810195, 49.03458532855274],
                            [2.083715127867986, 49.03396727747421],
                            [2.085266399054012, 49.03310199153051],
                            [2.086471977933504, 49.032431971975036],
                            [2.087653404473906, 49.03182396298089],
                            [2.088109707639061, 49.03157842727302],
                            [2.088577135965932, 49.03133606941406],
                            [2.088909010527916, 49.03115659802896],
                            [2.089230299877848, 49.03095838270194],
                            [2.089540462554628, 49.03074865824792],
                            [2.089860131583701, 49.03049951689638],
                            [2.090190951038185, 49.0301909135544],
                            [2.090503909471019, 49.02983468530743],
                            [2.090729820570972, 49.02951871767404],
                            [2.090915940711826, 49.02920028563079],
                            [2.091102600190946, 49.02877240220407],
                            [2.09120916929756, 49.02844190295927],
                            [2.091257649225088, 49.028151727236015],
                            [2.091284826714122, 49.027778226909874],
                            [2.09126486096519, 49.02742604039942],
                            [2.09123328898478, 49.0272261076615],
                            [2.091169575734375, 49.0269404500029],
                            [2.091069790340119, 49.026633298933156],
                            [2.090948286030414, 49.02632848133386],
                            [2.09080509517082, 49.02601885922264],
                            [2.090622451782062, 49.025640150706785],
                            [2.0897081715483, 49.0239678770201],
                            [2.089367338866619, 49.02339133901145],
                            [2.08915179808744, 49.02308393661535],
                            [2.088939651991842, 49.022821749101894],
                            [2.088720081508918, 49.02259761557288],
                            [2.088467998049307, 49.022363891604115],
                            [2.088259011867006, 49.02219450423433],
                            [2.088028330661265, 49.022022690971745],
                            [2.087743454737624, 49.021836481311986],
                            [2.087440481655731, 49.02165261348585],
                            [2.087112127813076, 49.02148058373926],
                            [2.086697126961103, 49.02127267595191],
                            [2.086238788952715, 49.02105039333346],
                            [2.085859890840416, 49.02085921436126],
                            [2.085488264964706, 49.02066091356204],
                            [2.084914668611982, 49.020340820748515],
                            [2.08427264509612, 49.019961090340075],
                            [2.081239292224347, 49.01818888125132],
                            [2.080748757798128, 49.01790702035803],
                            [2.080373766846072, 49.017668246014985],
                            [2.080020509629092, 49.01742476035577],
                            [2.079743134769261, 49.01719809931921],
                            [2.079487493825301, 49.01696672850629],
                            [2.079293140001917, 49.01677594262866],
                            [2.079084567036572, 49.016537539993905],
                            [2.078872676435314, 49.01624202174061],
                            [2.078718306011328, 49.01601563543059],
                            [2.078578678793434, 49.01573693577666],
                            [2.07846081767029, 49.01544639168923],
                            [2.078379108064912, 49.01516068325311],
                            [2.078326163420755, 49.014908353596375],
                            [2.078284568034463, 49.01456087315983],
                            [2.078289810937325, 49.014249190822],
                            [2.078306591409993, 49.014133684983044],
                        ],
                    },
                },
                40: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.80811669921215, 2.182660361141946],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1251.67386034,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.175926961285955,
                            48.80565394221556,
                            2.188259860000294,
                            48.81257171717766,
                        ),
                        "coordinates": [
                            [2.175926961285955, 48.80565394221556],
                            [2.176244638619483, 48.805679292531046],
                            [2.17656767040842, 48.805715322509414],
                            [2.17689606892237, 48.80575669508684],
                            [2.177326734230471, 48.80581777695293],
                            [2.177638972296932, 48.805860904333926],
                            [2.178005026800091, 48.80591655560105],
                            [2.178361930196951, 48.80597628912136],
                            [2.178674146174967, 48.806039175468044],
                            [2.179190473531706, 48.80615097582032],
                            [2.179753287461502, 48.80630031318024],
                            [2.180502944889887, 48.80652909207602],
                            [2.181168601358515, 48.80676793712481],
                            [2.181952907942329, 48.80708449884279],
                            [2.182283280876487, 48.807233327760564],
                            [2.182570148964991, 48.807363212613986],
                            [2.182654420360782, 48.807408290671304],
                            [2.183077167195768, 48.80762558765231],
                            [2.183673794332594, 48.807970814262994],
                            [2.183866752034676, 48.80809247613725],
                            [2.184095040000431, 48.80823666704375],
                            [2.184445568997908, 48.808477243660235],
                            [2.184800126216717, 48.808737608421566],
                            [2.184900651661447, 48.808811483142634],
                            [2.184948188647466, 48.80884931613252],
                            [2.185184526909117, 48.809034882060224],
                            [2.185188603857815, 48.80903758558408],
                            [2.185350196212467, 48.80917808774469],
                            [2.18570591159766, 48.809508595010904],
                            [2.185944795589196, 48.809754414369046],
                            [2.186011303512924, 48.80982284705895],
                            [2.186081874321824, 48.809898480132325],
                            [2.18618366436315, 48.810005628614604],
                            [2.186374967047272, 48.810228902338324],
                            [2.186994866749312, 48.811002198597095],
                            [2.187059974091799, 48.81108501696183],
                            [2.187663595616336, 48.811844799010636],
                            [2.18772599747772, 48.811922219215646],
                            [2.187763981332981, 48.81196903135119],
                            [2.187880677253543, 48.81210317609318],
                            [2.187978376784385, 48.81221571300756],
                            [2.187994650228365, 48.81223731749701],
                            [2.188259860000294, 48.81257171717766],
                        ],
                    },
                },
                41: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.87217992809245, 2.8679179775721435],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 3142.65038893,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.854315926463895,
                            48.8632902390859,
                            2.883201728539714,
                            48.88268104666967,
                        ),
                        "coordinates": [
                            [2.854315926463895, 48.88268104666967],
                            [2.856644668363824, 48.879458828545886],
                            [2.856802549398204, 48.879233090773596],
                            [2.856967915321395, 48.878981746810574],
                            [2.857125472733312, 48.878725324765526],
                            [2.857300441789926, 48.87840404647633],
                            [2.857541207895059, 48.87794949901487],
                            [2.858091106318945, 48.87690712689522],
                            [2.858261485896771, 48.876642122518],
                            [2.858447525942609, 48.87639238679099],
                            [2.858654364811935, 48.87615448946868],
                            [2.858856356248211, 48.87594729824542],
                            [2.859117480361318, 48.875710857049796],
                            [2.859409754393366, 48.87548790905373],
                            [2.859725372881151, 48.87527337729556],
                            [2.860046392311225, 48.87508098203457],
                            [2.860390773514688, 48.87489870605718],
                            [2.860768874931072, 48.87472820604863],
                            [2.861201273422776, 48.874560866805496],
                            [2.861543767572944, 48.87444507736772],
                            [2.861876136110965, 48.874349792066305],
                            [2.862254946805611, 48.87424747273815],
                            [2.864206011614499, 48.87375264082796],
                            [2.867131344306717, 48.87301971093815],
                            [2.867510153847908, 48.87291907816883],
                            [2.867925082625485, 48.872813162839556],
                            [2.86826776444696, 48.872717809901225],
                            [2.868641236798737, 48.872601856018726],
                            [2.868957877339857, 48.87248787119745],
                            [2.869274366675177, 48.87236024823657],
                            [2.869696145252711, 48.87217076407481],
                            [2.870081668388279, 48.87197462912744],
                            [2.87041811238854, 48.87178042726096],
                            [2.870726073705668, 48.871581242958904],
                            [2.871018454882052, 48.87137531150639],
                            [2.871274675236126, 48.87117125415404],
                            [2.871479563927353, 48.870999825651765],
                            [2.871730337336006, 48.870770220090506],
                            [2.872022029269046, 48.87050121664161],
                            [2.873173454380311, 48.86944231164542],
                            [2.874693250766208, 48.86804412933708],
                            [2.874962026773236, 48.86780932015138],
                            [2.875215647262726, 48.8676069687116],
                            [2.875436174813149, 48.8674508033667],
                            [2.875728662957316, 48.86725849608329],
                            [2.875993129543531, 48.86710382587176],
                            [2.876314198417295, 48.86692672442582],
                            [2.8767303650063, 48.86670314641096],
                            [2.880709417232306, 48.864561911953444],
                            [2.88200910774739, 48.86385849111414],
                            [2.882355912784986, 48.86367613555402],
                            [2.882646253346079, 48.863528144039876],
                            [2.882916183764921, 48.86340411480701],
                            [2.883201728539714, 48.8632902390859],
                        ],
                    },
                },
                42: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.80649829543364, 1.790761244746442],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 3874.20161566,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.765056756557643,
                            48.802601980906694,
                            1.816466794198607,
                            48.810402464358575,
                        ),
                        "coordinates": [
                            [1.765056756557643, 48.810402464358575],
                            [1.765578236059365, 48.810323677235814],
                            [1.765713281789975, 48.81030187078084],
                            [1.765848307990154, 48.81028186290839],
                            [1.766470284250454, 48.81018605076781],
                            [1.768641544773686, 48.80986774332251],
                            [1.77007917532504, 48.80964467439468],
                            [1.771833154563744, 48.809379089216684],
                            [1.773430251888483, 48.809138781783844],
                            [1.773917160261275, 48.80906474508711],
                            [1.774770941992939, 48.80893585884246],
                            [1.776433481161241, 48.808685040501096],
                            [1.776871278469499, 48.808618844288524],
                            [1.777864224791863, 48.808462739754354],
                            [1.778652645643295, 48.80833260449746],
                            [1.779678145884585, 48.80818653631542],
                            [1.781373460149095, 48.80792231677589],
                            [1.782849117272393, 48.80769747415338],
                            [1.786176728211459, 48.80719648992155],
                            [1.787248628854193, 48.80703618853358],
                            [1.788013718981526, 48.80691846639314],
                            [1.788687414065552, 48.806816488476215],
                            [1.792529115569641, 48.80622965725163],
                            [1.794120702736462, 48.805976444484706],
                            [1.795612481892875, 48.805760507001644],
                            [1.79650032088141, 48.8056190298184],
                            [1.797236759662873, 48.80550290959039],
                            [1.798199454722226, 48.80536267314405],
                            [1.799949019458404, 48.80509933317677],
                            [1.801256760021642, 48.804902240135576],
                            [1.801804956732735, 48.8048184807739],
                            [1.805334043340158, 48.804284610275445],
                            [1.805668159186067, 48.804231309839885],
                            [1.805902723407634, 48.80419373236873],
                            [1.806559956126206, 48.80409696747534],
                            [1.808209923841685, 48.803846528157784],
                            [1.808962630493156, 48.80373220630825],
                            [1.809861235881343, 48.80359607145867],
                            [1.811511169217694, 48.80334558463799],
                            [1.811673432507989, 48.80332115122481],
                            [1.812423429741043, 48.803204096739385],
                            [1.814014735411301, 48.80295959867648],
                            [1.814272459255679, 48.8029194121295],
                            [1.814841106180383, 48.8028284897656],
                            [1.816193615172426, 48.80263502755033],
                            [1.816466794198607, 48.802601980906694],
                        ],
                    },
                },
                43: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.89551351886699, 2.2422495430436404],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1050.51970801,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.2370182854985,
                            48.89218735760208,
                            2.247942846959712,
                            48.89811887571271,
                        ),
                        "coordinates": [
                            [2.247942846959712, 48.89811887571271],
                            [2.247501505955844, 48.89793615150407],
                            [2.247330562755172, 48.89787248944589],
                            [2.247231037616134, 48.897829582896506],
                            [2.244893808778216, 48.89683332546334],
                            [2.243141192416398, 48.89609449731615],
                            [2.242429809476499, 48.89579085594544],
                            [2.241882838939987, 48.895539677576956],
                            [2.241142058577106, 48.89520345819289],
                            [2.240928124576816, 48.89510166055526],
                            [2.240857267511158, 48.895068328256485],
                            [2.240790507593676, 48.89503230141264],
                            [2.240569785983877, 48.89491521011794],
                            [2.240462154103692, 48.89485666633074],
                            [2.240228040174852, 48.89473526437658],
                            [2.240019334521322, 48.89461659618253],
                            [2.239812820131014, 48.8944857960416],
                            [2.239607400369969, 48.89434857135113],
                            [2.239504700452058, 48.89427496268965],
                            [2.239047879130221, 48.893965889413174],
                            [2.23872266732821, 48.89375357381493],
                            [2.23829909095892, 48.89346184470364],
                            [2.23818972662415, 48.8933807675495],
                            [2.237954082843688, 48.89319687272099],
                            [2.237855181060364, 48.89311074281137],
                            [2.237781663427691, 48.89304593119936],
                            [2.237604726501907, 48.89286592296902],
                            [2.237459652277581, 48.89270857369787],
                            [2.237325753581405, 48.89256172497171],
                            [2.237211465993576, 48.892425834369206],
                            [2.237189697469287, 48.89239973643503],
                            [2.23716385274458, 48.89236644124214],
                            [2.237076774452764, 48.892263847177276],
                            [2.2370182854985, 48.89218735760208],
                        ],
                    },
                },
                44: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.820684400843895, 2.222425201633709],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 1149.81956414,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.21485979543755,
                            48.818947800937735,
                            2.229808003729513,
                            48.821353445618726,
                        ),
                        "coordinates": [
                            [2.21485979543755, 48.82121703789382],
                            [2.215385136870361, 48.82125565245838],
                            [2.216548842138161, 48.82131636844021],
                            [2.217518042257242, 48.82134831766572],
                            [2.217871150812068, 48.821353445618726],
                            [2.218361203741479, 48.821349196707054],
                            [2.218865693458763, 48.82133544357092],
                            [2.219986456226751, 48.82127235524613],
                            [2.220627968190282, 48.8212159056292],
                            [2.22115416995627, 48.82116171543497],
                            [2.221683989790666, 48.82110038820959],
                            [2.222451736509177, 48.820989332514486],
                            [2.223050090805913, 48.820894756311176],
                            [2.223677321435976, 48.820776413758495],
                            [2.224268528603829, 48.820653273404055],
                            [2.224960685761454, 48.820501675635285],
                            [2.225656469550867, 48.82033818128925],
                            [2.226287392891662, 48.82017462028862],
                            [2.226846242163563, 48.820013364582856],
                            [2.227372684543435, 48.81984017957013],
                            [2.227798163343908, 48.81970020601756],
                            [2.22874653871935, 48.819356103927056],
                            [2.229808003729513, 48.818947800937735],
                        ],
                    },
                },
                45: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.80525162147042, 2.479503811457814],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1027.10039316,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.472720403802171,
                            48.80487260701215,
                            2.486349748779074,
                            48.80620002476371,
                        ),
                        "coordinates": [
                            [2.472720403802171, 48.80620002476371],
                            [2.473065026260363, 48.80608340069781],
                            [2.47349332755808, 48.805954403578276],
                            [2.473957661296933, 48.8058301188538],
                            [2.474452172676266, 48.80571323380122],
                            [2.474713421687063, 48.80566076003578],
                            [2.475419643647813, 48.805532205253655],
                            [2.476100051816, 48.80542346167181],
                            [2.477848753350977, 48.80516861205552],
                            [2.47837541157962, 48.80509511685007],
                            [2.479261395857102, 48.80499239393389],
                            [2.479937852704598, 48.80493579074812],
                            [2.480588482675403, 48.80489360373159],
                            [2.481545489406977, 48.80487260701215],
                            [2.482081920192518, 48.80488541377393],
                            [2.482457729663807, 48.80490651574335],
                            [2.482956104641132, 48.804940949425834],
                            [2.483551235134649, 48.80500762999487],
                            [2.483970731085068, 48.80506913807007],
                            [2.484307119737713, 48.80511006987396],
                            [2.484764741791449, 48.80517332522905],
                            [2.485174689159024, 48.80522764771423],
                            [2.486349748779074, 48.80537766216148],
                        ],
                    },
                },
                46: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.955492897625206, 2.119900937702748],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 4353.42380922,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.093521901580612,
                            48.945795934518046,
                            2.144558756800802,
                            48.95942081579221,
                        ),
                        "coordinates": [
                            [2.093521901580612, 48.95540224453111],
                            [2.095275119180811, 48.955654064388554],
                            [2.096018815220241, 48.95577460055809],
                            [2.096618009515849, 48.95589244985157],
                            [2.097199058945369, 48.956026914310016],
                            [2.097718688332133, 48.95616124466473],
                            [2.098281520495417, 48.95632897650449],
                            [2.098880347475981, 48.956525331014426],
                            [2.099544077984347, 48.956750368259605],
                            [2.100608189393563, 48.95711899271907],
                            [2.101315248701186, 48.95735362746025],
                            [2.101924995466158, 48.95753809210881],
                            [2.102520396662549, 48.9577011077294],
                            [2.103123116157908, 48.957845103723315],
                            [2.10378009657946, 48.95797730778482],
                            [2.105895487496369, 48.958393226526475],
                            [2.106750946297849, 48.95858172935578],
                            [2.107656871894758, 48.9587976901254],
                            [2.10843651616127, 48.95897532140973],
                            [2.109136849052834, 48.959114719293304],
                            [2.109956464466103, 48.959244833795324],
                            [2.110639000414662, 48.959327083613374],
                            [2.111484219680787, 48.95939061488035],
                            [2.112322369032908, 48.95942081579221],
                            [2.113048645423283, 48.95941985921476],
                            [2.113803934326044, 48.95939516179983],
                            [2.114483473045252, 48.959341760471695],
                            [2.115260661327089, 48.95926713041187],
                            [2.1162728894209, 48.959152498848795],
                            [2.117111658406051, 48.95904228229965],
                            [2.118178295502507, 48.95887777293547],
                            [2.11932823883308, 48.95866582398323],
                            [2.120514540667297, 48.958412715591315],
                            [2.121747998698349, 48.95815101361782],
                            [2.124008480816989, 48.95763495050819],
                            [2.124915992428352, 48.957424777452],
                            [2.12539347128279, 48.957297175832075],
                            [2.126178595154797, 48.95704403509915],
                            [2.126703321605904, 48.95684989304958],
                            [2.127304104646893, 48.956610682942866],
                            [2.127894166345738, 48.95634289591625],
                            [2.128563966706861, 48.95601338786181],
                            [2.129363096573621, 48.95558242610153],
                            [2.129364252725261, 48.95558180229322],
                            [2.130186393825507, 48.95510504093087],
                            [2.130918026939952, 48.954668561787386],
                            [2.1323489735282, 48.95373842337728],
                            [2.134018912585963, 48.9526611748752],
                            [2.134996935419867, 48.95202999852488],
                            [2.13705434703725, 48.95069641978865],
                            [2.139423112433903, 48.94916585477055],
                            [2.141654189842415, 48.94770400653005],
                            [2.14260315743467, 48.94706319950211],
                            [2.143302133117028, 48.94660517253894],
                            [2.144558756800802, 48.945795934518046],
                        ],
                    },
                },
                47: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.53264201027134, 2.039154529180674],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 4574.23576267,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.008771813873437,
                            48.531057764508006,
                            2.069381524887472,
                            48.535806509243706,
                        ),
                        "coordinates": [
                            [2.008771813873437, 48.533732833977226],
                            [2.009746723385014, 48.53358378240689],
                            [2.011869678074811, 48.53325916163322],
                            [2.015236933939557, 48.532745314411315],
                            [2.019354185981668, 48.53211398400631],
                            [2.022193845468613, 48.5316778888953],
                            [2.02260723095999, 48.53161130087928],
                            [2.023214673083323, 48.5315184892104],
                            [2.023670815982834, 48.53145954217455],
                            [2.024043762041415, 48.53141625145539],
                            [2.024650979608317, 48.53135855339382],
                            [2.025259341134543, 48.531319251116294],
                            [2.026418113602109, 48.53127563808936],
                            [2.028202574348773, 48.53120199200792],
                            [2.02917633428576, 48.531167155766155],
                            [2.030399106889527, 48.531110397103575],
                            [2.031467828521446, 48.53106723654237],
                            [2.032058045877617, 48.531057764508006],
                            [2.032624002192012, 48.531066422234225],
                            [2.033010784651196, 48.5310841133706],
                            [2.033440498993227, 48.53111143655763],
                            [2.033820046760105, 48.53114100351547],
                            [2.034307006004498, 48.53118037160835],
                            [2.034880059997846, 48.53124453523164],
                            [2.037253168215208, 48.53153081143649],
                            [2.03928303293862, 48.531755050901516],
                            [2.041627626351697, 48.53202307463431],
                            [2.043452979452916, 48.53222025369867],
                            [2.045450314709484, 48.53241514656364],
                            [2.047512600058372, 48.53262006222356],
                            [2.050392546171845, 48.532906684239336],
                            [2.054463524084015, 48.533309477590954],
                            [2.057123821747188, 48.53357541338937],
                            [2.06013862941511, 48.53387546257729],
                            [2.062637892602588, 48.5341194627232],
                            [2.063786840836441, 48.53422519456175],
                            [2.064764729226511, 48.534338720800676],
                            [2.065090490805462, 48.53438470895088],
                            [2.065455572632191, 48.534447445125856],
                            [2.066010244684644, 48.534562976503615],
                            [2.066597006980077, 48.53470713422527],
                            [2.067151427027445, 48.53487024594024],
                            [2.06772718091878, 48.535064336412646],
                            [2.068267037200189, 48.535272615052605],
                            [2.068781704386639, 48.53550224539504],
                            [2.069234232328339, 48.53573177922848],
                            [2.069381524887472, 48.535806509243706],
                        ],
                    },
                },
                48: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.051930246401426, 2.1937179114595176],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1574.56425035,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.190262803121982,
                            49.04543025423756,
                            2.197087678318264,
                            49.058047811766336,
                        ),
                        "coordinates": [
                            [2.191244759191911, 49.058047811766336],
                            [2.190861645779191, 49.05745498788427],
                            [2.190548507695725, 49.05691952085123],
                            [2.190426094756453, 49.05667026589281],
                            [2.190320376514518, 49.05632840667057],
                            [2.190263903331224, 49.05599200549049],
                            [2.190262803121982, 49.05590117696955],
                            [2.190263384294123, 49.05570513614451],
                            [2.190286147146323, 49.05541110233548],
                            [2.190352253199126, 49.055143299819605],
                            [2.190476334369092, 49.054807972036606],
                            [2.190614746975041, 49.05452262832335],
                            [2.190767510816821, 49.05428013093477],
                            [2.190974640742354, 49.05401628817903],
                            [2.191239618929525, 49.05377631174804],
                            [2.191575177113631, 49.05351257614192],
                            [2.191838411525413, 49.05333125598555],
                            [2.192000148508365, 49.05323343873634],
                            [2.194354839966382, 49.05182093168787],
                            [2.194905705559385, 49.05139610171207],
                            [2.195268133108681, 49.05109544958792],
                            [2.195399875872445, 49.050956224249795],
                            [2.19560848076081, 49.05073076355253],
                            [2.195835107841015, 49.05042169181413],
                            [2.196012428182078, 49.050130545255556],
                            [2.196167887446513, 49.04982857941369],
                            [2.196558872161905, 49.0489346749638],
                            [2.196687457682791, 49.04858591982278],
                            [2.19678936158777, 49.04825740882277],
                            [2.196870196580013, 49.047732331233604],
                            [2.196987368693518, 49.04645010849869],
                            [2.197074722862676, 49.04555183964988],
                            [2.197087678318264, 49.04543025423756],
                        ],
                    },
                },
                49: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.06552067854783, 2.13588724561283],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1279.48780983,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.13087413699018,
                            49.06059168305009,
                            2.141696932779959,
                            49.06931413549863,
                        ),
                        "coordinates": [
                            [2.13087413699018, 49.06059168305009],
                            [2.131207137954742, 49.0608580302238],
                            [2.131565206928057, 49.06117616736091],
                            [2.132278407878558, 49.061896716213184],
                            [2.132609946293323, 49.06227800164913],
                            [2.132746809746462, 49.062454316054904],
                            [2.132880023166548, 49.06263776157711],
                            [2.133070945750251, 49.062876034902864],
                            [2.133708530825932, 49.06368138396556],
                            [2.13394625988483, 49.06398635946666],
                            [2.13411554609956, 49.06420555832268],
                            [2.134428911716054, 49.06461059938328],
                            [2.13479658586036, 49.06501811482306],
                            [2.1350978641201, 49.06535061371402],
                            [2.13539857733161, 49.065685388917764],
                            [2.135842281765689, 49.066100172749735],
                            [2.136477439580163, 49.06663187674777],
                            [2.136665138389196, 49.066779723669],
                            [2.136935885407915, 49.0669871982046],
                            [2.13713442397544, 49.06714220065981],
                            [2.137282447389924, 49.06725190810256],
                            [2.137499064429621, 49.06741408040418],
                            [2.137791543933161, 49.067621590122286],
                            [2.138152685966862, 49.06786490928907],
                            [2.13856092738341, 49.06810354920741],
                            [2.139005410894167, 49.068335113479456],
                            [2.139507839109402, 49.068566774436114],
                            [2.140169494514747, 49.06882725791799],
                            [2.140798364833166, 49.06905112808556],
                            [2.141481883794477, 49.069258227748065],
                            [2.141696932779959, 49.06931413549863],
                        ],
                    },
                },
                50: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.980362122696086, 2.2823083362410497],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1506.99009239,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.272084772747633,
                            48.9794479829515,
                            2.292477128819507,
                            48.980646100425986,
                        ),
                        "coordinates": [
                            [2.292477128819507, 48.9794479829515],
                            [2.291789698218523, 48.979589155286604],
                            [2.290222213839165, 48.979863539420045],
                            [2.289567691458342, 48.97997747994914],
                            [2.288836657909453, 48.98009048584478],
                            [2.288119301114432, 48.9801864052716],
                            [2.287041234559017, 48.980307345441915],
                            [2.285992792470875, 48.98040960927644],
                            [2.285262248269383, 48.98046663029194],
                            [2.283920717443852, 48.980544858469564],
                            [2.282988168044092, 48.98057511540684],
                            [2.282271280009533, 48.98058820378442],
                            [2.28159811695532, 48.98058979917034],
                            [2.28027131584125, 48.98056499761469],
                            [2.277954290835895, 48.98048379678582],
                            [2.2771755585253, 48.98046990494057],
                            [2.276747150227587, 48.98046968153068],
                            [2.276251981472504, 48.9804775149285],
                            [2.276096224327892, 48.980483726890874],
                            [2.27545269804132, 48.98051036253481],
                            [2.274714898034236, 48.98054054067926],
                            [2.272084772747633, 48.980646100425986],
                        ],
                    },
                },
                51: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.58026466261715, 2.207151105654557],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2336.13386759,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.192063068770897,
                            48.577508489431835,
                            2.22243331383282,
                            48.58248559694799,
                        ),
                        "coordinates": [
                            [2.192063068770897, 48.577508489431835],
                            [2.192959101978819, 48.577940754354735],
                            [2.193738645120984, 48.5783105414072],
                            [2.194079557396226, 48.57846752761568],
                            [2.194362844473483, 48.57858780027418],
                            [2.194776529693579, 48.57875153818035],
                            [2.195210332229236, 48.57890364143992],
                            [2.195651709922428, 48.5790407631797],
                            [2.196105677460959, 48.57916457353781],
                            [2.196559681979031, 48.57927505959016],
                            [2.197028785416625, 48.5793739035409],
                            [2.19751048415598, 48.57945610465408],
                            [2.197977176339137, 48.57951996726035],
                            [2.198474010372151, 48.57957720053478],
                            [2.198954985641293, 48.57962177042589],
                            [2.200637204591428, 48.57975302973528],
                            [2.20187803585503, 48.579854541363716],
                            [2.205739140858419, 48.580157092631076],
                            [2.208261283472879, 48.58035484105673],
                            [2.20911203386415, 48.580424086753055],
                            [2.212507550208399, 48.58069267208359],
                            [2.213365830271464, 48.58076689108147],
                            [2.213830097177527, 48.580810697383036],
                            [2.214214044964871, 48.58085275081135],
                            [2.214868993876325, 48.580933401084366],
                            [2.215298088048602, 48.58099048842931],
                            [2.215870193574709, 48.581076040105486],
                            [2.216700715035429, 48.58121682408262],
                            [2.217511122508184, 48.58137257116665],
                            [2.218341565999359, 48.58154998555617],
                            [2.219954744507211, 48.58191806856227],
                            [2.222157533987902, 48.582421632240035],
                            [2.22243331383282, 48.58248559694799],
                        ],
                    },
                },
                52: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.0061833642051, 2.2514035041850473],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 2513.46718163,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.242479108496568,
                            48.99609884257494,
                            2.259655619057618,
                            49.015584975459475,
                        ),
                        "coordinates": [
                            [2.242479108496568, 49.015584975459475],
                            [2.243891923138443, 49.01453029274929],
                            [2.244324528878944, 49.01421859449099],
                            [2.245137802949952, 49.01357896361903],
                            [2.245465000925462, 49.013333722204244],
                            [2.245951107650513, 49.012911449182134],
                            [2.246345489125486, 49.01255474932075],
                            [2.246694770052406, 49.01218811988461],
                            [2.246812588856645, 49.0120515230458],
                            [2.246976992433265, 49.01185740846296],
                            [2.247440086972719, 49.01129302540317],
                            [2.247818247749802, 49.010821200356936],
                            [2.248055304932615, 49.01052498448478],
                            [2.248261937282807, 49.01026579592635],
                            [2.248831076252792, 49.00955005446084],
                            [2.249102926643525, 49.00922191352898],
                            [2.249342175503082, 49.00891992099268],
                            [2.250233936549223, 49.00777137844844],
                            [2.250918944239741, 49.006946263171656],
                            [2.251419125522458, 49.006325630150876],
                            [2.252872474242901, 49.00452316574334],
                            [2.253923911874838, 49.00325118153558],
                            [2.255407261307396, 49.00139613999132],
                            [2.255753769687276, 49.00096383377891],
                            [2.256620708454428, 48.99987632037915],
                            [2.257083614594808, 48.99929211501987],
                            [2.258113442257416, 48.998010460210544],
                            [2.259025444872625, 48.99688069384329],
                            [2.259655619057618, 48.99609884257494],
                        ],
                    },
                },
                53: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.96953947194933, 2.3118606772568446],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 994.155034711,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.307137032071533,
                            48.966326544842126,
                            2.3165820711557,
                            48.972749119759264,
                        ),
                        "coordinates": [
                            [2.3165820711557, 48.966326544842126],
                            [2.316484910128924, 48.96639374526073],
                            [2.315909726745558, 48.966785727178284],
                            [2.314688285531393, 48.96762002714814],
                            [2.313242728158259, 48.96859725303137],
                            [2.312868353708528, 48.96884357757444],
                            [2.311414516053476, 48.96984595844002],
                            [2.310403360643432, 48.97053097845368],
                            [2.309758391346334, 48.97097057431772],
                            [2.308411024472593, 48.971888410684016],
                            [2.307137032071533, 48.972749119759264],
                        ],
                    },
                },
                54: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M6",
                        "rer": 0,
                        "extcode": "100110006:6",
                        "geo_point_2d": [48.83958973645683, 2.3847591913129182],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01376",
                        "navette": 0,
                        "idrefliga": "A01539",
                        "shape_leng": 733.108842178,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.379911271454398,
                            48.838969569169585,
                            2.389620014061439,
                            48.84038874809586,
                        ),
                        "coordinates": [
                            [2.379911271454398, 48.84038874809586],
                            [2.380044954129417, 48.840377697125106],
                            [2.380176797741775, 48.8403593966142],
                            [2.380184929183669, 48.84035801955395],
                            [2.38097671147078, 48.840222476483426],
                            [2.385724719441183, 48.83940954129745],
                            [2.387659931190602, 48.83905316937965],
                            [2.387674949465731, 48.839050403374316],
                            [2.387853778521485, 48.83902095798647],
                            [2.388042746548228, 48.8389972238873],
                            [2.38823347028698, 48.83898071495085],
                            [2.388425322443565, 48.83897148552068],
                            [2.388617658257711, 48.838969569169585],
                            [2.388809840151649, 48.83897496803334],
                            [2.389001234824099, 48.83898766808508],
                            [2.389005167019794, 48.838988006544206],
                            [2.389620014061439, 48.83904114371397],
                        ],
                    },
                },
                55: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.18700825046705, 2.3672096790769412],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 4459.06423684,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.362303528565357,
                            49.166775039807895,
                            2.376601177324503,
                            49.20326573346356,
                        ),
                        "coordinates": [
                            [2.362303528565357, 49.166775039807895],
                            [2.362649382468536, 49.167287545801706],
                            [2.362967793672144, 49.167757791319666],
                            [2.363197003377784, 49.16810485617761],
                            [2.364233101446112, 49.16966974128223],
                            [2.365565516625801, 49.17399735517902],
                            [2.366316858529152, 49.18024681686752],
                            [2.366136105256711, 49.19066294162191],
                            [2.366513203521723, 49.195932151988366],
                            [2.367262656547948, 49.19838279749573],
                            [2.369133976409839, 49.20046550287917],
                            [2.376601177324503, 49.20326573346356],
                        ],
                    },
                },
                56: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.97675212855222, 2.2649559103886157],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1389.9858931,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.262935722791332,
                            48.97051992210463,
                            2.270035426257897,
                            48.980377556311645,
                        ),
                        "coordinates": [
                            [2.270035426257897, 48.980377556311645],
                            [2.269081199987407, 48.980237598400976],
                            [2.268398152677566, 48.9801301234452],
                            [2.268033150235689, 48.98006566282356],
                            [2.267538065876373, 48.97996305262211],
                            [2.267180319859156, 48.9798819389715],
                            [2.266802722503067, 48.979771230636224],
                            [2.266421558315122, 48.97964116253644],
                            [2.266154222341803, 48.97953392843443],
                            [2.265843556403992, 48.97939335562487],
                            [2.265536517149731, 48.97924326665335],
                            [2.265272845884962, 48.979102721946525],
                            [2.26501643663722, 48.97894076571651],
                            [2.264741989672952, 48.97875500467351],
                            [2.26453256734434, 48.97859783791925],
                            [2.264272625131723, 48.9783835331386],
                            [2.264059665491615, 48.978174015887724],
                            [2.263897256079431, 48.97800498014507],
                            [2.263691593327449, 48.97775263831284],
                            [2.263561710145016, 48.977588382515464],
                            [2.263421081252494, 48.977359876771],
                            [2.263291310966419, 48.97712185947384],
                            [2.263165215872408, 48.97684101568385],
                            [2.263086014920816, 48.97662682343224],
                            [2.2630176916121, 48.97639122715924],
                            [2.26295666875579, 48.97610566593455],
                            [2.262938928509338, 48.975881997856966],
                            [2.262935722791332, 48.975608371534236],
                            [2.262946885926966, 48.97539423777607],
                            [2.262976140104324, 48.975168219881205],
                            [2.26302713927824, 48.97489938767443],
                            [2.263358352013193, 48.973348272954006],
                            [2.263557622576995, 48.972443461278715],
                            [2.263883026060117, 48.97072420004332],
                            [2.263924959788352, 48.97051992210463],
                        ],
                    },
                },
                57: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.79158199287345, 2.4067137131838674],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2038.29308463,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.40271281718153,
                            48.78250543550023,
                            2.409541656460374,
                            48.80020939834459,
                        ),
                        "coordinates": [
                            [2.409541656460374, 48.78250543550023],
                            [2.409504545391541, 48.782718760102725],
                            [2.409361654715678, 48.783492133803456],
                            [2.409272266165194, 48.78392047034458],
                            [2.409129272495981, 48.78462722365056],
                            [2.408971892768101, 48.78534826148277],
                            [2.408782174655474, 48.78611928576211],
                            [2.408538710867583, 48.787078310521714],
                            [2.408298656866495, 48.78791122789415],
                            [2.408169660018592, 48.78835148622518],
                            [2.408033457741617, 48.78879174723824],
                            [2.407760975044736, 48.78962230537667],
                            [2.407509982849522, 48.79037670972165],
                            [2.407208650101571, 48.79119062841646],
                            [2.40682834752396, 48.79219256245235],
                            [2.406412029096415, 48.79320165556693],
                            [2.406027942625695, 48.79409413977865],
                            [2.405733554601532, 48.79475577413811],
                            [2.405543241199632, 48.7951579962248],
                            [2.405349291749823, 48.795536427871625],
                            [2.405090645253383, 48.796012449709366],
                            [2.404609264150739, 48.796897849580674],
                            [2.404368534866408, 48.7973167562486],
                            [2.404120642832604, 48.7977689761037],
                            [2.4038655501678, 48.79822595853451],
                            [2.40357091525546, 48.79874244735021],
                            [2.402798310222541, 48.80005391144719],
                            [2.40271281718153, 48.80020939834459],
                        ],
                    },
                },
                58: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.83612245224618, 2.3709797496470864],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1633.0200525,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.36543338335276,
                            48.82987504460341,
                            2.376695892125261,
                            48.84252802768357,
                        ),
                        "coordinates": [
                            [2.376695892125261, 48.82987504460341],
                            [2.376310721393016, 48.83025845726653],
                            [2.376100014738509, 48.83046820031477],
                            [2.375626127836013, 48.83091781447308],
                            [2.375338031873506, 48.83120343387657],
                            [2.374884282692759, 48.831662798476835],
                            [2.374419729928119, 48.83214833839203],
                            [2.373872342705136, 48.83272193878771],
                            [2.37311965846401, 48.83350498377089],
                            [2.372788769485438, 48.833858984985916],
                            [2.372485827398598, 48.83420233131875],
                            [2.372262562137141, 48.83447602439655],
                            [2.372037483182515, 48.8347782794699],
                            [2.371583980405342, 48.835380689434714],
                            [2.371185475209688, 48.83587116095093],
                            [2.370504782526067, 48.8366470294828],
                            [2.370256258108027, 48.83691120950934],
                            [2.369928494955805, 48.83726582637737],
                            [2.369625807359515, 48.83760216261029],
                            [2.369382701363923, 48.8378996043211],
                            [2.369145006859776, 48.838208986095495],
                            [2.368972138117524, 48.83843507294346],
                            [2.368828076526018, 48.838620701620826],
                            [2.368485911818896, 48.83903718179771],
                            [2.36823737643977, 48.83931801243641],
                            [2.367801531073584, 48.83981303439403],
                            [2.36709924870718, 48.84064170283554],
                            [2.365581702747743, 48.842360082466925],
                            [2.36543338335276, 48.84252802768357],
                        ],
                    },
                },
                59: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.80736636380431, 2.3975493522017937],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1738.10740738,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.391686971662538,
                            48.80020939834459,
                            2.40271281718153,
                            48.813989052009454,
                        ),
                        "coordinates": [
                            [2.40271281718153, 48.80020939834459],
                            [2.402388694458657, 48.800798880907166],
                            [2.40230966399799, 48.80095834086986],
                            [2.401899980586725, 48.80166285949211],
                            [2.401529822340158, 48.80230311132965],
                            [2.401120043700234, 48.80295052291369],
                            [2.400469329429956, 48.803916898168495],
                            [2.400088253846302, 48.804497668870226],
                            [2.399678391990955, 48.80510938539171],
                            [2.399261264747814, 48.80568065601951],
                            [2.398750539869079, 48.806306699992135],
                            [2.3983656672838, 48.80676136270062],
                            [2.397829707196336, 48.80738979622354],
                            [2.397038329347954, 48.80831577895154],
                            [2.395717981668412, 48.80975834857481],
                            [2.39481129406606, 48.810724825856965],
                            [2.394174437462593, 48.81140801823558],
                            [2.393789421216613, 48.81180556107138],
                            [2.393404379955451, 48.812188826521734],
                            [2.392663105048392, 48.81295771851731],
                            [2.391686971662538, 48.813989052009454],
                        ],
                    },
                },
                60: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.96684452967871, 1.8289082795876979],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 3057.11833206,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.809094508773784,
                            48.96334411275807,
                            1.848348808282502,
                            48.97214167690781,
                        ),
                        "coordinates": [
                            [1.809094508773784, 48.96334411275807],
                            [1.809279551877828, 48.963355057024316],
                            [1.811029724209674, 48.96347807079743],
                            [1.812083086767916, 48.96355179040191],
                            [1.813387699003068, 48.963666453558346],
                            [1.814911934161123, 48.963825577806084],
                            [1.815912228767559, 48.96392916180948],
                            [1.817011205202946, 48.96406699800063],
                            [1.81845413919112, 48.96428608594147],
                            [1.819749147895919, 48.96450421403665],
                            [1.821617906480417, 48.964807692299324],
                            [1.823075227894982, 48.96506170646702],
                            [1.824965022409081, 48.9654318457826],
                            [1.825801666323962, 48.96560214604815],
                            [1.827049244693739, 48.96587420600549],
                            [1.828390453363887, 48.9661799805204],
                            [1.828910683687202, 48.966303205095066],
                            [1.829485475579419, 48.966444184797844],
                            [1.830438913009603, 48.966680407696785],
                            [1.831075973547873, 48.96684621932271],
                            [1.833000461301758, 48.96737104229682],
                            [1.833548209143593, 48.967525735222495],
                            [1.834866974414407, 48.96791461233414],
                            [1.838242688052874, 48.96896679082959],
                            [1.842774902225746, 48.97039743842707],
                            [1.845322167449251, 48.97119837017101],
                            [1.848348808282502, 48.97214167690781],
                        ],
                    },
                },
                61: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.75828388309225, 2.4146475096103424],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1310.3083477,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.411386724936104,
                            48.75288655674139,
                            2.418113047325797,
                            48.76378680955171,
                        ),
                        "coordinates": [
                            [2.418113047325797, 48.75288655674139],
                            [2.416624905232636, 48.75522931882932],
                            [2.416377979117072, 48.755605388227586],
                            [2.415558496728417, 48.75686404153501],
                            [2.414869262472233, 48.75794184587288],
                            [2.414459469393249, 48.75855902867565],
                            [2.414159620449721, 48.75903584730456],
                            [2.413774240207134, 48.75962056900609],
                            [2.413452595549658, 48.7600821807872],
                            [2.412453702802303, 48.76158118009764],
                            [2.412213173520056, 48.76197630951862],
                            [2.41204088089293, 48.76227859786082],
                            [2.411893754995528, 48.762564215824064],
                            [2.41169286382455, 48.76299738578484],
                            [2.411574538640741, 48.76329250082202],
                            [2.411441863780134, 48.763618556064316],
                            [2.411386724936104, 48.76378680955171],
                        ],
                    },
                },
                62: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.982368326609844, 1.8809392022219384],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 5285.39546558,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.848348808282502,
                            48.97214167690781,
                            1.91353050809466,
                            48.99259195475149,
                        ),
                        "coordinates": [
                            [1.848348808282502, 48.97214167690781],
                            [1.851021812508963, 48.97298425217767],
                            [1.861468323330048, 48.97626411273591],
                            [1.868665313283026, 48.97852090074438],
                            [1.8821924830449, 48.98276556001553],
                            [1.896839668836701, 48.98735317831446],
                            [1.908712966964527, 48.99107198435066],
                            [1.911421019791048, 48.991922003146975],
                            [1.913213127495083, 48.99249494421094],
                            [1.91353050809466, 48.99259195475149],
                        ],
                    },
                },
                63: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.93829748712154, 2.3530030860419053],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 450.708968826,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.350400018540065,
                            48.93750989644162,
                            2.355902810417396,
                            48.938597775209935,
                        ),
                        "coordinates": [
                            [2.355902810417396, 48.938597775209935],
                            [2.355429159133624, 48.93856562726525],
                            [2.355258469646472, 48.93854052478991],
                            [2.35509143422872, 48.9385077474605],
                            [2.35490088364042, 48.93847776870619],
                            [2.354740480448534, 48.938463787435076],
                            [2.353153116197353, 48.938371317398385],
                            [2.352551565974967, 48.93831115019994],
                            [2.351081109470616, 48.938139858431725],
                            [2.350995984122844, 48.93812747301883],
                            [2.350911059327141, 48.93810777025535],
                            [2.350830454343144, 48.938081340799464],
                            [2.350755388637984, 48.93804858694998],
                            [2.350687004063937, 48.93801000411318],
                            [2.350626333507694, 48.93796617703506],
                            [2.350574298283401, 48.937917769894284],
                            [2.35053168912451, 48.93786551810449],
                            [2.350500596820184, 48.93781317582778],
                            [2.350400018540065, 48.93750989644162],
                        ],
                    },
                },
                64: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.8549943562229, 2.2885902008619197],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 562.948769348,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.286419448213008,
                            48.853033488503854,
                            2.290391553460649,
                            48.857293413870465,
                        ),
                        "coordinates": [
                            [2.290391553460649, 48.857293413870465],
                            [2.290233969629259, 48.857116916754364],
                            [2.290008021717807, 48.85681736577427],
                            [2.289933189343854, 48.8566878397138],
                            [2.289829784316117, 48.856507942791616],
                            [2.289555002595611, 48.85597545777357],
                            [2.289344119514535, 48.85560756696089],
                            [2.289137257007656, 48.85531431749175],
                            [2.289004555406866, 48.855147078499826],
                            [2.288856018681601, 48.85496090005867],
                            [2.288707462235874, 48.85479840769266],
                            [2.288512776337732, 48.85461220893282],
                            [2.288389863687753, 48.85451724497622],
                            [2.286419448213008, 48.853033488503854],
                        ],
                    },
                },
                65: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.937240658804505, 2.362196272409096],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 283.677242808,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.360746043772506,
                            48.93638914706169,
                            2.363640702197924,
                            48.938082614059766,
                        ),
                        "coordinates": [
                            [2.363640702197924, 48.93638914706169],
                            [2.363561035020183, 48.93642734652028],
                            [2.362231791403588, 48.93722484164956],
                            [2.361996178362627, 48.937361621489735],
                            [2.361278784107133, 48.937788181650795],
                            [2.360746043772506, 48.938082614059766],
                        ],
                    },
                },
                66: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.887813287414566, 2.0748307787991527],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1737.06225249,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.069847520729069,
                            48.88099144075079,
                            2.079456713019077,
                            48.89460762842623,
                        ),
                        "coordinates": [
                            [2.069937966816875, 48.89460762842623],
                            [2.06991966754452, 48.894534877089995],
                            [2.069891527769017, 48.894399187275944],
                            [2.06987064342096, 48.89425637785819],
                            [2.069853369479513, 48.89411357487653],
                            [2.06985037429911, 48.89399935899256],
                            [2.069847520729069, 48.89385897122795],
                            [2.06984819968959, 48.89373286652931],
                            [2.069863568180821, 48.89355920930095],
                            [2.0698861265241, 48.893390327695926],
                            [2.069912140836625, 48.893250006690934],
                            [2.06995270277894, 48.89308830500236],
                            [2.06999682330192, 48.89293612898979],
                            [2.070044499654793, 48.8927934795313],
                            [2.070121195946435, 48.89262234531926],
                            [2.070197891749862, 48.89245121013213],
                            [2.070278055773203, 48.89230625681855],
                            [2.07035091311637, 48.89217794232182],
                            [2.070452726060841, 48.892033039118395],
                            [2.070576340496737, 48.89185963361358],
                            [2.070710767794486, 48.89168863400924],
                            [2.070841483146654, 48.891536659159776],
                            [2.071001191826305, 48.89136095927614],
                            [2.071164494328247, 48.891187646044926],
                            [2.071472967099735, 48.89085763324056],
                            [2.073091417039457, 48.88913635056786],
                            [2.073319967790454, 48.888903701451184],
                            [2.073494068084003, 48.88873278958121],
                            [2.073653604469192, 48.88858563819129],
                            [2.073820372026031, 48.888436122341645],
                            [2.073990719743308, 48.88829137444549],
                            [2.07417553871531, 48.88813952085178],
                            [2.074353063159543, 48.88800192743381],
                            [2.07453418287034, 48.88786671964632],
                            [2.074715275696037, 48.887736271665894],
                            [2.07489274828989, 48.887608193118645],
                            [2.075120844302162, 48.88745881734592],
                            [2.075316403331086, 48.887321262829396],
                            [2.075631440012261, 48.88710546268762],
                            [2.076131116794027, 48.886768736106745],
                            [2.076467893183744, 48.886533948724704],
                            [2.076906038637191, 48.886232768878834],
                            [2.077329671410796, 48.88594583020795],
                            [2.077528851519817, 48.88580352249013],
                            [2.077738890542331, 48.885654099610484],
                            [2.077920017534981, 48.885514128992014],
                            [2.078061320386325, 48.88540024042471],
                            [2.078191823372506, 48.88528156848475],
                            [2.078322337880908, 48.8851605167793],
                            [2.078442053927207, 48.88503468175609],
                            [2.078536389207196, 48.88493258321174],
                            [2.078638014572018, 48.8848162246887],
                            [2.078754270012778, 48.884661829622694],
                            [2.078870535492454, 48.884505054799796],
                            [2.07895421892158, 48.884369621021825],
                            [2.079034258845166, 48.88424131624867],
                            [2.079062317300772, 48.88418794014061],
                            [2.079121709335193, 48.884074958941994],
                            [2.079191047264349, 48.883922836715456],
                            [2.079260434431367, 48.883761196883306],
                            [2.079311757559971, 48.88360427552156],
                            [2.079359582159714, 48.88342593233554],
                            [2.079400095047284, 48.883266605616164],
                            [2.079426101403818, 48.88312152380987],
                            [2.07944497851566, 48.88295977057708],
                            [2.079456713019077, 48.88278372461976],
                            [2.079453868965917, 48.88263619859128],
                            [2.079451163048076, 48.88246249950271],
                            [2.079430442252997, 48.88228400137679],
                            [2.079413376551774, 48.88209599359672],
                            [2.079381932492387, 48.88189843551811],
                            [2.079346954350523, 48.88168659533497],
                            [2.079318908253816, 48.881529493202336],
                            [2.079283757610345, 48.88135096216606],
                            [2.079227061208015, 48.88115334909614],
                            [2.079177394694269, 48.88099144075079],
                        ],
                    },
                },
                67: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.80179960145587, 2.514336734024123],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1486.89418584,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.510307237115641,
                            48.79538383561483,
                            2.516055322407369,
                            48.80698507164624,
                        ),
                        "coordinates": [
                            [2.510307237115641, 48.80698507164624],
                            [2.510433108817921, 48.80694388303423],
                            [2.510756875783678, 48.80681966433071],
                            [2.511112960186082, 48.80666684267903],
                            [2.511411441138442, 48.806523626431726],
                            [2.511763794003523, 48.806335117318085],
                            [2.512410916003271, 48.80597484312017],
                            [2.512795527211592, 48.80574345328146],
                            [2.513147701275135, 48.805507354029025],
                            [2.513492640599702, 48.80526412815709],
                            [2.51380730132132, 48.80501312348691],
                            [2.514013385930899, 48.804825519929864],
                            [2.514218424630741, 48.80463939032214],
                            [2.514497905916015, 48.80436827272576],
                            [2.514731211013731, 48.8041287007002],
                            [2.514784085570845, 48.804067466995846],
                            [2.514965728999394, 48.80384865919177],
                            [2.515254316131879, 48.80346151876775],
                            [2.515462740436494, 48.80311946594813],
                            [2.515618266557589, 48.80283235286609],
                            [2.515691159246054, 48.80265957673568],
                            [2.515750486677784, 48.802500311848256],
                            [2.515819100410527, 48.802273585954744],
                            [2.51586940785784, 48.802086374812895],
                            [2.515936936010084, 48.801834058765095],
                            [2.516004009374217, 48.801455637537735],
                            [2.516042558359053, 48.80115815839129],
                            [2.516055322407369, 48.80070130400392],
                            [2.516024641549063, 48.80018265410029],
                            [2.515969168549575, 48.79978063182778],
                            [2.515917707872099, 48.79949281227939],
                            [2.5158082778713, 48.79910991059254],
                            [2.515688287143584, 48.79879364532239],
                            [2.515539406082418, 48.79845601208553],
                            [2.515361714218506, 48.79811842362603],
                            [2.51521315444596, 48.797868825566475],
                            [2.514984995293168, 48.797517039010444],
                            [2.5147858815811, 48.797229450132846],
                            [2.514518112228261, 48.7968777238003],
                            [2.514275642284225, 48.79654975251736],
                            [2.514051258882679, 48.796243166932086],
                            [2.513754485184352, 48.79583437954277],
                            [2.51350115244816, 48.79548738868592],
                            [2.513423298184714, 48.79538383561483],
                        ],
                    },
                },
                68: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.88595335363538, 2.1643023690980323],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1262.78610384,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.155903471896523,
                            48.8851632198879,
                            2.172579447718415,
                            48.88757361863876,
                        ),
                        "coordinates": [
                            [2.172579447718415, 48.88757361863876],
                            [2.171782068873163, 48.88730926067918],
                            [2.171547749345176, 48.88723967789196],
                            [2.171095459220695, 48.88710592843942],
                            [2.170754841219728, 48.887017303748365],
                            [2.170722143203212, 48.88700826369678],
                            [2.170468726817045, 48.88694134795458],
                            [2.170378804513189, 48.88691783477343],
                            [2.170302505816086, 48.88689793956726],
                            [2.170282069136247, 48.88689251429115],
                            [2.170260272163748, 48.88688618743371],
                            [2.170098140601709, 48.886843684859144],
                            [2.169617169445956, 48.88672517539531],
                            [2.168997292545189, 48.886590907528294],
                            [2.168341791213656, 48.886464312213946],
                            [2.167281755123788, 48.886255739070805],
                            [2.166565658626493, 48.88612618802025],
                            [2.16581919395176, 48.88599382915296],
                            [2.165537072433207, 48.885950240552894],
                            [2.165167733121407, 48.885891232729264],
                            [2.164944214287959, 48.885857623073406],
                            [2.164107317113675, 48.88575114355229],
                            [2.163829252492644, 48.88571834891036],
                            [2.163282665247964, 48.885653669749175],
                            [2.162866933023696, 48.885604476102564],
                            [2.162654297171717, 48.885578972110594],
                            [2.161729724557738, 48.885463598567306],
                            [2.161197210125788, 48.885403177740585],
                            [2.160784131091873, 48.88535079103308],
                            [2.160352135576175, 48.88530025599541],
                            [2.160057696348922, 48.88527192259143],
                            [2.159736789841772, 48.88524067229263],
                            [2.15943880986495, 48.88521790466067],
                            [2.159291582349866, 48.88520598523812],
                            [2.15903662989016, 48.88519389810617],
                            [2.15876122153014, 48.88518267667336],
                            [2.158447638955908, 48.88516959714309],
                            [2.158209021057997, 48.885165627261564],
                            [2.158166755724097, 48.88516376252927],
                            [2.15806994019543, 48.885163610580435],
                            [2.157955398240381, 48.8851634310154],
                            [2.157820402501647, 48.8851632198879],
                            [2.157636312163078, 48.885163830562846],
                            [2.157603586682145, 48.88516377838592],
                            [2.157531308659708, 48.88516546423599],
                            [2.157111306442858, 48.88516840069554],
                            [2.156515332277811, 48.88518994202832],
                            [2.155903471896523, 48.88521121820845],
                        ],
                    },
                },
                69: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.5487902171526, 2.2921731814414175],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 3696.92764064,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.290082513840396,
                            48.532890103244725,
                            2.293345838644037,
                            48.565593862821814,
                        ),
                        "coordinates": [
                            [2.290924468489718, 48.565593862821814],
                            [2.290972006789592, 48.56509546162683],
                            [2.291148000784847, 48.56321825008443],
                            [2.291297998710955, 48.56163874002049],
                            [2.291574827260926, 48.55879638260679],
                            [2.291716157634594, 48.557296510204196],
                            [2.291929536551554, 48.555077992546174],
                            [2.292039101985673, 48.553938393509846],
                            [2.292142942379187, 48.552808274246324],
                            [2.29223821542927, 48.55167056703662],
                            [2.292330633024033, 48.55052716981879],
                            [2.29247494684281, 48.54883198676967],
                            [2.292578771243155, 48.54769617977506],
                            [2.292737312139606, 48.54604082317767],
                            [2.292846832334936, 48.54491070670284],
                            [2.293025395188173, 48.5431984712315],
                            [2.293189658953251, 48.54149760819737],
                            [2.293299152455664, 48.540375076162796],
                            [2.293339624970796, 48.53980621955245],
                            [2.293345838644037, 48.53922976526901],
                            [2.293334903723072, 48.538670371374145],
                            [2.293286793866014, 48.5381735375931],
                            [2.293230100977195, 48.53769566383412],
                            [2.293144795015966, 48.53728793977789],
                            [2.293062266209859, 48.53697123570309],
                            [2.292954038609729, 48.536654522602966],
                            [2.292797336868192, 48.53626573277849],
                            [2.29260922842184, 48.535876931181676],
                            [2.292389711432258, 48.53549001221115],
                            [2.292144486379712, 48.535120149043685],
                            [2.291859291505608, 48.53475027028643],
                            [2.291565504082937, 48.53441451904097],
                            [2.291149043743194, 48.533970632854846],
                            [2.290826703998391, 48.53364624580547],
                            [2.290433058581351, 48.53324597882319],
                            [2.290082513840396, 48.532890103244725],
                        ],
                    },
                },
                70: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.883001467142776, 2.2657882119548045],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 4669.73856649,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.237213536457713,
                            48.874238476656075,
                            2.294490592832005,
                            48.89212336383249,
                        ),
                        "coordinates": [
                            [2.294490592832005, 48.874238476656075],
                            [2.293979630769604, 48.874304669363966],
                            [2.29358346053517, 48.87435609117054],
                            [2.292248949281205, 48.87457561694739],
                            [2.291329841196212, 48.87476923606603],
                            [2.290800759140827, 48.87489222553154],
                            [2.290123006206638, 48.875083495920784],
                            [2.283601731484298, 48.877163005675975],
                            [2.281891035520748, 48.87770842376787],
                            [2.27201728352592, 48.88083184022266],
                            [2.262191356498401, 48.88397152158327],
                            [2.260015441852841, 48.88462565428735],
                            [2.25921861809974, 48.88493626661831],
                            [2.258288006188821, 48.88533850754967],
                            [2.257519628722038, 48.885753443230065],
                            [2.256442691123083, 48.8863947753678],
                            [2.255293494466192, 48.887010866098144],
                            [2.254750354253448, 48.88725508113673],
                            [2.254104940357313, 48.88749562315546],
                            [2.253117182509752, 48.88776828510927],
                            [2.251742171747327, 48.888014572006334],
                            [2.250084903288651, 48.88823814724787],
                            [2.249619707971574, 48.88833851253028],
                            [2.243116621869925, 48.890308184070236],
                            [2.237994004180329, 48.89186771760373],
                            [2.237328035769669, 48.89208656393661],
                            [2.237213536457713, 48.89212336383249],
                        ],
                    },
                },
                71: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.60073977357278, 1.6757622440878344],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01744",
                        "navette": 0,
                        "idrefliga": "A02172",
                        "shape_leng": 1289.24957313,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.66971881148154,
                            48.596612809761496,
                            1.681645780403713,
                            48.60507627758083,
                        ),
                        "coordinates": [
                            [1.66971881148154, 48.596612809761496],
                            [1.670996615895592, 48.597479137279805],
                            [1.67247057276675, 48.59848418982428],
                            [1.674646464434534, 48.599933074152844],
                            [1.675689360660399, 48.60063250850369],
                            [1.677558209043181, 48.60193476225599],
                            [1.679376461179896, 48.603173741274425],
                            [1.679616957856203, 48.603342402883285],
                            [1.68014702386573, 48.60376364113057],
                            [1.680990655682556, 48.604486993660174],
                            [1.681645780403713, 48.60507627758083],
                        ],
                    },
                },
                72: {
                    "attributes": {
                        "reseau": "PARIS NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE K",
                        "rer": 0,
                        "extcode": "800:K",
                        "geo_point_2d": [48.93251347378888, 2.4652205859443646],
                        "indice_lig": "K",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01738",
                        "navette": 0,
                        "idrefliga": "A02175",
                        "shape_leng": 1532.65028221,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.454766382765777,
                            48.93230541606912,
                            2.475674370833512,
                            48.93270621869947,
                        ),
                        "coordinates": [
                            [2.454766382765777, 48.93270621869947],
                            [2.45518364315076, 48.932700995781666],
                            [2.457598821452279, 48.93267475387125],
                            [2.459869971859382, 48.93263783496673],
                            [2.462118221556601, 48.93260520910067],
                            [2.463698639395359, 48.932580933909804],
                            [2.464275473393231, 48.93256638793979],
                            [2.466635518401334, 48.9324895754969],
                            [2.469417617732813, 48.932398319719525],
                            [2.471060166345491, 48.93235468930533],
                            [2.47238270795745, 48.932341542495124],
                            [2.475674370833512, 48.93230541606912],
                        ],
                    },
                },
                73: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.30309453632192, 2.6804725098122493],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01745",
                        "navette": 0,
                        "idrefliga": "A02171",
                        "shape_leng": 7769.49621604,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.675087359405762,
                            48.26775810993438,
                            2.692480190584066,
                            48.33268364471056,
                        ),
                        "coordinates": [
                            [2.692480190584066, 48.33268364471056],
                            [2.691391542696429, 48.33228253572326],
                            [2.690409659957772, 48.33188545383876],
                            [2.689891583311462, 48.33165854002862],
                            [2.689365292574413, 48.33142201410298],
                            [2.688976489120495, 48.33124160855934],
                            [2.688567755902449, 48.33105060194479],
                            [2.688224663627763, 48.330881354474236],
                            [2.687906605869653, 48.33071885864362],
                            [2.687186506511966, 48.33033712063469],
                            [2.686885963109403, 48.33016989525797],
                            [2.686326809117357, 48.32985329650773],
                            [2.685774311968423, 48.3295231863682],
                            [2.685479084020273, 48.32934335199067],
                            [2.684668996449672, 48.328813500717516],
                            [2.683713695973193, 48.32814740678432],
                            [2.683383025525658, 48.32791012344695],
                            [2.683121055646814, 48.32770777996683],
                            [2.682790452979792, 48.327452082357176],
                            [2.682153260702667, 48.32693731803789],
                            [2.681755051210831, 48.32659203543299],
                            [2.681401695730068, 48.326278674410815],
                            [2.681131622688666, 48.32602591303681],
                            [2.680477248554331, 48.325378656047334],
                            [2.680155400057916, 48.32504601765736],
                            [2.679700310292202, 48.324551919654894],
                            [2.679560783117677, 48.32439220277733],
                            [2.679167143689837, 48.323924324626525],
                            [2.678839764978314, 48.323522203512624],
                            [2.678227216244546, 48.322691027298724],
                            [2.677805255589131, 48.32208565175546],
                            [2.677553142176157, 48.3216916470262],
                            [2.677295450940819, 48.32126978275815],
                            [2.677145310799483, 48.320999362541734],
                            [2.676969236280938, 48.32068356313474],
                            [2.676847640708833, 48.3204474295201],
                            [2.676464748696359, 48.319652755993324],
                            [2.67635262448922, 48.31938531382368],
                            [2.676218087039629, 48.31906449622371],
                            [2.676042468360639, 48.318613606385675],
                            [2.675867792771375, 48.31810246423378],
                            [2.675775357664548, 48.31781570405213],
                            [2.675666409491944, 48.317445755014326],
                            [2.675604279729833, 48.31721211001296],
                            [2.675540681467895, 48.316977599876836],
                            [2.675343439648102, 48.31611672096722],
                            [2.675214788432753, 48.315230457377574],
                            [2.675151705996511, 48.31467131988922],
                            [2.675131120092048, 48.3144168974097],
                            [2.675108316409423, 48.31399898315524],
                            [2.675095519346699, 48.31373448159181],
                            [2.675087359405762, 48.313123023917676],
                            [2.675094816930023, 48.312828950667935],
                            [2.67512727420026, 48.31224344963654],
                            [2.675181590587328, 48.31170104590739],
                            [2.675252050455233, 48.311154097619095],
                            [2.675309182499671, 48.31083020105635],
                            [2.67537031673438, 48.310499996574585],
                            [2.675554531998818, 48.309651523900655],
                            [2.67563568576462, 48.309271740314486],
                            [2.675732306515464, 48.308807443262225],
                            [2.676145201050875, 48.30687194226511],
                            [2.67649548931721, 48.30525046147873],
                            [2.676843052150074, 48.30362809042412],
                            [2.67727174197208, 48.30164937494295],
                            [2.677545458196509, 48.300447129148516],
                            [2.677714704225114, 48.29959418052138],
                            [2.677858594165325, 48.298907658264426],
                            [2.677996551817388, 48.29823008433304],
                            [2.678371884700336, 48.29654467685652],
                            [2.67852609549913, 48.2957817440343],
                            [2.678652454175343, 48.29519587096144],
                            [2.678869395527883, 48.29420245564648],
                            [2.679083633352303, 48.293209048105716],
                            [2.67925889634775, 48.29242977727173],
                            [2.679359271467391, 48.2919330939816],
                            [2.679501832487909, 48.29129959855797],
                            [2.67960090049538, 48.29081936469478],
                            [2.679752578554305, 48.29013072910954],
                            [2.679910707559019, 48.28941152731955],
                            [2.680064927673276, 48.2887107843005],
                            [2.680577903473908, 48.28628847977151],
                            [2.68087705776792, 48.284916232946394],
                            [2.681022053102365, 48.284250356419314],
                            [2.681190351235858, 48.283446826214714],
                            [2.681451544515652, 48.28224105380438],
                            [2.68169569844899, 48.28110637158191],
                            [2.681939833803385, 48.27997079085949],
                            [2.682086054852688, 48.27929142140013],
                            [2.682183953269003, 48.278834310742916],
                            [2.682280577162314, 48.278387994324305],
                            [2.682365427510876, 48.27799297047525],
                            [2.682507199262286, 48.277343525884795],
                            [2.68258741824988, 48.276971659519575],
                            [2.682860271339749, 48.27570829790955],
                            [2.683079586109003, 48.274692390137474],
                            [2.683300225465166, 48.27367467898567],
                            [2.683520868410259, 48.27265876621789],
                            [2.683721336208414, 48.27184344425305],
                            [2.683865485817682, 48.271261197016436],
                            [2.684020252387677, 48.270712689713825],
                            [2.684114353037021, 48.270426873280144],
                            [2.684240444271282, 48.27010766946594],
                            [2.684391161337541, 48.26977983773528],
                            [2.684616347604972, 48.26932374455536],
                            [2.68486627154594, 48.268875678655775],
                            [2.685109490180194, 48.268489492910525],
                            [2.685439261376148, 48.26803259197371],
                            [2.68564708993975, 48.26775810993438],
                        ],
                    },
                },
                74: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.84318509326101, 1.8979550294451668],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 4973.64175446,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.875595590302068,
                            48.833512070590515,
                            1.924597779359982,
                            48.85999873043875,
                        ),
                        "coordinates": [
                            [1.924597779359982, 48.833512070590515],
                            [1.923194770327423, 48.8336678299516],
                            [1.921190318523971, 48.83390708528862],
                            [1.919700159752708, 48.834056324325296],
                            [1.918703550013512, 48.83415429582055],
                            [1.918185450073443, 48.83420815147946],
                            [1.917712271985488, 48.834265767155195],
                            [1.917507723534034, 48.83429109570287],
                            [1.916580250283213, 48.834427971826806],
                            [1.916093254192245, 48.834508012591954],
                            [1.915059071771255, 48.834697540693014],
                            [1.915049521137181, 48.83469930417211],
                            [1.914713855049627, 48.83476461050825],
                            [1.914315351291881, 48.83485036595376],
                            [1.913440379459775, 48.83505845562745],
                            [1.912948925994493, 48.835180733139666],
                            [1.911243513250594, 48.83564291391187],
                            [1.909382363398708, 48.83615214829706],
                            [1.908593099039535, 48.836368615725696],
                            [1.908239433593845, 48.8364653103759],
                            [1.905403226666929, 48.83724060099547],
                            [1.903368563528334, 48.83779314686094],
                            [1.901077081489615, 48.83842021676756],
                            [1.900507667949804, 48.838570020222555],
                            [1.899849395057337, 48.838754554302625],
                            [1.899424382767335, 48.83888295765245],
                            [1.898988664991143, 48.8390327328708],
                            [1.898475025416582, 48.839224402691016],
                            [1.897922117497722, 48.83947558396048],
                            [1.89771008414774, 48.83957369003812],
                            [1.897510309452956, 48.83967184306835],
                            [1.897118414863756, 48.83987661390771],
                            [1.896757918099072, 48.84007925449823],
                            [1.896431717214061, 48.840287064583684],
                            [1.896093818571919, 48.84052253545949],
                            [1.895686448907955, 48.840845898593436],
                            [1.895347895741671, 48.84115441227406],
                            [1.895101504160527, 48.84139779201599],
                            [1.894912771304306, 48.84160697994902],
                            [1.894711777059476, 48.84184091695893],
                            [1.894557405271386, 48.84204086002167],
                            [1.894442983050777, 48.84219149797927],
                            [1.894396140582562, 48.84224977023602],
                            [1.894280249967738, 48.842412092310454],
                            [1.894013749691345, 48.84281034383009],
                            [1.893179296491143, 48.84410208169784],
                            [1.893082647696013, 48.844244693385534],
                            [1.892883691705741, 48.844553275997995],
                            [1.892044938542822, 48.84586207608825],
                            [1.891800371538073, 48.84624152289608],
                            [1.891740954455565, 48.84633391831386],
                            [1.891543457631963, 48.84662991364212],
                            [1.891394259084974, 48.84685775130098],
                            [1.891184808608388, 48.84711862714696],
                            [1.891023723334837, 48.84730415165089],
                            [1.890697694876669, 48.84764910447068],
                            [1.890406339439276, 48.847925846869245],
                            [1.890255270340923, 48.84805745138342],
                            [1.889989035800739, 48.84826774298703],
                            [1.889526792071094, 48.84860586474786],
                            [1.889307542327516, 48.84874259681445],
                            [1.888833611713345, 48.849015920432066],
                            [1.887846656114627, 48.84951384686808],
                            [1.887030992758062, 48.84990362639705],
                            [1.885802010045025, 48.85048961067134],
                            [1.885644623273448, 48.850564529509974],
                            [1.885461206267309, 48.85065463242783],
                            [1.885001384395286, 48.850870442147766],
                            [1.884916533163449, 48.850910574747054],
                            [1.884114573593193, 48.8512868979541],
                            [1.883673850115235, 48.85149918048404],
                            [1.881774175736952, 48.85239990788418],
                            [1.881063508312302, 48.85277207649475],
                            [1.880789511388133, 48.85293015725882],
                            [1.880234267344406, 48.85329305004022],
                            [1.879948925488302, 48.85349874558174],
                            [1.879722433519892, 48.853676797527775],
                            [1.879519196843302, 48.85384505094054],
                            [1.879295227771028, 48.85404469541246],
                            [1.878900482159473, 48.854438800756014],
                            [1.878790236769664, 48.85457145382602],
                            [1.878616856789359, 48.85475241439242],
                            [1.878347920560391, 48.85509846201705],
                            [1.878054268363712, 48.85546419290713],
                            [1.877712091996414, 48.855918757935974],
                            [1.877197799589176, 48.856563279856786],
                            [1.876762902132102, 48.857168549597745],
                            [1.876691011294865, 48.857278872891605],
                            [1.876429417057593, 48.85771217619204],
                            [1.876237738290118, 48.8581007961128],
                            [1.876127566257983, 48.858371038954516],
                            [1.875992168270031, 48.85871582076509],
                            [1.875891533074525, 48.85898610157833],
                            [1.875595590302068, 48.85999873043875],
                        ],
                    },
                },
                75: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.837666159350825, 2.6819810280352456],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 4215.87827718,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.655130086641314,
                            48.83446493974479,
                            2.708981742262277,
                            48.8413481541083,
                        ),
                        "coordinates": [
                            [2.708981742262277, 48.83653643294522],
                            [2.708813567142168, 48.836516448562065],
                            [2.708182267381735, 48.83644116664061],
                            [2.706801043508837, 48.83627568952893],
                            [2.705749758233857, 48.83614509994105],
                            [2.702406512761462, 48.83574398915671],
                            [2.700034121348974, 48.83546289624197],
                            [2.697856681602127, 48.835200018003185],
                            [2.69651641974847, 48.83503878004973],
                            [2.693278280452719, 48.834648755447375],
                            [2.692360775304486, 48.834548199615234],
                            [2.691592073732122, 48.83449213699931],
                            [2.691183271478378, 48.83447362323637],
                            [2.690793611689558, 48.83446493974479],
                            [2.690087976809076, 48.83446532681188],
                            [2.689372997596028, 48.83449271798273],
                            [2.689008074162088, 48.83451452766953],
                            [2.688595560731638, 48.834549072996616],
                            [2.687748928649365, 48.834645204765664],
                            [2.686966462600394, 48.83476181740248],
                            [2.686547419351012, 48.83483684330322],
                            [2.686290333426266, 48.83489068853669],
                            [2.685623933020744, 48.835047404463005],
                            [2.684774174737441, 48.83528291267264],
                            [2.684480568191723, 48.83537463530411],
                            [2.683833727569369, 48.83560322350509],
                            [2.683297042248419, 48.83580539473872],
                            [2.682783665282662, 48.836029974971495],
                            [2.682281283318439, 48.83626890783278],
                            [2.681320288957892, 48.836774513381044],
                            [2.679641194486992, 48.83765457432527],
                            [2.678748101708651, 48.83813657180763],
                            [2.678259375025331, 48.838386237976756],
                            [2.676749935165873, 48.83918840958539],
                            [2.675009550379647, 48.84009466375864],
                            [2.674562805808882, 48.84031271414811],
                            [2.674166190323721, 48.840490146625235],
                            [2.673729892822907, 48.840642515515796],
                            [2.673294870701926, 48.840782288310514],
                            [2.672851657937244, 48.84092028519619],
                            [2.672342934201122, 48.84104138675611],
                            [2.671881727561581, 48.84113806537385],
                            [2.671419042316219, 48.84121766056017],
                            [2.671033769583915, 48.84126105613632],
                            [2.670753316936057, 48.841291552872576],
                            [2.670362478986721, 48.84131787586561],
                            [2.669941631173118, 48.841338888715946],
                            [2.669539779876879, 48.8413481541083],
                            [2.66895797806322, 48.84134085538224],
                            [2.668538233810415, 48.841323191084086],
                            [2.668205661058196, 48.841301674218634],
                            [2.667798005673139, 48.84125789250317],
                            [2.667332946073375, 48.841186398453395],
                            [2.666893731350832, 48.84110853167479],
                            [2.665790036811735, 48.8408815001527],
                            [2.665262148042251, 48.8407849979329],
                            [2.664869338380738, 48.8407186814545],
                            [2.664334782120697, 48.84064377661963],
                            [2.663856240359233, 48.84059209132376],
                            [2.66346359326968, 48.84055004930345],
                            [2.662997337461138, 48.84050192144581],
                            [2.662413841464426, 48.840442435931976],
                            [2.661966672709561, 48.84039604867343],
                            [2.66144452182996, 48.84034177886048],
                            [2.658580203774628, 48.8400432314194],
                            [2.657993953902379, 48.83997743632301],
                            [2.655130086641314, 48.83964551726302],
                        ],
                    },
                },
                76: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.79158199287345, 2.4067137131838674],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 2038.29308463,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.40271281718153,
                            48.78250543550023,
                            2.409541656460374,
                            48.80020939834459,
                        ),
                        "coordinates": [
                            [2.409541656460374, 48.78250543550023],
                            [2.409504545391541, 48.782718760102725],
                            [2.409361654715678, 48.783492133803456],
                            [2.409272266165194, 48.78392047034458],
                            [2.409129272495981, 48.78462722365056],
                            [2.408971892768101, 48.78534826148277],
                            [2.408782174655474, 48.78611928576211],
                            [2.408538710867583, 48.787078310521714],
                            [2.408298656866495, 48.78791122789415],
                            [2.408169660018592, 48.78835148622518],
                            [2.408033457741617, 48.78879174723824],
                            [2.407760975044736, 48.78962230537667],
                            [2.407509982849522, 48.79037670972165],
                            [2.407208650101571, 48.79119062841646],
                            [2.40682834752396, 48.79219256245235],
                            [2.406412029096415, 48.79320165556693],
                            [2.406027942625695, 48.79409413977865],
                            [2.405733554601532, 48.79475577413811],
                            [2.405543241199632, 48.7951579962248],
                            [2.405349291749823, 48.795536427871625],
                            [2.405090645253383, 48.796012449709366],
                            [2.404609264150739, 48.796897849580674],
                            [2.404368534866408, 48.7973167562486],
                            [2.404120642832604, 48.7977689761037],
                            [2.4038655501678, 48.79822595853451],
                            [2.40357091525546, 48.79874244735021],
                            [2.402798310222541, 48.80005391144719],
                            [2.40271281718153, 48.80020939834459],
                        ],
                    },
                },
                77: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.595604808066874, 2.2824773927647555],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 2548.36843922,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.266937972614161,
                            48.591460820223375,
                            2.297950577822679,
                            48.599059348508746,
                        ),
                        "coordinates": [
                            [2.266937972614161, 48.591460820223375],
                            [2.267047525335429, 48.59151679110039],
                            [2.267393746322513, 48.591696878854286],
                            [2.268674568132321, 48.59239241779769],
                            [2.269922669670241, 48.59307077501544],
                            [2.271089898822804, 48.59370017204722],
                            [2.271525910676296, 48.59393110960185],
                            [2.272027767242565, 48.59416456845992],
                            [2.272396644934728, 48.59432799739449],
                            [2.273056651218614, 48.59459152098763],
                            [2.273601247795335, 48.59479002068213],
                            [2.274155927647354, 48.59496187494262],
                            [2.274708122737644, 48.59511374028097],
                            [2.275318074612092, 48.595263967518804],
                            [2.275717196138264, 48.59534912384036],
                            [2.276028466688033, 48.595412580583535],
                            [2.276440162842702, 48.595482751391785],
                            [2.276812599097834, 48.595538125571785],
                            [2.277128021386692, 48.59558304670883],
                            [2.277645192328033, 48.59564160986846],
                            [2.278084550472182, 48.5956801451578],
                            [2.278616804078241, 48.5957237225199],
                            [2.280698173409043, 48.59585801094676],
                            [2.282026335965663, 48.595946932759716],
                            [2.283678381982467, 48.596060972580474],
                            [2.286510473089086, 48.59626045928417],
                            [2.290291700203794, 48.59647359284977],
                            [2.291258363676342, 48.59651728825804],
                            [2.291845884000873, 48.596555828864894],
                            [2.292265183825152, 48.596582642928524],
                            [2.293081917984158, 48.596624196039],
                            [2.293298850176136, 48.59664259367458],
                            [2.293870732040014, 48.596721303727605],
                            [2.29433609656291, 48.59682351837107],
                            [2.294809322364659, 48.59695974683564],
                            [2.295325907192924, 48.597135235767595],
                            [2.295645308859402, 48.59726093930767],
                            [2.295921330104468, 48.597378776049474],
                            [2.296398449704391, 48.597590875344935],
                            [2.296779144063657, 48.59777501519646],
                            [2.2970529826857, 48.59792338887908],
                            [2.297269789044134, 48.598106612298714],
                            [2.297490499523158, 48.598344780730265],
                            [2.297597336598059, 48.59850367185756],
                            [2.297950577822679, 48.599059348508746],
                        ],
                    },
                },
                78: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.02829819019747, 2.098743182460937],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "NR",
                        "navette": 0,
                        "idrefliga": "NR",
                        "shape_leng": 2638.64991952,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.090906063354292,
                            49.01834916361145,
                            2.10385269644926,
                            49.03998130935,
                        ),
                        "coordinates": [
                            [2.090906063354292, 49.01834916361145],
                            [2.091144308072323, 49.018564409763925],
                            [2.09122053522454, 49.0186329185302],
                            [2.091279070152425, 49.018685202224916],
                            [2.091615197276309, 49.01900696553482],
                            [2.092114719567505, 49.01946756597293],
                            [2.094352501318781, 49.02152538299336],
                            [2.09533537133959, 49.022421343284144],
                            [2.096228347382347, 49.02325145976882],
                            [2.0985454164078, 49.02538579820293],
                            [2.098719477388619, 49.02558849839749],
                            [2.099135570053817, 49.026079470408554],
                            [2.09915597037364, 49.026102893950906],
                            [2.099192680202592, 49.026147034200044],
                            [2.09921442601375, 49.02617495682095],
                            [2.099275578719204, 49.02625511954155],
                            [2.09934353862269, 49.026341591980604],
                            [2.09957568245288, 49.026696389079795],
                            [2.099878297436992, 49.027185324342724],
                            [2.100089530867916, 49.02762460939573],
                            [2.100270687800041, 49.02806293202759],
                            [2.100401544114964, 49.02843910073451],
                            [2.100596206114226, 49.029201191740526],
                            [2.101124406699995, 49.03143428909256],
                            [2.101608255889117, 49.03351261773517],
                            [2.101675269178231, 49.03380142337698],
                            [2.101694080434523, 49.03387250533291],
                            [2.101706082080894, 49.03393727769525],
                            [2.101714147456867, 49.03396697038454],
                            [2.101716860891602, 49.0339714724487],
                            [2.101726217570092, 49.03401735465715],
                            [2.101765167831181, 49.03416761432772],
                            [2.101785197638508, 49.03427017303603],
                            [2.101802559365983, 49.03435833847271],
                            [2.101826776225532, 49.034442920480515],
                            [2.101860385628148, 49.03456619017363],
                            [2.101902098215733, 49.03471105970538],
                            [2.101972101625191, 49.034946813731096],
                            [2.102034027434305, 49.03515557352568],
                            [2.102300012578942, 49.03588633279511],
                            [2.1024649416769, 49.03629584159403],
                            [2.102609366399447, 49.0367035107185],
                            [2.10320372786693, 49.03828565546363],
                            [2.103441514816164, 49.03891203731664],
                            [2.103611874653595, 49.03933414594337],
                            [2.10385269644926, 49.03998130935],
                        ],
                    },
                },
                79: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.8520245704158, 2.3021937626521236],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 823.861672853,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.298301401728378,
                            48.84935055362092,
                            2.306097403692308,
                            48.85468215778704,
                        ),
                        "coordinates": [
                            [2.306097403692308, 48.85468215778704],
                            [2.300733125298419, 48.8510377224149],
                            [2.298862339812689, 48.84973975840741],
                            [2.298301401728378, 48.84935055362092],
                        ],
                    },
                },
                80: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.85620205355988, 2.3083328629905187],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 471.184831963,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.306097403692308,
                            48.85468215778704,
                            2.310565960946846,
                            48.85772541289345,
                        ),
                        "coordinates": [
                            [2.310565960946846, 48.85772541289345],
                            [2.308984358887443, 48.85664319884097],
                            [2.306684862664735, 48.855081223484696],
                            [2.306097403692308, 48.85468215778704],
                        ],
                    },
                },
                81: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.841907266348095, 2.2899350324017558],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 344.408599504,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.287945766487379,
                            48.84109405724891,
                            2.291912413317875,
                            48.842746779792876,
                        ),
                        "coordinates": [
                            [2.291912413317875, 48.842746779792876],
                            [2.291820756416435, 48.842697069668546],
                            [2.291665326961091, 48.84262039924946],
                            [2.291251417175003, 48.84244238468104],
                            [2.291020668107757, 48.842348270862445],
                            [2.287945766487379, 48.84109405724891],
                        ],
                    },
                },
                82: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.8592944523774, 2.3676595840324652],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 422.020021471,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.367210867785615,
                            48.857420037539946,
                            2.368108289338497,
                            48.86116886459571,
                        ),
                        "coordinates": [
                            [2.368108289338497, 48.857420037539946],
                            [2.36741171788129, 48.86032989554634],
                            [2.367210867785615, 48.86116886459571],
                        ],
                    },
                },
                83: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.99698913811343, 1.8738592005046046],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 4515.99165634,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.845134443502388,
                            48.99164222314708,
                            1.901781979947734,
                            49.00576253682855,
                        ),
                        "coordinates": [
                            [1.845134443502388, 48.99224128128681],
                            [1.845339087123361, 48.99224086589612],
                            [1.845700787429356, 48.99222814250953],
                            [1.846142147031367, 48.992203862759595],
                            [1.846779077664176, 48.99214710785623],
                            [1.847506679950353, 48.99206218562052],
                            [1.848661500415534, 48.991919596860875],
                            [1.849385524748993, 48.99182988690912],
                            [1.85007691425945, 48.991749553433515],
                            [1.850608913195878, 48.99169946969111],
                            [1.851198621556033, 48.991663903258484],
                            [1.851752007198012, 48.99164483658432],
                            [1.852258232083401, 48.99164222314708],
                            [1.852847519263956, 48.991649475741035],
                            [1.853219781521623, 48.991665326061096],
                            [1.853754602460592, 48.991696138749646],
                            [1.854325374562137, 48.99174851320475],
                            [1.85484179610291, 48.99181255535857],
                            [1.855307604280293, 48.99187638040057],
                            [1.855903180377851, 48.9919812001807],
                            [1.856863101136969, 48.99217320040876],
                            [1.857757924756603, 48.99236730343216],
                            [1.860716730700712, 48.99300305412534],
                            [1.86521459617215, 48.99397224754316],
                            [1.86649912593623, 48.99425830404563],
                            [1.867516535439773, 48.994498040678145],
                            [1.868295697228804, 48.994696342855555],
                            [1.868980965812998, 48.99488235987542],
                            [1.869778014771005, 48.995102141410214],
                            [1.870542529055708, 48.995321782169064],
                            [1.871869487437434, 48.995717401946784],
                            [1.874884157415533, 48.99660760533309],
                            [1.880095191668224, 48.998144193394246],
                            [1.883564543120176, 48.99917160441385],
                            [1.885375041519575, 48.99970460772858],
                            [1.886067544090376, 48.99990482628303],
                            [1.886619497887749, 49.00005214180135],
                            [1.887200494476583, 49.000187672653006],
                            [1.888034278400627, 49.00036226040809],
                            [1.888831933160587, 49.00053432248424],
                            [1.889593448734819, 49.00070385861547],
                            [1.890149081528058, 49.00084641373231],
                            [1.890740603746297, 49.001020036597545],
                            [1.89137522315858, 49.00122713678664],
                            [1.892013120835908, 49.00147231542071],
                            [1.892524714765811, 49.00168844528113],
                            [1.893176495006172, 49.002000295681974],
                            [1.893676802220116, 49.002266345534316],
                            [1.894148097076464, 49.002541799488334],
                            [1.894727106680992, 49.00290570286618],
                            [1.895694387118233, 49.00353045452068],
                            [1.89635634216309, 49.00392322439009],
                            [1.896741463756091, 49.00413171180254],
                            [1.897396921971946, 49.004443551173836],
                            [1.898088781938588, 49.00472935218384],
                            [1.898744884645162, 49.004969804545574],
                            [1.899455286756341, 49.005205700766005],
                            [1.900176791469935, 49.00541308188115],
                            [1.900797541551485, 49.00556297174352],
                            [1.901781979947734, 49.00576253682855],
                        ],
                    },
                },
                84: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.91331566771093, 2.3182610987949297],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1812.63218865,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.313835382457718,
                            48.9056549540281,
                            2.322400403166692,
                            48.92087280435657,
                        ),
                        "coordinates": [
                            [2.322400403166692, 48.9056549540281],
                            [2.322343016394903, 48.90593448954394],
                            [2.322321163367262, 48.90602351577318],
                            [2.322170935282105, 48.90659094009398],
                            [2.321997513371347, 48.90715476491949],
                            [2.321796827133725, 48.90764034846976],
                            [2.321728563122154, 48.90781120180266],
                            [2.321556521307095, 48.90813313361577],
                            [2.321330207791256, 48.90849833197662],
                            [2.321124362874009, 48.90881475654188],
                            [2.320629817828479, 48.90946752188185],
                            [2.32032954704596, 48.90985776609357],
                            [2.319924176440652, 48.91038198561147],
                            [2.319649816930623, 48.910773131270716],
                            [2.319528325280212, 48.910965558119436],
                            [2.319283957033095, 48.91140706628604],
                            [2.319120000188026, 48.91170536711489],
                            [2.318942970870801, 48.91211458694541],
                            [2.318588852132442, 48.91307578575448],
                            [2.318484080193902, 48.913306565552205],
                            [2.318422652102822, 48.91346121270532],
                            [2.318357623693711, 48.91359444478965],
                            [2.318252869329116, 48.913770499719135],
                            [2.317815825746098, 48.914389057347904],
                            [2.317255971307212, 48.9151598709375],
                            [2.316649141155665, 48.91599491534771],
                            [2.31648659391065, 48.91621854476956],
                            [2.315905032023427, 48.916998864982666],
                            [2.315649614227107, 48.9173796010488],
                            [2.315411178041731, 48.91775549361236],
                            [2.315288340981974, 48.91795533477694],
                            [2.31510882904646, 48.918283126780764],
                            [2.314389064917821, 48.91974791118154],
                            [2.313911022100327, 48.92071723734009],
                            [2.313835382457718, 48.92087280435657],
                        ],
                    },
                },
                85: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [49.00896242279198, 1.9414519203399303],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 3356.83036109,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.919237111731365,
                            49.00670027774167,
                            1.963551770278395,
                            49.01014136865553,
                        ),
                        "coordinates": [
                            [1.919237111731365, 49.00670027774167],
                            [1.919962154609168, 49.00679272531784],
                            [1.921295728366337, 49.0069141644876],
                            [1.921917281266103, 49.00697828333089],
                            [1.922560355579283, 49.007063890677166],
                            [1.923297187488737, 49.0071831440945],
                            [1.924117049575658, 49.007321728962125],
                            [1.924846556663963, 49.007452842342346],
                            [1.925464049616322, 49.00757165350609],
                            [1.925994742073372, 49.007690148787006],
                            [1.926637184087518, 49.007854250715305],
                            [1.927214624944173, 49.008006220539585],
                            [1.927976094109237, 49.00821118913309],
                            [1.929596489074198, 49.00864763260691],
                            [1.930989538629571, 49.009023764111305],
                            [1.931574217397635, 49.00917811424799],
                            [1.932126587596815, 49.00930379648014],
                            [1.932754990057206, 49.009420226009],
                            [1.933340223667563, 49.009507948589494],
                            [1.93392203816692, 49.00957186287439],
                            [1.934395579228628, 49.009606839349885],
                            [1.934923451820828, 49.00963248768522],
                            [1.935849102513868, 49.00966904677881],
                            [1.937736598157521, 49.00973988652296],
                            [1.942788014531863, 49.009931083201096],
                            [1.945622882241175, 49.01004074089918],
                            [1.948128713562733, 49.010137316349436],
                            [1.948869672389161, 49.01014136865553],
                            [1.94950346371552, 49.010129952542655],
                            [1.950256828674234, 49.01009109804834],
                            [1.950640084387352, 49.01006383987754],
                            [1.951055767526005, 49.01002349259428],
                            [1.951439393410282, 49.00997730812208],
                            [1.951758150693537, 49.009935441674244],
                            [1.952171557073107, 49.009873412573974],
                            [1.952438995344456, 49.009825900306545],
                            [1.953108952031279, 49.00972107752833],
                            [1.954506871415831, 49.009492575522245],
                            [1.95577800368968, 49.009287431617906],
                            [1.957223007196716, 49.00904715853953],
                            [1.957567380590215, 49.008986308791485],
                            [1.957937978828172, 49.00890973085301],
                            [1.958356459105238, 49.008814750951345],
                            [1.958719285382097, 49.00872594319529],
                            [1.959020045817519, 49.00864861304148],
                            [1.959781349263777, 49.00841794487313],
                            [1.960484851548508, 49.00817756363266],
                            [1.961173862662032, 49.00793951235834],
                            [1.963512748838912, 49.00714055851738],
                            [1.963551770278395, 49.00712724722575],
                        ],
                    },
                },
                86: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.84742327318669, 2.4752842544374576],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 2342.93300311,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.461697053166161,
                            48.843535700970456,
                            2.488187573818578,
                            48.85379557653064,
                        ),
                        "coordinates": [
                            [2.488187573818578, 48.85379557653064],
                            [2.488026151170836, 48.853700386686505],
                            [2.487710794332568, 48.85351465379882],
                            [2.486210503444546, 48.85263443581719],
                            [2.485533409726901, 48.85223693957022],
                            [2.48495734041789, 48.851897761377344],
                            [2.48376565257618, 48.851201462680834],
                            [2.483275607940306, 48.85091432345643],
                            [2.483038092901158, 48.850774340602065],
                            [2.48191783300419, 48.85017628518955],
                            [2.480971707757251, 48.84964926996462],
                            [2.480054724805599, 48.84918010801709],
                            [2.479499383003342, 48.84891641609899],
                            [2.478886748596456, 48.8486285124882],
                            [2.478667078396267, 48.848526268346454],
                            [2.478227730268892, 48.84831818139092],
                            [2.477698340004548, 48.84806973631689],
                            [2.477385889901806, 48.84792174047433],
                            [2.477137570633965, 48.84780514060543],
                            [2.476747352711748, 48.84762036877412],
                            [2.476196147110223, 48.84736115155709],
                            [2.475895983562817, 48.847218533223426],
                            [2.47551942336589, 48.84704183387312],
                            [2.475091018731824, 48.846840016371864],
                            [2.474769032778936, 48.846687528845735],
                            [2.474545282127779, 48.846581684960434],
                            [2.47428742459903, 48.846459694054694],
                            [2.473879474918706, 48.84626054488012],
                            [2.473766229315843, 48.84620402635157],
                            [2.473545198103419, 48.84609457980709],
                            [2.473277776819685, 48.84596180723225],
                            [2.472800246764779, 48.84572586757133],
                            [2.472459156848068, 48.84555720905356],
                            [2.471757883431485, 48.845210920009016],
                            [2.471340392906684, 48.845002781096326],
                            [2.470333380753157, 48.84444910962284],
                            [2.470184662276157, 48.8443719460013],
                            [2.469748053972886, 48.8441422401421],
                            [2.469506306450234, 48.844036034224786],
                            [2.46920679614395, 48.84392217346711],
                            [2.468878526048441, 48.8438368978605],
                            [2.468512637464665, 48.84376058174031],
                            [2.468090075933323, 48.84368642908167],
                            [2.467609025361742, 48.843614702805816],
                            [2.467096487269306, 48.84355267683406],
                            [2.466749207003489, 48.843535700970456],
                            [2.466381174362278, 48.84354539804679],
                            [2.465990352868966, 48.84358085763241],
                            [2.465576208259491, 48.84364163283772],
                            [2.465066853243504, 48.843722242414984],
                            [2.464298733820078, 48.843844505927976],
                            [2.46362127531146, 48.843961793805214],
                            [2.463283999721662, 48.844017369292494],
                            [2.462476869783194, 48.844162925469625],
                            [2.461697053166161, 48.844305524221596],
                        ],
                    },
                },
                87: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.9712674260537, 2.038578397804256],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1732.17472117,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.027518775677185,
                            48.969987572193546,
                            2.049083121493801,
                            48.97482086455293,
                        ),
                        "coordinates": [
                            [2.027518775677185, 48.9703669339495],
                            [2.029697735715853, 48.97014792031068],
                            [2.030373941673409, 48.97008787285684],
                            [2.031039229438515, 48.97003968591812],
                            [2.031639332769309, 48.97001273643106],
                            [2.032196021539893, 48.96999280693307],
                            [2.032911640449786, 48.969987572193546],
                            [2.033457328587801, 48.96999377966578],
                            [2.033999358836002, 48.97000711357591],
                            [2.034530503128254, 48.97002755355511],
                            [2.035216893226258, 48.97007457236039],
                            [2.03578037484953, 48.970126024583394],
                            [2.036574972096633, 48.970209011235376],
                            [2.037271934473995, 48.97030125490967],
                            [2.037874905379498, 48.970398006789445],
                            [2.038542804221758, 48.97051633938152],
                            [2.039167293932286, 48.97064169376353],
                            [2.039809727171332, 48.97078850445559],
                            [2.040462908289185, 48.970951993196294],
                            [2.041307230331253, 48.97118497667782],
                            [2.041862781201672, 48.971357723212584],
                            [2.042483183086317, 48.97156632525577],
                            [2.043060203455286, 48.97177719392779],
                            [2.043669589789665, 48.97201669316724],
                            [2.044217597282537, 48.97224651653825],
                            [2.044794323339983, 48.97250971929899],
                            [2.045219540670145, 48.97272494466729],
                            [2.045716765166938, 48.9729879424503],
                            [2.046866063316261, 48.973614253996054],
                            [2.047906545527419, 48.97417623188714],
                            [2.049083121493801, 48.97482086455293],
                        ],
                    },
                },
                88: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.84134815056841, 2.5363336873994156],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1803.93829,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.525922546560017,
                            48.84069774811574,
                            2.547775189299494,
                            48.844901139612055,
                        ),
                        "coordinates": [
                            [2.547775189299494, 48.84084343185482],
                            [2.547773029603954, 48.84084344797284],
                            [2.54618117540151, 48.84083781171269],
                            [2.543440733613217, 48.840798546376256],
                            [2.541135049724195, 48.84076700317546],
                            [2.538076724435698, 48.840738170325515],
                            [2.536372354265205, 48.840718318676],
                            [2.534760990146147, 48.840699708334746],
                            [2.534244073628467, 48.84069774811574],
                            [2.533481044941964, 48.84071750860806],
                            [2.532988025695994, 48.84075972316447],
                            [2.532760605880169, 48.8407852930702],
                            [2.532518231831299, 48.84081898188953],
                            [2.532009062539633, 48.84091247945275],
                            [2.531755865658337, 48.840965969429725],
                            [2.531246841659047, 48.84109723248938],
                            [2.530751550532498, 48.84125724727861],
                            [2.530501226101306, 48.84134939808981],
                            [2.530278144570199, 48.84144060400809],
                            [2.529912301038834, 48.84160669048067],
                            [2.529667537311592, 48.84172850661931],
                            [2.529411950969205, 48.841870124705345],
                            [2.529069417115513, 48.84207663693751],
                            [2.528857455476507, 48.842226274147826],
                            [2.528694415089344, 48.84234345466786],
                            [2.52824083468265, 48.84272640983125],
                            [2.527849830056378, 48.8430858772645],
                            [2.527528107609016, 48.84339396833171],
                            [2.527194168671096, 48.84371466939725],
                            [2.526826223462014, 48.84405161206988],
                            [2.526281808823845, 48.8445615088763],
                            [2.525922546560017, 48.844901139612055],
                        ],
                    },
                },
                89: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.83874110958538, 2.6441525461550777],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1637.12771627,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.633210913417633,
                            48.83817971021005,
                            2.655130086641314,
                            48.83964551726302,
                        ),
                        "coordinates": [
                            [2.655130086641314, 48.83964551726302],
                            [2.652211455711688, 48.83930717285293],
                            [2.650693528078407, 48.83913052568535],
                            [2.649022744125503, 48.838948564239935],
                            [2.645580122660524, 48.8385581943891],
                            [2.643334027455206, 48.83831629209087],
                            [2.642555693464354, 48.83824463832884],
                            [2.641800692607114, 48.83820079415843],
                            [2.640939570114344, 48.83817971021005],
                            [2.640401456961091, 48.83818114253053],
                            [2.63958011098775, 48.83820400783997],
                            [2.638991783321358, 48.83823704108516],
                            [2.638569664272801, 48.83827053238254],
                            [2.638127306838617, 48.838307813762086],
                            [2.637604410180904, 48.83837649748911],
                            [2.637057220089383, 48.83845437747083],
                            [2.636421770609677, 48.8385673705528],
                            [2.635897791311999, 48.83866785335885],
                            [2.634568389656018, 48.83893661760156],
                            [2.634085353299929, 48.839036797533204],
                            [2.633210913417633, 48.83921929995164],
                        ],
                    },
                },
                90: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.987580197609205, 1.827066751252897],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 2859.41441828,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.808907828712391,
                            48.98297976320563,
                            1.845134443502388,
                            48.992241629671234,
                        ),
                        "coordinates": [
                            [1.808907828712391, 48.98297976320563],
                            [1.814186700328448, 48.98426983899382],
                            [1.817093127672203, 48.984975485028244],
                            [1.830703012666158, 48.98830102949521],
                            [1.833822661788837, 48.9890619165253],
                            [1.834522231246966, 48.98924344293764],
                            [1.835091823233133, 48.98940774141917],
                            [1.835632348833083, 48.98958618445617],
                            [1.836215878498463, 48.98980288592875],
                            [1.836878424452741, 48.99007227475576],
                            [1.838523288626669, 48.99081468162012],
                            [1.839149631768785, 48.99109103808666],
                            [1.839617786325658, 48.99127866461101],
                            [1.840046481930515, 48.99143518747165],
                            [1.840489814688565, 48.99157511592291],
                            [1.840890015633595, 48.99168868284594],
                            [1.841431067858026, 48.99181951369095],
                            [1.841986697410191, 48.991938507597496],
                            [1.8425461638335, 48.99203610276609],
                            [1.843163547288799, 48.99212680478414],
                            [1.843683670107396, 48.99218139359167],
                            [1.844265424092584, 48.99221959223536],
                            [1.844963045003878, 48.992241629671234],
                            [1.845134443502388, 48.99224128128681],
                        ],
                    },
                },
                91: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.86785107035018, 2.2734975381145786],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 777.471132319,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.272120138879799,
                            48.86446175107751,
                            2.275574526847743,
                            48.870974138193766,
                        ),
                        "coordinates": [
                            [2.272120621598503, 48.86446175107751],
                            [2.272120138879799, 48.864832008903306],
                            [2.272127086099549, 48.86516816878753],
                            [2.272163569125495, 48.86550434450914],
                            [2.272214899155489, 48.86578206710471],
                            [2.272288388108724, 48.866054931140674],
                            [2.272369331895322, 48.86627420847161],
                            [2.272457630000423, 48.86651784975745],
                            [2.272538613999333, 48.86670789551702],
                            [2.272619611938358, 48.866888198604066],
                            [2.272884906318504, 48.867317067758115],
                            [2.273400973685293, 48.86798966628254],
                            [2.273998189559551, 48.86874025664755],
                            [2.27455946771283, 48.869459209571225],
                            [2.274571714316648, 48.86947720241366],
                            [2.27497038321126, 48.870072738979324],
                            [2.275170399511087, 48.87037230540044],
                            [2.275179923655839, 48.870386699575334],
                            [2.27543166144265, 48.87075463855705],
                            [2.275574526847743, 48.870974138193766],
                        ],
                    },
                },
                92: {
                    "attributes": {
                        "reseau": "PARIS NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE K",
                        "rer": 0,
                        "extcode": "800:K",
                        "geo_point_2d": [48.93220401222064, 2.485593854073034],
                        "indice_lig": "K",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01738",
                        "navette": 0,
                        "idrefliga": "A02175",
                        "shape_leng": 1453.79505853,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.475674370833512,
                            48.93212901293364,
                            2.495513142584314,
                            48.93230541606912,
                        ),
                        "coordinates": [
                            [2.475674370833512, 48.93230541606912],
                            [2.476163709743931, 48.93230003707236],
                            [2.477409636592118, 48.93228483173492],
                            [2.478716297186294, 48.9322688686431],
                            [2.480597999968426, 48.932242802188085],
                            [2.485909369257553, 48.93219180371595],
                            [2.488602667950408, 48.93216023242055],
                            [2.490988334468279, 48.93212901293364],
                            [2.493681829925758, 48.932162007084386],
                            [2.49440185171253, 48.932173955094534],
                            [2.495513142584314, 48.93219600596196],
                        ],
                    },
                },
                93: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.716884021644645, 2.4470935220619707],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01745",
                        "navette": 0,
                        "idrefliga": "A02171",
                        "shape_leng": 3717.07077233,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.438093383889102,
                            48.70823782858165,
                            2.462282244689792,
                            48.73011683142026,
                        ),
                        "coordinates": [
                            [2.462282244689792, 48.70823782858165],
                            [2.460983910433233, 48.70879460381943],
                            [2.460264468713545, 48.70910940162476],
                            [2.45989156299872, 48.70928770107002],
                            [2.459540394511254, 48.70947546745735],
                            [2.459186371898107, 48.70968137901128],
                            [2.458828870992446, 48.70990805478701],
                            [2.4581193284077, 48.710365645385814],
                            [2.45788462065311, 48.71051697335805],
                            [2.4573934369007, 48.710810659335635],
                            [2.457066390778859, 48.71098996065503],
                            [2.456146253745974, 48.71147204257776],
                            [2.455711881415892, 48.71166494265567],
                            [2.455406437124127, 48.711790260756786],
                            [2.45442359216518, 48.71220045254005],
                            [2.453762414097586, 48.71245293242585],
                            [2.451625523919498, 48.7133130196957],
                            [2.451142189484145, 48.713502354460644],
                            [2.450760658087116, 48.713643024944055],
                            [2.450474138316585, 48.713735037731645],
                            [2.45012376227197, 48.71383340884293],
                            [2.449712228421354, 48.71392914211516],
                            [2.449243587887568, 48.71401144056516],
                            [2.448787122355311, 48.71407034461838],
                            [2.448427319688785, 48.7141076013759],
                            [2.448015377294803, 48.71412506080166],
                            [2.447647093473568, 48.71411822694539],
                            [2.446926798726546, 48.71408835290434],
                            [2.446281276317311, 48.714072790965105],
                            [2.445407435106446, 48.71404755225977],
                            [2.44471845892446, 48.7140464104308],
                            [2.444150481297779, 48.714070330422494],
                            [2.443659987170575, 48.714105865696325],
                            [2.443169542254486, 48.71416477873885],
                            [2.442869323816343, 48.714213620946566],
                            [2.442552623224028, 48.71426550651059],
                            [2.442255364780425, 48.71434368775591],
                            [2.441614354305444, 48.71453582667013],
                            [2.441231430498669, 48.71467646649414],
                            [2.440803740234079, 48.714856713288114],
                            [2.440404624068385, 48.71505491884784],
                            [2.44005715933288, 48.71526026876353],
                            [2.439504846271283, 48.715639363933136],
                            [2.439275602654027, 48.715844604756086],
                            [2.439032833066198, 48.71608133259323],
                            [2.438822682066663, 48.71632072727946],
                            [2.438653267876831, 48.71654479851283],
                            [2.438431101762117, 48.716906959958216],
                            [2.438249711512178, 48.71729614086154],
                            [2.438178333422549, 48.717559518330255],
                            [2.438116704366139, 48.7179021951341],
                            [2.438093383889102, 48.71822263243712],
                            [2.438108347463893, 48.71850813798271],
                            [2.43815434831925, 48.7187313567867],
                            [2.438233522983043, 48.71911851748304],
                            [2.438364435249654, 48.7194806567947],
                            [2.43852495245468, 48.71982326862533],
                            [2.438704570856386, 48.720127660535574],
                            [2.43895095254639, 48.72041813306976],
                            [2.439645733248798, 48.72115958316324],
                            [2.43999873658582, 48.72144716199589],
                            [2.440384148210437, 48.72175374324625],
                            [2.440884786413756, 48.722131597580464],
                            [2.441352983723824, 48.722469032149334],
                            [2.441752777144327, 48.72276607883646],
                            [2.442040937787661, 48.72298946892722],
                            [2.44223548143611, 48.72315584184236],
                            [2.442469725183576, 48.72338879718654],
                            [2.442657165211647, 48.7235956239343],
                            [2.442844687405979, 48.72384051987785],
                            [2.443028625997199, 48.724090176611114],
                            [2.443194594919307, 48.72434460977975],
                            [2.4434291891175, 48.724736978193924],
                            [2.443839778338836, 48.725681117140645],
                            [2.444123624612847, 48.726203326118146],
                            [2.444202786960045, 48.7263543286648],
                            [2.444305117491671, 48.726533186922836],
                            [2.444408805593823, 48.72671114474048],
                            [2.444523377410538, 48.72689268881358],
                            [2.444943425580544, 48.72755208104018],
                            [2.44541690109799, 48.728360348361576],
                            [2.445687086449872, 48.72883670349414],
                            [2.445830415179587, 48.72911084413214],
                            [2.445921963217562, 48.72932658073056],
                            [2.446005440453732, 48.729580994507565],
                            [2.446054793282373, 48.72977069404581],
                            [2.446105500724956, 48.729957693392315],
                            [2.446135830934545, 48.73011683142026],
                        ],
                    },
                },
                94: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.4003702698243, 2.7405343694033517],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01745",
                        "navette": 0,
                        "idrefliga": "A02171",
                        "shape_leng": 4402.83068922,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.725685583605634,
                            48.394308438758266,
                            2.764028188787889,
                            48.416377033006604,
                        ),
                        "coordinates": [
                            [2.764028188787889, 48.394308438758266],
                            [2.763126578901833, 48.394390386630114],
                            [2.762026571127661, 48.39448100457268],
                            [2.760321297610465, 48.3946230434602],
                            [2.758757356663343, 48.39474759230496],
                            [2.757649500724457, 48.394835351208386],
                            [2.753678371873878, 48.39517199467734],
                            [2.752523311883279, 48.39526886970745],
                            [2.75101743052066, 48.39539754823184],
                            [2.749543910243132, 48.395521684086276],
                            [2.748745012052305, 48.39558124961076],
                            [2.748059966033951, 48.39564154114412],
                            [2.747513063189951, 48.395690044916485],
                            [2.747003836064991, 48.39573429195899],
                            [2.746101646752111, 48.39581476324794],
                            [2.74517120107466, 48.39591275726854],
                            [2.74437895638145, 48.39602061988101],
                            [2.743765304410223, 48.396112755611945],
                            [2.742972482153477, 48.396257688308985],
                            [2.741899604358853, 48.39648365581718],
                            [2.740933356187616, 48.39671264009034],
                            [2.740403476486886, 48.3968460067594],
                            [2.739554684237278, 48.39708643592351],
                            [2.738666117220153, 48.397361251998305],
                            [2.737850994699494, 48.397650927942905],
                            [2.737066146164455, 48.397954059624844],
                            [2.736215541808712, 48.398310473739144],
                            [2.735514659130686, 48.3986465701702],
                            [2.73494568923817, 48.39893004162216],
                            [2.733783993354781, 48.39956899964746],
                            [2.732651236450351, 48.40028518015406],
                            [2.732374577850641, 48.40047948761717],
                            [2.732028077394721, 48.40072259821432],
                            [2.731342022896275, 48.40123487101453],
                            [2.730699324796302, 48.40176677257546],
                            [2.730068993722046, 48.402327403324286],
                            [2.729892050597703, 48.40249617967574],
                            [2.729666202231323, 48.402718855628486],
                            [2.729500733563992, 48.402883319327145],
                            [2.729119019656139, 48.40329020825842],
                            [2.72868944749457, 48.40379528004186],
                            [2.728181286937066, 48.40444180490654],
                            [2.727844643400242, 48.404915977642744],
                            [2.727568375879036, 48.40533958208344],
                            [2.727244435845665, 48.40588564973888],
                            [2.726944888618034, 48.406443322325785],
                            [2.726691253507572, 48.406999287830935],
                            [2.72659562693465, 48.40720889280618],
                            [2.726526744637031, 48.40738268714426],
                            [2.726336260139316, 48.407898616450986],
                            [2.726181693915671, 48.408344279214546],
                            [2.725995032288738, 48.409005874160734],
                            [2.725942750976443, 48.40923086816349],
                            [2.725909358202428, 48.409396668539735],
                            [2.725868777010266, 48.40961960137255],
                            [2.725808126471974, 48.40998490749837],
                            [2.725746424715627, 48.41038888472404],
                            [2.725685583605634, 48.41125237992094],
                            [2.725685950470871, 48.41182250615781],
                            [2.72569692547183, 48.412094060132304],
                            [2.725712845366715, 48.41232959417772],
                            [2.725730315681396, 48.41249229905219],
                            [2.725751985051398, 48.41267387404075],
                            [2.725798115494479, 48.413209447058115],
                            [2.72586359520443, 48.41381831824005],
                            [2.725942597037732, 48.41432721450449],
                            [2.726038806308719, 48.414750395910374],
                            [2.726141499049052, 48.41508790161538],
                            [2.726525245192769, 48.41605691116175],
                            [2.726661533081673, 48.416377033006604],
                        ],
                    },
                },
                95: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.878150523525754, 2.6718618432719228],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 5106.56513654,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.637590717167975,
                            48.87520826545471,
                            2.706014179759928,
                            48.8821891367053,
                        ),
                        "coordinates": [
                            [2.637590717167975, 48.87520826545471],
                            [2.639501827967145, 48.87529591500355],
                            [2.641728063574485, 48.87538206469342],
                            [2.642860912098314, 48.87542258609675],
                            [2.644592904687644, 48.875508348157425],
                            [2.645740306052573, 48.87555759715815],
                            [2.646847971766107, 48.87559742442043],
                            [2.648197452884676, 48.87565799533788],
                            [2.650239784360432, 48.875759480792986],
                            [2.651527983023901, 48.875824940472356],
                            [2.652693479845031, 48.87588120718402],
                            [2.654032184690428, 48.87594649862967],
                            [2.655002820985922, 48.87599138595938],
                            [2.658041477654103, 48.87613856290198],
                            [2.659874089851316, 48.87621802751477],
                            [2.661779253654797, 48.876298279687475],
                            [2.663781960604314, 48.87639963597834],
                            [2.66670141427873, 48.87654575534861],
                            [2.667853296516822, 48.876610948266325],
                            [2.668444902453116, 48.87665638116822],
                            [2.669067415276588, 48.87671021522502],
                            [2.669631968750593, 48.876769432162604],
                            [2.670175480945566, 48.876835662451896],
                            [2.670679473282603, 48.87690548312522],
                            [2.671257387461126, 48.876990735437936],
                            [2.671943587250825, 48.87710522699537],
                            [2.672582326610504, 48.877218115328304],
                            [2.673213265600698, 48.877346673729996],
                            [2.673828414690495, 48.877478752432765],
                            [2.674681265399872, 48.87767446280215],
                            [2.67706832449245, 48.87823598321064],
                            [2.681074115056026, 48.87917165785329],
                            [2.683553734313555, 48.879753630437634],
                            [2.684224475693452, 48.8799098281598],
                            [2.684768429176102, 48.88003163238509],
                            [2.685285925293604, 48.8801396015488],
                            [2.686001384905116, 48.88028000340225],
                            [2.686925294353807, 48.88044410523126],
                            [2.689005393083607, 48.8808080890086],
                            [2.689865839666754, 48.88094280261593],
                            [2.690623294172337, 48.88105348419797],
                            [2.691562729337255, 48.88117229023932],
                            [2.6926339902513, 48.88129067917066],
                            [2.693689288654845, 48.88138824005221],
                            [2.694607306828951, 48.88146013950243],
                            [2.696142508184224, 48.88156486880858],
                            [2.699260271915324, 48.88175846503482],
                            [2.704285183743431, 48.882078003297934],
                            [2.706014179759928, 48.8821891367053],
                        ],
                    },
                },
                96: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.876525173157034, 2.484881107387862],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 1461.41150809,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.481421258690829,
                            48.86991241918608,
                            2.48624016101661,
                            48.88230400665456,
                        ),
                        "coordinates": [
                            [2.481421258690829, 48.88230400665456],
                            [2.482002110276723, 48.88167667369007],
                            [2.482400360106924, 48.88124631151913],
                            [2.482536273619913, 48.881097757575006],
                            [2.482896410749996, 48.880692622043405],
                            [2.483300285140525, 48.880235879488275],
                            [2.483961905991979, 48.87950457051255],
                            [2.484256765404425, 48.879182977480575],
                            [2.484468884423603, 48.878940011218695],
                            [2.484702474556856, 48.878639910392906],
                            [2.484878905805151, 48.87839870704009],
                            [2.485048557720638, 48.87813859564237],
                            [2.485198031495068, 48.87788025697987],
                            [2.485346909474769, 48.87760313675325],
                            [2.485459426487179, 48.87738716326004],
                            [2.485547415677536, 48.877175718432],
                            [2.485670460790816, 48.876833832459134],
                            [2.485760458163955, 48.876568504929374],
                            [2.485814032566226, 48.876389983656146],
                            [2.485906886925282, 48.8760781686341],
                            [2.485963930603088, 48.87585443509884],
                            [2.486017418568939, 48.8756473624002],
                            [2.486070768650098, 48.875395081796675],
                            [2.486120447842253, 48.87512139221512],
                            [2.486184326312482, 48.874771543890645],
                            [2.486226431624454, 48.87437889660741],
                            [2.48624016101661, 48.87414570285082],
                            [2.486239460219678, 48.87391252805102],
                            [2.486227988061312, 48.87369602184562],
                            [2.48610475195852, 48.87229474845391],
                            [2.486056305620401, 48.87177611417295],
                            [2.486011674208813, 48.8713264762644],
                            [2.485916040919188, 48.870707970752974],
                            [2.485761140611789, 48.86991241918608],
                        ],
                    },
                },
                97: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.74558913351448, 2.7283573369901104],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 253.938046092,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.727229371429766,
                            48.74472077575101,
                            2.729481333043577,
                            48.746452320704556,
                        ),
                        "coordinates": [
                            [2.727229371429766, 48.746452320704556],
                            [2.728179796656208, 48.74572975657104],
                            [2.729481333043577, 48.74472077575101],
                        ],
                    },
                },
                98: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.85533359324683, 2.368649449128164],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 460.881116057,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.368108289338497,
                            48.8534394275684,
                            2.369513568156525,
                            48.857420037539946,
                        ),
                        "coordinates": [
                            [2.369513568156525, 48.8534394275684],
                            [2.369409437789544, 48.85350300354124],
                            [2.369313185593906, 48.85357177603231],
                            [2.369225406852815, 48.853645318307535],
                            [2.36914664263279, 48.85372317996379],
                            [2.369077379891992, 48.8538048779355],
                            [2.369018040392512, 48.85388991172466],
                            [2.3689689944358, 48.853977754479],
                            [2.368930547081431, 48.85406786551022],
                            [2.368904564899556, 48.85415298071665],
                            [2.368505159064627, 48.85576200323284],
                            [2.368234848429127, 48.85689131913541],
                            [2.368108289338497, 48.857420037539946],
                        ],
                    },
                },
                99: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M6",
                        "rer": 0,
                        "extcode": "100110006:6",
                        "geo_point_2d": [48.865296479071255, 2.2888202381938845],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01376",
                        "navette": 0,
                        "idrefliga": "A01539",
                        "shape_leng": 416.736921337,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.287580162529652,
                            48.86361093764567,
                            2.290058833580487,
                            48.86698310944948,
                        ),
                        "coordinates": [
                            [2.290058833580487, 48.86698310944948],
                            [2.289730290058539, 48.86653268808891],
                            [2.28795952649392, 48.864126475049915],
                            [2.287768624731509, 48.863869120171074],
                            [2.287646011085742, 48.86370114697349],
                            [2.287580162529652, 48.86361093764567],
                        ],
                    },
                },
                100: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.642800403579216, 2.3970882627789267],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 2704.34749206,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.391689078843198,
                            48.63635136710195,
                            2.407796286173906,
                            48.65396975838212,
                        ),
                        "coordinates": [
                            [2.39617681244956, 48.65396975838212],
                            [2.395864101010868, 48.653518490020446],
                            [2.395458939069624, 48.65292968134022],
                            [2.395239316582994, 48.65260545624076],
                            [2.394940922720937, 48.65215837725698],
                            [2.394562949858908, 48.65158843593755],
                            [2.394156424820623, 48.65096724961034],
                            [2.393767579145324, 48.650367635322716],
                            [2.392841130134514, 48.648936312722356],
                            [2.392520884273106, 48.6484438262315],
                            [2.39231987647181, 48.64813195496308],
                            [2.392183040382199, 48.64791500761341],
                            [2.392037078500611, 48.647659555827914],
                            [2.391944853857916, 48.64745969433567],
                            [2.391844566074487, 48.64719598837524],
                            [2.391787770467719, 48.646979280642384],
                            [2.39171271573646, 48.64660252402962],
                            [2.391689078843198, 48.646088156185264],
                            [2.391703738547119, 48.64584534752414],
                            [2.391737373089843, 48.645580048025046],
                            [2.391784606952316, 48.64534082007902],
                            [2.391938706222179, 48.644793992316636],
                            [2.392055108655321, 48.64452055868223],
                            [2.392202704490011, 48.64423272177893],
                            [2.392378495723339, 48.64395832412358],
                            [2.392537313450767, 48.643717279037446],
                            [2.392762269197696, 48.64344289208505],
                            [2.393014354857973, 48.64316219605001],
                            [2.39337220921782, 48.642816700866675],
                            [2.394325141387599, 48.64192594901282],
                            [2.394605152743046, 48.641662659277436],
                            [2.394976729423956, 48.641313734056276],
                            [2.395935416001102, 48.640413455645955],
                            [2.39654675946726, 48.63988976293397],
                            [2.396900566429323, 48.63960270989555],
                            [2.397406375167309, 48.6392119269203],
                            [2.397720723104093, 48.638976384060314],
                            [2.398332148508299, 48.638548903472746],
                            [2.399088668369362, 48.63805749156287],
                            [2.399781492121971, 48.637638950269945],
                            [2.400094710694295, 48.63747151211496],
                            [2.400471679051141, 48.63729144718596],
                            [2.400807987420308, 48.63714737405335],
                            [2.401233825666714, 48.636988861142434],
                            [2.401593225070181, 48.636867254845754],
                            [2.401996052478821, 48.63675461416553],
                            [2.402397531674984, 48.63665006641713],
                            [2.402696725458449, 48.63659203943385],
                            [2.402926550812501, 48.63654724139136],
                            [2.403265675028598, 48.63648859003345],
                            [2.403523420362856, 48.636453365728094],
                            [2.403872066083513, 48.636413591725606],
                            [2.404394378400966, 48.63637191364101],
                            [2.405056478448452, 48.636357126288175],
                            [2.406261317369262, 48.63635549194504],
                            [2.407796286173906, 48.63635136710195],
                        ],
                    },
                },
                101: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.624572448151746, 2.4400913938885833],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1722.12779576,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.428738987337901,
                            48.62315996513932,
                            2.451409095593275,
                            48.62602242896445,
                        ),
                        "coordinates": [
                            [2.428738987337901, 48.62602242896445],
                            [2.428742301467787, 48.62602213092529],
                            [2.42916663667279, 48.625984041126706],
                            [2.430155386011357, 48.6259013949163],
                            [2.43099629559297, 48.6258314534492],
                            [2.431781593578669, 48.62576604962319],
                            [2.432153221002561, 48.62573606061387],
                            [2.433009043722516, 48.62566429334606],
                            [2.433615305311759, 48.625613416807894],
                            [2.434155099641001, 48.62556349337359],
                            [2.436996542166473, 48.62534248914052],
                            [2.43763669817619, 48.625286165422374],
                            [2.438209008928098, 48.62522090625164],
                            [2.438771789928664, 48.625139465578904],
                            [2.43930741900475, 48.62504815529787],
                            [2.439715550758611, 48.62496415334572],
                            [2.44030262647675, 48.62482692872933],
                            [2.440769353361479, 48.62469820342291],
                            [2.44107627687062, 48.624605715816685],
                            [2.441618915868571, 48.62441654996222],
                            [2.443183106310344, 48.62386114223498],
                            [2.443723960267897, 48.62368617448034],
                            [2.444184876614605, 48.6235562437341],
                            [2.444631595810533, 48.62345389098151],
                            [2.444988864230892, 48.623376523226035],
                            [2.445512258091159, 48.62328699364285],
                            [2.445944788251775, 48.62323704186018],
                            [2.446338377141303, 48.62320265456813],
                            [2.44668804813741, 48.62317344921166],
                            [2.447087025781402, 48.62315996513932],
                            [2.447326908237569, 48.623162035582666],
                            [2.447762367852635, 48.62318049332132],
                            [2.448049961623548, 48.62319280061602],
                            [2.448286004453629, 48.62320246040809],
                            [2.448630080129199, 48.6232166596575],
                            [2.448977856634347, 48.62323145162825],
                            [2.449340621993819, 48.62324589180375],
                            [2.449665638963876, 48.62325954388407],
                            [2.450099743361497, 48.623277994002464],
                            [2.450468732213283, 48.623292911932346],
                            [2.451409095593275, 48.62333224107223],
                        ],
                    },
                },
                102: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.66108419196308, 2.3992329530942507],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1691.41810349,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.39617681244956,
                            48.65396975838212,
                            2.401016156351858,
                            48.667915766467786,
                        ),
                        "coordinates": [
                            [2.397532093159732, 48.667915766467786],
                            [2.39888154121098, 48.666765773934685],
                            [2.399186655764104, 48.66648323608973],
                            [2.39941600821206, 48.666269946615714],
                            [2.39971820317037, 48.66597305914164],
                            [2.399865324181742, 48.66580642885111],
                            [2.40004904206656, 48.66557198602677],
                            [2.400188396378808, 48.66538058994313],
                            [2.4003936306488, 48.66505824352663],
                            [2.400575963959229, 48.6647181010123],
                            [2.400678840861131, 48.664484233643506],
                            [2.400777562284033, 48.664188318616596],
                            [2.400882976550303, 48.66381776078706],
                            [2.400953025241312, 48.66351056106398],
                            [2.400989938403034, 48.66321518322503],
                            [2.401016156351858, 48.662873455280376],
                            [2.401013098175372, 48.662607273825195],
                            [2.400975960555513, 48.662195357856845],
                            [2.400929407712837, 48.661922080086164],
                            [2.400788833236759, 48.66133583812131],
                            [2.400595318205693, 48.6607487259052],
                            [2.40036527496261, 48.66025336004428],
                            [2.400188814020248, 48.659944907763176],
                            [2.399772197466639, 48.65928248417143],
                            [2.399141142366588, 48.658318818597024],
                            [2.397741828610799, 48.65624047535344],
                            [2.397718711885923, 48.65620631502295],
                            [2.39766431784046, 48.656124511818625],
                            [2.397419550586035, 48.65575954035897],
                            [2.396905592852952, 48.655026012462905],
                            [2.39617681244956, 48.65396975838212],
                        ],
                    },
                },
                103: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.62256121614571, 2.4609490265889007],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1460.71349754,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.451409095593275,
                            48.620290259939715,
                            2.470234997616056,
                            48.62351258610026,
                        ),
                        "coordinates": [
                            [2.451409095593275, 48.62333224107223],
                            [2.453114062864075, 48.62340352973044],
                            [2.453693772210745, 48.62342684048099],
                            [2.454192545172785, 48.62344737851048],
                            [2.455228983102236, 48.62349305994019],
                            [2.455911319900418, 48.62351032928923],
                            [2.456329113521387, 48.62351258610026],
                            [2.456781489060409, 48.62350569990087],
                            [2.45721886040086, 48.62347657126055],
                            [2.457696497870699, 48.623433346227365],
                            [2.458213156556097, 48.62337093095124],
                            [2.458730833430602, 48.62328340787198],
                            [2.45950178514217, 48.623126956610925],
                            [2.461484388251039, 48.62272735838829],
                            [2.462029393479884, 48.622615248121264],
                            [2.46285367774219, 48.622447069477104],
                            [2.46387048942235, 48.62224809319325],
                            [2.46449274961663, 48.62211699941729],
                            [2.464899463272262, 48.62203470662792],
                            [2.465598997835206, 48.62188913007324],
                            [2.46637734294892, 48.6217320477142],
                            [2.46690719694398, 48.62160706321074],
                            [2.467255564999587, 48.62152033281481],
                            [2.467639513736466, 48.62140772462234],
                            [2.467940077309812, 48.62131493612504],
                            [2.468166285161286, 48.621239105511755],
                            [2.468408885208123, 48.621150298236955],
                            [2.46860069468404, 48.621079927186024],
                            [2.468786922021146, 48.6210005797618],
                            [2.46902310495756, 48.620903754830834],
                            [2.469303113917114, 48.620777857798295],
                            [2.46963498155279, 48.620611104369736],
                            [2.470234997616056, 48.620290259939715],
                        ],
                    },
                },
                104: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T4",
                        "rer": 0,
                        "extcode": "800:T4",
                        "geo_point_2d": [48.89254031037891, 2.4936512587466804],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01843",
                        "navette": 0,
                        "idrefliga": "A01761",
                        "shape_leng": 854.883281953,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.487910986261173,
                            48.89221962480339,
                            2.499388457291095,
                            48.893094628632376,
                        ),
                        "coordinates": [
                            [2.487910986261173, 48.893094628632376],
                            [2.488874894937666, 48.89295227248385],
                            [2.490249091498063, 48.89275057105122],
                            [2.490580920786352, 48.892702539048415],
                            [2.490937998983932, 48.89265209089862],
                            [2.491251812725068, 48.89261359677553],
                            [2.49152597788434, 48.89258943306217],
                            [2.491814597004557, 48.89257238694861],
                            [2.492164577896476, 48.89256001509356],
                            [2.492640879139245, 48.89255698712453],
                            [2.493340896319599, 48.89255127349638],
                            [2.493662020000235, 48.89254369439483],
                            [2.4939181781454, 48.892531444966025],
                            [2.494242860800842, 48.89250720524032],
                            [2.494535059760832, 48.892480629610986],
                            [2.494830849293523, 48.8924492894826],
                            [2.49586241754877, 48.89231223465382],
                            [2.496219525580559, 48.89227366876907],
                            [2.496663241386505, 48.89223735893589],
                            [2.497085369617848, 48.89222011120564],
                            [2.497431773305663, 48.89221962480339],
                            [2.49776016104334, 48.89222630128547],
                            [2.49803447200481, 48.89224970938686],
                            [2.49831965180608, 48.892284996413224],
                            [2.498594028247652, 48.8923274373981],
                            [2.498875669452198, 48.892384142428924],
                            [2.499388457291095, 48.89250476140823],
                        ],
                    },
                },
                105: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T4",
                        "rer": 0,
                        "extcode": "800:T4",
                        "geo_point_2d": [48.919152572940746, 2.515110202237391],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01843",
                        "navette": 0,
                        "idrefliga": "A01761",
                        "shape_leng": 678.653166425,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.514613744110568,
                            48.91609650409271,
                            2.516443536539131,
                            48.92192614328582,
                        ),
                        "coordinates": [
                            [2.515061446192154, 48.91609650409271],
                            [2.514786506793893, 48.91694636095778],
                            [2.514740213707818, 48.91712488455638],
                            [2.514686894357189, 48.9173581444992],
                            [2.514644499075632, 48.91761756124888],
                            [2.514620088132031, 48.91785791214176],
                            [2.514613744110568, 48.918102996280666],
                            [2.514618315540905, 48.91837185677805],
                            [2.514640938729763, 48.918640688718014],
                            [2.514666952844916, 48.91884765259214],
                            [2.514718346213276, 48.91908550809684],
                            [2.514769640574127, 48.91929481257573],
                            [2.51483902281828, 48.91951360396429],
                            [2.514919234965931, 48.919732380658914],
                            [2.515006635097069, 48.919941627838206],
                            [2.515093950629235, 48.920127080364644],
                            [2.515210270746824, 48.92034580141876],
                            [2.51534465996286, 48.920569250103604],
                            [2.515482607054773, 48.9207784188352],
                            [2.515613279952619, 48.92097094366411],
                            [2.515772859697456, 48.92117055909289],
                            [2.515975912602574, 48.92141055691074],
                            [2.516443536539131, 48.92192614328582],
                        ],
                    },
                },
                106: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T4",
                        "rer": 0,
                        "extcode": "800:T4",
                        "geo_point_2d": [48.89980621144714, 2.5090421101655718],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01843",
                        "navette": 0,
                        "idrefliga": "A01761",
                        "shape_leng": 705.703383802,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.506408247006797,
                            48.89714381938228,
                            2.51169930327069,
                            48.902444190569966,
                        ),
                        "coordinates": [
                            [2.506408247006797, 48.89714381938228],
                            [2.507773417232102, 48.89850039620572],
                            [2.508334785347305, 48.89907773770559],
                            [2.508787509898089, 48.8995434120482],
                            [2.509830670785831, 48.90063158316465],
                            [2.510189222048285, 48.900992701644164],
                            [2.510395662200781, 48.90119939232473],
                            [2.510841156110496, 48.90165079415016],
                            [2.511116347438255, 48.90190734538039],
                            [2.51169930327069, 48.902444190569966],
                        ],
                    },
                },
                107: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T4",
                        "rer": 0,
                        "extcode": "800:T4",
                        "geo_point_2d": [48.89354688729754, 2.484127164949328],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01843",
                        "navette": 0,
                        "idrefliga": "A01761",
                        "shape_leng": 565.011859229,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.480348871695586,
                            48.893094628632376,
                            2.487910986261173,
                            48.89404828420717,
                        ),
                        "coordinates": [
                            [2.480348871695586, 48.89404828420717],
                            [2.4836949740937, 48.89356578082677],
                            [2.484189125106957, 48.893493764010046],
                            [2.484488514781544, 48.89345530730381],
                            [2.484791542810352, 48.89342636311626],
                            [2.485148688840417, 48.89339496820445],
                            [2.48562492116048, 48.89336579789121],
                            [2.485953220372634, 48.89334157637053],
                            [2.486256259975347, 48.89331738767819],
                            [2.486562877903646, 48.89328367547997],
                            [2.486880307537121, 48.89324518852307],
                            [2.48716164566722, 48.89320437163583],
                            [2.487910986261173, 48.893094628632376],
                        ],
                    },
                },
                108: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T2",
                        "rer": 0,
                        "extcode": "100112012:T2",
                        "geo_point_2d": [48.832532427607816, 2.2790915346706897],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01390",
                        "navette": 0,
                        "idrefliga": "A01192",
                        "shape_leng": 395.751175346,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.276712090531075,
                            48.831696593107,
                            2.281470444083868,
                            48.833365343840185,
                        ),
                        "coordinates": [
                            [2.281470444083868, 48.831696593107],
                            [2.28099868136585, 48.83186746926793],
                            [2.280731882060706, 48.83195775363572],
                            [2.280461485830581, 48.83204089719003],
                            [2.280158626569133, 48.83214543881969],
                            [2.278153912295457, 48.83287964041308],
                            [2.278044468341895, 48.83292088723591],
                            [2.277941181806217, 48.83295329067679],
                            [2.277786158129075, 48.83299365860412],
                            [2.277638342225036, 48.833034030290044],
                            [2.277468883965455, 48.83308866738981],
                            [2.276712090531075, 48.833365343840185],
                        ],
                    },
                },
                109: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.83261495987958, 1.8955039383782115],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 5629.25943636,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.877504204313639,
                            48.81532862049073,
                            1.924597779359982,
                            48.838772335396015,
                        ),
                        "coordinates": [
                            [1.877504204313639, 48.81532862049073],
                            [1.87787100730415, 48.815726383929736],
                            [1.878421569306398, 48.81634995032969],
                            [1.878651511889975, 48.81663394610838],
                            [1.878892811372323, 48.816964396163435],
                            [1.879045935011556, 48.81719433005968],
                            [1.879158588822934, 48.81738273390282],
                            [1.879423676068235, 48.81787660767603],
                            [1.879615417570198, 48.818350404056055],
                            [1.879892246605241, 48.819197745440434],
                            [1.879938148944577, 48.81938947853934],
                            [1.879965176819042, 48.81956045197007],
                            [1.880008917410456, 48.81983940690308],
                            [1.88004016075747, 48.82029277485367],
                            [1.880044694493354, 48.82113363025723],
                            [1.880036352548925, 48.82189349764664],
                            [1.880020603068876, 48.823311616623634],
                            [1.880015945084784, 48.82381879844969],
                            [1.879999803881867, 48.825427565803096],
                            [1.879999864901178, 48.82616228701768],
                            [1.880006738413766, 48.82645188606749],
                            [1.880001846728486, 48.827132630097005],
                            [1.880002498239201, 48.82720997142658],
                            [1.880003472730375, 48.827252242307544],
                            [1.879990284389749, 48.82794644194013],
                            [1.879981500397308, 48.82905073693857],
                            [1.879977733132066, 48.82960918141672],
                            [1.879977691009625, 48.829613678187904],
                            [1.879984030070301, 48.830702744579845],
                            [1.879995329268325, 48.83095549099647],
                            [1.880053524906276, 48.83144134152736],
                            [1.880133127308516, 48.83182116132579],
                            [1.880251927889158, 48.83223441101881],
                            [1.880291684347071, 48.832355074927676],
                            [1.880408547314741, 48.83268288448552],
                            [1.8805741008108, 48.833048658502804],
                            [1.880679738710653, 48.8332640119926],
                            [1.880952058988127, 48.833722839251514],
                            [1.881227684535757, 48.834118729329596],
                            [1.881441733725005, 48.83439656471265],
                            [1.881496989898135, 48.83446153455297],
                            [1.881544189790246, 48.83451388199198],
                            [1.881677711340868, 48.83466009957169],
                            [1.881923178747562, 48.83492906699741],
                            [1.882334990421441, 48.8353308922992],
                            [1.882627024932562, 48.83557306481658],
                            [1.883082710867936, 48.83594538571947],
                            [1.88341973156075, 48.83618503775586],
                            [1.883777230103803, 48.836420273005004],
                            [1.884134894807137, 48.836637522818314],
                            [1.884477808558082, 48.83682953182274],
                            [1.88490493763266, 48.83704885262108],
                            [1.88572449313217, 48.8374100124786],
                            [1.886046175416951, 48.83754078213053],
                            [1.886401932152393, 48.83766988579632],
                            [1.886893618010836, 48.83783279821918],
                            [1.887547118482255, 48.838029619927084],
                            [1.888210419085543, 48.83819769891052],
                            [1.888535356133755, 48.83827091884642],
                            [1.888884848174625, 48.83834063697214],
                            [1.889182713369399, 48.83839486413132],
                            [1.889477925939689, 48.83844098638236],
                            [1.890033102632028, 48.838514205256836],
                            [1.890887882379865, 48.83860028341749],
                            [1.891330354785899, 48.83863258685505],
                            [1.892768106915908, 48.83873171662893],
                            [1.892838907306756, 48.838736488650476],
                            [1.893333229945059, 48.83875999331609],
                            [1.893732288561841, 48.838772335396015],
                            [1.89415463429514, 48.8387703774405],
                            [1.894882263335759, 48.83875521118525],
                            [1.895224377263014, 48.838736751164426],
                            [1.895618354691325, 48.83870769892675],
                            [1.896036956033603, 48.838667049742455],
                            [1.896793931650778, 48.838568351558564],
                            [1.897171852980187, 48.83850595831437],
                            [1.897749136141255, 48.83839127300515],
                            [1.898240552772194, 48.83828075165187],
                            [1.898867285886277, 48.838119487402],
                            [1.899525726677632, 48.83791517559326],
                            [1.900101056534674, 48.83771144148132],
                            [1.900185809989112, 48.83767849153344],
                            [1.900254160578375, 48.837651774820735],
                            [1.90076001010163, 48.83744777195684],
                            [1.903020266980627, 48.836491449216375],
                            [1.90397433275486, 48.836125464964276],
                            [1.904485326453057, 48.83595294004234],
                            [1.904934782873284, 48.8358071587669],
                            [1.905422385419095, 48.835660620413584],
                            [1.905845727401256, 48.83554081585114],
                            [1.906729122566696, 48.83530853623562],
                            [1.907112667134727, 48.8352218507903],
                            [1.907853722425754, 48.83506546517961],
                            [1.908331301721591, 48.83497373333898],
                            [1.909118439662935, 48.834843591991586],
                            [1.909784036358162, 48.8347480628073],
                            [1.910405830827939, 48.8346766465092],
                            [1.910780743796137, 48.83464207599627],
                            [1.912754655367173, 48.834479464807124],
                            [1.913557538872308, 48.834417697473214],
                            [1.913826074508072, 48.83439711031479],
                            [1.915055662538173, 48.83429644507696],
                            [1.915648648571893, 48.834247376976585],
                            [1.915925378505783, 48.834224117065666],
                            [1.917360778064037, 48.8341088987831],
                            [1.917585712659889, 48.834089041797846],
                            [1.918688504735731, 48.83399956330741],
                            [1.919424625782274, 48.83393750925741],
                            [1.920967741035089, 48.83380825183372],
                            [1.921056342265891, 48.83380137996571],
                            [1.921894688151168, 48.83373158943451],
                            [1.923240103035626, 48.83362226587428],
                            [1.924597779359982, 48.833512070590515],
                        ],
                    },
                },
                110: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.7618874502046, 2.506610957193139],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 2271.50278665,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.504559838342837,
                            48.752185720788724,
                            2.507811246902368,
                            48.77170790696431,
                        ),
                        "coordinates": [
                            [2.507482645714313, 48.77170790696431],
                            [2.507530787502072, 48.771051137643774],
                            [2.507575019194044, 48.770613698309866],
                            [2.507589224547753, 48.770392455958934],
                            [2.507574752546502, 48.770139780687096],
                            [2.507550757374261, 48.76988712006307],
                            [2.507506430534911, 48.769656072867065],
                            [2.507432013666611, 48.76937830770552],
                            [2.507330439336359, 48.76911497205392],
                            [2.50722346037568, 48.76886243563733],
                            [2.507083811860147, 48.76860365277777],
                            [2.506855347168026, 48.7682307943893],
                            [2.506565626102118, 48.76784543694536],
                            [2.50624182151027, 48.76743674829111],
                            [2.505994466577197, 48.767106181841314],
                            [2.505863226677005, 48.76691662979885],
                            [2.505720982448366, 48.76669112219029],
                            [2.505661802962114, 48.766578385350996],
                            [2.505596338910067, 48.766440409286524],
                            [2.50555243559284, 48.76633076211139],
                            [2.505478252088972, 48.766116844994755],
                            [2.505418401920174, 48.76591490972972],
                            [2.505377948454334, 48.76566038161464],
                            [2.505375234171927, 48.7654227558511],
                            [2.505378666905266, 48.76523120535594],
                            [2.505401167454085, 48.76504682025084],
                            [2.505443993996173, 48.764839024843255],
                            [2.505480285518237, 48.764710374849585],
                            [2.505561178773942, 48.764496226997565],
                            [2.505626006195953, 48.76435854173047],
                            [2.505721967314257, 48.76417584645876],
                            [2.505901876289787, 48.76387881881513],
                            [2.506533993777897, 48.76295881991824],
                            [2.507061862090788, 48.762189151936255],
                            [2.507262111543242, 48.76187770268923],
                            [2.50733375059555, 48.76174540212374],
                            [2.507416169268052, 48.76158340953246],
                            [2.507494413708713, 48.76139444420694],
                            [2.507582029003717, 48.761161401162035],
                            [2.507665499214359, 48.7609103778139],
                            [2.507720445871089, 48.760671088379134],
                            [2.507757780899108, 48.76045250816767],
                            [2.50778284615865, 48.76022585275563],
                            [2.507811246902368, 48.75978246722647],
                            [2.507800588874619, 48.75945154989539],
                            [2.507788745730873, 48.75917189339321],
                            [2.507764829916254, 48.758940815795555],
                            [2.507732721231531, 48.75870075698282],
                            [2.507699393243959, 48.75850116772497],
                            [2.507659167456201, 48.758273711242374],
                            [2.507597698565905, 48.75803605677067],
                            [2.507522864732568, 48.757792803097104],
                            [2.507436381948397, 48.75756092027852],
                            [2.507291076517386, 48.75723020413544],
                            [2.507106196364434, 48.75685997935367],
                            [2.506883115016229, 48.75645473947403],
                            [2.506669586179318, 48.756057578383974],
                            [2.506397244478356, 48.75556248331012],
                            [2.506118081080678, 48.7550593039698],
                            [2.505863454974878, 48.75457137599365],
                            [2.505766325086295, 48.75440425490308],
                            [2.505629434486417, 48.75414276835828],
                            [2.505276331913783, 48.75348771979618],
                            [2.50487542148979, 48.75276799206569],
                            [2.504559838342837, 48.752185720788724],
                        ],
                    },
                },
                111: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.80518233330807, 1.8484705402272763],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 5040.70247754,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.816466794198607,
                            48.80227950685127,
                            1.877504204313639,
                            48.81532862049073,
                        ),
                        "coordinates": [
                            [1.816466794198607, 48.802601980906694],
                            [1.817032818079235, 48.8025335043232],
                            [1.817823666604824, 48.80245720189971],
                            [1.818624898789292, 48.80238530353169],
                            [1.819086762327612, 48.802350530441245],
                            [1.82000609534681, 48.802310634074026],
                            [1.820074188137612, 48.80230824451127],
                            [1.820718350384725, 48.802285081362],
                            [1.821076445753394, 48.80227950685127],
                            [1.821441263605794, 48.80228205495915],
                            [1.821821056380993, 48.80228467041143],
                            [1.822483914054006, 48.80229665411869],
                            [1.82320791904584, 48.802319701459034],
                            [1.823538491128812, 48.802342771761175],
                            [1.823837892918126, 48.80235221246174],
                            [1.824964241420545, 48.802435511383095],
                            [1.826055303175848, 48.802508748765874],
                            [1.826271593266374, 48.80252500527546],
                            [1.827893059945599, 48.80265005864113],
                            [1.82922479761647, 48.80275221770809],
                            [1.829450618797667, 48.80276851053067],
                            [1.829554004320367, 48.8027761645971],
                            [1.830159347084805, 48.80282202154411],
                            [1.834557352977546, 48.80314993013397],
                            [1.837705248178437, 48.80338317567262],
                            [1.838303817284695, 48.80342716060231],
                            [1.838737783527716, 48.80345873373858],
                            [1.839736298611609, 48.8035332339526],
                            [1.842137252339903, 48.803724430707796],
                            [1.843440591975587, 48.8038128103879],
                            [1.844704414875316, 48.80390550164154],
                            [1.846983025185839, 48.80408167887678],
                            [1.849335182132726, 48.804256325846175],
                            [1.851690079303359, 48.80443093648833],
                            [1.854043639604491, 48.80460459368391],
                            [1.85577003475879, 48.8047332918976],
                            [1.857218832070746, 48.804849106204976],
                            [1.857331747852899, 48.80485767455522],
                            [1.858980623305471, 48.804979703596494],
                            [1.859498935581443, 48.805020542924616],
                            [1.859677163506899, 48.80503298013552],
                            [1.860264906717973, 48.805074106096555],
                            [1.861847217251214, 48.80518232598419],
                            [1.862328750917853, 48.80522569814248],
                            [1.86288904744771, 48.80529007787644],
                            [1.863170546078489, 48.80532362203207],
                            [1.863779642244063, 48.80541068270712],
                            [1.864069155035706, 48.805460445227745],
                            [1.864676620353485, 48.8055762719471],
                            [1.865268950380655, 48.80570911975499],
                            [1.865745581680614, 48.80583968759697],
                            [1.866440712724201, 48.806043997862496],
                            [1.867223772337531, 48.806308917685236],
                            [1.867496424041834, 48.80641525673903],
                            [1.868103904531152, 48.806675851831734],
                            [1.868525453291286, 48.8068745276079],
                            [1.868965887020769, 48.80709216469365],
                            [1.869272024340581, 48.80725799047664],
                            [1.86952657099664, 48.80740831568767],
                            [1.870157316082131, 48.807803888443935],
                            [1.870390018599309, 48.80796131687527],
                            [1.870742814372329, 48.808234344494004],
                            [1.871063301534588, 48.80846857023127],
                            [1.871374024220767, 48.80872793515015],
                            [1.871726326190471, 48.80905491568096],
                            [1.872075690908933, 48.809405263831835],
                            [1.872427532637042, 48.80978260058982],
                            [1.873296930715759, 48.81072769521586],
                            [1.874195865176207, 48.81172146349909],
                            [1.874594691971299, 48.81217452445748],
                            [1.874635138465118, 48.812217853840444],
                            [1.874678265947965, 48.812265691291785],
                            [1.875186346180608, 48.81283160391503],
                            [1.875763471882011, 48.8134418584178],
                            [1.876287841852475, 48.814015925602206],
                            [1.876341781856911, 48.814072799075454],
                            [1.876411886775733, 48.81414862286476],
                            [1.876564270028339, 48.814309310792474],
                            [1.877504204313639, 48.81532862049073],
                        ],
                    },
                },
                112: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.81262364872032, 2.4666046520617333],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1863.26833208,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.463640702639653,
                            48.80620002476371,
                            2.472720403802171,
                            48.82103881506317,
                        ),
                        "coordinates": [
                            [2.463856795362316, 48.82103881506317],
                            [2.463842035253322, 48.820991686635246],
                            [2.463774544495059, 48.82069320223674],
                            [2.46371376667862, 48.82035694097439],
                            [2.4636913914199, 48.82012675096497],
                            [2.463668764501629, 48.819797640631904],
                            [2.463644562959298, 48.81938489956624],
                            [2.463640702639653, 48.81893796283143],
                            [2.4636522061659, 48.8186548165587],
                            [2.463684708528003, 48.818036838970386],
                            [2.463723215995494, 48.817651006266345],
                            [2.463869367561328, 48.81675696240219],
                            [2.463929966726621, 48.816490708287986],
                            [2.464070438320374, 48.815919694925185],
                            [2.464199055775851, 48.815518234780704],
                            [2.464401440208634, 48.8150198644123],
                            [2.464475950473105, 48.81487050078451],
                            [2.464611446754479, 48.81460865911553],
                            [2.464882493231197, 48.814107457988214],
                            [2.465182081347027, 48.81358823791181],
                            [2.465371881872123, 48.81326698148805],
                            [2.465640310511219, 48.812812543885805],
                            [2.465923578510521, 48.812306829071694],
                            [2.466194683006095, 48.811837998305734],
                            [2.466445454401813, 48.81140606022196],
                            [2.466751822147863, 48.810888627245944],
                            [2.466858881292646, 48.81069516010546],
                            [2.467060835373302, 48.81034331264128],
                            [2.467119127720184, 48.81024612391507],
                            [2.467262731322083, 48.810024882697356],
                            [2.467393106990122, 48.80984383314322],
                            [2.467489445339136, 48.809717824007734],
                            [2.467596423333249, 48.80957715371977],
                            [2.467726940726905, 48.80942348777076],
                            [2.467884421904365, 48.80924974611803],
                            [2.46804869162419, 48.80906970191179],
                            [2.46822384271856, 48.80888604718312],
                            [2.46836103329865, 48.80876358714535],
                            [2.468491402111727, 48.808636638384655],
                            [2.46864898177488, 48.808502464282505],
                            [2.469060623737829, 48.808165656843634],
                            [2.469657190803659, 48.80774230263048],
                            [2.470051330131114, 48.80748374911306],
                            [2.470259304277273, 48.80736030543941],
                            [2.470729922629629, 48.80708311516568],
                            [2.471166050842005, 48.806857442559405],
                            [2.471894883210954, 48.806522049356815],
                            [2.472249827083262, 48.806376844148005],
                            [2.472720403802171, 48.80620002476371],
                        ],
                    },
                },
                113: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.902023492912264, 2.2589282740598504],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1827.03317568,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.247942846959712,
                            48.89811887571271,
                            2.269964779194514,
                            48.90576265710707,
                        ),
                        "coordinates": [
                            [2.269964779194514, 48.90576265710707],
                            [2.269170966677327, 48.905578188978794],
                            [2.26852152180131, 48.90540331885525],
                            [2.267929858450347, 48.90520944496078],
                            [2.267535462518766, 48.90504741171076],
                            [2.267150708747172, 48.904875866452095],
                            [2.266905432119463, 48.90476468079431],
                            [2.266640924246886, 48.90464079357891],
                            [2.266174398266635, 48.90444698712153],
                            [2.265499573356789, 48.90421207879283],
                            [2.264172004326552, 48.903773445984726],
                            [2.262635234622845, 48.90326328327007],
                            [2.261210320411657, 48.902791240913956],
                            [2.259210162614818, 48.9021085609344],
                            [2.258221457490604, 48.90177507346837],
                            [2.257632812606457, 48.9015765185643],
                            [2.257065954621635, 48.90138530843066],
                            [2.256571907473751, 48.901218653919045],
                            [2.256125676885577, 48.90107109020327],
                            [2.25534040722679, 48.90081603890312],
                            [2.252259406365097, 48.899805716981895],
                            [2.251159323258396, 48.89941641147634],
                            [2.251027094334288, 48.89937044922859],
                            [2.250882602014157, 48.8993181831883],
                            [2.25069585218518, 48.89925059696528],
                            [2.249880770168008, 48.89891544975923],
                            [2.249146138678088, 48.898601042413055],
                            [2.247942846959712, 48.89811887571271],
                        ],
                    },
                },
                114: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.82194275596548, 2.3842004486949167],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2081.76727457,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.376695892125261,
                            48.813989052009454,
                            2.391686971662538,
                            48.82987504460341,
                        ),
                        "coordinates": [
                            [2.391686971662538, 48.813989052009454],
                            [2.391644736066674, 48.81403367489162],
                            [2.391256089487555, 48.814445486936805],
                            [2.390734284057633, 48.81499536125855],
                            [2.390298842776883, 48.81545953803256],
                            [2.389615060350911, 48.816173659556846],
                            [2.388902483060373, 48.81693537502156],
                            [2.387675212460237, 48.818242186449375],
                            [2.386429870754618, 48.81955851019719],
                            [2.384853298547533, 48.821222344253066],
                            [2.383431420318824, 48.822726677377766],
                            [2.382729474191612, 48.823497868782205],
                            [2.382412726451002, 48.82388344932435],
                            [2.38204555869107, 48.82430711771084],
                            [2.381713885426457, 48.82464175224206],
                            [2.381462328800976, 48.824904562472305],
                            [2.381174280815445, 48.82516640174247],
                            [2.38100145262221, 48.825325884515536],
                            [2.380241787770921, 48.826111359755714],
                            [2.379957379772388, 48.826432677685865],
                            [2.379118555179876, 48.82740138296538],
                            [2.378513688223332, 48.82806544209967],
                            [2.376695892125261, 48.82987504460341],
                        ],
                    },
                },
                115: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.90170806059854, 2.2905108199356654],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1352.62497118,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.283517328323657,
                            48.89763744791706,
                            2.297419948146663,
                            48.90562211913642,
                        ),
                        "coordinates": [
                            [2.297419948146663, 48.89763744791706],
                            [2.297395280401841, 48.897650756172794],
                            [2.296393968719668, 48.89823136374865],
                            [2.295318006130621, 48.89886388299613],
                            [2.294724849962381, 48.899224388455764],
                            [2.294311359645943, 48.89946780578177],
                            [2.293698791446777, 48.89984879511778],
                            [2.292359132250744, 48.900671534563216],
                            [2.29167304108838, 48.90108765149402],
                            [2.290109474898639, 48.90199355263667],
                            [2.289546150383618, 48.902313343551604],
                            [2.289069498124001, 48.9025713045086],
                            [2.288661449960847, 48.90279241218691],
                            [2.286371892257679, 48.90413788792124],
                            [2.285796569144198, 48.90446606543778],
                            [2.285020552053906, 48.90491105086764],
                            [2.283921380883971, 48.90545270809693],
                            [2.283517328323657, 48.90562211913642],
                        ],
                    },
                },
                116: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.89835131453269, 2.205293816282843],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1622.41359122,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.195363986912902,
                            48.89512589133458,
                            2.215232347269524,
                            48.9015496742534,
                        ),
                        "coordinates": [
                            [2.215232347269524, 48.9015496742534],
                            [2.212174295892574, 48.90056448333464],
                            [2.211305634022634, 48.90029358157169],
                            [2.209260726163626, 48.899655817526394],
                            [2.20834896021813, 48.89936433027229],
                            [2.206397403793262, 48.89872183628752],
                            [2.204685711106618, 48.89817041353144],
                            [2.204084883528737, 48.89796802739981],
                            [2.20318259669091, 48.89767316529355],
                            [2.202821465831462, 48.89755583706814],
                            [2.200533461798464, 48.896803135755704],
                            [2.19766910100393, 48.895870725863396],
                            [2.196726132172626, 48.895569212869844],
                            [2.196439975386387, 48.89547713466982],
                            [2.195799552115966, 48.89526411597628],
                            [2.195363986912902, 48.89512589133458],
                        ],
                    },
                },
                117: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.732707983110366, 1.9055149546534647],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 3310.55653413,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.890004563697985,
                            48.72191596105865,
                            1.921036600039739,
                            48.74348398592533,
                        ),
                        "coordinates": [
                            [1.890004563697985, 48.72191596105865],
                            [1.890034431822112, 48.721936895367286],
                            [1.890266086137454, 48.72209856823183],
                            [1.891620949749069, 48.7230355335236],
                            [1.891785688193822, 48.7231566818875],
                            [1.892501621874721, 48.72365408454952],
                            [1.895511355051447, 48.725750332141075],
                            [1.896271931016806, 48.726280257723445],
                            [1.89783355362877, 48.72738071825863],
                            [1.898844173125484, 48.72807885787199],
                            [1.899652182529723, 48.72863322465181],
                            [1.900023645844506, 48.728901737789634],
                            [1.901184246010784, 48.729711044894486],
                            [1.902651551611075, 48.73074003762751],
                            [1.904708292188821, 48.73215344622749],
                            [1.905902813171118, 48.73298801416836],
                            [1.907447505811745, 48.73405140925048],
                            [1.908213712840531, 48.734588471514456],
                            [1.908504326461507, 48.73478381104041],
                            [1.90872465011916, 48.73493212253206],
                            [1.90884495574657, 48.73501261159476],
                            [1.910870763410868, 48.73642758928511],
                            [1.912002200183204, 48.73721797359011],
                            [1.914187243962756, 48.738732242570805],
                            [1.91661919159956, 48.74041869378139],
                            [1.91779942111266, 48.74124154398555],
                            [1.919580594358542, 48.742480594453625],
                            [1.921036600039739, 48.74348398592533],
                        ],
                    },
                },
                118: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M4",
                        "rer": 0,
                        "extcode": "100110004:4",
                        "geo_point_2d": [48.88939586598889, 2.349724777482816],
                        "indice_lig": "4",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01374",
                        "navette": 0,
                        "idrefliga": "A01537",
                        "shape_leng": 449.480782327,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.349694082213971,
                            48.88737490965435,
                            2.349742536008521,
                            48.89141683421295,
                        ),
                        "coordinates": [
                            [2.349694082213971, 48.88737490965435],
                            [2.349731931153697, 48.88941178530525],
                            [2.349735137319289, 48.89007848178429],
                            [2.349737900413805, 48.8906531116933],
                            [2.349741043696849, 48.89130661760289],
                            [2.349742536008521, 48.89135158826425],
                            [2.349738407022142, 48.89141683421295],
                        ],
                    },
                },
                119: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.817893599066835, 1.734002721117619],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 4912.05823832,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.703218425476859,
                            48.810402464358575,
                            1.765056756557643,
                            48.82657842806816,
                        ),
                        "coordinates": [
                            [1.703218425476859, 48.82657842806816],
                            [1.703834706081143, 48.82646491843838],
                            [1.704440868864696, 48.826353168721774],
                            [1.705059332238571, 48.826237886526634],
                            [1.705386982651539, 48.82617764765288],
                            [1.705975387351061, 48.82606938935608],
                            [1.706640251963787, 48.82594626129542],
                            [1.7068696017519, 48.82590436112266],
                            [1.707990364636365, 48.82570280394646],
                            [1.708435472943173, 48.8256162256746],
                            [1.708836863898313, 48.82554019578124],
                            [1.709611040257465, 48.825387975302824],
                            [1.710195613521477, 48.82525809031064],
                            [1.710804866956573, 48.825114847945656],
                            [1.711348633248916, 48.82498023683586],
                            [1.712008744744395, 48.824799497119244],
                            [1.712223352927734, 48.824737720647825],
                            [1.712816613266964, 48.82456560288375],
                            [1.713334762327082, 48.82440925836364],
                            [1.713593239341642, 48.82432433778815],
                            [1.713657530608635, 48.82430220636175],
                            [1.713760098814089, 48.82426859299619],
                            [1.713947476039934, 48.82420576497837],
                            [1.714273009634636, 48.82409512880752],
                            [1.714821504639136, 48.82390746813572],
                            [1.715179820401797, 48.82378891484546],
                            [1.716881164567938, 48.823221719061586],
                            [1.71780841570151, 48.82291199699557],
                            [1.720304265419156, 48.822079267838525],
                            [1.721752435411251, 48.82160146069737],
                            [1.724410791146531, 48.82072185532163],
                            [1.725454163075655, 48.820374924638415],
                            [1.72645474936757, 48.82003775341909],
                            [1.72848322513523, 48.819349724692636],
                            [1.730612228450318, 48.818641615831204],
                            [1.732366338047564, 48.818073571818424],
                            [1.734643164394577, 48.81729422681533],
                            [1.735079370350868, 48.81714544641768],
                            [1.736558681682944, 48.816658623749824],
                            [1.737761912325528, 48.81625306855582],
                            [1.738329338511924, 48.81606179818051],
                            [1.738490705957064, 48.816005089491334],
                            [1.738671179311696, 48.81594488264169],
                            [1.739734851702543, 48.81559163425183],
                            [1.740027429514338, 48.81549424200263],
                            [1.740255687190121, 48.81542349177832],
                            [1.740618018259811, 48.81530038328331],
                            [1.741312646775495, 48.81506030140504],
                            [1.742156178047613, 48.81477962323151],
                            [1.742314739589809, 48.814729189653775],
                            [1.743851501127592, 48.814208398571],
                            [1.744212454851976, 48.81408527195248],
                            [1.74450643005247, 48.81398337892803],
                            [1.745094854012801, 48.81378116166545],
                            [1.745879825709287, 48.81355234643284],
                            [1.746817159311929, 48.813298395575416],
                            [1.747076583180959, 48.81323858451115],
                            [1.74821493818605, 48.81299425430823],
                            [1.748713261864647, 48.812896306543024],
                            [1.749087106460449, 48.81283258510359],
                            [1.750412987050746, 48.812632569203565],
                            [1.751530464204398, 48.81246657956357],
                            [1.752381300567321, 48.812337807300985],
                            [1.753630824029237, 48.81214455770408],
                            [1.754761671860952, 48.81196867441502],
                            [1.75503449631644, 48.81192600100822],
                            [1.755771042534285, 48.811817341766975],
                            [1.757926093173865, 48.811500054108166],
                            [1.759934009884037, 48.811187377382815],
                            [1.762259726740296, 48.81082500715827],
                            [1.765056756557643, 48.810402464358575],
                        ],
                    },
                },
                120: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.89048056005887, 2.306484293549573],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1651.83719007,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.29803330457685,
                            48.8854042809258,
                            2.315599220546768,
                            48.89416838621195,
                        ),
                        "coordinates": [
                            [2.29803330457685, 48.8854042809258],
                            [2.298278490321922, 48.88553700998297],
                            [2.298906871348438, 48.88585916014498],
                            [2.299499868875073, 48.886148678935285],
                            [2.300053263238162, 48.88642068160199],
                            [2.30046489801403, 48.88667170934397],
                            [2.300749769168129, 48.88684985547936],
                            [2.300974643437413, 48.88702708226512],
                            [2.301222672411993, 48.887244784124306],
                            [2.301435259014266, 48.88744718606856],
                            [2.301642390401899, 48.887653183671574],
                            [2.301771845610144, 48.88778541630017],
                            [2.301920375347839, 48.88794193488141],
                            [2.302006222792398, 48.888033687716785],
                            [2.302152025498302, 48.88819200401933],
                            [2.302191545922343, 48.88823068431048],
                            [2.302547201014362, 48.88861657975514],
                            [2.302833392748343, 48.88888554701571],
                            [2.303070541528806, 48.889087054457136],
                            [2.30340311755293, 48.889338049078965],
                            [2.303997437406768, 48.889732101675726],
                            [2.304166463946563, 48.88984635719162],
                            [2.304372305938201, 48.889970515700675],
                            [2.304586338694636, 48.890085682254366],
                            [2.304747208226468, 48.89016396405495],
                            [2.305946269516834, 48.89072521915211],
                            [2.307533920375972, 48.891474947649236],
                            [2.307772512865817, 48.89159011449711],
                            [2.30828378788212, 48.89183934154016],
                            [2.308815518190312, 48.892097563435854],
                            [2.31036847368245, 48.892857815797825],
                            [2.310843384229622, 48.893055150412785],
                            [2.31128651457019, 48.89322605440771],
                            [2.311762761774658, 48.89336415981205],
                            [2.31237612386189, 48.893521326783755],
                            [2.312827131249224, 48.8936284909725],
                            [2.313220417438781, 48.89371184914755],
                            [2.313537935800478, 48.89377377517818],
                            [2.315518841217685, 48.8941524701219],
                            [2.315599220546768, 48.89416838621195],
                        ],
                    },
                },
                121: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.83976410057666, 2.4687547126700164],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1263.28828138,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.463708038038903,
                            48.83428889889614,
                            2.471751013746376,
                            48.84372026160052,
                        ),
                        "coordinates": [
                            [2.463708038038903, 48.84372026160052],
                            [2.464072714949626, 48.84359026307213],
                            [2.464223807167134, 48.84353523846805],
                            [2.464845785868624, 48.843275550074615],
                            [2.4648675546364, 48.843263835359316],
                            [2.465138363632208, 48.84313943029574],
                            [2.465278511748215, 48.84306823002769],
                            [2.465678552381045, 48.84286723954678],
                            [2.466205052588956, 48.84257257966302],
                            [2.466784488607378, 48.842204115934166],
                            [2.467223732831621, 48.841890666220934],
                            [2.467456233548691, 48.84171054473043],
                            [2.467727971745666, 48.84149215089406],
                            [2.468066596599805, 48.84119455817351],
                            [2.468281316900039, 48.840990174101606],
                            [2.468807131305007, 48.84045000085818],
                            [2.468986417035168, 48.8402438581054],
                            [2.469312476241462, 48.8399017543085],
                            [2.469489056992771, 48.8397037082008],
                            [2.469711871023516, 48.83947413302528],
                            [2.469902017309917, 48.83925628592139],
                            [2.470044668296358, 48.83910863769832],
                            [2.47030952379091, 48.83880976785207],
                            [2.470472459133075, 48.83860634001926],
                            [2.470891883807731, 48.83803660497335],
                            [2.471076340311951, 48.837733331325275],
                            [2.471245622982843, 48.837387600873775],
                            [2.471478443430251, 48.83687308883418],
                            [2.471598766123802, 48.83646833052923],
                            [2.47168497477152, 48.83610761842296],
                            [2.471711732204699, 48.83592773107126],
                            [2.471734441754037, 48.835762237118345],
                            [2.471747673255242, 48.8356174377757],
                            [2.471751013746376, 48.835342255254716],
                            [2.471730865312358, 48.83494479827724],
                            [2.471713817584186, 48.83468582642015],
                            [2.471701476872501, 48.834432502579006],
                            [2.471681242571033, 48.83428889889614],
                        ],
                    },
                },
                122: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.99521691364474, 1.985369609018619],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 4276.19533509,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.963551770278395,
                            48.98107191008835,
                            2.00593089306856,
                            49.00712724722575,
                        ),
                        "coordinates": [
                            [1.963551770278395, 49.00712724722575],
                            [1.966504229714531, 49.00612001225277],
                            [1.969169283586467, 49.00520778971877],
                            [1.969883718400177, 49.00494359496062],
                            [1.970641916885702, 49.004629566626136],
                            [1.971509280064331, 49.00422308748815],
                            [1.972351546127064, 49.00378559057962],
                            [1.97309599138091, 49.003369190331846],
                            [1.976516420966801, 49.00147957052218],
                            [1.979187413352886, 48.999984667403446],
                            [1.980383619065264, 48.999297233533895],
                            [1.980934788738326, 48.99897793357045],
                            [1.981285774062346, 48.99874632270073],
                            [1.981726285418852, 48.998435041776936],
                            [1.983292072527056, 48.997320636859996],
                            [1.986599920129499, 48.994985233047736],
                            [1.992072386069761, 48.99111444955427],
                            [1.993652914913131, 48.98999709405227],
                            [1.99458126773623, 48.989290151775776],
                            [1.995384130320824, 48.98872312763308],
                            [1.997313715319048, 48.98729411462418],
                            [1.999210479069605, 48.98589067001332],
                            [2.000143506587969, 48.985208163013866],
                            [2.000780028771487, 48.9847446304471],
                            [2.001446790197096, 48.9842983147471],
                            [2.002376770537794, 48.98373712781365],
                            [2.00351809931744, 48.98303093273212],
                            [2.004326521660503, 48.98247651381918],
                            [2.004890556772752, 48.982039676661145],
                            [2.005264894718132, 48.98174096209572],
                            [2.005683193481696, 48.98135433740403],
                            [2.00593089306856, 48.98107191008835],
                        ],
                    },
                },
                123: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [49.00630891359553, 1.9105019882715242],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1292.74038421,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.901781979947734,
                            49.00576253682855,
                            1.919237111731365,
                            49.00670027774167,
                        ),
                        "coordinates": [
                            [1.901781979947734, 49.00576253682855],
                            [1.901790368381825, 49.00576423769356],
                            [1.902729160929524, 49.00594149584636],
                            [1.903689724174504, 49.00611169271597],
                            [1.904482276708446, 49.00624347054149],
                            [1.905071122249443, 49.00632183254277],
                            [1.905670966702997, 49.00638357875187],
                            [1.906216685650328, 49.00643084124695],
                            [1.906758955782845, 49.006459053606754],
                            [1.90735652766824, 49.006468617667586],
                            [1.907813070223567, 49.006471229968845],
                            [1.907968951258836, 49.00646551889662],
                            [1.908543235855356, 49.006446985609024],
                            [1.909184460914762, 49.00643319469682],
                            [1.909355365117211, 49.00642933689485],
                            [1.909875055716564, 49.006400702181246],
                            [1.910097972388945, 49.0063889434238],
                            [1.912091835759061, 49.00629114201759],
                            [1.912452856034925, 49.00627449575719],
                            [1.913312850695135, 49.00622294912462],
                            [1.913811458069127, 49.00619910650897],
                            [1.914310654289818, 49.006189054038025],
                            [1.914795242248773, 49.006195599436765],
                            [1.915366526181886, 49.00621436166403],
                            [1.915981031332432, 49.00625469322571],
                            [1.91657007856274, 49.006311583196954],
                            [1.917198748634746, 49.006387649694645],
                            [1.917812832804513, 49.00647793657892],
                            [1.918488239911505, 49.00658747973578],
                            [1.91917454426289, 49.00669229884557],
                            [1.919237111731365, 49.00670027774167],
                        ],
                    },
                },
                124: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.96326967418847, 2.623331986674454],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 3881.11035797,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.603135305118449,
                            48.9531483875826,
                            2.64240630231019,
                            48.97585875402045,
                        ),
                        "coordinates": [
                            [2.603135305118449, 48.9531483875826],
                            [2.605000289162331, 48.95358023622196],
                            [2.606667981536762, 48.953976045436235],
                            [2.60843332667294, 48.95438587455402],
                            [2.609996191861178, 48.954762848286016],
                            [2.610564286872323, 48.954918527856364],
                            [2.610987737600818, 48.95505075694514],
                            [2.611407665895066, 48.955199648801525],
                            [2.611737170967245, 48.9553297236263],
                            [2.612157252560272, 48.95550478508058],
                            [2.612526701935252, 48.95567044971302],
                            [2.612852742036049, 48.95582670175315],
                            [2.613182453497493, 48.95599245990038],
                            [2.613454237727346, 48.95613694387159],
                            [2.613813069025569, 48.9563407001603],
                            [2.614150249870269, 48.95654926678368],
                            [2.614560028989912, 48.95681714106856],
                            [2.61516573517021, 48.957229677317436],
                            [2.615546578415751, 48.957490478786184],
                            [2.615989121755064, 48.95779871768538],
                            [2.616384480709172, 48.95806899772281],
                            [2.616765337560406, 48.95832979781849],
                            [2.617204238868017, 48.95863090006522],
                            [2.618865618889549, 48.95977604693423],
                            [2.620848305052638, 48.96113672398326],
                            [2.623788406543668, 48.963147256113665],
                            [2.627376631213806, 48.96560559525237],
                            [2.629031207469668, 48.966743473580635],
                            [2.633236858467855, 48.969623578526125],
                            [2.633995347296979, 48.97014982880753],
                            [2.635112976436022, 48.970896419788794],
                            [2.636905798974081, 48.972125430531804],
                            [2.637998180871814, 48.97286611020394],
                            [2.639061483617493, 48.97357473575402],
                            [2.64030279661989, 48.974425640339135],
                            [2.64240630231019, 48.97585875402045],
                        ],
                    },
                },
                125: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [49.05021880665001, 2.022354526331116],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1835.11393662,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.010999760003633,
                            49.047876203368986,
                            2.034294461852662,
                            49.05104855336923,
                        ),
                        "coordinates": [
                            [2.010999760003633, 49.047876203368986],
                            [2.012824844986796, 49.049102920262555],
                            [2.013873905514164, 49.049764963802374],
                            [2.014241856975978, 49.04996110765006],
                            [2.014736320939224, 49.05018615781923],
                            [2.015353789518761, 49.05042344822877],
                            [2.015816177845282, 49.05057226495576],
                            [2.016285947490587, 49.05069968562204],
                            [2.016810096450205, 49.05081536046382],
                            [2.017392288051122, 49.050912158187394],
                            [2.018101285744873, 49.050992651604204],
                            [2.018770695307558, 49.05103734023598],
                            [2.019382402802194, 49.05104855336923],
                            [2.020005166842821, 49.051028862615084],
                            [2.020533875061965, 49.05099939153168],
                            [2.021033680757431, 49.05096032163714],
                            [2.023460624314959, 49.0507147734925],
                            [2.032798582030029, 49.049788186849895],
                            [2.034294461852662, 49.049647005256354],
                        ],
                    },
                },
                126: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.84144211570125, 2.563956513685172],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 2390.80566103,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.547775189299494,
                            48.840835907860786,
                            2.580085911974356,
                            48.8428848408236,
                        ),
                        "coordinates": [
                            [2.580085911974356, 48.8428848408236],
                            [2.579637084565441, 48.84284184523262],
                            [2.577914167028852, 48.84268182528889],
                            [2.575579252547477, 48.84246550708517],
                            [2.574559690564778, 48.84237051114792],
                            [2.574375677072554, 48.842352908428936],
                            [2.573993999525708, 48.84231233480048],
                            [2.573491000004915, 48.84225762233939],
                            [2.572932211184678, 48.842192795117704],
                            [2.572388964288188, 48.84211539851454],
                            [2.570772082019269, 48.84185604015062],
                            [2.569897621407743, 48.84171363920376],
                            [2.569288938958205, 48.84160977632782],
                            [2.568646755163735, 48.841505865086496],
                            [2.5679065355355, 48.84141384001755],
                            [2.566261374250111, 48.84125618544308],
                            [2.565834756551796, 48.84121657390359],
                            [2.563752675582071, 48.84101839425878],
                            [2.563164204872726, 48.840978160339496],
                            [2.562331359867017, 48.84094269018195],
                            [2.561574309897242, 48.840928479204024],
                            [2.560603182763992, 48.8409232469098],
                            [2.559177817735165, 48.84090747244781],
                            [2.557432384954917, 48.840898008653745],
                            [2.555014278335986, 48.84087981175414],
                            [2.553800907888681, 48.8408721299675],
                            [2.552907647796653, 48.84086811309447],
                            [2.551586119972329, 48.84085632982434],
                            [2.548761401539636, 48.840835907860786],
                            [2.547775189299494, 48.84084343185482],
                        ],
                    },
                },
                127: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.94009088399499, 2.550616210006712],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 2485.82994821,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.534714974742524,
                            48.93628018565177,
                            2.566448016963,
                            48.94418106597472,
                        ),
                        "coordinates": [
                            [2.534714974742524, 48.93628018565177],
                            [2.535340370734915, 48.93642662289816],
                            [2.535962129245601, 48.93656592503689],
                            [2.537332129872436, 48.93686095462459],
                            [2.537917744457916, 48.93699079325262],
                            [2.538601003272541, 48.93715138676137],
                            [2.540918322655967, 48.93769453308393],
                            [2.543683993892404, 48.938343894483246],
                            [2.544656530410048, 48.93857531034312],
                            [2.545538668164763, 48.93878071039493],
                            [2.54620751804285, 48.93893890513631],
                            [2.548626257665795, 48.93951026287049],
                            [2.549765126932029, 48.93977463943],
                            [2.550694334226996, 48.93999656709117],
                            [2.5514427700577, 48.940175997923625],
                            [2.551959857044305, 48.94031065011705],
                            [2.552824110079801, 48.94054220031732],
                            [2.554205472265827, 48.9409083884766],
                            [2.556928501227496, 48.94163602933851],
                            [2.559405672499717, 48.94229270450478],
                            [2.560599066535213, 48.94260683298388],
                            [2.561441695287231, 48.942831221353366],
                            [2.562157770590603, 48.943024923588446],
                            [2.563249943759487, 48.94331305085653],
                            [2.564117913392034, 48.94354450877578],
                            [2.564797843137347, 48.94372874544],
                            [2.566448016963, 48.94418106597472],
                        ],
                    },
                },
                128: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.94876873710224, 2.584765994787457],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 2866.56229588,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.566448016963,
                            48.94418106597472,
                            2.603135305118449,
                            48.9531483875826,
                        ),
                        "coordinates": [
                            [2.566448016963, 48.94418106597472],
                            [2.566891948596433, 48.94430274383506],
                            [2.568060084076771, 48.944602570357915],
                            [2.569195661927715, 48.944888173339194],
                            [2.569817732203788, 48.94505108464606],
                            [2.570754486773528, 48.94530138872618],
                            [2.571557405897602, 48.94551150926684],
                            [2.573604556880427, 48.94605454643058],
                            [2.576045849572909, 48.94667048694143],
                            [2.578678916716112, 48.94733831537988],
                            [2.58119625510733, 48.94796588262504],
                            [2.58410432923042, 48.94869724276722],
                            [2.585019430124057, 48.948923681494264],
                            [2.586169571382587, 48.949192430824624],
                            [2.588419224238586, 48.94971334949363],
                            [2.591652740358425, 48.95046283702698],
                            [2.592202519073878, 48.950590098723566],
                            [2.59297655268225, 48.95076920162161],
                            [2.594032738515728, 48.951016666970744],
                            [2.59547956323488, 48.95135127815666],
                            [2.596702132176895, 48.95163165419941],
                            [2.601719329292711, 48.95281697296261],
                            [2.60283348429561, 48.95307849550037],
                            [2.603135305118449, 48.9531483875826],
                        ],
                    },
                },
                129: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.78330278836103, 1.557959721404166],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 7349.53843059,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.513333052350337,
                            48.76842177662328,
                            1.602701692990599,
                            48.796318150417065,
                        ),
                        "coordinates": [
                            [1.513333052350337, 48.76842177662328],
                            [1.530235391978185, 48.77355432460681],
                            [1.548384785396549, 48.7799301986718],
                            [1.548581052360553, 48.779996308995685],
                            [1.550562845284013, 48.78065482392585],
                            [1.550985183639332, 48.780796235375085],
                            [1.552213053017217, 48.781201302830844],
                            [1.55292207986148, 48.781457996539615],
                            [1.552941015866866, 48.781465321406884],
                            [1.554481626185669, 48.781975039422214],
                            [1.55524096565038, 48.78223566042545],
                            [1.558308845210969, 48.783245928793306],
                            [1.563495662375764, 48.78496389642468],
                            [1.563781347824285, 48.78505846645894],
                            [1.56647704875338, 48.78595626675818],
                            [1.56798694158851, 48.786445807471836],
                            [1.570828906068965, 48.78740024841214],
                            [1.572135447622024, 48.787843399636664],
                            [1.572515694509206, 48.787986245521914],
                            [1.572937907797496, 48.78814376065562],
                            [1.573374818740625, 48.78831935921934],
                            [1.574083518199571, 48.78861098999951],
                            [1.574713458738051, 48.788891297403204],
                            [1.575178451031452, 48.789100350739645],
                            [1.576076172015337, 48.78949305698947],
                            [1.578127899112504, 48.7904330385426],
                            [1.580698743112527, 48.791611151214994],
                            [1.583271095586056, 48.79278741673831],
                            [1.585842223194829, 48.79396271478883],
                            [1.58638430500226, 48.79421090102901],
                            [1.586558697510138, 48.79429029063243],
                            [1.58684122951289, 48.79441985373194],
                            [1.58703862574551, 48.79450838654141],
                            [1.587586204255666, 48.79475390563928],
                            [1.58795123795239, 48.794919082250885],
                            [1.588319251915359, 48.79506718954354],
                            [1.588546651767766, 48.7951523196056],
                            [1.588852628956593, 48.79526224750694],
                            [1.589196621972004, 48.79537871850116],
                            [1.58948109556084, 48.79547051664924],
                            [1.589711491353154, 48.79553767782329],
                            [1.589851101653075, 48.79557726406157],
                            [1.590095149936224, 48.79564181687393],
                            [1.590482946172726, 48.79574238292753],
                            [1.590903463973901, 48.79583956546203],
                            [1.590978040427842, 48.79585893965311],
                            [1.591147650107343, 48.79589512347828],
                            [1.591318566381321, 48.79593491241535],
                            [1.59149364842103, 48.795969333336735],
                            [1.591721703950386, 48.79601129460757],
                            [1.591933507502587, 48.79604775323074],
                            [1.592168410282592, 48.796087059796946],
                            [1.592415617063088, 48.79612284980171],
                            [1.592707712963614, 48.79616073125764],
                            [1.593266275556596, 48.79622103534825],
                            [1.59355039323903, 48.79624627172361],
                            [1.593868527257183, 48.79627262907262],
                            [1.594186781687725, 48.796290892280346],
                            [1.594428895203967, 48.79630326235087],
                            [1.59474047827648, 48.79631248737807],
                            [1.595018101366116, 48.79631699379198],
                            [1.595316195758208, 48.79631803509326],
                            [1.59533388976602, 48.796318150417065],
                            [1.595608911590666, 48.79631454457132],
                            [1.595882640009979, 48.79630643343509],
                            [1.596157754895825, 48.79629653174077],
                            [1.596441064020632, 48.7962848834532],
                            [1.596825119805168, 48.79627209130351],
                            [1.597246045650499, 48.79625144350542],
                            [1.598700603848344, 48.79619972510762],
                            [1.599284885850794, 48.7961783301367],
                            [1.599630844288678, 48.796164381731614],
                            [1.600215216871904, 48.79613668580825],
                            [1.601238148944774, 48.79609202985972],
                            [1.601894695267072, 48.79606209055192],
                            [1.602559407145686, 48.79603220085211],
                            [1.602701692990599, 48.79602536780062],
                        ],
                    },
                },
                130: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.93056577715358, 2.018818905070078],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 3875.60340782,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.999603609660236,
                            48.92749432052858,
                            2.041072289675926,
                            48.93948681080073,
                        ),
                        "coordinates": [
                            [1.999603609660236, 48.93948681080073],
                            [1.999745478814779, 48.93880673258692],
                            [1.999860332839626, 48.938381164256135],
                            [1.999956433436328, 48.938057853551705],
                            [2.000088777529168, 48.93771561386505],
                            [2.000217299794479, 48.93740429598073],
                            [2.000367538745524, 48.93708590414306],
                            [2.00052498252498, 48.936769910372384],
                            [2.000766180951774, 48.936351852996204],
                            [2.001061921934988, 48.93587922875607],
                            [2.001258908111934, 48.93558952511411],
                            [2.001492180159692, 48.93527375240844],
                            [2.001772641436504, 48.93492242967672],
                            [2.002074845731686, 48.93455927312396],
                            [2.002369585781313, 48.93423178392727],
                            [2.002762339087557, 48.93382843904429],
                            [2.003191250370267, 48.9334180621935],
                            [2.003539951811205, 48.933119281041144],
                            [2.003928485189991, 48.93280395666924],
                            [2.004367667103087, 48.93247450241822],
                            [2.004817502139509, 48.93217125332143],
                            [2.005361478288389, 48.93183020440016],
                            [2.005858137663208, 48.93154373923018],
                            [2.006340173391652, 48.93128340488281],
                            [2.006890970120898, 48.9309994725025],
                            [2.007405446844218, 48.93074636618486],
                            [2.007945165016606, 48.93049808646754],
                            [2.008513780312058, 48.93024750997885],
                            [2.009259712665592, 48.929940332446385],
                            [2.009983778343435, 48.92966163940012],
                            [2.010790986660044, 48.929368904471005],
                            [2.011558213243689, 48.92911411977606],
                            [2.012325340075177, 48.9288736071436],
                            [2.01305972765501, 48.928668685330386],
                            [2.013830172796917, 48.92847099771639],
                            [2.014705358833772, 48.92826884327863],
                            [2.015403277938154, 48.92811614985625],
                            [2.016166128380683, 48.9279731523932],
                            [2.017178270840227, 48.927809432896616],
                            [2.01813232326213, 48.927693130038854],
                            [2.019035633850587, 48.92760522962063],
                            [2.019953220732404, 48.92754353509037],
                            [2.021011493040057, 48.927503637068874],
                            [2.021946797439078, 48.92749432052858],
                            [2.022661654665784, 48.92751294519864],
                            [2.023361994446083, 48.92754342097989],
                            [2.024062214136317, 48.927592926031316],
                            [2.024733503113487, 48.927649486895945],
                            [2.025462388942178, 48.92773475231132],
                            [2.026162359721935, 48.927824694025766],
                            [2.026894640334668, 48.92794565111718],
                            [2.027554718119948, 48.928064028457506],
                            [2.028265175235255, 48.928211090112995],
                            [2.028957480750428, 48.92837475493428],
                            [2.029682109026624, 48.928567052182764],
                            [2.030323752556166, 48.92874960735206],
                            [2.031062604959402, 48.92898000696472],
                            [2.031783243750481, 48.929236524159506],
                            [2.032417330717282, 48.92947615106812],
                            [2.033202606317243, 48.92979469453686],
                            [2.033800465418992, 48.93005563156655],
                            [2.034358695409448, 48.930302185188765],
                            [2.035133032821583, 48.93064210246535],
                            [2.03703827540336, 48.93148465053155],
                            [2.038615843263528, 48.93217879336028],
                            [2.041072289675926, 48.93326540612854],
                        ],
                    },
                },
                131: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.82949284193254, 1.9771930768514645],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 2719.75448517,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.960026560248269,
                            48.82365326874927,
                            1.992864535155556,
                            48.83095952864679,
                        ),
                        "coordinates": [
                            [1.960026560248269, 48.83095952864679],
                            [1.960935037637888, 48.8309379250036],
                            [1.962093061398932, 48.83091025970915],
                            [1.963721094929362, 48.83087243058366],
                            [1.963757878332537, 48.830871652009066],
                            [1.966582072810431, 48.83080531245419],
                            [1.969404903416691, 48.83073800049453],
                            [1.971730451228169, 48.8306843159905],
                            [1.974054625266235, 48.83063147843705],
                            [1.97455188070673, 48.8306204691827],
                            [1.976381517728135, 48.83057860283449],
                            [1.977309278389815, 48.830557249532816],
                            [1.97944692409613, 48.83049112489424],
                            [1.980105181229709, 48.83044192528568],
                            [1.980684545473023, 48.83037718861256],
                            [1.981573604029977, 48.83024326924754],
                            [1.981914547415635, 48.83018497848945],
                            [1.982507918347994, 48.83006541945888],
                            [1.982889947928216, 48.82997577732718],
                            [1.983445473163384, 48.82983171815846],
                            [1.984110075155704, 48.82963692860319],
                            [1.985080954442035, 48.829293702141804],
                            [1.985893753053863, 48.828959872761175],
                            [1.986162995461228, 48.82883030457826],
                            [1.986708414721469, 48.828553201710655],
                            [1.987065343057734, 48.828350158970814],
                            [1.987578284775649, 48.82804147726763],
                            [1.987929990763962, 48.82780514161545],
                            [1.988274960049601, 48.82755799357086],
                            [1.988536414014613, 48.8273717411227],
                            [1.988870612356766, 48.82710567358642],
                            [1.989320163455206, 48.826704164316794],
                            [1.991813433196942, 48.82443294496405],
                            [1.991988781901201, 48.82428599279434],
                            [1.992248912743041, 48.824089835255215],
                            [1.992864535155556, 48.82365326874927],
                        ],
                    },
                },
                132: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [49.07807574390078, 2.0143100562528713],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1636.96989927,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.003715373018928,
                            49.07584288482138,
                            2.024952931375388,
                            49.08049370702575,
                        ),
                        "coordinates": [
                            [2.024952931375388, 49.07584288482138],
                            [2.023876796508751, 49.0760735064212],
                            [2.022097690787036, 49.07643644322721],
                            [2.021382177249325, 49.0765864552848],
                            [2.02088872097804, 49.07668941305134],
                            [2.020829778358793, 49.07670184095788],
                            [2.019291810340124, 49.077024930744074],
                            [2.017753820460642, 49.07734799892939],
                            [2.016214442683926, 49.077671044223536],
                            [2.014134975889603, 49.07810316119402],
                            [2.013620932385088, 49.07820962686544],
                            [2.012845053373147, 49.078372006317174],
                            [2.012052723256836, 49.0785370312914],
                            [2.009970453092824, 49.078968165865255],
                            [2.006277297645017, 49.07974535050034],
                            [2.005510793293748, 49.07993266371232],
                            [2.004783856294224, 49.08013672002951],
                            [2.00394695756873, 49.080406775960846],
                            [2.003715373018928, 49.08049370702575],
                        ],
                    },
                },
                133: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.9016978943315, 2.290539692171141],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1351.92438677,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.283628702682815,
                            48.89763744791706,
                            2.297419948146663,
                            48.90570604953261,
                        ),
                        "coordinates": [
                            [2.297419948146663, 48.89763744791706],
                            [2.297395280401841, 48.897650756172794],
                            [2.296393968719668, 48.89823136374865],
                            [2.295318006130621, 48.89886388299613],
                            [2.294724849962381, 48.899224388455764],
                            [2.294311359645943, 48.89946780578177],
                            [2.293698791446777, 48.89984879511778],
                            [2.292359132250744, 48.900671534563216],
                            [2.29167304108838, 48.90108765149402],
                            [2.290109474898639, 48.90199355263667],
                            [2.289546150383618, 48.902313343551604],
                            [2.289069498124001, 48.9025713045086],
                            [2.288661449960847, 48.90279241218691],
                            [2.286371892257679, 48.90413788792124],
                            [2.285796569144198, 48.90446606543778],
                            [2.285020552053906, 48.90491105086764],
                            [2.284279755159278, 48.9053356067742],
                            [2.283628702682815, 48.90570604953261],
                        ],
                    },
                },
                134: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.962002055426225, 1.9940103249898837],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 4929.3745197,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.983143352086498,
                            48.93948681080073,
                            1.999603609660236,
                            48.98144596941029,
                        ),
                        "coordinates": [
                            [1.983143352086498, 48.98144596941029],
                            [1.985340988872836, 48.97994898514042],
                            [1.98739040784258, 48.97843485119064],
                            [1.987862935756174, 48.97806273195275],
                            [1.988441100695305, 48.977574346080175],
                            [1.988950423817492, 48.97710716156023],
                            [1.989591011343472, 48.97647619566364],
                            [1.990239311090215, 48.97577387075046],
                            [1.99074231896534, 48.97517103625501],
                            [1.991176409229675, 48.97460130023088],
                            [1.991563389677002, 48.97404807761586],
                            [1.991928790942554, 48.97347813228685],
                            [1.992269163858888, 48.97286766158834],
                            [1.992521945842703, 48.97237827467398],
                            [1.9927567681866, 48.971872175628135],
                            [1.992955248295027, 48.97139452047125],
                            [1.99311723636855, 48.97096672227368],
                            [1.993272060286449, 48.97052938315263],
                            [1.993408975130323, 48.970068197702645],
                            [1.993512786240843, 48.969690190999394],
                            [1.993628292576129, 48.969188491657484],
                            [1.993729243048589, 48.96870102540323],
                            [1.99398738330238, 48.967431218555205],
                            [1.994118454353673, 48.96676776752097],
                            [1.994286758732096, 48.96594501173718],
                            [1.994507830980454, 48.964805958086565],
                            [1.99482946101371, 48.9632317804725],
                            [1.995888335689857, 48.957959889931864],
                            [1.9992371126774, 48.94132973750179],
                            [1.999603609660236, 48.93948681080073],
                        ],
                    },
                },
                135: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.918807223348814, 2.2652069343553594],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1410.3565588,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.25934570305215,
                            48.91424647429558,
                            2.271598750389755,
                            48.923918626560365,
                        ),
                        "coordinates": [
                            [2.271598750389755, 48.91424647429558],
                            [2.270532945876196, 48.91500938112961],
                            [2.270139074361969, 48.915287536801934],
                            [2.269723507352697, 48.91559184934864],
                            [2.269235674719603, 48.91593656632342],
                            [2.268101078561584, 48.91667110755421],
                            [2.266174994851476, 48.91797857288676],
                            [2.26402825131479, 48.919509524027916],
                            [2.262242762116137, 48.92081463095848],
                            [2.261671656306205, 48.92124492007583],
                            [2.261266744071509, 48.92159679535038],
                            [2.260916014822611, 48.92192729234508],
                            [2.260362777223492, 48.922462274479905],
                            [2.25988531362348, 48.9230187198303],
                            [2.259639252488354, 48.92336593882241],
                            [2.25942563414716, 48.92374410948801],
                            [2.25934570305215, 48.923918626560365],
                        ],
                    },
                },
                136: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.98493952737166, 2.265570823626869],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1261.36486082,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.263182622862856,
                            48.98091190326584,
                            2.269851993930268,
                            48.99065124967573,
                        ),
                        "coordinates": [
                            [2.263182622862856, 48.99065124967573],
                            [2.263828000159767, 48.98850080746261],
                            [2.264569558116951, 48.98598060907531],
                            [2.264938987091222, 48.98468948165153],
                            [2.265151782845797, 48.98398907934167],
                            [2.265217628725084, 48.98380746726178],
                            [2.265299862717603, 48.98363126018516],
                            [2.265387535529786, 48.98347214339544],
                            [2.265506693029483, 48.983271679108135],
                            [2.265639465883045, 48.983103597459554],
                            [2.265798227785891, 48.98291484795068],
                            [2.265967910562413, 48.98273150030918],
                            [2.266218262553732, 48.98250593661489],
                            [2.266449404173173, 48.982337015015496],
                            [2.266783082822401, 48.98211959515766],
                            [2.267241126077733, 48.98187527114086],
                            [2.267625294850131, 48.98169744667459],
                            [2.268508390037164, 48.98134096418717],
                            [2.268870637837192, 48.98120179144643],
                            [2.269185026292536, 48.98108956812498],
                            [2.269851993930268, 48.98091190326584],
                        ],
                    },
                },
                137: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.98791766527209, 1.9696860535955014],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 2400.43254417,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.955479247534605,
                            48.98144596941029,
                            1.983143352086498,
                            48.992613881639144,
                        ),
                        "coordinates": [
                            [1.955479247534605, 48.992613881639144],
                            [1.958410208905752, 48.99185031963231],
                            [1.959493512426805, 48.99155885623629],
                            [1.960660072257731, 48.99125337848831],
                            [1.961823005469121, 48.990947879632216],
                            [1.96358732940907, 48.99048015461005],
                            [1.964826506702233, 48.99012728583892],
                            [1.966297780375974, 48.9896776003621],
                            [1.967337946717621, 48.98934071587559],
                            [1.96833111582847, 48.9890012887529],
                            [1.96919027253338, 48.9886923570231],
                            [1.970093117239252, 48.988340729064085],
                            [1.971137547301475, 48.98790864868745],
                            [1.972330708894163, 48.987405650985686],
                            [1.973948342561463, 48.98669698356846],
                            [1.974996768279388, 48.98620301726783],
                            [1.97661871831096, 48.985387255040436],
                            [1.97832460287864, 48.98445514381108],
                            [1.979243090830599, 48.98392028118249],
                            [1.980368620212517, 48.98324567510205],
                            [1.981472547679287, 48.98255433420734],
                            [1.983143352086498, 48.98144596941029],
                        ],
                    },
                },
                138: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M6",
                        "rer": 0,
                        "extcode": "100110006:6",
                        "geo_point_2d": [48.84515192477183, 2.400015910245531],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01376",
                        "navette": 0,
                        "idrefliga": "A01539",
                        "shape_leng": 187.988448097,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.398743260868829,
                            48.8450615799449,
                            2.401289019827348,
                            48.84524823225362,
                        ),
                        "coordinates": [
                            [2.401289019827348, 48.8450615799449],
                            [2.400072430374568, 48.845146472296896],
                            [2.39902509865528, 48.845223418649965],
                            [2.398743260868829, 48.84524823225362],
                        ],
                    },
                },
                139: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.66709106514783, 1.84695431729289],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 5803.08638244,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.832935470348963,
                            48.644221953457865,
                            1.85659206528713,
                            48.69309659121679,
                        ),
                        "coordinates": [
                            [1.832935470348963, 48.644221953457865],
                            [1.833897742269862, 48.64483970101746],
                            [1.835324124189156, 48.64581915998322],
                            [1.837193509659841, 48.647087998505334],
                            [1.837546513719914, 48.64734404631596],
                            [1.837880828061444, 48.64756943559603],
                            [1.838592317774448, 48.648077952894106],
                            [1.839019356772323, 48.64839637123526],
                            [1.839398873945023, 48.648717278382605],
                            [1.839692151481013, 48.64897665520306],
                            [1.840174788476924, 48.64943739944275],
                            [1.840632878565732, 48.64991062359412],
                            [1.840973934304241, 48.650279918877594],
                            [1.84136941477331, 48.65077265161532],
                            [1.841696257529263, 48.651207530340436],
                            [1.841780606608487, 48.65132390458805],
                            [1.84212318915172, 48.651814606109895],
                            [1.842467448349342, 48.65241053000372],
                            [1.842700474059629, 48.65286388334804],
                            [1.842881098071016, 48.65326394998563],
                            [1.843184643382457, 48.653998184763765],
                            [1.843497540193419, 48.65488533688768],
                            [1.843637183017852, 48.65531310298988],
                            [1.843757091376512, 48.65567783303002],
                            [1.843855995510116, 48.6559705289699],
                            [1.844004976773792, 48.65641542091583],
                            [1.844318665800132, 48.65736282719837],
                            [1.844397785343592, 48.65759788274752],
                            [1.844863599274432, 48.658949724640365],
                            [1.845328071822014, 48.66030245851917],
                            [1.845792578715679, 48.66165429048384],
                            [1.845941424720584, 48.662116266278225],
                            [1.846145666036338, 48.662743049090736],
                            [1.846531023941065, 48.66386521919959],
                            [1.846669758325678, 48.66425250942441],
                            [1.847209896930332, 48.66578991522906],
                            [1.847784738395138, 48.66752980553356],
                            [1.847842821808982, 48.6676982212138],
                            [1.84819155495819, 48.66868623537434],
                            [1.849019203452952, 48.67109897112784],
                            [1.849326236649587, 48.67205173070517],
                            [1.849676484314482, 48.67302985490711],
                            [1.850197493462145, 48.67459863843122],
                            [1.850333551960932, 48.67498771165959],
                            [1.850452338978258, 48.675338041394504],
                            [1.850614680494159, 48.675817155022685],
                            [1.851188007576962, 48.6774573760777],
                            [1.851490623368341, 48.67831461180392],
                            [1.851726601402419, 48.67904314001343],
                            [1.85217323906696, 48.680313034994754],
                            [1.852618550278436, 48.681582023410364],
                            [1.853062524695244, 48.682851004731404],
                            [1.853326603331995, 48.683627311174284],
                            [1.853672770973487, 48.68464887205584],
                            [1.854165322260302, 48.68606973363427],
                            [1.854458800034756, 48.686899219198416],
                            [1.854710960338351, 48.68764889444398],
                            [1.854862228152567, 48.68801694176579],
                            [1.854986597374976, 48.6883582972875],
                            [1.855143765850118, 48.68881939675369],
                            [1.855344426080367, 48.68941827137432],
                            [1.855428977361471, 48.68966413381634],
                            [1.855925175448971, 48.69116623973367],
                            [1.856240942407902, 48.69208484429995],
                            [1.85659206528713, 48.69309659121679],
                        ],
                    },
                },
                140: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.857420161219245, 2.3360102898696686],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "NR",
                        "navette": 0,
                        "idrefliga": "NR",
                        "shape_leng": 1738.6722232,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.325620298740735,
                            48.85333579289227,
                            2.346034985851638,
                            48.86070823076494,
                        ),
                        "coordinates": [
                            [2.346034985851638, 48.85333579289227],
                            [2.345907892957767, 48.85336873855313],
                            [2.344887247687885, 48.853635003555446],
                            [2.344233164905792, 48.85386076766378],
                            [2.342986280062955, 48.85445464936386],
                            [2.342285594334723, 48.85487256895882],
                            [2.34189481858839, 48.85515855701591],
                            [2.341713582367341, 48.85530244861159],
                            [2.34141924098911, 48.85553537397197],
                            [2.341049948552972, 48.855826754792744],
                            [2.340521208490326, 48.85619907437647],
                            [2.340267736690628, 48.856380736777844],
                            [2.340259560796243, 48.8563852334311],
                            [2.339927731137451, 48.85657838396466],
                            [2.33948141502974, 48.85683399481777],
                            [2.339263367994021, 48.85694640978577],
                            [2.338716531799063, 48.857227920693774],
                            [2.338280628507666, 48.85742758098966],
                            [2.338071533441895, 48.85750010934028],
                            [2.337896005383008, 48.85755617695443],
                            [2.337692158261464, 48.85761260290408],
                            [2.33743958324096, 48.85767461979302],
                            [2.336937003020826, 48.85777275678894],
                            [2.336275440182249, 48.85788781174538],
                            [2.335462398875377, 48.85800578572366],
                            [2.334967677481534, 48.85808042027029],
                            [2.334543823481463, 48.85815145646423],
                            [2.334055912776827, 48.85824497193187],
                            [2.333829171919461, 48.85828708741927],
                            [2.333627966903686, 48.8583267959171],
                            [2.333381282555507, 48.85838614169282],
                            [2.333224550472934, 48.858423007975766],
                            [2.332518565338944, 48.858616329624276],
                            [2.331613586685024, 48.85887708436926],
                            [2.330469928217356, 48.85920739385645],
                            [2.329262505065705, 48.859560409663246],
                            [2.325974952816833, 48.86059971663194],
                            [2.325620298740735, 48.86070823076494],
                        ],
                    },
                },
                141: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.77314071828095, 2.4104429502163347],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 2086.48660115,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.409541656460374,
                            48.76378680955171,
                            2.411386724936104,
                            48.78250543550023,
                        ),
                        "coordinates": [
                            [2.411386724936104, 48.76378680955171],
                            [2.411327217835018, 48.763968394246305],
                            [2.411255717612045, 48.76428964998598],
                            [2.411184339710723, 48.76469418252225],
                            [2.411148752220556, 48.76496544994747],
                            [2.410981564960481, 48.766288466990666],
                            [2.410943269257952, 48.76660807062959],
                            [2.410810783113312, 48.76807936723669],
                            [2.410672871619905, 48.769567753651664],
                            [2.41063709737736, 48.77021255492548],
                            [2.410606989875543, 48.77101023025481],
                            [2.41058061315596, 48.771572292333126],
                            [2.410562142373555, 48.77196079016195],
                            [2.410519442718912, 48.77252466268932],
                            [2.410463428132036, 48.77328638315034],
                            [2.41041910536067, 48.773674897608615],
                            [2.410332529397457, 48.774933035940535],
                            [2.410261693083095, 48.77579638421732],
                            [2.410163806074753, 48.7767712590885],
                            [2.410151755115293, 48.77690256107511],
                            [2.410070299183182, 48.77795026655007],
                            [2.410032922058886, 48.778440394601496],
                            [2.4099848371692, 48.77905193190946],
                            [2.409937977507461, 48.77957174165585],
                            [2.4098076829105, 48.780743720800345],
                            [2.409732889392154, 48.78129815197806],
                            [2.409679415371185, 48.78165984567194],
                            [2.40964018779611, 48.78191683785356],
                            [2.409590234985702, 48.782226183530135],
                            [2.409541656460374, 48.78250543550023],
                        ],
                    },
                },
                142: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.80736636380431, 2.3975493522017937],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 1738.10740738,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.391686971662538,
                            48.80020939834459,
                            2.40271281718153,
                            48.813989052009454,
                        ),
                        "coordinates": [
                            [2.40271281718153, 48.80020939834459],
                            [2.402388694458657, 48.800798880907166],
                            [2.40230966399799, 48.80095834086986],
                            [2.401899980586725, 48.80166285949211],
                            [2.401529822340158, 48.80230311132965],
                            [2.401120043700234, 48.80295052291369],
                            [2.400469329429956, 48.803916898168495],
                            [2.400088253846302, 48.804497668870226],
                            [2.399678391990955, 48.80510938539171],
                            [2.399261264747814, 48.80568065601951],
                            [2.398750539869079, 48.806306699992135],
                            [2.3983656672838, 48.80676136270062],
                            [2.397829707196336, 48.80738979622354],
                            [2.397038329347954, 48.80831577895154],
                            [2.395717981668412, 48.80975834857481],
                            [2.39481129406606, 48.810724825856965],
                            [2.394174437462593, 48.81140801823558],
                            [2.393789421216613, 48.81180556107138],
                            [2.393404379955451, 48.812188826521734],
                            [2.392663105048392, 48.81295771851731],
                            [2.391686971662538, 48.813989052009454],
                        ],
                    },
                },
                143: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.86470601092518, 2.3184037491343963],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 756.725929834,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.315138432191171,
                            48.86232532909372,
                            2.32208284867617,
                            48.86681836985008,
                        ),
                        "coordinates": [
                            [2.32208284867617, 48.86681836985008],
                            [2.321774360384874, 48.866399729418816],
                            [2.321774146036822, 48.86639944041338],
                            [2.321683429134978, 48.8662847435189],
                            [2.321583020231526, 48.86617361686905],
                            [2.321473243278932, 48.86606641482068],
                            [2.321354449598869, 48.8659634828914],
                            [2.321227020713149, 48.865865149682094],
                            [2.321091362855634, 48.86577172954391],
                            [2.32094791106153, 48.865683522602176],
                            [2.32079712648788, 48.86560081114407],
                            [2.320639490961498, 48.86552385958815],
                            [2.320475509705399, 48.86545291450024],
                            [2.320305707249787, 48.865388204570586],
                            [2.320203485083617, 48.86535318889153],
                            [2.316739953588707, 48.86421451610631],
                            [2.3166895278863, 48.86419751741929],
                            [2.316536680018167, 48.86414064670694],
                            [2.316389487160845, 48.86407761608152],
                            [2.316248520017697, 48.86400866984854],
                            [2.316114321726438, 48.86393407464166],
                            [2.315987413322851, 48.8638541185539],
                            [2.315868285550733, 48.86376911198985],
                            [2.315757397545608, 48.86367938406026],
                            [2.315655180947798, 48.86358528080652],
                            [2.315562030349788, 48.86348716604486],
                            [2.315478303296491, 48.863385421365955],
                            [2.31540432720746, 48.863280438079975],
                            [2.315340387015807, 48.86317262434035],
                            [2.315286729388407, 48.86306239527469],
                            [2.315243562643898, 48.862950179279366],
                            [2.315211052771303, 48.862836409902485],
                            [2.315189328871536, 48.862721526774095],
                            [2.315187166455062, 48.86270549518221],
                            [2.315138432191171, 48.86232532909372],
                        ],
                    },
                },
                144: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.58026466261715, 2.207151105654557],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 2336.13386759,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.192063068770897,
                            48.577508489431835,
                            2.22243331383282,
                            48.58248559694799,
                        ),
                        "coordinates": [
                            [2.192063068770897, 48.577508489431835],
                            [2.192959101978819, 48.577940754354735],
                            [2.193738645120984, 48.5783105414072],
                            [2.194079557396226, 48.57846752761568],
                            [2.194362844473483, 48.57858780027418],
                            [2.194776529693579, 48.57875153818035],
                            [2.195210332229236, 48.57890364143992],
                            [2.195651709922428, 48.5790407631797],
                            [2.196105677460959, 48.57916457353781],
                            [2.196559681979031, 48.57927505959016],
                            [2.197028785416625, 48.5793739035409],
                            [2.19751048415598, 48.57945610465408],
                            [2.197977176339137, 48.57951996726035],
                            [2.198474010372151, 48.57957720053478],
                            [2.198954985641293, 48.57962177042589],
                            [2.200637204591428, 48.57975302973528],
                            [2.20187803585503, 48.579854541363716],
                            [2.205739140858419, 48.580157092631076],
                            [2.208261283472879, 48.58035484105673],
                            [2.20911203386415, 48.580424086753055],
                            [2.212507550208399, 48.58069267208359],
                            [2.213365830271464, 48.58076689108147],
                            [2.213830097177527, 48.580810697383036],
                            [2.214214044964871, 48.58085275081135],
                            [2.214868993876325, 48.580933401084366],
                            [2.215298088048602, 48.58099048842931],
                            [2.215870193574709, 48.581076040105486],
                            [2.216700715035429, 48.58121682408262],
                            [2.217511122508184, 48.58137257116665],
                            [2.218341565999359, 48.58154998555617],
                            [2.219954744507211, 48.58191806856227],
                            [2.222157533987902, 48.582421632240035],
                            [2.22243331383282, 48.58248559694799],
                        ],
                    },
                },
                145: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.75828388309225, 2.4146475096103424],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 1310.3083477,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.411386724936104,
                            48.75288655674139,
                            2.418113047325797,
                            48.76378680955171,
                        ),
                        "coordinates": [
                            [2.418113047325797, 48.75288655674139],
                            [2.416624905232636, 48.75522931882932],
                            [2.416377979117072, 48.755605388227586],
                            [2.415558496728417, 48.75686404153501],
                            [2.414869262472233, 48.75794184587288],
                            [2.414459469393249, 48.75855902867565],
                            [2.414159620449721, 48.75903584730456],
                            [2.413774240207134, 48.75962056900609],
                            [2.413452595549658, 48.7600821807872],
                            [2.412453702802303, 48.76158118009764],
                            [2.412213173520056, 48.76197630951862],
                            [2.41204088089293, 48.76227859786082],
                            [2.411893754995528, 48.762564215824064],
                            [2.41169286382455, 48.76299738578484],
                            [2.411574538640741, 48.76329250082202],
                            [2.411441863780134, 48.763618556064316],
                            [2.411386724936104, 48.76378680955171],
                        ],
                    },
                },
                146: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.852241361715436, 2.372776167893174],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 544.495585985,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.369513568156525,
                            48.85127112726454,
                            2.376118773328578,
                            48.8534394275684,
                        ),
                        "coordinates": [
                            [2.376118773328578, 48.85127112726454],
                            [2.375908557132854, 48.851317944905084],
                            [2.375191751868697, 48.8514982862211],
                            [2.373933084695514, 48.851814939795396],
                            [2.372837033454945, 48.8521349669725],
                            [2.372715849389661, 48.85216701599625],
                            [2.372464509653884, 48.85223924083999],
                            [2.372217748060535, 48.852318044557705],
                            [2.371975959916607, 48.85240330064415],
                            [2.371739532513001, 48.85249486996352],
                            [2.371508846379278, 48.852592609749315],
                            [2.37128426998515, 48.852696360985405],
                            [2.371066159632332, 48.85280595739869],
                            [2.370863988822697, 48.85291605361976],
                            [2.370773069021646, 48.852965244065004],
                            [2.370635497624539, 48.85303171654456],
                            [2.370491696820891, 48.85309217090081],
                            [2.370342266577877, 48.853146357551374],
                            [2.370187833887753, 48.85319404684388],
                            [2.370061729771435, 48.85322723643112],
                            [2.370006555778103, 48.85324150196161],
                            [2.369995405589655, 48.85324438503508],
                            [2.369866599229653, 48.853283617325744],
                            [2.369742855504854, 48.853329395548144],
                            [2.369624936886777, 48.85338143863965],
                            [2.369513568156525, 48.8534394275684],
                        ],
                    },
                },
                147: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.84372550446258, 2.29297454889573],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 273.398680196,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.291912413317875,
                            48.842746779792876,
                            2.293951963648718,
                            48.84479476371181,
                        ),
                        "coordinates": [
                            [2.293951963648718, 48.84479476371181],
                            [2.293059853120187, 48.843760295825994],
                            [2.292389913093769, 48.84311684775477],
                            [2.292351358249487, 48.843077541259106],
                            [2.292254168094726, 48.84298790818733],
                            [2.292148305749116, 48.842902666592074],
                            [2.29203422419307, 48.84282217438239],
                            [2.291912413317875, 48.842746779792876],
                        ],
                    },
                },
                148: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M8",
                        "rer": 0,
                        "extcode": "100110008:8",
                        "geo_point_2d": [48.83765605128395, 2.2802321062255557],
                        "indice_lig": "8",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01378",
                        "navette": 0,
                        "idrefliga": "A01541",
                        "shape_leng": 488.304338813,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.278161671278975,
                            48.83593087919467,
                            2.282700027239131,
                            48.838960939372015,
                        ),
                        "coordinates": [
                            [2.282700027239131, 48.838960939372015],
                            [2.282143378170892, 48.838734858836744],
                            [2.281665519935401, 48.83848228922402],
                            [2.27901897375046, 48.837083382005126],
                            [2.278793008191094, 48.83696705096826],
                            [2.278649713850015, 48.836865025272594],
                            [2.278561598682571, 48.836746035444094],
                            [2.278436830892277, 48.836525072788966],
                            [2.278237951915641, 48.83609678405708],
                            [2.278161671278975, 48.83593087919467],
                        ],
                    },
                },
                149: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.35347134651465, 2.781557164066508],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01745",
                        "navette": 0,
                        "idrefliga": "A02171",
                        "shape_leng": 8508.41926662,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.738001618532588,
                            48.33623310392106,
                            2.810859344364383,
                            48.37952262366741,
                        ),
                        "coordinates": [
                            [2.796343615000022, 48.37952262366741],
                            [2.797248420496505, 48.37912848649691],
                            [2.79761483674829, 48.37896996051565],
                            [2.797973955717404, 48.37879480928714],
                            [2.798318622920005, 48.37862361973774],
                            [2.799191538939647, 48.37818694211936],
                            [2.802443568430986, 48.37655055536922],
                            [2.804294911566199, 48.37561578312655],
                            [2.80574475336322, 48.37491105799888],
                            [2.806264606124487, 48.374642720774425],
                            [2.806582083677722, 48.374477545049174],
                            [2.806914676593119, 48.37429920195685],
                            [2.807332151212079, 48.37405376634118],
                            [2.807450240781468, 48.37398043539133],
                            [2.807592466140204, 48.37388991820488],
                            [2.808075350904084, 48.37356777126153],
                            [2.808348295682342, 48.37336189343858],
                            [2.808623206099906, 48.37312215320578],
                            [2.808931830165427, 48.372836922046325],
                            [2.80922506782465, 48.372536023384804],
                            [2.809439843906403, 48.372291642711986],
                            [2.809657723410513, 48.37203392250013],
                            [2.80982700663255, 48.37179523043513],
                            [2.809981427449479, 48.37157875622105],
                            [2.810091674810464, 48.37140023700046],
                            [2.810242113841549, 48.371116795283534],
                            [2.810388725538886, 48.37084055635797],
                            [2.810505774582508, 48.37054569146438],
                            [2.810634809330417, 48.37017227795512],
                            [2.810752259113344, 48.369746438204864],
                            [2.810792161091127, 48.36949262452508],
                            [2.810841540066914, 48.36908748817764],
                            [2.810859344364383, 48.36879457836428],
                            [2.810857367365935, 48.36858506020063],
                            [2.810827686932018, 48.36815713970425],
                            [2.810801460987502, 48.36795221970639],
                            [2.810770031941613, 48.36773666067906],
                            [2.810721638996953, 48.36752748657377],
                            [2.810651056614941, 48.36731617889527],
                            [2.810569179592014, 48.36707731999777],
                            [2.81048727966102, 48.366863395763346],
                            [2.810351990738025, 48.36658135533083],
                            [2.810199833984077, 48.36626414411335],
                            [2.8099819127011, 48.36590895217408],
                            [2.809795861568467, 48.365641753494614],
                            [2.809566164376916, 48.36532527774554],
                            [2.809336925867321, 48.36505735923569],
                            [2.809072492316782, 48.36479288960506],
                            [2.808781521299228, 48.36450660856349],
                            [2.80846545793831, 48.36422530734343],
                            [2.808257872629849, 48.36406549923453],
                            [2.808004038285347, 48.363870278762185],
                            [2.807738186184881, 48.36368638238577],
                            [2.807449237970457, 48.36350143390745],
                            [2.807227972902301, 48.36336584467541],
                            [2.80700416916066, 48.363242105176944],
                            [2.806791892142428, 48.36312319377371],
                            [2.806532219331344, 48.36298997692461],
                            [2.806316854235649, 48.36288457742787],
                            [2.806087570308325, 48.3627719041596],
                            [2.805855997703855, 48.36265810567422],
                            [2.805581904502054, 48.362523612492865],
                            [2.805112847548699, 48.36229265106712],
                            [2.804444608587908, 48.36195877838189],
                            [2.802978524232097, 48.36122627750964],
                            [2.802429903403687, 48.36095215868656],
                            [2.80189983959655, 48.36068726402109],
                            [2.801444420001418, 48.36046009010383],
                            [2.800876365653938, 48.36017979634537],
                            [2.798944709176131, 48.359222813979834],
                            [2.797536386048403, 48.35852872378684],
                            [2.796832600873678, 48.35818185013968],
                            [2.796355802254994, 48.35794833965115],
                            [2.795735811807697, 48.35763369984602],
                            [2.794165334961084, 48.35685204569394],
                            [2.78979293037002, 48.35467548339257],
                            [2.787345380185906, 48.3534649848033],
                            [2.784899288019739, 48.352253529213584],
                            [2.782453322301761, 48.351042919056034],
                            [2.780007481545479, 48.34983315613476],
                            [2.779148378851981, 48.34940398307679],
                            [2.777266286282123, 48.34846622437487],
                            [2.775769173882739, 48.34773286722875],
                            [2.775168467063438, 48.34743993340582],
                            [2.774654838264852, 48.34718742553389],
                            [2.774090624224166, 48.34690842440341],
                            [2.773414465180275, 48.34657206824231],
                            [2.772391612913229, 48.346069738584816],
                            [2.771817199743027, 48.345787789019745],
                            [2.771156294979855, 48.34546168402381],
                            [2.770521636538296, 48.34512388678718],
                            [2.770141451961348, 48.34490883254907],
                            [2.769667987775808, 48.3446370323269],
                            [2.769240943266641, 48.34436743129193],
                            [2.768882041358417, 48.34413563667834],
                            [2.768271824744296, 48.34373111313951],
                            [2.767840963248556, 48.34343059188321],
                            [2.767492555918279, 48.34317258079742],
                            [2.76725535831382, 48.342980764255366],
                            [2.766982209478003, 48.34275815341179],
                            [2.766403678144707, 48.34229877768275],
                            [2.765724601045989, 48.341766022681426],
                            [2.765318588691842, 48.34144636280191],
                            [2.765063482441401, 48.34124509340032],
                            [2.764815598978347, 48.34105331254801],
                            [2.76455956609762, 48.34086244164286],
                            [2.764171475269018, 48.34058964016269],
                            [2.763778677600431, 48.34034112629955],
                            [2.763207739784304, 48.33999110208336],
                            [2.762655424206349, 48.33966960600864],
                            [2.762160615341695, 48.33939547531839],
                            [2.761705490616973, 48.33917115809785],
                            [2.761225286394286, 48.338935037461574],
                            [2.760755975484152, 48.33872028596698],
                            [2.760043243520127, 48.33841603436495],
                            [2.759040459312793, 48.3380323509091],
                            [2.758278940060271, 48.33776116412743],
                            [2.757729843734565, 48.337582462456346],
                            [2.757119159292535, 48.33740148971741],
                            [2.756523894664542, 48.3372407394336],
                            [2.755911018252329, 48.33710061432007],
                            [2.755193949527226, 48.33693846357185],
                            [2.754616217746583, 48.336808820271116],
                            [2.754005047174062, 48.33669449508738],
                            [2.753208202397128, 48.33656657584971],
                            [2.752422321989855, 48.33646954044065],
                            [2.751754945500969, 48.33639850510893],
                            [2.75095841426223, 48.33632791515356],
                            [2.750484447768678, 48.33629003128472],
                            [2.749855363300322, 48.3362646919118],
                            [2.74937002803512, 48.33624464777485],
                            [2.748837186785384, 48.33623310392106],
                            [2.747990189927628, 48.336233491807846],
                            [2.746835928354824, 48.3362637659126],
                            [2.746254755349334, 48.33627936198361],
                            [2.745486952961956, 48.3362972192121],
                            [2.744986769326461, 48.33630906395358],
                            [2.744190244502054, 48.33632729178352],
                            [2.743660305068411, 48.33634089125678],
                            [2.74310471746014, 48.33635188385259],
                            [2.740744925188887, 48.33641160247909],
                            [2.738387831447255, 48.33647216267016],
                            [2.738001618532588, 48.336481780613234],
                        ],
                    },
                },
                150: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.12137306210128, 2.7670868898131036],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01745",
                        "navette": 0,
                        "idrefliga": "A02171",
                        "shape_leng": 5856.19123313,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.762728388543796,
                            48.09650277877714,
                            2.774122167142249,
                            48.14721803991587,
                        ),
                        "coordinates": [
                            [2.762728388543796, 48.14721803991587],
                            [2.76273124070775, 48.14692600279808],
                            [2.762737587948206, 48.14608701359404],
                            [2.762731355484866, 48.145190522916145],
                            [2.762737017123065, 48.1442706069449],
                            [2.762732068918912, 48.143366918204336],
                            [2.762740038379433, 48.142561194296455],
                            [2.762749366108946, 48.1415981038468],
                            [2.762761928003978, 48.14069974419957],
                            [2.762767771373231, 48.13980141098956],
                            [2.762772377652811, 48.13891567061274],
                            [2.762774289639833, 48.13802904155212],
                            [2.762780581342609, 48.13718376005438],
                            [2.762787334268553, 48.136234168354456],
                            [2.762786065436448, 48.13528910318546],
                            [2.76279185536933, 48.13438447673979],
                            [2.762795723004767, 48.13341151679277],
                            [2.76279800660798, 48.132568949314575],
                            [2.762797785334969, 48.132383712904534],
                            [2.762792466697309, 48.131754286685364],
                            [2.762804865578496, 48.13083704575186],
                            [2.762810212589824, 48.12988026735892],
                            [2.762817913102712, 48.12888391545409],
                            [2.762827917607845, 48.12768343432905],
                            [2.762832292342056, 48.1266115614433],
                            [2.762836012496911, 48.12546235950826],
                            [2.762851370833684, 48.12410090014393],
                            [2.762868537246985, 48.12374834587039],
                            [2.76289268551721, 48.12342723794915],
                            [2.762916575377397, 48.12323471695812],
                            [2.762954784014198, 48.12298819005845],
                            [2.763002490295106, 48.1227533162626],
                            [2.763085704013368, 48.12242928620231],
                            [2.763185215189774, 48.12212677610113],
                            [2.763290507295784, 48.12187280062092],
                            [2.763414432253781, 48.12159897224304],
                            [2.763561048419426, 48.12130887231516],
                            [2.763766242014921, 48.12095830301011],
                            [2.764018198635113, 48.12057968062769],
                            [2.764182768967725, 48.12034885962159],
                            [2.764403459228069, 48.12008455388772],
                            [2.764634866271736, 48.11981751016425],
                            [2.76494501251472, 48.11949261621677],
                            [2.765250188618764, 48.11921539968384],
                            [2.765536821318116, 48.11896882477002],
                            [2.765879582481076, 48.11869056363751],
                            [2.766161189825298, 48.11848537094358],
                            [2.771079631821379, 48.11361145787937],
                            [2.773060532582075, 48.10992778590111],
                            [2.774122167142249, 48.10575752160171],
                            [2.773713826426943, 48.10085776549668],
                            [2.77230261766097, 48.09650277877714],
                        ],
                    },
                },
                151: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.82974976174606, 2.5009613591628375],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 2304.08009043,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.494188055346116,
                            48.82484856949889,
                            2.511855553451007,
                            48.839341939180265,
                        ),
                        "coordinates": [
                            [2.494188055346116, 48.839341939180265],
                            [2.494247766895406, 48.838846953662475],
                            [2.49428634106946, 48.83850665376865],
                            [2.494335041496361, 48.83794981945879],
                            [2.49440876096613, 48.83732632879831],
                            [2.49444007068898, 48.83696938300809],
                            [2.494492824963791, 48.83655530353588],
                            [2.494553057041376, 48.83622687146399],
                            [2.494606625712022, 48.83600754436564],
                            [2.494677919395311, 48.835757614148676],
                            [2.494785088492835, 48.83545528867773],
                            [2.494874454512325, 48.83522198901582],
                            [2.494988959541596, 48.83496010230668],
                            [2.495092814994253, 48.834750575106625],
                            [2.495250507616648, 48.83446959352472],
                            [2.495401095686161, 48.83422193256743],
                            [2.496322846076571, 48.832809693311546],
                            [2.496712946261206, 48.83219844504028],
                            [2.497140330411507, 48.831552605217134],
                            [2.497320489863974, 48.83129060209894],
                            [2.49768548971296, 48.830733342726056],
                            [2.497893531093397, 48.83042849144205],
                            [2.4981267353821, 48.83010457095283],
                            [2.498321673575904, 48.82986671831846],
                            [2.498521609160343, 48.82962576369708],
                            [2.49869037660845, 48.82943755598253],
                            [2.499101887977773, 48.829023344577465],
                            [2.499323720496731, 48.828814886859284],
                            [2.499628931941801, 48.828544098368724],
                            [2.499934239976472, 48.82830409190573],
                            [2.500267467584421, 48.82804497023481],
                            [2.500646486652083, 48.82778552795893],
                            [2.501191511108631, 48.82743672379359],
                            [2.501691788944037, 48.82715003217035],
                            [2.502106461696296, 48.826926411390446],
                            [2.502574264952994, 48.82670720837081],
                            [2.502874036656867, 48.82657485091107],
                            [2.50319948682061, 48.826442221633926],
                            [2.503541299313914, 48.826302924058766],
                            [2.504073190058934, 48.826109700224784],
                            [2.504311268842221, 48.8260293155916],
                            [2.504535748512162, 48.82595929506318],
                            [2.504858178104163, 48.82586103227905],
                            [2.505331909786763, 48.825726674456156],
                            [2.505642006799357, 48.82564965816218],
                            [2.506225849975233, 48.825518398747874],
                            [2.506561054164337, 48.82545323751325],
                            [2.507099534828155, 48.82535528254552],
                            [2.50754384646785, 48.82528963736865],
                            [2.507984529348589, 48.825229805287194],
                            [2.508844977549582, 48.825138583558406],
                            [2.509435855385033, 48.82507654159762],
                            [2.509914257207523, 48.82502670696369],
                            [2.510482958774583, 48.82497528756578],
                            [2.511177234201497, 48.82491292453119],
                            [2.511855553451007, 48.82484856949889],
                        ],
                    },
                },
                152: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.87412669089637, 2.610452466832867],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 3992.07205924,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.583331158055108,
                            48.873371395535315,
                            2.637590717167975,
                            48.87520826545471,
                        ),
                        "coordinates": [
                            [2.583331158055108, 48.87414408301457],
                            [2.585207558695742, 48.873954442853965],
                            [2.585510387322357, 48.873923668498286],
                            [2.586323765709928, 48.873841008135635],
                            [2.58841899418083, 48.87365331474768],
                            [2.589324219151641, 48.87358189178765],
                            [2.589854110628206, 48.8735470495907],
                            [2.590571671217689, 48.87350581800877],
                            [2.59134977905419, 48.87346725117777],
                            [2.592208167334582, 48.87343080360643],
                            [2.592735079834614, 48.87341120715678],
                            [2.59340507342645, 48.873388985527676],
                            [2.593904110134702, 48.87337865475599],
                            [2.594525981654122, 48.873371395535315],
                            [2.59531395576001, 48.873376241105404],
                            [2.596024942027703, 48.87338319679672],
                            [2.596830117163757, 48.87339849915184],
                            [2.597560626610289, 48.87341396687035],
                            [2.598430785469064, 48.87343981727825],
                            [2.599125643294948, 48.87346606367441],
                            [2.599690649112652, 48.873492603904495],
                            [2.601340211186603, 48.87357017043353],
                            [2.603622561980809, 48.873675412130865],
                            [2.607039420624726, 48.873834409481375],
                            [2.611011574659458, 48.874019276925736],
                            [2.615896285505255, 48.87424741244236],
                            [2.618256815721966, 48.87435225607318],
                            [2.623245817549538, 48.87458636034341],
                            [2.62535912649922, 48.87467809073089],
                            [2.627551798882467, 48.874754052580975],
                            [2.62981148833539, 48.87485443246263],
                            [2.631172890821067, 48.87490486500882],
                            [2.63248189675449, 48.87496461168814],
                            [2.634268630284971, 48.87505993357167],
                            [2.636043476594933, 48.87513487798265],
                            [2.637590717167975, 48.87520826545471],
                        ],
                    },
                },
                153: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.16029172996976, 3.0952712416096126],
                        "indice_lig": "TER",
                        "idf": 0,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 6051.41950253,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            3.075626562947475,
                            49.13547414375095,
                            3.12061291667141,
                            49.179504949934255,
                        ),
                        "coordinates": [
                            [3.075626562947475, 49.13547414375095],
                            [3.07593991650652, 49.13828659666273],
                            [3.076101032370153, 49.139069755821595],
                            [3.076317468340032, 49.13970237391073],
                            [3.076430597472889, 49.13993456608019],
                            [3.087687495154015, 49.153982716666256],
                            [3.099703478640675, 49.16733030611128],
                            [3.1116530363399, 49.17602932425011],
                            [3.12061291667141, 49.179504949934255],
                        ],
                    },
                },
                154: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.54158017398183, 3.132339202182192],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 18930.2274681,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            3.011769326340159,
                            48.51375459097529,
                            3.250034982583049,
                            48.562124835009335,
                        ),
                        "coordinates": [
                            [3.250034982583049, 48.51375459097529],
                            [3.249853945357546, 48.51389872290486],
                            [3.249138844995903, 48.51447015954613],
                            [3.247753636545094, 48.51563334044736],
                            [3.246758844411207, 48.51645882048767],
                            [3.246041668711754, 48.51706892450682],
                            [3.245649465686489, 48.51738683453011],
                            [3.245209903375309, 48.5177060229367],
                            [3.244929359176486, 48.51791151926874],
                            [3.244497516600703, 48.51820905850838],
                            [3.244084047518781, 48.518474973117506],
                            [3.243663593912424, 48.518729250947516],
                            [3.243276501400833, 48.51895717945212],
                            [3.24298857430668, 48.51912945551102],
                            [3.242645385238286, 48.519314425227265],
                            [3.242136961404717, 48.519571902305024],
                            [3.241798657694586, 48.5197298657957],
                            [3.241457664070075, 48.51988784905679],
                            [3.241039197446301, 48.520069650141146],
                            [3.240448496523091, 48.52030087851992],
                            [3.239557288674779, 48.520651524807924],
                            [3.238441656931013, 48.52109478124457],
                            [3.237391669432112, 48.52150063351466],
                            [3.236347255484608, 48.52191632466226],
                            [3.235285488950892, 48.522337250278],
                            [3.234365570085992, 48.52268567380888],
                            [3.233755261989401, 48.52292869057292],
                            [3.232861321848435, 48.523281240508254],
                            [3.232035885563069, 48.52360612638846],
                            [3.230844718761034, 48.524072387904965],
                            [3.229430345244032, 48.524625830772884],
                            [3.227673709987366, 48.52529554060056],
                            [3.225588891633128, 48.52611922690337],
                            [3.224679813252694, 48.52646629779769],
                            [3.223682271251082, 48.52685982209516],
                            [3.222502957180112, 48.527320603065974],
                            [3.220706679366514, 48.52803250392],
                            [3.218524096889001, 48.52887688451809],
                            [3.217145530280503, 48.52941623057007],
                            [3.216042838639051, 48.52983415663934],
                            [3.215070703394111, 48.530185567322945],
                            [3.214098824653648, 48.53052005030102],
                            [3.212262189287973, 48.531133270260696],
                            [3.211258078677476, 48.531476469914644],
                            [3.210488256671631, 48.531745010113106],
                            [3.20983147652462, 48.53197400301876],
                            [3.20773178410411, 48.532699724273094],
                            [3.20649070083182, 48.53312384273446],
                            [3.204363522912061, 48.5338631097363],
                            [3.203561324348018, 48.53414106600199],
                            [3.202600035881683, 48.53447187593961],
                            [3.201604929095662, 48.5348079771379],
                            [3.201017600239632, 48.53501227341592],
                            [3.200412362702639, 48.53522546759334],
                            [3.199789416124002, 48.53543503525303],
                            [3.199307558779785, 48.53557773570062],
                            [3.198801710715775, 48.5357139002397],
                            [3.198339811005731, 48.535838196855515],
                            [3.197922815967738, 48.535942206308],
                            [3.197436122316396, 48.53604740952538],
                            [3.196924097493987, 48.536151449072094],
                            [3.196406272389532, 48.53624408225733],
                            [3.195765166901817, 48.536346614464804],
                            [3.195154189062761, 48.536432536302236],
                            [3.194652856395575, 48.53649478781314],
                            [3.193645680817977, 48.53659323762959],
                            [3.19265693272599, 48.536660962975574],
                            [3.191890856351761, 48.53668383189958],
                            [3.190948450629059, 48.536690039423775],
                            [3.190214240283105, 48.53667578505952],
                            [3.189431985313782, 48.53663611795202],
                            [3.188763841827345, 48.53659226871273],
                            [3.188058502824284, 48.53652382458915],
                            [3.187237601817624, 48.53642836526992],
                            [3.186337789008579, 48.536311007942096],
                            [3.184403767562205, 48.53605569323023],
                            [3.182431670942092, 48.535789838231885],
                            [3.181055479998649, 48.53560764539772],
                            [3.179885618917621, 48.53545447666611],
                            [3.178502660561405, 48.5352714036136],
                            [3.177724974621389, 48.53516656072753],
                            [3.176424760047027, 48.53499094203191],
                            [3.174262802065457, 48.53470297047485],
                            [3.172870423691708, 48.534520798309735],
                            [3.169903832762767, 48.5341316587778],
                            [3.168747879502285, 48.533996260132675],
                            [3.168147771849165, 48.53393023725482],
                            [3.167499263779493, 48.53387431693945],
                            [3.16709572080642, 48.53384515129412],
                            [3.166692238389889, 48.53381955368603],
                            [3.166061993587139, 48.533791117755705],
                            [3.164978130007166, 48.53375587654628],
                            [3.16378894386412, 48.533738481320356],
                            [3.162903440036716, 48.53374314054031],
                            [3.162365255449034, 48.5337541515964],
                            [3.161656850673534, 48.533775603691815],
                            [3.160987396839414, 48.53381036193435],
                            [3.159994317769176, 48.53387375923635],
                            [3.15927218159047, 48.53393412826336],
                            [3.158919305729981, 48.533967264710874],
                            [3.158373110997732, 48.53401978891238],
                            [3.157395905592261, 48.53413028976209],
                            [3.156772959585215, 48.53420944186886],
                            [3.156363582890293, 48.53426546277316],
                            [3.155515424325035, 48.534391610763095],
                            [3.154679469972308, 48.534538430487245],
                            [3.153942756618073, 48.53467600142997],
                            [3.153329965299476, 48.53480216163728],
                            [3.152777910311315, 48.534923527803116],
                            [3.152103397177411, 48.53508668732859],
                            [3.151150991228357, 48.53530847062247],
                            [3.150469732657855, 48.53546714684498],
                            [3.149561876351572, 48.53568140262141],
                            [3.148969636321698, 48.53581874637556],
                            [3.147920107952338, 48.53606547942096],
                            [3.146858354889337, 48.53631049197145],
                            [3.146023147843207, 48.53649722008421],
                            [3.14490348682026, 48.536763311752246],
                            [3.143267193716167, 48.53715537643393],
                            [3.142208117891897, 48.537401225541814],
                            [3.141529495522832, 48.537558928598095],
                            [3.140142610581884, 48.537884425897964],
                            [3.139155122735691, 48.53812074568456],
                            [3.138359038846482, 48.53830174435092],
                            [3.138041958613676, 48.53837413300859],
                            [3.137374200647418, 48.538535331278105],
                            [3.136985653771198, 48.53862710701978],
                            [3.135090028836219, 48.53906944650952],
                            [3.13381352113094, 48.539358115573876],
                            [3.132608709487235, 48.539642669863674],
                            [3.131626512588099, 48.53987528927635],
                            [3.130605036066385, 48.54010817486039],
                            [3.129742994026311, 48.540318352680806],
                            [3.129091261897971, 48.540468598319706],
                            [3.128484070626437, 48.540609536634065],
                            [3.12787825815666, 48.54075225957793],
                            [3.127012031383058, 48.540956151111395],
                            [3.126078333061371, 48.54117579263791],
                            [3.12411768625052, 48.541629191303464],
                            [3.120941283457941, 48.54237065892662],
                            [3.117901110811394, 48.54308231959451],
                            [3.117299272649429, 48.54322316004994],
                            [3.114935025965158, 48.54377360473222],
                            [3.114287295559121, 48.54392553610051],
                            [3.112541059051712, 48.54433229721375],
                            [3.111847437449446, 48.54449532053042],
                            [3.109492578192943, 48.5450473854617],
                            [3.108365650791605, 48.545305968975626],
                            [3.105821835994189, 48.54590600648883],
                            [3.103650310548614, 48.54640994146619],
                            [3.101285845555926, 48.5469654971732],
                            [3.097734899902423, 48.54779426483861],
                            [3.095715730592144, 48.548263745542705],
                            [3.094916695703703, 48.54844985133962],
                            [3.093757252919604, 48.54871839658532],
                            [3.093282136219811, 48.54882858455425],
                            [3.091859481183006, 48.54915911963083],
                            [3.089720122314041, 48.54965986920119],
                            [3.087837150947541, 48.55009862744388],
                            [3.085271061882689, 48.55069204930398],
                            [3.08446929492454, 48.55088169636795],
                            [3.083346254485842, 48.55114629684202],
                            [3.08178987602475, 48.551510858857185],
                            [3.077856149761744, 48.55242155099415],
                            [3.077008534714337, 48.55262187856622],
                            [3.075961145805754, 48.55286784255948],
                            [3.074940598906934, 48.553111836429025],
                            [3.073909106396766, 48.55334340005444],
                            [3.072960770269283, 48.553563707860455],
                            [3.072135698142945, 48.55375822502891],
                            [3.071313045462485, 48.553934873457585],
                            [3.070610738023913, 48.554069693820395],
                            [3.069986036783935, 48.55418080703257],
                            [3.06937558422581, 48.55428617489089],
                            [3.068574371997201, 48.554398422471614],
                            [3.067865849386374, 48.55447675441995],
                            [3.067107115382745, 48.554553025317375],
                            [3.065040411280048, 48.554752837811805],
                            [3.06359014450487, 48.55488534618906],
                            [3.062009473752052, 48.555025194893716],
                            [3.061092680987014, 48.55510906501933],
                            [3.059378646121201, 48.55527018288535],
                            [3.058118125786075, 48.555385322965634],
                            [3.057165302767761, 48.55547132042359],
                            [3.055322690347238, 48.555642187254584],
                            [3.053001077492066, 48.55585292094307],
                            [3.049947482324466, 48.55612846712036],
                            [3.048252200809361, 48.556279406405196],
                            [3.045097126257802, 48.55656714974675],
                            [3.043580570400756, 48.5567133056116],
                            [3.040996384036385, 48.55694791239956],
                            [3.040103363556948, 48.55702539829785],
                            [3.038634000989672, 48.55715770568853],
                            [3.037293140737366, 48.5572766107589],
                            [3.035643838746968, 48.55742707779664],
                            [3.034163690882344, 48.55756478982158],
                            [3.033353280096604, 48.55764171458729],
                            [3.032004254794427, 48.55775970680259],
                            [3.030923125387875, 48.55785356219038],
                            [3.029524142644331, 48.55798442079056],
                            [3.025989951964486, 48.55830272366499],
                            [3.024960189425027, 48.55838991447917],
                            [3.023929242114034, 48.55848969300562],
                            [3.021603228169595, 48.55869441421202],
                            [3.021076775685551, 48.55873446394976],
                            [3.020474671050076, 48.55879025482424],
                            [3.019850997161139, 48.55884729572404],
                            [3.019292611779082, 48.558905383348964],
                            [3.018734549412604, 48.55898726138023],
                            [3.018291050030732, 48.559058929132455],
                            [3.017929953753836, 48.55912772226823],
                            [3.017590559295051, 48.55920059864839],
                            [3.017194494254066, 48.55929464055645],
                            [3.016827162414875, 48.559392548736675],
                            [3.016424028134937, 48.55951488257897],
                            [3.016056068111987, 48.55963336922651],
                            [3.015676191709057, 48.55977418039796],
                            [3.015210056313884, 48.559965050489836],
                            [3.01460137873621, 48.560258091731235],
                            [3.014123955959843, 48.56050439353964],
                            [3.013723247820952, 48.56074176193987],
                            [3.013341726240904, 48.56098145302508],
                            [3.012867991809824, 48.561315219453775],
                            [3.012291165334066, 48.561740426398096],
                            [3.011769326340159, 48.562124835009335],
                        ],
                    },
                },
                155: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.73820855442225, 2.443557312087149],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1845.03556701,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.438344239163614,
                            48.73011683142026,
                            2.446290833250972,
                            48.745230819408114,
                        ),
                        "coordinates": [
                            [2.446135830934545, 48.73011683142026],
                            [2.446160508450207, 48.730246306539605],
                            [2.446222422872905, 48.730584373317015],
                            [2.446248693104217, 48.73078578508506],
                            [2.446269528987294, 48.730988100725234],
                            [2.446269615326568, 48.73102766850042],
                            [2.446272415584877, 48.73106453614594],
                            [2.446273879119162, 48.73111219629473],
                            [2.446282312306956, 48.73123808629105],
                            [2.446290833250972, 48.73140354404188],
                            [2.446288478243837, 48.73156901247847],
                            [2.446287565201259, 48.73177224885048],
                            [2.446281302495835, 48.73201505829245],
                            [2.446276313061863, 48.73221919760409],
                            [2.446266041324861, 48.73249348589149],
                            [2.446236631618638, 48.73278306037673],
                            [2.446215780519422, 48.73300213223851],
                            [2.446167245499712, 48.73337190552676],
                            [2.446119054693386, 48.73387110074781],
                            [2.446088788355104, 48.73425220060114],
                            [2.446034357101834, 48.734706818113786],
                            [2.446017268650283, 48.734973918225386],
                            [2.446004070876241, 48.73515468476403],
                            [2.445977310335536, 48.735350751647665],
                            [2.445939762913628, 48.735587296248184],
                            [2.445860381998591, 48.73596596659345],
                            [2.445774256046163, 48.73636982210687],
                            [2.445666632296345, 48.73689060437912],
                            [2.445607303913415, 48.73711547885987],
                            [2.445570889406429, 48.73724950585651],
                            [2.445510137380059, 48.73744560510114],
                            [2.445462812981973, 48.737565253314656],
                            [2.445383029303381, 48.73776227050722],
                            [2.445289642676271, 48.73795660254881],
                            [2.445154201945167, 48.73819413957204],
                            [2.445018685233024, 48.73839750464062],
                            [2.444904842413411, 48.738563978272616],
                            [2.444744830478017, 48.738757473784304],
                            [2.444580700532257, 48.73893388758578],
                            [2.444396194167901, 48.73911841366572],
                            [2.444231998310451, 48.7392651506375],
                            [2.444055585243407, 48.739420891395646],
                            [2.44383707055715, 48.73959915370179],
                            [2.443611736536056, 48.739768429021964],
                            [2.443360601504762, 48.739953015220834],
                            [2.442567756625349, 48.74050770886944],
                            [2.441554548523095, 48.741237240206225],
                            [2.441230557603763, 48.74148465724214],
                            [2.440953696087649, 48.74172861447228],
                            [2.440766405962939, 48.74189425143231],
                            [2.440610371240031, 48.74205176693014],
                            [2.440486911126692, 48.742182274655434],
                            [2.440334983952946, 48.74235417387515],
                            [2.440150509190862, 48.7425674696153],
                            [2.439631097472172, 48.74322261156942],
                            [2.439130624977952, 48.74383726739878],
                            [2.438931269855138, 48.744093739458705],
                            [2.438784855113378, 48.744306998508705],
                            [2.438679150644873, 48.744480652452346],
                            [2.438584332826893, 48.7446596929051],
                            [2.438505805511379, 48.74482522934107],
                            [2.438443153463417, 48.744956580996465],
                            [2.438393051958888, 48.745087488858424],
                            [2.438344239163614, 48.745230819408114],
                        ],
                    },
                },
                156: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.68305239679522, 2.3676079915120343],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2706.5412615,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.352481401048998,
                            48.676446656997726,
                            2.382757203082266,
                            48.68969793365298,
                        ),
                        "coordinates": [
                            [2.352481401048998, 48.676446656997726],
                            [2.352651710635371, 48.676611194955726],
                            [2.352968137765413, 48.676883253100854],
                            [2.353598371553556, 48.67736336978714],
                            [2.354080550656454, 48.67769512658065],
                            [2.354733699512631, 48.67809203212078],
                            [2.355333834707852, 48.67841314223769],
                            [2.355893769256218, 48.67867413588618],
                            [2.356466925031537, 48.67891773907016],
                            [2.356770974291829, 48.679041341532646],
                            [2.357072676012722, 48.67915503885028],
                            [2.357351910387353, 48.679254329499415],
                            [2.357633701449175, 48.67935257185632],
                            [2.358043358131362, 48.67948335743325],
                            [2.358302089057277, 48.67956420652395],
                            [2.358550040447846, 48.67963791717336],
                            [2.358866264717556, 48.67972589062563],
                            [2.359225608812028, 48.67981861398919],
                            [2.359761028415913, 48.67994461033868],
                            [2.360329534296937, 48.68007435902309],
                            [2.360932470570231, 48.68021749939525],
                            [2.361503833830279, 48.68035299737065],
                            [2.36184521812357, 48.68043619802744],
                            [2.362175820604817, 48.68051464199508],
                            [2.362409400013626, 48.68057407190389],
                            [2.36265736285523, 48.680650154000254],
                            [2.362952044943171, 48.680742880151506],
                            [2.363271883412531, 48.68084273701301],
                            [2.363523448957911, 48.68093071245555],
                            [2.363814547340856, 48.681035333723756],
                            [2.364173940603852, 48.681182764377915],
                            [2.364483016886978, 48.68130403400878],
                            [2.364971794667307, 48.68150139774188],
                            [2.36547136498358, 48.68171303144649],
                            [2.36578405258717, 48.68185333109283],
                            [2.366103925304415, 48.68199124936919],
                            [2.366466942603685, 48.68216722481026],
                            [2.366758083280973, 48.68231942448375],
                            [2.366959375894221, 48.68243833590251],
                            [2.367243339037844, 48.68260243332113],
                            [2.367469798856948, 48.68274037288902],
                            [2.367760957277161, 48.68291160412782],
                            [2.368059310811836, 48.683092350634624],
                            [2.368350488591731, 48.68328737456252],
                            [2.368612906265408, 48.68345623233758],
                            [2.368904079792835, 48.68363697817642],
                            [2.369166493762556, 48.68379393805232],
                            [2.369450472553815, 48.683958030034155],
                            [2.369730860075062, 48.68412212121583],
                            [2.370362016312544, 48.68445883056417],
                            [2.371006933646718, 48.68475940117238],
                            [2.371671910468043, 48.68504471697853],
                            [2.372390799871556, 48.68533477055899],
                            [2.373131245413605, 48.68560815673932],
                            [2.373775282734897, 48.68581978797649],
                            [2.374087336073916, 48.68592436399419],
                            [2.37434992310769, 48.6860039492812],
                            [2.374860705818699, 48.6861530574915],
                            [2.375603774728401, 48.686348846074864],
                            [2.376991511385021, 48.68672513374018],
                            [2.377465966812344, 48.686860586385485],
                            [2.377954820330918, 48.687019824363254],
                            [2.378508397119493, 48.68722424398286],
                            [2.379083571683295, 48.68746196250001],
                            [2.379601250329117, 48.687699700193626],
                            [2.380038646964371, 48.68791431984325],
                            [2.380633434791751, 48.68826138717864],
                            [2.382057704915416, 48.689197865937366],
                            [2.382407004307814, 48.689448621645965],
                            [2.382757203082266, 48.68969793365298],
                        ],
                    },
                },
                157: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.70098871594943, 2.3933781192115724],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2979.62085903,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.382757203082266,
                            48.68969793365298,
                            2.403633104908493,
                            48.71262898747625,
                        ),
                        "coordinates": [
                            [2.382757203082266, 48.68969793365298],
                            [2.383045806984474, 48.68990339294061],
                            [2.383230663352005, 48.69004540272094],
                            [2.38345493979785, 48.69021796980802],
                            [2.384025918477654, 48.69074740314599],
                            [2.384494979877404, 48.69121752392339],
                            [2.384936890498618, 48.691695748125035],
                            [2.385571844184228, 48.69232856255648],
                            [2.386115722608555, 48.69287778020683],
                            [2.388439743080135, 48.69538570681775],
                            [2.389199942623788, 48.696188405541065],
                            [2.389924826868116, 48.696972231572516],
                            [2.390523270418308, 48.69763920728414],
                            [2.390955746082016, 48.69807964382771],
                            [2.391208720371253, 48.69835020305846],
                            [2.391541944909567, 48.698706153166206],
                            [2.392333599661923, 48.699605937312384],
                            [2.393121165310217, 48.700467948296954],
                            [2.39387341168129, 48.70130928933809],
                            [2.394578044363382, 48.702075110306524],
                            [2.395354774138076, 48.702899342748864],
                            [2.395813300584402, 48.703465645033965],
                            [2.396119453143499, 48.70385127241293],
                            [2.396779365218163, 48.7046539738991],
                            [2.397523664407638, 48.70556184101406],
                            [2.397633887097888, 48.70569937009275],
                            [2.39780262031756, 48.705907910418155],
                            [2.398790582515602, 48.707147467869454],
                            [2.399143026197246, 48.70757083148948],
                            [2.399769008776976, 48.708328569929],
                            [2.400420900819729, 48.70914474331237],
                            [2.400912159347558, 48.70971730056517],
                            [2.402222690553023, 48.711156499190864],
                            [2.402568361349131, 48.71155364541476],
                            [2.402816812970916, 48.711836640859524],
                            [2.403076020967614, 48.712095835821586],
                            [2.403390114759124, 48.71239119577324],
                            [2.403633104908493, 48.71262898747625],
                        ],
                    },
                },
                158: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M10",
                        "rer": 0,
                        "extcode": "100110010:10",
                        "geo_point_2d": [48.84605814805444, 2.31211295314543],
                        "indice_lig": "10",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01380",
                        "navette": 0,
                        "idrefliga": "A01543",
                        "shape_leng": 812.698766286,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.307402240619641,
                            48.84532666016781,
                            2.317005235737245,
                            48.84706613315245,
                        ),
                        "coordinates": [
                            [2.317005235737245, 48.846989106139524],
                            [2.316634671102764, 48.84685485575205],
                            [2.3162490013665, 48.84671315388128],
                            [2.315374875791169, 48.84644494378696],
                            [2.312067879030493, 48.84543016051683],
                            [2.311954699311265, 48.84539866505795],
                            [2.311825114563824, 48.84537008169891],
                            [2.311692461861698, 48.84534847040511],
                            [2.311557608614055, 48.84533397555995],
                            [2.311421422902659, 48.845326690290776],
                            [2.311284791149452, 48.84532666016781],
                            [2.311148597644598, 48.8453338857848],
                            [2.311013725934533, 48.84534832096804],
                            [2.310881051987304, 48.84536987453588],
                            [2.310751437512516, 48.845398400366896],
                            [2.310653537884301, 48.84542521834227],
                            [2.309724111819044, 48.8457025690233],
                            [2.309652612949601, 48.84572431139976],
                            [2.309521848519459, 48.8457698848026],
                            [2.3093966087611, 48.8458217810049],
                            [2.309277595182059, 48.84587970908208],
                            [2.309165475664999, 48.84594334554007],
                            [2.309136689723739, 48.84596131678528],
                            [2.307402240619641, 48.84706613315245],
                        ],
                    },
                },
                159: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M10",
                        "rer": 0,
                        "extcode": "100110010:10",
                        "geo_point_2d": [48.852237513415986, 2.3309631639692987],
                        "indice_lig": "10",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01380",
                        "navette": 0,
                        "idrefliga": "A01543",
                        "shape_leng": 695.842044683,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.326488473969165,
                            48.851192349321856,
                            2.335502051727559,
                            48.85301676791718,
                        ),
                        "coordinates": [
                            [2.335502051727559, 48.85301676791718],
                            [2.335145283308617, 48.852942114518896],
                            [2.334697790355912, 48.85284847566291],
                            [2.334057378978815, 48.852737246682715],
                            [2.33353072296907, 48.85267513941075],
                            [2.333225963365026, 48.852670496104],
                            [2.332822899226455, 48.85261951139787],
                            [2.328769344818776, 48.851897025405954],
                            [2.327802871339836, 48.85166218976492],
                            [2.327639491233927, 48.85161900377258],
                            [2.327446888673913, 48.851560939807065],
                            [2.327259115995632, 48.85149635535886],
                            [2.327102988253409, 48.85143618275847],
                            [2.32693524339044, 48.85137882973943],
                            [2.326488473969165, 48.851192349321856],
                        ],
                    },
                },
                160: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.04534072858193, 2.106172270618482],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01863",
                        "navette": 0,
                        "idrefliga": "A02181",
                        "shape_leng": 155.514119079,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.105110703444507,
                            49.04530962796638,
                            2.107233059674136,
                            49.04539401994291,
                        ),
                        "coordinates": [
                            [2.107233059674136, 49.04539401994291],
                            [2.106582403517276, 49.045354551360596],
                            [2.105934758426439, 49.04532512796745],
                            [2.105610917541017, 49.04531443254045],
                            [2.105221049327595, 49.04530962796638],
                            [2.105110703444507, 49.045311648350264],
                        ],
                    },
                },
                161: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.80063291553285, 2.1747611804387925],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01744",
                        "navette": 0,
                        "idrefliga": "A02172",
                        "shape_leng": 496.243917546,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.171389812756379,
                            48.800562566282714,
                            2.178130972336866,
                            48.800720766349464,
                        ),
                        "coordinates": [
                            [2.171389812756379, 48.80071846386355],
                            [2.171400515562385, 48.80071880338744],
                            [2.171903089010338, 48.800720766349464],
                            [2.172336889530995, 48.8007152310616],
                            [2.173064633662477, 48.800682384781815],
                            [2.174282238330508, 48.80061633996727],
                            [2.175919822294987, 48.800562566282714],
                            [2.176654529377904, 48.80057787835856],
                            [2.177065087651669, 48.80059035108217],
                            [2.177472022349711, 48.80060995499961],
                            [2.177821314060172, 48.80063423733164],
                            [2.178130972336866, 48.80066322078583],
                        ],
                    },
                },
                162: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.80030825690828, 2.1809198019738107],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "NR",
                        "navette": 0,
                        "idrefliga": "NR",
                        "shape_leng": 424.489649532,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.178130973726579,
                            48.79972882534396,
                            2.183684109854236,
                            48.800695034197034,
                        ),
                        "coordinates": [
                            [2.183684109854236, 48.79972882534396],
                            [2.181549600534488, 48.800207172114476],
                            [2.181037401196676, 48.80032158054706],
                            [2.180435311758618, 48.80045025127266],
                            [2.180044832620709, 48.8005272873863],
                            [2.179621038661392, 48.80059951195484],
                            [2.179189058512375, 48.800664361173034],
                            [2.178993254809456, 48.80068650189317],
                            [2.178819450514283, 48.800695034197034],
                            [2.178649252405362, 48.800693040898544],
                            [2.178130973726579, 48.80066321899656],
                        ],
                    },
                },
                163: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.045431012009466, 2.1031051862686283],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01863",
                        "navette": 0,
                        "idrefliga": "A02181",
                        "shape_leng": 295.647988421,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.101108482966614,
                            49.045311648350264,
                            2.105110703444507,
                            49.04564873988319,
                        ),
                        "coordinates": [
                            [2.105110703444507, 49.045311648350264],
                            [2.104628215681291, 49.04532047996179],
                            [2.104374559147197, 49.04533000897707],
                            [2.104086670840201, 49.04534147623432],
                            [2.103441731027953, 49.045386363089136],
                            [2.10270505892091, 49.04544511964608],
                            [2.102295453480011, 49.045478428084046],
                            [2.101824629861494, 49.0455337048508],
                            [2.101108482966614, 49.04564873988319],
                        ],
                    },
                },
                164: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.71863684646498, 2.4119979829145652],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1874.10971295,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.403633104908493,
                            48.71262898747625,
                            2.419565024387933,
                            48.72553530486119,
                        ),
                        "coordinates": [
                            [2.403633104908493, 48.71262898747625],
                            [2.403760218066728, 48.71275338036123],
                            [2.404241855357792, 48.71319103840689],
                            [2.404580737259858, 48.71346305084839],
                            [2.404929819788531, 48.71370077356364],
                            [2.405515012454503, 48.71408234846835],
                            [2.40618558384271, 48.7145297763729],
                            [2.406450802714425, 48.7146923814499],
                            [2.40727093899601, 48.71518467423468],
                            [2.408001281358155, 48.71559428453797],
                            [2.408971029364889, 48.71615211765388],
                            [2.409509679788258, 48.716490797208145],
                            [2.409953157029819, 48.71679536485506],
                            [2.410055184198932, 48.71686544136762],
                            [2.410748939013496, 48.7173137267399],
                            [2.4114739452638, 48.71775029636385],
                            [2.412359454632673, 48.71826858843303],
                            [2.412956645358633, 48.718644083809956],
                            [2.413091319321211, 48.718728524164284],
                            [2.413197428798623, 48.718795897961854],
                            [2.413898110216495, 48.71929361949754],
                            [2.41427228515168, 48.71957213772228],
                            [2.414568002899246, 48.71981418733267],
                            [2.414777186701919, 48.720009736405494],
                            [2.41517597685818, 48.720378162012075],
                            [2.415574830267373, 48.72078165881984],
                            [2.415683744313906, 48.72089938726115],
                            [2.415732769389958, 48.72096050315869],
                            [2.416036479366335, 48.72135597063324],
                            [2.416135926304154, 48.721500683507486],
                            [2.416273513368349, 48.721698426554525],
                            [2.41645742542816, 48.72196717920239],
                            [2.416627760758634, 48.72224403484902],
                            [2.416855273307344, 48.72257660457186],
                            [2.417056940391772, 48.72289480380049],
                            [2.41730288080876, 48.72327181618965],
                            [2.417569179431797, 48.72363094277449],
                            [2.417689018459523, 48.72377384131561],
                            [2.417920500127482, 48.72403176721072],
                            [2.418459628617813, 48.72457274056327],
                            [2.418853008010847, 48.72491777697031],
                            [2.419565024387933, 48.72553530486119],
                        ],
                    },
                },
                165: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.90211574537828, 1.8653499616634424],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "NR",
                        "navette": 0,
                        "idrefliga": "NR",
                        "shape_leng": 2116.78611661,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.857227537127738,
                            48.893238595694605,
                            1.871738475714576,
                            48.90930537596191,
                        ),
                        "coordinates": [
                            [1.871738475714576, 48.893238595694605],
                            [1.871582764656284, 48.89355451252227],
                            [1.871531452566473, 48.89364513283113],
                            [1.871482943936253, 48.89372766980096],
                            [1.871346981453043, 48.89397352157298],
                            [1.871198768426265, 48.89421662607558],
                            [1.870985533794781, 48.89455748812633],
                            [1.870874731954356, 48.89473779385778],
                            [1.870657232165005, 48.895096623301164],
                            [1.870341807396979, 48.89557106134978],
                            [1.869844655939476, 48.89636940069622],
                            [1.868415110236178, 48.89869811179744],
                            [1.867753085932334, 48.89976015798868],
                            [1.867672718056363, 48.89989292341102],
                            [1.867235009858375, 48.90059886898659],
                            [1.86633874776849, 48.902047539353646],
                            [1.86575853402498, 48.902960629130874],
                            [1.865249796899448, 48.90367077059337],
                            [1.865173970170793, 48.90375499095625],
                            [1.865033313318742, 48.903914484420405],
                            [1.864851390144611, 48.90410977925254],
                            [1.864577294637015, 48.904386527911484],
                            [1.864166099684214, 48.904734652491186],
                            [1.863804546229426, 48.905026326013854],
                            [1.862979914862162, 48.905668601551],
                            [1.862412455513467, 48.90609251148615],
                            [1.861216833956546, 48.90686542982669],
                            [1.859416378378991, 48.90796764844396],
                            [1.859261366847702, 48.90805603040124],
                            [1.858042787614553, 48.90879464677143],
                            [1.857227537127738, 48.90930537596191],
                        ],
                    },
                },
                166: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.70857323368284, 1.8721225754551571],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01744",
                        "navette": 0,
                        "idrefliga": "A02172",
                        "shape_leng": 4084.99966675,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.85659206528713,
                            48.69309659121679,
                            1.890004563697985,
                            48.72191596105865,
                        ),
                        "coordinates": [
                            [1.85659206528713, 48.69309659121679],
                            [1.856715398503036, 48.69345196258986],
                            [1.856799946512059, 48.69369962214961],
                            [1.857277685985409, 48.69501099590093],
                            [1.857507784225903, 48.69551830749273],
                            [1.857753066602306, 48.69603948180251],
                            [1.858030526563277, 48.69653575647938],
                            [1.858262072372782, 48.696896444672134],
                            [1.858442917149364, 48.697161594401486],
                            [1.858730317708505, 48.69757590145742],
                            [1.859003393662899, 48.69796012582615],
                            [1.859244743253453, 48.69827997358976],
                            [1.859440144657987, 48.69851872870949],
                            [1.859750937344423, 48.69888292086132],
                            [1.860112396605303, 48.699299005778514],
                            [1.860648986307845, 48.69987049879539],
                            [1.861172491947406, 48.70039157634829],
                            [1.861697736142728, 48.70087398867113],
                            [1.862232750374959, 48.70133036004215],
                            [1.862781478892719, 48.701774196723605],
                            [1.864799002836341, 48.70335363345357],
                            [1.865029637383951, 48.70353264863516],
                            [1.865365446260445, 48.703796631668055],
                            [1.866569838035721, 48.70473956896716],
                            [1.867022941689387, 48.7051020537334],
                            [1.869610704020809, 48.70713140426907],
                            [1.87068369324005, 48.7079633431826],
                            [1.871297369540176, 48.70845236829666],
                            [1.872929590574994, 48.709732420126194],
                            [1.873113045264286, 48.70987705304943],
                            [1.875622239556932, 48.711846790073906],
                            [1.876220046429648, 48.71229885351404],
                            [1.876464352393001, 48.712477900387846],
                            [1.876649335188688, 48.71260634668252],
                            [1.879687442676669, 48.71472381395895],
                            [1.879841369904282, 48.71483234560751],
                            [1.881241773766145, 48.7157992943732],
                            [1.882713742400859, 48.71682316600738],
                            [1.883287686057122, 48.717222938365225],
                            [1.883992701473626, 48.71770686229569],
                            [1.884310062671973, 48.71792844860221],
                            [1.885294539118915, 48.71862031034604],
                            [1.885965690491573, 48.7190959940718],
                            [1.888508517925195, 48.720867321760046],
                            [1.890004563697985, 48.72191596105865],
                        ],
                    },
                },
                167: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M12",
                        "rer": 0,
                        "extcode": "100110012:12",
                        "geo_point_2d": [48.83503063630636, 2.2922410766228767],
                        "indice_lig": "12",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01382",
                        "navette": 0,
                        "idrefliga": "A01545",
                        "shape_leng": 834.037508321,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.288022141100325,
                            48.83244909914335,
                            2.296630340533544,
                            48.83730749276759,
                        ),
                        "coordinates": [
                            [2.288022141100325, 48.83244909914335],
                            [2.288252677402633, 48.8326011933349],
                            [2.288723477978069, 48.83291179314505],
                            [2.28886558877803, 48.83300834082818],
                            [2.290286727177951, 48.833973801627714],
                            [2.291448415703456, 48.83469140677358],
                            [2.292479855202144, 48.83532289069432],
                            [2.293153058082708, 48.835688888744365],
                            [2.293728569640646, 48.835975963406916],
                            [2.294358425262617, 48.836241539702456],
                            [2.295759303930777, 48.836865959778635],
                            [2.296476020811045, 48.83721761303035],
                            [2.296630340533544, 48.83730749276759],
                        ],
                    },
                },
                168: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M10",
                        "rer": 0,
                        "extcode": "100110010:10",
                        "geo_point_2d": [48.84531677689487, 2.2581854944662108],
                        "indice_lig": "10",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01380",
                        "navette": 0,
                        "idrefliga": "A01543",
                        "shape_leng": 506.004972487,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.254756719786218,
                            48.845227500732506,
                            2.261623492404885,
                            48.845378500435366,
                        ),
                        "coordinates": [
                            [2.261623492404885, 48.84524756545478],
                            [2.260908453096279, 48.845264422898296],
                            [2.257948221777687, 48.845337297795155],
                            [2.25634637547889, 48.845376699742694],
                            [2.256340933866544, 48.84537683319988],
                            [2.256117255218372, 48.845378500435366],
                            [2.255893727144803, 48.84537286530566],
                            [2.255670891885798, 48.84535994107764],
                            [2.255449300960836, 48.8453397590672],
                            [2.255229489305364, 48.84531236667963],
                            [2.255012002443456, 48.84527783297483],
                            [2.254756719786218, 48.845227500732506],
                        ],
                    },
                },
                169: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M10",
                        "rer": 0,
                        "extcode": "100110010:10",
                        "geo_point_2d": [48.84687803044527, 2.2719395508546283],
                        "indice_lig": "10",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01380",
                        "navette": 0,
                        "idrefliga": "A01543",
                        "shape_leng": 133.414408665,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.271115349613071,
                            48.846625048719645,
                            2.272763753316159,
                            48.847131008196236,
                        ),
                        "coordinates": [
                            [2.272763753316159, 48.847131008196236],
                            [2.271816089288167, 48.84684013744314],
                            [2.271115349613071, 48.846625048719645],
                        ],
                    },
                },
                170: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M9",
                        "rer": 0,
                        "extcode": "100110009:9",
                        "geo_point_2d": [48.87254958447499, 2.3362977386766595],
                        "indice_lig": "9",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01379",
                        "navette": 0,
                        "idrefliga": "A01542",
                        "shape_leng": 422.531048258,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.333479131845597,
                            48.872152352579874,
                            2.33911503790642,
                            48.872937657673795,
                        ),
                        "coordinates": [
                            [2.333479131845597, 48.872937657673795],
                            [2.334089658681054, 48.87285384040136],
                            [2.338068582821625, 48.87230749636527],
                            [2.33911503790642, 48.872152352579874],
                        ],
                    },
                },
                171: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M9",
                        "rer": 0,
                        "extcode": "100110009:9",
                        "geo_point_2d": [48.87183133824494, 2.341135894778504],
                        "indice_lig": "9",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01379",
                        "navette": 0,
                        "idrefliga": "A01542",
                        "shape_leng": 305.151186671,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.33911503790642,
                            48.87149773935003,
                            2.343154773075233,
                            48.872152352579874,
                        ),
                        "coordinates": [
                            [2.33911503790642, 48.872152352579874],
                            [2.340051785735736, 48.872013463764766],
                            [2.343154773075233, 48.87149773935003],
                        ],
                    },
                },
                172: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.98935751527942, 2.2458746664321008],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01863",
                        "navette": 0,
                        "idrefliga": "A02181",
                        "shape_leng": 1954.61314817,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.234276393996537,
                            48.98500470125915,
                            2.25747415725031,
                            48.99371348038584,
                        ),
                        "coordinates": [
                            [2.25747415725031, 48.98500470125915],
                            [2.256667529466798, 48.98530179983275],
                            [2.256537648249651, 48.98534937040701],
                            [2.256406397970248, 48.98539873895597],
                            [2.256324367152076, 48.98542925655962],
                            [2.25483957933873, 48.98598395673322],
                            [2.254752076836709, 48.98601716760732],
                            [2.254065722420399, 48.98627566499257],
                            [2.252697094129654, 48.986791752504],
                            [2.252152919385233, 48.98699548761377],
                            [2.250853987138239, 48.98748372667994],
                            [2.25052446527544, 48.98760757845762],
                            [2.250302957914854, 48.987691044437135],
                            [2.250069147044349, 48.987778097556905],
                            [2.248828968929537, 48.98824477512492],
                            [2.248735984251072, 48.98828247410205],
                            [2.248689496718009, 48.98829862493679],
                            [2.248644373466953, 48.988315676355626],
                            [2.248578741899453, 48.988339906642],
                            [2.248519944991161, 48.988362343427454],
                            [2.248182205336202, 48.9884897792397],
                            [2.247942915503344, 48.98857952129495],
                            [2.244431417603644, 48.98989778089434],
                            [2.244312450985003, 48.98994174964649],
                            [2.244241341042742, 48.98996956972559],
                            [2.244168866746831, 48.98999648911002],
                            [2.244036222252495, 48.9900476409717],
                            [2.243727181301108, 48.99016159795455],
                            [2.243554620207485, 48.99022882178484],
                            [2.242902227019158, 48.99047741455814],
                            [2.24162140823175, 48.990954603971424],
                            [2.239750755235367, 48.99166921656483],
                            [2.237898175127222, 48.99236001975328],
                            [2.23664981377814, 48.99283004478473],
                            [2.235958195596444, 48.99308036887799],
                            [2.234276393996537, 48.99371348038584],
                        ],
                    },
                },
                173: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.08353183889434, 2.2045051569201672],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "NR",
                        "navette": 0,
                        "idrefliga": "NR",
                        "shape_leng": 1497.22432397,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.200817247554296,
                            49.07769904281828,
                            2.207404910227873,
                            49.08930709608885,
                        ),
                        "coordinates": [
                            [2.200978026879316, 49.08930709608885],
                            [2.200858886040124, 49.08883668609218],
                            [2.200817247554296, 49.08852157256377],
                            [2.200820929914095, 49.08817832299847],
                            [2.200853268621624, 49.08786991070815],
                            [2.200922459442305, 49.087603808351226],
                            [2.200994258518992, 49.08738447030166],
                            [2.201099004649961, 49.08713369754419],
                            [2.201166459457293, 49.08700068428713],
                            [2.201291697610338, 49.08676522278638],
                            [2.201537793117673, 49.0863941134586],
                            [2.201673782621026, 49.086231505541384],
                            [2.201857852021466, 49.086010501543896],
                            [2.202091248430846, 49.085774267134724],
                            [2.20250567587162, 49.08542493572345],
                            [2.202788262577688, 49.085222929541395],
                            [2.203202412396381, 49.084972515524335],
                            [2.203746714512316, 49.08468807873599],
                            [2.203889287125589, 49.08461899980039],
                            [2.204205967789653, 49.084462892250194],
                            [2.204741984239535, 49.0842009230612],
                            [2.20509293213278, 49.08402776668637],
                            [2.205705814622024, 49.08368764427291],
                            [2.205907404134456, 49.08356107744532],
                            [2.206162568612107, 49.0833653263573],
                            [2.206356035657136, 49.08320277855845],
                            [2.206570185460174, 49.08298359839493],
                            [2.20679400128443, 49.082732955594714],
                            [2.206994628678089, 49.08244811295753],
                            [2.2071817069896, 49.082109298318024],
                            [2.207312689761099, 49.08175603227995],
                            [2.207382050865224, 49.08140809192987],
                            [2.207404910227873, 49.081043013116535],
                            [2.207375646480392, 49.08071654374962],
                            [2.207331194501543, 49.08043951790937],
                            [2.207211544546548, 49.08012643533654],
                            [2.207058986093821, 49.079833999087924],
                            [2.206790397969286, 49.079415533234695],
                            [2.206437036530973, 49.07896099924466],
                            [2.20594311432761, 49.078342636482795],
                            [2.205446725524735, 49.07769904281828],
                        ],
                    },
                },
                174: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.98940490744247, 2.3617927853946363],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01746",
                        "navette": 0,
                        "idrefliga": "A02173",
                        "shape_leng": 1756.98324336,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.353407245869684,
                            48.984315962065935,
                            2.368684562796334,
                            48.996006830493926,
                        ),
                        "coordinates": [
                            [2.353407245869684, 48.984315962065935],
                            [2.353757288256642, 48.98451021557755],
                            [2.360689271665839, 48.98834209199464],
                            [2.362765100830239, 48.98949561924234],
                            [2.363416078162131, 48.98985950816034],
                            [2.363817530110666, 48.990102106668836],
                            [2.364175590152148, 48.990330437599106],
                            [2.364544510621891, 48.99057780155343],
                            [2.364855575633539, 48.99080376191301],
                            [2.365184736257229, 48.99105826994945],
                            [2.365513909887416, 48.99132943366328],
                            [2.365922685925408, 48.991693368807674],
                            [2.366233809964462, 48.99200022371598],
                            [2.366505149146215, 48.992278536297285],
                            [2.366729466309284, 48.99252117097596],
                            [2.367008076768097, 48.99285420501942],
                            [2.36727223330656, 48.99319676052654],
                            [2.367489362082486, 48.993498877874025],
                            [2.368003310338213, 48.99431485299605],
                            [2.368191568426409, 48.994688358895914],
                            [2.368332785243835, 48.99500477160592],
                            [2.368466783972825, 48.9953378430455],
                            [2.368571835309858, 48.99563523045974],
                            [2.368669666441447, 48.99595165605619],
                            [2.368684562796334, 48.996006830493926],
                        ],
                    },
                },
                175: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.95374366552486, 2.2439538301797435],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01748",
                        "navette": 0,
                        "idrefliga": "A02174",
                        "shape_leng": 2255.43457812,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.231110035011993,
                            48.950304353547466,
                            2.25508371139436,
                            48.95603120205498,
                        ),
                        "coordinates": [
                            [2.25508371139436, 48.95101678180594],
                            [2.254921549225827, 48.95165221283468],
                            [2.254884998865097, 48.951906775811715],
                            [2.254856445777283, 48.95207975427657],
                            [2.254801844897676, 48.9523271671612],
                            [2.254707444005894, 48.952610239990086],
                            [2.254587760587532, 48.95288853767845],
                            [2.254464522583103, 48.953131142181334],
                            [2.254290649363522, 48.953407021537714],
                            [2.254120469110216, 48.953632935219936],
                            [2.253961202977405, 48.95381127083217],
                            [2.253838151234981, 48.953939664311726],
                            [2.253548660036974, 48.954213079124514],
                            [2.253244760135622, 48.95446030992415],
                            [2.252944518815264, 48.954678988977214],
                            [2.252655176735339, 48.9548596066055],
                            [2.252336937191794, 48.955035443504244],
                            [2.252018724767871, 48.95519462504646],
                            [2.251657158006386, 48.95535139126356],
                            [2.251205249525729, 48.955517610190945],
                            [2.250731694508429, 48.955662394495256],
                            [2.250312404539619, 48.95576676897383],
                            [2.24980640731436, 48.95586631893533],
                            [2.249304063103541, 48.95594207401254],
                            [2.248769234527907, 48.95599876826722],
                            [2.248281429064058, 48.956024567042306],
                            [2.247634683629114, 48.95603120205498],
                            [2.247013302793014, 48.955997405676825],
                            [2.246475057949377, 48.95594463758255],
                            [2.245951314722693, 48.9558657055799],
                            [2.245481786619101, 48.95577491731696],
                            [2.245052029120419, 48.955672261615085],
                            [2.244629528586005, 48.955552955828374],
                            [2.244199853611307, 48.955407469307055],
                            [2.243719681661203, 48.95521911322948],
                            [2.237629727357868, 48.95265145478149],
                            [2.235416993589458, 48.951719194728554],
                            [2.234146408152569, 48.95119222987754],
                            [2.233720456589484, 48.951025294111304],
                            [2.233247537452552, 48.950863070829904],
                            [2.232691552572382, 48.950688876011085],
                            [2.232182473393724, 48.950545651828534],
                            [2.231550585693242, 48.95039279475235],
                            [2.231110035011993, 48.950304353547466],
                        ],
                    },
                },
                176: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.94166787115946, 2.150760739942237],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 1284.07893555,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.144558756800802,
                            48.93773606341459,
                            2.157086496469818,
                            48.945795934518046,
                        ),
                        "coordinates": [
                            [2.144558756800802, 48.945795934518046],
                            [2.146753189057277, 48.94439103172525],
                            [2.14745577502546, 48.94391394942269],
                            [2.147933873262263, 48.94357449457276],
                            [2.148459092094536, 48.94318990649488],
                            [2.148973504613955, 48.942795781350526],
                            [2.149404596685325, 48.942463379849556],
                            [2.149911625986352, 48.94210730967307],
                            [2.150342526973852, 48.9418224908282],
                            [2.150766182551382, 48.94154241953934],
                            [2.151349105221197, 48.941169810212344],
                            [2.153087010268662, 48.940044806929784],
                            [2.153651740968178, 48.93969832985609],
                            [2.154545805962058, 48.9391715445828],
                            [2.155276891353209, 48.93876107928797],
                            [2.157086496469818, 48.93773606341459],
                        ],
                    },
                },
                177: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.9447488719057, 2.0671612677018625],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01748",
                        "navette": 0,
                        "idrefliga": "A02174",
                        "shape_leng": 4574.55828958,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.041072289675926,
                            48.93326540612854,
                            2.093521901580612,
                            48.95540224453111,
                        ),
                        "coordinates": [
                            [2.041072289675926, 48.93326540612854],
                            [2.045668504587519, 48.93529966502182],
                            [2.048460294797077, 48.93653211266265],
                            [2.053997431953846, 48.938980034483606],
                            [2.063909453931477, 48.943358356350146],
                            [2.069404894499701, 48.94578163311858],
                            [2.072525787399531, 48.9471641609139],
                            [2.075109865164508, 48.94830505866521],
                            [2.087559970412699, 48.95376495153617],
                            [2.088475704144185, 48.9541523995623],
                            [2.089216048741711, 48.95442352812452],
                            [2.089784880943044, 48.954616830409066],
                            [2.09041982801554, 48.95480379054842],
                            [2.091033257892704, 48.954959769637476],
                            [2.091639584520061, 48.955091935833345],
                            [2.092029394089491, 48.955171289332526],
                            [2.092321810369193, 48.95521950257172],
                            [2.092971637236077, 48.95532320200608],
                            [2.093521901580612, 48.95540224453111],
                        ],
                    },
                },
                178: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.986643147363, 1.7091422868963677],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 1107.77054667,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.703016134167223,
                            48.983654507541004,
                            1.715210986447546,
                            48.989502508030505,
                        ),
                        "coordinates": [
                            [1.715210986447546, 48.983654507541004],
                            [1.714876713955381, 48.983788316553415],
                            [1.713600965108449, 48.98433101806053],
                            [1.712641222925728, 48.984754079445864],
                            [1.712284705578705, 48.98493058933371],
                            [1.711411070835274, 48.98540407886332],
                            [1.708445222531689, 48.9871303023471],
                            [1.707197842322636, 48.987799197118015],
                            [1.706378210456435, 48.98818807925704],
                            [1.705757817330407, 48.98845115279417],
                            [1.704968622676812, 48.98871963626297],
                            [1.70427599037051, 48.9889759579842],
                            [1.703016134167223, 48.989502508030505],
                        ],
                    },
                },
                179: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [49.02902212266669, 2.3498710263222318],
                        "indice_lig": "TER",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01746",
                        "navette": 0,
                        "idrefliga": "A02173",
                        "shape_leng": 2186.61970193,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.336829689836827,
                            49.02320637806201,
                            2.362222981011115,
                            49.03297204677151,
                        ),
                        "coordinates": [
                            [2.362222981011115, 49.02320637806201],
                            [2.362062785664122, 49.023299049476606],
                            [2.354325519588647, 49.02752619658293],
                            [2.35180402234732, 49.0289018103816],
                            [2.351080465120606, 49.029289735538576],
                            [2.350447341166052, 49.02962054047568],
                            [2.349973391976561, 49.029849011707185],
                            [2.349452396514655, 49.03007272834155],
                            [2.348963955802607, 49.03026312735066],
                            [2.348392289277997, 49.030463051266445],
                            [2.347867649231807, 49.030627276676256],
                            [2.347357476394044, 49.030767706288785],
                            [2.346894336240289, 49.03088671417556],
                            [2.346333493604799, 49.031008109096796],
                            [2.345736464135617, 49.03113426156674],
                            [2.343619700272693, 49.03157458345275],
                            [2.337526101484952, 49.03282869248634],
                            [2.336829689836827, 49.03297204677151],
                        ],
                    },
                },
                180: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M2",
                        "rer": 0,
                        "extcode": "100110002:2",
                        "geo_point_2d": [48.878650740007885, 2.300900760156482],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01372",
                        "navette": 0,
                        "idrefliga": "A01535",
                        "shape_leng": 408.652610936,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.298310373761529,
                            48.87797270141955,
                            2.303528725370108,
                            48.879214134245586,
                        ),
                        "coordinates": [
                            [2.298310373761529, 48.87797270141955],
                            [2.298430598817582, 48.87803930781454],
                            [2.298557573832707, 48.87810022124744],
                            [2.298690683767284, 48.87815514401097],
                            [2.298829276348082, 48.878203808759025],
                            [2.298972679817809, 48.87824597681242],
                            [2.299090086321498, 48.87827420652144],
                            [2.29912019193179, 48.878281445289694],
                            [2.299129264600565, 48.87828337802444],
                            [2.303528725370108, 48.879214134245586],
                        ],
                    },
                },
                181: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M2",
                        "rer": 0,
                        "extcode": "100110002:2",
                        "geo_point_2d": [48.88234000676494, 2.3407177164605466],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01372",
                        "navette": 0,
                        "idrefliga": "A01535",
                        "shape_leng": 521.013505016,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.337294790567405,
                            48.88200505537663,
                            2.344130633722553,
                            48.88286864756839,
                        ),
                        "coordinates": [
                            [2.337294790567405, 48.88239015067237],
                            [2.337532538668095, 48.882336640488255],
                            [2.338558167921224, 48.8821737315106],
                            [2.339487057216237, 48.88202617936634],
                            [2.33979203199945, 48.88200505537663],
                            [2.340077404350079, 48.882031422387364],
                            [2.341532769084847, 48.88235428883831],
                            [2.344130633722553, 48.88286864756839],
                        ],
                    },
                },
                182: {
                    "attributes": {
                        "reseau": "LA VERRIERE-LA DEFENSE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE U",
                        "rer": 0,
                        "extcode": "800:U",
                        "geo_point_2d": [48.819380272260695, 2.195423262875548],
                        "indice_lig": "U",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01741",
                        "navette": 0,
                        "idrefliga": "A01855",
                        "shape_leng": 1940.22611855,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.188259860000294,
                            48.81257171717766,
                            2.200721257947835,
                            48.8272387754095,
                        ),
                        "coordinates": [
                            [2.188259860000294, 48.81257171717766],
                            [2.18977173089294, 48.81447792661163],
                            [2.189817854884192, 48.814536438585144],
                            [2.189880267957558, 48.814612058709386],
                            [2.190284571652338, 48.81511257772727],
                            [2.190527497518925, 48.81538986762242],
                            [2.190691712957203, 48.81557712747344],
                            [2.190853279230943, 48.815739204791704],
                            [2.190918445474538, 48.81580583450609],
                            [2.191009444196634, 48.81588598697984],
                            [2.191078696426578, 48.81595262175729],
                            [2.191165605292646, 48.81603456771417],
                            [2.191514647029684, 48.816348861240286],
                            [2.191794485413418, 48.81658033139004],
                            [2.192138224509382, 48.81684785422946],
                            [2.192414098347767, 48.81703975029532],
                            [2.192805540364206, 48.81729474083723],
                            [2.192855834424884, 48.81732627963286],
                            [2.192893897575333, 48.81734880930482],
                            [2.193312595117685, 48.817598437267954],
                            [2.193729974448492, 48.817834572803044],
                            [2.194971361017204, 48.81850069086825],
                            [2.196381503666261, 48.81923166825301],
                            [2.196910272897255, 48.81954639257153],
                            [2.197231024107471, 48.819776987004445],
                            [2.197574853164364, 48.820040767528695],
                            [2.197934923038173, 48.82033167379007],
                            [2.198174690283779, 48.82055047437471],
                            [2.198313907605619, 48.820678356718965],
                            [2.198752519384207, 48.82113302449515],
                            [2.198838023237781, 48.82123834372864],
                            [2.199055191565388, 48.82150119528909],
                            [2.199333237856536, 48.821911601361165],
                            [2.199532563556481, 48.82222658902717],
                            [2.19958265460223, 48.82233456299452],
                            [2.1997298831254, 48.82262274037754],
                            [2.199854742676403, 48.82293380849898],
                            [2.199943941533043, 48.82317547081763],
                            [2.200026192789215, 48.82348347348516],
                            [2.200124394198703, 48.82392693510873],
                            [2.200140507601999, 48.82401058753482],
                            [2.200155270760345, 48.824089741149876],
                            [2.200267917081906, 48.82472926231235],
                            [2.200305389839422, 48.82497031358611],
                            [2.200478604419895, 48.82587429509449],
                            [2.200486644086928, 48.82592286563294],
                            [2.200498723526633, 48.82598762794323],
                            [2.200530897228218, 48.82617561531387],
                            [2.20059528646788, 48.826535403866295],
                            [2.200655619224576, 48.826885294333515],
                            [2.200674388675792, 48.82699412916455],
                            [2.20068917234138, 48.82706698869271],
                            [2.200721257947835, 48.8272387754095],
                        ],
                    },
                },
                183: {
                    "attributes": {
                        "reseau": "RER A",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER A",
                        "rer": 1,
                        "extcode": "810:A",
                        "geo_point_2d": [48.84552101618076, 2.4144114236427296],
                        "indice_lig": "A",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01742",
                        "navette": 0,
                        "idrefliga": "A01856",
                        "shape_leng": 2995.39739741,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.395823588826127,
                            48.84363500495395,
                            2.433299716281995,
                            48.84823711041019,
                        ),
                        "coordinates": [
                            [2.433299716281995, 48.84730835944483],
                            [2.432718704425602, 48.84732866082917],
                            [2.432394436625349, 48.847340623021],
                            [2.431210445851776, 48.847382975904765],
                            [2.430809879368417, 48.847397695391706],
                            [2.430503317315531, 48.847406041259134],
                            [2.430263509793383, 48.84740893580813],
                            [2.429962384388675, 48.847410081687045],
                            [2.429650341389914, 48.84740224240014],
                            [2.429362815162821, 48.84738898732365],
                            [2.429120892250702, 48.84737550758445],
                            [2.428751663563904, 48.847341542997114],
                            [2.428395222713234, 48.847297142926465],
                            [2.427881528429491, 48.84722256040823],
                            [2.427392507068644, 48.84713158345431],
                            [2.427009494461212, 48.847049086798805],
                            [2.426658946025194, 48.846975127349715],
                            [2.426202327042903, 48.84685699552397],
                            [2.425682922279799, 48.84670464776007],
                            [2.425237064480452, 48.84655366822894],
                            [2.424901578713412, 48.84643258238624],
                            [2.424390749640624, 48.84623168348388],
                            [2.424096337578732, 48.846094859096716],
                            [2.423877695368279, 48.84599366700637],
                            [2.423693682189064, 48.845903867950895],
                            [2.423509669634036, 48.84581406950443],
                            [2.423334309173288, 48.84572426390438],
                            [2.422741141323987, 48.845432053258214],
                            [2.422254093904951, 48.84521399571047],
                            [2.421221541653886, 48.84473651905528],
                            [2.420587022168888, 48.84444704897725],
                            [2.420146630720783, 48.84426302068311],
                            [2.419697930336349, 48.84407962223682],
                            [2.419067992964417, 48.84385068731212],
                            [2.418798268964133, 48.843780267145824],
                            [2.418417271020609, 48.84370427536515],
                            [2.418079126537894, 48.84366497228829],
                            [2.417848007174963, 48.84364818914995],
                            [2.417344358940576, 48.84363823929585],
                            [2.416829342640422, 48.84363500495395],
                            [2.416112734727961, 48.84366608167363],
                            [2.415269512052094, 48.84375749185558],
                            [2.414930317714806, 48.84379549417043],
                            [2.414595209315051, 48.84383349303501],
                            [2.413942700569974, 48.843907677060635],
                            [2.412302562880426, 48.844092228128055],
                            [2.411693621880217, 48.8441492833327],
                            [2.411080591702227, 48.844206339594216],
                            [2.410286376090954, 48.84428149412267],
                            [2.408840922923079, 48.84437953810553],
                            [2.407004424842043, 48.84447241085893],
                            [2.406231946435997, 48.84450975367717],
                            [2.405704699739519, 48.84453705184664],
                            [2.404798761170446, 48.844622128407906],
                            [2.404128556046331, 48.84472684166804],
                            [2.40365931489003, 48.84481358657325],
                            [2.403239958311115, 48.84490967097375],
                            [2.402965799013999, 48.84500034498978],
                            [2.402546510586614, 48.845149670067435],
                            [2.40229658457625, 48.84526695048941],
                            [2.401764551584505, 48.84557074581143],
                            [2.401055086836175, 48.84603256485446],
                            [2.399620100754327, 48.84692454650537],
                            [2.399248383412272, 48.84713338316269],
                            [2.398870620387838, 48.84731875918163],
                            [2.398402945195865, 48.847510691479556],
                            [2.397857907971638, 48.847706977594974],
                            [2.397396174339602, 48.84785560494727],
                            [2.396860860964621, 48.84800606841567],
                            [2.39635411248072, 48.84811874515271],
                            [2.39634866163159, 48.84811874822868],
                            [2.395823588826127, 48.84823711041019],
                        ],
                    },
                },
                184: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.797580349605624, 2.1406320310669837],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1796.83912,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.129043867370256,
                            48.796178314273135,
                            2.152378660253372,
                            48.80021557813598,
                        ),
                        "coordinates": [
                            [2.152378660253372, 48.79652818117568],
                            [2.152338963680592, 48.79652271537383],
                            [2.151471461789258, 48.796402340222436],
                            [2.150481531964946, 48.79627699980382],
                            [2.149919278022563, 48.796234597562176],
                            [2.149386970964321, 48.79620382486479],
                            [2.148911648288609, 48.796186386585646],
                            [2.148346254825638, 48.796178314273135],
                            [2.147978893252051, 48.796182464964964],
                            [2.147139728577896, 48.79619058794475],
                            [2.14674351935253, 48.7962042040603],
                            [2.146242795216752, 48.79623667880198],
                            [2.14585733505846, 48.79626458503123],
                            [2.145259279419891, 48.79632068578173],
                            [2.144711615802071, 48.796384005867424],
                            [2.144297248504016, 48.796435651809674],
                            [2.143875642409222, 48.79649680172298],
                            [2.143468432092114, 48.796560354944475],
                            [2.143108038006966, 48.79662398431525],
                            [2.142707980272671, 48.796699442413846],
                            [2.142297099246691, 48.79677963970738],
                            [2.141752812458423, 48.796897676941086],
                            [2.141194061865006, 48.79702996254319],
                            [2.140386158644989, 48.797244135999144],
                            [2.13942061427876, 48.79750259791235],
                            [2.137527869103348, 48.798009194274506],
                            [2.136514029104777, 48.79828079712656],
                            [2.135489978018193, 48.7985608854198],
                            [2.134833786095137, 48.79873646316356],
                            [2.134247807910476, 48.79889459527487],
                            [2.133292523448711, 48.79915188493529],
                            [2.133000893591115, 48.799230500080526],
                            [2.132544631484282, 48.79934069288383],
                            [2.131751185260367, 48.79951309439427],
                            [2.131331777615874, 48.79961329329602],
                            [2.130541404082334, 48.799816001623284],
                            [2.129043867370256, 48.80021557813598],
                        ],
                    },
                },
                185: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T6",
                        "rer": 0,
                        "extcode": "100112016:T6",
                        "geo_point_2d": [48.78329741721353, 2.1782347255209875],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01794",
                        "navette": 0,
                        "idrefliga": "A02149",
                        "shape_leng": 567.573521082,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.176835487870611,
                            48.7819866725001,
                            2.180493750928926,
                            48.78512141332815,
                        ),
                        "coordinates": [
                            [2.178798590270473, 48.78512141332815],
                            [2.178444700311648, 48.78491614730715],
                            [2.177078738392514, 48.78412743070845],
                            [2.176976139852545, 48.78405675936703],
                            [2.176916525412981, 48.78400066335265],
                            [2.176859341153883, 48.7839274490461],
                            [2.176840933836507, 48.783861641513276],
                            [2.176835487870611, 48.78379592326814],
                            [2.176836366270744, 48.78374024303342],
                            [2.176847934928273, 48.78369177610332],
                            [2.176872464831643, 48.78364339846035],
                            [2.176905750406229, 48.78358794146537],
                            [2.176949814870061, 48.78353398699981],
                            [2.177026466533371, 48.783468834232664],
                            [2.177170811033188, 48.78335845664294],
                            [2.178412795140476, 48.78242319679481],
                            [2.178541560939034, 48.78234126723295],
                            [2.178624286169174, 48.78230185633762],
                            [2.17868729614171, 48.7822794439862],
                            [2.178767635409114, 48.78225429502489],
                            [2.178847883369435, 48.78223485675607],
                            [2.180189777209781, 48.78202957393656],
                            [2.180493750928926, 48.7819866725001],
                        ],
                    },
                },
                186: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T6",
                        "rer": 0,
                        "extcode": "100112016:T6",
                        "geo_point_2d": [48.797160266079445, 2.277311330678508],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01794",
                        "navette": 0,
                        "idrefliga": "A02149",
                        "shape_leng": 911.019161344,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.272650344658386,
                            48.79446888451292,
                            2.281951320169448,
                            48.79988738317761,
                        ),
                        "coordinates": [
                            [2.272650344658386, 48.79446888451292],
                            [2.273372932701242, 48.79489055701269],
                            [2.274214412245569, 48.79537636693466],
                            [2.275184922355289, 48.79590935724733],
                            [2.276101458396386, 48.7964396334752],
                            [2.277003656229638, 48.79696624493579],
                            [2.277925534820534, 48.79750367735999],
                            [2.278356136673652, 48.79775257582172],
                            [2.279640716298814, 48.79850278491174],
                            [2.280162361769861, 48.79881171725014],
                            [2.280667672862257, 48.799130066381984],
                            [2.280987333394884, 48.799328313526814],
                            [2.281546600126762, 48.79965293285739],
                            [2.281951320169448, 48.79988738317761],
                        ],
                    },
                },
                187: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T6",
                        "rer": 0,
                        "extcode": "100112016:T6",
                        "geo_point_2d": [48.8020227985797, 2.285518024189754],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01794",
                        "navette": 0,
                        "idrefliga": "A02149",
                        "shape_leng": 709.325520529,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.281951320169448,
                            48.79988738317761,
                            2.289057253599707,
                            48.804204938303016,
                        ),
                        "coordinates": [
                            [2.281951320169448, 48.79988738317761],
                            [2.282641957248953, 48.800286557132466],
                            [2.283442579983374, 48.80074349747637],
                            [2.283903852273689, 48.80099255788442],
                            [2.284385941115677, 48.80130004391047],
                            [2.285553823215842, 48.80203520934738],
                            [2.286541476660883, 48.80264911454797],
                            [2.28752196352453, 48.80326177849352],
                            [2.287929245981885, 48.803510500747265],
                            [2.288472989144604, 48.8038450631493],
                            [2.289057253599707, 48.804204938303016],
                        ],
                    },
                },
                188: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T6",
                        "rer": 0,
                        "extcode": "100112016:T6",
                        "geo_point_2d": [48.80572325035524, 2.2915530797350665],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01794",
                        "navette": 0,
                        "idrefliga": "A02149",
                        "shape_leng": 495.595321437,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.289057253599707,
                            48.804204938303016,
                            2.294091244318829,
                            48.807169846835585,
                        ),
                        "coordinates": [
                            [2.289057253599707, 48.804204938303016],
                            [2.289624275318297, 48.804562879492096],
                            [2.290267237472113, 48.804966482411764],
                            [2.291269168121019, 48.80559827872177],
                            [2.291789265244971, 48.80589881904611],
                            [2.294091244318829, 48.807169846835585],
                        ],
                    },
                },
                189: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M2",
                        "rer": 0,
                        "extcode": "100110002:2",
                        "geo_point_2d": [48.88080897399949, 2.3123125701967915],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01372",
                        "navette": 0,
                        "idrefliga": "A01535",
                        "shape_leng": 427.147133518,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.309451167991542,
                            48.8804494561385,
                            2.315176626220464,
                            48.881150028474686,
                        ),
                        "coordinates": [
                            [2.309451167991542, 48.8804494561385],
                            [2.309598557889442, 48.88047487696105],
                            [2.310015000027064, 48.88053925192658],
                            [2.310138996539572, 48.88055699722095],
                            [2.311925832724022, 48.88076259160808],
                            [2.313026821579926, 48.88089330230174],
                            [2.314337119452803, 48.881048856070024],
                            [2.314655633326033, 48.88108666672566],
                            [2.31495537595022, 48.8811222484903],
                            [2.315176626220464, 48.881150028474686],
                        ],
                    },
                },
                190: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [49.14258121193363, 1.9410021448726438],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 4610.5275496,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.936404406282517,
                            49.12345185404933,
                            1.949332680280041,
                            49.16267058077503,
                        ),
                        "coordinates": [
                            [1.949332680280041, 49.12345185404933],
                            [1.949185475917967, 49.12378430761103],
                            [1.949104582604222, 49.12396569001574],
                            [1.94906001725428, 49.12405726641162],
                            [1.949008475131125, 49.12416500562504],
                            [1.948961127224009, 49.12426196888726],
                            [1.948899668364135, 49.12441104182411],
                            [1.948677644142843, 49.12494086837261],
                            [1.948354212597838, 49.125645712108835],
                            [1.947911904182227, 49.126655008666965],
                            [1.947649598670639, 49.12725124352399],
                            [1.947221212344662, 49.12822910966549],
                            [1.947170995731967, 49.12834134977251],
                            [1.946874172548261, 49.12896804154083],
                            [1.946639048125813, 49.12939342870717],
                            [1.946366049974775, 49.12980084821339],
                            [1.946088942919607, 49.13018479864618],
                            [1.945918705255562, 49.13039734908229],
                            [1.945698842510051, 49.13064660097523],
                            [1.945567556038215, 49.130785541848205],
                            [1.945383795623346, 49.130974664694975],
                            [1.945060650715532, 49.13128651195902],
                            [1.944233272120679, 49.132105629669866],
                            [1.943425187274626, 49.13290772130572],
                            [1.942731826031594, 49.13358430159307],
                            [1.942683466858274, 49.133633596070055],
                            [1.941559174675724, 49.13472505688229],
                            [1.940799244166007, 49.135493123162135],
                            [1.940462892353715, 49.13590653194088],
                            [1.939991773709939, 49.13654396173729],
                            [1.939794055794995, 49.13686703029378],
                            [1.939675695066615, 49.13708294663929],
                            [1.93950206860149, 49.137450876604255],
                            [1.939303422180774, 49.13790029980681],
                            [1.939171986740406, 49.13828101745344],
                            [1.939067200120823, 49.138692180723424],
                            [1.938971188976278, 49.13921163345045],
                            [1.938952480858631, 49.139322180491234],
                            [1.938907469990834, 49.139975803965385],
                            [1.938902856777726, 49.140378667417416],
                            [1.938882412396459, 49.14138579397961],
                            [1.938871946518622, 49.141834500165665],
                            [1.938873077029986, 49.142374973166376],
                            [1.938859597047989, 49.14302780627577],
                            [1.938847749566484, 49.14381823618507],
                            [1.938834485755011, 49.14444409105921],
                            [1.938827702825857, 49.14545666062833],
                            [1.938826732247982, 49.14557716147961],
                            [1.93882548648793, 49.145731834112986],
                            [1.938824943604575, 49.14579927771332],
                            [1.938818433317541, 49.14609691821341],
                            [1.93881922500777, 49.14616886393916],
                            [1.93881191282284, 49.14656632148197],
                            [1.938807807931568, 49.14724616512458],
                            [1.938834359853648, 49.14769410080937],
                            [1.938896987940069, 49.1480882036881],
                            [1.93898727952948, 49.14845182705083],
                            [1.939157369190831, 49.14895061918455],
                            [1.939222793991834, 49.149110044650826],
                            [1.939279729943177, 49.14924780658754],
                            [1.939480091837816, 49.14973321365721],
                            [1.939726476201954, 49.15029252129591],
                            [1.939901089203664, 49.15074186729888],
                            [1.940015729817905, 49.151147840178965],
                            [1.940038032842936, 49.15127291784952],
                            [1.9400786826006, 49.151503274961016],
                            [1.940106121473767, 49.15184239919653],
                            [1.940090758375393, 49.15221914541746],
                            [1.940038833771533, 49.152568400853],
                            [1.940006303902632, 49.152708090427254],
                            [1.939941667231574, 49.15293449354225],
                            [1.939897976356676, 49.153066786359105],
                            [1.939816421080084, 49.153260465964536],
                            [1.93969488393565, 49.15354152148326],
                            [1.939603111357302, 49.15370127590263],
                            [1.939304644659973, 49.15416067566739],
                            [1.939045589120717, 49.154492513571384],
                            [1.938764549520273, 49.1547919936153],
                            [1.938528400879658, 49.15504018217532],
                            [1.938217300127178, 49.15536374377609],
                            [1.937752709808606, 49.155847741863944],
                            [1.937322992368784, 49.156343873220585],
                            [1.936916294485169, 49.15701380522366],
                            [1.936758771024738, 49.157363352595596],
                            [1.936655536489487, 49.15765551197302],
                            [1.936572553495464, 49.1579080242288],
                            [1.936484650957162, 49.158275543933904],
                            [1.936432627481818, 49.15869027532295],
                            [1.936424846505528, 49.15880445730658],
                            [1.936420353412215, 49.158851204604794],
                            [1.936411682941337, 49.1589060306748],
                            [1.936404406282517, 49.15929629397013],
                            [1.936499035833846, 49.15997108596125],
                            [1.936542310067271, 49.160214941894736],
                            [1.936678172214937, 49.16087818725432],
                            [1.936690105717014, 49.16092858799794],
                            [1.936700645806429, 49.16098168285089],
                            [1.936716525157527, 49.16105278163155],
                            [1.936745649107598, 49.16118148045347],
                            [1.936770523474651, 49.161327250603144],
                            [1.936840510387389, 49.16165932932405],
                            [1.936908906882405, 49.16235741100266],
                            [1.936911337535203, 49.16239608835169],
                            [1.936916370461952, 49.16245186157214],
                            [1.936928635785827, 49.16267058077503],
                        ],
                    },
                },
                191: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.80738791345056, 2.973101704150685],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 3429.44115718,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.953730383101934,
                            48.80417686931555,
                            2.993109893419177,
                            48.81077532178037,
                        ),
                        "coordinates": [
                            [2.993109893419177, 48.80865396493307],
                            [2.990709606822247, 48.80940829284611],
                            [2.990089916073384, 48.809602498275076],
                            [2.989480847436489, 48.80978838952263],
                            [2.988864473045204, 48.809968624489386],
                            [2.988245197662251, 48.810114631786256],
                            [2.987891785180404, 48.81018679249689],
                            [2.987520887540429, 48.8102373648395],
                            [2.987134761606885, 48.81028226034113],
                            [2.986725759013785, 48.81031045907051],
                            [2.986282833452384, 48.81032480779425],
                            [2.985882470611465, 48.81031517942641],
                            [2.985567661028314, 48.81029920161439],
                            [2.985251696674947, 48.81026970637737],
                            [2.984839242971863, 48.810212568924996],
                            [2.984445712495797, 48.81015364008926],
                            [2.983948100423079, 48.81005212669939],
                            [2.9834130139531, 48.8099052576863],
                            [2.982975192781956, 48.80975783445286],
                            [2.982569558244773, 48.80958996827341],
                            [2.98214746043456, 48.80939256149227],
                            [2.981732746472705, 48.80915865652677],
                            [2.981419358713379, 48.808970161919746],
                            [2.980968173304679, 48.80861278717678],
                            [2.980576216825366, 48.80826907973069],
                            [2.980243498359322, 48.807957883569],
                            [2.979807976707063, 48.80754935559512],
                            [2.979513852367254, 48.80730040845847],
                            [2.979128223652701, 48.80700753241476],
                            [2.978627149519647, 48.806701028033835],
                            [2.978246420167149, 48.80650805630155],
                            [2.977949275618639, 48.80637172165721],
                            [2.977540134121476, 48.80620984049273],
                            [2.977210881022343, 48.806097477614834],
                            [2.976784224105451, 48.80597376298629],
                            [2.976310834413202, 48.80585744741021],
                            [2.975826671705476, 48.805743569536304],
                            [2.974898575063514, 48.80555078891234],
                            [2.973406135639297, 48.80521019887229],
                            [2.972597936154589, 48.805036644479415],
                            [2.971795708153195, 48.80486081691203],
                            [2.971177521615658, 48.80471782280691],
                            [2.97073312389193, 48.80461322058398],
                            [2.970252799946781, 48.80451595465856],
                            [2.969653402942331, 48.80440269023666],
                            [2.969180558675533, 48.80432679254418],
                            [2.968675390323818, 48.80425821072068],
                            [2.968238960155719, 48.80421304017145],
                            [2.967870145847296, 48.804188532897285],
                            [2.967521092309976, 48.80417812197487],
                            [2.967035392795515, 48.80417686931555],
                            [2.966628273824733, 48.804200143389494],
                            [2.966092484607458, 48.80424394268387],
                            [2.96553520449233, 48.804320388350625],
                            [2.964881026457769, 48.80443859637909],
                            [2.964375535558804, 48.80455789927259],
                            [2.96383358011103, 48.80472307806971],
                            [2.963288209296099, 48.80491910506867],
                            [2.962753187627467, 48.80513787764479],
                            [2.96221627516754, 48.80542320627935],
                            [2.961768272268781, 48.80568940898927],
                            [2.961463861820348, 48.80589497100491],
                            [2.960975800883497, 48.80627715196083],
                            [2.9600237910985, 48.80712051363151],
                            [2.959656097805605, 48.80743997880412],
                            [2.959138959974744, 48.807875035101695],
                            [2.958687671282343, 48.808280720692466],
                            [2.958352074980656, 48.80855504117014],
                            [2.957948871790213, 48.808867499395575],
                            [2.957483738092628, 48.80918084252058],
                            [2.957087460944171, 48.809419053560035],
                            [2.956658508288335, 48.809664112603315],
                            [2.956234993310772, 48.80987775025719],
                            [2.95570950477239, 48.81010428231028],
                            [2.955219071460242, 48.810301442212925],
                            [2.954702600852694, 48.81047620428591],
                            [2.954203500236609, 48.81064508445913],
                            [2.953730383101934, 48.81077532178037],
                        ],
                    },
                },
                192: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.543401472036884, 2.0975435985117445],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 4563.09665636,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.069381524887472,
                            48.535806509243706,
                            2.125707269059876,
                            48.551091975575105,
                        ),
                        "coordinates": [
                            [2.069381524887472, 48.535806509243706],
                            [2.069759543359357, 48.535998299504776],
                            [2.070460925418069, 48.536369885165314],
                            [2.070989667570149, 48.536651883101214],
                            [2.072040039916783, 48.53720871623102],
                            [2.073273757490746, 48.5378560219729],
                            [2.07383404555529, 48.538140458443806],
                            [2.074244342878502, 48.5383329422697],
                            [2.074504543504812, 48.53845346124114],
                            [2.074882417699546, 48.53861255718317],
                            [2.075520628197743, 48.53886718701092],
                            [2.076148916434266, 48.53910180412147],
                            [2.076584528721693, 48.539252699498405],
                            [2.077142904990033, 48.53942885759285],
                            [2.077816578558207, 48.53962026619161],
                            [2.078492848664502, 48.53979502098793],
                            [2.07918925769334, 48.539956493749614],
                            [2.079885784087626, 48.540096310235015],
                            [2.080594929150033, 48.54022116316257],
                            [2.081259068524918, 48.54031926103049],
                            [2.082103700714306, 48.54043608076878],
                            [2.082938309794534, 48.54055120683898],
                            [2.083775407841583, 48.54067132830402],
                            [2.084610016941602, 48.54078810776433],
                            [2.085449655022675, 48.540903226017186],
                            [2.086294287222878, 48.54102334529376],
                            [2.087121402124146, 48.541136758602526],
                            [2.087963534321341, 48.54125686024295],
                            [2.088803187270259, 48.54137195477327],
                            [2.089637837299403, 48.541485365922625],
                            [2.090477481826369, 48.54160377798841],
                            [2.091289542246929, 48.54172212442475],
                            [2.092126727902933, 48.54183219167525],
                            [2.092961376831942, 48.54194890973271],
                            [2.093806044482454, 48.542068972864186],
                            [2.094630588693342, 48.54220231167277],
                            [2.095462530899476, 48.54236230816707],
                            [2.096279439256296, 48.542520601194106],
                            [2.097096303734741, 48.542688882096584],
                            [2.098923014614802, 48.543060805047304],
                            [2.105237765577978, 48.544356312859044],
                            [2.106871638908124, 48.54469107235334],
                            [2.109898878629026, 48.545310074744734],
                            [2.110374998751922, 48.54541262325007],
                            [2.11083602775469, 48.545525130891],
                            [2.111289473372245, 48.545650946541386],
                            [2.111735345169215, 48.54578840336501],
                            [2.112103473540647, 48.54592237318674],
                            [2.112531692645639, 48.546081444263166],
                            [2.112944775749895, 48.54626046947401],
                            [2.113340272653671, 48.54644611999209],
                            [2.113728165332595, 48.546650075415435],
                            [2.114090970456488, 48.54685564545722],
                            [2.114456218741776, 48.547076208413365],
                            [2.114808930623826, 48.547296747042324],
                            [2.115098771644708, 48.547477918343304],
                            [2.115589080466254, 48.547780126908684],
                            [2.115918661708137, 48.54798220358367],
                            [2.116650168299203, 48.54842788229872],
                            [2.117113052054024, 48.54869859196749],
                            [2.117688679037721, 48.54900282726212],
                            [2.118086738149973, 48.54918513555765],
                            [2.1185074053828, 48.549360823372425],
                            [2.118945678752854, 48.54952655183586],
                            [2.119381549984429, 48.54966895550533],
                            [2.119814972604467, 48.549798029663535],
                            [2.120266013129358, 48.5499138112294],
                            [2.120729628888395, 48.550022954037395],
                            [2.121193283228171, 48.55012376579669],
                            [2.122007822832604, 48.550298523815634],
                            [2.12363441164031, 48.55064801806724],
                            [2.125268550437647, 48.55099750216395],
                            [2.125707269059876, 48.551091975575105],
                        ],
                    },
                },
                193: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.08353183889434, 2.2045051569201672],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1497.22432397,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.200817247554296,
                            49.07769904281828,
                            2.207404910227873,
                            49.08930709608885,
                        ),
                        "coordinates": [
                            [2.200978026879316, 49.08930709608885],
                            [2.200858886040124, 49.08883668609218],
                            [2.200817247554296, 49.08852157256377],
                            [2.200820929914095, 49.08817832299847],
                            [2.200853268621624, 49.08786991070815],
                            [2.200922459442305, 49.087603808351226],
                            [2.200994258518992, 49.08738447030166],
                            [2.201099004649961, 49.08713369754419],
                            [2.201166459457293, 49.08700068428713],
                            [2.201291697610338, 49.08676522278638],
                            [2.201537793117673, 49.0863941134586],
                            [2.201673782621026, 49.086231505541384],
                            [2.201857852021466, 49.086010501543896],
                            [2.202091248430846, 49.085774267134724],
                            [2.20250567587162, 49.08542493572345],
                            [2.202788262577688, 49.085222929541395],
                            [2.203202412396381, 49.084972515524335],
                            [2.203746714512316, 49.08468807873599],
                            [2.203889287125589, 49.08461899980039],
                            [2.204205967789653, 49.084462892250194],
                            [2.204741984239535, 49.0842009230612],
                            [2.20509293213278, 49.08402776668637],
                            [2.205705814622024, 49.08368764427291],
                            [2.205907404134456, 49.08356107744532],
                            [2.206162568612107, 49.0833653263573],
                            [2.206356035657136, 49.08320277855845],
                            [2.206570185460174, 49.08298359839493],
                            [2.20679400128443, 49.082732955594714],
                            [2.206994628678089, 49.08244811295753],
                            [2.2071817069896, 49.082109298318024],
                            [2.207312689761099, 49.08175603227995],
                            [2.207382050865224, 49.08140809192987],
                            [2.207404910227873, 49.081043013116535],
                            [2.207375646480392, 49.08071654374962],
                            [2.207331194501543, 49.08043951790937],
                            [2.207211544546548, 49.08012643533654],
                            [2.207058986093821, 49.079833999087924],
                            [2.206790397969286, 49.079415533234695],
                            [2.206437036530973, 49.07896099924466],
                            [2.20594311432761, 49.078342636482795],
                            [2.205446725524735, 49.07769904281828],
                        ],
                    },
                },
                194: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.98532092323638, 2.1710129580525397],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1746.00734146,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.161906605592158,
                            48.98026352072714,
                            2.180012382147682,
                            48.99028999637593,
                        ),
                        "coordinates": [
                            [2.180012382147682, 48.98026352072714],
                            [2.179744028518352, 48.980534397773155],
                            [2.17943952143388, 48.9808052247129],
                            [2.179149542791524, 48.98105465508013],
                            [2.178729144981954, 48.98139194229784],
                            [2.178265330202148, 48.98173868401558],
                            [2.177888571497791, 48.98199037099218],
                            [2.177461178654776, 48.98224912582839],
                            [2.177026603469663, 48.98249121140953],
                            [2.176501567665112, 48.98275934306846],
                            [2.175944033983173, 48.983013150491665],
                            [2.17535761170449, 48.98325739537508],
                            [2.174525169018463, 48.98355839521004],
                            [2.17337421097981, 48.98397552111971],
                            [2.171919191813018, 48.98450402653379],
                            [2.171463047489131, 48.984696093955996],
                            [2.170995990963719, 48.98490718010388],
                            [2.170572318568492, 48.98511594750829],
                            [2.170134094507895, 48.985350864954775],
                            [2.169710270453896, 48.98560245836311],
                            [2.16924290881962, 48.98589919035854],
                            [2.166532546034458, 48.98769873133757],
                            [2.16506500094823, 48.98866017298146],
                            [2.164586749680049, 48.98895211373551],
                            [2.164267965424287, 48.9891324616969],
                            [2.163963686196905, 48.98929855765896],
                            [2.161906605592158, 48.99028999637593],
                        ],
                    },
                },
                195: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.95527034220546, 2.518986404402624],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 1918.82335622,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.512644627819613,
                            48.947607554953485,
                            2.52471638942019,
                            48.962709513300425,
                        ),
                        "coordinates": [
                            [2.52471638942019, 48.947607554953485],
                            [2.524690195029446, 48.94792125942806],
                            [2.524649513491627, 48.94840848815528],
                            [2.52459649163621, 48.94876693576496],
                            [2.524476063686018, 48.949205736438515],
                            [2.524310989877811, 48.94957882066666],
                            [2.524167641997917, 48.94982759698238],
                            [2.524013137601642, 48.9500617706561],
                            [2.523767156932613, 48.9503957862003],
                            [2.523545274049944, 48.950681738858265],
                            [2.523325128089641, 48.95093478504357],
                            [2.523208550877416, 48.951061318519116],
                            [2.523053086052221, 48.95122217747705],
                            [2.522884687730144, 48.95140233140805],
                            [2.522725968457396, 48.95156319493269],
                            [2.521556546707297, 48.952734303009066],
                            [2.515348917598681, 48.958941410314985],
                            [2.514995757824175, 48.95930385896129],
                            [2.514804613698599, 48.95950545000867],
                            [2.514607078866195, 48.95973917213266],
                            [2.514441958488591, 48.95994286241386],
                            [2.514263938659011, 48.96017869432164],
                            [2.514144227250268, 48.96035019226891],
                            [2.513937206250479, 48.960661017939415],
                            [2.513083485356867, 48.96201999432523],
                            [2.512644627819613, 48.962709513300425],
                        ],
                    },
                },
                196: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.595604808066874, 2.2824773927647555],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2548.36843922,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.266937972614161,
                            48.591460820223375,
                            2.297950577822679,
                            48.599059348508746,
                        ),
                        "coordinates": [
                            [2.266937972614161, 48.591460820223375],
                            [2.267047525335429, 48.59151679110039],
                            [2.267393746322513, 48.591696878854286],
                            [2.268674568132321, 48.59239241779769],
                            [2.269922669670241, 48.59307077501544],
                            [2.271089898822804, 48.59370017204722],
                            [2.271525910676296, 48.59393110960185],
                            [2.272027767242565, 48.59416456845992],
                            [2.272396644934728, 48.59432799739449],
                            [2.273056651218614, 48.59459152098763],
                            [2.273601247795335, 48.59479002068213],
                            [2.274155927647354, 48.59496187494262],
                            [2.274708122737644, 48.59511374028097],
                            [2.275318074612092, 48.595263967518804],
                            [2.275717196138264, 48.59534912384036],
                            [2.276028466688033, 48.595412580583535],
                            [2.276440162842702, 48.595482751391785],
                            [2.276812599097834, 48.595538125571785],
                            [2.277128021386692, 48.59558304670883],
                            [2.277645192328033, 48.59564160986846],
                            [2.278084550472182, 48.5956801451578],
                            [2.278616804078241, 48.5957237225199],
                            [2.280698173409043, 48.59585801094676],
                            [2.282026335965663, 48.595946932759716],
                            [2.283678381982467, 48.596060972580474],
                            [2.286510473089086, 48.59626045928417],
                            [2.290291700203794, 48.59647359284977],
                            [2.291258363676342, 48.59651728825804],
                            [2.291845884000873, 48.596555828864894],
                            [2.292265183825152, 48.596582642928524],
                            [2.293081917984158, 48.596624196039],
                            [2.293298850176136, 48.59664259367458],
                            [2.293870732040014, 48.596721303727605],
                            [2.29433609656291, 48.59682351837107],
                            [2.294809322364659, 48.59695974683564],
                            [2.295325907192924, 48.597135235767595],
                            [2.295645308859402, 48.59726093930767],
                            [2.295921330104468, 48.597378776049474],
                            [2.296398449704391, 48.597590875344935],
                            [2.296779144063657, 48.59777501519646],
                            [2.2970529826857, 48.59792338887908],
                            [2.297269789044134, 48.598106612298714],
                            [2.297490499523158, 48.598344780730265],
                            [2.297597336598059, 48.59850367185756],
                            [2.297950577822679, 48.599059348508746],
                        ],
                    },
                },
                197: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.93723077211048, 2.5190146055658134],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 2431.54747179,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.508038741924935,
                            48.9322501569209,
                            2.525001590830138,
                            48.947607554953485,
                        ),
                        "coordinates": [
                            [2.508038741924935, 48.9322501569209],
                            [2.509511499171653, 48.93229557999441],
                            [2.51173560303805, 48.93243328802947],
                            [2.51263144443881, 48.93249853842352],
                            [2.51331057582227, 48.93255459834294],
                            [2.513910267077514, 48.93261315685097],
                            [2.514379945622042, 48.93266953363641],
                            [2.514719588469443, 48.93271897297017],
                            [2.515055640169205, 48.93277317465532],
                            [2.515420660221266, 48.93284874689551],
                            [2.515731492880958, 48.932919641363206],
                            [2.515977302975914, 48.932985879470806],
                            [2.516293648307232, 48.93307164535643],
                            [2.516686370408892, 48.93319218044048],
                            [2.516956388598597, 48.93328060122371],
                            [2.517217230577274, 48.9333730743249],
                            [2.51744745111074, 48.93347367170414],
                            [2.517662387081816, 48.933584386902744],
                            [2.517871195325143, 48.933695113021315],
                            [2.518644888477624, 48.934183677193154],
                            [2.519030843091576, 48.93446633786969],
                            [2.519756239316235, 48.934999354911135],
                            [2.520008130137293, 48.93519859342558],
                            [2.520327810049966, 48.93551554231356],
                            [2.520562178379841, 48.93574996719751],
                            [2.520809050317273, 48.93604104624682],
                            [2.521173243846935, 48.93648577273667],
                            [2.521506573065543, 48.93689006395683],
                            [2.521926569049038, 48.937464241161464],
                            [2.522440131549308, 48.93830116409966],
                            [2.522761571252461, 48.93889361096752],
                            [2.523062190399648, 48.939436866481614],
                            [2.523380650863689, 48.94000633363021],
                            [2.523661856023293, 48.94056360046595],
                            [2.523879406807256, 48.941044865481096],
                            [2.524712006720615, 48.943256338410464],
                            [2.524822302613202, 48.94353440961144],
                            [2.524888524601425, 48.94375237351017],
                            [2.524963122453256, 48.944024169964365],
                            [2.525000855938172, 48.94427448786633],
                            [2.525001590830138, 48.94446833094366],
                            [2.524895537088352, 48.945604640268236],
                            [2.52473861279838, 48.94734141012521],
                            [2.52471638942019, 48.947607554953485],
                        ],
                    },
                },
                198: {
                    "attributes": {
                        "reseau": "CDGVAL",
                        "val": 1,
                        "metro": 0,
                        "res_com": "CDGVAL",
                        "rer": 0,
                        "extcode": "043043100:CDGVAL",
                        "geo_point_2d": [49.009533674567464, 2.5526969894618303],
                        "indice_lig": "CDG",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Navette",
                        "tramway": 0,
                        "idrefligc": "C00563",
                        "navette": 1,
                        "idrefliga": "A01516",
                        "shape_leng": 1158.03071717,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.54483189791712,
                            49.008978460950175,
                            2.560558843901876,
                            49.010067608984684,
                        ),
                        "coordinates": [
                            [2.54483189791712, 49.008978460950175],
                            [2.547162425802318, 49.0091057529518],
                            [2.547638634618383, 49.00913012321774],
                            [2.548309436247278, 49.009182424186754],
                            [2.549309098505333, 49.00925338420587],
                            [2.553503308062386, 49.00958602287308],
                            [2.554336977326103, 49.009659395056886],
                            [2.556147660844504, 49.00982940120673],
                            [2.559091939988773, 49.010042220561566],
                            [2.559398026013325, 49.01005868136568],
                            [2.559686531709368, 49.010067608984684],
                            [2.559967728802765, 49.01005520240244],
                            [2.560227196951591, 49.010021489767944],
                            [2.560558843901876, 49.01000186615112],
                        ],
                    },
                },
                199: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.96272518249947, 3.27000233292206],
                        "indice_lig": "TER",
                        "idf": 0,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01747",
                        "navette": 0,
                        "idrefliga": "A02170",
                        "shape_leng": 9880.37555071,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            3.219302814192089,
                            48.9490786960231,
                            3.32188681725306,
                            48.974026580478466,
                        ),
                        "coordinates": [
                            [3.219302814192089, 48.974026580478466],
                            [3.220051124556012, 48.973955503684245],
                            [3.220748614529517, 48.973908469373825],
                            [3.221440729638185, 48.97387844981426],
                            [3.22214195202817, 48.973864367983495],
                            [3.222807354987442, 48.97386254211974],
                            [3.223303437733916, 48.97387202006249],
                            [3.2239109814487, 48.97388895744797],
                            [3.225599772920116, 48.973954119021776],
                            [3.226737198053162, 48.973986745663815],
                            [3.227657340777943, 48.97399742830987],
                            [3.228499781707588, 48.97397197080792],
                            [3.229164471386213, 48.973936329753194],
                            [3.229611866248663, 48.973899434002966],
                            [3.23072739813513, 48.97379088595276],
                            [3.231801314864924, 48.973647579038584],
                            [3.232305277789907, 48.97356448924119],
                            [3.232770993686833, 48.97348169635326],
                            [3.2337523086958, 48.97327974114177],
                            [3.234817130899744, 48.973012368163964],
                            [3.235818752485804, 48.972725697363856],
                            [3.236562942323716, 48.97248151471364],
                            [3.237126261828032, 48.97228282101101],
                            [3.237568553162295, 48.972114756556344],
                            [3.238123180014235, 48.97188914517359],
                            [3.238762986176607, 48.97161519438356],
                            [3.239238967404711, 48.971389832262524],
                            [3.239534817914093, 48.971246460204696],
                            [3.239811034464006, 48.971105086075816],
                            [3.240445560571207, 48.970767314627835],
                            [3.240805914952083, 48.970559404391665],
                            [3.241186956266989, 48.970325785573436],
                            [3.241506123201707, 48.97012129120249],
                            [3.242054037888303, 48.9697545177798],
                            [3.242543526073105, 48.96940529329134],
                            [3.242938125464083, 48.96909638895769],
                            [3.243278759940915, 48.96882478495911],
                            [3.243476458845109, 48.968655040302586],
                            [3.243672626974816, 48.96847631326666],
                            [3.244103660794766, 48.96806908865474],
                            [3.244542207704287, 48.96762492897347],
                            [3.244996230966727, 48.96713118178916],
                            [3.245676556508061, 48.96639011231234],
                            [3.246440924758489, 48.96554044944534],
                            [3.247154624625369, 48.964759533994744],
                            [3.247750549852749, 48.96411175703726],
                            [3.248043503275677, 48.96377576582863],
                            [3.248963393863972, 48.962771957246964],
                            [3.249748952592749, 48.961892423641665],
                            [3.250479746680428, 48.96107392377699],
                            [3.251488797445429, 48.9599631858926],
                            [3.252522541986071, 48.958822257197866],
                            [3.253214124279665, 48.95805717273584],
                            [3.25622809260059, 48.954729378730335],
                            [3.256979271825964, 48.95390440514789],
                            [3.257423557592575, 48.953449432815354],
                            [3.257732651159442, 48.95314713378433],
                            [3.258007680299058, 48.9528983871552],
                            [3.258244233454284, 48.95269826674022],
                            [3.258448620442044, 48.95253671371046],
                            [3.258653099287763, 48.95238015812103],
                            [3.258875062165073, 48.95221180135747],
                            [3.259178958846838, 48.95199947282635],
                            [3.259447549171697, 48.951830026757015],
                            [3.25987417354828, 48.95156756925578],
                            [3.260210706501014, 48.951380484640914],
                            [3.260572944292518, 48.95118059993728],
                            [3.260911121762154, 48.951008787928835],
                            [3.261283377886781, 48.95083400149383],
                            [3.261723460824696, 48.95063528160006],
                            [3.262129527556702, 48.95046976723937],
                            [3.262488183983621, 48.95032884991796],
                            [3.262828315918833, 48.95020543822273],
                            [3.26330740301974, 48.95004866495225],
                            [3.263713443135862, 48.94992233624862],
                            [3.263990155997988, 48.949843470102635],
                            [3.264334860494532, 48.94974906007039],
                            [3.264725077915624, 48.94965427967217],
                            [3.265075037590687, 48.94957564940334],
                            [3.265528068561412, 48.94948652853041],
                            [3.265853762604668, 48.94942523778572],
                            [3.266249496894872, 48.94935539163253],
                            [3.26657733691546, 48.949306084740904],
                            [3.266993642345201, 48.94925439209138],
                            [3.267382194622261, 48.949206253478025],
                            [3.267730477364163, 48.949168436102255],
                            [3.268159798960954, 48.94913662061608],
                            [3.268576538616538, 48.94910823723731],
                            [3.268945304869598, 48.94909625714524],
                            [3.269339751365802, 48.94908035415021],
                            [3.26974687747657, 48.9490786960231],
                            [3.270224956996792, 48.949084783711236],
                            [3.270700699442268, 48.94910088252404],
                            [3.271120874374347, 48.94912076597347],
                            [3.271579260980257, 48.94915532528342],
                            [3.272106137459299, 48.94920098242349],
                            [3.272615598960103, 48.949261769861906],
                            [3.273016208271058, 48.94931678528912],
                            [3.273451296429456, 48.949386757097066],
                            [3.273856902266804, 48.94946257235397],
                            [3.27423663727745, 48.94954219618774],
                            [3.274583504705027, 48.949616691937635],
                            [3.274931944265065, 48.9497019659792],
                            [3.275284648547881, 48.94979619832755],
                            [3.275704694831234, 48.94991325780826],
                            [3.276424447241859, 48.95013757106604],
                            [3.276898697238463, 48.95030454457533],
                            [3.277324928561055, 48.95045932014982],
                            [3.277699231217119, 48.95061182428068],
                            [3.278119101185705, 48.950790931021636],
                            [3.27847873089525, 48.950961540721366],
                            [3.278872870787224, 48.95115164929429],
                            [3.279161203701664, 48.951306656193694],
                            [3.279463208647743, 48.95146244882942],
                            [3.279705815592856, 48.9516103435911],
                            [3.280002651950996, 48.95179278172166],
                            [3.280353261724357, 48.95202348549484],
                            [3.28076440125702, 48.95231687151686],
                            [3.281084408920581, 48.95255704994441],
                            [3.281514081801471, 48.95292466315023],
                            [3.282016643457746, 48.95339127043647],
                            [3.282407700166431, 48.953780003489086],
                            [3.282811146439633, 48.95424639809517],
                            [3.283031394713747, 48.954522740079234],
                            [3.283203429673976, 48.95476179225213],
                            [3.283333943631602, 48.95494597586285],
                            [3.283558003472831, 48.95530925304632],
                            [3.283761722582123, 48.955679893194166],
                            [3.28394254172856, 48.95606691109604],
                            [3.284092328677198, 48.956402023094086],
                            [3.284141207120106, 48.95653022405892],
                            [3.284180303971511, 48.95664681464919],
                            [3.284219883275057, 48.95676320084165],
                            [3.286257479674211, 48.96092766911615],
                            [3.28847320115611, 48.96340773142829],
                            [3.290494760731977, 48.96517551599734],
                            [3.292859479997547, 48.96598858660525],
                            [3.298782001341376, 48.9669272009919],
                            [3.312418595811659, 48.968202831680195],
                            [3.32188681725306, 48.969278782071456],
                        ],
                    },
                },
                200: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.972402667181115, 1.6209521307485937],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01748",
                        "navette": 0,
                        "idrefliga": "A02174",
                        "shape_leng": 13649.5046806,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.541381156495169,
                            48.943236988151924,
                            1.703016134167223,
                            48.99049452612851,
                        ),
                        "coordinates": [
                            [1.541381156495169, 48.943236988151924],
                            [1.541962745194756, 48.943565823888335],
                            [1.54254334169736, 48.943884622508584],
                            [1.542562295245285, 48.94389464656514],
                            [1.54324907697493, 48.94423306517932],
                            [1.543911482816356, 48.944559619924696],
                            [1.544622022325549, 48.944864919596505],
                            [1.545368036210908, 48.945172259802774],
                            [1.546239210948517, 48.94550833896896],
                            [1.547519428603309, 48.94596594722534],
                            [1.547598180104668, 48.94599347063161],
                            [1.547758413730737, 48.9460485368756],
                            [1.547902337627978, 48.94609899286605],
                            [1.548006899319773, 48.946134787448564],
                            [1.548044924967328, 48.94614764088472],
                            [1.549952746525076, 48.94680830004222],
                            [1.550812307244833, 48.947105594027974],
                            [1.551173532112853, 48.947229485166346],
                            [1.55363420708505, 48.94807644366639],
                            [1.555333019185319, 48.94866633246041],
                            [1.555576140385528, 48.94874803398496],
                            [1.555663021738991, 48.94878010368736],
                            [1.557583417977607, 48.94943532514701],
                            [1.560633704637024, 48.95048759620734],
                            [1.563719253387407, 48.95156340583482],
                            [1.565807189852035, 48.952259190346126],
                            [1.566748177267378, 48.95260097800559],
                            [1.567018476055226, 48.95269362928425],
                            [1.567298279397954, 48.95278994161394],
                            [1.567463976189321, 48.95284771444821],
                            [1.568944512226664, 48.9533567897689],
                            [1.569877669377148, 48.953677814902576],
                            [1.571022733611183, 48.95407219703166],
                            [1.571379962902067, 48.95419599748944],
                            [1.574815293959903, 48.95537816694688],
                            [1.575758031148289, 48.955702804106146],
                            [1.576104444180637, 48.95582112188943],
                            [1.576236203363719, 48.95586696430809],
                            [1.57641279020859, 48.95592839277981],
                            [1.577159940221973, 48.956185168585826],
                            [1.577202034451363, 48.956200736434276],
                            [1.577240076063393, 48.95621357960577],
                            [1.577826794284136, 48.956424319742474],
                            [1.577871580218472, 48.956442603040244],
                            [1.578144541799151, 48.95654244070133],
                            [1.579605797102149, 48.95707642954749],
                            [1.579707686719592, 48.957111278042646],
                            [1.580307739391328, 48.95734457621661],
                            [1.580986271085755, 48.95762605281115],
                            [1.581486680164821, 48.957856887449786],
                            [1.582157849389659, 48.958174281280634],
                            [1.582954929093008, 48.95856444703446],
                            [1.583445402186658, 48.95882128718064],
                            [1.584107830176099, 48.95917638341776],
                            [1.58476456105724, 48.959547626154034],
                            [1.585202809907044, 48.959838145483644],
                            [1.586562968604124, 48.9606941609709],
                            [1.586910063111115, 48.96092010549522],
                            [1.587397209791767, 48.961204073833706],
                            [1.587906115444549, 48.96148342437678],
                            [1.588354175835437, 48.96172430222169],
                            [1.588899365619935, 48.96199436757759],
                            [1.589419629645817, 48.962240473581446],
                            [1.589968767860917, 48.962489143616544],
                            [1.590510937822693, 48.96272110952674],
                            [1.591031823948726, 48.962926761559046],
                            [1.591595896243342, 48.96314458880158],
                            [1.59257383167648, 48.9634769415565],
                            [1.593642077668292, 48.9638122528945],
                            [1.594545333484994, 48.96406558090088],
                            [1.595880431329847, 48.96444067390458],
                            [1.596984712768646, 48.96478570403875],
                            [1.597628080688679, 48.96502067153474],
                            [1.598199399344948, 48.96524089161369],
                            [1.598975168241535, 48.96556474461152],
                            [1.599556631501998, 48.96583261281742],
                            [1.600076881017257, 48.966085807008945],
                            [1.600525150390071, 48.96631950044647],
                            [1.600996209161962, 48.96657681555457],
                            [1.601475058821443, 48.966844331183985],
                            [1.602008658922043, 48.967173744588294],
                            [1.602531284577495, 48.96751260224393],
                            [1.602981958639509, 48.96782958029518],
                            [1.603471581817273, 48.96820153435026],
                            [1.603953806737483, 48.96858533739492],
                            [1.605182299627212, 48.969585429018785],
                            [1.606800130368989, 48.970902080694025],
                            [1.608446715411697, 48.972235546755456],
                            [1.614319244402173, 48.97700311606737],
                            [1.618535048506358, 48.98042274436897],
                            [1.619239035258169, 48.980986329898776],
                            [1.61968580937528, 48.981338908049544],
                            [1.620107973984369, 48.98164374320861],
                            [1.620559233267343, 48.981936859971945],
                            [1.621014491310247, 48.9822038271807],
                            [1.621487931679318, 48.98246376798808],
                            [1.622108965821046, 48.98276745870964],
                            [1.622748525804292, 48.98304032836921],
                            [1.623320268406904, 48.983253285554895],
                            [1.623787938385126, 48.98341324509759],
                            [1.6243277376094, 48.98358554795548],
                            [1.624965143230725, 48.98375845633887],
                            [1.625541644789221, 48.983892910468846],
                            [1.626053491383382, 48.98399840771947],
                            [1.626641253604478, 48.98410437348103],
                            [1.627297768850721, 48.98420600397686],
                            [1.627893276503856, 48.984276320046305],
                            [1.628499765837446, 48.98433718330214],
                            [1.629160753037861, 48.98437934460489],
                            [1.629847350046053, 48.98440024542518],
                            [1.630512598901766, 48.98439721690573],
                            [1.631192644781068, 48.984370481188115],
                            [1.63185127145934, 48.9843245732144],
                            [1.632539154803839, 48.984255048150445],
                            [1.633933529872428, 48.984078027938104],
                            [1.634810088585694, 48.98395968027273],
                            [1.636005292202547, 48.98380520663098],
                            [1.636787585370083, 48.98370530118996],
                            [1.637606023824801, 48.983605611423066],
                            [1.63842442686033, 48.98350829537596],
                            [1.639322521063671, 48.98339956293483],
                            [1.640162503920702, 48.98330950378012],
                            [1.641227040397552, 48.983189872146305],
                            [1.642139313879204, 48.98310023760408],
                            [1.642975574514153, 48.98301727462341],
                            [1.644666026247236, 48.98286095541211],
                            [1.646197049875647, 48.98272982255503],
                            [1.647091035472594, 48.982654315704245],
                            [1.648100656596277, 48.98258187718742],
                            [1.649993109827354, 48.98245524813063],
                            [1.651216028955323, 48.982381684406995],
                            [1.652713568557468, 48.98231688763237],
                            [1.65361059241172, 48.982281798450735],
                            [1.654525492038574, 48.982261084887135],
                            [1.655389522410743, 48.982259097751545],
                            [1.656275046455499, 48.98227150718231],
                            [1.656929125515478, 48.98228967299071],
                            [1.657676961347356, 48.98232504747259],
                            [1.658450005580976, 48.98236770601398],
                            [1.659175861373318, 48.982424354760376],
                            [1.660060513008304, 48.9825009748465],
                            [1.66083659101365, 48.98258646430374],
                            [1.661558450648096, 48.9826716279605],
                            [1.662276503781799, 48.982771041687435],
                            [1.663077376461642, 48.98289473281918],
                            [1.663928602278427, 48.98303774961124],
                            [1.664682264356379, 48.98317780726155],
                            [1.665360052874971, 48.98331503562577],
                            [1.666088192789255, 48.983471590219445],
                            [1.666808917157769, 48.98364237366442],
                            [1.667471838705015, 48.983810434049694],
                            [1.668199480865629, 48.98400504467882],
                            [1.66891964187714, 48.98421864015558],
                            [1.669535265417425, 48.98441020709595],
                            [1.670208409670134, 48.98462590015267],
                            [1.672126728384713, 48.98526760903823],
                            [1.680239757114454, 48.98797227330492],
                            [1.680862605127309, 48.988170958437436],
                            [1.681449588465203, 48.98834801992586],
                            [1.682094328823308, 48.988532547911646],
                            [1.682681603654369, 48.988688190521664],
                            [1.683431163547309, 48.98887568861192],
                            [1.684184469060674, 48.98905368554938],
                            [1.684880310524462, 48.98920279874365],
                            [1.685623124567352, 48.9893545529823],
                            [1.686625808719835, 48.9895410911535],
                            [1.687462817713614, 48.98967909249607],
                            [1.688412001902074, 48.989810585424145],
                            [1.689437298712309, 48.98992822418882],
                            [1.69037255819594, 48.99001917196599],
                            [1.691358652984027, 48.990093743246646],
                            [1.692232922640822, 48.99014863948858],
                            [1.693175978351185, 48.990196779060376],
                            [1.696268802939145, 48.99036404035903],
                            [1.698529593632241, 48.99048631919019],
                            [1.699147766592247, 48.99049452612851],
                            [1.699683334961162, 48.990459440130536],
                            [1.700213667819275, 48.990410889589135],
                            [1.700724909562586, 48.990309941744876],
                            [1.70126561943671, 48.99016591077427],
                            [1.701598682602702, 48.990060884515835],
                            [1.702348288564212, 48.98977924602929],
                            [1.703016134167223, 48.989502508030505],
                        ],
                    },
                },
                201: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.467862035062616, 2.7665218453153955],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 5873.52915957,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.751153658380149,
                            48.442882064226566,
                            2.773485606663736,
                            48.487222875528246,
                        ),
                        "coordinates": [
                            [2.760926733738456, 48.442882064226566],
                            [2.761595951004158, 48.44354694021371],
                            [2.763422457189777, 48.445359056860475],
                            [2.764926650505398, 48.446868994569265],
                            [2.765680142918008, 48.44761329316563],
                            [2.765951009215691, 48.447896288729545],
                            [2.766124752982382, 48.448074727769395],
                            [2.766225533085432, 48.448198865003135],
                            [2.766321623876522, 48.448339422882505],
                            [2.766421774736739, 48.44850614724888],
                            [2.766586591072239, 48.44881037152612],
                            [2.766743584332989, 48.44914789796946],
                            [2.766882983986937, 48.44948279412558],
                            [2.766986886946515, 48.44977645864304],
                            [2.767074105482878, 48.450016230276155],
                            [2.767324460026053, 48.450835406492644],
                            [2.767426846737313, 48.45113944996402],
                            [2.767532538329151, 48.45145330840755],
                            [2.767681640379815, 48.45180042278222],
                            [2.767831749205445, 48.452135609759615],
                            [2.767888189285304, 48.452241370777884],
                            [2.768350304169477, 48.45301401374466],
                            [2.768503899000985, 48.45326792043091],
                            [2.768920876041274, 48.4539650575954],
                            [2.769207590781253, 48.45444866594502],
                            [2.769811043678867, 48.45545874875412],
                            [2.77007976253259, 48.45592406519053],
                            [2.77035913428027, 48.45637982223105],
                            [2.770825994270108, 48.45712407983803],
                            [2.771222131880606, 48.4577255822222],
                            [2.77136382249737, 48.457977245511394],
                            [2.771491266504765, 48.458236101546795],
                            [2.771574140953394, 48.458429639862544],
                            [2.771817774610239, 48.45908426846817],
                            [2.771916567490021, 48.459406724335636],
                            [2.771994377541466, 48.45973789308037],
                            [2.772193108546506, 48.460735674391266],
                            [2.772316576384184, 48.46137534151357],
                            [2.772440480960773, 48.46197391068492],
                            [2.772585800884284, 48.46267028235211],
                            [2.772694172546813, 48.4631599649219],
                            [2.772807204354267, 48.46371887295381],
                            [2.772887787100706, 48.46412233250483],
                            [2.773365257537985, 48.46646937497422],
                            [2.773418655732841, 48.46683511706058],
                            [2.773447698267541, 48.46708505414123],
                            [2.773465728805673, 48.46744738915953],
                            [2.773485606663736, 48.467866370244394],
                            [2.773457057579393, 48.468469888228924],
                            [2.773404735362116, 48.46887853676099],
                            [2.773335706074937, 48.46928688966345],
                            [2.773170868595014, 48.46996202604711],
                            [2.773008668838968, 48.47055521547116],
                            [2.772648855063921, 48.471788595626215],
                            [2.772465603035616, 48.472305024023306],
                            [2.772268010049928, 48.47278005296128],
                            [2.772072691561673, 48.47318377514302],
                            [2.771789646262083, 48.47366003513115],
                            [2.771485763848649, 48.47410375294116],
                            [2.77120549910066, 48.474535071882094],
                            [2.770600178812847, 48.475400720924135],
                            [2.77031561305327, 48.47580648005272],
                            [2.770044435919698, 48.476196900727025],
                            [2.769630305275653, 48.47679199934125],
                            [2.769312517881354, 48.477268026437116],
                            [2.768677604746096, 48.478141838809755],
                            [2.768141037009027, 48.478815635470184],
                            [2.767868040105863, 48.47915569828132],
                            [2.767290401176827, 48.47975161386681],
                            [2.766793892302045, 48.480234404195315],
                            [2.766255387394773, 48.480687845353465],
                            [2.765757730570017, 48.48110688068657],
                            [2.765401072575688, 48.481382650833126],
                            [2.764881310400018, 48.481773643711556],
                            [2.764325483713099, 48.48214569697125],
                            [2.763522391228304, 48.482666701966124],
                            [2.763006955411796, 48.48297619225833],
                            [2.762367833682136, 48.48332728889813],
                            [2.761665846489327, 48.483689200513965],
                            [2.760831671652031, 48.48408015459614],
                            [2.759719510474557, 48.48461252023684],
                            [2.75928104563875, 48.484821156227184],
                            [2.758739169459785, 48.48507538313257],
                            [2.758289899490584, 48.48527691715416],
                            [2.757797697238829, 48.48548098876748],
                            [2.757415982506981, 48.485629924957514],
                            [2.756930593312749, 48.48579351918423],
                            [2.756402294189915, 48.485964157295335],
                            [2.755964682047495, 48.48610374057985],
                            [2.75552761458263, 48.48622699012184],
                            [2.755095442948047, 48.486335655639394],
                            [2.754631016848214, 48.48643967936091],
                            [2.754213016978645, 48.48653163466971],
                            [2.75273398453552, 48.48686304015041],
                            [2.751883734060254, 48.48705650403138],
                            [2.751153658380149, 48.487222875528246],
                        ],
                    },
                },
                202: {
                    "attributes": {
                        "reseau": "PARIS EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE P",
                        "rer": 0,
                        "extcode": "800:P",
                        "geo_point_2d": [48.89780707209598, 2.4293987926745437],
                        "indice_lig": "P",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01730",
                        "navette": 0,
                        "idrefliga": "A01844",
                        "shape_leng": 4313.53099779,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.400361703159176,
                            48.896260322962334,
                            2.458363412015992,
                            48.89887033891491,
                        ),
                        "coordinates": [
                            [2.400361703159176, 48.898112306280396],
                            [2.403281547204399, 48.8983438213715],
                            [2.404876826547504, 48.89847136687579],
                            [2.405450682176829, 48.89850671463484],
                            [2.406020912342306, 48.898530163543775],
                            [2.407403173866654, 48.89858166368836],
                            [2.408521966211799, 48.898614278896304],
                            [2.409633528019113, 48.89863737105588],
                            [2.41263233951892, 48.898676559246276],
                            [2.413472391835469, 48.8986734053139],
                            [2.413883777660752, 48.898658852205685],
                            [2.414421450071567, 48.89862755761662],
                            [2.414944681641715, 48.898593891432306],
                            [2.415713296251286, 48.89854815551904],
                            [2.416146323114309, 48.89852644188184],
                            [2.416608232083264, 48.898511844231294],
                            [2.417019628566003, 48.89850441914446],
                            [2.417499613034112, 48.898508839242446],
                            [2.417947125452648, 48.898518040421095],
                            [2.419379904883467, 48.89855746392422],
                            [2.420978711081432, 48.89860864377334],
                            [2.424111357756001, 48.898699089762765],
                            [2.427846738939663, 48.89881276436524],
                            [2.42932644878034, 48.898852026787786],
                            [2.429896676332358, 48.89886584003609],
                            [2.430214265413721, 48.89887033891491],
                            [2.430578757373056, 48.89886766133943],
                            [2.430914364672341, 48.89885786856133],
                            [2.431286045461826, 48.898840905981636],
                            [2.431690180914725, 48.89880963985484],
                            [2.432025749779658, 48.898780808992264],
                            [2.432415416154168, 48.898732897522414],
                            [2.432794241858564, 48.89867785497748],
                            [2.433133358374563, 48.89861808627199],
                            [2.433458034450159, 48.89855594966109],
                            [2.433829588397613, 48.89847473819822],
                            [2.434309326591622, 48.89835298313319],
                            [2.434882797779406, 48.89818355988485],
                            [2.435607717209017, 48.89795451927382],
                            [2.437259492611106, 48.897429625227275],
                            [2.438323331177323, 48.8970622661271],
                            [2.438813792515264, 48.89690241428735],
                            [2.439087894363203, 48.89682365164865],
                            [2.439445450651772, 48.896725945649514],
                            [2.439780394912604, 48.896642199826694],
                            [2.440162745475339, 48.896558577560285],
                            [2.440678596698777, 48.896465316512106],
                            [2.441154809413359, 48.89640063993438],
                            [2.441576925802698, 48.896352666637725],
                            [2.441991858898001, 48.89632135409288],
                            [2.442421241332333, 48.896297166078696],
                            [2.442872297336787, 48.89628247245745],
                            [2.443756413206839, 48.89627688942672],
                            [2.444514209915559, 48.896264281247326],
                            [2.445448854167565, 48.89626101817673],
                            [2.446177806648478, 48.896260322962334],
                            [2.446719118883842, 48.8962645625113],
                            [2.44714858881238, 48.896280804457405],
                            [2.4476971821202, 48.89631358493711],
                            [2.448361265144072, 48.89635100837806],
                            [2.449736363934091, 48.89643293507745],
                            [2.450819069581169, 48.89647468855999],
                            [2.45599294890596, 48.89665511724568],
                            [2.458363412015992, 48.896652451144085],
                        ],
                    },
                },
                203: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.74069806140985, 2.4112039151073685],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1589.11927858,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.40290860736794,
                            48.739201399103095,
                            2.417520977896491,
                            48.745072166893884,
                        ),
                        "coordinates": [
                            [2.40290860736794, 48.74187870567889],
                            [2.404148997694423, 48.74099924519451],
                            [2.404757643217121, 48.74064726679039],
                            [2.405086455081131, 48.74048519987144],
                            [2.405426135443845, 48.74031862960775],
                            [2.405987298049764, 48.74005390302935],
                            [2.406208773621854, 48.73995035151224],
                            [2.406476476959746, 48.739847669815504],
                            [2.406710207050344, 48.73975849825125],
                            [2.407073043981454, 48.739629678050854],
                            [2.407395152591308, 48.73954494655495],
                            [2.408133187830964, 48.73937991804247],
                            [2.408564079746463, 48.73930680465609],
                            [2.408755749852512, 48.739282402478366],
                            [2.409118717043212, 48.73924889836191],
                            [2.40930495829174, 48.739231693627914],
                            [2.409787586284275, 48.73920980122712],
                            [2.4102661560042, 48.739201399103095],
                            [2.410664530200711, 48.73920833398242],
                            [2.410811379616232, 48.73921633169249],
                            [2.411019421589991, 48.739230584525146],
                            [2.411075169715351, 48.739234144303495],
                            [2.411465435589616, 48.73927255734691],
                            [2.411906039467219, 48.739332517606854],
                            [2.412392916845483, 48.73942302048742],
                            [2.412942417322595, 48.739564737557345],
                            [2.413773559218267, 48.73983395734561],
                            [2.414097365070003, 48.7399722255866],
                            [2.414456565445204, 48.74013834493735],
                            [2.414837562557761, 48.740329628350366],
                            [2.415195486350047, 48.7405452064186],
                            [2.415548012333417, 48.740784168391286],
                            [2.415793035794553, 48.74096475144346],
                            [2.416055824997396, 48.7412010771217],
                            [2.416330905349029, 48.74146886698946],
                            [2.416512065030532, 48.741671076148776],
                            [2.416878676187535, 48.742204985630586],
                            [2.416987721592861, 48.742373072345345],
                            [2.417091393483954, 48.74258073036333],
                            [2.417259384866112, 48.74304373628445],
                            [2.417316901741602, 48.74329639139475],
                            [2.417387046518704, 48.74379004150383],
                            [2.417520977896491, 48.745072166893884],
                        ],
                    },
                },
                204: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.74207585643256, 2.331916074868938],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 3148.30843408,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.312711013515798,
                            48.738738654836844,
                            2.351633198171911,
                            48.74794571395915,
                        ),
                        "coordinates": [
                            [2.312711013515798, 48.747941901886946],
                            [2.312954547887192, 48.74794571395915],
                            [2.313294514565373, 48.74793589239383],
                            [2.313644005760375, 48.74791707803183],
                            [2.314200214846999, 48.74784974342829],
                            [2.314677554927342, 48.747774297536985],
                            [2.315022986980907, 48.747705119517796],
                            [2.315323428140145, 48.74762957351263],
                            [2.315681759063343, 48.747527892488726],
                            [2.315998109487221, 48.747429223182934],
                            [2.316222519001663, 48.747342034088646],
                            [2.316755662215582, 48.747121806058445],
                            [2.318526226281677, 48.746315382799565],
                            [2.319932703806598, 48.745695168838616],
                            [2.321232167678898, 48.7451102517737],
                            [2.322407582797582, 48.744577435373934],
                            [2.323420980982226, 48.744139884726955],
                            [2.324007099304466, 48.74387646405618],
                            [2.325309863984821, 48.74329477148518],
                            [2.325770855123277, 48.7430888828714],
                            [2.327099412766535, 48.74251076922499],
                            [2.327969684712783, 48.74215832374952],
                            [2.328819541864001, 48.74184363902379],
                            [2.329364803418165, 48.74165752572969],
                            [2.329891023066446, 48.741484898162824],
                            [2.331287456413227, 48.74105242209054],
                            [2.333128480757714, 48.740493145702104],
                            [2.334744798588848, 48.73999948246041],
                            [2.335783523924499, 48.73968020127323],
                            [2.336798169287619, 48.73936371305131],
                            [2.337148530683693, 48.739251792698546],
                            [2.33758020725802, 48.73911537462024],
                            [2.337992694666737, 48.73899799057319],
                            [2.338385997901208, 48.7389155016141],
                            [2.338894412684503, 48.738836181725766],
                            [2.339426807638118, 48.73877906566978],
                            [2.339986430072071, 48.73874226605257],
                            [2.340420142293865, 48.738738654836844],
                            [2.340845698587959, 48.738752129655026],
                            [2.341377306552279, 48.73879707146058],
                            [2.341900758980999, 48.73885550168947],
                            [2.34291231973197, 48.73898224707868],
                            [2.342924556277525, 48.738984044962976],
                            [2.343560862731155, 48.73906134592529],
                            [2.345544166923985, 48.739308462626816],
                            [2.346450102220287, 48.73942353922805],
                            [2.347853266372745, 48.73959517052126],
                            [2.348251647444905, 48.73964459031302],
                            [2.349091922822984, 48.73975421272648],
                            [2.349949881828628, 48.739882711273985],
                            [2.350689557679258, 48.74001121783873],
                            [2.350941103460682, 48.740060646587224],
                            [2.351203528283975, 48.74011187164995],
                            [2.351633198171911, 48.74019544820276],
                        ],
                    },
                },
                205: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.749454187881554, 2.3888211902596206],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 2931.84432367,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.373111940704935,
                            48.74187870567889,
                            2.40290860736794,
                            48.753024053396466,
                        ),
                        "coordinates": [
                            [2.373111940704935, 48.74834968236464],
                            [2.375038314740253, 48.7491591776172],
                            [2.376449188498006, 48.74971704252789],
                            [2.377442593546729, 48.75012910826065],
                            [2.379664684921162, 48.75100384351047],
                            [2.381019671355158, 48.75155637531202],
                            [2.381993755078001, 48.75195346947338],
                            [2.382601886806677, 48.75220142434109],
                            [2.383398470065671, 48.752490282214346],
                            [2.384090155503829, 48.75269091714027],
                            [2.384649229971608, 48.75281748016059],
                            [2.385345647521766, 48.75292599532882],
                            [2.385964506247302, 48.75299047714941],
                            [2.386471808951518, 48.75301723437296],
                            [2.386901468057297, 48.753024053396466],
                            [2.387285085274832, 48.753016134923854],
                            [2.387702427305103, 48.752995492117215],
                            [2.388215469965258, 48.75295465938656],
                            [2.388759177761242, 48.75288851315514],
                            [2.389254438995922, 48.75280315129084],
                            [2.389771510923235, 48.752688349848135],
                            [2.390208585449726, 48.752573993937595],
                            [2.390706165210284, 48.75241548721488],
                            [2.391092238848415, 48.75226962070701],
                            [2.391623041594178, 48.75203544046033],
                            [2.391971692368281, 48.751866323511074],
                            [2.392297353788927, 48.751680020034726],
                            [2.392613732305581, 48.75148997896813],
                            [2.392914004950804, 48.75127587542633],
                            [2.393148386563563, 48.751098214001836],
                            [2.3933973598713, 48.75088870180531],
                            [2.393655008221016, 48.75066297588677],
                            [2.39390846286162, 48.75041728499207],
                            [2.394147003440079, 48.750145837266736],
                            [2.395544409175165, 48.74849945567564],
                            [2.396183265847584, 48.74773766689982],
                            [2.396737943950552, 48.74706668852121],
                            [2.397305625310963, 48.74642158935819],
                            [2.39765739209652, 48.74607120880517],
                            [2.397850268442019, 48.74589574763405],
                            [2.398208872973871, 48.74558620449429],
                            [2.399210014732709, 48.74477091897648],
                            [2.400217958361645, 48.74398529614095],
                            [2.400821071882167, 48.74351193975223],
                            [2.400952830283561, 48.743406650891515],
                            [2.401452686788605, 48.743005291899664],
                            [2.401680893640317, 48.742833400289314],
                            [2.401933544699539, 48.74263901253194],
                            [2.40290860736794, 48.74187870567889],
                        ],
                    },
                },
                206: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.102765644793315, 2.2065049546336812],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 2723.15578191,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.201823484236059,
                            49.091073452190784,
                            2.210019869292197,
                            49.114783970085064,
                        ),
                        "coordinates": [
                            [2.210019869292197, 49.114783970085064],
                            [2.209905287355804, 49.11443309398685],
                            [2.209571462191194, 49.11373129263828],
                            [2.208931932224397, 49.112588506036516],
                            [2.208754877303718, 49.112191730025366],
                            [2.208690859330901, 49.112050473242945],
                            [2.20849372942117, 49.11147291984737],
                            [2.208347530096024, 49.11080189978026],
                            [2.20829376362407, 49.110407058586986],
                            [2.208251389250461, 49.10984586550507],
                            [2.208251588433557, 49.109769427217294],
                            [2.208249052626379, 49.109691187901205],
                            [2.208199239455729, 49.10883052850721],
                            [2.20818224207847, 49.10851936185565],
                            [2.208098938314571, 49.107392634374335],
                            [2.208043830023013, 49.10628856382146],
                            [2.207974382447253, 49.10512499395677],
                            [2.207943275419631, 49.104546781745384],
                            [2.207907792382327, 49.10425646391118],
                            [2.207725193781185, 49.10340683792403],
                            [2.207585024884563, 49.10296412489829],
                            [2.207432109535791, 49.1025734283271],
                            [2.207037411877319, 49.10174528981345],
                            [2.206545329911213, 49.1007415059105],
                            [2.206082236900937, 49.099816948326385],
                            [2.20567135075664, 49.098988472939396],
                            [2.205253377454526, 49.09810526328376],
                            [2.204788443360864, 49.09717441149549],
                            [2.204526779703096, 49.09658455843854],
                            [2.204306099611187, 49.09614905646674],
                            [2.203721931498399, 49.09494612675242],
                            [2.20341199452994, 49.094331900130705],
                            [2.203130863229058, 49.09378670700129],
                            [2.202641884285912, 49.09275146960124],
                            [2.202456717071126, 49.09236096837448],
                            [2.2023395836078, 49.092129718375276],
                            [2.201823484236059, 49.091073452190784],
                        ],
                    },
                },
                207: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.749008291026875, 2.4185503110281754],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 900.737445286,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.417520977896491,
                            48.745072166893884,
                            2.419295469321415,
                            48.75288655674139,
                        ),
                        "coordinates": [
                            [2.417520977896491, 48.745072166893884],
                            [2.417559694134845, 48.74544278037653],
                            [2.417595364677613, 48.74563789761012],
                            [2.417725869572168, 48.74613350845395],
                            [2.4177936903694, 48.746349079793504],
                            [2.417929698571815, 48.7466944082515],
                            [2.41812683826887, 48.74712111819496],
                            [2.418276276263958, 48.747417952017706],
                            [2.418475450665925, 48.747766142519914],
                            [2.41889971977792, 48.74846535830931],
                            [2.419038315363134, 48.748727936264515],
                            [2.41909250837702, 48.748862091012214],
                            [2.419185230450416, 48.74913495356007],
                            [2.419241479165207, 48.74939117360156],
                            [2.419278572259143, 48.74961866253804],
                            [2.41929383748868, 48.74980390156787],
                            [2.419295469321415, 48.74996756799391],
                            [2.419278185604111, 48.750178200573124],
                            [2.419235022955878, 48.75041994623721],
                            [2.419203423280662, 48.75055133411644],
                            [2.419178299335482, 48.75065739495887],
                            [2.419156643455977, 48.750719459979486],
                            [2.419099773387582, 48.75086878091593],
                            [2.419036105714618, 48.75101900504099],
                            [2.418875794858536, 48.75144249373356],
                            [2.418463407659742, 48.75226736495072],
                            [2.418113047325797, 48.75288655674139],
                        ],
                    },
                },
                208: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T2",
                        "rer": 0,
                        "extcode": "100112012:T2",
                        "geo_point_2d": [48.872451786806316, 2.2227314972805274],
                        "indice_lig": "2",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01390",
                        "navette": 0,
                        "idrefliga": "A01192",
                        "shape_leng": 976.053877371,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.220949328253845,
                            48.86823878484656,
                            2.22595909514488,
                            48.87600129150149,
                        ),
                        "coordinates": [
                            [2.221410602618016, 48.86823878484656],
                            [2.221244923926796, 48.86876727236577],
                            [2.221035722153108, 48.869444511777665],
                            [2.220957002185118, 48.86988148032841],
                            [2.220949328253845, 48.87024927775301],
                            [2.220986615272779, 48.87062791080432],
                            [2.221021982663541, 48.87079745951286],
                            [2.221073317384238, 48.870982337240015],
                            [2.22113088515698, 48.871133238349195],
                            [2.221223528552819, 48.87133588254776],
                            [2.22139319643104, 48.87165259971504],
                            [2.221616822355393, 48.87196029168843],
                            [2.221855326755002, 48.87224479024959],
                            [2.222054531482109, 48.8724477125608],
                            [2.223461988600421, 48.873703030148576],
                            [2.223898750639484, 48.8740849496861],
                            [2.224084764306137, 48.87425089581864],
                            [2.224700319021337, 48.87480826671129],
                            [2.22532663019438, 48.87540133588663],
                            [2.22595909514488, 48.87600129150149],
                        ],
                    },
                },
                209: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.913400103593474, 2.433349802332179],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 340.674628107,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.431278002116334,
                            48.912704975295874,
                            2.435420992985438,
                            48.914093263505734,
                        ),
                        "coordinates": [
                            [2.435420992985438, 48.912704975295874],
                            [2.434036289484119, 48.91318020978114],
                            [2.431987763248024, 48.913844713363304],
                            [2.431278002116334, 48.914093263505734],
                        ],
                    },
                },
                210: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.49598459103408, 1.897286340154126],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01857",
                        "navette": 0,
                        "idrefliga": "A02179",
                        "shape_leng": 18238.011361,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.796479819708098,
                            48.45590771649728,
                            1.995901990362833,
                            48.535651142265905,
                        ),
                        "coordinates": [
                            [1.796479819708098, 48.45590771649728],
                            [1.797347183384676, 48.45656095387452],
                            [1.798739683457298, 48.457657756103394],
                            [1.799322068036277, 48.458111688841825],
                            [1.799800901950759, 48.45847096960028],
                            [1.800460534878132, 48.45899297304827],
                            [1.801363188628623, 48.45967619178733],
                            [1.802049742528129, 48.46021270184216],
                            [1.802312577824452, 48.46041717794173],
                            [1.803288844944094, 48.46117626734845],
                            [1.804715931587813, 48.462268397738576],
                            [1.804858110417826, 48.462376977850674],
                            [1.805908448560783, 48.46317146469557],
                            [1.806426241885901, 48.46356417296395],
                            [1.806699901051818, 48.46377138707511],
                            [1.80744307410263, 48.46433510710486],
                            [1.808110420257153, 48.464781563459475],
                            [1.808780442767113, 48.465197490006624],
                            [1.80930327639629, 48.465492582552294],
                            [1.809822713780274, 48.46577100193898],
                            [1.81040796712989, 48.466059334700745],
                            [1.810901357768851, 48.466289948885276],
                            [1.811339419605432, 48.46648232775929],
                            [1.811865794516726, 48.46669648738058],
                            [1.812801829439585, 48.46705963015292],
                            [1.813586034136623, 48.46733033821838],
                            [1.814483823869516, 48.46760246397173],
                            [1.815024543018507, 48.467751537399906],
                            [1.81560987948991, 48.46790171199413],
                            [1.817134347146376, 48.46825223680285],
                            [1.819493981056953, 48.46879090933883],
                            [1.820611153913419, 48.46903880819246],
                            [1.822637577851106, 48.46950485338076],
                            [1.824193273242659, 48.46985272755863],
                            [1.82569096241697, 48.470188627827795],
                            [1.827262576594724, 48.47054757623165],
                            [1.828860319954941, 48.470913306641215],
                            [1.830386186052458, 48.471268241277755],
                            [1.831323830903261, 48.471502555980265],
                            [1.831737848371277, 48.47161860988495],
                            [1.832820742645258, 48.47192558688724],
                            [1.833728285893107, 48.47218771128672],
                            [1.835475880331524, 48.472701746351625],
                            [1.836887189313672, 48.47312443511973],
                            [1.840381581049273, 48.47416128066264],
                            [1.842242687714025, 48.47470639519609],
                            [1.844487991755756, 48.475369831669],
                            [1.846607972804901, 48.47599951930195],
                            [1.847622226787146, 48.47629076935788],
                            [1.849386261322481, 48.476812754213675],
                            [1.851045579216219, 48.47730462891601],
                            [1.853786209880743, 48.478111037995745],
                            [1.856196052177203, 48.47881574003382],
                            [1.858560464693356, 48.47951728251933],
                            [1.860926345697587, 48.48021338563424],
                            [1.861676404448346, 48.48042516349604],
                            [1.862975893285599, 48.48075344217077],
                            [1.863502249278825, 48.48087794317638],
                            [1.864011085392062, 48.48099607261369],
                            [1.865487642848335, 48.48134124882376],
                            [1.866970951246157, 48.481690030905774],
                            [1.868442004856799, 48.48204953316117],
                            [1.868976287705818, 48.48219742228588],
                            [1.869452402411082, 48.482345967155986],
                            [1.86987449784543, 48.4824852951019],
                            [1.871093174540894, 48.48293364976055],
                            [1.871587923622687, 48.48311643445254],
                            [1.872554711598398, 48.48345222961363],
                            [1.87302276511184, 48.483597130403126],
                            [1.873492291701562, 48.48372944485443],
                            [1.873893114269943, 48.483830901473674],
                            [1.874404725785146, 48.483947197247076],
                            [1.875073077464651, 48.48408301431888],
                            [1.875317532058818, 48.48412537659963],
                            [1.87588353725892, 48.484211312482444],
                            [1.876218631795877, 48.48425314250328],
                            [1.877042870931892, 48.4843545101753],
                            [1.877475327710981, 48.48440032868654],
                            [1.878291988984055, 48.4844990150006],
                            [1.878964283103872, 48.48459340282371],
                            [1.879492458130092, 48.48467557066152],
                            [1.879765244151144, 48.48472703047211],
                            [1.880124472502447, 48.484793225677166],
                            [1.88050762097865, 48.48487675290486],
                            [1.882279038493584, 48.485282097992126],
                            [1.883889468697054, 48.48566084268555],
                            [1.885499909668612, 48.4860413637978],
                            [1.88794041408196, 48.48660527213401],
                            [1.891076604892144, 48.48732906777998],
                            [1.893905531639184, 48.487999230066414],
                            [1.896952478616021, 48.48871537498314],
                            [1.900519077960755, 48.489556968034506],
                            [1.903585924063144, 48.49027796474703],
                            [1.905422811107824, 48.49069712484978],
                            [1.90716180892519, 48.49110660167523],
                            [1.9089021873188, 48.491516057246535],
                            [1.909702806918212, 48.49170972207141],
                            [1.910217107611719, 48.491845649449374],
                            [1.910800124834483, 48.49201510606071],
                            [1.911683430369431, 48.492300113494295],
                            [1.912343705237787, 48.49253100321779],
                            [1.912950274726099, 48.49276406529041],
                            [1.913656574740024, 48.493056980695314],
                            [1.914312770242985, 48.49334970465227],
                            [1.914950501253676, 48.49366819130454],
                            [1.915555380899235, 48.493977990369196],
                            [1.916112563891495, 48.49429860603861],
                            [1.917583668432846, 48.49517726220579],
                            [1.918050091711761, 48.495481159231325],
                            [1.918555302422936, 48.4958565765064],
                            [1.918857484966555, 48.49610989829828],
                            [1.919155873423027, 48.496389377065746],
                            [1.919429245012203, 48.496664004003655],
                            [1.919794472287263, 48.49708648633886],
                            [1.920028197196202, 48.49739427587882],
                            [1.920204905179514, 48.49767092522721],
                            [1.920356790032013, 48.49791893144977],
                            [1.920526045423771, 48.49823124221957],
                            [1.920620853835, 48.49845524598501],
                            [1.920759428304037, 48.49880182509059],
                            [1.92086236092363, 48.499122338649464],
                            [1.920955303762367, 48.49957236772101],
                            [1.920989039380547, 48.49982231887006],
                            [1.92101551337969, 48.50008414090517],
                            [1.921031552553057, 48.50043334444899],
                            [1.921052411692544, 48.50232097573657],
                            [1.921059509014802, 48.503421700863974],
                            [1.921071858591887, 48.504215795951936],
                            [1.921102961265781, 48.50464321318166],
                            [1.921150261388074, 48.50498362699153],
                            [1.921279391135521, 48.50546113876255],
                            [1.921399654107431, 48.50580869583872],
                            [1.921537952388219, 48.50615804748133],
                            [1.921682402106643, 48.50644171481881],
                            [1.921858980163159, 48.50673739523163],
                            [1.92205148973519, 48.50700530574641],
                            [1.922289711198901, 48.507327214837716],
                            [1.92249195587338, 48.50758154678044],
                            [1.922711899944923, 48.507823352531034],
                            [1.92287617474469, 48.50799976812693],
                            [1.923096401575981, 48.50821471058692],
                            [1.923359419734197, 48.50845122121825],
                            [1.923579945340111, 48.508630473704876],
                            [1.923782764435343, 48.50878586719884],
                            [1.924010551289588, 48.50895324957036],
                            [1.924288334163497, 48.50913746703831],
                            [1.924598264241474, 48.509331317803074],
                            [1.925040272757297, 48.509575614921715],
                            [1.925364707041571, 48.50974810260799],
                            [1.92570457390914, 48.50990794910282],
                            [1.926153095734525, 48.510110236802824],
                            [1.926531405976856, 48.51026388225689],
                            [1.926857798265932, 48.51038603799363],
                            [1.92727746626088, 48.51054971780896],
                            [1.928448347360359, 48.510996493307786],
                            [1.931054346632533, 48.51199088390979],
                            [1.933878196992141, 48.51307164515939],
                            [1.938614133441519, 48.51488379692858],
                            [1.940836580403704, 48.5157371954728],
                            [1.941225664037522, 48.51589796636548],
                            [1.941803746017502, 48.51616170634916],
                            [1.942139062500095, 48.51632942569386],
                            [1.942563443422539, 48.51655693627003],
                            [1.94296980866279, 48.51679865890037],
                            [1.943454424682542, 48.517109650512054],
                            [1.943831981243184, 48.5173726841502],
                            [1.944134558582695, 48.51760690545804],
                            [1.944344511226292, 48.51777894198369],
                            [1.944645072147484, 48.518034258066365],
                            [1.944989056928959, 48.518358282476875],
                            [1.945428468905822, 48.518769865220094],
                            [1.946851339822075, 48.52009552064898],
                            [1.948159893058107, 48.521313459677856],
                            [1.948995546350472, 48.52209197660334],
                            [1.950087283518154, 48.523106910473075],
                            [1.951125724566066, 48.524071688460374],
                            [1.951548892795057, 48.5244704713892],
                            [1.953163637040052, 48.52596063386107],
                            [1.953355781193922, 48.5261278357402],
                            [1.95361923757199, 48.52633810611456],
                            [1.953968371911126, 48.52658673256372],
                            [1.954278064400252, 48.526787331216795],
                            [1.954635012172937, 48.527005360587474],
                            [1.95498457297061, 48.527199262716294],
                            [1.955327191094532, 48.527364587417665],
                            [1.955848420029291, 48.52759475342328],
                            [1.956280575280522, 48.52776275637395],
                            [1.956787937585347, 48.52793338796284],
                            [1.957195348383404, 48.52805847744412],
                            [1.957667275363324, 48.52817902120314],
                            [1.958221645259116, 48.52829270063792],
                            [1.95893362854804, 48.52840690411028],
                            [1.959406047638396, 48.52846320121289],
                            [1.959721089316469, 48.52848804134776],
                            [1.960132829298217, 48.528515582529444],
                            [1.960659338497882, 48.52852446843557],
                            [1.961003253446917, 48.52852084979491],
                            [1.961365165369233, 48.52850539328064],
                            [1.961852557758751, 48.52847607579192],
                            [1.962257598284, 48.52844172451782],
                            [1.962651622586215, 48.528405168758646],
                            [1.962982188997888, 48.52837568446024],
                            [1.963354764953974, 48.52834094098841],
                            [1.964712311391007, 48.52821141340132],
                            [1.967538420040237, 48.52794997350238],
                            [1.968416358354918, 48.52786380255813],
                            [1.970218198549861, 48.52769968079375],
                            [1.971166402942377, 48.52763080114941],
                            [1.971773087346663, 48.52760937488149],
                            [1.972286562406724, 48.527601201225664],
                            [1.972906162480634, 48.52761508767053],
                            [1.973582922552961, 48.52764666121552],
                            [1.974034009589304, 48.5276853230605],
                            [1.974542257423417, 48.527741671260706],
                            [1.974997970622828, 48.52779686527808],
                            [1.975404663726265, 48.52786338893215],
                            [1.976008055495209, 48.52797004494974],
                            [1.976592266780299, 48.528093202312135],
                            [1.977228725015882, 48.528254635554134],
                            [1.9777327863755, 48.528396610958374],
                            [1.978175972311691, 48.528536013338694],
                            [1.978625349337965, 48.528688760400655],
                            [1.979047769877629, 48.52885045690475],
                            [1.979531216974234, 48.529051323641625],
                            [1.979894127681135, 48.52921715735364],
                            [1.980211868894974, 48.529368053370625],
                            [1.980604463426243, 48.52957152784054],
                            [1.981043555189483, 48.529807862310264],
                            [1.981870977700573, 48.53030118719812],
                            [1.983369266929133, 48.53118858886927],
                            [1.985117334437867, 48.53222426274626],
                            [1.9867120465048, 48.53317140201081],
                            [1.987957296873395, 48.5338937900335],
                            [1.988617567884867, 48.53425271492436],
                            [1.989246117024498, 48.5345377801789],
                            [1.989614076350927, 48.53468880335194],
                            [1.990160848724494, 48.53488557870415],
                            [1.990664882233726, 48.53504653203461],
                            [1.991233470745683, 48.53519816188031],
                            [1.991769999235982, 48.535323520199746],
                            [1.992213614470143, 48.53541528136816],
                            [1.992904314196555, 48.53552444684039],
                            [1.99367759402475, 48.535607686034794],
                            [1.994143166368439, 48.53563288694631],
                            [1.99467327654999, 48.535651142265905],
                            [1.995164104772484, 48.53565024278171],
                            [1.995901990362833, 48.535620622584574],
                        ],
                    },
                },
                211: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.52091778489184, 2.626144867080216],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 4304.739207,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.599304265919263,
                            48.515049655815545,
                            2.652441044420506,
                            48.52824560466065,
                        ),
                        "coordinates": [
                            [2.652441044420506, 48.5277977343036],
                            [2.651489225559338, 48.527969506856465],
                            [2.651028031568304, 48.52804542428913],
                            [2.650278770255548, 48.52817069843449],
                            [2.649981316073498, 48.528208165835125],
                            [2.649716165376932, 48.52823352577011],
                            [2.649538660921548, 48.528244682772204],
                            [2.649358302096582, 48.52824560466065],
                            [2.649035074246412, 48.52823454856931],
                            [2.648726427197078, 48.52821445521793],
                            [2.648444406908526, 48.528181469656616],
                            [2.648139431084696, 48.52813648974451],
                            [2.64786026178536, 48.528093727393056],
                            [2.647264510565324, 48.52796105153835],
                            [2.646698173370978, 48.527801051666025],
                            [2.646335118477055, 48.52767111077758],
                            [2.645924601123552, 48.52749921217977],
                            [2.645634018619189, 48.52736061776811],
                            [2.645231967123099, 48.52714858644443],
                            [2.644847192137414, 48.52689933566662],
                            [2.644418929397711, 48.526590553226384],
                            [2.643620231995226, 48.52593985248545],
                            [2.643097233017624, 48.525565267949425],
                            [2.642794943686103, 48.52536475518051],
                            [2.642164701116606, 48.52502473435866],
                            [2.641720848717082, 48.52483438512334],
                            [2.641332734687247, 48.52468165473522],
                            [2.640954121695803, 48.524532494311885],
                            [2.640093738517779, 48.52418858234178],
                            [2.639578179588021, 48.52400291413874],
                            [2.638814625237293, 48.52377384021085],
                            [2.638390205599792, 48.52365896476726],
                            [2.637452101019002, 48.52344203591286],
                            [2.636561713918897, 48.52327982869425],
                            [2.635565866583197, 48.523138575666266],
                            [2.633511939065768, 48.52285980360623],
                            [2.631039315325018, 48.52251014020595],
                            [2.629997341086728, 48.522346476499735],
                            [2.629452934023944, 48.522245748867654],
                            [2.628836080801009, 48.52210933985746],
                            [2.62831371265814, 48.521982049844134],
                            [2.627724098599113, 48.52182176870779],
                            [2.627153256810648, 48.521661364482],
                            [2.626486181977524, 48.52143964787353],
                            [2.62585921819042, 48.52121054397652],
                            [2.62501519826064, 48.52085928363604],
                            [2.624040790557002, 48.52043011078196],
                            [2.623484417153311, 48.52019141635272],
                            [2.622032347584952, 48.51955120853955],
                            [2.621249345616701, 48.51920875899237],
                            [2.620603391664902, 48.51892261424376],
                            [2.620040243256816, 48.51867672635145],
                            [2.619171815600943, 48.518303001536346],
                            [2.61791802298259, 48.517759367107885],
                            [2.616660740923838, 48.517312848304954],
                            [2.616169892242245, 48.517160285984744],
                            [2.615524579608531, 48.51697932485183],
                            [2.614921407363884, 48.516829730492326],
                            [2.614128661603245, 48.51666620918174],
                            [2.613634089145572, 48.51657209667064],
                            [2.61294035894753, 48.516455918917835],
                            [2.612267417627047, 48.51635224625796],
                            [2.61179299513362, 48.51628072203051],
                            [2.609359994178583, 48.51591070887729],
                            [2.608749866080982, 48.515818299316734],
                            [2.608081196528596, 48.51571683890171],
                            [2.607088815154976, 48.51556594473757],
                            [2.605826148260457, 48.51537444985189],
                            [2.604851951272825, 48.515237697441115],
                            [2.604137956304632, 48.51513899311251],
                            [2.603508164506213, 48.515081455483035],
                            [2.602924740609365, 48.51505282130296],
                            [2.602357598733199, 48.515049655815545],
                            [2.600173328535484, 48.515108708645215],
                            [2.599506222005111, 48.51514263245651],
                            [2.599304265919263, 48.51515145414115],
                        ],
                    },
                },
                212: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.90585344080832, 2.46542538916796],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 772.43812341,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.460523403674419,
                            48.90470320378032,
                            2.469971544978576,
                            48.90670063080091,
                        ),
                        "coordinates": [
                            [2.469971544978576, 48.90470320378032],
                            [2.469705581429786, 48.90527670641671],
                            [2.469686018911685, 48.905307506314074],
                            [2.469648651037504, 48.9053503463571],
                            [2.469602014757477, 48.90538903733753],
                            [2.469547152945768, 48.905422713339824],
                            [2.469485288753148, 48.90545062345811],
                            [2.469417806389947, 48.90547214340331],
                            [2.469346211390938, 48.9054867924148],
                            [2.469272104593556, 48.90549424303839],
                            [2.469221039393303, 48.905495104920305],
                            [2.468180585833174, 48.905535701349926],
                            [2.468086162773788, 48.905540786702566],
                            [2.467969175013784, 48.905553696400304],
                            [2.467880769388707, 48.905567588197584],
                            [2.467815105715589, 48.90558246858462],
                            [2.467576252133193, 48.90565689986793],
                            [2.467520223304738, 48.90567461075323],
                            [2.467431243301111, 48.905696075379005],
                            [2.467339084865083, 48.9057105849973],
                            [2.467244992824449, 48.90571794369407],
                            [2.467140499291809, 48.905717649755225],
                            [2.466205370033744, 48.9057071244155],
                            [2.46546518313828, 48.905711713112225],
                            [2.465228240399152, 48.90571196577839],
                            [2.46510030436569, 48.90571579211301],
                            [2.464973361094033, 48.90572695295135],
                            [2.46484837723056, 48.90574536628228],
                            [2.464726300946452, 48.90577088976285],
                            [2.464608065940123, 48.90580332972881],
                            [2.464606102060072, 48.905803936972184],
                            [2.46433917354481, 48.9058992493938],
                            [2.464224425292458, 48.90593668939942],
                            [2.464081495867911, 48.90597590343516],
                            [2.463934687090267, 48.906008295825174],
                            [2.463812190610341, 48.906029611359614],
                            [2.462944236708066, 48.9061719340242],
                            [2.462578711499976, 48.90623418814636],
                            [2.462257207395177, 48.90629881599506],
                            [2.461855003217617, 48.90639328437512],
                            [2.46136850247316, 48.90652319063485],
                            [2.461220618119033, 48.906560989551565],
                            [2.461074048569321, 48.90659379049016],
                            [2.460523403674419, 48.90670063080091],
                        ],
                    },
                },
                213: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.52177361645987, 2.585466944622349],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 2654.10401673,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.572073662735742,
                            48.51515145414115,
                            2.599304265919263,
                            48.529746918576464,
                        ),
                        "coordinates": [
                            [2.599304265919263, 48.51515145414115],
                            [2.59887562610162, 48.51517017440106],
                            [2.598245040143599, 48.51519951042084],
                            [2.597770171013025, 48.515241073895425],
                            [2.596939690274288, 48.51535269662779],
                            [2.596227049971859, 48.51548112882047],
                            [2.595353722854649, 48.51568456202822],
                            [2.594773839087644, 48.515836063059595],
                            [2.593507432400048, 48.51619774836117],
                            [2.592976457502738, 48.51638689745907],
                            [2.592568591560144, 48.51656407527451],
                            [2.592007208345519, 48.516842481208585],
                            [2.591533165786993, 48.51710416887128],
                            [2.590742306748619, 48.51756367096046],
                            [2.590329382343046, 48.51781459093654],
                            [2.590323981338558, 48.51781730078016],
                            [2.58992724196531, 48.51805739275638],
                            [2.588269986247771, 48.51904397943652],
                            [2.587862498101782, 48.51930387207674],
                            [2.587264818536509, 48.519699072431024],
                            [2.587008575186801, 48.51988848430887],
                            [2.586455845235856, 48.52034203287396],
                            [2.586074888780608, 48.52067852066144],
                            [2.585763363453361, 48.52100451524352],
                            [2.584855951388392, 48.522005585617954],
                            [2.584086927840274, 48.52280221467334],
                            [2.583798553263469, 48.52306992479124],
                            [2.583090876584879, 48.52368566300801],
                            [2.582779310415092, 48.52391924878109],
                            [2.582141330092338, 48.52439724158895],
                            [2.581822892099882, 48.52461195605406],
                            [2.581185690125076, 48.52504204958687],
                            [2.580680568601538, 48.52537752830194],
                            [2.579994681359997, 48.525809249881114],
                            [2.57960659413182, 48.52605976033186],
                            [2.578859209425171, 48.52651307624202],
                            [2.578204476999259, 48.52690541927283],
                            [2.577727879965257, 48.527171951217774],
                            [2.577085099586342, 48.52751503673576],
                            [2.576532743339013, 48.527787271103755],
                            [2.575761436809097, 48.52816620678575],
                            [2.575119723175314, 48.52845442504817],
                            [2.57426848464177, 48.52881322038668],
                            [2.572452964537946, 48.52959084623357],
                            [2.572443136513669, 48.52959505512437],
                            [2.572073662735742, 48.529746918576464],
                        ],
                    },
                },
                214: {
                    "attributes": {
                        "reseau": "RER D",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER D",
                        "rer": 1,
                        "extcode": "800:D",
                        "geo_point_2d": [48.56911565976585, 2.485574868793531],
                        "indice_lig": "D",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01728",
                        "navette": 0,
                        "idrefliga": "A01842",
                        "shape_leng": 1341.75092707,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.479469169601778,
                            48.5661178207362,
                            2.492713002881577,
                            48.57380779355899,
                        ),
                        "coordinates": [
                            [2.492713002881577, 48.5661178207362],
                            [2.491819478699903, 48.566345662792685],
                            [2.490618651029176, 48.56666114502516],
                            [2.488962922873594, 48.567096828853785],
                            [2.488384904907827, 48.56727296080031],
                            [2.487972960925036, 48.56741009091336],
                            [2.487434736430953, 48.56760156149464],
                            [2.48691372236041, 48.5678135805795],
                            [2.486375187785103, 48.568057993210445],
                            [2.485858366782099, 48.56831586379911],
                            [2.48530374239909, 48.56862144323904],
                            [2.484772201664366, 48.568945873165646],
                            [2.484286764404232, 48.569283730352],
                            [2.482568310495115, 48.570562008657475],
                            [2.482083011867324, 48.57095830785134],
                            [2.481573562170229, 48.57144006496315],
                            [2.480938483708071, 48.572060466874255],
                            [2.480900645604948, 48.57209648477394],
                            [2.480861457132637, 48.572134303983496],
                            [2.480399334419026, 48.57258901814628],
                            [2.48013729529505, 48.57288340831681],
                            [2.479779439773886, 48.573317305298026],
                            [2.479552738788886, 48.57365121680028],
                            [2.479469169601778, 48.57380779355899],
                        ],
                    },
                },
                215: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.43712714134036, 2.756774937871566],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 1447.60649302,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.753177568842823,
                            48.430970724114694,
                            2.760926733738456,
                            48.442882064226566,
                        ),
                        "coordinates": [
                            [2.753177568842823, 48.430970724114694],
                            [2.753227367847633, 48.43108280821532],
                            [2.75339639305608, 48.431422105938125],
                            [2.754164768115173, 48.43276305632415],
                            [2.754629576730084, 48.433628840442324],
                            [2.755394865834612, 48.43497580257816],
                            [2.755929416209419, 48.43587488365372],
                            [2.756147380557123, 48.436244572186816],
                            [2.756363958669194, 48.43660976815724],
                            [2.756601118571874, 48.43701175793484],
                            [2.757408964657009, 48.43842509495271],
                            [2.757838092539092, 48.43917950611003],
                            [2.758226072944558, 48.439818093906354],
                            [2.758465072481294, 48.440174098574076],
                            [2.758744445361875, 48.44054058274868],
                            [2.759161056041372, 48.44106239900572],
                            [2.759440760725487, 48.44138390370022],
                            [2.759751457988305, 48.44171285281196],
                            [2.760926733738456, 48.442882064226566],
                        ],
                    },
                },
                216: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.93266764439456, 2.3746568031244317],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 564.49835856,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.37108317162386,
                            48.93173482548615,
                            2.378225490397901,
                            48.9335864037298,
                        ),
                        "coordinates": [
                            [2.378225490397901, 48.93173482548615],
                            [2.377990238522344, 48.9317608360259],
                            [2.377800559586583, 48.931784740074846],
                            [2.377624106595516, 48.931816152312585],
                            [2.377399780304581, 48.931870540581464],
                            [2.377175626954585, 48.93193199143018],
                            [2.376882129937261, 48.932022666076314],
                            [2.376507285053355, 48.93213496283342],
                            [2.376258160617174, 48.93220500243233],
                            [2.375977233618566, 48.93227181205202],
                            [2.375693535522128, 48.93233824686265],
                            [2.375471988690423, 48.93239394007178],
                            [2.375155502583231, 48.93248674429097],
                            [2.374582327641469, 48.9326815984969],
                            [2.373333985901969, 48.93310377549099],
                            [2.373017489575142, 48.93319425563207],
                            [2.372676367147772, 48.933280107805395],
                            [2.372268415246179, 48.933368296954356],
                            [2.371863972598721, 48.93344721437942],
                            [2.37108317162386, 48.9335864037298],
                        ],
                    },
                },
                217: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.07394314421013, 2.3392798008692384],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 2085.12463312,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.327669570460789,
                            49.068530235211696,
                            2.35083083355881,
                            49.079470233982065,
                        ),
                        "coordinates": [
                            [2.327669570460789, 49.068530235211696],
                            [2.328714085613412, 49.068980939458065],
                            [2.331555889767361, 49.07034789591556],
                            [2.333152513976816, 49.07108456999683],
                            [2.333887987614685, 49.0714305778981],
                            [2.335303955010883, 49.072089680652134],
                            [2.338052702632552, 49.07337214662515],
                            [2.340682072555365, 49.07459268705621],
                            [2.343282596530885, 49.075801272500435],
                            [2.343619818528195, 49.07596029535128],
                            [2.344972356117883, 49.076599591564225],
                            [2.348765940056676, 49.07836543501684],
                            [2.349157498836323, 49.07854884543927],
                            [2.34971335369105, 49.07881227267111],
                            [2.3501431024938, 49.07905085497304],
                            [2.350581437189748, 49.079312529418345],
                            [2.35083083355881, 49.079470233982065],
                        ],
                    },
                },
                218: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.91673341604137, 2.4213300633444628],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 579.584518889,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.417691093337975,
                            48.915837892883054,
                            2.425009894274451,
                            48.917783725255454,
                        ),
                        "coordinates": [
                            [2.425009894274451, 48.915837892883054],
                            [2.423426826501466, 48.91615965643257],
                            [2.42263248303036, 48.91633869564315],
                            [2.422375918355764, 48.91640609231264],
                            [2.422126397139699, 48.91648043619281],
                            [2.421725787112236, 48.9166174615369],
                            [2.421481356616688, 48.91669348963934],
                            [2.421329893519381, 48.916734841614556],
                            [2.420415099354189, 48.916954392876434],
                            [2.419887606234933, 48.917089245991086],
                            [2.419254188769923, 48.91727155360557],
                            [2.418853658150199, 48.91739461532926],
                            [2.418485607907105, 48.91751194297783],
                            [2.417691093337975, 48.917783725255454],
                        ],
                    },
                },
                219: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.91998689192097, 2.4122203750888245],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 297.447108459,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.410598615094689,
                            48.919179027725846,
                            2.41383718095636,
                            48.920785969955396,
                        ),
                        "coordinates": [
                            [2.41383718095636, 48.919179027725846],
                            [2.413212194384826, 48.919493980535684],
                            [2.412774822946779, 48.91974762395063],
                            [2.412571024109022, 48.91984740791715],
                            [2.412314487720756, 48.91995417847965],
                            [2.412116330696243, 48.92002959958562],
                            [2.411935929597778, 48.92010823615369],
                            [2.410598615094689, 48.920785969955396],
                        ],
                    },
                },
                220: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.99796489265113, 2.5317061007929005],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 6430.61878118,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.514360285533493,
                            48.97342490721535,
                            2.561232695225106,
                            49.00975645213836,
                        ),
                        "coordinates": [
                            [2.514360285533493, 48.97342490721535],
                            [2.515393263594468, 48.974892772869225],
                            [2.517718185511947, 48.97819976141486],
                            [2.519467807032124, 48.980689598485725],
                            [2.519742526133311, 48.981078898219415],
                            [2.52000746380691, 48.98146178875312],
                            [2.520197220061898, 48.98174843592305],
                            [2.520347779255573, 48.98199231760475],
                            [2.520488612558998, 48.982244779314236],
                            [2.520639397545857, 48.98254861868227],
                            [2.520754205528181, 48.98280112251762],
                            [2.520856039043879, 48.98306435346333],
                            [2.520934967814882, 48.98329121775053],
                            [2.521007384332063, 48.9835180910038],
                            [2.521079917306177, 48.98377494592646],
                            [2.521139556652976, 48.98406393997992],
                            [2.521192773969197, 48.984376502331735],
                            [2.521226423432624, 48.98467624706681],
                            [2.521250223408343, 48.98495245189641],
                            [2.521257700506907, 48.98521369215792],
                            [2.521252125576408, 48.98546424686898],
                            [2.521236764089628, 48.98570839411733],
                            [2.521202055781671, 48.98599968178228],
                            [2.521132024536406, 48.98641737251204],
                            [2.521087226341204, 48.986620878243215],
                            [2.521013432482801, 48.98690152456949],
                            [2.520637630095882, 48.98822124009513],
                            [2.52026501120734, 48.98952810305979],
                            [2.520178198423098, 48.98981090908115],
                            [2.520094475495744, 48.99004873900618],
                            [2.519988065217984, 48.99031230385261],
                            [2.519881599698468, 48.99056087821723],
                            [2.519771801513882, 48.99078804470322],
                            [2.519645760767343, 48.99102380017194],
                            [2.519509967114661, 48.991261714113556],
                            [2.519367705430668, 48.991510345893296],
                            [2.518785614208525, 48.99250488862331],
                            [2.518663940651673, 48.99272850810477],
                            [2.518548743118225, 48.9929857610214],
                            [2.51841791152753, 48.99329862199918],
                            [2.518329524503683, 48.993670470474164],
                            [2.518257103208032, 48.99407703533845],
                            [2.518205809556509, 48.99448703984075],
                            [2.518212606673171, 48.99473374652227],
                            [2.518229616440271, 48.99493501325487],
                            [2.518262941514691, 48.99514910271857],
                            [2.518306022171094, 48.995361034489164],
                            [2.518378533119977, 48.99561146672925],
                            [2.518444326834417, 48.99580408969404],
                            [2.5185494980788, 48.996086590445124],
                            [2.518730602344485, 48.99643244720212],
                            [2.518907702542956, 48.99669960025212],
                            [2.51909941644108, 48.99695299230068],
                            [2.519318430901336, 48.99721603766328],
                            [2.519563499579044, 48.99748332597616],
                            [2.519841161045308, 48.99776340874519],
                            [2.520122010129798, 48.998024212563486],
                            [2.522349199686013, 49.000061403624784],
                            [2.523440048286008, 49.001070381478584],
                            [2.523629528603032, 49.00125851891976],
                            [2.523913836292266, 49.0015621364957],
                            [2.524080554783236, 49.00175459078642],
                            [2.524283246776067, 49.00199195759419],
                            [2.524505661249694, 49.00228068354199],
                            [2.524750946355387, 49.00259078669496],
                            [2.52511068855266, 49.00304203615561],
                            [2.525362458389907, 49.00334356157268],
                            [2.525623978532358, 49.0036407897875],
                            [2.525878845930051, 49.003899479488815],
                            [2.526117258765225, 49.004111087278076],
                            [2.526365400312325, 49.00431197113942],
                            [2.526704870926082, 49.004561954732495],
                            [2.527037685331536, 49.00477340312837],
                            [2.527328021725017, 49.00494209380831],
                            [2.527598736441719, 49.00508511850118],
                            [2.527980265288008, 49.005266502743225],
                            [2.528322599826032, 49.0054115482652],
                            [2.528658365219273, 49.00554161307144],
                            [2.528990821024291, 49.00565669382984],
                            [2.529310192921969, 49.00575466337127],
                            [2.529603449263512, 49.005833403443155],
                            [2.530062831188062, 49.00594184241444],
                            [2.530453732273655, 49.00601827311647],
                            [2.530867378564925, 49.006083958627585],
                            [2.531199591467566, 49.006134789793194],
                            [2.531548021234403, 49.00617060353766],
                            [2.531922456541273, 49.00619780611901],
                            [2.532251263526683, 49.00621009522694],
                            [2.532742797939719, 49.00621567947264],
                            [2.533178937282292, 49.00620636842332],
                            [2.533527155276757, 49.006188640989144],
                            [2.534152009602865, 49.00615972940619],
                            [2.535017664707053, 49.00611326798355],
                            [2.535496065945075, 49.006091025102464],
                            [2.536068827286857, 49.00606005315039],
                            [2.536583022628391, 49.00603560274131],
                            [2.537090726425559, 49.006015444010224],
                            [2.537598465651282, 49.006003850063244],
                            [2.538073723603044, 49.00600944149606],
                            [2.538594584339257, 49.00602351508457],
                            [2.538972236459689, 49.00603998223226],
                            [2.541195917989215, 49.00616024454069],
                            [2.545662837171938, 49.006398461515154],
                            [2.546847958585747, 49.00646482188928],
                            [2.547342835043416, 49.00648961105501],
                            [2.547795412657332, 49.006518760054114],
                            [2.548150329259859, 49.00654594452661],
                            [2.548550856475564, 49.00658161091718],
                            [2.548948199691394, 49.006634411953655],
                            [2.54932675403193, 49.0066822889805],
                            [2.550153074983159, 49.00683992805838],
                            [2.550737357371696, 49.00696815071972],
                            [2.551228653275078, 49.007105008684775],
                            [2.551669488697603, 49.00725975925561],
                            [2.553108599054325, 49.00781460799817],
                            [2.553866245491355, 49.00812650813554],
                            [2.555402243342059, 49.00870774249366],
                            [2.555995034400608, 49.00890535185251],
                            [2.556592116078286, 49.00907387480147],
                            [2.557115572534614, 49.00920075953147],
                            [2.557616713047839, 49.00930062303462],
                            [2.558175686612269, 49.00940598825874],
                            [2.558698933624695, 49.00948435658386],
                            [2.559235550571284, 49.009553876749614],
                            [2.559845911461627, 49.009623252208236],
                            [2.561232695225106, 49.00975645213836],
                        ],
                    },
                },
                221: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.94690104205246, 2.337943146402199],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 2995.47612694,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.32824501026232,
                            48.93445554506131,
                            2.345604378196291,
                            48.958269604608034,
                        ),
                        "coordinates": [
                            [2.345604378196291, 48.93445554506131],
                            [2.34552682729569, 48.934759881220835],
                            [2.345435526614926, 48.935194669214006],
                            [2.345360667089803, 48.93555115323384],
                            [2.345304141024547, 48.93586840064392],
                            [2.345187141814928, 48.936525023869564],
                            [2.345094819779337, 48.93693648596403],
                            [2.344825212527904, 48.938001662135036],
                            [2.344718752966593, 48.93841979525869],
                            [2.344611081014025, 48.93884268321627],
                            [2.34445438759634, 48.93922909944737],
                            [2.344318818865329, 48.93960593663021],
                            [2.344199675596359, 48.93993191450605],
                            [2.344073302064426, 48.9402222023237],
                            [2.343784447655979, 48.94091698912217],
                            [2.343567793834791, 48.94139287038358],
                            [2.343405297819504, 48.94170933256215],
                            [2.343188624089768, 48.94207814333833],
                            [2.342953884887095, 48.942411264627516],
                            [2.34271552642032, 48.94273486821583],
                            [2.342329083715866, 48.94316316970892],
                            [2.341888451584169, 48.943608127361564],
                            [2.341577835338476, 48.94387938653777],
                            [2.341296109545675, 48.94411733240661],
                            [2.340952975273245, 48.94439334912475],
                            [2.340382279712963, 48.944795478745384],
                            [2.339327549259685, 48.94551882780223],
                            [2.338760437553038, 48.945901914348276],
                            [2.338247501223794, 48.94624692676937],
                            [2.33785015168668, 48.94653007376765],
                            [2.337387774586994, 48.94689173748575],
                            [2.337044601839636, 48.94719629528594],
                            [2.336668912202581, 48.947557956116526],
                            [2.336418315320437, 48.94783369425153],
                            [2.336361852815723, 48.94789582213892],
                            [2.33608007716816, 48.948240824593505],
                            [2.33576578286533, 48.948645311354845],
                            [2.335559862419661, 48.948945106049166],
                            [2.335364777086415, 48.94924966000805],
                            [2.335194977619876, 48.94954469646904],
                            [2.334429046671183, 48.95092946083693],
                            [2.334259234623968, 48.9512268749831],
                            [2.334093034053209, 48.951529047154985],
                            [2.333901541167026, 48.95184549567271],
                            [2.333724500337994, 48.952126252789114],
                            [2.33246349174877, 48.95389882173151],
                            [2.332004592777578, 48.95454836445361],
                            [2.331675770706241, 48.95498852971],
                            [2.331328881441106, 48.955393000881635],
                            [2.331010897605432, 48.955735611255236],
                            [2.330743501400027, 48.95601160089214],
                            [2.330407443727636, 48.956354208445674],
                            [2.329955748658342, 48.95680863701481],
                            [2.329579937771228, 48.957148859850385],
                            [2.328972850049945, 48.957681793189806],
                            [2.328322390158605, 48.958212340049705],
                            [2.32824501026232, 48.958269604608034],
                        ],
                    },
                },
                222: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.1380598109603, 2.2723418012754895],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1901.06508262,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.267674786874433,
                            49.132577702391806,
                            2.280515369819846,
                            49.14528660789949,
                        ),
                        "coordinates": [
                            [2.280515369819846, 49.132577702391806],
                            [2.27565936485099, 49.13454062027236],
                            [2.274687083291566, 49.134932686664044],
                            [2.27412837303634, 49.13516079772366],
                            [2.273689365759236, 49.13535328260266],
                            [2.273341035287542, 49.13552678182589],
                            [2.272963638695093, 49.1357407114609],
                            [2.272607952052375, 49.13598796219108],
                            [2.272306675190137, 49.13622096790012],
                            [2.272001708776877, 49.13649917629721],
                            [2.271685798336763, 49.136824965649225],
                            [2.270029841963733, 49.13859185120883],
                            [2.268439142618548, 49.14028737212342],
                            [2.26817393733281, 49.140625077022],
                            [2.267981311096413, 49.140927135732966],
                            [2.267817627562239, 49.14127679768858],
                            [2.267737454764108, 49.14155513068775],
                            [2.267678932094973, 49.14190961473698],
                            [2.267674786874433, 49.14228078535519],
                            [2.267732310361471, 49.142640098585574],
                            [2.267837030870093, 49.14296374942959],
                            [2.267967214367085, 49.143235069968526],
                            [2.268159021828312, 49.14352784117683],
                            [2.268394369927039, 49.14380874219874],
                            [2.268687713633045, 49.14411584911734],
                            [2.268937644669891, 49.14434679097185],
                            [2.269270947505275, 49.14461109207766],
                            [2.269651444988593, 49.14484448919205],
                            [2.270039114589342, 49.14504174548885],
                            [2.270552769414137, 49.14528660789949],
                        ],
                    },
                },
                223: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.829590814229746, 2.306428691903834],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 3287.91237839,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.292061814554318,
                            48.81838763956164,
                            2.320509227539884,
                            48.841186920243864,
                        ),
                        "coordinates": [
                            [2.292061814554318, 48.81838763956164],
                            [2.292063215351291, 48.81838838895092],
                            [2.292554771060914, 48.81865161255986],
                            [2.293235393541554, 48.819056361381406],
                            [2.294139273426576, 48.81963488165732],
                            [2.294801881437852, 48.82007054623802],
                            [2.2952938573242, 48.820437987625624],
                            [2.295885726493976, 48.82091377045482],
                            [2.296321399688822, 48.82130413649662],
                            [2.296850718517542, 48.821749259187285],
                            [2.297545684405248, 48.82234195481006],
                            [2.298071434702834, 48.82277041559989],
                            [2.299465078654862, 48.82390820243954],
                            [2.300945242268247, 48.82508406607587],
                            [2.303549153206343, 48.8272238682784],
                            [2.305288812554795, 48.82866385421778],
                            [2.306380208050093, 48.829558777861976],
                            [2.307323957912953, 48.830329927679344],
                            [2.309290836804992, 48.83186270435911],
                            [2.310022123292139, 48.83246722754302],
                            [2.310436406341613, 48.832809946388],
                            [2.310857899660154, 48.833162182809986],
                            [2.311582025943372, 48.83375003926354],
                            [2.312893438726868, 48.83477819039799],
                            [2.314255341069606, 48.83586343947946],
                            [2.314568807512882, 48.83610381335719],
                            [2.31484984447211, 48.836329903848586],
                            [2.315250124707188, 48.836680150934235],
                            [2.316400888248523, 48.83771801315104],
                            [2.31680803621099, 48.83809639901349],
                            [2.318112438906453, 48.839186352114176],
                            [2.320509227539884, 48.841186920243864],
                        ],
                    },
                },
                224: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [49.008992128501205, 2.5672579152749813],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 1195.36389945,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.561232695225106,
                            49.00468746180567,
                            2.57058948552452,
                            49.010323008541455,
                        ),
                        "coordinates": [
                            [2.561232695225106, 49.00975645213836],
                            [2.566933315888485, 49.01030381116595],
                            [2.566994848324108, 49.010309258439534],
                            [2.567169126287478, 49.01031974229678],
                            [2.56734406179033, 49.010323008541455],
                            [2.567518964603455, 49.010319039397665],
                            [2.567693141449908, 49.01030785484905],
                            [2.567865907067921, 49.01028949739211],
                            [2.568036580044855, 49.010264040114],
                            [2.568204486949174, 49.01023158311038],
                            [2.568368962323955, 49.01019225438452],
                            [2.568529359608517, 49.010146211684635],
                            [2.568685045768951, 49.010093630794536],
                            [2.568835405250774, 49.010034723531945],
                            [2.568979844184409, 49.00996972517399],
                            [2.569117791835329, 49.009898884571],
                            [2.569248705877909, 49.009822487544184],
                            [2.569372071230316, 49.00974083260265],
                            [2.569487398575887, 49.00965424442557],
                            [2.569594231294806, 49.00956306219702],
                            [2.56969214949691, 49.0094676477128],
                            [2.569780767355098, 49.0093683772777],
                            [2.569859734471483, 49.00926564170976],
                            [2.569928739977285, 49.009159846354734],
                            [2.569987509820637, 49.00905140837844],
                            [2.570035813570076, 49.00894076038749],
                            [2.570073460461935, 49.00882833243077],
                            [2.570100300594615, 49.00871457268526],
                            [2.570112437716692, 49.00863573405281],
                            [2.57058948552452, 49.00468746180567],
                        ],
                    },
                },
                225: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.97660283337612, 2.300035279742222],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1320.83868052,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.292477128819507,
                            48.972749119759264,
                            2.307137032071533,
                            48.9794479829515,
                        ),
                        "coordinates": [
                            [2.307137032071533, 48.972749119759264],
                            [2.306894158072118, 48.972913200039194],
                            [2.306451383665558, 48.97321434113163],
                            [2.305326661217574, 48.97397482562643],
                            [2.304248387110239, 48.974680455821535],
                            [2.303272628965902, 48.97525391322202],
                            [2.302027637899256, 48.9759531795682],
                            [2.30107647610827, 48.976444790948634],
                            [2.300390459437297, 48.97675572500292],
                            [2.299588440994141, 48.97711234527124],
                            [2.298772732575371, 48.97745327439792],
                            [2.297903298149639, 48.97779447069571],
                            [2.297140757257672, 48.97807928049051],
                            [2.296019737740486, 48.97847734767796],
                            [2.295284316545156, 48.97871406598963],
                            [2.29446429243953, 48.978962169468424],
                            [2.293514126699586, 48.9792173559293],
                            [2.292830739502113, 48.979375363324145],
                            [2.292477128819507, 48.9794479829515],
                        ],
                    },
                },
                226: {
                    "attributes": {
                        "reseau": "PARIS RIVE GAUCHE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE N",
                        "rer": 0,
                        "extcode": "800:N",
                        "geo_point_2d": [48.81343684350115, 2.2576414460161507],
                        "indice_lig": "N",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01736",
                        "navette": 0,
                        "idrefliga": "A01847",
                        "shape_leng": 2513.01998193,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.240919294866535,
                            48.8126035833289,
                            2.274489672177882,
                            48.81488431421452,
                        ),
                        "coordinates": [
                            [2.240919294866535, 48.81488431421452],
                            [2.241726748463877, 48.81466133223218],
                            [2.242339521055581, 48.814502426292414],
                            [2.242876561607956, 48.81438152371835],
                            [2.243601010146782, 48.814225082183285],
                            [2.244044311335397, 48.814137408477],
                            [2.244811968641806, 48.81399051098299],
                            [2.248041096454325, 48.81338396064823],
                            [2.24933488683262, 48.81314226835762],
                            [2.250109707258579, 48.813000099215266],
                            [2.250834043158753, 48.812884060873834],
                            [2.251551137127898, 48.81278704631829],
                            [2.252282597272691, 48.812713831706816],
                            [2.253006824031245, 48.81265726293035],
                            [2.253734617081729, 48.81261972527513],
                            [2.254440759709511, 48.8126035833289],
                            [2.255172077863239, 48.8126136261862],
                            [2.255899761086372, 48.81264269745161],
                            [2.25662740828471, 48.8126955566814],
                            [2.257481113554087, 48.812769912924445],
                            [2.258331227074339, 48.812839502753405],
                            [2.259177735732794, 48.81291146287018],
                            [2.260020642353675, 48.81298579336772],
                            [2.263165351898009, 48.81326149121986],
                            [2.265387930932504, 48.81345087413204],
                            [2.270589594529998, 48.81391560582077],
                            [2.272977807351703, 48.81411477416988],
                            [2.273475067343621, 48.81415755907355],
                            [2.274489672177882, 48.81423944550172],
                        ],
                    },
                },
                227: {
                    "attributes": {
                        "reseau": "CDGVAL",
                        "val": 1,
                        "metro": 0,
                        "res_com": "CDGVAL",
                        "rer": 0,
                        "extcode": "043043100:CDGVAL",
                        "geo_point_2d": [49.0073852922682, 2.5709674566631833],
                        "indice_lig": "CDG",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Navette",
                        "tramway": 0,
                        "idrefligc": "C00563",
                        "navette": 1,
                        "idrefliga": "A01516",
                        "shape_leng": 593.502497166,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.570640068890432,
                            49.00472562449587,
                            2.571294844435935,
                            49.01004496004053,
                        ),
                        "coordinates": [
                            [2.570640068890432, 49.01004496004053],
                            [2.571294844435935, 49.00472562449587],
                        ],
                    },
                },
                228: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [49.0924694061026, 2.3120933777191293],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 6794.94954186,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.287258769653332,
                            49.068530235211696,
                            2.332268008349061,
                            49.114061951542226,
                        ),
                        "coordinates": [
                            [2.327669570460789, 49.068530235211696],
                            [2.328038899836222, 49.06872774835301],
                            [2.328379264756656, 49.06892525848934],
                            [2.328676176403118, 49.0691180065254],
                            [2.328983949716981, 49.069344065005964],
                            [2.329179472928231, 49.069508251543276],
                            [2.329360515503158, 49.06966767941749],
                            [2.329570522942775, 49.06986755607332],
                            [2.329791390118977, 49.07010312444122],
                            [2.330052085913148, 49.0704053156475],
                            [2.331366468790297, 49.07199240033275],
                            [2.331598215740878, 49.07227555195412],
                            [2.331797367797573, 49.07257059859203],
                            [2.331974874701607, 49.07288350252421],
                            [2.332072550278713, 49.0731249944843],
                            [2.332152201816522, 49.07337244835855],
                            [2.332210122745445, 49.07362703948198],
                            [2.332253554719168, 49.07392445752204],
                            [2.332268008349061, 49.07427421970068],
                            [2.332249873440238, 49.07455260085012],
                            [2.332199141035724, 49.07487380898436],
                            [2.332104944450692, 49.07520691156585],
                            [2.332003508792088, 49.0754733920773],
                            [2.331891212154573, 49.07570656170569],
                            [2.331731827631216, 49.07596828054261],
                            [2.331586934681513, 49.07617051788867],
                            [2.331402195507324, 49.07641082086371],
                            [2.331173993251632, 49.076653501839004],
                            [2.330956659677541, 49.07686049282034],
                            [2.330703102629793, 49.077072238785995],
                            [2.33040245962997, 49.077298259623554],
                            [2.330032994790309, 49.07753141222436],
                            [2.329685266863023, 49.07772173705681],
                            [2.329304938153184, 49.077902542004274],
                            [2.328913740944432, 49.078080965199966],
                            [2.327544539625985, 49.07866379666528],
                            [2.326972218059813, 49.078908820056334],
                            [2.326526667687847, 49.07911578259786],
                            [2.32615718191176, 49.07930847483493],
                            [2.325769572659676, 49.07953923205923],
                            [2.325439914253079, 49.07976761573263],
                            [2.325092128031762, 49.0800554789994],
                            [2.324795044868954, 49.08035286494631],
                            [2.324555917373287, 49.08062646195659],
                            [2.324367503040595, 49.08088340951281],
                            [2.324208063182895, 49.081137980376795],
                            [2.324084847082168, 49.08138065820567],
                            [2.323961613812705, 49.081687577457664],
                            [2.32387097522335, 49.08200639774618],
                            [2.323809316133887, 49.08230618644279],
                            [2.323773011066654, 49.08262263349091],
                            [2.323776560397654, 49.082896256295385],
                            [2.323809089985613, 49.08316750370957],
                            [2.323859736651423, 49.08341496039041],
                            [2.323968307335626, 49.083793286764646],
                            [2.324304910881321, 49.084883057344186],
                            [2.324384526902926, 49.08518999925676],
                            [2.324438794128032, 49.08546600680521],
                            [2.324456849662571, 49.085699183355786],
                            [2.324449529474076, 49.08599421976928],
                            [2.324420468931485, 49.086310667915676],
                            [2.324358816301413, 49.08659142136787],
                            [2.324260928579596, 49.08689834430137],
                            [2.324141313024478, 49.087174333422304],
                            [2.323978216497334, 49.087476489767546],
                            [2.323797014644475, 49.0877453344385],
                            [2.323532472532622, 49.088073650486805],
                            [2.323286061206933, 49.088328209241745],
                            [2.323017914702043, 49.08857086967374],
                            [2.322659186377886, 49.08885396502554],
                            [2.322300466766626, 49.08908947316159],
                            [2.321909144200667, 49.08930832103963],
                            [2.321543189002131, 49.08948672189342],
                            [2.321130136024855, 49.08966749560844],
                            [2.320496066400167, 49.089917235937584],
                            [2.319909095900716, 49.09014080680531],
                            [2.319470672121568, 49.09031681137767],
                            [2.319053977121199, 49.09050947290653],
                            [2.318680751811855, 49.09070451931201],
                            [2.318314760308707, 49.090925737747284],
                            [2.317992236460335, 49.09115410084827],
                            [2.317676946315405, 49.091411015453765],
                            [2.317383377388297, 49.09169648473053],
                            [2.317136908957664, 49.09197006595916],
                            [2.316897659499486, 49.0923007507611],
                            [2.316705517562842, 49.09260765121393],
                            [2.316393703437106, 49.093178634344675],
                            [2.315944115231108, 49.09396135228037],
                            [2.31575558789445, 49.094253974798654],
                            [2.315617833207036, 49.09443239938168],
                            [2.31529159262215, 49.094796375333104],
                            [2.314990745456496, 49.09507707870352],
                            [2.314613802878118, 49.095369663231516],
                            [2.314135393244986, 49.0956883996003],
                            [2.313754856675624, 49.09589770375553],
                            [2.313309102135331, 49.09609985552999],
                            [2.312827117190319, 49.09628772234868],
                            [2.312374142862541, 49.09642324801372],
                            [2.311924795135436, 49.096544497095486],
                            [2.311431969449966, 49.09665859543148],
                            [2.310663748524728, 49.09681069934106],
                            [2.310134687678268, 49.09691764676506],
                            [2.309601992084954, 49.09704124577252],
                            [2.309112768342545, 49.09717437055678],
                            [2.308648892987908, 49.09733129218884],
                            [2.308235735716148, 49.09749536344521],
                            [2.307815309184519, 49.097695121025225],
                            [2.307423853696543, 49.09791391987519],
                            [2.307054125715642, 49.09815175628827],
                            [2.306785867107673, 49.09835630909926],
                            [2.306532099380311, 49.09856800139231],
                            [2.306300063428488, 49.098786837262374],
                            [2.306038993923108, 49.09907704603832],
                            [2.305291999580416, 49.09995243468669],
                            [2.305081680377242, 49.10019030885264],
                            [2.304798854149685, 49.1004828876242],
                            [2.304458037442235, 49.100787346106834],
                            [2.304091867467211, 49.10106800201921],
                            [2.303693105388029, 49.101312957952814],
                            [2.303239987405854, 49.10155313781977],
                            [2.302736141883567, 49.10178140392713],
                            [2.302181580935156, 49.10197872163898],
                            [2.301583534711548, 49.102171264216075],
                            [2.301047118536595, 49.102320995709675],
                            [2.30048169412737, 49.102492128441526],
                            [2.299992367569859, 49.10265852509547],
                            [2.299528387918171, 49.10284634213778],
                            [2.298999124016957, 49.103100757077414],
                            [2.298426343445829, 49.10339084484059],
                            [2.297788292845123, 49.10372373478782],
                            [2.297237256779659, 49.1039947901187],
                            [2.296805869213364, 49.10418022711995],
                            [2.296450619117983, 49.10431810433001],
                            [2.296015637627256, 49.10446070995024],
                            [2.295551675648676, 49.10458902852821],
                            [2.29509136199417, 49.10468403441923],
                            [2.294591193483939, 49.10476950760368],
                            [2.293946063870054, 49.10485730352573],
                            [2.292655796160776, 49.1050376432397],
                            [2.29210487482149, 49.10513260378288],
                            [2.291535796595178, 49.105265622732006],
                            [2.29099931184523, 49.105420066293966],
                            [2.29046751074561, 49.105616198851294],
                            [2.290089364589656, 49.105778977768985],
                            [2.289603502431451, 49.106040504616054],
                            [2.289204635662977, 49.10627827300051],
                            [2.28887461105024, 49.10652558512761],
                            [2.28860984965019, 49.106739614745834],
                            [2.288323277790877, 49.10701549549874],
                            [2.28804391394789, 49.107331826676855],
                            [2.287789876320268, 49.10768623844484],
                            [2.287608354024446, 49.10800499104566],
                            [2.28744853917153, 49.108357062918465],
                            [2.28734311246677, 49.10868298594598],
                            [2.287281163547714, 49.109020822939414],
                            [2.28725910135174, 49.10933726367102],
                            [2.287258769653332, 49.10966799009189],
                            [2.287298282229797, 49.11002014801475],
                            [2.287651213665814, 49.11227828073427],
                            [2.28782761206601, 49.11348705357541],
                            [2.287915343526005, 49.114061951542226],
                        ],
                    },
                },
                229: {
                    "attributes": {
                        "reseau": "SNCF ST LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [49.019346630068554, 1.6061956471845904],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 6084.48648559,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.581532102335019,
                            48.99739200091919,
                            1.63016762729846,
                            49.03894771561846,
                        ),
                        "coordinates": [
                            [1.63016762729846, 48.99739200091919],
                            [1.629615692017885, 48.997560837011484],
                            [1.629460504632378, 48.99761293770859],
                            [1.628593555301599, 48.99791173604998],
                            [1.627811844925676, 48.99820670406024],
                            [1.627051447103467, 48.998527972797795],
                            [1.626590581322135, 48.99873908518356],
                            [1.625833792703765, 48.99909141201894],
                            [1.624705919394252, 48.99968064198069],
                            [1.623875953985121, 49.00017729075291],
                            [1.623064757456155, 49.00069833229609],
                            [1.622288690439635, 49.001246566472055],
                            [1.621762115174275, 49.00164886765004],
                            [1.621161612675615, 49.0021504294707],
                            [1.620626207879674, 49.002597733912765],
                            [1.62019127016299, 49.00299430655519],
                            [1.619274705909445, 49.00389507108065],
                            [1.618877743323862, 49.00431076202242],
                            [1.618826428898806, 49.00436170069768],
                            [1.61876533818036, 49.00442696746323],
                            [1.617979797419733, 49.005244008365665],
                            [1.616819444509274, 49.00645348575051],
                            [1.615903376863251, 49.007405487999655],
                            [1.615853395871856, 49.0074582321737],
                            [1.615784030318514, 49.00752794171759],
                            [1.615416186179481, 49.007911429165254],
                            [1.614883064429518, 49.008472836913484],
                            [1.614460649988764, 49.00894141134471],
                            [1.614116641390115, 49.009376306620545],
                            [1.613716072504004, 49.00993944518545],
                            [1.612246992817986, 49.012052534321796],
                            [1.612090623412661, 49.01227457501104],
                            [1.611697670786939, 49.01287462592438],
                            [1.611476254545599, 49.01324374063732],
                            [1.611259054096735, 49.01360478717779],
                            [1.610957338419534, 49.01404173977259],
                            [1.610508517641199, 49.01462704438992],
                            [1.610494609991183, 49.01464314325722],
                            [1.610173086730092, 49.01503140489684],
                            [1.609101422182481, 49.016317810261654],
                            [1.608888430987631, 49.016576358383375],
                            [1.60834145057359, 49.01723207585954],
                            [1.608317758696369, 49.01726250150898],
                            [1.607870972987262, 49.01779834678812],
                            [1.60743113219538, 49.01832613999689],
                            [1.607244629524408, 49.0185488806476],
                            [1.607195864303764, 49.018610622852194],
                            [1.607159694354645, 49.0186526603572],
                            [1.607112348797088, 49.01871081359914],
                            [1.6070567067536, 49.0187752098984],
                            [1.60702189051834, 49.01881815519702],
                            [1.606928617176198, 49.01893087349594],
                            [1.606208332707137, 49.01974465529506],
                            [1.606052603434265, 49.01991992689994],
                            [1.605847956882135, 49.02016683069421],
                            [1.605726855871133, 49.020311746176425],
                            [1.605522206202155, 49.02055865022237],
                            [1.60489716127549, 49.02130918033011],
                            [1.60471481793337, 49.02152654747718],
                            [1.604260971283995, 49.02207222626804],
                            [1.604079950089932, 49.022292299401016],
                            [1.603655322379698, 49.022803088918664],
                            [1.603385256245901, 49.023126011369136],
                            [1.602626468474463, 49.02403844871774],
                            [1.602148917490556, 49.02461184590749],
                            [1.601075428533441, 49.025900865404694],
                            [1.600234392771734, 49.026912582232974],
                            [1.600109077139743, 49.027062860749005],
                            [1.59887813610613, 49.02854060299173],
                            [1.597534301366289, 49.03015519836505],
                            [1.595833825220453, 49.032199142506805],
                            [1.595299011081934, 49.0328413896036],
                            [1.593914566486216, 49.03450334490145],
                            [1.593839351155919, 49.034593687952174],
                            [1.59382262945704, 49.03461426361393],
                            [1.59339638389231, 49.03512770478363],
                            [1.593308615812961, 49.035234152840665],
                            [1.592990420852731, 49.03559079461748],
                            [1.592495485444969, 49.03609519244363],
                            [1.592073905054099, 49.036480675782855],
                            [1.591888497856948, 49.036621561973774],
                            [1.591625767104305, 49.03681050776459],
                            [1.591186573572399, 49.037090933978995],
                            [1.591135453970383, 49.03712477525534],
                            [1.591089872044565, 49.03715415523627],
                            [1.591025074916945, 49.03718790794046],
                            [1.590200486537125, 49.03762679694639],
                            [1.589762549291128, 49.037812807503855],
                            [1.589204173200386, 49.03804076380119],
                            [1.588571185036308, 49.038272665428934],
                            [1.587880403683471, 49.03846358777291],
                            [1.587189533526433, 49.038640444370174],
                            [1.586528302021865, 49.038766515443584],
                            [1.586413165277728, 49.0387819495076],
                            [1.585577184505887, 49.0388852866932],
                            [1.584968189887681, 49.03892915752503],
                            [1.58421529283523, 49.03894771561846],
                            [1.583631096623415, 49.0389471491973],
                            [1.583427382428863, 49.038940413527115],
                            [1.583145734183793, 49.038931365929116],
                            [1.582244135991481, 49.03885168604373],
                            [1.582147148993589, 49.03884295350847],
                            [1.582072045693136, 49.038834365064766],
                            [1.581756641855026, 49.03879631297051],
                            [1.581532102335019, 49.0387620447533],
                        ],
                    },
                },
                230: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.864825082740374, 2.064072127883049],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 2401.04694712,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.050767845333735,
                            48.86283275236239,
                            2.076719102677291,
                            48.86806442324713,
                        ),
                        "coordinates": [
                            [2.076719102677291, 48.86806442324713],
                            [2.07665881660464, 48.86802622947434],
                            [2.076608555495885, 48.867992841017724],
                            [2.07620390160699, 48.86769515474171],
                            [2.076112978215862, 48.867617608643776],
                            [2.076080405637447, 48.86759055587084],
                            [2.075895918837657, 48.86741927046852],
                            [2.075575979873753, 48.8670849047019],
                            [2.075325440262298, 48.86677407834343],
                            [2.075205067242472, 48.866594845507024],
                            [2.075005046250618, 48.86626884677418],
                            [2.074757327063351, 48.86583348538165],
                            [2.074559395102638, 48.865479152571915],
                            [2.074451182523806, 48.865321529418],
                            [2.07418711765022, 48.86499358376927],
                            [2.073997318972103, 48.86479890152741],
                            [2.073842656979287, 48.86466185397434],
                            [2.073643153145084, 48.864498624526114],
                            [2.073370200600273, 48.86430644711338],
                            [2.073322652421665, 48.86427666124253],
                            [2.073280522518526, 48.86425318236562],
                            [2.073011465247485, 48.86409788440096],
                            [2.072755911195044, 48.86396689715028],
                            [2.072611786289378, 48.86390001705266],
                            [2.072531565036953, 48.86386296071837],
                            [2.072305792996286, 48.86377071009561],
                            [2.071995611305614, 48.86366027835953],
                            [2.071731631113541, 48.86357693186826],
                            [2.071433560181984, 48.86349620278058],
                            [2.070790912357746, 48.863366108603],
                            [2.070560754322489, 48.86333049933857],
                            [2.069916555247065, 48.86323636887943],
                            [2.067988040587575, 48.86295755976663],
                            [2.067685701034707, 48.8629118826311],
                            [2.067345140060446, 48.86287690626078],
                            [2.067034511605546, 48.862851891749045],
                            [2.06674154903981, 48.86283681022662],
                            [2.066505767163426, 48.86283355386535],
                            [2.066167747786756, 48.86283275236239],
                            [2.065858282869491, 48.862844607607364],
                            [2.065546080554733, 48.86286049327951],
                            [2.065248783233793, 48.862888122628384],
                            [2.064925525015882, 48.86292961917955],
                            [2.064577648373885, 48.862986344083936],
                            [2.064244738739486, 48.863047600061435],
                            [2.063880331847427, 48.86313575739054],
                            [2.06355542582283, 48.86322850555161],
                            [2.063287819884336, 48.86331149698967],
                            [2.06302151958094, 48.86340438402286],
                            [2.062736048148904, 48.86351341076755],
                            [2.062470954850895, 48.86363417687092],
                            [2.062118310352679, 48.86381228599204],
                            [2.061894090299821, 48.86393584710576],
                            [2.06179425185358, 48.863996757324735],
                            [2.061522089934632, 48.86416246808791],
                            [2.060718918988046, 48.86471448580716],
                            [2.0604590327292, 48.86487752575733],
                            [2.060174573758996, 48.86504680092025],
                            [2.059953115252001, 48.86516227123453],
                            [2.05964150318829, 48.86531169481954],
                            [2.05929860338916, 48.86544935153863],
                            [2.058996795069521, 48.865551134919535],
                            [2.058714199183737, 48.865629583202484],
                            [2.05838252739573, 48.865708811205195],
                            [2.058124611009986, 48.86576123901306],
                            [2.057820365358938, 48.86581085524539],
                            [2.057458921244195, 48.86585133766723],
                            [2.057142558874905, 48.865873944684175],
                            [2.056774460499759, 48.86588563121387],
                            [2.056508095344468, 48.86588113840887],
                            [2.056130948627628, 48.86585846285686],
                            [2.055670669615201, 48.86581851599152],
                            [2.055253008654674, 48.865775996989505],
                            [2.055017674958524, 48.86575062482637],
                            [2.054796811587871, 48.86573204166439],
                            [2.054504765557766, 48.865717935875104],
                            [2.054218707067317, 48.86572124277896],
                            [2.053938674430305, 48.865746442525854],
                            [2.053625984286768, 48.86578401514966],
                            [2.053322001226854, 48.86584473207426],
                            [2.053054440354415, 48.86591421125467],
                            [2.052790894759253, 48.86599628952499],
                            [2.05256682711773, 48.86608745856883],
                            [2.05217180146996, 48.86627802081153],
                            [2.051697681083132, 48.86656641713413],
                            [2.051461601841635, 48.86674621252236],
                            [2.051196210713628, 48.86701770941848],
                            [2.050998065553517, 48.86727354921825],
                            [2.050852646476935, 48.867535851508414],
                            [2.050767845333735, 48.8677920976795],
                        ],
                    },
                },
                231: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.527211362206735, 2.2723040121192186],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 3105.06240268,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.254739702427517,
                            48.52040359106998,
                            2.290082513840396,
                            48.532890103244725,
                        ),
                        "coordinates": [
                            [2.290082513840396, 48.532890103244725],
                            [2.289734209201174, 48.53253649789415],
                            [2.289289225210587, 48.53209828136959],
                            [2.288938355857433, 48.531775772723115],
                            [2.288553233244141, 48.531451353204254],
                            [2.288148109787515, 48.53114588601439],
                            [2.287722985367884, 48.53086316280305],
                            [2.287369179467573, 48.53064114993548],
                            [2.286847002103546, 48.53034890042888],
                            [2.286370458634132, 48.53010786720578],
                            [2.285851089074588, 48.529874397727575],
                            [2.285343113467049, 48.52966747794502],
                            [2.284686717225082, 48.52943204412497],
                            [2.284138752105517, 48.5292535453459],
                            [2.283576495678448, 48.529095894444595],
                            [2.28301137245379, 48.52895340983816],
                            [2.282403419485687, 48.52881848697852],
                            [2.281815426567638, 48.52870822108015],
                            [2.281230268100794, 48.52861881241655],
                            [2.280568024784544, 48.52853505081832],
                            [2.279922878390861, 48.52847973934412],
                            [2.279246314363187, 48.528437680333774],
                            [2.27864394885956, 48.52842220226254],
                            [2.278027290449138, 48.52842188360666],
                            [2.277410618847667, 48.528432939927164],
                            [2.2765683769011, 48.52847231666823],
                            [2.275714707034037, 48.52851547264879],
                            [2.274858185217396, 48.52855672492686],
                            [2.274127312692539, 48.52856959727176],
                            [2.273513507684554, 48.528569255542905],
                            [2.272908294357497, 48.528548058069724],
                            [2.272325935166354, 48.528515492300926],
                            [2.27172933809518, 48.528456367237986],
                            [2.271132762818213, 48.52838017460659],
                            [2.270530500533806, 48.528288803635384],
                            [2.269956816596601, 48.528178485687526],
                            [2.269257576908441, 48.52802447552144],
                            [2.268575499776866, 48.527849613071275],
                            [2.267890604016973, 48.527651989839704],
                            [2.267245695746463, 48.527444905885865],
                            [2.266615089583204, 48.52722076181568],
                            [2.265981664349252, 48.526975752926795],
                            [2.265362551577256, 48.52670799508884],
                            [2.264766303036454, 48.526426975629136],
                            [2.264198633211657, 48.526128903303935],
                            [2.263642412954147, 48.52581566684544],
                            [2.263100501568763, 48.525481577883305],
                            [2.262561462899985, 48.52514179969478],
                            [2.261962566743837, 48.52474509311154],
                            [2.261395085444001, 48.52434650672226],
                            [2.261135580428958, 48.52416808749404],
                            [2.260773422943895, 48.52391564601215],
                            [2.259008330803085, 48.52267430971919],
                            [2.25840378914813, 48.522273786699685],
                            [2.2578676525067, 48.52194536711778],
                            [2.257305829094408, 48.52161882122433],
                            [2.25674968038453, 48.521318824222746],
                            [2.256467314338979, 48.521176406814156],
                            [2.256159265451747, 48.52103017824302],
                            [2.255631585081808, 48.52078518738958],
                            [2.254912773973982, 48.520471791151905],
                            [2.254739702427517, 48.52040359106998],
                        ],
                    },
                },
                232: {
                    "attributes": {
                        "reseau": "SNCF NORD",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE H",
                        "rer": 0,
                        "extcode": "800:H",
                        "geo_point_2d": [48.98935751527942, 2.2458746664321008],
                        "indice_lig": "H",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01737",
                        "navette": 0,
                        "idrefliga": "A01849",
                        "shape_leng": 1954.61314817,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.234276393996537,
                            48.98500470125915,
                            2.25747415725031,
                            48.99371348038584,
                        ),
                        "coordinates": [
                            [2.25747415725031, 48.98500470125915],
                            [2.256667529466798, 48.98530179983275],
                            [2.256537648249651, 48.98534937040701],
                            [2.256406397970248, 48.98539873895597],
                            [2.256324367152076, 48.98542925655962],
                            [2.25483957933873, 48.98598395673322],
                            [2.254752076836709, 48.98601716760732],
                            [2.254065722420399, 48.98627566499257],
                            [2.252697094129654, 48.986791752504],
                            [2.252152919385233, 48.98699548761377],
                            [2.250853987138239, 48.98748372667994],
                            [2.25052446527544, 48.98760757845762],
                            [2.250302957914854, 48.987691044437135],
                            [2.250069147044349, 48.987778097556905],
                            [2.248828968929537, 48.98824477512492],
                            [2.248735984251072, 48.98828247410205],
                            [2.248689496718009, 48.98829862493679],
                            [2.248644373466953, 48.988315676355626],
                            [2.248578741899453, 48.988339906642],
                            [2.248519944991161, 48.988362343427454],
                            [2.248182205336202, 48.9884897792397],
                            [2.247942915503344, 48.98857952129495],
                            [2.244431417603644, 48.98989778089434],
                            [2.244312450985003, 48.98994174964649],
                            [2.244241341042742, 48.98996956972559],
                            [2.244168866746831, 48.98999648911002],
                            [2.244036222252495, 48.9900476409717],
                            [2.243727181301108, 48.99016159795455],
                            [2.243554620207485, 48.99022882178484],
                            [2.242902227019158, 48.99047741455814],
                            [2.24162140823175, 48.990954603971424],
                            [2.239750755235367, 48.99166921656483],
                            [2.237898175127222, 48.99236001975328],
                            [2.23664981377814, 48.99283004478473],
                            [2.235958195596444, 48.99308036887799],
                            [2.234276393996537, 48.99371348038584],
                        ],
                    },
                },
                233: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.839792769296366, 2.198425985381831],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1723.99749497,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.187110711095018,
                            48.83828254600231,
                            2.209938360929272,
                            48.840517349814164,
                        ),
                        "coordinates": [
                            [2.209938360929272, 48.840517349814164],
                            [2.209378074228418, 48.84039201418087],
                            [2.208902838412542, 48.840300655727155],
                            [2.208404390561844, 48.84022995250118],
                            [2.207828259213623, 48.84016995072265],
                            [2.20731908058864, 48.840116412990525],
                            [2.206998337665408, 48.84008987616147],
                            [2.206715441592328, 48.84007696143968],
                            [2.204591654638433, 48.840019665625455],
                            [2.203492276258633, 48.83999860241443],
                            [2.202604062166013, 48.839979576370524],
                            [2.201555127130644, 48.83994596415789],
                            [2.19988086272485, 48.83991429183193],
                            [2.199691511422124, 48.83990776916452],
                            [2.199047163231645, 48.83988990640791],
                            [2.198965426291571, 48.839888009115654],
                            [2.198890503390143, 48.83988522024738],
                            [2.198218920579349, 48.83986282302237],
                            [2.198037737175246, 48.839859005654596],
                            [2.197664471878732, 48.83985135635475],
                            [2.196863450593256, 48.83983418824968],
                            [2.196185034234173, 48.839819864118596],
                            [2.195663285120399, 48.83980752863991],
                            [2.19376154628688, 48.839766489063905],
                            [2.193331918669794, 48.83975348265407],
                            [2.192826000765254, 48.839740948350496],
                            [2.192245699403402, 48.839728317060654],
                            [2.191784358015278, 48.83971226597262],
                            [2.19155009300573, 48.83970126010026],
                            [2.191368104879146, 48.8396867524227],
                            [2.190926702419407, 48.839632652252],
                            [2.190541191822519, 48.83957148628907],
                            [2.19009089305345, 48.83947930233946],
                            [2.189786505150622, 48.839412287648514],
                            [2.189574008960758, 48.8393537203063],
                            [2.189317944032969, 48.839268373203275],
                            [2.189102608376043, 48.83919490188592],
                            [2.188561008096156, 48.83898916306283],
                            [2.188242619955218, 48.83885565607613],
                            [2.188091596817663, 48.83878981167965],
                            [2.187882117313896, 48.83868342356778],
                            [2.187604615301071, 48.838545470642934],
                            [2.187187047988941, 48.83832370068622],
                            [2.187110711095018, 48.83828254600231],
                        ],
                    },
                },
                234: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.49751296476139, 2.6861985369150476],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 3017.03064454,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.678973982691401,
                            48.487076395248074,
                            2.69503731516767,
                            48.510265175268025,
                        ),
                        "coordinates": [
                            [2.69503731516767, 48.487076395248074],
                            [2.694245575197542, 48.487281572807596],
                            [2.693509532376374, 48.48749953727407],
                            [2.692867053870831, 48.4877118107041],
                            [2.692250465805759, 48.48793334259983],
                            [2.69158537619751, 48.48819261790166],
                            [2.690815269927012, 48.48852415773336],
                            [2.690522171756, 48.4886589831965],
                            [2.6900940554476, 48.4888578019078],
                            [2.689685481029043, 48.48907263631791],
                            [2.689297445758597, 48.48929686183042],
                            [2.688813966004562, 48.48960771190611],
                            [2.688355025342478, 48.48994636097858],
                            [2.687876290443878, 48.49035701010034],
                            [2.687522550803856, 48.490714384858826],
                            [2.687167445395255, 48.491137966707285],
                            [2.686875371613728, 48.491546235827855],
                            [2.686597845502224, 48.492047403255086],
                            [2.68643375205892, 48.49243247404081],
                            [2.686310821426463, 48.49284651427812],
                            [2.686186525672235, 48.49345300102005],
                            [2.686164067422796, 48.49372464797546],
                            [2.686173832219567, 48.494736288854114],
                            [2.686202135695622, 48.49607790229893],
                            [2.686236255323618, 48.497089467982434],
                            [2.686244244936598, 48.49784662348441],
                            [2.686282949245358, 48.499127055042585],
                            [2.686252432699991, 48.49979530194838],
                            [2.686157087701774, 48.50028659447774],
                            [2.686078125886153, 48.50060517747804],
                            [2.685816428867547, 48.501302913932896],
                            [2.685676440760374, 48.50160280062751],
                            [2.685496057224245, 48.50193158769325],
                            [2.685214692563314, 48.502333525747275],
                            [2.684955889151448, 48.502672444905656],
                            [2.684319767270796, 48.50343337706348],
                            [2.683529459310763, 48.504404306722705],
                            [2.683309378298592, 48.50467116206516],
                            [2.683097332682365, 48.50492630225843],
                            [2.682706756457446, 48.50539151659371],
                            [2.68146138858131, 48.506908773942925],
                            [2.681281486538678, 48.50711795093848],
                            [2.680970187146986, 48.50750558088728],
                            [2.680588914414678, 48.50795187415301],
                            [2.680175580334432, 48.50846031271878],
                            [2.679845527274557, 48.50887857128996],
                            [2.679604470085139, 48.50921099848539],
                            [2.679454774943514, 48.50941935062202],
                            [2.679257236993564, 48.50973015661758],
                            [2.679039404519952, 48.51013458460954],
                            [2.678973982691401, 48.510265175268025],
                        ],
                    },
                },
                235: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE L",
                        "rer": 0,
                        "extcode": "800:L",
                        "geo_point_2d": [48.84776004312368, 2.133318973679109],
                        "indice_lig": "L",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01740",
                        "navette": 0,
                        "idrefliga": "A02176",
                        "shape_leng": 1471.13889724,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.131100577321693,
                            48.84271995435486,
                            2.138125058777295,
                            48.85425170349275,
                        ),
                        "coordinates": [
                            [2.138125058777295, 48.84271995435486],
                            [2.137311463270128, 48.84331568166061],
                            [2.136849623168135, 48.843645808107546],
                            [2.136723907967805, 48.84373731369144],
                            [2.134342214756369, 48.84543184966389],
                            [2.134115363880631, 48.84559691507521],
                            [2.133372014083482, 48.846118971635995],
                            [2.132792552296897, 48.84654419584981],
                            [2.132453529971064, 48.84681427168019],
                            [2.132290725030947, 48.84697495115206],
                            [2.132140225290957, 48.84712486050152],
                            [2.131977354544583, 48.84730082764652],
                            [2.131821258077197, 48.84748579886223],
                            [2.131570338308711, 48.84786574313454],
                            [2.131398770773044, 48.84816669277937],
                            [2.131258400527841, 48.84850187157919],
                            [2.1311838115422, 48.8487454419496],
                            [2.131125469558153, 48.84901422116238],
                            [2.131102699979315, 48.84924799299549],
                            [2.131100577321693, 48.849431442356114],
                            [2.131119856117018, 48.849712052543694],
                            [2.131163798369543, 48.84995943336533],
                            [2.131181155475021, 48.8500457956262],
                            [2.131269515953317, 48.85042634994647],
                            [2.131679143079398, 48.852205863450294],
                            [2.132095245728708, 48.85407441555457],
                            [2.132132445251102, 48.85425170349275],
                        ],
                    },
                },
                236: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.58032014674072, 2.589409838485273],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 3494.85205435,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.58394771106125,
                            48.564949495670916,
                            2.594551816007613,
                            48.595563837991776,
                        ),
                        "coordinates": [
                            [2.594551816007613, 48.564949495670916],
                            [2.594295504436848, 48.56545677875951],
                            [2.59394493728639, 48.566297471138796],
                            [2.593513140386829, 48.567378656710105],
                            [2.592647916108226, 48.569933613348155],
                            [2.592298847202012, 48.571078849405694],
                            [2.591903749787656, 48.57234077373574],
                            [2.591473493827524, 48.57374315570742],
                            [2.591127969309865, 48.574890759355135],
                            [2.590837866272776, 48.5758674762185],
                            [2.590598102195244, 48.57666508302081],
                            [2.590238337562021, 48.57784126690704],
                            [2.589807856422505, 48.57921747191162],
                            [2.589310338910697, 48.58081509872764],
                            [2.588812824486161, 48.58241986298694],
                            [2.588347481668348, 48.584010276998],
                            [2.587987516220817, 48.58516742138348],
                            [2.587511457618529, 48.58677689070458],
                            [2.586973779293195, 48.588501098135],
                            [2.586601945524944, 48.58968840234978],
                            [2.586134388752506, 48.59086322685132],
                            [2.585694396053536, 48.59181591901776],
                            [2.585149965885586, 48.592927460295556],
                            [2.584091329784307, 48.59523255348737],
                            [2.58394771106125, 48.595563837991776],
                        ],
                    },
                },
                237: {
                    "attributes": {
                        "reseau": "Métro",
                        "val": 0,
                        "metro": 1,
                        "res_com": "M6",
                        "rer": 0,
                        "extcode": "100110006:6",
                        "geo_point_2d": [48.846564004640356, 2.3062490383617456],
                        "indice_lig": "6",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Metro",
                        "tramway": 0,
                        "idrefligc": "C01376",
                        "navette": 0,
                        "idrefliga": "A01539",
                        "shape_leng": 525.077197842,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.302968297817314,
                            48.845626966747176,
                            2.309531491460945,
                            48.84750708199681,
                        ),
                        "coordinates": [
                            [2.302968297817314, 48.84750708199681],
                            [2.304451820139122, 48.84708342797386],
                            [2.307571426047775, 48.84617955755766],
                            [2.308979893777096, 48.845780563609615],
                            [2.309531491460945, 48.845626966747176],
                        ],
                    },
                },
                238: {
                    "attributes": {
                        "reseau": "GRANDES LIGNES",
                        "val": 0,
                        "metro": 0,
                        "res_com": "TER",
                        "rer": 0,
                        "extcode": "800:TER",
                        "geo_point_2d": [48.632155809117435, 1.80325190267206],
                        "indice_lig": "GL",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "TER",
                        "tramway": 0,
                        "idrefligc": "C01744",
                        "navette": 0,
                        "idrefliga": "A02172",
                        "shape_leng": 5090.65309918,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            1.771695684383177,
                            48.62599081977363,
                            1.832935470348963,
                            48.644221953457865,
                        ),
                        "coordinates": [
                            [1.771695684383177, 48.62599081977363],
                            [1.771789234910462, 48.625993714173234],
                            [1.775294766291022, 48.62609673738346],
                            [1.778253953288389, 48.62617510851936],
                            [1.778757072012567, 48.62619016941249],
                            [1.779643986849183, 48.62621520206869],
                            [1.780016931707398, 48.626225122947474],
                            [1.781089516560572, 48.62626634214707],
                            [1.781854010110753, 48.6263213352617],
                            [1.782441385377774, 48.62638164056386],
                            [1.782832091059342, 48.6264287529839],
                            [1.783188491163392, 48.626478021746394],
                            [1.783696201204207, 48.626568622499015],
                            [1.784631464432751, 48.62676111992955],
                            [1.785764159345311, 48.62701122113867],
                            [1.787960566770759, 48.62749576886527],
                            [1.788829412831479, 48.62768611221708],
                            [1.791297364301402, 48.62823517384915],
                            [1.794458063645305, 48.62892443808158],
                            [1.795995413418458, 48.629271226882615],
                            [1.798921057474979, 48.629915635146915],
                            [1.801707165774385, 48.630526004014506],
                            [1.80335088842882, 48.63089063581582],
                            [1.804844310113646, 48.63121409131256],
                            [1.808049539332668, 48.631921441843296],
                            [1.808507937878205, 48.632023506536605],
                            [1.809761253782975, 48.63231484861222],
                            [1.810498740246909, 48.632503855680014],
                            [1.81137572434654, 48.63274109035344],
                            [1.812248876046153, 48.63300209435513],
                            [1.813254253968988, 48.63332080577438],
                            [1.813780005654765, 48.63350643658823],
                            [1.814506084180801, 48.63375960875121],
                            [1.81550358979515, 48.63414726539937],
                            [1.816007394394606, 48.63434538004149],
                            [1.81654904003577, 48.63457807731161],
                            [1.816863761901163, 48.634713511391006],
                            [1.817394506830523, 48.63495154974686],
                            [1.817894106053569, 48.635184049043794],
                            [1.818270759755442, 48.635366523645764],
                            [1.819171038824418, 48.63582116894826],
                            [1.820269244742543, 48.636425088259955],
                            [1.82060912439786, 48.63662267562147],
                            [1.821037876175012, 48.63688631426458],
                            [1.821412686014929, 48.63711823056304],
                            [1.821543468233524, 48.637198860260135],
                            [1.824339366114668, 48.63897409631737],
                            [1.825841204068545, 48.639926903963996],
                            [1.826341365401625, 48.64024569882337],
                            [1.827367245483112, 48.64089657648942],
                            [1.82998973544806, 48.642560592953174],
                            [1.830340395878458, 48.6427734875547],
                            [1.830469896221011, 48.64284960438045],
                            [1.830661452617415, 48.64296196811928],
                            [1.83092441461041, 48.6431014728271],
                            [1.831299297758785, 48.643310144664596],
                            [1.83163984521822, 48.64349077942609],
                            [1.831842136363664, 48.64359808010537],
                            [1.832314856713282, 48.643846119164735],
                            [1.832935470348963, 48.644221953457865],
                        ],
                    },
                },
                239: {
                    "attributes": {
                        "reseau": "RER B",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER B",
                        "rer": 1,
                        "extcode": "810:B",
                        "geo_point_2d": [48.699538946497306, 2.1172950111266533],
                        "indice_lig": "B",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01743",
                        "navette": 0,
                        "idrefliga": "A01857",
                        "shape_leng": 2916.87932911,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.097975858420524,
                            48.69754950085678,
                            2.136566717058361,
                            48.70121772031537,
                        ),
                        "coordinates": [
                            [2.097975858420524, 48.70121772031537],
                            [2.09860437330809, 48.701039183427106],
                            [2.099330897085727, 48.70085794718826],
                            [2.100017445405373, 48.70071929319873],
                            [2.100672897558623, 48.70059663324645],
                            [2.101300966222995, 48.70049893686537],
                            [2.101627235991346, 48.700452849309805],
                            [2.10218177323226, 48.700400037342405],
                            [2.102863176776255, 48.700337051083075],
                            [2.103553525199324, 48.700293260570405],
                            [2.104349265950277, 48.700269593146416],
                            [2.105161659531043, 48.70027304838885],
                            [2.105639770308572, 48.70029380465048],
                            [2.106146366367439, 48.70032450865369],
                            [2.106834917959957, 48.700374462341415],
                            [2.107484751152433, 48.70042556065397],
                            [2.108566427385785, 48.70051373882784],
                            [2.109517051782314, 48.700592979125496],
                            [2.109988317547961, 48.700626293113196],
                            [2.110431748559973, 48.70065215308149],
                            [2.110852995020118, 48.7006613671844],
                            [2.111349381208017, 48.70067216232582],
                            [2.112012370453761, 48.70066897708845],
                            [2.112422702665969, 48.70065809680607],
                            [2.112827669893056, 48.70063191608533],
                            [2.113265298473231, 48.700593208381285],
                            [2.113653776244, 48.70055281880377],
                            [2.114061776873859, 48.70051113735976],
                            [2.11478263117267, 48.70043701991963],
                            [2.116448477774766, 48.70026578520458],
                            [2.117904137926928, 48.70011571793081],
                            [2.118593234462253, 48.700043300882655],
                            [2.119251071038363, 48.699973517562924],
                            [2.119847927814652, 48.69989950459252],
                            [2.120173087719416, 48.699848841858845],
                            [2.120553365641245, 48.699785353874354],
                            [2.121064616936839, 48.699682908202796],
                            [2.121298508060788, 48.69963119387628],
                            [2.121959447535761, 48.69946967489261],
                            [2.123087279132641, 48.699153850965644],
                            [2.123835775935643, 48.69895301124837],
                            [2.124274805443225, 48.69883248647731],
                            [2.124792969879381, 48.69869783122564],
                            [2.12606237908847, 48.69837290394825],
                            [2.127070735959188, 48.69809770323912],
                            [2.127664455042126, 48.69794176026221],
                            [2.128186226644817, 48.69779995845076],
                            [2.128531614540134, 48.6977196941413],
                            [2.128851773855037, 48.69765603736141],
                            [2.129265372767743, 48.69759493013148],
                            [2.129635711193363, 48.69756467441329],
                            [2.129928352861774, 48.69755190739702],
                            [2.130451677419926, 48.69754950085678],
                            [2.130847928495224, 48.697577855546],
                            [2.131328605271686, 48.69763178133112],
                            [2.133241864620513, 48.69783395872046],
                            [2.136566717058361, 48.69819697630193],
                        ],
                    },
                },
                240: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.939183252148254, 2.2613697346186448],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1859.15320244,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.25789748402742,
                            48.93105422781371,
                            2.263184304511326,
                            48.946796942080006,
                        ),
                        "coordinates": [
                            [2.260602314246561, 48.93105422781371],
                            [2.261339992940939, 48.93277735871654],
                            [2.26192845562579, 48.934095897822615],
                            [2.262165980863144, 48.93464568021208],
                            [2.26278593547287, 48.93607741003118],
                            [2.26287225768476, 48.93631539973921],
                            [2.262987382623659, 48.93661527153104],
                            [2.263087913842962, 48.93701506388585],
                            [2.263138048210378, 48.937302996881705],
                            [2.263177395067224, 48.93755999071292],
                            [2.263184304511326, 48.93777175654649],
                            [2.263183753703794, 48.93814293283929],
                            [2.263157862879139, 48.93855216237681],
                            [2.263103227020259, 48.93886144123741],
                            [2.263059574229614, 48.939070795209915],
                            [2.262990553880533, 48.93933723668828],
                            [2.262856372097004, 48.93970237840287],
                            [2.262769314320712, 48.93995096295791],
                            [2.262627994339127, 48.94025780692889],
                            [2.262526554468291, 48.94046236424788],
                            [2.262345516519471, 48.94075728519014],
                            [2.262019734947993, 48.941226992058596],
                            [2.261791735517665, 48.941521880947555],
                            [2.261553780255332, 48.941821366327915],
                            [2.259935982944806, 48.94390459301893],
                            [2.25924098169465, 48.944843962964256],
                            [2.258465163835001, 48.946054674714276],
                            [2.25789748402742, 48.946796942080006],
                        ],
                    },
                },
                241: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.89294686080906, 2.305586250545477],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 1589.87147309,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.297419948146663,
                            48.88822016276462,
                            2.313732451520271,
                            48.89763744791706,
                        ),
                        "coordinates": [
                            [2.313732451520271, 48.88822016276462],
                            [2.312557681116819, 48.888904131906834],
                            [2.311861101364987, 48.88931322918998],
                            [2.310471156153221, 48.89009856750011],
                            [2.307915667206252, 48.89156362940108],
                            [2.305782353427846, 48.892812229255576],
                            [2.304508076579762, 48.89358040663048],
                            [2.302399845234058, 48.894833707686736],
                            [2.301472058910227, 48.89536877831059],
                            [2.300746415528593, 48.895794456467286],
                            [2.29982620296289, 48.896307637273466],
                            [2.299147473198817, 48.89669643774181],
                            [2.298473555854997, 48.89706897752753],
                            [2.297419948146663, 48.89763744791706],
                        ],
                    },
                },
                242: {
                    "attributes": {
                        "reseau": "RER C",
                        "val": 0,
                        "metro": 0,
                        "res_com": "RER C",
                        "rer": 1,
                        "extcode": "800:C",
                        "geo_point_2d": [48.860582770308255, 2.295416613701717],
                        "indice_lig": "C",
                        "idf": 1,
                        "train": 0,
                        "fer": 1,
                        "mode": "RER",
                        "tramway": 0,
                        "idrefligc": "C01727",
                        "navette": 0,
                        "idrefliga": "A01840",
                        "shape_leng": 1011.36657611,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.290391553460649,
                            48.857293413870465,
                            2.300989969386769,
                            48.86266245169434,
                        ),
                        "coordinates": [
                            [2.300989969386769, 48.86266245169434],
                            [2.300489376303076, 48.86262060013306],
                            [2.300032815891246, 48.862567398790404],
                            [2.299490401215816, 48.86249438141424],
                            [2.298927572098009, 48.86238628327973],
                            [2.298494214862682, 48.86229351367372],
                            [2.29800637041118, 48.8621620556285],
                            [2.297826501717835, 48.86210623886935],
                            [2.297464042713203, 48.86199010797553],
                            [2.297153379144549, 48.861873095721656],
                            [2.296750074591071, 48.86170748768124],
                            [2.296048439329894, 48.8613538246328],
                            [2.295530772178002, 48.86104788535211],
                            [2.29518069637236, 48.86080855129745],
                            [2.294891922429404, 48.86060880715892],
                            [2.294201323231796, 48.86013373465184],
                            [2.293821293267962, 48.859873701813434],
                            [2.292941392127579, 48.85926365878662],
                            [2.291533049514775, 48.85828559758574],
                            [2.29113808270113, 48.85799857196018],
                            [2.290786737550953, 48.85770436759405],
                            [2.290694652871954, 48.857616747019215],
                            [2.290586576383536, 48.85751184216011],
                            [2.290391553460649, 48.857293413870465],
                        ],
                    },
                },
                243: {
                    "attributes": {
                        "reseau": "SNCF SAINT-LAZARE",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE J",
                        "rer": 0,
                        "extcode": "800:J",
                        "geo_point_2d": [48.927538935302024, 2.2594319486728183],
                        "indice_lig": "J",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01739",
                        "navette": 0,
                        "idrefliga": "A01852",
                        "shape_leng": 812.556138388,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.25890223580021,
                            48.923918626560365,
                            2.260602314246561,
                            48.93105422781371,
                        ),
                        "coordinates": [
                            [2.25934570305215, 48.923918626560365],
                            [2.259242690685924, 48.924161829185316],
                            [2.25914654050798, 48.924426791415236],
                            [2.259044843227303, 48.924807416548504],
                            [2.258968397437719, 48.92520233379846],
                            [2.258931748247874, 48.92554731403057],
                            [2.25890223580021, 48.92594464268499],
                            [2.258905290105806, 48.9262991661213],
                            [2.258930064197831, 48.92662039577116],
                            [2.258976468072476, 48.92696067231551],
                            [2.259051762539378, 48.92730334775074],
                            [2.259141518144067, 48.92763413642275],
                            [2.259234960436355, 48.927917340461626],
                            [2.259353635180461, 48.92822911553918],
                            [2.259508342731763, 48.92859325725773],
                            [2.259709849054022, 48.929050227627464],
                            [2.260602314246561, 48.93105422781371],
                        ],
                    },
                },
                244: {
                    "attributes": {
                        "reseau": "TRAMWAY",
                        "val": 0,
                        "metro": 0,
                        "res_com": "T1",
                        "rer": 0,
                        "extcode": "100112011:T1",
                        "geo_point_2d": [48.93858713280242, 2.358379606699589],
                        "indice_lig": "1",
                        "idf": 1,
                        "train": 0,
                        "fer": 0,
                        "mode": "Tramway",
                        "tramway": 1,
                        "idrefligc": "C01389",
                        "navette": 0,
                        "idrefliga": "A01191",
                        "shape_leng": 379.309216488,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.355902810417396,
                            48.938082614059766,
                            2.360746043772506,
                            48.93873295309403,
                        ),
                        "coordinates": [
                            [2.360746043772506, 48.938082614059766],
                            [2.359886135989626, 48.938557853528465],
                            [2.359883879316849, 48.938558979069725],
                            [2.359784358085317, 48.93860391977967],
                            [2.359678965852863, 48.93864261949221],
                            [2.359568603561618, 48.938674748472984],
                            [2.359454212437124, 48.93870003206175],
                            [2.359336767128403, 48.93871825333391],
                            [2.359217270179924, 48.93872925846719],
                            [2.359148479387801, 48.938732267492654],
                            [2.359096742519166, 48.93873295309403],
                            [2.358976211124996, 48.93872930583298],
                            [2.358149367895832, 48.938672831319145],
                            [2.357441331957247, 48.938625530357605],
                            [2.357022710000366, 48.938597797035406],
                            [2.356787020429971, 48.93859783822363],
                            [2.356480985413449, 48.93862106700933],
                            [2.356178458600191, 48.938616483735494],
                            [2.355902810417396, 48.938597775209935],
                        ],
                    },
                },
                245: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.20283254658722, 2.716911750278763],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 6203.63706657,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.703936052961915,
                            48.18093685577102,
                            2.736249842909681,
                            48.229549937455864,
                        ),
                        "coordinates": [
                            [2.703936052961915, 48.229549937455864],
                            [2.703985765329806, 48.22946151109987],
                            [2.704101421761575, 48.229265103554084],
                            [2.704225164985404, 48.229070467980414],
                            [2.704352886364159, 48.2288677252921],
                            [2.704517841918618, 48.22860371505364],
                            [2.70467751708113, 48.22835410852025],
                            [2.704861205445985, 48.22807564906738],
                            [2.705023496755266, 48.227816141933936],
                            [2.705181874539825, 48.22757373319775],
                            [2.70536014788292, 48.22729169349031],
                            [2.70550115941089, 48.22706732563995],
                            [2.705648891838918, 48.226842035858034],
                            [2.705801892812961, 48.2266014429016],
                            [2.70595490661124, 48.22636264750474],
                            [2.706158455915499, 48.22604185629278],
                            [2.706328803153279, 48.22578142228816],
                            [2.706476514209562, 48.225554333469084],
                            [2.706601505187193, 48.2253489006608],
                            [2.706689285050819, 48.225207434414294],
                            [2.706773041571207, 48.225067780164956],
                            [2.706839500167284, 48.22495515917468],
                            [2.706921909296604, 48.22481550865272],
                            [2.707004357709474, 48.22466118810824],
                            [2.707065320270406, 48.22455336357048],
                            [2.707146269835485, 48.224398430932204],
                            [2.707225813562455, 48.22423541019387],
                            [2.707319775214898, 48.22405038312066],
                            [2.707388982455865, 48.223915649196634],
                            [2.707486973277202, 48.22369951293949],
                            [2.70762734827228, 48.22339151642417],
                            [2.707756870759499, 48.22308896802133],
                            [2.70793450292641, 48.222683029049314],
                            [2.708045672228668, 48.22242515946952],
                            [2.708147324444039, 48.22218754196321],
                            [2.708286300392824, 48.22187325501202],
                            [2.708422601763943, 48.22156167408185],
                            [2.708565517848919, 48.22123478501777],
                            [2.708706939045614, 48.22088811745996],
                            [2.708765136296709, 48.220751243513426],
                            [2.708827234973856, 48.22059637174785],
                            [2.708874746945234, 48.220470323694485],
                            [2.708971678277027, 48.220197938446205],
                            [2.709048686366518, 48.21997247819565],
                            [2.709149993140247, 48.21966101231183],
                            [2.70920526312418, 48.21949267523329],
                            [2.709264435585181, 48.21930634030446],
                            [2.709318225868206, 48.21912002267478],
                            [2.709368046736703, 48.21894271108707],
                            [2.709424486162038, 48.218750990366836],
                            [2.709502488760634, 48.218382050362464],
                            [2.709547283037827, 48.21815443899932],
                            [2.70957626777858, 48.21798794630537],
                            [2.709599974819012, 48.217736983955085],
                            [2.709613257142747, 48.21753191744798],
                            [2.709618479314898, 48.21732867566423],
                            [2.709609001286167, 48.217138970108465],
                            [2.709592448184047, 48.216902529295],
                            [2.709570927201045, 48.216721855834535],
                            [2.709532868581779, 48.21648818381126],
                            [2.709477891089822, 48.21615025674991],
                            [2.709423274324293, 48.215860887512655],
                            [2.709386955125592, 48.215680262969016],
                            [2.709347684235613, 48.21546457899056],
                            [2.709307248617781, 48.215273178280206],
                            [2.709283245178246, 48.21512038918399],
                            [2.70925925485543, 48.214969398775246],
                            [2.709232494118538, 48.21480762656162],
                            [2.709222123613283, 48.214679072563065],
                            [2.709210123097969, 48.21451185602511],
                            [2.709207760414496, 48.21437428243087],
                            [2.709203452617789, 48.214155786033146],
                            [2.709211514118181, 48.21397231733615],
                            [2.709223737121063, 48.21380592065657],
                            [2.709238491540321, 48.213617934348214],
                            [2.709270489525792, 48.2133966199641],
                            [2.709304079744115, 48.2132085710698],
                            [2.709345847307024, 48.213034883104605],
                            [2.709402221394513, 48.21283506875077],
                            [2.709469298142296, 48.21262712676873],
                            [2.709547051418953, 48.21240745971294],
                            [2.70963433368146, 48.212203047639356],
                            [2.709740084195719, 48.21197737561937],
                            [2.709830476274736, 48.211801344969054],
                            [2.709926095360049, 48.21163287450498],
                            [2.710048387780507, 48.21143284267847],
                            [2.71019605432599, 48.211207547441234],
                            [2.710350465630802, 48.2109849283053],
                            [2.71049972145941, 48.210792899988974],
                            [2.710645065964089, 48.210617968706536],
                            [2.710797171205638, 48.21044751134172],
                            [2.710941388693076, 48.210302258308516],
                            [2.711129688537949, 48.210114595051046],
                            [2.711323446157342, 48.2099377045137],
                            [2.71164295909947, 48.20966597671235],
                            [2.711970621691362, 48.209405012285714],
                            [2.712563014471554, 48.20892465443174],
                            [2.712924110789214, 48.20863839715556],
                            [2.713095290449376, 48.20850204371293],
                            [2.713212940639064, 48.20840363567997],
                            [2.7133426585274, 48.20829979236943],
                            [2.713456231273418, 48.20819600242793],
                            [2.713571156975474, 48.20809310734561],
                            [2.713714149565788, 48.207965839104226],
                            [2.713842372065293, 48.20784221685366],
                            [2.714015342792432, 48.20766332775619],
                            [2.714209396741369, 48.20745162626286],
                            [2.714293398500193, 48.207351531352224],
                            [2.71439075722646, 48.20723880318539],
                            [2.714466768441794, 48.20714952592521],
                            [2.714537363960081, 48.207055769851536],
                            [2.714629266697856, 48.20693316835028],
                            [2.714697150289967, 48.20683672423348],
                            [2.714771672675774, 48.20672856729727],
                            [2.714846114398255, 48.20660962069083],
                            [2.714923163633058, 48.20647987470275],
                            [2.714992224206144, 48.20636094559194],
                            [2.715139446658792, 48.20608169257097],
                            [2.715221518134324, 48.205904270289544],
                            [2.715335223767999, 48.205640417088524],
                            [2.715386646004452, 48.20550176398288],
                            [2.71542352624199, 48.20539733096837],
                            [2.71545897384051, 48.205281212457635],
                            [2.715494367180454, 48.20515789994235],
                            [2.715534937429664, 48.2050075934489],
                            [2.715578529584745, 48.204802037830945],
                            [2.715607562470922, 48.204654941856454],
                            [2.715638444425401, 48.20446141821218],
                            [2.715652057004335, 48.20430400851502],
                            [2.715664358442297, 48.204151099116096],
                            [2.715675132235256, 48.20397391675516],
                            [2.715674163857806, 48.20384533102925],
                            [2.715671687187926, 48.2035162241197],
                            [2.715667711929983, 48.20334538572704],
                            [2.715664020523567, 48.203212313308974],
                            [2.715652371310211, 48.20291560920674],
                            [2.715648138742553, 48.20271060038188],
                            [2.715636374214697, 48.20239861016432],
                            [2.715629560643321, 48.20220799808585],
                            [2.715621244675989, 48.20199670864886],
                            [2.715615220153311, 48.20173235831187],
                            [2.71560837174563, 48.2015372497771],
                            [2.715602869382034, 48.201342137258],
                            [2.715594283083424, 48.201094880367705],
                            [2.715585731866197, 48.20085211890368],
                            [2.715573597483122, 48.20066961807093],
                            [2.715567377369465, 48.200379190895276],
                            [2.715561813901625, 48.20017598529307],
                            [2.715556019504955, 48.19994220758914],
                            [2.715550788034258, 48.199783063109656],
                            [2.715546683432086, 48.19959513949964],
                            [2.715541506126994, 48.19944318899457],
                            [2.715533224587629, 48.199236396416836],
                            [2.715528938667036, 48.19902419484873],
                            [2.715526383355073, 48.19886324271902],
                            [2.715530099033233, 48.19864202279452],
                            [2.715538025262077, 48.19844416724339],
                            [2.715551339672104, 48.19824719384682],
                            [2.715568702222668, 48.19805200457377],
                            [2.715591470618959, 48.197860394191906],
                            [2.715615888972144, 48.19770924360806],
                            [2.715642921715625, 48.197548192512215],
                            [2.715685655367018, 48.19732863916533],
                            [2.7157350995227, 48.197107265431654],
                            [2.715786098424808, 48.19691376127032],
                            [2.715833277227634, 48.196749045950554],
                            [2.715886078114076, 48.19657493671469],
                            [2.715927866467486, 48.196450187348056],
                            [2.715969984017179, 48.19632775213296],
                            [2.716109811087196, 48.19596399694512],
                            [2.716173237249966, 48.19581361376144],
                            [2.71626314678736, 48.19560828937853],
                            [2.716365119156295, 48.19539752938364],
                            [2.716465923468639, 48.19521015227839],
                            [2.71654689758047, 48.19506870277493],
                            [2.716679693193127, 48.194843450438036],
                            [2.716890919270105, 48.1944965394436],
                            [2.717146900109505, 48.1941417206653],
                            [2.71733551274196, 48.1938862688341],
                            [2.717443455962247, 48.19375461899209],
                            [2.717551417861278, 48.19362566578977],
                            [2.717691371582509, 48.19345883803613],
                            [2.71782073401307, 48.1933145257198],
                            [2.718027451657028, 48.19308452630762],
                            [2.718224992216332, 48.19288603095799],
                            [2.718439918568245, 48.19267488590107],
                            [2.718649537943883, 48.19247365079896],
                            [2.718855265490582, 48.19229131177645],
                            [2.719153278541325, 48.19204211792696],
                            [2.719317668195639, 48.191906677310534],
                            [2.719445979104611, 48.19180193298652],
                            [2.719753522782259, 48.19156889005158],
                            [2.720054532582699, 48.19136104776338],
                            [2.720338131659676, 48.19116315486281],
                            [2.720605825797976, 48.19099588890988],
                            [2.720944378768769, 48.19077442730669],
                            [2.721311060433757, 48.1905384812761],
                            [2.721699144230601, 48.190288074289974],
                            [2.722060522154168, 48.19006293440417],
                            [2.722534251077435, 48.18975827904674],
                            [2.722915592862175, 48.189506991001714],
                            [2.72330901933349, 48.189253862013615],
                            [2.72381756593059, 48.18893199591477],
                            [2.724113287354183, 48.188740346875534],
                            [2.724981746018108, 48.18818254239143],
                            [2.725293540694679, 48.187983641133684],
                            [2.726065572709857, 48.18748011425554],
                            [2.726992930631392, 48.186893316221486],
                            [2.727976333029956, 48.18625326338009],
                            [2.728648185346315, 48.185823417241274],
                            [2.729231419941952, 48.18545129530457],
                            [2.729908422740339, 48.18501461508867],
                            [2.730719437880147, 48.1844817629396],
                            [2.731222053684885, 48.18415167853432],
                            [2.73160428289024, 48.18389576745479],
                            [2.732036222014905, 48.18362778543925],
                            [2.732482235994008, 48.18334071999235],
                            [2.733639771166605, 48.18260148272277],
                            [2.734809003672546, 48.18185555650667],
                            [2.735598311273384, 48.18135010489242],
                            [2.736249842909681, 48.18093685577102],
                        ],
                    },
                },
                246: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.35347134651465, 2.781557164066508],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 8508.41926662,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.738001618532588,
                            48.33623310392106,
                            2.810859344364383,
                            48.37952262366741,
                        ),
                        "coordinates": [
                            [2.796343615000022, 48.37952262366741],
                            [2.797248420496505, 48.37912848649691],
                            [2.79761483674829, 48.37896996051565],
                            [2.797973955717404, 48.37879480928714],
                            [2.798318622920005, 48.37862361973774],
                            [2.799191538939647, 48.37818694211936],
                            [2.802443568430986, 48.37655055536922],
                            [2.804294911566199, 48.37561578312655],
                            [2.80574475336322, 48.37491105799888],
                            [2.806264606124487, 48.374642720774425],
                            [2.806582083677722, 48.374477545049174],
                            [2.806914676593119, 48.37429920195685],
                            [2.807332151212079, 48.37405376634118],
                            [2.807450240781468, 48.37398043539133],
                            [2.807592466140204, 48.37388991820488],
                            [2.808075350904084, 48.37356777126153],
                            [2.808348295682342, 48.37336189343858],
                            [2.808623206099906, 48.37312215320578],
                            [2.808931830165427, 48.372836922046325],
                            [2.80922506782465, 48.372536023384804],
                            [2.809439843906403, 48.372291642711986],
                            [2.809657723410513, 48.37203392250013],
                            [2.80982700663255, 48.37179523043513],
                            [2.809981427449479, 48.37157875622105],
                            [2.810091674810464, 48.37140023700046],
                            [2.810242113841549, 48.371116795283534],
                            [2.810388725538886, 48.37084055635797],
                            [2.810505774582508, 48.37054569146438],
                            [2.810634809330417, 48.37017227795512],
                            [2.810752259113344, 48.369746438204864],
                            [2.810792161091127, 48.36949262452508],
                            [2.810841540066914, 48.36908748817764],
                            [2.810859344364383, 48.36879457836428],
                            [2.810857367365935, 48.36858506020063],
                            [2.810827686932018, 48.36815713970425],
                            [2.810801460987502, 48.36795221970639],
                            [2.810770031941613, 48.36773666067906],
                            [2.810721638996953, 48.36752748657377],
                            [2.810651056614941, 48.36731617889527],
                            [2.810569179592014, 48.36707731999777],
                            [2.81048727966102, 48.366863395763346],
                            [2.810351990738025, 48.36658135533083],
                            [2.810199833984077, 48.36626414411335],
                            [2.8099819127011, 48.36590895217408],
                            [2.809795861568467, 48.365641753494614],
                            [2.809566164376916, 48.36532527774554],
                            [2.809336925867321, 48.36505735923569],
                            [2.809072492316782, 48.36479288960506],
                            [2.808781521299228, 48.36450660856349],
                            [2.80846545793831, 48.36422530734343],
                            [2.808257872629849, 48.36406549923453],
                            [2.808004038285347, 48.363870278762185],
                            [2.807738186184881, 48.36368638238577],
                            [2.807449237970457, 48.36350143390745],
                            [2.807227972902301, 48.36336584467541],
                            [2.80700416916066, 48.363242105176944],
                            [2.806791892142428, 48.36312319377371],
                            [2.806532219331344, 48.36298997692461],
                            [2.806316854235649, 48.36288457742787],
                            [2.806087570308325, 48.3627719041596],
                            [2.805855997703855, 48.36265810567422],
                            [2.805581904502054, 48.362523612492865],
                            [2.805112847548699, 48.36229265106712],
                            [2.804444608587908, 48.36195877838189],
                            [2.802978524232097, 48.36122627750964],
                            [2.802429903403687, 48.36095215868656],
                            [2.80189983959655, 48.36068726402109],
                            [2.801444420001418, 48.36046009010383],
                            [2.800876365653938, 48.36017979634537],
                            [2.798944709176131, 48.359222813979834],
                            [2.797536386048403, 48.35852872378684],
                            [2.796832600873678, 48.35818185013968],
                            [2.796355802254994, 48.35794833965115],
                            [2.795735811807697, 48.35763369984602],
                            [2.794165334961084, 48.35685204569394],
                            [2.78979293037002, 48.35467548339257],
                            [2.787345380185906, 48.3534649848033],
                            [2.784899288019739, 48.352253529213584],
                            [2.782453322301761, 48.351042919056034],
                            [2.780007481545479, 48.34983315613476],
                            [2.779148378851981, 48.34940398307679],
                            [2.777266286282123, 48.34846622437487],
                            [2.775769173882739, 48.34773286722875],
                            [2.775168467063438, 48.34743993340582],
                            [2.774654838264852, 48.34718742553389],
                            [2.774090624224166, 48.34690842440341],
                            [2.773414465180275, 48.34657206824231],
                            [2.772391612913229, 48.346069738584816],
                            [2.771817199743027, 48.345787789019745],
                            [2.771156294979855, 48.34546168402381],
                            [2.770521636538296, 48.34512388678718],
                            [2.770141451961348, 48.34490883254907],
                            [2.769667987775808, 48.3446370323269],
                            [2.769240943266641, 48.34436743129193],
                            [2.768882041358417, 48.34413563667834],
                            [2.768271824744296, 48.34373111313951],
                            [2.767840963248556, 48.34343059188321],
                            [2.767492555918279, 48.34317258079742],
                            [2.76725535831382, 48.342980764255366],
                            [2.766982209478003, 48.34275815341179],
                            [2.766403678144707, 48.34229877768275],
                            [2.765724601045989, 48.341766022681426],
                            [2.765318588691842, 48.34144636280191],
                            [2.765063482441401, 48.34124509340032],
                            [2.764815598978347, 48.34105331254801],
                            [2.76455956609762, 48.34086244164286],
                            [2.764171475269018, 48.34058964016269],
                            [2.763778677600431, 48.34034112629955],
                            [2.763207739784304, 48.33999110208336],
                            [2.762655424206349, 48.33966960600864],
                            [2.762160615341695, 48.33939547531839],
                            [2.761705490616973, 48.33917115809785],
                            [2.761225286394286, 48.338935037461574],
                            [2.760755975484152, 48.33872028596698],
                            [2.760043243520127, 48.33841603436495],
                            [2.759040459312793, 48.3380323509091],
                            [2.758278940060271, 48.33776116412743],
                            [2.757729843734565, 48.337582462456346],
                            [2.757119159292535, 48.33740148971741],
                            [2.756523894664542, 48.3372407394336],
                            [2.755911018252329, 48.33710061432007],
                            [2.755193949527226, 48.33693846357185],
                            [2.754616217746583, 48.336808820271116],
                            [2.754005047174062, 48.33669449508738],
                            [2.753208202397128, 48.33656657584971],
                            [2.752422321989855, 48.33646954044065],
                            [2.751754945500969, 48.33639850510893],
                            [2.75095841426223, 48.33632791515356],
                            [2.750484447768678, 48.33629003128472],
                            [2.749855363300322, 48.3362646919118],
                            [2.74937002803512, 48.33624464777485],
                            [2.748837186785384, 48.33623310392106],
                            [2.747990189927628, 48.336233491807846],
                            [2.746835928354824, 48.3362637659126],
                            [2.746254755349334, 48.33627936198361],
                            [2.745486952961956, 48.3362972192121],
                            [2.744986769326461, 48.33630906395358],
                            [2.744190244502054, 48.33632729178352],
                            [2.743660305068411, 48.33634089125678],
                            [2.74310471746014, 48.33635188385259],
                            [2.740744925188887, 48.33641160247909],
                            [2.738387831447255, 48.33647216267016],
                            [2.738001618532588, 48.336481780613234],
                        ],
                    },
                },
                247: {
                    "attributes": {
                        "reseau": "PARIS SUD EST",
                        "val": 0,
                        "metro": 0,
                        "res_com": "LIGNE R",
                        "rer": 0,
                        "extcode": "800:R",
                        "geo_point_2d": [48.24941853311187, 2.6960834155399858],
                        "indice_lig": "R",
                        "idf": 1,
                        "train": 1,
                        "fer": 1,
                        "mode": "Train",
                        "tramway": 0,
                        "idrefligc": "C01731",
                        "navette": 0,
                        "idrefliga": "A01845",
                        "shape_leng": 4520.41587191,
                    },
                    "geometry": {
                        "type": "LineString",
                        "bbox": (
                            2.68564708993975,
                            48.229549937455864,
                            2.703936052961915,
                            48.26775810993438,
                        ),
                        "coordinates": [
                            [2.68564708993975, 48.26775810993438],
                            [2.685830313827444, 48.26751612159178],
                            [2.686250497479578, 48.26704177353725],
                            [2.686487945864353, 48.266792899007015],
                            [2.686850418277224, 48.266430283037046],
                            [2.687214483540642, 48.2661036297662],
                            [2.687480836498322, 48.2658645046267],
                            [2.688033931048953, 48.265414066435994],
                            [2.689345883702873, 48.264283232575465],
                            [2.689637596632948, 48.264014349152866],
                            [2.690029433103608, 48.26362015719037],
                            [2.690543620710754, 48.26300616803842],
                            [2.690906415917873, 48.2625059557208],
                            [2.691323592449331, 48.261888670656056],
                            [2.691579048548333, 48.261521229425],
                            [2.691771555936461, 48.26124610889578],
                            [2.692007439935492, 48.260858411463346],
                            [2.692231206061809, 48.26046618762296],
                            [2.692425683451772, 48.26005076683954],
                            [2.692555293353361, 48.259716742988594],
                            [2.692701283508169, 48.259223502918275],
                            [2.692781078103009, 48.25889143481272],
                            [2.692811844394738, 48.25867192532545],
                            [2.692870613909288, 48.25803328514041],
                            [2.69290799704218, 48.256656444802864],
                            [2.692930019805266, 48.2563434430829],
                            [2.692952264601215, 48.25606191377403],
                            [2.693008742291233, 48.2556705699214],
                            [2.693069522795977, 48.255417611712566],
                            [2.693160982117407, 48.255074067474915],
                            [2.69334432729476, 48.254551420504626],
                            [2.693508380183719, 48.25416098029063],
                            [2.694330868397965, 48.252612597341724],
                            [2.694564072513331, 48.252176157958786],
                            [2.69486235977706, 48.25161546188483],
                            [2.695429696302523, 48.250549869732986],
                            [2.696274650642705, 48.24895913762218],
                            [2.69778376066048, 48.24611994270639],
                            [2.698149070659552, 48.24543445914578],
                            [2.698776103427554, 48.24426524742434],
                            [2.699068413283547, 48.243728368312304],
                            [2.699348463230589, 48.24320258187557],
                            [2.699603716600194, 48.242725804203346],
                            [2.69988266953105, 48.242206050834255],
                            [2.700214724246778, 48.24158361438647],
                            [2.700490862568579, 48.24104858382148],
                            [2.70082166331228, 48.240417410626456],
                            [2.701259953188705, 48.23962082555225],
                            [2.701428640264105, 48.2393073488037],
                            [2.701573395610863, 48.23903531428073],
                            [2.701635813601244, 48.23891821247668],
                            [2.701702184729609, 48.23878940825473],
                            [2.701772548795654, 48.23864065797963],
                            [2.701837015559999, 48.23849787986672],
                            [2.701913016850792, 48.23831222148008],
                            [2.701977508920031, 48.23814646939549],
                            [2.702033031730077, 48.23800690956407],
                            [2.70208306595699, 48.23785297906438],
                            [2.702135608613895, 48.23767386297008],
                            [2.702181486769021, 48.23750376017419],
                            [2.702216745966819, 48.237354373988694],
                            [2.702265020507399, 48.23714379900299],
                            [2.702295809761331, 48.23693507845354],
                            [2.702326129061472, 48.23666161428319],
                            [2.702356543779326, 48.23638144786916],
                            [2.702384092733924, 48.236117394549645],
                            [2.702412980668557, 48.23583224571354],
                            [2.702433163089409, 48.235646040308936],
                            [2.702456875156807, 48.235389683756416],
                            [2.702505864966412, 48.23490753893102],
                            [2.702535417656313, 48.234528868762276],
                            [2.702566752837356, 48.234210440304516],
                            [2.702595500078212, 48.233906407980136],
                            [2.702630597635736, 48.233550200908084],
                            [2.702654667420769, 48.233343300183705],
                            [2.702675050519214, 48.23318497001422],
                            [2.702695304543422, 48.23300865655287],
                            [2.702723619746322, 48.232830517899515],
                            [2.702752059365686, 48.23266946360359],
                            [2.702789736897144, 48.232483201853505],
                            [2.70