/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.App;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JMXAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reporter {
    private static final Logger LOGGER = Logger.getLogger(App.class.getName());
    protected HashMap<String, HashMap<String, HashMap<String, Object>>> ratesAggregator = new HashMap();

    protected String _generateId(HashMap<String, Object> metric) {
        String key = (String)metric.get("alias");
        for (String tag : (String[])metric.get("tags")) {
            key = key + tag;
        }
        return key;
    }

    public void clearRatesAggregator(String instance_name) {
        this.ratesAggregator.put(instance_name, new HashMap());
    }

    public void sendMetrics(LinkedList<HashMap<String, Object>> metrics, String instance_name) {
        HashMap<Object, Object> instanceRatesAggregator = this.ratesAggregator.containsKey(instance_name) ? this.ratesAggregator.get(instance_name) : new HashMap();
        int loopCounter = App.getLoopCounter();
        if (loopCounter <= 5 || loopCounter % 10 == 0) {
            LOGGER.info("Instance " + instance_name + " is sending " + metrics.size() + " metrics to the metrics reporter during collection #" + loopCounter);
            if (loopCounter == 5) {
                LOGGER.info("Next collections will be logged only every 10 collections.");
            }
        } else {
            LOGGER.debug("Instance " + instance_name + " is sending " + metrics.size() + " metrics to the metrics reporter during collection #" + loopCounter);
        }
        for (HashMap hashMap : metrics) {
            HashMap<String, Object> metric = this._postprocess(hashMap);
            Double current_value = (Double)metric.get("value");
            if (current_value.isNaN() || current_value.isInfinite()) continue;
            String metric_name = (String)metric.get("alias");
            String metric_type = (String)metric.get("metric_type");
            String[] tags = (String[])metric.get("tags");
            if (!metric_type.equals("gauge")) {
                String key = this._generateId(metric);
                if (!instanceRatesAggregator.containsKey(key)) {
                    HashMap<String, Number> rate_info = new HashMap<String, Number>();
                    rate_info.put("ts", System.currentTimeMillis());
                    rate_info.put("value", current_value);
                    instanceRatesAggregator.put(key, rate_info);
                    continue;
                }
                long old_ts = (Long)((HashMap)instanceRatesAggregator.get(key)).get("ts");
                double old_value = (Double)((HashMap)instanceRatesAggregator.get(key)).get("value");
                long now = System.currentTimeMillis();
                double rate = 1000.0 * (current_value - old_value) / (double)(now - old_ts);
                if (!Double.isNaN(rate) && !Double.isInfinite(rate)) {
                    this._sendMetricPoint(metric_name, rate, tags);
                }
                ((HashMap)instanceRatesAggregator.get(key)).put("ts", now);
                ((HashMap)instanceRatesAggregator.get(key)).put("value", current_value);
                continue;
            }
            this._sendMetricPoint(metric_name, current_value, tags);
        }
        this.ratesAggregator.put(instance_name, instanceRatesAggregator);
    }

    protected HashMap<String, Object> _postprocess(HashMap<String, Object> metric) {
        if (metric.get("check_name").equals("cassandra")) {
            return this._postProcessCassandra(metric);
        }
        return metric;
    }

    private HashMap<String, Object> _postProcessCassandra(HashMap<String, Object> metric) {
        metric.put("alias", ((String)metric.get("alias")).replace("jmx.org.apache.", ""));
        return metric;
    }

    protected abstract void _sendMetricPoint(String var1, double var2, String[] var4);

    public abstract void displayMetricReached();

    public abstract void displayNonMatchingAttributeName(JMXAttribute var1);

    public abstract void displayInstanceName(Instance var1);

    public abstract void displayMatchingAttributeName(JMXAttribute var1, int var2, int var3);
}

