# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TrunkList(ListResource):

    def __init__(self, version):
        """
        Initialize the TrunkList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.routes.v2.trunk.TrunkList
        :rtype: twilio.rest.routes.v2.trunk.TrunkList
        """
        super(TrunkList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, sip_trunk_domain):
        """
        Constructs a TrunkContext

        :param sip_trunk_domain: The SIP Trunk

        :returns: twilio.rest.routes.v2.trunk.TrunkContext
        :rtype: twilio.rest.routes.v2.trunk.TrunkContext
        """
        return TrunkContext(self._version, sip_trunk_domain=sip_trunk_domain, )

    def __call__(self, sip_trunk_domain):
        """
        Constructs a TrunkContext

        :param sip_trunk_domain: The SIP Trunk

        :returns: twilio.rest.routes.v2.trunk.TrunkContext
        :rtype: twilio.rest.routes.v2.trunk.TrunkContext
        """
        return TrunkContext(self._version, sip_trunk_domain=sip_trunk_domain, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes.V2.TrunkList>'


class TrunkPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the TrunkPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.routes.v2.trunk.TrunkPage
        :rtype: twilio.rest.routes.v2.trunk.TrunkPage
        """
        super(TrunkPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TrunkInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.routes.v2.trunk.TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        return TrunkInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes.V2.TrunkPage>'


class TrunkContext(InstanceContext):

    def __init__(self, version, sip_trunk_domain):
        """
        Initialize the TrunkContext

        :param Version version: Version that contains the resource
        :param sip_trunk_domain: The SIP Trunk

        :returns: twilio.rest.routes.v2.trunk.TrunkContext
        :rtype: twilio.rest.routes.v2.trunk.TrunkContext
        """
        super(TrunkContext, self).__init__(version)

        # Path Solution
        self._solution = {'sip_trunk_domain': sip_trunk_domain, }
        self._uri = '/Trunks/{sip_trunk_domain}'.format(**self._solution)

    def update(self, voice_region=values.unset, friendly_name=values.unset):
        """
        Update the TrunkInstance

        :param unicode voice_region: The Inbound Processing Region used for this SIP Trunk for voice
        :param unicode friendly_name: A human readable description of this resource.

        :returns: The updated TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        data = values.of({'VoiceRegion': voice_region, 'FriendlyName': friendly_name, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return TrunkInstance(self._version, payload, sip_trunk_domain=self._solution['sip_trunk_domain'], )

    def fetch(self):
        """
        Fetch the TrunkInstance

        :returns: The fetched TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return TrunkInstance(self._version, payload, sip_trunk_domain=self._solution['sip_trunk_domain'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Routes.V2.TrunkContext {}>'.format(context)


class TrunkInstance(InstanceResource):

    def __init__(self, version, payload, sip_trunk_domain=None):
        """
        Initialize the TrunkInstance

        :returns: twilio.rest.routes.v2.trunk.TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        super(TrunkInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sip_trunk_domain': payload.get('sip_trunk_domain'),
            'url': payload.get('url'),
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'voice_region': payload.get('voice_region'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
        }

        # Context
        self._context = None
        self._solution = {'sip_trunk_domain': sip_trunk_domain or self._properties['sip_trunk_domain'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TrunkContext for this TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkContext
        """
        if self._context is None:
            self._context = TrunkContext(self._version, sip_trunk_domain=self._solution['sip_trunk_domain'], )
        return self._context

    @property
    def sip_trunk_domain(self):
        """
        :returns: The SIP Trunk
        :rtype: unicode
        """
        return self._properties['sip_trunk_domain']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def sid(self):
        """
        :returns: A string that uniquely identifies the Inbound Processing Region assignments for this SIP Trunk.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: A human readable description of the Inbound Processing Region assignments for this SIP Trunk.
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def voice_region(self):
        """
        :returns: The Inbound Processing Region used for this SIP Trunk for voice.
        :rtype: unicode
        """
        return self._properties['voice_region']

    @property
    def date_created(self):
        """
        :returns: The date that this SIP Trunk was assigned an Inbound Processing Region.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that the Inbound Processing Region was updated for this SIP Trunk.
        :rtype: datetime
        """
        return self._properties['date_updated']

    def update(self, voice_region=values.unset, friendly_name=values.unset):
        """
        Update the TrunkInstance

        :param unicode voice_region: The Inbound Processing Region used for this SIP Trunk for voice
        :param unicode friendly_name: A human readable description of this resource.

        :returns: The updated TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        return self._proxy.update(voice_region=voice_region, friendly_name=friendly_name, )

    def fetch(self):
        """
        Fetch the TrunkInstance

        :returns: The fetched TrunkInstance
        :rtype: twilio.rest.routes.v2.trunk.TrunkInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Routes.V2.TrunkInstance {}>'.format(context)
