# -*- coding: utf-8 -*-
#
# nti.externalization documentation build configuration file, created by
# sphinx-quickstart on Thu Jun  8 07:02:25 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import os
import sys
# Use the python versions instead of the cython compiled versions
# for better documentation extraction and ease of tweaking docs.
os.environ['PURE_PYTHON'] = '1'

import pkg_resources


sys.path.append(os.path.abspath('../src'))
rqmt = pkg_resources.require('nti.externalization')[0]

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.viewcode',
    'repoze.sphinx.autointerface',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'nti.externalization'
copyright = u'2017, NextThought'
author = u'NextThought'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '%s.%s' % tuple(map(int, rqmt.version.split('.')[:2]))
# The full version, including alpha/beta/rc tags.
release = rqmt.version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The reST default role (used for this markup: `text`) to use for all documents.
default_role = 'obj'

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'perldoc'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'ntiexternalizationdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'ntiexternalization.tex', u'nti.externalization Documentation',
     u'NextThought', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'ntiexternalization', u'nti.externalization Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'ntiexternalization', u'nti.externalization Documentation',
     author, 'ntiexternalization', 'One line description of project.',
     'Miscellaneous'),
]




# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "http://docs.pylonsproject.org/projects/pyramid/en/latest/": None,
    #'https://ntiwref.readthedocs.io/en/latest': None,
    'http://docs.python.org/': None,
    'http://ntischema.readthedocs.io/en/latest/': None,
    'http://ntizodb.readthedocs.io/en/latest/': None,
    'http://persistent.readthedocs.io/en/latest': None,
    'http://zodb.readthedocs.io/en/latest': None,

    'http://zopecomponent.readthedocs.io/en/latest': None,
    'http://zopecontainer.readthedocs.io/en/latest': None,
    'http://zopedatetime.readthedocs.io/en/latest': None,
    'http://zopedublincore.readthedocs.io/en/latest': None,
    'http://zopeevent.readthedocs.io/en/latest': None,
    'http://zopehookable.readthedocs.io/en/latest': None,
    'http://zopeinterface.readthedocs.io/en/latest': None,
    'http://zopeintid.readthedocs.io/en/latest/': None,
    'http://zopemimetype.readthedocs.io/en/latest/': None,
    'http://zopeproxy.readthedocs.io/en/latest': None,
    'http://zopeschema.readthedocs.io/en/latest/': None,
    'http://zopelifecycleevent.readthedocs.io/en/latest/': None,
}

extlinks = {
    'issue': ('https://github.com/NextThought/nti.externalization/issues/%s',
              'issue #'),
    'pr': ('https://github.com/NextThought/nti.externalization/pull/%s',
           'pull request #')}

# Sphinx 1.8+ prefers this to `autodoc_default_flags`. It's documented that
# either True or None mean the same thing as just setting the flag, but
# only None works in 1.8 (True works in 2.0)
autodoc_default_options = {
    'members': None,
    'show-inheritance': None,
}

autoclass_content = 'both'
# This causes the order in __all__ to be ignored :(
# autodoc_member_order = 'bysource'
# autodoc_member_order = 'groupwise'
