# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deutschland',
 'deutschland.coachingangebote',
 'deutschland.coachingangebote.api',
 'deutschland.coachingangebote.apis',
 'deutschland.coachingangebote.model',
 'deutschland.coachingangebote.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil', 'urllib3>=1.25.3']

setup_kwargs = {
    'name': 'de-coachingangebote',
    'version': '0.1.0',
    'description': 'Bundesagentur für Arbeit: Coachingangebote API',
    'long_description': '# coachingangebote\nEine der größten Datenbanken zu Coaching-/Aktivierungsangeboten Deutschlands durchsuchen. \n\nDie Authentifizierung funktioniert per OAuth 2 Client Credentials mit JWTs. Folgende Client-Credentials können dafür verwendet werden:\n\n**ClientID:** ee971dcb-96fa-47b3-b2be-00863e4fc88b\n\n**ClientSecret:** 1050e0b7-6db8-49e8-aff9-0e58e556681f\n\n**Achtung**: der generierte Token muss bei folgenden GET-requests im header als \'OAuthAccessToken\' inkludiert werden. \n\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 1.0.0\n- Package version: 0.1.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\nFor more information, please visit [https://github.com/AndreasFischer1985/coachingangebote-api](https://github.com/AndreasFischer1985/coachingangebote-api)\n\n## Requirements.\n\nPython >= 3.6\n\n## Installation & Usage\n### pip install\n\n```sh\npip install deutschland[coachingangebote]\n```\n\n### poetry install\n\n```sh\npoetry add deutschland -E coachingangebote\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\n## Usage\n\nImport the package:\n```python\nfrom deutschland import coachingangebote\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nfrom deutschland import coachingangebote\nfrom pprint import pprint\nfrom deutschland.coachingangebote.api import default_api\nfrom deutschland.coachingangebote.model.response import Response\n# Defining the host is optional and defaults to https://rest.arbeitsagentur.de/infosysbub/avgs\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = coachingangebote.Configuration(\n    host = "https://rest.arbeitsagentur.de/infosysbub/avgs"\n)\n\n# The client must configure the authentication and authorization parameters\n# in accordance with the API server security policy.\n# Examples for each auth method are provided below, use the example that\n# satisfies your auth use case.\n\n# Configure OAuth2 access token for authorization: clientCredAuth\nconfiguration = coachingangebote.Configuration(\n    host = "https://rest.arbeitsagentur.de/infosysbub/avgs"\n)\nconfiguration.access_token = \'YOUR_ACCESS_TOKEN\'\n\n\n# Enter a context with an instance of the API client\nwith coachingangebote.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = default_api.DefaultApi(api_client)\n    mz = "SA%2001" # str | Maßnahmenziel - SA%2001 = Heranführung an den Ausbildungs- und Arbeitsmarkt sowie Feststellung, Verringerung und Beseitigung von Vermittlungshemmnissen; SA%2004 = Heranführung an eine selbständige Arbeit; SA%2005 = Stabilisierung einer Beschäftigungsaufnahme.\n    sw = "Vermittlungshemmnisse" # str | Suchwort (optional)\n    ort = "Feucht_90537_11.224918_49.376701" # str | Ortsangabe nebst Postleitzahl und Koordinaten (optional)\n    pg = 1 # int | Ergebnissseite (beginnend mit 0) (optional)\n    re = "BY" # str | Region/Bundesland - BW=Baden-Württemberg; BY=Bayern; BE=Berlin; BB=Brandenburg; HB=Bremen; HH=Hamburg; HE=Hessen; MV=Mecklenburg-Vorpommern; NI=Niedersachsen; NW=Nordrhei-Westfalen; RP=Rheinland-Pfalz; SL=Saarland; SN=Sachsen; ST=Sachsen-Anhalt; SH=Schleswig-Holstein; TH=Thüringen. Mehrere Komma-getrennte Angaben möglich. (optional)\n    ban = 229563 # int | Anbieter-ID (optional)\n    uk = "Bundesweit" # str | Umkreis - Bundesweit=Bundesweit; 25=25 km; 50=50 km; 100=100 km; 150=150 km; 200=200 km. (optional)\n    mna = 0 # int | Maßnahmenart - 0=Einzelmaßnahme; 1=Gruppenmaßnahme. Komma-separierte Angaben möglich. (optional)\n    deufoev = True # bool | DEUFOEV - true = (nur) Anbieter berufsbezogener Sprachförderung Deutsch (DeuFöV) anzeigen. (optional)\n    sort = "ta" # str | Sortierungskriterium - ta = Maßnahmetitel A-Z; tz = Maßnahmetitel Z-A. (optional)\n\n    try:\n        # Coaching-/Aktivierungsangebote\n        api_response = api_instance.aktivierungsangebote(mz, sw=sw, ort=ort, pg=pg, re=re, ban=ban, uk=uk, mna=mna, deufoev=deufoev, sort=sort)\n        pprint(api_response)\n    except coachingangebote.ApiException as e:\n        print("Exception when calling DefaultApi->aktivierungsangebote: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://rest.arbeitsagentur.de/infosysbub/avgs*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*DefaultApi* | [**aktivierungsangebote**](docs/DefaultApi.md#aktivierungsangebote) | **GET** /pc/v1/aktivierungsangebote | Coaching-/Aktivierungsangebote\n\n\n## Documentation For Models\n\n - [Response](docs/Response.md)\n - [ResponseAggregations](docs/ResponseAggregations.md)\n - [ResponseAggregationsANZAHLAUSGEFILTERT](docs/ResponseAggregationsANZAHLAUSGEFILTERT.md)\n - [ResponseAggregationsANZAHLGESAMT](docs/ResponseAggregationsANZAHLGESAMT.md)\n - [ResponseAggregationsREGIONEN](docs/ResponseAggregationsREGIONEN.md)\n - [ResponseAggregationsUNTERRICHSFORMEN](docs/ResponseAggregationsUNTERRICHSFORMEN.md)\n - [ResponseEmbedded](docs/ResponseEmbedded.md)\n - [ResponseEmbeddedAbstaende](docs/ResponseEmbeddedAbstaende.md)\n - [ResponseEmbeddedAdresse](docs/ResponseEmbeddedAdresse.md)\n - [ResponseEmbeddedAngebot](docs/ResponseEmbeddedAngebot.md)\n - [ResponseEmbeddedAngebotAnbieter](docs/ResponseEmbeddedAngebotAnbieter.md)\n - [ResponseEmbeddedAngebotAnbieterAdresse](docs/ResponseEmbeddedAngebotAnbieterAdresse.md)\n - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasse](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasse.md)\n - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseKoordinaten](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseKoordinaten.md)\n - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseLand](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseLand.md)\n - [ResponseEmbeddedAngebotAnbieterLogo](docs/ResponseEmbeddedAngebotAnbieterLogo.md)\n - [ResponseEmbeddedAngebotSuchworte](docs/ResponseEmbeddedAngebotSuchworte.md)\n - [ResponseEmbeddedAngebotSystematiken](docs/ResponseEmbeddedAngebotSystematiken.md)\n - [ResponseEmbeddedAngebotZertifizierer](docs/ResponseEmbeddedAngebotZertifizierer.md)\n - [ResponseEmbeddedAnsprechpartner](docs/ResponseEmbeddedAnsprechpartner.md)\n - [ResponseEmbeddedOrt](docs/ResponseEmbeddedOrt.md)\n - [ResponseEmbeddedRollen](docs/ResponseEmbeddedRollen.md)\n - [ResponseEmbeddedTermine](docs/ResponseEmbeddedTermine.md)\n - [ResponseEmbeddedUnterrichtsform](docs/ResponseEmbeddedUnterrichtsform.md)\n - [ResponseLinks](docs/ResponseLinks.md)\n - [ResponseLinksFirst](docs/ResponseLinksFirst.md)\n - [ResponsePage](docs/ResponsePage.md)\n\n\n## Documentation For Authorization\n\n\n## clientCredAuth\n\n- **Type**: OAuth\n- **Flow**: application\n- **Authorization URL**: \n- **Scopes**: N/A\n\n\n## Author\n\nandreasfischer1985@web.de\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in coachingangebote.apis and coachingangebote.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from deutschland.coachingangebote.api.default_api import DefaultApi`\n- `from deutschland.coachingangebote.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nfrom deutschland import coachingangebote\nfrom deutschland.coachingangebote.apis import *\nfrom deutschland.coachingangebote.models import *\n```\n\n',
    'author': 'BundesAPI',
    'author_email': 'kontakt@bund.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bundesAPI/coachingangebote-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
