"""
    Bundesagentur für Arbeit: Coachingangebote API

    Eine der größten Datenbanken zu Coaching-/Aktivierungsangeboten Deutschlands durchsuchen.   Die Authentifizierung funktioniert per OAuth 2 Client Credentials mit JWTs. Folgende Client-Credentials können dafür verwendet werden:  **ClientID:** ee971dcb-96fa-47b3-b2be-00863e4fc88b  **ClientSecret:** 1050e0b7-6db8-49e8-aff9-0e58e556681f  **Achtung**: der generierte Token muss bei folgenden GET-requests im header als 'OAuthAccessToken' inkludiert werden.    # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: andreasfischer1985@web.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from deutschland.coachingangebote.api_client import ApiClient
from deutschland.coachingangebote.api_client import Endpoint as _Endpoint
from deutschland.coachingangebote.model.response import Response
from deutschland.coachingangebote.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.aktivierungsangebote_endpoint = _Endpoint(
            settings={
                "response_type": (Response,),
                "auth": ["clientCredAuth"],
                "endpoint_path": "/pc/v1/aktivierungsangebote",
                "operation_id": "aktivierungsangebote",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "mz",
                    "sw",
                    "ort",
                    "pg",
                    "re",
                    "ban",
                    "uk",
                    "mna",
                    "deufoev",
                    "sort",
                ],
                "required": [
                    "mz",
                ],
                "nullable": [],
                "enum": [
                    "mz",
                    "re",
                    "uk",
                    "mna",
                    "deufoev",
                    "sort",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("mz",): {"2001": "SA%2001", "2004": "SA%2004", "2005": "SA%2005"},
                    ("re",): {
                        "BW": "BW",
                        "BY": "BY",
                        "BE": "BE",
                        "BB": "BB",
                        "HB": "HB",
                        "HH": "HH",
                        "HE": "HE",
                        "MV": "MV",
                        "NI": "NI",
                        "NW": "NW",
                        "RP": "RP",
                        "SL": "SL",
                        "SN": "SN",
                        "ST": "ST",
                        "SH": "SH",
                        "TH": "TH",
                    },
                    ("uk",): {
                        "BUNDESWEIT": "Bundesweit",
                        "25": "25",
                        "50": "50",
                        "100": "100",
                        "150": "150",
                        "200": "200",
                    },
                    ("mna",): {"0": 0, "1": 1},
                    ("deufoev",): {"TRUE": True, "FALSE": False},
                    ("sort",): {"TA": "ta", "TZ": "tz"},
                },
                "openapi_types": {
                    "mz": (str,),
                    "sw": (str,),
                    "ort": (str,),
                    "pg": (int,),
                    "re": (str,),
                    "ban": (int,),
                    "uk": (str,),
                    "mna": (int,),
                    "deufoev": (bool,),
                    "sort": (str,),
                },
                "attribute_map": {
                    "mz": "mz",
                    "sw": "sw",
                    "ort": "ort",
                    "pg": "pg",
                    "re": "re",
                    "ban": "ban",
                    "uk": "uk",
                    "mna": "mna",
                    "deufoev": "deufoev",
                    "sort": "sort",
                },
                "location_map": {
                    "mz": "query",
                    "sw": "query",
                    "ort": "query",
                    "pg": "query",
                    "re": "query",
                    "ban": "query",
                    "uk": "query",
                    "mna": "query",
                    "deufoev": "query",
                    "sort": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def aktivierungsangebote(self, mz, **kwargs):
        """Coaching-/Aktivierungsangebote  # noqa: E501

        Die Suche nach Coaching-/Aktivierungsangeboten ermöglicht verfügbare Weiterbildungsangebote mit verschiedenen GET-Parametern zu filtern.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.aktivierungsangebote(mz, async_req=True)
        >>> result = thread.get()

        Args:
            mz (str): Maßnahmenziel - SA%2001 = Heranführung an den Ausbildungs- und Arbeitsmarkt sowie Feststellung, Verringerung und Beseitigung von Vermittlungshemmnissen; SA%2004 = Heranführung an eine selbständige Arbeit; SA%2005 = Stabilisierung einer Beschäftigungsaufnahme.

        Keyword Args:
            sw (str): Suchwort. [optional]
            ort (str): Ortsangabe nebst Postleitzahl und Koordinaten. [optional]
            pg (int): Ergebnissseite (beginnend mit 0). [optional]
            re (str): Region/Bundesland - BW=Baden-Württemberg; BY=Bayern; BE=Berlin; BB=Brandenburg; HB=Bremen; HH=Hamburg; HE=Hessen; MV=Mecklenburg-Vorpommern; NI=Niedersachsen; NW=Nordrhei-Westfalen; RP=Rheinland-Pfalz; SL=Saarland; SN=Sachsen; ST=Sachsen-Anhalt; SH=Schleswig-Holstein; TH=Thüringen. Mehrere Komma-getrennte Angaben möglich.. [optional]
            ban (int): Anbieter-ID. [optional]
            uk (str): Umkreis - Bundesweit=Bundesweit; 25=25 km; 50=50 km; 100=100 km; 150=150 km; 200=200 km.. [optional]
            mna (int): Maßnahmenart - 0=Einzelmaßnahme; 1=Gruppenmaßnahme. Komma-separierte Angaben möglich.. [optional]
            deufoev (bool): DEUFOEV - true = (nur) Anbieter berufsbezogener Sprachförderung Deutsch (DeuFöV) anzeigen.. [optional]
            sort (str): Sortierungskriterium - ta = Maßnahmetitel A-Z; tz = Maßnahmetitel Z-A.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["mz"] = mz
        return self.aktivierungsangebote_endpoint.call_with_http_info(**kwargs)
