# coachingangebote
Eine der größten Datenbanken zu Coaching-/Aktivierungsangeboten Deutschlands durchsuchen. 

Die Authentifizierung funktioniert per OAuth 2 Client Credentials mit JWTs. Folgende Client-Credentials können dafür verwendet werden:

**ClientID:** ee971dcb-96fa-47b3-b2be-00863e4fc88b

**ClientSecret:** 1050e0b7-6db8-49e8-aff9-0e58e556681f

**Achtung**: der generierte Token muss bei folgenden GET-requests im header als 'OAuthAccessToken' inkludiert werden. 


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/AndreasFischer1985/coachingangebote-api](https://github.com/AndreasFischer1985/coachingangebote-api)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

```sh
pip install deutschland[coachingangebote]
```

### poetry install

```sh
poetry add deutschland -E coachingangebote
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Usage

Import the package:
```python
from deutschland import coachingangebote
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
from deutschland import coachingangebote
from pprint import pprint
from deutschland.coachingangebote.api import default_api
from deutschland.coachingangebote.model.response import Response
# Defining the host is optional and defaults to https://rest.arbeitsagentur.de/infosysbub/avgs
# See configuration.py for a list of all supported configuration parameters.
configuration = coachingangebote.Configuration(
    host = "https://rest.arbeitsagentur.de/infosysbub/avgs"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: clientCredAuth
configuration = coachingangebote.Configuration(
    host = "https://rest.arbeitsagentur.de/infosysbub/avgs"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with coachingangebote.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    mz = "SA%2001" # str | Maßnahmenziel - SA%2001 = Heranführung an den Ausbildungs- und Arbeitsmarkt sowie Feststellung, Verringerung und Beseitigung von Vermittlungshemmnissen; SA%2004 = Heranführung an eine selbständige Arbeit; SA%2005 = Stabilisierung einer Beschäftigungsaufnahme.
    sw = "Vermittlungshemmnisse" # str | Suchwort (optional)
    ort = "Feucht_90537_11.224918_49.376701" # str | Ortsangabe nebst Postleitzahl und Koordinaten (optional)
    pg = 1 # int | Ergebnissseite (beginnend mit 0) (optional)
    re = "BY" # str | Region/Bundesland - BW=Baden-Württemberg; BY=Bayern; BE=Berlin; BB=Brandenburg; HB=Bremen; HH=Hamburg; HE=Hessen; MV=Mecklenburg-Vorpommern; NI=Niedersachsen; NW=Nordrhei-Westfalen; RP=Rheinland-Pfalz; SL=Saarland; SN=Sachsen; ST=Sachsen-Anhalt; SH=Schleswig-Holstein; TH=Thüringen. Mehrere Komma-getrennte Angaben möglich. (optional)
    ban = 229563 # int | Anbieter-ID (optional)
    uk = "Bundesweit" # str | Umkreis - Bundesweit=Bundesweit; 25=25 km; 50=50 km; 100=100 km; 150=150 km; 200=200 km. (optional)
    mna = 0 # int | Maßnahmenart - 0=Einzelmaßnahme; 1=Gruppenmaßnahme. Komma-separierte Angaben möglich. (optional)
    deufoev = True # bool | DEUFOEV - true = (nur) Anbieter berufsbezogener Sprachförderung Deutsch (DeuFöV) anzeigen. (optional)
    sort = "ta" # str | Sortierungskriterium - ta = Maßnahmetitel A-Z; tz = Maßnahmetitel Z-A. (optional)

    try:
        # Coaching-/Aktivierungsangebote
        api_response = api_instance.aktivierungsangebote(mz, sw=sw, ort=ort, pg=pg, re=re, ban=ban, uk=uk, mna=mna, deufoev=deufoev, sort=sort)
        pprint(api_response)
    except coachingangebote.ApiException as e:
        print("Exception when calling DefaultApi->aktivierungsangebote: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.arbeitsagentur.de/infosysbub/avgs*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**aktivierungsangebote**](docs/DefaultApi.md#aktivierungsangebote) | **GET** /pc/v1/aktivierungsangebote | Coaching-/Aktivierungsangebote


## Documentation For Models

 - [Response](docs/Response.md)
 - [ResponseAggregations](docs/ResponseAggregations.md)
 - [ResponseAggregationsANZAHLAUSGEFILTERT](docs/ResponseAggregationsANZAHLAUSGEFILTERT.md)
 - [ResponseAggregationsANZAHLGESAMT](docs/ResponseAggregationsANZAHLGESAMT.md)
 - [ResponseAggregationsREGIONEN](docs/ResponseAggregationsREGIONEN.md)
 - [ResponseAggregationsUNTERRICHSFORMEN](docs/ResponseAggregationsUNTERRICHSFORMEN.md)
 - [ResponseEmbedded](docs/ResponseEmbedded.md)
 - [ResponseEmbeddedAbstaende](docs/ResponseEmbeddedAbstaende.md)
 - [ResponseEmbeddedAdresse](docs/ResponseEmbeddedAdresse.md)
 - [ResponseEmbeddedAngebot](docs/ResponseEmbeddedAngebot.md)
 - [ResponseEmbeddedAngebotAnbieter](docs/ResponseEmbeddedAngebotAnbieter.md)
 - [ResponseEmbeddedAngebotAnbieterAdresse](docs/ResponseEmbeddedAngebotAnbieterAdresse.md)
 - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasse](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasse.md)
 - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseKoordinaten](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseKoordinaten.md)
 - [ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseLand](docs/ResponseEmbeddedAngebotAnbieterAdresseOrtStrasseLand.md)
 - [ResponseEmbeddedAngebotAnbieterLogo](docs/ResponseEmbeddedAngebotAnbieterLogo.md)
 - [ResponseEmbeddedAngebotSuchworte](docs/ResponseEmbeddedAngebotSuchworte.md)
 - [ResponseEmbeddedAngebotSystematiken](docs/ResponseEmbeddedAngebotSystematiken.md)
 - [ResponseEmbeddedAngebotZertifizierer](docs/ResponseEmbeddedAngebotZertifizierer.md)
 - [ResponseEmbeddedAnsprechpartner](docs/ResponseEmbeddedAnsprechpartner.md)
 - [ResponseEmbeddedOrt](docs/ResponseEmbeddedOrt.md)
 - [ResponseEmbeddedRollen](docs/ResponseEmbeddedRollen.md)
 - [ResponseEmbeddedTermine](docs/ResponseEmbeddedTermine.md)
 - [ResponseEmbeddedUnterrichtsform](docs/ResponseEmbeddedUnterrichtsform.md)
 - [ResponseLinks](docs/ResponseLinks.md)
 - [ResponseLinksFirst](docs/ResponseLinksFirst.md)
 - [ResponsePage](docs/ResponsePage.md)


## Documentation For Authorization


## clientCredAuth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Author

andreasfischer1985@web.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in coachingangebote.apis and coachingangebote.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from deutschland.coachingangebote.api.default_api import DefaultApi`
- `from deutschland.coachingangebote.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
from deutschland import coachingangebote
from deutschland.coachingangebote.apis import *
from deutschland.coachingangebote.models import *
```

