# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/package/catalog.ipynb (unless otherwise specified).

__all__ = ['cd', 'change_cwd_dir', 'get_config', 'get_catalog', 'get_parameters', 'reload_catalog', 'reload',
           'package_outer_folder']

# Cell

from functools import wraps
from contextlib import contextmanager
from typing import Union, List
from fastcore.meta import delegates

@contextmanager
def cd(newdir):
    prevdir = os.getcwd()
    os.chdir(os.path.expanduser(newdir))
    try:
        yield
    finally:
        os.chdir(prevdir)

def change_cwd_dir(new_dir):
    def decorator(func):
        @wraps(func)
        def wrapped_func(*args, **kwargs):
            with cd(new_dir):
                func_result = func(*args, **kwargs)
            return func_result
        return wrapped_func
    return decorator



# Cell

import combinatorial_gwas
from kedro.config import ConfigLoader, TemplatedConfigLoader
from kedro.io import DataCatalog
import os
from pathlib import Path

package_outer_folder = Path(combinatorial_gwas.__file__).parents[1]

@change_cwd_dir(new_dir = package_outer_folder)
def get_config(env, patterns, globals_pattern="globals*.y*ml"):#(env, patterns):
    if not isinstance(env, list):
        env = [env]

    # Initialise a ConfigLoader
    conf_loader = TemplatedConfigLoader([f"conf/{single_env}" for single_env in env], globals_pattern=globals_pattern)

    # Load the data catalog configuration from catalog.yml
    conf= conf_loader.get(*patterns)

    return conf

@change_cwd_dir(new_dir = package_outer_folder)
@delegates(get_config)
def get_catalog(env: Union[str, List[str]]=["base", "local"], patterns=["catalog*.yml", "catalog*.yaml", "catalog*/*.yml", "catalog*/*.yaml"], **kwargs):

    conf_catalog = get_config(env, patterns, **kwargs)#env, patterns)

    # Create the DataCatalog instance from the configuration
    catalog = DataCatalog.from_config(conf_catalog)
    catalog.load = change_cwd_dir(package_outer_folder)(catalog.load)
    catalog.save = change_cwd_dir(package_outer_folder)(catalog.save)
    catalog.env = env
    catalog.patterns = patterns
    catalog.reload = reload.__get__(catalog)
    return catalog

@change_cwd_dir(new_dir = package_outer_folder)
def get_parameters(env=["base", "local"], patterns=["param*.yml", "param*.yaml", "param*/*.yml", "param*/*.yaml"]):
    params = get_config(env, patterns)
    return params

def reload_catalog(catalog):
    return get_catalog(catalog.env, catalog.patterns)

def reload(self):
    return reload_catalog(self)


# catalog_all = get_catalog()
# parameters_all = get_config("base", ["parameters*.yml", "parameters*/*.yml"])