"""
    StatusCake API

    Copyright (c) 2022

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or  sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    API Version: 1.0.0
    Contact: support@statuscake.com

    Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
"""


import re  # noqa: F401
import sys  # noqa: F401

from statuscake.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from statuscake.exceptions import ApiAttributeError


def lazy_import():
    from statuscake.model.monitoring_location import MonitoringLocation
    from statuscake.model.uptime_test_check_rate import UptimeTestCheckRate
    from statuscake.model.uptime_test_processing_state import UptimeTestProcessingState
    from statuscake.model.uptime_test_status import UptimeTestStatus
    from statuscake.model.uptime_test_type import UptimeTestType
    globals()['MonitoringLocation'] = MonitoringLocation
    globals()['UptimeTestCheckRate'] = UptimeTestCheckRate
    globals()['UptimeTestProcessingState'] = UptimeTestProcessingState
    globals()['UptimeTestStatus'] = UptimeTestStatus
    globals()['UptimeTestType'] = UptimeTestType


class UptimeTest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('confirmation',): {
            'inclusive_maximum': 3,
            'inclusive_minimum': 0,
        },
        ('timeout',): {
            'inclusive_maximum': 75,
            'inclusive_minimum': 5,
        },
        ('trigger_rate',): {
            'inclusive_maximum': 60,
            'inclusive_minimum': 0,
        },
        ('uptime',): {
            'inclusive_minimum': 0,
        },
        ('port',): {
            'inclusive_minimum': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'test_type': (UptimeTestType,),  # noqa: E501
            'website_url': (str,),  # noqa: E501
            'check_rate': (UptimeTestCheckRate,),  # noqa: E501
            'confirmation': (int,),  # noqa: E501
            'contact_groups': ([str],),  # noqa: E501
            'dns_ips': ([str],),  # noqa: E501
            'do_not_find': (bool,),  # noqa: E501
            'enable_ssl_alert': (bool,),  # noqa: E501
            'follow_redirects': (bool,),  # noqa: E501
            'include_header': (bool,),  # noqa: E501
            'paused': (bool,),  # noqa: E501
            'processing': (bool,),  # noqa: E501
            'servers': ([MonitoringLocation],),  # noqa: E501
            'status': (UptimeTestStatus,),  # noqa: E501
            'status_codes': ([str],),  # noqa: E501
            'tags': ([str],),  # noqa: E501
            'timeout': (int,),  # noqa: E501
            'trigger_rate': (int,),  # noqa: E501
            'uptime': (float,),  # noqa: E501
            'use_jar': (bool,),  # noqa: E501
            'custom_header': (str,),  # noqa: E501
            'dns_server': (str,),  # noqa: E501
            'final_endpoint': (str,),  # noqa: E501
            'find_string': (str,),  # noqa: E501
            'host': (str,),  # noqa: E501
            'last_tested_at': (datetime,),  # noqa: E501
            'next_location': (str,),  # noqa: E501
            'port': (int,),  # noqa: E501
            'post_body': (str,),  # noqa: E501
            'post_raw': (str,),  # noqa: E501
            'processing_on': (str,),  # noqa: E501
            'processing_state': (UptimeTestProcessingState,),  # noqa: E501
            'user_agent': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'test_type': 'test_type',  # noqa: E501
        'website_url': 'website_url',  # noqa: E501
        'check_rate': 'check_rate',  # noqa: E501
        'confirmation': 'confirmation',  # noqa: E501
        'contact_groups': 'contact_groups',  # noqa: E501
        'dns_ips': 'dns_ips',  # noqa: E501
        'do_not_find': 'do_not_find',  # noqa: E501
        'enable_ssl_alert': 'enable_ssl_alert',  # noqa: E501
        'follow_redirects': 'follow_redirects',  # noqa: E501
        'include_header': 'include_header',  # noqa: E501
        'paused': 'paused',  # noqa: E501
        'processing': 'processing',  # noqa: E501
        'servers': 'servers',  # noqa: E501
        'status': 'status',  # noqa: E501
        'status_codes': 'status_codes',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'timeout': 'timeout',  # noqa: E501
        'trigger_rate': 'trigger_rate',  # noqa: E501
        'uptime': 'uptime',  # noqa: E501
        'use_jar': 'use_jar',  # noqa: E501
        'custom_header': 'custom_header',  # noqa: E501
        'dns_server': 'dns_server',  # noqa: E501
        'final_endpoint': 'final_endpoint',  # noqa: E501
        'find_string': 'find_string',  # noqa: E501
        'host': 'host',  # noqa: E501
        'last_tested_at': 'last_tested_at',  # noqa: E501
        'next_location': 'next_location',  # noqa: E501
        'port': 'port',  # noqa: E501
        'post_body': 'post_body',  # noqa: E501
        'post_raw': 'post_raw',  # noqa: E501
        'processing_on': 'processing_on',  # noqa: E501
        'processing_state': 'processing_state',  # noqa: E501
        'user_agent': 'user_agent',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, name, test_type, website_url, check_rate, confirmation, contact_groups, dns_ips, do_not_find, enable_ssl_alert, follow_redirects, include_header, paused, processing, servers, status, status_codes, tags, timeout, trigger_rate, uptime, use_jar, *args, **kwargs):  # noqa: E501
        """UptimeTest - a model defined in OpenAPI

        Args:
            id (str): Uptime check ID
            name (str): Name of the check
            test_type (UptimeTestType):
            website_url (str): URL, FQDN, or IP address of the server under test
            check_rate (UptimeTestCheckRate):
            confirmation (int): Number of confirmation servers to confirm downtime before an alert is triggered
            contact_groups ([str]): List of contact group IDs
            dns_ips ([str]): List of IP addresses to compare against returned DNS records
            do_not_find (bool): Whether to consider the check as down if the content is present within the response
            enable_ssl_alert (bool): Whether to send an alert if the SSL certificate is soon to expire
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default
            include_header (bool): Include header content in string match search
            paused (bool): Whether the check should be run
            processing (bool): Whether the check is currently being processed
            servers ([MonitoringLocation]): List of assigned monitoring locations on which to run checks
            status (UptimeTestStatus):
            status_codes ([str]): List of status codes that trigger an alert
            tags ([str]): List of tags
            timeout (int): The number of seconds to wait to receive the first byte
            trigger_rate (int): The number of minutes to wait before sending an alert
            uptime (float): Uptime percentage for a check
            use_jar (bool): Whether to enable cookie storage

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            custom_header (str): JSON object. Represents headers to be sent when making requests. [optional]  # noqa: E501
            dns_server (str): FQDN or IP address of the nameserver to query. [optional]  # noqa: E501
            final_endpoint (str): Specify where the redirect chain should end. [optional]  # noqa: E501
            find_string (str): String to look for within the response. Considered down if not found. [optional]  # noqa: E501
            host (str): Name of the hosting provider. [optional]  # noqa: E501
            last_tested_at (datetime): When the check was last run (RFC3339 format). [optional]  # noqa: E501
            next_location (str): The server location the check will run next. [optional]  # noqa: E501
            port (int): Destination port for TCP checks. [optional]  # noqa: E501
            post_body (str): JSON object. Payload submitted with the request. Setting this updates the check to use the HTTP POST verb. [optional]  # noqa: E501
            post_raw (str): Raw HTTP POST string to send to the server. [optional]  # noqa: E501
            processing_on (str): The server location the check is currently being run. [optional]  # noqa: E501
            processing_state (UptimeTestProcessingState): [optional]  # noqa: E501
            user_agent (str): Custom user agent string set when testing. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.test_type = test_type
        self.website_url = website_url
        self.check_rate = check_rate
        self.confirmation = confirmation
        self.contact_groups = contact_groups
        self.dns_ips = dns_ips
        self.do_not_find = do_not_find
        self.enable_ssl_alert = enable_ssl_alert
        self.follow_redirects = follow_redirects
        self.include_header = include_header
        self.paused = paused
        self.processing = processing
        self.servers = servers
        self.status = status
        self.status_codes = status_codes
        self.tags = tags
        self.timeout = timeout
        self.trigger_rate = trigger_rate
        self.uptime = uptime
        self.use_jar = use_jar
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                    self._configuration is not None and \
                    self._configuration.discard_unknown_keys and \
                    self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, name, test_type, website_url, check_rate, confirmation, contact_groups, dns_ips, do_not_find, enable_ssl_alert, follow_redirects, include_header, paused, processing, servers, status, status_codes, tags, timeout, trigger_rate, uptime, use_jar, *args, **kwargs):  # noqa: E501
        """UptimeTest - a model defined in OpenAPI

        Args:
            id (str): Uptime check ID
            name (str): Name of the check
            test_type (UptimeTestType):
            website_url (str): URL, FQDN, or IP address of the server under test
            check_rate (UptimeTestCheckRate):
            confirmation (int): Number of confirmation servers to confirm downtime before an alert is triggered
            contact_groups ([str]): List of contact group IDs
            dns_ips ([str]): List of IP addresses to compare against returned DNS records
            do_not_find (bool): Whether to consider the check as down if the content is present within the response
            enable_ssl_alert (bool): Whether to send an alert if the SSL certificate is soon to expire
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default
            include_header (bool): Include header content in string match search
            paused (bool): Whether the check should be run
            processing (bool): Whether the check is currently being processed
            servers ([MonitoringLocation]): List of assigned monitoring locations on which to run checks
            status (UptimeTestStatus):
            status_codes ([str]): List of status codes that trigger an alert
            tags ([str]): List of tags
            timeout (int): The number of seconds to wait to receive the first byte
            trigger_rate (int): The number of minutes to wait before sending an alert
            uptime (float): Uptime percentage for a check
            use_jar (bool): Whether to enable cookie storage

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            custom_header (str): JSON object. Represents headers to be sent when making requests. [optional]  # noqa: E501
            dns_server (str): FQDN or IP address of the nameserver to query. [optional]  # noqa: E501
            final_endpoint (str): Specify where the redirect chain should end. [optional]  # noqa: E501
            find_string (str): String to look for within the response. Considered down if not found. [optional]  # noqa: E501
            host (str): Name of the hosting provider. [optional]  # noqa: E501
            last_tested_at (datetime): When the check was last run (RFC3339 format). [optional]  # noqa: E501
            next_location (str): The server location the check will run next. [optional]  # noqa: E501
            port (int): Destination port for TCP checks. [optional]  # noqa: E501
            post_body (str): JSON object. Payload submitted with the request. Setting this updates the check to use the HTTP POST verb. [optional]  # noqa: E501
            post_raw (str): Raw HTTP POST string to send to the server. [optional]  # noqa: E501
            processing_on (str): The server location the check is currently being run. [optional]  # noqa: E501
            processing_state (UptimeTestProcessingState): [optional]  # noqa: E501
            user_agent (str): Custom user agent string set when testing. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.test_type = test_type
        self.website_url = website_url
        self.check_rate = check_rate
        self.confirmation = confirmation
        self.contact_groups = contact_groups
        self.dns_ips = dns_ips
        self.do_not_find = do_not_find
        self.enable_ssl_alert = enable_ssl_alert
        self.follow_redirects = follow_redirects
        self.include_header = include_header
        self.paused = paused
        self.processing = processing
        self.servers = servers
        self.status = status
        self.status_codes = status_codes
        self.tags = tags
        self.timeout = timeout
        self.trigger_rate = trigger_rate
        self.uptime = uptime
        self.use_jar = use_jar
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                    self._configuration is not None and \
                    self._configuration.discard_unknown_keys and \
                    self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                        f"class with read only attributes.")
