"""
    StatusCake API

    Copyright (c) 2022

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or  sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    API Version: 1.0.0
    Contact: support@statuscake.com

    Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
"""


import re  # noqa: F401
import sys  # noqa: F401

from statuscake.api_client import ApiClient, Endpoint as _Endpoint
from statuscake.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from statuscake.model.api_error import APIError
from statuscake.model.api_response import APIResponse
from statuscake.model.uptime_test_alerts import UptimeTestAlerts
from statuscake.model.uptime_test_check_rate import UptimeTestCheckRate
from statuscake.model.uptime_test_history import UptimeTestHistory
from statuscake.model.uptime_test_periods import UptimeTestPeriods
from statuscake.model.uptime_test_response import UptimeTestResponse
from statuscake.model.uptime_test_type import UptimeTestType
from statuscake.model.uptime_tests import UptimeTests


class UptimeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_uptime_test_endpoint = _Endpoint(
            settings={
                'response_type': (APIResponse,),
                'auth': [],
                'endpoint_path': '/uptime',
                'operation_id': 'create_uptime_test',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'test_type',
                    'website_url',
                    'check_rate',
                    'basic_username',
                    'basic_password',
                    'confirmation',
                    'contact_groups',
                    'custom_header',
                    'do_not_find',
                    'dns_ips',
                    'dns_server',
                    'enable_ssl_alert',
                    'final_endpoint',
                    'find_string',
                    'follow_redirects',
                    'host',
                    'include_header',
                    'paused',
                    'port',
                    'post_body',
                    'post_raw',
                    'regions',
                    'status_codes_csv',
                    'tags',
                    'timeout',
                    'trigger_rate',
                    'use_jar',
                    'user_agent',
                ],
                'required': [
                    'name',
                    'test_type',
                    'website_url',
                    'check_rate',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'confirmation',
                    'port',
                    'timeout',
                    'trigger_rate',
                ]
            },
            root_map={
                'validations': {
                    ('confirmation',): {

                        'inclusive_maximum': 3,
                        'inclusive_minimum': 0,
                    },
                    ('port',): {

                        'inclusive_minimum': 0,
                    },
                    ('timeout',): {

                        'inclusive_maximum': 75,
                        'inclusive_minimum': 5,
                    },
                    ('trigger_rate',): {

                        'inclusive_maximum': 60,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'test_type':
                        (UptimeTestType,),
                    'website_url':
                        (str,),
                    'check_rate':
                        (UptimeTestCheckRate,),
                    'basic_username':
                        (str,),
                    'basic_password':
                        (str,),
                    'confirmation':
                        (int,),
                    'contact_groups':
                        ([str],),
                    'custom_header':
                        (str,),
                    'do_not_find':
                        (bool,),
                    'dns_ips':
                        ([str],),
                    'dns_server':
                        (str,),
                    'enable_ssl_alert':
                        (bool,),
                    'final_endpoint':
                        (str,),
                    'find_string':
                        (str,),
                    'follow_redirects':
                        (bool,),
                    'host':
                        (str,),
                    'include_header':
                        (bool,),
                    'paused':
                        (bool,),
                    'port':
                        (int,),
                    'post_body':
                        (str,),
                    'post_raw':
                        (str,),
                    'regions':
                        ([str],),
                    'status_codes_csv':
                        (str,),
                    'tags':
                        ([str],),
                    'timeout':
                        (int,),
                    'trigger_rate':
                        (int,),
                    'use_jar':
                        (bool,),
                    'user_agent':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'test_type': 'test_type',
                    'website_url': 'website_url',
                    'check_rate': 'check_rate',
                    'basic_username': 'basic_username',
                    'basic_password': 'basic_password',
                    'confirmation': 'confirmation',
                    'contact_groups': 'contact_groups',
                    'custom_header': 'custom_header',
                    'do_not_find': 'do_not_find',
                    'dns_ips': 'dns_ips',
                    'dns_server': 'dns_server',
                    'enable_ssl_alert': 'enable_ssl_alert',
                    'final_endpoint': 'final_endpoint',
                    'find_string': 'find_string',
                    'follow_redirects': 'follow_redirects',
                    'host': 'host',
                    'include_header': 'include_header',
                    'paused': 'paused',
                    'port': 'port',
                    'post_body': 'post_body',
                    'post_raw': 'post_raw',
                    'regions': 'regions',
                    'status_codes_csv': 'status_codes_csv',
                    'tags': 'tags',
                    'timeout': 'timeout',
                    'trigger_rate': 'trigger_rate',
                    'use_jar': 'use_jar',
                    'user_agent': 'user_agent',
                },
                'location_map': {
                    'name': 'form',
                    'test_type': 'form',
                    'website_url': 'form',
                    'check_rate': 'form',
                    'basic_username': 'form',
                    'basic_password': 'form',
                    'confirmation': 'form',
                    'contact_groups': 'form',
                    'custom_header': 'form',
                    'do_not_find': 'form',
                    'dns_ips': 'form',
                    'dns_server': 'form',
                    'enable_ssl_alert': 'form',
                    'final_endpoint': 'form',
                    'find_string': 'form',
                    'follow_redirects': 'form',
                    'host': 'form',
                    'include_header': 'form',
                    'paused': 'form',
                    'port': 'form',
                    'post_body': 'form',
                    'post_raw': 'form',
                    'regions': 'form',
                    'status_codes_csv': 'form',
                    'tags': 'form',
                    'timeout': 'form',
                    'trigger_rate': 'form',
                    'use_jar': 'form',
                    'user_agent': 'form',
                },
                'collection_format_map': {
                    'contact_groups': 'csv',
                    'dns_ips': 'csv',
                    'regions': 'csv',
                    'tags': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )
        self.delete_uptime_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/uptime/{test_id}',
                'operation_id': 'delete_uptime_test',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_uptime_test_endpoint = _Endpoint(
            settings={
                'response_type': (UptimeTestResponse,),
                'auth': [],
                'endpoint_path': '/uptime/{test_id}',
                'operation_id': 'get_uptime_test',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_uptime_test_alerts_endpoint = _Endpoint(
            settings={
                'response_type': (UptimeTestAlerts,),
                'auth': [],
                'endpoint_path': '/uptime/{test_id}/alerts',
                'operation_id': 'list_uptime_test_alerts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'limit',
                    'before',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'before',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('before',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'limit':
                        (int,),
                    'before':
                        (int,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'limit': 'limit',
                    'before': 'before',
                },
                'location_map': {
                    'test_id': 'path',
                    'limit': 'query',
                    'before': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_uptime_test_history_endpoint = _Endpoint(
            settings={
                'response_type': (UptimeTestHistory,),
                'auth': [],
                'endpoint_path': '/uptime/{test_id}/history',
                'operation_id': 'list_uptime_test_history',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'limit',
                    'before',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'before',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('before',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'limit':
                        (int,),
                    'before':
                        (int,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'limit': 'limit',
                    'before': 'before',
                },
                'location_map': {
                    'test_id': 'path',
                    'limit': 'query',
                    'before': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_uptime_test_periods_endpoint = _Endpoint(
            settings={
                'response_type': (UptimeTestPeriods,),
                'auth': [],
                'endpoint_path': '/uptime/{test_id}/periods',
                'operation_id': 'list_uptime_test_periods',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'limit',
                    'before',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'before',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('before',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'limit':
                        (int,),
                    'before':
                        (int,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'limit': 'limit',
                    'before': 'before',
                },
                'location_map': {
                    'test_id': 'path',
                    'limit': 'query',
                    'before': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_uptime_tests_endpoint = _Endpoint(
            settings={
                'response_type': (UptimeTests,),
                'auth': [],
                'endpoint_path': '/uptime',
                'operation_id': 'list_uptime_tests',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'status',
                    'page',
                    'limit',
                    'tags',
                    'matchany',
                    'nouptime',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'page',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "DOWN": "down",
                        "UP": "up"
                    },
                },
                'openapi_types': {
                    'status':
                        (str,),
                    'page':
                        (int,),
                    'limit':
                        (int,),
                    'tags':
                        (str,),
                    'matchany':
                        (bool,),
                    'nouptime':
                        (bool,),
                },
                'attribute_map': {
                    'status': 'status',
                    'page': 'page',
                    'limit': 'limit',
                    'tags': 'tags',
                    'matchany': 'matchany',
                    'nouptime': 'nouptime',
                },
                'location_map': {
                    'status': 'query',
                    'page': 'query',
                    'limit': 'query',
                    'tags': 'query',
                    'matchany': 'query',
                    'nouptime': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_uptime_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/uptime/{test_id}',
                'operation_id': 'update_uptime_test',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'name',
                    'check_rate',
                    'basic_username',
                    'basic_password',
                    'confirmation',
                    'contact_groups',
                    'custom_header',
                    'do_not_find',
                    'dns_ips',
                    'dns_server',
                    'enable_ssl_alert',
                    'final_endpoint',
                    'find_string',
                    'follow_redirects',
                    'host',
                    'include_header',
                    'paused',
                    'port',
                    'post_body',
                    'post_raw',
                    'regions',
                    'status_codes_csv',
                    'tags',
                    'timeout',
                    'trigger_rate',
                    'use_jar',
                    'user_agent',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'confirmation',
                    'port',
                    'timeout',
                    'trigger_rate',
                ]
            },
            root_map={
                'validations': {
                    ('confirmation',): {

                        'inclusive_maximum': 3,
                        'inclusive_minimum': 0,
                    },
                    ('port',): {

                        'inclusive_minimum': 0,
                    },
                    ('timeout',): {

                        'inclusive_maximum': 75,
                        'inclusive_minimum': 5,
                    },
                    ('trigger_rate',): {

                        'inclusive_maximum': 60,
                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'name':
                        (str,),
                    'check_rate':
                        (UptimeTestCheckRate,),
                    'basic_username':
                        (str,),
                    'basic_password':
                        (str,),
                    'confirmation':
                        (int,),
                    'contact_groups':
                        ([str],),
                    'custom_header':
                        (str,),
                    'do_not_find':
                        (bool,),
                    'dns_ips':
                        ([str],),
                    'dns_server':
                        (str,),
                    'enable_ssl_alert':
                        (bool,),
                    'final_endpoint':
                        (str,),
                    'find_string':
                        (str,),
                    'follow_redirects':
                        (bool,),
                    'host':
                        (str,),
                    'include_header':
                        (bool,),
                    'paused':
                        (bool,),
                    'port':
                        (int,),
                    'post_body':
                        (str,),
                    'post_raw':
                        (str,),
                    'regions':
                        ([str],),
                    'status_codes_csv':
                        (str,),
                    'tags':
                        ([str],),
                    'timeout':
                        (int,),
                    'trigger_rate':
                        (int,),
                    'use_jar':
                        (bool,),
                    'user_agent':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'name': 'name',
                    'check_rate': 'check_rate',
                    'basic_username': 'basic_username',
                    'basic_password': 'basic_password',
                    'confirmation': 'confirmation',
                    'contact_groups': 'contact_groups',
                    'custom_header': 'custom_header',
                    'do_not_find': 'do_not_find',
                    'dns_ips': 'dns_ips',
                    'dns_server': 'dns_server',
                    'enable_ssl_alert': 'enable_ssl_alert',
                    'final_endpoint': 'final_endpoint',
                    'find_string': 'find_string',
                    'follow_redirects': 'follow_redirects',
                    'host': 'host',
                    'include_header': 'include_header',
                    'paused': 'paused',
                    'port': 'port',
                    'post_body': 'post_body',
                    'post_raw': 'post_raw',
                    'regions': 'regions',
                    'status_codes_csv': 'status_codes_csv',
                    'tags': 'tags',
                    'timeout': 'timeout',
                    'trigger_rate': 'trigger_rate',
                    'use_jar': 'use_jar',
                    'user_agent': 'user_agent',
                },
                'location_map': {
                    'test_id': 'path',
                    'name': 'form',
                    'check_rate': 'form',
                    'basic_username': 'form',
                    'basic_password': 'form',
                    'confirmation': 'form',
                    'contact_groups': 'form',
                    'custom_header': 'form',
                    'do_not_find': 'form',
                    'dns_ips': 'form',
                    'dns_server': 'form',
                    'enable_ssl_alert': 'form',
                    'final_endpoint': 'form',
                    'find_string': 'form',
                    'follow_redirects': 'form',
                    'host': 'form',
                    'include_header': 'form',
                    'paused': 'form',
                    'port': 'form',
                    'post_body': 'form',
                    'post_raw': 'form',
                    'regions': 'form',
                    'status_codes_csv': 'form',
                    'tags': 'form',
                    'timeout': 'form',
                    'trigger_rate': 'form',
                    'use_jar': 'form',
                    'user_agent': 'form',
                },
                'collection_format_map': {
                    'contact_groups': 'csv',
                    'dns_ips': 'csv',
                    'regions': 'csv',
                    'tags': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )

    def create_uptime_test(
        self,
        name,
        test_type,
        website_url,
        check_rate,
        **kwargs
    ):
        """Create an uptime check  # noqa: E501

        Creates an uptime check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_uptime_test(name, test_type, website_url, check_rate, async_req=True)
        >>> result = thread.get()

        Args:
            name (str): Name of the check
            test_type (UptimeTestType):
            website_url (str): URL or IP address of the server under test
            check_rate (UptimeTestCheckRate):

        Keyword Args:
            basic_username (str): Basic authentication username. [optional]
            basic_password (str): Basic authentication password. [optional]
            confirmation (int): Number of confirmation servers to confirm downtime before an alert is triggered. [optional] if omitted the server will use the default value of 2
            contact_groups ([str]): List of contact group IDs. [optional]
            custom_header (str): JSON object. Represents headers to be sent when making requests. [optional]
            do_not_find (bool): Whether to consider the check as down if the content is present within the response. [optional] if omitted the server will use the default value of False
            dns_ips ([str]): List of IP addresses to compare against returned DNS records. [optional]
            dns_server (str): FQDN or IP address of the nameserver to query. [optional]
            enable_ssl_alert (bool): Whether to send an alert if the SSL certificate is soon to expire. [optional] if omitted the server will use the default value of False
            final_endpoint (str): Specify where the redirect chain should end. [optional]
            find_string (str): String to look for within the response. Considered down if not found. [optional]
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default. [optional] if omitted the server will use the default value of False
            host (str): Name of the hosting provider. [optional]
            include_header (bool): Include header content in string match search. [optional] if omitted the server will use the default value of False
            paused (bool): Whether the check should be run. [optional] if omitted the server will use the default value of False
            port (int): Destination port for TCP checks. [optional]
            post_body (str): JSON object. Payload submitted with the request. Setting this updates the check to use the HTTP POST verb. [optional]
            post_raw (str): Raw HTTP POST string to send to the server. [optional]
            regions ([str]): List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET /v1/uptime-locations` endpoint.. [optional]
            status_codes_csv (str): Comma separated list of status codes that trigger an alert. [optional]
            tags ([str]): List of tags. [optional]
            timeout (int): The number of seconds to wait to receive the first byte. [optional] if omitted the server will use the default value of 15
            trigger_rate (int): The number of minutes to wait before sending an alert. [optional] if omitted the server will use the default value of 0
            use_jar (bool): Whether to enable cookie storage. [optional] if omitted the server will use the default value of False
            user_agent (str): Custom user agent string set when testing. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['name'] = \
            name
        kwargs['test_type'] = \
            test_type
        kwargs['website_url'] = \
            website_url
        kwargs['check_rate'] = \
            check_rate
        return self.create_uptime_test_endpoint.call_with_http_info(**kwargs)

    def delete_uptime_test(
        self,
        test_id,
        **kwargs
    ):
        """Delete an uptime check  # noqa: E501

        Deletes an uptime check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_uptime_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.delete_uptime_test_endpoint.call_with_http_info(**kwargs)

    def get_uptime_test(
        self,
        test_id,
        **kwargs
    ):
        """Retrieve an uptime check  # noqa: E501

        Returns an uptime check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_uptime_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UptimeTestResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.get_uptime_test_endpoint.call_with_http_info(**kwargs)

    def list_uptime_test_alerts(
        self,
        test_id,
        **kwargs
    ):
        """Get all uptime check alerts  # noqa: E501

        Returns a list of uptime check alerts for a given id.  The returned results are a paginated series. Alongside the response data is a `links` object referencing the current response document, `self`, and the next page in the series, `next`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_uptime_test_alerts(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            limit (int): The number of uptime alerts to return per page. [optional] if omitted the server will use the default value of 25
            before (int): Only alerts triggered before this UNIX timestamp will be returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UptimeTestAlerts
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.list_uptime_test_alerts_endpoint.call_with_http_info(**kwargs)

    def list_uptime_test_history(
        self,
        test_id,
        **kwargs
    ):
        """Get all uptime check history  # noqa: E501

        Returns a list of uptime check history results for a given id, detailing the runs performed on the StatusCake testing infrastruture.  The returned results are a paginated series. Alongside the response data is a `links` object referencing the current response document, `self`, and the next page in the series, `next`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_uptime_test_history(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            limit (int): The number of results to return per page. [optional] if omitted the server will use the default value of 25
            before (int): Only results created before this UNIX timestamp will be returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UptimeTestHistory
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.list_uptime_test_history_endpoint.call_with_http_info(**kwargs)

    def list_uptime_test_periods(
        self,
        test_id,
        **kwargs
    ):
        """Get all uptime check periods  # noqa: E501

        Returns a list of uptime check periods for a given id, detailing the creation time of the period, when it ended and the duration.  The returned results are a paginated series. Alongside the response data is a `links` object referencing the current response document, `self`, and the next page in the series, `next`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_uptime_test_periods(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            limit (int): The number of uptime check periods to return per page. [optional] if omitted the server will use the default value of 25
            before (int): Only check periods created before this UNIX timestamp will be returned. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UptimeTestPeriods
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.list_uptime_test_periods_endpoint.call_with_http_info(**kwargs)

    def list_uptime_tests(
        self,
        **kwargs
    ):
        """Get all uptime checks  # noqa: E501

        Returns a list of uptime checks for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_uptime_tests(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            status (str): Uptime check status. [optional]
            page (int): Page of results. [optional] if omitted the server will use the default value of 1
            limit (int): The number of uptime checks to return per page. [optional] if omitted the server will use the default value of 25
            tags (str): Comma separated list of tags assocaited with a check. [optional]
            matchany (bool): Include uptime checks in response that match any specified tag or all tags. [optional] if omitted the server will use the default value of False
            nouptime (bool): Do not calculate uptime percentages for results. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UptimeTests
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_uptime_tests_endpoint.call_with_http_info(**kwargs)

    def update_uptime_test(
        self,
        test_id,
        **kwargs
    ):
        """Update an uptime check  # noqa: E501

        Updates an uptime check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_uptime_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Uptime check ID

        Keyword Args:
            name (str): Name of the check. [optional]
            check_rate (UptimeTestCheckRate): [optional]
            basic_username (str): Basic authentication username. [optional]
            basic_password (str): Basic authentication password. [optional]
            confirmation (int): Number of confirmation servers to confirm downtime before an alert is triggered. [optional]
            contact_groups ([str]): List of contact group IDs. [optional]
            custom_header (str): JSON object. Represents headers to be sent when making requests. [optional]
            do_not_find (bool): Whether to consider the check as down if the content is present within the response. [optional]
            dns_ips ([str]): List of IP addresses to compare against returned DNS records. [optional]
            dns_server (str): FQDN or IP address of the nameserver to query. [optional]
            enable_ssl_alert (bool): Whether to send an alert if the SSL certificate is soon to expire. [optional]
            final_endpoint (str): Specify where the redirect chain should end. [optional]
            find_string (str): String to look for within the response. Considered down if not found. [optional]
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default. [optional]
            host (str): Name of the hosting provider. [optional]
            include_header (bool): Include header content in string match search. [optional]
            paused (bool): Whether the check should be run. [optional]
            port (int): Destination port for TCP checks. [optional]
            post_body (str): JSON object. Payload submitted with the request. Setting this updates the check to use the HTTP POST verb. [optional]
            post_raw (str): Raw HTTP POST string to send to the server. [optional]
            regions ([str]): List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET /v1/uptime-locations` endpoint.. [optional]
            status_codes_csv (str): Comma separated list of status codes that trigger an alert. [optional]
            tags ([str]): List of tags. [optional]
            timeout (int): The number of seconds to wait to receive the first byte. [optional]
            trigger_rate (int): The number of minutes to wait before sending an alert. [optional]
            use_jar (bool): Whether to enable cookie storage. [optional]
            user_agent (str): Custom user agent string set when testing. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.update_uptime_test_endpoint.call_with_http_info(**kwargs)
