"""
    StatusCake API

    Copyright (c) 2022

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or  sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    API Version: 1.0.0
    Contact: support@statuscake.com

    Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
"""


import re  # noqa: F401
import sys  # noqa: F401

from statuscake.api_client import ApiClient, Endpoint as _Endpoint
from statuscake.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from statuscake.model.api_error import APIError
from statuscake.model.api_response import APIResponse
from statuscake.model.ssl_test_check_rate import SSLTestCheckRate
from statuscake.model.ssl_test_response import SSLTestResponse
from statuscake.model.ssl_tests import SSLTests


class SslApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_ssl_test_endpoint = _Endpoint(
            settings={
                'response_type': (APIResponse,),
                'auth': [],
                'endpoint_path': '/ssl',
                'operation_id': 'create_ssl_test',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'website_url',
                    'check_rate',
                    'alert_at',
                    'alert_broken',
                    'alert_expiry',
                    'alert_mixed',
                    'alert_reminder',
                    'contact_groups',
                    'follow_redirects',
                    'hostname',
                    'paused',
                    'user_agent',
                ],
                'required': [
                    'website_url',
                    'check_rate',
                    'alert_at',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'website_url':
                        (str,),
                    'check_rate':
                        (SSLTestCheckRate,),
                    'alert_at':
                        ([int],),
                    'alert_broken':
                        (bool,),
                    'alert_expiry':
                        (bool,),
                    'alert_mixed':
                        (bool,),
                    'alert_reminder':
                        (bool,),
                    'contact_groups':
                        ([str],),
                    'follow_redirects':
                        (bool,),
                    'hostname':
                        (str,),
                    'paused':
                        (bool,),
                    'user_agent':
                        (str,),
                },
                'attribute_map': {
                    'website_url': 'website_url',
                    'check_rate': 'check_rate',
                    'alert_at': 'alert_at',
                    'alert_broken': 'alert_broken',
                    'alert_expiry': 'alert_expiry',
                    'alert_mixed': 'alert_mixed',
                    'alert_reminder': 'alert_reminder',
                    'contact_groups': 'contact_groups',
                    'follow_redirects': 'follow_redirects',
                    'hostname': 'hostname',
                    'paused': 'paused',
                    'user_agent': 'user_agent',
                },
                'location_map': {
                    'website_url': 'form',
                    'check_rate': 'form',
                    'alert_at': 'form',
                    'alert_broken': 'form',
                    'alert_expiry': 'form',
                    'alert_mixed': 'form',
                    'alert_reminder': 'form',
                    'contact_groups': 'form',
                    'follow_redirects': 'form',
                    'hostname': 'form',
                    'paused': 'form',
                    'user_agent': 'form',
                },
                'collection_format_map': {
                    'alert_at': 'csv',
                    'contact_groups': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )
        self.delete_ssl_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/ssl/{test_id}',
                'operation_id': 'delete_ssl_test',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ssl_test_endpoint = _Endpoint(
            settings={
                'response_type': (SSLTestResponse,),
                'auth': [],
                'endpoint_path': '/ssl/{test_id}',
                'operation_id': 'get_ssl_test',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                },
                'location_map': {
                    'test_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_ssl_tests_endpoint = _Endpoint(
            settings={
                'response_type': (SSLTests,),
                'auth': [],
                'endpoint_path': '/ssl',
                'operation_id': 'list_ssl_tests',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('page',): {

                        'inclusive_minimum': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'limit': 'limit',
                },
                'location_map': {
                    'page': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_ssl_test_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/ssl/{test_id}',
                'operation_id': 'update_ssl_test',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_id',
                    'check_rate',
                    'alert_at',
                    'alert_broken',
                    'alert_expiry',
                    'alert_mixed',
                    'alert_reminder',
                    'contact_groups',
                    'follow_redirects',
                    'hostname',
                    'paused',
                    'user_agent',
                ],
                'required': [
                    'test_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'test_id':
                        (str,),
                    'check_rate':
                        (SSLTestCheckRate,),
                    'alert_at':
                        ([int],),
                    'alert_broken':
                        (bool,),
                    'alert_expiry':
                        (bool,),
                    'alert_mixed':
                        (bool,),
                    'alert_reminder':
                        (bool,),
                    'contact_groups':
                        ([str],),
                    'follow_redirects':
                        (bool,),
                    'hostname':
                        (str,),
                    'paused':
                        (bool,),
                    'user_agent':
                        (str,),
                },
                'attribute_map': {
                    'test_id': 'test_id',
                    'check_rate': 'check_rate',
                    'alert_at': 'alert_at',
                    'alert_broken': 'alert_broken',
                    'alert_expiry': 'alert_expiry',
                    'alert_mixed': 'alert_mixed',
                    'alert_reminder': 'alert_reminder',
                    'contact_groups': 'contact_groups',
                    'follow_redirects': 'follow_redirects',
                    'hostname': 'hostname',
                    'paused': 'paused',
                    'user_agent': 'user_agent',
                },
                'location_map': {
                    'test_id': 'path',
                    'check_rate': 'form',
                    'alert_at': 'form',
                    'alert_broken': 'form',
                    'alert_expiry': 'form',
                    'alert_mixed': 'form',
                    'alert_reminder': 'form',
                    'contact_groups': 'form',
                    'follow_redirects': 'form',
                    'hostname': 'form',
                    'paused': 'form',
                    'user_agent': 'form',
                },
                'collection_format_map': {
                    'alert_at': 'csv',
                    'contact_groups': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client
        )

    def create_ssl_test(
        self,
        website_url,
        check_rate,
        alert_at,
        **kwargs
    ):
        """Create an SSL check  # noqa: E501

        Creates an SSL check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ssl_test(website_url, check_rate, alert_at, async_req=True)
        >>> result = thread.get()

        Args:
            website_url (str): URL of the server under test. Must begin with https://
            check_rate (SSLTestCheckRate):
            alert_at ([int]): List representing when alerts should be sent (days). Must be exactly 3 numerical values

        Keyword Args:
            alert_broken (bool): Whether to enable alerts when SSL certificate issues are found. [optional] if omitted the server will use the default value of False
            alert_expiry (bool): Whether to enable alerts when the SSL certificate is to expire. [optional] if omitted the server will use the default value of False
            alert_mixed (bool): Whether to enable alerts when mixed content is found. [optional] if omitted the server will use the default value of False
            alert_reminder (bool): Whether to enable alert reminders. [optional] if omitted the server will use the default value of False
            contact_groups ([str]): List of contact group IDs. [optional]
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default. [optional] if omitted the server will use the default value of False
            hostname (str): Hostname of the server under test. [optional]
            paused (bool): Whether the check should be run. [optional] if omitted the server will use the default value of False
            user_agent (str): Custom user agent string set when testing. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            APIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['website_url'] = \
            website_url
        kwargs['check_rate'] = \
            check_rate
        kwargs['alert_at'] = \
            alert_at
        return self.create_ssl_test_endpoint.call_with_http_info(**kwargs)

    def delete_ssl_test(
        self,
        test_id,
        **kwargs
    ):
        """Delete an SSL check  # noqa: E501

        Deletes an SSL check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ssl_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): Pagespeed check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.delete_ssl_test_endpoint.call_with_http_info(**kwargs)

    def get_ssl_test(
        self,
        test_id,
        **kwargs
    ):
        """Retrieve an SSL check  # noqa: E501

        Returns an SSL check with the given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ssl_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): SSL check ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SSLTestResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.get_ssl_test_endpoint.call_with_http_info(**kwargs)

    def list_ssl_tests(
        self,
        **kwargs
    ):
        """Get all SSL checks  # noqa: E501

        Returns a list of SSL checks for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_ssl_tests(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Page of results. [optional] if omitted the server will use the default value of 1
            limit (int): The number of SSL checks to return per page. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            SSLTests
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_ssl_tests_endpoint.call_with_http_info(**kwargs)

    def update_ssl_test(
        self,
        test_id,
        **kwargs
    ):
        """Update an SSL check  # noqa: E501

        Updates an SSL check with the given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ssl_test(test_id, async_req=True)
        >>> result = thread.get()

        Args:
            test_id (str): SSL check ID

        Keyword Args:
            check_rate (SSLTestCheckRate): [optional]
            alert_at ([int]): List representing when alerts should be sent (days). Must be exactly 3 numerical values. [optional]
            alert_broken (bool): Whether to enable alerts when SSL certificate issues are found. [optional]
            alert_expiry (bool): Whether to enable alerts when the SSL certificate is to expire. [optional]
            alert_mixed (bool): Whether to enable alerts when mixed content is found. [optional]
            alert_reminder (bool): Whether to enable alert reminders. [optional]
            contact_groups ([str]): List of contact group IDs. [optional]
            follow_redirects (bool): Whether to follow redirects when testing. Disabled by default. [optional]
            hostname (str): Hostname of the server under test. [optional]
            paused (bool): Whether the check should be run. [optional]
            user_agent (str): Custom user agent string set when testing. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['test_id'] = \
            test_id
        return self.update_ssl_test_endpoint.call_with_http_info(**kwargs)
