from setuptools import setup, find_packages
import pathlib

here = pathlib.Path(__file__).parent.resolve()
long_description = (here / "README.md").read_text(encoding="utf-8")

setup(
    name                            =   "flow_sensor_RH",
    version                         =   "0.0.6",
    description                     =   "Flow Sensor Model",
    long_description                =   long_description,
    long_description_content_type   =   "text/markdown",
    author                          =   "Renato Hong",
    author_email                    =   "13822871764@163.com",
    classifiers                     =   [
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Build Tools",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
    packages                        =   find_packages(),
    python_requires                 =   ">=3.7, <4",
)
