/*
	(Кодировка)
*/
angular.module('app', []).controller('indexController', ['$scope', indexController]);

function hrListToBootstrapTreeview(list, parentId){
	return list.filter(x=>parentId ? x.parent_id==parentId : !x.parent_id).map(function(x){
		var rs = {
			id: x.id,
			text: x.title
		}
		var subNodes =hrListToBootstrapTreeview(list, x.id)
		if (subNodes.length)
			rs.nodes = subNodes;
		return rs;
	})
}

function indexController($scope){
	var self = $scope;
	self.$ctrl = self;
	
	self.DATA = {
         date:          null    // выбранная на форме отчетная дата
        ,raisingSum:    false
		/*
			[{id, parent_id, title}, ...]
		*/
		,hrList: 	    null
		,hrMap:		    null
		,selHr:		    null
		/*
			[{"id": "eap",  "title": "Энергия акт.",    "eu": "кВт*ч"}, ... ]
		*/
		,qtList: 	    null
		,qtMap: 	    null
		,selQt:		    null
        
        /*
            ivlList: [
                {"id": str, "title": "Час/5 мин", "all_ivl": "1h", "sub_ivl": "5m", "fmt": "HH:mm"},
                ...
            ]
        */
        ,ivlList: []
        ,ivlMap: {}
		,ivlSelId:	null
        
		,onlyFinished:	true
	}
	
	self.update = async function(){
		/*
			intervals:[
                {"title": "Час/5 мин", "all_ivl": "1h", "sub_ivl": "5m", "fmt": "HH:mm"},
                {"title": "Сутки/час", "all_ivl": "1D", "sub_ivl": "1h", "fmt": "HH:mm"},
                {"title": "Месяц/сутки", "all_ivl": "1M", "sub_ivl": "1D", "fmt": "d MMM"}
            ]
		*/
		intervals = await ajax_get ('/www/intervals.json');
		console.log ( intervals );

        var index = 0
		intervals.forEach (function (ivl){
            var id = ''+index;
            index++;
            
            var x = {
                id:         id
			   //,title: 		the_time.parseIvlDef(all_ivl.id).toFriendlyString ()
			   ,title: 		ivl.title
			   ,all_ivl:    ivl.all_ivl
			   ,sub_ivl:    ivl.sub_ivl
			   ,fmt:		ivl.fmt
		   };
            
			self.DATA.ivlList.push(x);
			self.DATA.ivlMap[id] = x;
            if (self.DATA.ivlSelId === null)
                self.DATA.ivlSelId = id;
		});
		//self.onIvlChanged ();

		/*
			[{id, title, parent_id}, ...]
		*/
		var d = await ajax_get ('/enum_hr.json');

		$('#hr').treeview({
			 data: hrListToBootstrapTreeview( d )
			,multiSelect: true
		});

		self.DATA.hrList = d.map(function(x){
			return {
				 id: x.id
				,title: x.title
				,parent_id: x.parent_id
			}
		});
		self.DATA.hrMap = to_map(d, 'id');
		/*
			[{id, title, eu}, ...]
		*/
		var d = await ajax_get ('/enum_qt.json?cumulative=1');
		self.DATA.qtList = d.map(function(x){
			return {
				 id: x.id
				,title: x.title
				,eu: x.eu
			}
		});
		self.DATA.qtMap = to_map(d, 'id');
		
		$scope.$apply ();
	}
	self.update ();
    

	self.onQtSelected = async function(qt){
		self.DATA.selQt = qt;
	}

	self.read = async function(){
        var setpt = self.DATA.date; // null => сегодня
        var raisingSum = self.DATA.raisingSum;
        
		var selected_hr_nodes = $('#hr').treeview('getSelected');
		if ( selected_hr_nodes.length == 0 ){
			console.warn ('Hr not selected');
			alert ('Выберите объекты учета');
			return;
		}
		var hr_ids = selected_hr_nodes.map(x=>x.id);

			// Qt
		var qt = self.DATA.selQt
		if ( !qt ){
			console.warn ('Qt not selected');
			alert ('Выберите параметр');
			return;
		}
		var qt_id = qt.id;

			// Interval
		if ( !self.DATA.ivlSelId ) {
			console.warn ('All ivl not selected');
			alert ('Выберите отчетный период');
			return;
		}
        var ivl = self.DATA.ivlMap[self.DATA.ivlSelId]
		var allIvl = ivl.all_ivl;
		var subIvl = ivl.sub_ivl;
		var finished = self.DATA.onlyFinished;
		var dtmFormat = ivl.fmt;
		
		/*
        	d:{
				start: 'iso-date'
				readouts: ['iso-date', ...]
				series:[
					{hr_id, qt_id, values:[1,2,3]}
				]
        	}
		*/
		var d = await ajax_get ('/read.json?hr=' + 
            hr_ids.join(',') + 
            '&qt=' + qt_id + 
            '&all_ivl=' + allIvl + 
            '&sub_ivl=' + subIvl + 
            '&finished=' + (finished ? '1' : '0') + 
            '&setpt=' + (setpt ? new Date(setpt).toISOString() : '') +
            '&raising_sum=' + (raisingSum ? '1' : '0')
            )

        console.log ( d )

		/*
			dataPack:{
				...
				x_axis: ['a', 'b', ...]
		}
		*/
		dataPack = {
			start: the_time.parseDate ( d.start ),
			//x_axis: d.readouts.map (x => the_time.formatDateTime (the_time.parseDate ( x ), dtm_format) ),
			readouts: d.readouts.map (x => the_time.parseDate ( x ) ),
			dtm_format: dtmFormat,
			qt_title: self.DATA.qtMap[ qt_id ].title,
			series: d.series.map(function(s){
				//s.title = self.DATA.hrMap[ s.hr_id ].title + ' / ' + self.DATA.qtMap[ qt_id ].title;
				s.title = self.DATA.hrMap[ s.hr_id ].title; // у нас одна Qt, нет смысла ее писать в кадой серии
				s.sum = s.values.reduce ((x1, x) => x1 + x, 0);
				return s;
			})
		};		

		/*
		var chart = await ajax_get ('/www/energy_chart.json');
		chart.series = [];

		dataPack.series.forEach (function(s){

			var chartSerie = {
				type: 'column',
				title: s.title, //self.DATA.hrMap[ s.hr_id ].title + ' / ' + self.DATA.qtMap[ qt_id ].title,
				data: s.values
			}
			chart.series.push ( chartSerie );
		})

		$('#chart').jqChart(chart);
		*/
		
		self.drawTable (dataPack, raisingSum);
	}

    /*
        raisingSum [bool]   True включает специальный режим для Усть-луги, когда накопительные значения суммируются, то есть фактически 
                            выводится не потребление на интервале, а показания счетчика.
    */
	self.drawTable = function (dataPack, raisingSum) {
		var f = 'HH:mm d MMM yyyy';
		$('#period_text').text (the_time.formatDateTime(dataPack.start, f) + ' .. ' + the_time.formatDateTime(dataPack.readouts[dataPack.readouts.length - 1], f))
		$('#report_qt_title').text ( dataPack.qt_title )
		// Table head
		var html_head = '<tr><th>Период</th>'
		dataPack.series.forEach(function(s){
			html_head += '<th>' + s.title + '</th>';
		})
		html_head += '</tr>'
		$('#table thead').html ( html_head )

		// Table body
		var html = ''
		for (var i = 0; i < dataPack.readouts.length; i++){
			var d1 = i > 0 ? dataPack.readouts[i-1] : dataPack.start;
			var d2 = dataPack.readouts[i];
            
            if (raisingSum)
                html += '<tr><td>' + the_time.formatDateTime(d2, dataPack.dtm_format) + '</td>';
            else
                html += '<tr><td>' + the_time.formatDateTime(d1, dataPack.dtm_format) + ' .. ' + the_time.formatDateTime(d2, dataPack.dtm_format) + '</td>';
            
			dataPack.series.forEach(function(s){
                v = s.values[i]
				html += '<td>' + (v === null ? 'Н/Д' : Math.floor(v*100)/100) + '</td>';
			})
			html += '</tr>';
		}

		// Table footer
        if (!raisingSum) {
            html += '<tr><th>Итого</th>'
            dataPack.series.forEach(function(s){
                html += '<th>' + s.sum + '</th>';
            })
            html += '</tr>';
        }
        
		$('#table tbody').html ( html )
	}
}

