# -*- coding: utf-8 -*-
#
# parseq help build configuration file

import sys
import os
import codecs
# import shutil
import subprocess

on_rtd = os.environ.get('READTHEDOCS') == 'True'

autodoc_mock_imports = [
    'numpy', 'scipy', 'qt',
    'silx', 'silx.gui', 'silx.io',
    'parseq.gui.gcommons'
    ]

__fdir__ = os.path.dirname(os.path.abspath(__file__))


def read(pathnames):
    with codecs.open(os.path.join(__fdir__, *pathnames), 'r') as fp:
        return fp.read()


def get_version():
    # return '0.9.91'
    inLines = read(('..', 'version.py')).splitlines()
    for line in inLines:
        if line.startswith('__versioninfo__'):
            versioninfo = eval(line[line.find('=')+1:])
            version = '.'.join(map(str, versioninfo))
            return version
    else:
        raise RuntimeError("Unable to find version string.")


def execute_shell_command(cmd, repo_dir):
    """Executes a command in a subprocess, waiting until it has completed.

    :param cmd: Command to execute.
    :param work_dir: Working directory path.
    """
    pipe = subprocess.Popen(cmd, shell=True, cwd=repo_dir,
                            stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    (out, error) = pipe.communicate()
    print(out, error)
    pipe.wait()


def git_clone(repo_url, repo_dir):
    cmd = 'git clone --depth 1 -b master ' + repo_url + ' ' + repo_dir
    execute_shell_command(cmd, repo_dir)


def load_parseq():
    repo_dir = os.path.join(__fdir__, "parseq")
    if os.path.exists(repo_dir):
        return  # already exists from the 1st run (rtfd has several runs)

    os.makedirs(repo_dir)
    sys.path.insert(0, repo_dir)
    repo_url = "https://github.com/kklmn/ParSeq.git"
    git_clone(repo_url, repo_dir)


# import Cloud
# import cloud_sptheme as csp

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, '../..')
sys.path.append(os.path.abspath('exts'))
# autodoc_mock_imports = ["PyQt5.QtWebKitWidgets"]

if on_rtd:
    load_parseq()  # from GH
else:
    import parseq.gui.webWidget as pgww

# -- General configuration ----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
# extensions = ['sphinx.ext.autodoc', 'sphinx.ext.pngmath']
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.mathjax',
              'sphinxcontrib.jquery', 'sphinx_tabs.tabs', 'animation']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = {'.rst': 'restructuredtext'}

wwwParSeq = r"https://parseq.readthedocs.io"
helpParSeq = wwwParSeq if on_rtd else pgww.MAINHELPFILE
helpCorr = f"{wwwParSeq}/corrections.html" if on_rtd else pgww.MAINHELPCORR
helpForm = f"{wwwParSeq}/howto.html#file-tree-views-and-file-formats" \
    if on_rtd else pgww.MAINHELPFORM

rst_prolog = """
.. role:: red
.. role:: bigger
.. role:: underline
.. role:: param

.. |br| raw:: html

      <br>

.. |ParSeq framework| raw:: html

   <a class="reference external" href="{0}">the ParSeq framework</a>

.. |corrections| raw:: html

   <a class="reference external" href="{1}">the general data correction
   capabilities of ParSeq</a>

.. |formats| raw:: html

   <a class="reference external" href="{2}">the general data format definitions
   of ParSeq</a>

""".format(helpParSeq, helpCorr, helpForm)

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'ParSeq-XAS'
copyright = u'2023 Konstantin Klementiev'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = get_version()
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build', 'parseq']

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []


# -- Options for HTML output --------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'mytheme'
# html_theme = "cloud"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    # "rightsidebar": False,
    # "stickysidebar": True,
    # "collapsiblesidebar": True,
    # "max_width": 20,
    # "externalrefs": True,
    # "roottarget": "index"
    "body_min_width": '96%',
    }

toc_object_entries = False

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ['_themes']
# html_theme_path = [csp.get_theme_dir()]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = f"v{release}"

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "_images/parseq-XAS_big.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "_images/parseq-XAS.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'ParSeq-XAS'

html_scaled_image_link = False
