# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class SystemProperty(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'checksums': 'list[str]',
        'default_checksum': 'str',
        'default_license': 'str',
        'file_size_limit': 'str',
        'forbidden_characters': 'list[str]',
        'golden_formats': 'list[str]',
        'search_facets': 'list[str]'
    }

    attribute_map = {
        'links': '_links',
        'checksums': 'checksums',
        'default_checksum': 'defaultChecksum',
        'default_license': 'defaultLicense',
        'file_size_limit': 'fileSizeLimit',
        'forbidden_characters': 'forbiddenCharacters',
        'golden_formats': 'goldenFormats',
        'search_facets': 'searchFacets'
    }

    def __init__(self, links=None, checksums=None, default_checksum=None, default_license=None, file_size_limit=None, forbidden_characters=None, golden_formats=None, search_facets=None, local_vars_configuration=None):  # noqa: E501
        """SystemProperty - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._checksums = None
        self._default_checksum = None
        self._default_license = None
        self._file_size_limit = None
        self._forbidden_characters = None
        self._golden_formats = None
        self._search_facets = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if checksums is not None:
            self.checksums = checksums
        if default_checksum is not None:
            self.default_checksum = default_checksum
        if default_license is not None:
            self.default_license = default_license
        if file_size_limit is not None:
            self.file_size_limit = file_size_limit
        if forbidden_characters is not None:
            self.forbidden_characters = forbidden_characters
        if golden_formats is not None:
            self.golden_formats = golden_formats
        if search_facets is not None:
            self.search_facets = search_facets

    @property
    def links(self):
        """Gets the links of this SystemProperty.  # noqa: E501

        The _links_ list of the _system-properties_ resource  # noqa: E501

        :return: The links of this SystemProperty.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this SystemProperty.

        The _links_ list of the _system-properties_ resource  # noqa: E501

        :param links: The links of this SystemProperty.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def checksums(self):
        """Gets the checksums of this SystemProperty.  # noqa: E501

        The list of checksums used by the system  # noqa: E501

        :return: The checksums of this SystemProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._checksums

    @checksums.setter
    def checksums(self, checksums):
        """Sets the checksums of this SystemProperty.

        The list of checksums used by the system  # noqa: E501

        :param checksums: The checksums of this SystemProperty.  # noqa: E501
        :type: list[str]
        """

        self._checksums = checksums

    @property
    def default_checksum(self):
        """Gets the default_checksum of this SystemProperty.  # noqa: E501

        The default checksum type used by the system  # noqa: E501

        :return: The default_checksum of this SystemProperty.  # noqa: E501
        :rtype: str
        """
        return self._default_checksum

    @default_checksum.setter
    def default_checksum(self, default_checksum):
        """Sets the default_checksum of this SystemProperty.

        The default checksum type used by the system  # noqa: E501

        :param default_checksum: The default_checksum of this SystemProperty.  # noqa: E501
        :type: str
        """

        self._default_checksum = default_checksum

    @property
    def default_license(self):
        """Gets the default_license of this SystemProperty.  # noqa: E501

        The default license used by the system  # noqa: E501

        :return: The default_license of this SystemProperty.  # noqa: E501
        :rtype: str
        """
        return self._default_license

    @default_license.setter
    def default_license(self, default_license):
        """Sets the default_license of this SystemProperty.

        The default license used by the system  # noqa: E501

        :param default_license: The default_license of this SystemProperty.  # noqa: E501
        :type: str
        """

        self._default_license = default_license

    @property
    def file_size_limit(self):
        """Gets the file_size_limit of this SystemProperty.  # noqa: E501

        The maximum file size, in bytes, up to which data and virus verification are done  # noqa: E501

        :return: The file_size_limit of this SystemProperty.  # noqa: E501
        :rtype: str
        """
        return self._file_size_limit

    @file_size_limit.setter
    def file_size_limit(self, file_size_limit):
        """Sets the file_size_limit of this SystemProperty.

        The maximum file size, in bytes, up to which data and virus verification are done  # noqa: E501

        :param file_size_limit: The file_size_limit of this SystemProperty.  # noqa: E501
        :type: str
        """

        self._file_size_limit = file_size_limit

    @property
    def forbidden_characters(self):
        """Gets the forbidden_characters of this SystemProperty.  # noqa: E501

        The list of forbidden characters the system  # noqa: E501

        :return: The forbidden_characters of this SystemProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._forbidden_characters

    @forbidden_characters.setter
    def forbidden_characters(self, forbidden_characters):
        """Sets the forbidden_characters of this SystemProperty.

        The list of forbidden characters the system  # noqa: E501

        :param forbidden_characters: The forbidden_characters of this SystemProperty.  # noqa: E501
        :type: list[str]
        """

        self._forbidden_characters = forbidden_characters

    @property
    def golden_formats(self):
        """Gets the golden_formats of this SystemProperty.  # noqa: E501

        The list of golden formats of the system  # noqa: E501

        :return: The golden_formats of this SystemProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._golden_formats

    @golden_formats.setter
    def golden_formats(self, golden_formats):
        """Sets the golden_formats of this SystemProperty.

        The list of golden formats of the system  # noqa: E501

        :param golden_formats: The golden_formats of this SystemProperty.  # noqa: E501
        :type: list[str]
        """

        self._golden_formats = golden_formats

    @property
    def search_facets(self):
        """Gets the search_facets of this SystemProperty.  # noqa: E501

        Describes facet properties used on archives search page  # noqa: E501

        :return: The search_facets of this SystemProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_facets

    @search_facets.setter
    def search_facets(self, search_facets):
        """Sets the search_facets of this SystemProperty.

        Describes facet properties used on archives search page  # noqa: E501

        :param search_facets: The search_facets of this SystemProperty.  # noqa: E501
        :type: list[str]
        """

        self._search_facets = search_facets

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SystemProperty):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SystemProperty):
            return True

        return self.to_dict() != other.to_dict()
