# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class Sip(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'aip_id': 'str',
        'collection_size': 'float',
        'creation': 'ChangeInfo',
        'data_file_number': 'float',
        'deposit_id': 'str',
        'disposition_approval': 'bool',
        'info': 'AipInfo',
        'last_update': 'ChangeInfo',
        'organizational_unit_id': 'str',
        'ready': 'bool',
        'res_id': 'str',
        'retention': 'float',
        'smart_retention': 'str',
        'submission_policy_id': 'str'
    }

    attribute_map = {
        'links': '_links',
        'aip_id': 'aipId',
        'collection_size': 'collectionSize',
        'creation': 'creation',
        'data_file_number': 'dataFileNumber',
        'deposit_id': 'depositId',
        'disposition_approval': 'dispositionApproval',
        'info': 'info',
        'last_update': 'lastUpdate',
        'organizational_unit_id': 'organizationalUnitId',
        'ready': 'ready',
        'res_id': 'resId',
        'retention': 'retention',
        'smart_retention': 'smartRetention',
        'submission_policy_id': 'submissionPolicyId'
    }

    def __init__(self, links=None, aip_id=None, collection_size=None, creation=None, data_file_number=None, deposit_id=None, disposition_approval=None, info=None, last_update=None, organizational_unit_id=None, ready=None, res_id=None, retention=None, smart_retention=None, submission_policy_id=None, local_vars_configuration=None):  # noqa: E501
        """Sip - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._aip_id = None
        self._collection_size = None
        self._creation = None
        self._data_file_number = None
        self._deposit_id = None
        self._disposition_approval = None
        self._info = None
        self._last_update = None
        self._organizational_unit_id = None
        self._ready = None
        self._res_id = None
        self._retention = None
        self._smart_retention = None
        self._submission_policy_id = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if aip_id is not None:
            self.aip_id = aip_id
        if collection_size is not None:
            self.collection_size = collection_size
        if creation is not None:
            self.creation = creation
        if data_file_number is not None:
            self.data_file_number = data_file_number
        if deposit_id is not None:
            self.deposit_id = deposit_id
        if disposition_approval is not None:
            self.disposition_approval = disposition_approval
        if info is not None:
            self.info = info
        if last_update is not None:
            self.last_update = last_update
        if organizational_unit_id is not None:
            self.organizational_unit_id = organizational_unit_id
        if ready is not None:
            self.ready = ready
        if res_id is not None:
            self.res_id = res_id
        if retention is not None:
            self.retention = retention
        if smart_retention is not None:
            self.smart_retention = smart_retention
        if submission_policy_id is not None:
            self.submission_policy_id = submission_policy_id

    @property
    def links(self):
        """Gets the links of this Sip.  # noqa: E501

        The _links_ list of the _sip_ resource  # noqa: E501

        :return: The links of this Sip.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Sip.

        The _links_ list of the _sip_ resource  # noqa: E501

        :param links: The links of this Sip.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def aip_id(self):
        """Gets the aip_id of this Sip.  # noqa: E501

        The generated AIP DLCM ID of the SIP  # noqa: E501

        :return: The aip_id of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._aip_id

    @aip_id.setter
    def aip_id(self, aip_id):
        """Sets the aip_id of this Sip.

        The generated AIP DLCM ID of the SIP  # noqa: E501

        :param aip_id: The aip_id of this Sip.  # noqa: E501
        :type: str
        """

        self._aip_id = aip_id

    @property
    def collection_size(self):
        """Gets the collection_size of this Sip.  # noqa: E501

        Size of AIP collection  # noqa: E501

        :return: The collection_size of this Sip.  # noqa: E501
        :rtype: float
        """
        return self._collection_size

    @collection_size.setter
    def collection_size(self, collection_size):
        """Sets the collection_size of this Sip.

        Size of AIP collection  # noqa: E501

        :param collection_size: The collection_size of this Sip.  # noqa: E501
        :type: float
        """

        self._collection_size = collection_size

    @property
    def creation(self):
        """Gets the creation of this Sip.  # noqa: E501


        :return: The creation of this Sip.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this Sip.


        :param creation: The creation of this Sip.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def data_file_number(self):
        """Gets the data_file_number of this Sip.  # noqa: E501

        Number of SIP data files  # noqa: E501

        :return: The data_file_number of this Sip.  # noqa: E501
        :rtype: float
        """
        return self._data_file_number

    @data_file_number.setter
    def data_file_number(self, data_file_number):
        """Sets the data_file_number of this Sip.

        Number of SIP data files  # noqa: E501

        :param data_file_number: The data_file_number of this Sip.  # noqa: E501
        :type: float
        """

        self._data_file_number = data_file_number

    @property
    def deposit_id(self):
        """Gets the deposit_id of this Sip.  # noqa: E501

        The source deposit ID of the SIP  # noqa: E501

        :return: The deposit_id of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._deposit_id

    @deposit_id.setter
    def deposit_id(self, deposit_id):
        """Sets the deposit_id of this Sip.

        The source deposit ID of the SIP  # noqa: E501

        :param deposit_id: The deposit_id of this Sip.  # noqa: E501
        :type: str
        """

        self._deposit_id = deposit_id

    @property
    def disposition_approval(self):
        """Gets the disposition_approval of this Sip.  # noqa: E501

        Mandatory step to approve the AIP disposition  # noqa: E501

        :return: The disposition_approval of this Sip.  # noqa: E501
        :rtype: bool
        """
        return self._disposition_approval

    @disposition_approval.setter
    def disposition_approval(self, disposition_approval):
        """Sets the disposition_approval of this Sip.

        Mandatory step to approve the AIP disposition  # noqa: E501

        :param disposition_approval: The disposition_approval of this Sip.  # noqa: E501
        :type: bool
        """

        self._disposition_approval = disposition_approval

    @property
    def info(self):
        """Gets the info of this Sip.  # noqa: E501


        :return: The info of this Sip.  # noqa: E501
        :rtype: AipInfo
        """
        return self._info

    @info.setter
    def info(self, info):
        """Sets the info of this Sip.


        :param info: The info of this Sip.  # noqa: E501
        :type: AipInfo
        """

        self._info = info

    @property
    def last_update(self):
        """Gets the last_update of this Sip.  # noqa: E501


        :return: The last_update of this Sip.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Sip.


        :param last_update: The last_update of this Sip.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def organizational_unit_id(self):
        """Gets the organizational_unit_id of this Sip.  # noqa: E501

        The organizational unit ID of the SIP  # noqa: E501

        :return: The organizational_unit_id of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._organizational_unit_id

    @organizational_unit_id.setter
    def organizational_unit_id(self, organizational_unit_id):
        """Sets the organizational_unit_id of this Sip.

        The organizational unit ID of the SIP  # noqa: E501

        :param organizational_unit_id: The organizational_unit_id of this Sip.  # noqa: E501
        :type: str
        """

        self._organizational_unit_id = organizational_unit_id

    @property
    def ready(self):
        """Gets the ready of this Sip.  # noqa: E501

        If the SIP package is ready  # noqa: E501

        :return: The ready of this Sip.  # noqa: E501
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """Sets the ready of this Sip.

        If the SIP package is ready  # noqa: E501

        :param ready: The ready of this Sip.  # noqa: E501
        :type: bool
        """

        self._ready = ready

    @property
    def res_id(self):
        """Gets the res_id of this Sip.  # noqa: E501

        The _sip_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this Sip.

        The _sip_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this Sip.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def retention(self):
        """Gets the retention of this Sip.  # noqa: E501

        The retention duration in days of the AIP  # noqa: E501

        :return: The retention of this Sip.  # noqa: E501
        :rtype: float
        """
        return self._retention

    @retention.setter
    def retention(self, retention):
        """Sets the retention of this Sip.

        The retention duration in days of the AIP  # noqa: E501

        :param retention: The retention of this Sip.  # noqa: E501
        :type: float
        """

        self._retention = retention

    @property
    def smart_retention(self):
        """Gets the smart_retention of this Sip.  # noqa: E501

        The retention duration in human-readable format of the AIP  # noqa: E501

        :return: The smart_retention of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._smart_retention

    @smart_retention.setter
    def smart_retention(self, smart_retention):
        """Sets the smart_retention of this Sip.

        The retention duration in human-readable format of the AIP  # noqa: E501

        :param smart_retention: The smart_retention of this Sip.  # noqa: E501
        :type: str
        """

        self._smart_retention = smart_retention

    @property
    def submission_policy_id(self):
        """Gets the submission_policy_id of this Sip.  # noqa: E501

        The submission policy ID of the SIP  # noqa: E501

        :return: The submission_policy_id of this Sip.  # noqa: E501
        :rtype: str
        """
        return self._submission_policy_id

    @submission_policy_id.setter
    def submission_policy_id(self, submission_policy_id):
        """Sets the submission_policy_id of this Sip.

        The submission policy ID of the SIP  # noqa: E501

        :param submission_policy_id: The submission_policy_id of this Sip.  # noqa: E501
        :type: str
        """

        self._submission_policy_id = submission_policy_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Sip):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Sip):
            return True

        return self.to_dict() != other.to_dict()
