# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class ScheduledTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'creation': 'ChangeInfo',
        'cron_expression': 'str',
        'enabled': 'bool',
        'last_execution_end': 'datetime',
        'last_execution_start': 'datetime',
        'last_update': 'ChangeInfo',
        'name': 'str',
        'next_execution': 'datetime',
        'res_id': 'str',
        'task_type': 'str'
    }

    attribute_map = {
        'links': '_links',
        'creation': 'creation',
        'cron_expression': 'cronExpression',
        'enabled': 'enabled',
        'last_execution_end': 'lastExecutionEnd',
        'last_execution_start': 'lastExecutionStart',
        'last_update': 'lastUpdate',
        'name': 'name',
        'next_execution': 'nextExecution',
        'res_id': 'resId',
        'task_type': 'taskType'
    }

    def __init__(self, links=None, creation=None, cron_expression=None, enabled=None, last_execution_end=None, last_execution_start=None, last_update=None, name=None, next_execution=None, res_id=None, task_type=None, local_vars_configuration=None):  # noqa: E501
        """ScheduledTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._creation = None
        self._cron_expression = None
        self._enabled = None
        self._last_execution_end = None
        self._last_execution_start = None
        self._last_update = None
        self._name = None
        self._next_execution = None
        self._res_id = None
        self._task_type = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if creation is not None:
            self.creation = creation
        if cron_expression is not None:
            self.cron_expression = cron_expression
        if enabled is not None:
            self.enabled = enabled
        if last_execution_end is not None:
            self.last_execution_end = last_execution_end
        if last_execution_start is not None:
            self.last_execution_start = last_execution_start
        if last_update is not None:
            self.last_update = last_update
        if name is not None:
            self.name = name
        if next_execution is not None:
            self.next_execution = next_execution
        if res_id is not None:
            self.res_id = res_id
        if task_type is not None:
            self.task_type = task_type

    @property
    def links(self):
        """Gets the links of this ScheduledTask.  # noqa: E501

        The _links_ list of the _scheduled-tasks_ resource  # noqa: E501

        :return: The links of this ScheduledTask.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this ScheduledTask.

        The _links_ list of the _scheduled-tasks_ resource  # noqa: E501

        :param links: The links of this ScheduledTask.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def creation(self):
        """Gets the creation of this ScheduledTask.  # noqa: E501


        :return: The creation of this ScheduledTask.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this ScheduledTask.


        :param creation: The creation of this ScheduledTask.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def cron_expression(self):
        """Gets the cron_expression of this ScheduledTask.  # noqa: E501

        The CRON expression of the scheduled task  # noqa: E501

        :return: The cron_expression of this ScheduledTask.  # noqa: E501
        :rtype: str
        """
        return self._cron_expression

    @cron_expression.setter
    def cron_expression(self, cron_expression):
        """Sets the cron_expression of this ScheduledTask.

        The CRON expression of the scheduled task  # noqa: E501

        :param cron_expression: The cron_expression of this ScheduledTask.  # noqa: E501
        :type: str
        """

        self._cron_expression = cron_expression

    @property
    def enabled(self):
        """Gets the enabled of this ScheduledTask.  # noqa: E501

        If the task is enable  # noqa: E501

        :return: The enabled of this ScheduledTask.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ScheduledTask.

        If the task is enable  # noqa: E501

        :param enabled: The enabled of this ScheduledTask.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def last_execution_end(self):
        """Gets the last_execution_end of this ScheduledTask.  # noqa: E501

        The last execution end of the scheduled task  # noqa: E501

        :return: The last_execution_end of this ScheduledTask.  # noqa: E501
        :rtype: datetime
        """
        return self._last_execution_end

    @last_execution_end.setter
    def last_execution_end(self, last_execution_end):
        """Sets the last_execution_end of this ScheduledTask.

        The last execution end of the scheduled task  # noqa: E501

        :param last_execution_end: The last_execution_end of this ScheduledTask.  # noqa: E501
        :type: datetime
        """

        self._last_execution_end = last_execution_end

    @property
    def last_execution_start(self):
        """Gets the last_execution_start of this ScheduledTask.  # noqa: E501

        The last execution start of the scheduled task  # noqa: E501

        :return: The last_execution_start of this ScheduledTask.  # noqa: E501
        :rtype: datetime
        """
        return self._last_execution_start

    @last_execution_start.setter
    def last_execution_start(self, last_execution_start):
        """Sets the last_execution_start of this ScheduledTask.

        The last execution start of the scheduled task  # noqa: E501

        :param last_execution_start: The last_execution_start of this ScheduledTask.  # noqa: E501
        :type: datetime
        """

        self._last_execution_start = last_execution_start

    @property
    def last_update(self):
        """Gets the last_update of this ScheduledTask.  # noqa: E501


        :return: The last_update of this ScheduledTask.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this ScheduledTask.


        :param last_update: The last_update of this ScheduledTask.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def name(self):
        """Gets the name of this ScheduledTask.  # noqa: E501

        The name of the scheduled task  # noqa: E501

        :return: The name of this ScheduledTask.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ScheduledTask.

        The name of the scheduled task  # noqa: E501

        :param name: The name of this ScheduledTask.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def next_execution(self):
        """Gets the next_execution of this ScheduledTask.  # noqa: E501

        The next execution date of the scheduled task  # noqa: E501

        :return: The next_execution of this ScheduledTask.  # noqa: E501
        :rtype: datetime
        """
        return self._next_execution

    @next_execution.setter
    def next_execution(self, next_execution):
        """Sets the next_execution of this ScheduledTask.

        The next execution date of the scheduled task  # noqa: E501

        :param next_execution: The next_execution of this ScheduledTask.  # noqa: E501
        :type: datetime
        """

        self._next_execution = next_execution

    @property
    def res_id(self):
        """Gets the res_id of this ScheduledTask.  # noqa: E501

        The _scheduled-tasks_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this ScheduledTask.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this ScheduledTask.

        The _scheduled-tasks_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this ScheduledTask.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def task_type(self):
        """Gets the task_type of this ScheduledTask.  # noqa: E501

        The type of the scheduled task  # noqa: E501

        :return: The task_type of this ScheduledTask.  # noqa: E501
        :rtype: str
        """
        return self._task_type

    @task_type.setter
    def task_type(self, task_type):
        """Sets the task_type of this ScheduledTask.

        The type of the scheduled task  # noqa: E501

        :param task_type: The task_type of this ScheduledTask.  # noqa: E501
        :type: str
        """
        allowed_values = ["NOTIFY_DEPOSITS_TO_VALIDATE", "NOTIFY_APPROVED_DEPOSITS_CREATOR", "NOTIFY_COMPLETED_DEPOSITS_CREATOR", "NOTIFY_COMPLETED_DEPOSITS_CONTRIBUTORS", "NOTIFY_FORGOTTEN_DEPOSITS_TO_VALIDATE", "NOTIFY_DEPOSITS_IN_ERROR", "NOTIFY_COMPLETED_ARCHIVES_CREATOR", "NOTIFY_COMPLETED_ARCHIVES_APPROVERS", "NOTIFY_ORG_UNIT_CREATION_TO_VALIDATE", "NOTIFY_JOIN_MEMBER_ORG_UNIT_TO_VALIDATE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and task_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `task_type` ({0}), must be one of {1}"  # noqa: E501
                .format(task_type, allowed_values)
            )

        self._task_type = task_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduledTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduledTask):
            return True

        return self.to_dict() != other.to_dict()
