# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class PreservationJob(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'creation': 'ChangeInfo',
        'enable': 'bool',
        'execution_number': 'float',
        'job_recurrence': 'str',
        'job_type': 'str',
        'last_update': 'ChangeInfo',
        'name': 'str',
        'res_id': 'str',
        'scheduling': 'PreservationJobScheduling'
    }

    attribute_map = {
        'links': '_links',
        'creation': 'creation',
        'enable': 'enable',
        'execution_number': 'executionNumber',
        'job_recurrence': 'jobRecurrence',
        'job_type': 'jobType',
        'last_update': 'lastUpdate',
        'name': 'name',
        'res_id': 'resId',
        'scheduling': 'scheduling'
    }

    def __init__(self, links=None, creation=None, enable=None, execution_number=None, job_recurrence=None, job_type=None, last_update=None, name=None, res_id=None, scheduling=None, local_vars_configuration=None):  # noqa: E501
        """PreservationJob - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._creation = None
        self._enable = None
        self._execution_number = None
        self._job_recurrence = None
        self._job_type = None
        self._last_update = None
        self._name = None
        self._res_id = None
        self._scheduling = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if creation is not None:
            self.creation = creation
        if enable is not None:
            self.enable = enable
        if execution_number is not None:
            self.execution_number = execution_number
        if job_recurrence is not None:
            self.job_recurrence = job_recurrence
        if job_type is not None:
            self.job_type = job_type
        if last_update is not None:
            self.last_update = last_update
        if name is not None:
            self.name = name
        if res_id is not None:
            self.res_id = res_id
        if scheduling is not None:
            self.scheduling = scheduling

    @property
    def links(self):
        """Gets the links of this PreservationJob.  # noqa: E501

        The _links_ list of the _preservation-jobs_ resource  # noqa: E501

        :return: The links of this PreservationJob.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this PreservationJob.

        The _links_ list of the _preservation-jobs_ resource  # noqa: E501

        :param links: The links of this PreservationJob.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def creation(self):
        """Gets the creation of this PreservationJob.  # noqa: E501


        :return: The creation of this PreservationJob.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this PreservationJob.


        :param creation: The creation of this PreservationJob.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def enable(self):
        """Gets the enable of this PreservationJob.  # noqa: E501

        If the job is enable  # noqa: E501

        :return: The enable of this PreservationJob.  # noqa: E501
        :rtype: bool
        """
        return self._enable

    @enable.setter
    def enable(self, enable):
        """Sets the enable of this PreservationJob.

        If the job is enable  # noqa: E501

        :param enable: The enable of this PreservationJob.  # noqa: E501
        :type: bool
        """

        self._enable = enable

    @property
    def execution_number(self):
        """Gets the execution_number of this PreservationJob.  # noqa: E501

        Number of job executions  # noqa: E501

        :return: The execution_number of this PreservationJob.  # noqa: E501
        :rtype: float
        """
        return self._execution_number

    @execution_number.setter
    def execution_number(self, execution_number):
        """Sets the execution_number of this PreservationJob.

        Number of job executions  # noqa: E501

        :param execution_number: The execution_number of this PreservationJob.  # noqa: E501
        :type: float
        """

        self._execution_number = execution_number

    @property
    def job_recurrence(self):
        """Gets the job_recurrence of this PreservationJob.  # noqa: E501

        Job recurrence  # noqa: E501

        :return: The job_recurrence of this PreservationJob.  # noqa: E501
        :rtype: str
        """
        return self._job_recurrence

    @job_recurrence.setter
    def job_recurrence(self, job_recurrence):
        """Sets the job_recurrence of this PreservationJob.

        Job recurrence  # noqa: E501

        :param job_recurrence: The job_recurrence of this PreservationJob.  # noqa: E501
        :type: str
        """
        allowed_values = ["DAILY", "MONTHLY", "ONCE", "WEEKLY", "YEARLY"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and job_recurrence not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `job_recurrence` ({0}), must be one of {1}"  # noqa: E501
                .format(job_recurrence, allowed_values)
            )

        self._job_recurrence = job_recurrence

    @property
    def job_type(self):
        """Gets the job_type of this PreservationJob.  # noqa: E501

        The job type of the preservation job  # noqa: E501

        :return: The job_type of this PreservationJob.  # noqa: E501
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """Sets the job_type of this PreservationJob.

        The job type of the preservation job  # noqa: E501

        :param job_type: The job_type of this PreservationJob.  # noqa: E501
        :type: str
        """
        allowed_values = ["ARCHIVE_CHECK", "CLEAN_SUBMISSION", "DISPOSAL", "FIXITY", "MIGRATION", "ARCHIVE_PRELOAD_SMALL", "ARCHIVE_PRELOAD_BIG", "PURGE_SUBMISSION_TEMP_FILES", "PURGE_ORDER", "REBUILD_REGISTRY", "REINDEX", "RELOAD", "REPLICATION", "REPLICATION_CHECK", "CHECK_COMPLIANCE_LEVEL"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and job_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `job_type` ({0}), must be one of {1}"  # noqa: E501
                .format(job_type, allowed_values)
            )

        self._job_type = job_type

    @property
    def last_update(self):
        """Gets the last_update of this PreservationJob.  # noqa: E501


        :return: The last_update of this PreservationJob.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this PreservationJob.


        :param last_update: The last_update of this PreservationJob.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def name(self):
        """Gets the name of this PreservationJob.  # noqa: E501

        The name of the preservation job  # noqa: E501

        :return: The name of this PreservationJob.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PreservationJob.

        The name of the preservation job  # noqa: E501

        :param name: The name of this PreservationJob.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def res_id(self):
        """Gets the res_id of this PreservationJob.  # noqa: E501

        The _preservation-jobs_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this PreservationJob.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this PreservationJob.

        The _preservation-jobs_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this PreservationJob.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def scheduling(self):
        """Gets the scheduling of this PreservationJob.  # noqa: E501


        :return: The scheduling of this PreservationJob.  # noqa: E501
        :rtype: PreservationJobScheduling
        """
        return self._scheduling

    @scheduling.setter
    def scheduling(self, scheduling):
        """Sets the scheduling of this PreservationJob.


        :param scheduling: The scheduling of this PreservationJob.  # noqa: E501
        :type: PreservationJobScheduling
        """

        self._scheduling = scheduling

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PreservationJob):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PreservationJob):
            return True

        return self.to_dict() != other.to_dict()
