# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'aip_number': 'float',
        'creation': 'ChangeInfo',
        'dip_number': 'float',
        'last_update': 'ChangeInfo',
        'metadata_version': 'str',
        'name': 'str',
        'public_order': 'bool',
        'query': 'str',
        'query_type': 'str',
        'res_id': 'str',
        'status': 'str',
        'status_message': 'str'
    }

    attribute_map = {
        'links': '_links',
        'aip_number': 'aipNumber',
        'creation': 'creation',
        'dip_number': 'dipNumber',
        'last_update': 'lastUpdate',
        'metadata_version': 'metadataVersion',
        'name': 'name',
        'public_order': 'publicOrder',
        'query': 'query',
        'query_type': 'queryType',
        'res_id': 'resId',
        'status': 'status',
        'status_message': 'statusMessage'
    }

    def __init__(self, links=None, aip_number=None, creation=None, dip_number=None, last_update=None, metadata_version=None, name=None, public_order=None, query=None, query_type=None, res_id=None, status=None, status_message=None, local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._aip_number = None
        self._creation = None
        self._dip_number = None
        self._last_update = None
        self._metadata_version = None
        self._name = None
        self._public_order = None
        self._query = None
        self._query_type = None
        self._res_id = None
        self._status = None
        self._status_message = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if aip_number is not None:
            self.aip_number = aip_number
        if creation is not None:
            self.creation = creation
        if dip_number is not None:
            self.dip_number = dip_number
        if last_update is not None:
            self.last_update = last_update
        if metadata_version is not None:
            self.metadata_version = metadata_version
        if name is not None:
            self.name = name
        if public_order is not None:
            self.public_order = public_order
        if query is not None:
            self.query = query
        if query_type is not None:
            self.query_type = query_type
        if res_id is not None:
            self.res_id = res_id
        if status is not None:
            self.status = status
        if status_message is not None:
            self.status_message = status_message

    @property
    def links(self):
        """Gets the links of this Order.  # noqa: E501

        The _links_ list of the _orders_ resource  # noqa: E501

        :return: The links of this Order.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Order.

        The _links_ list of the _orders_ resource  # noqa: E501

        :param links: The links of this Order.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def aip_number(self):
        """Gets the aip_number of this Order.  # noqa: E501

        The AIP number of the order query  # noqa: E501

        :return: The aip_number of this Order.  # noqa: E501
        :rtype: float
        """
        return self._aip_number

    @aip_number.setter
    def aip_number(self, aip_number):
        """Sets the aip_number of this Order.

        The AIP number of the order query  # noqa: E501

        :param aip_number: The aip_number of this Order.  # noqa: E501
        :type: float
        """

        self._aip_number = aip_number

    @property
    def creation(self):
        """Gets the creation of this Order.  # noqa: E501


        :return: The creation of this Order.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this Order.


        :param creation: The creation of this Order.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def dip_number(self):
        """Gets the dip_number of this Order.  # noqa: E501

        The DIP number of the order query  # noqa: E501

        :return: The dip_number of this Order.  # noqa: E501
        :rtype: float
        """
        return self._dip_number

    @dip_number.setter
    def dip_number(self, dip_number):
        """Sets the dip_number of this Order.

        The DIP number of the order query  # noqa: E501

        :param dip_number: The dip_number of this Order.  # noqa: E501
        :type: float
        """

        self._dip_number = dip_number

    @property
    def last_update(self):
        """Gets the last_update of this Order.  # noqa: E501


        :return: The last_update of this Order.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Order.


        :param last_update: The last_update of this Order.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def metadata_version(self):
        """Gets the metadata_version of this Order.  # noqa: E501

        The metadata version of the deposit  # noqa: E501

        :return: The metadata_version of this Order.  # noqa: E501
        :rtype: str
        """
        return self._metadata_version

    @metadata_version.setter
    def metadata_version(self, metadata_version):
        """Sets the metadata_version of this Order.

        The metadata version of the deposit  # noqa: E501

        :param metadata_version: The metadata_version of this Order.  # noqa: E501
        :type: str
        """
        allowed_values = ["1.0", "1.1", "2.0", "2.1", "3.0"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and metadata_version not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `metadata_version` ({0}), must be one of {1}"  # noqa: E501
                .format(metadata_version, allowed_values)
            )

        self._metadata_version = metadata_version

    @property
    def name(self):
        """Gets the name of this Order.  # noqa: E501

        The name of the order query  # noqa: E501

        :return: The name of this Order.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Order.

        The name of the order query  # noqa: E501

        :param name: The name of this Order.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def public_order(self):
        """Gets the public_order of this Order.  # noqa: E501

        True if the order is public, false otherwise  # noqa: E501

        :return: The public_order of this Order.  # noqa: E501
        :rtype: bool
        """
        return self._public_order

    @public_order.setter
    def public_order(self, public_order):
        """Sets the public_order of this Order.

        True if the order is public, false otherwise  # noqa: E501

        :param public_order: The public_order of this Order.  # noqa: E501
        :type: bool
        """

        self._public_order = public_order

    @property
    def query(self):
        """Gets the query of this Order.  # noqa: E501

        The query of the order query  # noqa: E501

        :return: The query of this Order.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this Order.

        The query of the order query  # noqa: E501

        :param query: The query of this Order.  # noqa: E501
        :type: str
        """

        self._query = query

    @property
    def query_type(self):
        """Gets the query_type of this Order.  # noqa: E501

        The type of the order query  # noqa: E501

        :return: The query_type of this Order.  # noqa: E501
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type):
        """Sets the query_type of this Order.

        The type of the order query  # noqa: E501

        :param query_type: The query_type of this Order.  # noqa: E501
        :type: str
        """
        allowed_values = ["ADVANCED", "DIRECT", "SIMPLE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and query_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `query_type` ({0}), must be one of {1}"  # noqa: E501
                .format(query_type, allowed_values)
            )

        self._query_type = query_type

    @property
    def res_id(self):
        """Gets the res_id of this Order.  # noqa: E501

        The _orders_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this Order.

        The _orders_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this Order.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def status(self):
        """Gets the status of this Order.  # noqa: E501

        The status of the order query  # noqa: E501

        :return: The status of this Order.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Order.

        The status of the order query  # noqa: E501

        :param status: The status of this Order.  # noqa: E501
        :type: str
        """
        allowed_values = ["DOWNLOADING", "IN_DISSEMINATION_PREPARATION", "IN_ERROR", "IN_PREPARATION", "IN_PROGRESS", "READY", "SUBMITTED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this Order.  # noqa: E501

        The message related to the status  # noqa: E501

        :return: The status_message of this Order.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this Order.

        The message related to the status  # noqa: E501

        :param status_message: The status_message of this Order.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
