# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class Notification(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'creation': 'ChangeInfo',
        'emitter': 'object',
        'last_update': 'ChangeInfo',
        'message': 'str',
        'notification_status': 'str',
        'notification_type': 'NotificationNotificationType',
        'notified_org_unit': 'NotificationNotifiedOrgUnit',
        'object_id': 'str',
        'recipient': 'NotificationRecipient',
        'res_id': 'str',
        'status_message': 'str'
    }

    attribute_map = {
        'links': '_links',
        'creation': 'creation',
        'emitter': 'emitter',
        'last_update': 'lastUpdate',
        'message': 'message',
        'notification_status': 'notificationStatus',
        'notification_type': 'notificationType',
        'notified_org_unit': 'notifiedOrgUnit',
        'object_id': 'objectId',
        'recipient': 'recipient',
        'res_id': 'resId',
        'status_message': 'statusMessage'
    }

    def __init__(self, links=None, creation=None, emitter=None, last_update=None, message=None, notification_status=None, notification_type=None, notified_org_unit=None, object_id=None, recipient=None, res_id=None, status_message=None, local_vars_configuration=None):  # noqa: E501
        """Notification - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._creation = None
        self._emitter = None
        self._last_update = None
        self._message = None
        self._notification_status = None
        self._notification_type = None
        self._notified_org_unit = None
        self._object_id = None
        self._recipient = None
        self._res_id = None
        self._status_message = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if creation is not None:
            self.creation = creation
        if emitter is not None:
            self.emitter = emitter
        if last_update is not None:
            self.last_update = last_update
        if message is not None:
            self.message = message
        if notification_status is not None:
            self.notification_status = notification_status
        if notification_type is not None:
            self.notification_type = notification_type
        if notified_org_unit is not None:
            self.notified_org_unit = notified_org_unit
        if object_id is not None:
            self.object_id = object_id
        if recipient is not None:
            self.recipient = recipient
        if res_id is not None:
            self.res_id = res_id
        if status_message is not None:
            self.status_message = status_message

    @property
    def links(self):
        """Gets the links of this Notification.  # noqa: E501

        The _links_ list of the _notifications_ resource  # noqa: E501

        :return: The links of this Notification.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Notification.

        The _links_ list of the _notifications_ resource  # noqa: E501

        :param links: The links of this Notification.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def creation(self):
        """Gets the creation of this Notification.  # noqa: E501


        :return: The creation of this Notification.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this Notification.


        :param creation: The creation of this Notification.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def emitter(self):
        """Gets the emitter of this Notification.  # noqa: E501

        The emitter of the notification (User)  # noqa: E501

        :return: The emitter of this Notification.  # noqa: E501
        :rtype: object
        """
        return self._emitter

    @emitter.setter
    def emitter(self, emitter):
        """Sets the emitter of this Notification.

        The emitter of the notification (User)  # noqa: E501

        :param emitter: The emitter of this Notification.  # noqa: E501
        :type: object
        """

        self._emitter = emitter

    @property
    def last_update(self):
        """Gets the last_update of this Notification.  # noqa: E501


        :return: The last_update of this Notification.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Notification.


        :param last_update: The last_update of this Notification.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def message(self):
        """Gets the message of this Notification.  # noqa: E501

        The message sent by the notification  # noqa: E501

        :return: The message of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Notification.

        The message sent by the notification  # noqa: E501

        :param message: The message of this Notification.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def notification_status(self):
        """Gets the notification_status of this Notification.  # noqa: E501

        The status of the notification  # noqa: E501

        :return: The notification_status of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._notification_status

    @notification_status.setter
    def notification_status(self, notification_status):
        """Sets the notification_status of this Notification.

        The status of the notification  # noqa: E501

        :param notification_status: The notification_status of this Notification.  # noqa: E501
        :type: str
        """
        allowed_values = ["PROCESSED", "PENDING", "REFUSED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and notification_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `notification_status` ({0}), must be one of {1}"  # noqa: E501
                .format(notification_status, allowed_values)
            )

        self._notification_status = notification_status

    @property
    def notification_type(self):
        """Gets the notification_type of this Notification.  # noqa: E501


        :return: The notification_type of this Notification.  # noqa: E501
        :rtype: NotificationNotificationType
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type):
        """Sets the notification_type of this Notification.


        :param notification_type: The notification_type of this Notification.  # noqa: E501
        :type: NotificationNotificationType
        """

        self._notification_type = notification_type

    @property
    def notified_org_unit(self):
        """Gets the notified_org_unit of this Notification.  # noqa: E501


        :return: The notified_org_unit of this Notification.  # noqa: E501
        :rtype: NotificationNotifiedOrgUnit
        """
        return self._notified_org_unit

    @notified_org_unit.setter
    def notified_org_unit(self, notified_org_unit):
        """Sets the notified_org_unit of this Notification.


        :param notified_org_unit: The notified_org_unit of this Notification.  # noqa: E501
        :type: NotificationNotifiedOrgUnit
        """

        self._notified_org_unit = notified_org_unit

    @property
    def object_id(self):
        """Gets the object_id of this Notification.  # noqa: E501

        The target object ID of the notification  # noqa: E501

        :return: The object_id of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._object_id

    @object_id.setter
    def object_id(self, object_id):
        """Sets the object_id of this Notification.

        The target object ID of the notification  # noqa: E501

        :param object_id: The object_id of this Notification.  # noqa: E501
        :type: str
        """

        self._object_id = object_id

    @property
    def recipient(self):
        """Gets the recipient of this Notification.  # noqa: E501


        :return: The recipient of this Notification.  # noqa: E501
        :rtype: NotificationRecipient
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this Notification.


        :param recipient: The recipient of this Notification.  # noqa: E501
        :type: NotificationRecipient
        """

        self._recipient = recipient

    @property
    def res_id(self):
        """Gets the res_id of this Notification.  # noqa: E501

        The _notifications_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this Notification.

        The _notifications_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this Notification.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def status_message(self):
        """Gets the status_message of this Notification.  # noqa: E501

        The message related to the status  # noqa: E501

        :return: The status_message of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this Notification.

        The message related to the status  # noqa: E501

        :param status_message: The status_message of this Notification.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Notification):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Notification):
            return True

        return self.to_dict() != other.to_dict()
