# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class Deposit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'access': 'str',
        'additional_fields_form_id': 'str',
        'additional_fields_values': 'str',
        'agreement': 'bool',
        'archive_type_id': 'str',
        'collection_begin': 'datetime',
        'collection_end': 'datetime',
        'collection_size': 'float',
        'contains_updated_metadata': 'bool',
        'creation': 'ChangeInfo',
        'data_file_number': 'float',
        'data_sensitivity': 'str',
        'description': 'str',
        'doi': 'str',
        'embargo': 'AipInfoEmbargo',
        'has_embargo': 'bool',
        'is_identical_to': 'str',
        'is_obsoleted_by': 'str',
        'is_referenced_by': 'str',
        'keywords': 'list[str]',
        'language_id': 'str',
        'last_update': 'ChangeInfo',
        'license_id': 'str',
        'metadata_version': 'str',
        'organizational_unit_id': 'str',
        'preparation_id': 'str',
        'preservation_policy_id': 'str',
        'publication_date': 'date',
        'res_id': 'str',
        'sip_id': 'str',
        'status': 'str',
        'status_message': 'str',
        'submission_agreement_id': 'str',
        'submission_policy_id': 'str',
        'title': 'str'
    }

    attribute_map = {
        'links': '_links',
        'access': 'access',
        'additional_fields_form_id': 'additionalFieldsFormId',
        'additional_fields_values': 'additionalFieldsValues',
        'agreement': 'agreement',
        'archive_type_id': 'archiveTypeId',
        'collection_begin': 'collectionBegin',
        'collection_end': 'collectionEnd',
        'collection_size': 'collectionSize',
        'contains_updated_metadata': 'containsUpdatedMetadata',
        'creation': 'creation',
        'data_file_number': 'dataFileNumber',
        'data_sensitivity': 'dataSensitivity',
        'description': 'description',
        'doi': 'doi',
        'embargo': 'embargo',
        'has_embargo': 'hasEmbargo',
        'is_identical_to': 'isIdenticalTo',
        'is_obsoleted_by': 'isObsoletedBy',
        'is_referenced_by': 'isReferencedBy',
        'keywords': 'keywords',
        'language_id': 'languageId',
        'last_update': 'lastUpdate',
        'license_id': 'licenseId',
        'metadata_version': 'metadataVersion',
        'organizational_unit_id': 'organizationalUnitId',
        'preparation_id': 'preparationId',
        'preservation_policy_id': 'preservationPolicyId',
        'publication_date': 'publicationDate',
        'res_id': 'resId',
        'sip_id': 'sipId',
        'status': 'status',
        'status_message': 'statusMessage',
        'submission_agreement_id': 'submissionAgreementId',
        'submission_policy_id': 'submissionPolicyId',
        'title': 'title'
    }

    def __init__(self, links=None, access=None, additional_fields_form_id=None, additional_fields_values=None, agreement=None, archive_type_id=None, collection_begin=None, collection_end=None, collection_size=None, contains_updated_metadata=None, creation=None, data_file_number=None, data_sensitivity=None, description=None, doi=None, embargo=None, has_embargo=None, is_identical_to=None, is_obsoleted_by=None, is_referenced_by=None, keywords=None, language_id=None, last_update=None, license_id=None, metadata_version=None, organizational_unit_id=None, preparation_id=None, preservation_policy_id=None, publication_date=None, res_id=None, sip_id=None, status=None, status_message=None, submission_agreement_id=None, submission_policy_id=None, title=None, local_vars_configuration=None):  # noqa: E501
        """Deposit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._access = None
        self._additional_fields_form_id = None
        self._additional_fields_values = None
        self._agreement = None
        self._archive_type_id = None
        self._collection_begin = None
        self._collection_end = None
        self._collection_size = None
        self._contains_updated_metadata = None
        self._creation = None
        self._data_file_number = None
        self._data_sensitivity = None
        self._description = None
        self._doi = None
        self._embargo = None
        self._has_embargo = None
        self._is_identical_to = None
        self._is_obsoleted_by = None
        self._is_referenced_by = None
        self._keywords = None
        self._language_id = None
        self._last_update = None
        self._license_id = None
        self._metadata_version = None
        self._organizational_unit_id = None
        self._preparation_id = None
        self._preservation_policy_id = None
        self._publication_date = None
        self._res_id = None
        self._sip_id = None
        self._status = None
        self._status_message = None
        self._submission_agreement_id = None
        self._submission_policy_id = None
        self._title = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if access is not None:
            self.access = access
        if additional_fields_form_id is not None:
            self.additional_fields_form_id = additional_fields_form_id
        if additional_fields_values is not None:
            self.additional_fields_values = additional_fields_values
        if agreement is not None:
            self.agreement = agreement
        if archive_type_id is not None:
            self.archive_type_id = archive_type_id
        if collection_begin is not None:
            self.collection_begin = collection_begin
        if collection_end is not None:
            self.collection_end = collection_end
        if collection_size is not None:
            self.collection_size = collection_size
        if contains_updated_metadata is not None:
            self.contains_updated_metadata = contains_updated_metadata
        if creation is not None:
            self.creation = creation
        if data_file_number is not None:
            self.data_file_number = data_file_number
        if data_sensitivity is not None:
            self.data_sensitivity = data_sensitivity
        if description is not None:
            self.description = description
        if doi is not None:
            self.doi = doi
        if embargo is not None:
            self.embargo = embargo
        if has_embargo is not None:
            self.has_embargo = has_embargo
        if is_identical_to is not None:
            self.is_identical_to = is_identical_to
        if is_obsoleted_by is not None:
            self.is_obsoleted_by = is_obsoleted_by
        if is_referenced_by is not None:
            self.is_referenced_by = is_referenced_by
        if keywords is not None:
            self.keywords = keywords
        if language_id is not None:
            self.language_id = language_id
        if last_update is not None:
            self.last_update = last_update
        if license_id is not None:
            self.license_id = license_id
        if metadata_version is not None:
            self.metadata_version = metadata_version
        if organizational_unit_id is not None:
            self.organizational_unit_id = organizational_unit_id
        if preparation_id is not None:
            self.preparation_id = preparation_id
        if preservation_policy_id is not None:
            self.preservation_policy_id = preservation_policy_id
        if publication_date is not None:
            self.publication_date = publication_date
        if res_id is not None:
            self.res_id = res_id
        if sip_id is not None:
            self.sip_id = sip_id
        if status is not None:
            self.status = status
        if status_message is not None:
            self.status_message = status_message
        if submission_agreement_id is not None:
            self.submission_agreement_id = submission_agreement_id
        if submission_policy_id is not None:
            self.submission_policy_id = submission_policy_id
        if title is not None:
            self.title = title

    @property
    def links(self):
        """Gets the links of this Deposit.  # noqa: E501

        The _links_ list of the _deposits_ resource  # noqa: E501

        :return: The links of this Deposit.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Deposit.

        The _links_ list of the _deposits_ resource  # noqa: E501

        :param links: The links of this Deposit.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def access(self):
        """Gets the access of this Deposit.  # noqa: E501

        The access level of the deposit  # noqa: E501

        :return: The access of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._access

    @access.setter
    def access(self, access):
        """Sets the access of this Deposit.

        The access level of the deposit  # noqa: E501

        :param access: The access of this Deposit.  # noqa: E501
        :type: str
        """
        allowed_values = ["PUBLIC", "RESTRICTED", "CLOSED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and access not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `access` ({0}), must be one of {1}"  # noqa: E501
                .format(access, allowed_values)
            )

        self._access = access

    @property
    def additional_fields_form_id(self):
        """Gets the additional_fields_form_id of this Deposit.  # noqa: E501

        The additional fields form ID used to generate the additional fields values  # noqa: E501

        :return: The additional_fields_form_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._additional_fields_form_id

    @additional_fields_form_id.setter
    def additional_fields_form_id(self, additional_fields_form_id):
        """Sets the additional_fields_form_id of this Deposit.

        The additional fields form ID used to generate the additional fields values  # noqa: E501

        :param additional_fields_form_id: The additional_fields_form_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._additional_fields_form_id = additional_fields_form_id

    @property
    def additional_fields_values(self):
        """Gets the additional_fields_values of this Deposit.  # noqa: E501

        Some eventual additional fields values generated through an additional fields form  # noqa: E501

        :return: The additional_fields_values of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._additional_fields_values

    @additional_fields_values.setter
    def additional_fields_values(self, additional_fields_values):
        """Sets the additional_fields_values of this Deposit.

        Some eventual additional fields values generated through an additional fields form  # noqa: E501

        :param additional_fields_values: The additional_fields_values of this Deposit.  # noqa: E501
        :type: str
        """

        self._additional_fields_values = additional_fields_values

    @property
    def agreement(self):
        """Gets the agreement of this Deposit.  # noqa: E501

        The submission agreement of the deposit  # noqa: E501

        :return: The agreement of this Deposit.  # noqa: E501
        :rtype: bool
        """
        return self._agreement

    @agreement.setter
    def agreement(self, agreement):
        """Sets the agreement of this Deposit.

        The submission agreement of the deposit  # noqa: E501

        :param agreement: The agreement of this Deposit.  # noqa: E501
        :type: bool
        """

        self._agreement = agreement

    @property
    def archive_type_id(self):
        """Gets the archive_type_id of this Deposit.  # noqa: E501

        The archive type ID of the deposit  # noqa: E501

        :return: The archive_type_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._archive_type_id

    @archive_type_id.setter
    def archive_type_id(self, archive_type_id):
        """Sets the archive_type_id of this Deposit.

        The archive type ID of the deposit  # noqa: E501

        :param archive_type_id: The archive_type_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._archive_type_id = archive_type_id

    @property
    def collection_begin(self):
        """Gets the collection_begin of this Deposit.  # noqa: E501

        The beginning of the deposit collection  # noqa: E501

        :return: The collection_begin of this Deposit.  # noqa: E501
        :rtype: datetime
        """
        return self._collection_begin

    @collection_begin.setter
    def collection_begin(self, collection_begin):
        """Sets the collection_begin of this Deposit.

        The beginning of the deposit collection  # noqa: E501

        :param collection_begin: The collection_begin of this Deposit.  # noqa: E501
        :type: datetime
        """

        self._collection_begin = collection_begin

    @property
    def collection_end(self):
        """Gets the collection_end of this Deposit.  # noqa: E501

        The end of the deposit collection  # noqa: E501

        :return: The collection_end of this Deposit.  # noqa: E501
        :rtype: datetime
        """
        return self._collection_end

    @collection_end.setter
    def collection_end(self, collection_end):
        """Sets the collection_end of this Deposit.

        The end of the deposit collection  # noqa: E501

        :param collection_end: The collection_end of this Deposit.  # noqa: E501
        :type: datetime
        """

        self._collection_end = collection_end

    @property
    def collection_size(self):
        """Gets the collection_size of this Deposit.  # noqa: E501

        Size of AIP collection  # noqa: E501

        :return: The collection_size of this Deposit.  # noqa: E501
        :rtype: float
        """
        return self._collection_size

    @collection_size.setter
    def collection_size(self, collection_size):
        """Sets the collection_size of this Deposit.

        Size of AIP collection  # noqa: E501

        :param collection_size: The collection_size of this Deposit.  # noqa: E501
        :type: float
        """

        self._collection_size = collection_size

    @property
    def contains_updated_metadata(self):
        """Gets the contains_updated_metadata of this Deposit.  # noqa: E501

        If the deposit contains updated metadata  # noqa: E501

        :return: The contains_updated_metadata of this Deposit.  # noqa: E501
        :rtype: bool
        """
        return self._contains_updated_metadata

    @contains_updated_metadata.setter
    def contains_updated_metadata(self, contains_updated_metadata):
        """Sets the contains_updated_metadata of this Deposit.

        If the deposit contains updated metadata  # noqa: E501

        :param contains_updated_metadata: The contains_updated_metadata of this Deposit.  # noqa: E501
        :type: bool
        """

        self._contains_updated_metadata = contains_updated_metadata

    @property
    def creation(self):
        """Gets the creation of this Deposit.  # noqa: E501


        :return: The creation of this Deposit.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this Deposit.


        :param creation: The creation of this Deposit.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def data_file_number(self):
        """Gets the data_file_number of this Deposit.  # noqa: E501

        Number of deposit data files  # noqa: E501

        :return: The data_file_number of this Deposit.  # noqa: E501
        :rtype: float
        """
        return self._data_file_number

    @data_file_number.setter
    def data_file_number(self, data_file_number):
        """Sets the data_file_number of this Deposit.

        Number of deposit data files  # noqa: E501

        :param data_file_number: The data_file_number of this Deposit.  # noqa: E501
        :type: float
        """

        self._data_file_number = data_file_number

    @property
    def data_sensitivity(self):
        """Gets the data_sensitivity of this Deposit.  # noqa: E501

        The data sensitivity of the deposit  # noqa: E501

        :return: The data_sensitivity of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._data_sensitivity

    @data_sensitivity.setter
    def data_sensitivity(self, data_sensitivity):
        """Sets the data_sensitivity of this Deposit.

        The data sensitivity of the deposit  # noqa: E501

        :param data_sensitivity: The data_sensitivity of this Deposit.  # noqa: E501
        :type: str
        """
        allowed_values = ["UNDEFINED", "BLUE", "GREEN", "YELLOW", "ORANGE", "RED", "CRIMSON"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and data_sensitivity not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `data_sensitivity` ({0}), must be one of {1}"  # noqa: E501
                .format(data_sensitivity, allowed_values)
            )

        self._data_sensitivity = data_sensitivity

    @property
    def description(self):
        """Gets the description of this Deposit.  # noqa: E501

        The description of the deposit  # noqa: E501

        :return: The description of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Deposit.

        The description of the deposit  # noqa: E501

        :param description: The description of this Deposit.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def doi(self):
        """Gets the doi of this Deposit.  # noqa: E501

        The Digital Object Identifier (DOI) of the deposit  # noqa: E501

        :return: The doi of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._doi

    @doi.setter
    def doi(self, doi):
        """Sets the doi of this Deposit.

        The Digital Object Identifier (DOI) of the deposit  # noqa: E501

        :param doi: The doi of this Deposit.  # noqa: E501
        :type: str
        """

        self._doi = doi

    @property
    def embargo(self):
        """Gets the embargo of this Deposit.  # noqa: E501


        :return: The embargo of this Deposit.  # noqa: E501
        :rtype: AipInfoEmbargo
        """
        return self._embargo

    @embargo.setter
    def embargo(self, embargo):
        """Sets the embargo of this Deposit.


        :param embargo: The embargo of this Deposit.  # noqa: E501
        :type: AipInfoEmbargo
        """

        self._embargo = embargo

    @property
    def has_embargo(self):
        """Gets the has_embargo of this Deposit.  # noqa: E501

        If the deposit has an embargo  # noqa: E501

        :return: The has_embargo of this Deposit.  # noqa: E501
        :rtype: bool
        """
        return self._has_embargo

    @has_embargo.setter
    def has_embargo(self, has_embargo):
        """Sets the has_embargo of this Deposit.

        If the deposit has an embargo  # noqa: E501

        :param has_embargo: The has_embargo of this Deposit.  # noqa: E501
        :type: bool
        """

        self._has_embargo = has_embargo

    @property
    def is_identical_to(self):
        """Gets the is_identical_to of this Deposit.  # noqa: E501

        Indicates that Archive A is identical to B, used to register two separate instances of the same resource  # noqa: E501

        :return: The is_identical_to of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._is_identical_to

    @is_identical_to.setter
    def is_identical_to(self, is_identical_to):
        """Sets the is_identical_to of this Deposit.

        Indicates that Archive A is identical to B, used to register two separate instances of the same resource  # noqa: E501

        :param is_identical_to: The is_identical_to of this Deposit.  # noqa: E501
        :type: str
        """

        self._is_identical_to = is_identical_to

    @property
    def is_obsoleted_by(self):
        """Gets the is_obsoleted_by of this Deposit.  # noqa: E501

        Indicates A is replaced by B  # noqa: E501

        :return: The is_obsoleted_by of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._is_obsoleted_by

    @is_obsoleted_by.setter
    def is_obsoleted_by(self, is_obsoleted_by):
        """Sets the is_obsoleted_by of this Deposit.

        Indicates A is replaced by B  # noqa: E501

        :param is_obsoleted_by: The is_obsoleted_by of this Deposit.  # noqa: E501
        :type: str
        """

        self._is_obsoleted_by = is_obsoleted_by

    @property
    def is_referenced_by(self):
        """Gets the is_referenced_by of this Deposit.  # noqa: E501

        Indicates A is used as a source of information by B  # noqa: E501

        :return: The is_referenced_by of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._is_referenced_by

    @is_referenced_by.setter
    def is_referenced_by(self, is_referenced_by):
        """Sets the is_referenced_by of this Deposit.

        Indicates A is used as a source of information by B  # noqa: E501

        :param is_referenced_by: The is_referenced_by of this Deposit.  # noqa: E501
        :type: str
        """

        self._is_referenced_by = is_referenced_by

    @property
    def keywords(self):
        """Gets the keywords of this Deposit.  # noqa: E501

        List of deposit keywords  # noqa: E501

        :return: The keywords of this Deposit.  # noqa: E501
        :rtype: list[str]
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """Sets the keywords of this Deposit.

        List of deposit keywords  # noqa: E501

        :param keywords: The keywords of this Deposit.  # noqa: E501
        :type: list[str]
        """

        self._keywords = keywords

    @property
    def language_id(self):
        """Gets the language_id of this Deposit.  # noqa: E501

        The language ID of the deposit  # noqa: E501

        :return: The language_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._language_id

    @language_id.setter
    def language_id(self, language_id):
        """Sets the language_id of this Deposit.

        The language ID of the deposit  # noqa: E501

        :param language_id: The language_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._language_id = language_id

    @property
    def last_update(self):
        """Gets the last_update of this Deposit.  # noqa: E501


        :return: The last_update of this Deposit.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Deposit.


        :param last_update: The last_update of this Deposit.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def license_id(self):
        """Gets the license_id of this Deposit.  # noqa: E501

        The license ID of the deposit  # noqa: E501

        :return: The license_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._license_id

    @license_id.setter
    def license_id(self, license_id):
        """Sets the license_id of this Deposit.

        The license ID of the deposit  # noqa: E501

        :param license_id: The license_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._license_id = license_id

    @property
    def metadata_version(self):
        """Gets the metadata_version of this Deposit.  # noqa: E501

        The metadata version of the deposit  # noqa: E501

        :return: The metadata_version of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._metadata_version

    @metadata_version.setter
    def metadata_version(self, metadata_version):
        """Sets the metadata_version of this Deposit.

        The metadata version of the deposit  # noqa: E501

        :param metadata_version: The metadata_version of this Deposit.  # noqa: E501
        :type: str
        """
        allowed_values = ["1.0", "1.1", "2.0", "2.1", "3.0"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and metadata_version not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `metadata_version` ({0}), must be one of {1}"  # noqa: E501
                .format(metadata_version, allowed_values)
            )

        self._metadata_version = metadata_version

    @property
    def organizational_unit_id(self):
        """Gets the organizational_unit_id of this Deposit.  # noqa: E501

        The organizational unit ID of the deposit  # noqa: E501

        :return: The organizational_unit_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._organizational_unit_id

    @organizational_unit_id.setter
    def organizational_unit_id(self, organizational_unit_id):
        """Sets the organizational_unit_id of this Deposit.

        The organizational unit ID of the deposit  # noqa: E501

        :param organizational_unit_id: The organizational_unit_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._organizational_unit_id = organizational_unit_id

    @property
    def preparation_id(self):
        """Gets the preparation_id of this Deposit.  # noqa: E501

        The preparation ID of the deposit  # noqa: E501

        :return: The preparation_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._preparation_id

    @preparation_id.setter
    def preparation_id(self, preparation_id):
        """Sets the preparation_id of this Deposit.

        The preparation ID of the deposit  # noqa: E501

        :param preparation_id: The preparation_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._preparation_id = preparation_id

    @property
    def preservation_policy_id(self):
        """Gets the preservation_policy_id of this Deposit.  # noqa: E501

        The preservation policy ID of the deposit  # noqa: E501

        :return: The preservation_policy_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._preservation_policy_id

    @preservation_policy_id.setter
    def preservation_policy_id(self, preservation_policy_id):
        """Sets the preservation_policy_id of this Deposit.

        The preservation policy ID of the deposit  # noqa: E501

        :param preservation_policy_id: The preservation_policy_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._preservation_policy_id = preservation_policy_id

    @property
    def publication_date(self):
        """Gets the publication_date of this Deposit.  # noqa: E501

        The publication date of the deposit  # noqa: E501

        :return: The publication_date of this Deposit.  # noqa: E501
        :rtype: date
        """
        return self._publication_date

    @publication_date.setter
    def publication_date(self, publication_date):
        """Sets the publication_date of this Deposit.

        The publication date of the deposit  # noqa: E501

        :param publication_date: The publication_date of this Deposit.  # noqa: E501
        :type: date
        """

        self._publication_date = publication_date

    @property
    def res_id(self):
        """Gets the res_id of this Deposit.  # noqa: E501

        The _deposits_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this Deposit.

        The _deposits_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def sip_id(self):
        """Gets the sip_id of this Deposit.  # noqa: E501

        The generated SIP DLCM ID of the deposit  # noqa: E501

        :return: The sip_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._sip_id

    @sip_id.setter
    def sip_id(self, sip_id):
        """Sets the sip_id of this Deposit.

        The generated SIP DLCM ID of the deposit  # noqa: E501

        :param sip_id: The sip_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._sip_id = sip_id

    @property
    def status(self):
        """Gets the status of this Deposit.  # noqa: E501

        The status of the deposit  # noqa: E501

        :return: The status of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Deposit.

        The status of the deposit  # noqa: E501

        :param status: The status of this Deposit.  # noqa: E501
        :type: str
        """
        allowed_values = ["APPROVED", "CHECKED", "CLEANED", "CLEANING", "COMPLETED", "DELETING", "IN_ERROR", "IN_PROGRESS", "IN_VALIDATION", "REJECTED", "SUBMITTED", "EDITING_METADATA", "CHECKING_COMPLIANCE", "CHECKING_COMPLIANCE_CLEANED", "COMPLIANCE_ERROR", "EDITING_ERROR", "CANCEL_EDITING_METADATA"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this Deposit.  # noqa: E501

        The message related to the status  # noqa: E501

        :return: The status_message of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this Deposit.

        The message related to the status  # noqa: E501

        :param status_message: The status_message of this Deposit.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    @property
    def submission_agreement_id(self):
        """Gets the submission_agreement_id of this Deposit.  # noqa: E501

        The submission agreement of the deposit  # noqa: E501

        :return: The submission_agreement_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._submission_agreement_id

    @submission_agreement_id.setter
    def submission_agreement_id(self, submission_agreement_id):
        """Sets the submission_agreement_id of this Deposit.

        The submission agreement of the deposit  # noqa: E501

        :param submission_agreement_id: The submission_agreement_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._submission_agreement_id = submission_agreement_id

    @property
    def submission_policy_id(self):
        """Gets the submission_policy_id of this Deposit.  # noqa: E501

        The submission policy ID of the deposit  # noqa: E501

        :return: The submission_policy_id of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._submission_policy_id

    @submission_policy_id.setter
    def submission_policy_id(self, submission_policy_id):
        """Sets the submission_policy_id of this Deposit.

        The submission policy ID of the deposit  # noqa: E501

        :param submission_policy_id: The submission_policy_id of this Deposit.  # noqa: E501
        :type: str
        """

        self._submission_policy_id = submission_policy_id

    @property
    def title(self):
        """Gets the title of this Deposit.  # noqa: E501

        The title of the deposit  # noqa: E501

        :return: The title of this Deposit.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Deposit.

        The title of the deposit  # noqa: E501

        :param title: The title of this Deposit.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Deposit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Deposit):
            return True

        return self.to_dict() != other.to_dict()
