# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from dlcmapi_client.configuration import Configuration


class Aip(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'links': 'object',
        'archival_unit': 'bool',
        'archive_container': 'str',
        'archive_file_number': 'float',
        'archive_id': 'str',
        'archive_size': 'float',
        'checksum_check': 'AipChecksumCheck',
        'checksums': 'list[str]',
        'collection_size': 'float',
        'creation': 'ChangeInfo',
        'data_file_number': 'float',
        'disposition_approval': 'bool',
        'file_format': 'AipFileFormat',
        'info': 'AipInfo',
        'last_update': 'ChangeInfo',
        'ready': 'bool',
        'res_id': 'str',
        'retention': 'float',
        'retention_end': 'datetime',
        'sip_ids': 'list[str]',
        'smart_retention': 'str',
        'smart_size': 'str',
        'smart_tombstone_size': 'str',
        'tombstone_size': 'float',
        'virus_check': 'AipVirusCheck'
    }

    attribute_map = {
        'links': '_links',
        'archival_unit': 'archivalUnit',
        'archive_container': 'archiveContainer',
        'archive_file_number': 'archiveFileNumber',
        'archive_id': 'archiveId',
        'archive_size': 'archiveSize',
        'checksum_check': 'checksumCheck',
        'checksums': 'checksums',
        'collection_size': 'collectionSize',
        'creation': 'creation',
        'data_file_number': 'dataFileNumber',
        'disposition_approval': 'dispositionApproval',
        'file_format': 'fileFormat',
        'info': 'info',
        'last_update': 'lastUpdate',
        'ready': 'ready',
        'res_id': 'resId',
        'retention': 'retention',
        'retention_end': 'retentionEnd',
        'sip_ids': 'sipIds',
        'smart_retention': 'smartRetention',
        'smart_size': 'smartSize',
        'smart_tombstone_size': 'smartTombstoneSize',
        'tombstone_size': 'tombstoneSize',
        'virus_check': 'virusCheck'
    }

    def __init__(self, links=None, archival_unit=None, archive_container=None, archive_file_number=None, archive_id=None, archive_size=None, checksum_check=None, checksums=None, collection_size=None, creation=None, data_file_number=None, disposition_approval=None, file_format=None, info=None, last_update=None, ready=None, res_id=None, retention=None, retention_end=None, sip_ids=None, smart_retention=None, smart_size=None, smart_tombstone_size=None, tombstone_size=None, virus_check=None, local_vars_configuration=None):  # noqa: E501
        """Aip - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._links = None
        self._archival_unit = None
        self._archive_container = None
        self._archive_file_number = None
        self._archive_id = None
        self._archive_size = None
        self._checksum_check = None
        self._checksums = None
        self._collection_size = None
        self._creation = None
        self._data_file_number = None
        self._disposition_approval = None
        self._file_format = None
        self._info = None
        self._last_update = None
        self._ready = None
        self._res_id = None
        self._retention = None
        self._retention_end = None
        self._sip_ids = None
        self._smart_retention = None
        self._smart_size = None
        self._smart_tombstone_size = None
        self._tombstone_size = None
        self._virus_check = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if archival_unit is not None:
            self.archival_unit = archival_unit
        if archive_container is not None:
            self.archive_container = archive_container
        if archive_file_number is not None:
            self.archive_file_number = archive_file_number
        if archive_id is not None:
            self.archive_id = archive_id
        if archive_size is not None:
            self.archive_size = archive_size
        if checksum_check is not None:
            self.checksum_check = checksum_check
        if checksums is not None:
            self.checksums = checksums
        if collection_size is not None:
            self.collection_size = collection_size
        if creation is not None:
            self.creation = creation
        if data_file_number is not None:
            self.data_file_number = data_file_number
        if disposition_approval is not None:
            self.disposition_approval = disposition_approval
        if file_format is not None:
            self.file_format = file_format
        if info is not None:
            self.info = info
        if last_update is not None:
            self.last_update = last_update
        if ready is not None:
            self.ready = ready
        if res_id is not None:
            self.res_id = res_id
        if retention is not None:
            self.retention = retention
        if retention_end is not None:
            self.retention_end = retention_end
        if sip_ids is not None:
            self.sip_ids = sip_ids
        if smart_retention is not None:
            self.smart_retention = smart_retention
        if smart_size is not None:
            self.smart_size = smart_size
        if smart_tombstone_size is not None:
            self.smart_tombstone_size = smart_tombstone_size
        if tombstone_size is not None:
            self.tombstone_size = tombstone_size
        if virus_check is not None:
            self.virus_check = virus_check

    @property
    def links(self):
        """Gets the links of this Aip.  # noqa: E501

        The _links_ list of the _aip_ resource  # noqa: E501

        :return: The links of this Aip.  # noqa: E501
        :rtype: object
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Aip.

        The _links_ list of the _aip_ resource  # noqa: E501

        :param links: The links of this Aip.  # noqa: E501
        :type: object
        """

        self._links = links

    @property
    def archival_unit(self):
        """Gets the archival_unit of this Aip.  # noqa: E501

        if the AIP is an unit (AIU) or a collection (AIC)  # noqa: E501

        :return: The archival_unit of this Aip.  # noqa: E501
        :rtype: bool
        """
        return self._archival_unit

    @archival_unit.setter
    def archival_unit(self, archival_unit):
        """Sets the archival_unit of this Aip.

        if the AIP is an unit (AIU) or a collection (AIC)  # noqa: E501

        :param archival_unit: The archival_unit of this Aip.  # noqa: E501
        :type: bool
        """

        self._archival_unit = archival_unit

    @property
    def archive_container(self):
        """Gets the archive_container of this Aip.  # noqa: E501

        The container type of the AIP  # noqa: E501

        :return: The archive_container of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._archive_container

    @archive_container.setter
    def archive_container(self, archive_container):
        """Sets the archive_container of this Aip.

        The container type of the AIP  # noqa: E501

        :param archive_container: The archive_container of this Aip.  # noqa: E501
        :type: str
        """
        allowed_values = ["UNDEFINED", "ZIP", "BAG_IT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and archive_container not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `archive_container` ({0}), must be one of {1}"  # noqa: E501
                .format(archive_container, allowed_values)
            )

        self._archive_container = archive_container

    @property
    def archive_file_number(self):
        """Gets the archive_file_number of this Aip.  # noqa: E501

        The total number of file in the AIP  # noqa: E501

        :return: The archive_file_number of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._archive_file_number

    @archive_file_number.setter
    def archive_file_number(self, archive_file_number):
        """Sets the archive_file_number of this Aip.

        The total number of file in the AIP  # noqa: E501

        :param archive_file_number: The archive_file_number of this Aip.  # noqa: E501
        :type: float
        """

        self._archive_file_number = archive_file_number

    @property
    def archive_id(self):
        """Gets the archive_id of this Aip.  # noqa: E501

        The storage URL of the AIP  # noqa: E501

        :return: The archive_id of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._archive_id

    @archive_id.setter
    def archive_id(self, archive_id):
        """Sets the archive_id of this Aip.

        The storage URL of the AIP  # noqa: E501

        :param archive_id: The archive_id of this Aip.  # noqa: E501
        :type: str
        """

        self._archive_id = archive_id

    @property
    def archive_size(self):
        """Gets the archive_size of this Aip.  # noqa: E501

        The size in bytes of the AIP  # noqa: E501

        :return: The archive_size of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._archive_size

    @archive_size.setter
    def archive_size(self, archive_size):
        """Sets the archive_size of this Aip.

        The size in bytes of the AIP  # noqa: E501

        :param archive_size: The archive_size of this Aip.  # noqa: E501
        :type: float
        """

        self._archive_size = archive_size

    @property
    def checksum_check(self):
        """Gets the checksum_check of this Aip.  # noqa: E501


        :return: The checksum_check of this Aip.  # noqa: E501
        :rtype: AipChecksumCheck
        """
        return self._checksum_check

    @checksum_check.setter
    def checksum_check(self, checksum_check):
        """Sets the checksum_check of this Aip.


        :param checksum_check: The checksum_check of this Aip.  # noqa: E501
        :type: AipChecksumCheck
        """

        self._checksum_check = checksum_check

    @property
    def checksums(self):
        """Gets the checksums of this Aip.  # noqa: E501

        The checksum list of the AIP  # noqa: E501

        :return: The checksums of this Aip.  # noqa: E501
        :rtype: list[str]
        """
        return self._checksums

    @checksums.setter
    def checksums(self, checksums):
        """Sets the checksums of this Aip.

        The checksum list of the AIP  # noqa: E501

        :param checksums: The checksums of this Aip.  # noqa: E501
        :type: list[str]
        """

        self._checksums = checksums

    @property
    def collection_size(self):
        """Gets the collection_size of this Aip.  # noqa: E501

        Number of AIPs in collection  # noqa: E501

        :return: The collection_size of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._collection_size

    @collection_size.setter
    def collection_size(self, collection_size):
        """Sets the collection_size of this Aip.

        Number of AIPs in collection  # noqa: E501

        :param collection_size: The collection_size of this Aip.  # noqa: E501
        :type: float
        """

        self._collection_size = collection_size

    @property
    def creation(self):
        """Gets the creation of this Aip.  # noqa: E501


        :return: The creation of this Aip.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._creation

    @creation.setter
    def creation(self, creation):
        """Sets the creation of this Aip.


        :param creation: The creation of this Aip.  # noqa: E501
        :type: ChangeInfo
        """

        self._creation = creation

    @property
    def data_file_number(self):
        """Gets the data_file_number of this Aip.  # noqa: E501

        Number of AIP data files  # noqa: E501

        :return: The data_file_number of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._data_file_number

    @data_file_number.setter
    def data_file_number(self, data_file_number):
        """Sets the data_file_number of this Aip.

        Number of AIP data files  # noqa: E501

        :param data_file_number: The data_file_number of this Aip.  # noqa: E501
        :type: float
        """

        self._data_file_number = data_file_number

    @property
    def disposition_approval(self):
        """Gets the disposition_approval of this Aip.  # noqa: E501

        Mandatory step to approve the AIP disposition  # noqa: E501

        :return: The disposition_approval of this Aip.  # noqa: E501
        :rtype: bool
        """
        return self._disposition_approval

    @disposition_approval.setter
    def disposition_approval(self, disposition_approval):
        """Sets the disposition_approval of this Aip.

        Mandatory step to approve the AIP disposition  # noqa: E501

        :param disposition_approval: The disposition_approval of this Aip.  # noqa: E501
        :type: bool
        """

        self._disposition_approval = disposition_approval

    @property
    def file_format(self):
        """Gets the file_format of this Aip.  # noqa: E501


        :return: The file_format of this Aip.  # noqa: E501
        :rtype: AipFileFormat
        """
        return self._file_format

    @file_format.setter
    def file_format(self, file_format):
        """Sets the file_format of this Aip.


        :param file_format: The file_format of this Aip.  # noqa: E501
        :type: AipFileFormat
        """

        self._file_format = file_format

    @property
    def info(self):
        """Gets the info of this Aip.  # noqa: E501


        :return: The info of this Aip.  # noqa: E501
        :rtype: AipInfo
        """
        return self._info

    @info.setter
    def info(self, info):
        """Sets the info of this Aip.


        :param info: The info of this Aip.  # noqa: E501
        :type: AipInfo
        """

        self._info = info

    @property
    def last_update(self):
        """Gets the last_update of this Aip.  # noqa: E501


        :return: The last_update of this Aip.  # noqa: E501
        :rtype: ChangeInfo
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """Sets the last_update of this Aip.


        :param last_update: The last_update of this Aip.  # noqa: E501
        :type: ChangeInfo
        """

        self._last_update = last_update

    @property
    def ready(self):
        """Gets the ready of this Aip.  # noqa: E501

        If AIP package is ready  # noqa: E501

        :return: The ready of this Aip.  # noqa: E501
        :rtype: bool
        """
        return self._ready

    @ready.setter
    def ready(self, ready):
        """Sets the ready of this Aip.

        If AIP package is ready  # noqa: E501

        :param ready: The ready of this Aip.  # noqa: E501
        :type: bool
        """

        self._ready = ready

    @property
    def res_id(self):
        """Gets the res_id of this Aip.  # noqa: E501

        The _aip_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :return: The res_id of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._res_id

    @res_id.setter
    def res_id(self, res_id):
        """Sets the res_id of this Aip.

        The _aip_ resource identifier [https://en.wikipedia.org/wiki/Universally_unique_identifier[UUID]]  # noqa: E501

        :param res_id: The res_id of this Aip.  # noqa: E501
        :type: str
        """

        self._res_id = res_id

    @property
    def retention(self):
        """Gets the retention of this Aip.  # noqa: E501

        The retention duration in days of the AIP  # noqa: E501

        :return: The retention of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._retention

    @retention.setter
    def retention(self, retention):
        """Sets the retention of this Aip.

        The retention duration in days of the AIP  # noqa: E501

        :param retention: The retention of this Aip.  # noqa: E501
        :type: float
        """

        self._retention = retention

    @property
    def retention_end(self):
        """Gets the retention_end of this Aip.  # noqa: E501

        The end of the AIP retention  # noqa: E501

        :return: The retention_end of this Aip.  # noqa: E501
        :rtype: datetime
        """
        return self._retention_end

    @retention_end.setter
    def retention_end(self, retention_end):
        """Sets the retention_end of this Aip.

        The end of the AIP retention  # noqa: E501

        :param retention_end: The retention_end of this Aip.  # noqa: E501
        :type: datetime
        """

        self._retention_end = retention_end

    @property
    def sip_ids(self):
        """Gets the sip_ids of this Aip.  # noqa: E501

        The source SIP IDs of the AIP  # noqa: E501

        :return: The sip_ids of this Aip.  # noqa: E501
        :rtype: list[str]
        """
        return self._sip_ids

    @sip_ids.setter
    def sip_ids(self, sip_ids):
        """Sets the sip_ids of this Aip.

        The source SIP IDs of the AIP  # noqa: E501

        :param sip_ids: The sip_ids of this Aip.  # noqa: E501
        :type: list[str]
        """

        self._sip_ids = sip_ids

    @property
    def smart_retention(self):
        """Gets the smart_retention of this Aip.  # noqa: E501

        The retention duration in human-readable format of the AIP  # noqa: E501

        :return: The smart_retention of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._smart_retention

    @smart_retention.setter
    def smart_retention(self, smart_retention):
        """Sets the smart_retention of this Aip.

        The retention duration in human-readable format of the AIP  # noqa: E501

        :param smart_retention: The smart_retention of this Aip.  # noqa: E501
        :type: str
        """

        self._smart_retention = smart_retention

    @property
    def smart_size(self):
        """Gets the smart_size of this Aip.  # noqa: E501

        The size in human-readable format of the AIP  # noqa: E501

        :return: The smart_size of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._smart_size

    @smart_size.setter
    def smart_size(self, smart_size):
        """Sets the smart_size of this Aip.

        The size in human-readable format of the AIP  # noqa: E501

        :param smart_size: The smart_size of this Aip.  # noqa: E501
        :type: str
        """

        self._smart_size = smart_size

    @property
    def smart_tombstone_size(self):
        """Gets the smart_tombstone_size of this Aip.  # noqa: E501

        The size in human-readable format of the tombstone AIP  # noqa: E501

        :return: The smart_tombstone_size of this Aip.  # noqa: E501
        :rtype: str
        """
        return self._smart_tombstone_size

    @smart_tombstone_size.setter
    def smart_tombstone_size(self, smart_tombstone_size):
        """Sets the smart_tombstone_size of this Aip.

        The size in human-readable format of the tombstone AIP  # noqa: E501

        :param smart_tombstone_size: The smart_tombstone_size of this Aip.  # noqa: E501
        :type: str
        """

        self._smart_tombstone_size = smart_tombstone_size

    @property
    def tombstone_size(self):
        """Gets the tombstone_size of this Aip.  # noqa: E501

        The size in bytes of the tombstone AIP  # noqa: E501

        :return: The tombstone_size of this Aip.  # noqa: E501
        :rtype: float
        """
        return self._tombstone_size

    @tombstone_size.setter
    def tombstone_size(self, tombstone_size):
        """Sets the tombstone_size of this Aip.

        The size in bytes of the tombstone AIP  # noqa: E501

        :param tombstone_size: The tombstone_size of this Aip.  # noqa: E501
        :type: float
        """

        self._tombstone_size = tombstone_size

    @property
    def virus_check(self):
        """Gets the virus_check of this Aip.  # noqa: E501


        :return: The virus_check of this Aip.  # noqa: E501
        :rtype: AipVirusCheck
        """
        return self._virus_check

    @virus_check.setter
    def virus_check(self, virus_check):
        """Sets the virus_check of this Aip.


        :param virus_check: The virus_check of this Aip.  # noqa: E501
        :type: AipVirusCheck
        """

        self._virus_check = virus_check

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Aip):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Aip):
            return True

        return self.to_dict() != other.to_dict()
