# coding: utf-8

"""
    DLCM-Solution

    DLCM application wrapping all modules, All-In-One  # noqa: E501

    The version of the OpenAPI document: 2.1.1
    Contact: eresearch-opensource@unige.ch
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dlcmapi_client.api_client import ApiClient
from dlcmapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OaiInfoApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def oai_info_get(self, **kwargs):  # noqa: E501
        """oai_info_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_get_with_http_info(**kwargs)  # noqa: E501

    def oai_info_get_with_http_info(self, **kwargs):  # noqa: E501
        """oai_info_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiInfo, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_metadata_prefixes_delete_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_delete_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_delete_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiMetadataPrefixe
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_metadata_prefixes_delete_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_metadata_prefixes_delete_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_delete_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_delete_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiMetadataPrefixe, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_metadata_prefixes_delete_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_metadata_prefixes_delete_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-metadata-prefixes/{resId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiMetadataPrefixe',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_metadata_prefixes_get(self, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: The page size
        :param int page: The current page number
        :param str sort: To sort on a field. By default, the sort is ascending. desc option '[,desc]' permits to have descending order.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_metadata_prefixes_get_with_http_info(**kwargs)  # noqa: E501

    def oai_info_oai_metadata_prefixes_get_with_http_info(self, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: The page size
        :param int page: The current page number
        :param str sort: To sort on a field. By default, the sort is ascending. desc option '[,desc]' permits to have descending order.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Collection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'size',
            'page',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_metadata_prefixes_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-metadata-prefixes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_metadata_prefixes_get_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_get_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiMetadataPrefixe
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_metadata_prefixes_get_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_metadata_prefixes_get_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_get_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiMetadataPrefixe, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_metadata_prefixes_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_metadata_prefixes_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-metadata-prefixes/{resId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiMetadataPrefixe',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_metadata_prefixes_patch_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_patch_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_patch_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param OaiMetadataPrefixe oai_metadata_prefixe:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiMetadataPrefixe
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_metadata_prefixes_patch_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_metadata_prefixes_patch_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_patch_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_patch_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param OaiMetadataPrefixe oai_metadata_prefixe:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiMetadataPrefixe, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id',
            'oai_metadata_prefixe'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_metadata_prefixes_patch_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_metadata_prefixes_patch_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'oai_metadata_prefixe' in local_var_params:
            body_params = local_var_params['oai_metadata_prefixe']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-metadata-prefixes/{resId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiMetadataPrefixe',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_metadata_prefixes_post(self, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OaiMetadataPrefixe oai_metadata_prefixe:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiMetadataPrefixe
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_metadata_prefixes_post_with_http_info(**kwargs)  # noqa: E501

    def oai_info_oai_metadata_prefixes_post_with_http_info(self, **kwargs):  # noqa: E501
        """oai_info_oai_metadata_prefixes_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_metadata_prefixes_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OaiMetadataPrefixe oai_metadata_prefixe:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiMetadataPrefixe, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'oai_metadata_prefixe'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_metadata_prefixes_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'oai_metadata_prefixe' in local_var_params:
            body_params = local_var_params['oai_metadata_prefixe']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-metadata-prefixes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiMetadataPrefixe',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_sets_delete_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_delete_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_delete_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_sets_delete_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_sets_delete_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_delete_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_delete_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiSet, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_sets_delete_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_sets_delete_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-sets/{resId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_sets_get(self, **kwargs):  # noqa: E501
        """oai_info_oai_sets_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: The page size
        :param int page: The current page number
        :param str sort: To sort on a field. By default, the sort is ascending. desc option '[,desc]' permits to have descending order.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_sets_get_with_http_info(**kwargs)  # noqa: E501

    def oai_info_oai_sets_get_with_http_info(self, **kwargs):  # noqa: E501
        """oai_info_oai_sets_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int size: The page size
        :param int page: The current page number
        :param str sort: To sort on a field. By default, the sort is ascending. desc option '[,desc]' permits to have descending order.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Collection, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'size',
            'page',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_sets_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-sets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_sets_get_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_get_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_sets_get_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_sets_get_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_get_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_get_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiSet, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_sets_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_sets_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-sets/{resId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_sets_patch_by_id(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_patch_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_patch_by_id(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param OaiSet oai_set:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_sets_patch_by_id_with_http_info(res_id, **kwargs)  # noqa: E501

    def oai_info_oai_sets_patch_by_id_with_http_info(self, res_id, **kwargs):  # noqa: E501
        """oai_info_oai_sets_patch_by_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_patch_by_id_with_http_info(res_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str res_id: Resource Id (GUID) (required)
        :param OaiSet oai_set:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiSet, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'res_id',
            'oai_set'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_sets_patch_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'res_id' is set
        if self.api_client.client_side_validation and ('res_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['res_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `res_id` when calling `oai_info_oai_sets_patch_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'res_id' in local_var_params:
            path_params['resId'] = local_var_params['res_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'oai_set' in local_var_params:
            body_params = local_var_params['oai_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-sets/{resId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def oai_info_oai_sets_post(self, **kwargs):  # noqa: E501
        """oai_info_oai_sets_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OaiSet oai_set:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OaiSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.oai_info_oai_sets_post_with_http_info(**kwargs)  # noqa: E501

    def oai_info_oai_sets_post_with_http_info(self, **kwargs):  # noqa: E501
        """oai_info_oai_sets_post  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.oai_info_oai_sets_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OaiSet oai_set:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OaiSet, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'oai_set'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oai_info_oai_sets_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'oai_set' in local_var_params:
            body_params = local_var_params['oai_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['dlcm-auth']  # noqa: E501

        return self.api_client.call_api(
            '/oai-info/oai-sets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OaiSet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
