# dlcm-api
DLCM application wrapping all modules, All-In-One

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.1
- Package version: 2.1.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dlcmapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dlcmapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import dlcmapi_client
from dlcmapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = dlcmapi_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: dlcm-auth
configuration = dlcmapi_client.Configuration(
    host = "http://localhost"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with dlcmapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = dlcmapi_client.AccessApi(api_client)
    res_id = 'res_id_example' # str | Resource Id (GUID)

    try:
        api_response = api_instance.access_dip_delete_by_id(res_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessApi->access_dip_delete_by_id: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessApi* | [**access_dip_delete_by_id**](docs/AccessApi.md#access_dip_delete_by_id) | **DELETE** /access/dip/{resId} | 
*AccessApi* | [**access_dip_get**](docs/AccessApi.md#access_dip_get) | **GET** /access/dip | 
*AccessApi* | [**access_dip_get_by_id**](docs/AccessApi.md#access_dip_get_by_id) | **GET** /access/dip/{resId} | 
*AccessApi* | [**access_dip_patch_by_id**](docs/AccessApi.md#access_dip_patch_by_id) | **PATCH** /access/dip/{resId} | 
*AccessApi* | [**access_dip_post**](docs/AccessApi.md#access_dip_post) | **POST** /access/dip | 
*AccessApi* | [**access_get**](docs/AccessApi.md#access_get) | **GET** /access | 
*AccessApi* | [**access_metadata_get**](docs/AccessApi.md#access_metadata_get) | **GET** /access/metadata | 
*AccessApi* | [**access_metadata_get_by_id**](docs/AccessApi.md#access_metadata_get_by_id) | **GET** /access/metadata/{resId} | 
*AccessApi* | [**access_orders_delete_by_id**](docs/AccessApi.md#access_orders_delete_by_id) | **DELETE** /access/orders/{resId} | 
*AccessApi* | [**access_orders_get**](docs/AccessApi.md#access_orders_get) | **GET** /access/orders | 
*AccessApi* | [**access_orders_get_by_id**](docs/AccessApi.md#access_orders_get_by_id) | **GET** /access/orders/{resId} | 
*AccessApi* | [**access_orders_patch_by_id**](docs/AccessApi.md#access_orders_patch_by_id) | **PATCH** /access/orders/{resId} | 
*AccessApi* | [**access_orders_post**](docs/AccessApi.md#access_orders_post) | **POST** /access/orders | 
*AccessApi* | [**access_organizational_units_get**](docs/AccessApi.md#access_organizational_units_get) | **GET** /access/organizational-units | 
*AccessApi* | [**access_organizational_units_get_by_id**](docs/AccessApi.md#access_organizational_units_get_by_id) | **GET** /access/organizational-units/{resId} | 
*AdminApi* | [**admin_application_roles_delete_by_id**](docs/AdminApi.md#admin_application_roles_delete_by_id) | **DELETE** /admin/application-roles/{resId} | 
*AdminApi* | [**admin_application_roles_get**](docs/AdminApi.md#admin_application_roles_get) | **GET** /admin/application-roles | 
*AdminApi* | [**admin_application_roles_get_by_id**](docs/AdminApi.md#admin_application_roles_get_by_id) | **GET** /admin/application-roles/{resId} | 
*AdminApi* | [**admin_application_roles_patch_by_id**](docs/AdminApi.md#admin_application_roles_patch_by_id) | **PATCH** /admin/application-roles/{resId} | 
*AdminApi* | [**admin_application_roles_post**](docs/AdminApi.md#admin_application_roles_post) | **POST** /admin/application-roles | 
*AdminApi* | [**admin_archive_acl_delete_by_id**](docs/AdminApi.md#admin_archive_acl_delete_by_id) | **DELETE** /admin/archive-acl/{resId} | 
*AdminApi* | [**admin_archive_acl_get**](docs/AdminApi.md#admin_archive_acl_get) | **GET** /admin/archive-acl | 
*AdminApi* | [**admin_archive_acl_get_by_id**](docs/AdminApi.md#admin_archive_acl_get_by_id) | **GET** /admin/archive-acl/{resId} | 
*AdminApi* | [**admin_archive_acl_patch_by_id**](docs/AdminApi.md#admin_archive_acl_patch_by_id) | **PATCH** /admin/archive-acl/{resId} | 
*AdminApi* | [**admin_archive_acl_post**](docs/AdminApi.md#admin_archive_acl_post) | **POST** /admin/archive-acl | 
*AdminApi* | [**admin_archive_ratings_delete_by_id**](docs/AdminApi.md#admin_archive_ratings_delete_by_id) | **DELETE** /admin/archive-ratings/{resId} | 
*AdminApi* | [**admin_archive_ratings_get**](docs/AdminApi.md#admin_archive_ratings_get) | **GET** /admin/archive-ratings | 
*AdminApi* | [**admin_archive_ratings_get_by_id**](docs/AdminApi.md#admin_archive_ratings_get_by_id) | **GET** /admin/archive-ratings/{resId} | 
*AdminApi* | [**admin_archive_ratings_patch_by_id**](docs/AdminApi.md#admin_archive_ratings_patch_by_id) | **PATCH** /admin/archive-ratings/{resId} | 
*AdminApi* | [**admin_archive_ratings_post**](docs/AdminApi.md#admin_archive_ratings_post) | **POST** /admin/archive-ratings | 
*AdminApi* | [**admin_archive_statistics_get**](docs/AdminApi.md#admin_archive_statistics_get) | **GET** /admin/archive-statistics | 
*AdminApi* | [**admin_archive_statistics_get_by_id**](docs/AdminApi.md#admin_archive_statistics_get_by_id) | **GET** /admin/archive-statistics/{resId} | 
*AdminApi* | [**admin_archive_types_delete_by_id**](docs/AdminApi.md#admin_archive_types_delete_by_id) | **DELETE** /admin/archive-types/{resId} | 
*AdminApi* | [**admin_archive_types_get**](docs/AdminApi.md#admin_archive_types_get) | **GET** /admin/archive-types | 
*AdminApi* | [**admin_archive_types_get_by_id**](docs/AdminApi.md#admin_archive_types_get_by_id) | **GET** /admin/archive-types/{resId} | 
*AdminApi* | [**admin_archive_types_patch_by_id**](docs/AdminApi.md#admin_archive_types_patch_by_id) | **PATCH** /admin/archive-types/{resId} | 
*AdminApi* | [**admin_archive_types_post**](docs/AdminApi.md#admin_archive_types_post) | **POST** /admin/archive-types | 
*AdminApi* | [**admin_authorized_organizational_units_get**](docs/AdminApi.md#admin_authorized_organizational_units_get) | **GET** /admin/authorized-organizational-units | 
*AdminApi* | [**admin_dissemination_policies_delete_by_id**](docs/AdminApi.md#admin_dissemination_policies_delete_by_id) | **DELETE** /admin/dissemination-policies/{resId} | 
*AdminApi* | [**admin_dissemination_policies_get**](docs/AdminApi.md#admin_dissemination_policies_get) | **GET** /admin/dissemination-policies | 
*AdminApi* | [**admin_dissemination_policies_get_by_id**](docs/AdminApi.md#admin_dissemination_policies_get_by_id) | **GET** /admin/dissemination-policies/{resId} | 
*AdminApi* | [**admin_dissemination_policies_patch_by_id**](docs/AdminApi.md#admin_dissemination_policies_patch_by_id) | **PATCH** /admin/dissemination-policies/{resId} | 
*AdminApi* | [**admin_dissemination_policies_post**](docs/AdminApi.md#admin_dissemination_policies_post) | **POST** /admin/dissemination-policies | 
*AdminApi* | [**admin_funding_agencies_delete_by_id**](docs/AdminApi.md#admin_funding_agencies_delete_by_id) | **DELETE** /admin/funding-agencies/{resId} | 
*AdminApi* | [**admin_funding_agencies_get**](docs/AdminApi.md#admin_funding_agencies_get) | **GET** /admin/funding-agencies | 
*AdminApi* | [**admin_funding_agencies_get_by_id**](docs/AdminApi.md#admin_funding_agencies_get_by_id) | **GET** /admin/funding-agencies/{resId} | 
*AdminApi* | [**admin_funding_agencies_patch_by_id**](docs/AdminApi.md#admin_funding_agencies_patch_by_id) | **PATCH** /admin/funding-agencies/{resId} | 
*AdminApi* | [**admin_funding_agencies_post**](docs/AdminApi.md#admin_funding_agencies_post) | **POST** /admin/funding-agencies | 
*AdminApi* | [**admin_get**](docs/AdminApi.md#admin_get) | **GET** /admin | 
*AdminApi* | [**admin_institutions_delete_by_id**](docs/AdminApi.md#admin_institutions_delete_by_id) | **DELETE** /admin/institutions/{resId} | 
*AdminApi* | [**admin_institutions_get**](docs/AdminApi.md#admin_institutions_get) | **GET** /admin/institutions | 
*AdminApi* | [**admin_institutions_get_by_id**](docs/AdminApi.md#admin_institutions_get_by_id) | **GET** /admin/institutions/{resId} | 
*AdminApi* | [**admin_institutions_patch_by_id**](docs/AdminApi.md#admin_institutions_patch_by_id) | **PATCH** /admin/institutions/{resId} | 
*AdminApi* | [**admin_institutions_post**](docs/AdminApi.md#admin_institutions_post) | **POST** /admin/institutions | 
*AdminApi* | [**admin_languages_delete_by_id**](docs/AdminApi.md#admin_languages_delete_by_id) | **DELETE** /admin/languages/{resId} | 
*AdminApi* | [**admin_languages_get**](docs/AdminApi.md#admin_languages_get) | **GET** /admin/languages | 
*AdminApi* | [**admin_languages_get_by_id**](docs/AdminApi.md#admin_languages_get_by_id) | **GET** /admin/languages/{resId} | 
*AdminApi* | [**admin_languages_patch_by_id**](docs/AdminApi.md#admin_languages_patch_by_id) | **PATCH** /admin/languages/{resId} | 
*AdminApi* | [**admin_languages_post**](docs/AdminApi.md#admin_languages_post) | **POST** /admin/languages | 
*AdminApi* | [**admin_licenses_delete_by_id**](docs/AdminApi.md#admin_licenses_delete_by_id) | **DELETE** /admin/licenses/{resId} | 
*AdminApi* | [**admin_licenses_get**](docs/AdminApi.md#admin_licenses_get) | **GET** /admin/licenses | 
*AdminApi* | [**admin_licenses_get_by_id**](docs/AdminApi.md#admin_licenses_get_by_id) | **GET** /admin/licenses/{resId} | 
*AdminApi* | [**admin_licenses_patch_by_id**](docs/AdminApi.md#admin_licenses_patch_by_id) | **PATCH** /admin/licenses/{resId} | 
*AdminApi* | [**admin_licenses_post**](docs/AdminApi.md#admin_licenses_post) | **POST** /admin/licenses | 
*AdminApi* | [**admin_metadata_types_delete_by_id**](docs/AdminApi.md#admin_metadata_types_delete_by_id) | **DELETE** /admin/metadata-types/{resId} | 
*AdminApi* | [**admin_metadata_types_get**](docs/AdminApi.md#admin_metadata_types_get) | **GET** /admin/metadata-types | 
*AdminApi* | [**admin_metadata_types_get_by_id**](docs/AdminApi.md#admin_metadata_types_get_by_id) | **GET** /admin/metadata-types/{resId} | 
*AdminApi* | [**admin_metadata_types_patch_by_id**](docs/AdminApi.md#admin_metadata_types_patch_by_id) | **PATCH** /admin/metadata-types/{resId} | 
*AdminApi* | [**admin_metadata_types_post**](docs/AdminApi.md#admin_metadata_types_post) | **POST** /admin/metadata-types | 
*AdminApi* | [**admin_notifications_delete_by_id**](docs/AdminApi.md#admin_notifications_delete_by_id) | **DELETE** /admin/notifications/{resId} | 
*AdminApi* | [**admin_notifications_get**](docs/AdminApi.md#admin_notifications_get) | **GET** /admin/notifications | 
*AdminApi* | [**admin_notifications_get_by_id**](docs/AdminApi.md#admin_notifications_get_by_id) | **GET** /admin/notifications/{resId} | 
*AdminApi* | [**admin_notifications_patch_by_id**](docs/AdminApi.md#admin_notifications_patch_by_id) | **PATCH** /admin/notifications/{resId} | 
*AdminApi* | [**admin_notifications_post**](docs/AdminApi.md#admin_notifications_post) | **POST** /admin/notifications | 
*AdminApi* | [**admin_organizational_units_delete_by_id**](docs/AdminApi.md#admin_organizational_units_delete_by_id) | **DELETE** /admin/organizational-units/{resId} | 
*AdminApi* | [**admin_organizational_units_get**](docs/AdminApi.md#admin_organizational_units_get) | **GET** /admin/organizational-units | 
*AdminApi* | [**admin_organizational_units_get_by_id**](docs/AdminApi.md#admin_organizational_units_get_by_id) | **GET** /admin/organizational-units/{resId} | 
*AdminApi* | [**admin_organizational_units_patch_by_id**](docs/AdminApi.md#admin_organizational_units_patch_by_id) | **PATCH** /admin/organizational-units/{resId} | 
*AdminApi* | [**admin_organizational_units_post**](docs/AdminApi.md#admin_organizational_units_post) | **POST** /admin/organizational-units | 
*AdminApi* | [**admin_people_delete_by_id**](docs/AdminApi.md#admin_people_delete_by_id) | **DELETE** /admin/people/{resId} | 
*AdminApi* | [**admin_people_get**](docs/AdminApi.md#admin_people_get) | **GET** /admin/people | 
*AdminApi* | [**admin_people_get_by_id**](docs/AdminApi.md#admin_people_get_by_id) | **GET** /admin/people/{resId} | 
*AdminApi* | [**admin_people_patch_by_id**](docs/AdminApi.md#admin_people_patch_by_id) | **PATCH** /admin/people/{resId} | 
*AdminApi* | [**admin_people_post**](docs/AdminApi.md#admin_people_post) | **POST** /admin/people | 
*AdminApi* | [**admin_preservation_policies_delete_by_id**](docs/AdminApi.md#admin_preservation_policies_delete_by_id) | **DELETE** /admin/preservation-policies/{resId} | 
*AdminApi* | [**admin_preservation_policies_get**](docs/AdminApi.md#admin_preservation_policies_get) | **GET** /admin/preservation-policies | 
*AdminApi* | [**admin_preservation_policies_get_by_id**](docs/AdminApi.md#admin_preservation_policies_get_by_id) | **GET** /admin/preservation-policies/{resId} | 
*AdminApi* | [**admin_preservation_policies_patch_by_id**](docs/AdminApi.md#admin_preservation_policies_patch_by_id) | **PATCH** /admin/preservation-policies/{resId} | 
*AdminApi* | [**admin_preservation_policies_post**](docs/AdminApi.md#admin_preservation_policies_post) | **POST** /admin/preservation-policies | 
*AdminApi* | [**admin_rating_types_delete_by_id**](docs/AdminApi.md#admin_rating_types_delete_by_id) | **DELETE** /admin/rating-types/{resId} | 
*AdminApi* | [**admin_rating_types_get**](docs/AdminApi.md#admin_rating_types_get) | **GET** /admin/rating-types | 
*AdminApi* | [**admin_rating_types_get_by_id**](docs/AdminApi.md#admin_rating_types_get_by_id) | **GET** /admin/rating-types/{resId} | 
*AdminApi* | [**admin_rating_types_patch_by_id**](docs/AdminApi.md#admin_rating_types_patch_by_id) | **PATCH** /admin/rating-types/{resId} | 
*AdminApi* | [**admin_rating_types_post**](docs/AdminApi.md#admin_rating_types_post) | **POST** /admin/rating-types | 
*AdminApi* | [**admin_research_domains_delete_by_id**](docs/AdminApi.md#admin_research_domains_delete_by_id) | **DELETE** /admin/research-domains/{resId} | 
*AdminApi* | [**admin_research_domains_get**](docs/AdminApi.md#admin_research_domains_get) | **GET** /admin/research-domains | 
*AdminApi* | [**admin_research_domains_get_by_id**](docs/AdminApi.md#admin_research_domains_get_by_id) | **GET** /admin/research-domains/{resId} | 
*AdminApi* | [**admin_research_domains_patch_by_id**](docs/AdminApi.md#admin_research_domains_patch_by_id) | **PATCH** /admin/research-domains/{resId} | 
*AdminApi* | [**admin_research_domains_post**](docs/AdminApi.md#admin_research_domains_post) | **POST** /admin/research-domains | 
*AdminApi* | [**admin_roles_delete_by_id**](docs/AdminApi.md#admin_roles_delete_by_id) | **DELETE** /admin/roles/{resId} | 
*AdminApi* | [**admin_roles_get**](docs/AdminApi.md#admin_roles_get) | **GET** /admin/roles | 
*AdminApi* | [**admin_roles_get_by_id**](docs/AdminApi.md#admin_roles_get_by_id) | **GET** /admin/roles/{resId} | 
*AdminApi* | [**admin_roles_patch_by_id**](docs/AdminApi.md#admin_roles_patch_by_id) | **PATCH** /admin/roles/{resId} | 
*AdminApi* | [**admin_roles_post**](docs/AdminApi.md#admin_roles_post) | **POST** /admin/roles | 
*AdminApi* | [**admin_scheduled_tasks_delete_by_id**](docs/AdminApi.md#admin_scheduled_tasks_delete_by_id) | **DELETE** /admin/scheduled-tasks/{resId} | 
*AdminApi* | [**admin_scheduled_tasks_get**](docs/AdminApi.md#admin_scheduled_tasks_get) | **GET** /admin/scheduled-tasks | 
*AdminApi* | [**admin_scheduled_tasks_get_by_id**](docs/AdminApi.md#admin_scheduled_tasks_get_by_id) | **GET** /admin/scheduled-tasks/{resId} | 
*AdminApi* | [**admin_scheduled_tasks_patch_by_id**](docs/AdminApi.md#admin_scheduled_tasks_patch_by_id) | **PATCH** /admin/scheduled-tasks/{resId} | 
*AdminApi* | [**admin_scheduled_tasks_post**](docs/AdminApi.md#admin_scheduled_tasks_post) | **POST** /admin/scheduled-tasks | 
*AdminApi* | [**admin_submission_agreements_delete_by_id**](docs/AdminApi.md#admin_submission_agreements_delete_by_id) | **DELETE** /admin/submission-agreements/{resId} | 
*AdminApi* | [**admin_submission_agreements_get**](docs/AdminApi.md#admin_submission_agreements_get) | **GET** /admin/submission-agreements | 
*AdminApi* | [**admin_submission_agreements_get_by_id**](docs/AdminApi.md#admin_submission_agreements_get_by_id) | **GET** /admin/submission-agreements/{resId} | 
*AdminApi* | [**admin_submission_agreements_patch_by_id**](docs/AdminApi.md#admin_submission_agreements_patch_by_id) | **PATCH** /admin/submission-agreements/{resId} | 
*AdminApi* | [**admin_submission_agreements_post**](docs/AdminApi.md#admin_submission_agreements_post) | **POST** /admin/submission-agreements | 
*AdminApi* | [**admin_submission_policies_delete_by_id**](docs/AdminApi.md#admin_submission_policies_delete_by_id) | **DELETE** /admin/submission-policies/{resId} | 
*AdminApi* | [**admin_submission_policies_get**](docs/AdminApi.md#admin_submission_policies_get) | **GET** /admin/submission-policies | 
*AdminApi* | [**admin_submission_policies_get_by_id**](docs/AdminApi.md#admin_submission_policies_get_by_id) | **GET** /admin/submission-policies/{resId} | 
*AdminApi* | [**admin_submission_policies_patch_by_id**](docs/AdminApi.md#admin_submission_policies_patch_by_id) | **PATCH** /admin/submission-policies/{resId} | 
*AdminApi* | [**admin_submission_policies_post**](docs/AdminApi.md#admin_submission_policies_post) | **POST** /admin/submission-policies | 
*AdminApi* | [**admin_system_properties_get**](docs/AdminApi.md#admin_system_properties_get) | **GET** /admin/system-properties | 
*AdminApi* | [**admin_users_delete_by_id**](docs/AdminApi.md#admin_users_delete_by_id) | **DELETE** /admin/users/{resId} | 
*AdminApi* | [**admin_users_get**](docs/AdminApi.md#admin_users_get) | **GET** /admin/users | 
*AdminApi* | [**admin_users_get_by_id**](docs/AdminApi.md#admin_users_get_by_id) | **GET** /admin/users/{resId} | 
*AdminApi* | [**admin_users_patch_by_id**](docs/AdminApi.md#admin_users_patch_by_id) | **PATCH** /admin/users/{resId} | 
*AdminApi* | [**admin_users_post**](docs/AdminApi.md#admin_users_post) | **POST** /admin/users | 
*ArchivalStorageApi* | [**archival_storage_aip_delete_by_id**](docs/ArchivalStorageApi.md#archival_storage_aip_delete_by_id) | **DELETE** /archival-storage/aip/{resId} | 
*ArchivalStorageApi* | [**archival_storage_aip_get**](docs/ArchivalStorageApi.md#archival_storage_aip_get) | **GET** /archival-storage/aip | 
*ArchivalStorageApi* | [**archival_storage_aip_get_by_id**](docs/ArchivalStorageApi.md#archival_storage_aip_get_by_id) | **GET** /archival-storage/aip/{resId} | 
*ArchivalStorageApi* | [**archival_storage_aip_patch_by_id**](docs/ArchivalStorageApi.md#archival_storage_aip_patch_by_id) | **PATCH** /archival-storage/aip/{resId} | 
*ArchivalStorageApi* | [**archival_storage_aip_post**](docs/ArchivalStorageApi.md#archival_storage_aip_post) | **POST** /archival-storage/aip | 
*ArchivalStorageApi* | [**archival_storage_get**](docs/ArchivalStorageApi.md#archival_storage_get) | **GET** /archival-storage | 
*DataMgmtApi* | [**data_mgmt_get**](docs/DataMgmtApi.md#data_mgmt_get) | **GET** /data-mgmt | 
*DlcmApi* | [**application_get**](docs/DlcmApi.md#application_get) | **GET** / | 
*IndexApi* | [**index_get**](docs/IndexApi.md#index_get) | **GET** /index | 
*IndexApi* | [**index_index_field_aliases_delete_by_id**](docs/IndexApi.md#index_index_field_aliases_delete_by_id) | **DELETE** /index/index-field-aliases/{resId} | 
*IndexApi* | [**index_index_field_aliases_get**](docs/IndexApi.md#index_index_field_aliases_get) | **GET** /index/index-field-aliases | 
*IndexApi* | [**index_index_field_aliases_get_by_id**](docs/IndexApi.md#index_index_field_aliases_get_by_id) | **GET** /index/index-field-aliases/{resId} | 
*IndexApi* | [**index_index_field_aliases_patch_by_id**](docs/IndexApi.md#index_index_field_aliases_patch_by_id) | **PATCH** /index/index-field-aliases/{resId} | 
*IndexApi* | [**index_index_field_aliases_post**](docs/IndexApi.md#index_index_field_aliases_post) | **POST** /index/index-field-aliases | 
*IngestApi* | [**ingest_get**](docs/IngestApi.md#ingest_get) | **GET** /ingest | 
*IngestApi* | [**ingest_sip_delete_by_id**](docs/IngestApi.md#ingest_sip_delete_by_id) | **DELETE** /ingest/sip/{resId} | 
*IngestApi* | [**ingest_sip_get**](docs/IngestApi.md#ingest_sip_get) | **GET** /ingest/sip | 
*IngestApi* | [**ingest_sip_get_by_id**](docs/IngestApi.md#ingest_sip_get_by_id) | **GET** /ingest/sip/{resId} | 
*IngestApi* | [**ingest_sip_patch_by_id**](docs/IngestApi.md#ingest_sip_patch_by_id) | **PATCH** /ingest/sip/{resId} | 
*IngestApi* | [**ingest_sip_post**](docs/IngestApi.md#ingest_sip_post) | **POST** /ingest/sip | 
*OaiInfoApi* | [**oai_info_get**](docs/OaiInfoApi.md#oai_info_get) | **GET** /oai-info | 
*OaiInfoApi* | [**oai_info_oai_metadata_prefixes_delete_by_id**](docs/OaiInfoApi.md#oai_info_oai_metadata_prefixes_delete_by_id) | **DELETE** /oai-info/oai-metadata-prefixes/{resId} | 
*OaiInfoApi* | [**oai_info_oai_metadata_prefixes_get**](docs/OaiInfoApi.md#oai_info_oai_metadata_prefixes_get) | **GET** /oai-info/oai-metadata-prefixes | 
*OaiInfoApi* | [**oai_info_oai_metadata_prefixes_get_by_id**](docs/OaiInfoApi.md#oai_info_oai_metadata_prefixes_get_by_id) | **GET** /oai-info/oai-metadata-prefixes/{resId} | 
*OaiInfoApi* | [**oai_info_oai_metadata_prefixes_patch_by_id**](docs/OaiInfoApi.md#oai_info_oai_metadata_prefixes_patch_by_id) | **PATCH** /oai-info/oai-metadata-prefixes/{resId} | 
*OaiInfoApi* | [**oai_info_oai_metadata_prefixes_post**](docs/OaiInfoApi.md#oai_info_oai_metadata_prefixes_post) | **POST** /oai-info/oai-metadata-prefixes | 
*OaiInfoApi* | [**oai_info_oai_sets_delete_by_id**](docs/OaiInfoApi.md#oai_info_oai_sets_delete_by_id) | **DELETE** /oai-info/oai-sets/{resId} | 
*OaiInfoApi* | [**oai_info_oai_sets_get**](docs/OaiInfoApi.md#oai_info_oai_sets_get) | **GET** /oai-info/oai-sets | 
*OaiInfoApi* | [**oai_info_oai_sets_get_by_id**](docs/OaiInfoApi.md#oai_info_oai_sets_get_by_id) | **GET** /oai-info/oai-sets/{resId} | 
*OaiInfoApi* | [**oai_info_oai_sets_patch_by_id**](docs/OaiInfoApi.md#oai_info_oai_sets_patch_by_id) | **PATCH** /oai-info/oai-sets/{resId} | 
*OaiInfoApi* | [**oai_info_oai_sets_post**](docs/OaiInfoApi.md#oai_info_oai_sets_post) | **POST** /oai-info/oai-sets | 
*PreingestApi* | [**preingest_contributors_get**](docs/PreingestApi.md#preingest_contributors_get) | **GET** /preingest/contributors | 
*PreingestApi* | [**preingest_contributors_get_by_id**](docs/PreingestApi.md#preingest_contributors_get_by_id) | **GET** /preingest/contributors/{resId} | 
*PreingestApi* | [**preingest_deposits_delete_by_id**](docs/PreingestApi.md#preingest_deposits_delete_by_id) | **DELETE** /preingest/deposits/{resId} | 
*PreingestApi* | [**preingest_deposits_get**](docs/PreingestApi.md#preingest_deposits_get) | **GET** /preingest/deposits | 
*PreingestApi* | [**preingest_deposits_get_by_id**](docs/PreingestApi.md#preingest_deposits_get_by_id) | **GET** /preingest/deposits/{resId} | 
*PreingestApi* | [**preingest_deposits_patch_by_id**](docs/PreingestApi.md#preingest_deposits_patch_by_id) | **PATCH** /preingest/deposits/{resId} | 
*PreingestApi* | [**preingest_deposits_post**](docs/PreingestApi.md#preingest_deposits_post) | **POST** /preingest/deposits | 
*PreingestApi* | [**preingest_get**](docs/PreingestApi.md#preingest_get) | **GET** /preingest | 
*PreservationPlanningApi* | [**preservation_planning_get**](docs/PreservationPlanningApi.md#preservation_planning_get) | **GET** /preservation-planning | 
*PreservationPlanningApi* | [**preservation_planning_modules_get**](docs/PreservationPlanningApi.md#preservation_planning_modules_get) | **GET** /preservation-planning/modules | 
*PreservationPlanningApi* | [**preservation_planning_preservation_jobs_delete_by_id**](docs/PreservationPlanningApi.md#preservation_planning_preservation_jobs_delete_by_id) | **DELETE** /preservation-planning/preservation-jobs/{resId} | 
*PreservationPlanningApi* | [**preservation_planning_preservation_jobs_get**](docs/PreservationPlanningApi.md#preservation_planning_preservation_jobs_get) | **GET** /preservation-planning/preservation-jobs | 
*PreservationPlanningApi* | [**preservation_planning_preservation_jobs_get_by_id**](docs/PreservationPlanningApi.md#preservation_planning_preservation_jobs_get_by_id) | **GET** /preservation-planning/preservation-jobs/{resId} | 
*PreservationPlanningApi* | [**preservation_planning_preservation_jobs_patch_by_id**](docs/PreservationPlanningApi.md#preservation_planning_preservation_jobs_patch_by_id) | **PATCH** /preservation-planning/preservation-jobs/{resId} | 
*PreservationPlanningApi* | [**preservation_planning_preservation_jobs_post**](docs/PreservationPlanningApi.md#preservation_planning_preservation_jobs_post) | **POST** /preservation-planning/preservation-jobs | 


## Documentation For Models

 - [Access](docs/Access.md)
 - [AccessOrganizationalUnit](docs/AccessOrganizationalUnit.md)
 - [Admin](docs/Admin.md)
 - [Aip](docs/Aip.md)
 - [AipChecksumCheck](docs/AipChecksumCheck.md)
 - [AipFileFormat](docs/AipFileFormat.md)
 - [AipInfo](docs/AipInfo.md)
 - [AipInfoEmbargo](docs/AipInfoEmbargo.md)
 - [AipVirusCheck](docs/AipVirusCheck.md)
 - [Application](docs/Application.md)
 - [ApplicationRole](docs/ApplicationRole.md)
 - [ArchivalStorage](docs/ArchivalStorage.md)
 - [ArchiveAcl](docs/ArchiveAcl.md)
 - [ArchiveAclOrganizationalUnit](docs/ArchiveAclOrganizationalUnit.md)
 - [ArchiveAclUser](docs/ArchiveAclUser.md)
 - [ArchiveRating](docs/ArchiveRating.md)
 - [ArchiveRatingRatingType](docs/ArchiveRatingRatingType.md)
 - [ArchiveRatingUser](docs/ArchiveRatingUser.md)
 - [ArchiveStatistics](docs/ArchiveStatistics.md)
 - [ArchiveType](docs/ArchiveType.md)
 - [ChangeInfo](docs/ChangeInfo.md)
 - [Collection](docs/Collection.md)
 - [Contributor](docs/Contributor.md)
 - [DataMgmt](docs/DataMgmt.md)
 - [Deposit](docs/Deposit.md)
 - [Dip](docs/Dip.md)
 - [DisseminationPolicy](docs/DisseminationPolicy.md)
 - [FundingAgency](docs/FundingAgency.md)
 - [Index](docs/Index.md)
 - [IndexFieldAlias](docs/IndexFieldAlias.md)
 - [Ingest](docs/Ingest.md)
 - [Institution](docs/Institution.md)
 - [Language](docs/Language.md)
 - [Licens](docs/Licens.md)
 - [Metadata](docs/Metadata.md)
 - [MetadataType](docs/MetadataType.md)
 - [Module](docs/Module.md)
 - [Notification](docs/Notification.md)
 - [NotificationNotificationType](docs/NotificationNotificationType.md)
 - [NotificationNotifiedOrgUnit](docs/NotificationNotifiedOrgUnit.md)
 - [NotificationRecipient](docs/NotificationRecipient.md)
 - [OaiInfo](docs/OaiInfo.md)
 - [OaiMetadataPrefixe](docs/OaiMetadataPrefixe.md)
 - [OaiSet](docs/OaiSet.md)
 - [Order](docs/Order.md)
 - [OrganizationalUnit](docs/OrganizationalUnit.md)
 - [Page](docs/Page.md)
 - [Person](docs/Person.md)
 - [Preingest](docs/Preingest.md)
 - [PreservationJob](docs/PreservationJob.md)
 - [PreservationJobScheduling](docs/PreservationJobScheduling.md)
 - [PreservationPlanning](docs/PreservationPlanning.md)
 - [PreservationPolicy](docs/PreservationPolicy.md)
 - [RatingType](docs/RatingType.md)
 - [ResearchDomain](docs/ResearchDomain.md)
 - [Role](docs/Role.md)
 - [ScheduledTask](docs/ScheduledTask.md)
 - [Sip](docs/Sip.md)
 - [SubmissionAgreement](docs/SubmissionAgreement.md)
 - [SubmissionPolicy](docs/SubmissionPolicy.md)
 - [SystemProperty](docs/SystemProperty.md)
 - [User](docs/User.md)


## Documentation For Authorization


## dlcm-auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://localhost
- **Scopes**: N/A


## Author

eresearch-opensource@unige.ch


