# sysnet-pyutils

SYSNET Python Utilities

Knihovna obsahuje záklaní, v aplikacích hojně používané, utility.

## sysnet-pyutils.utils

Hlavní modul

### Třídy

* **Singleton**: Vzor všech singletonů. 

        class ConfigFlag(object, metaclass=Singleton):

* **ConfigFlag**: Pomocný singleton. Používá se pro inicializaci konfigurace.
* **Config**: Singleton konfigurace aplikace. Konfigurace se ukládá do souboru YAML.

        from sysnet_pyutils import utils as pu
        ...
        CC = pu.Config(config_path=CONFIG_FILE_PATH, config_dict=CONFIG_INIT)
        if CC.loaded:
            LOG.logger.info("CONFIG loaded")
        CONFIG = CC.config    # konfigurační dictionary

* **ConfigError**: Chyba konfigurace
* **Log**: Logovací singleton. Centralizuje logování v aplikaci. Umožňuje použití externího loggeru (např. pro Django nebo Flask)


### Funkce
----------------------------------------------------------------
#### api_key_generate(length: int):
Vygeneruje API klíč
* param length: Dělka API klíče
* return: API Key
----------------------------------------------------------------
#### api_key_next(name, length=16):
Vygeneruje slovník API key {API Key: name}
* param name:    Název API klíče
* param length:  Délka API klíče
* return:    Slovník {API Key: name}
----------------------------------------------------------------
#### api_keys_init(agenda='main', amount=4):
Vygeneruje klíče pro API
* param agenda: Název agendy, pro kterou se klíče generují
* param amount: Počet vygenerovaných klíčů
* return: seznam vygenerovaných klíčů
--------------------------------------------------------
#### convert_hex_to_int(id_hex):
Konvertuje hex string na int
* param id_hex:  Hexadecimální string
* return: int
--------------------------------------------------------
#### cron_to_dict(cron):
Konvertuje cron text do do slovníku
* param cron: cron text (například '35 21 * * *')
* return:    dict of cron
--------------------------------------------------------
#### cs_bool(value=None):
Vrátí českou textovou hodnotu 'ano'/'ne' pokud je bool(value) True/False
* param value:  Obecný objekt
* return:    'ano' or 'ne'
--------------------------------------------------------
#### date_to_datetime(date_value):
Konvertuje date na datetime v lokální časové zóně
* param date_value:  hodntoda  
* return:        hodnota date v lokální časové zóně
--------------------------------------------------------
#### ddecode_b64_string(b64_data: str, encoding='utf-8'):
Dekóduje base64 data na string
* param b64_data: data v base64 
* param encoding: kódování
* return:
--------------------------------------------------------
#### decode_b64_to_file(b64_data: str, filepath, encoding='utf-8'):
Uloží base64 data do souboru
* param b64_data: data v base64 
* param filepath: cesta k cílovému souboru
* param encoding: kódování
* return: cesta k cílovému souboru
--------------------------------------------------------
#### encode_file_b64(filepath, encoding='utf-8'):
Načte soubor do base64
* param filepath: cesta ke zdrojovému souboru
* param encoding: kódování
* return: data base64
--------------------------------------------------------
#### encode_string_b64(data: str, encoding='utf-8'):
Zakóduje string do base64
* param data: zdrojový text
* param encoding: kódování
* return: výstupní data base64
---------------------------------------------------------------- 
#### hash_md5(text):
Vytvoří md5 checksum ze zdrojového textu (zastaralé, nepoužívat)
* param text: zdrojový text 
* return: výstupní hash
--------------------------------------------------------
#### hash_sha1(text):
Vytvoří sha1 checksum ze zdrojového textu
* param text: zdrojový text 
* return: výstupní hash
--------------------------------------------------------
#### hash_sha256(text):
Vytvoří sha256 checksum ze zdrojového textu
* param text: zdrojový text 
* return: výstupní hash
--------------------------------------------------------
#### hash_sha383(text):
Vytvoří sha383 checksum ze zdrojového textu
* param text: zdrojový text 
* return: výstupní hash
----------------------------------------------------------------
#### id12_next(three_char_prefix=None):
Vygeneruje korektní 12místný alfanumerický identifikátor s pevným prefixem
* param three_char_prefix:   Tříznakový prefix identifikátoru
* return:    12místný alfanumerický identifikátor
----------------------------------------------------------------
#### increment_date(date_str=None, days=1):
Inkrementuje datum v textovém formátu ISO o daný počet dní
* param date_str:    ISO datum v textovém formátu ISO
* param days:        počet dní
* return:        ISO datum v textovém formátu ISO
----------------------------------------------------------------
#### is_base64(body):
Kontrola, zda jsou data kódována base64
* param body: Vstupní data (str, bytes) 
* return: True/False
----------------------------------------------------------------
#### is_valid_ico(ico):
Kontrola validity IČO
* param ico: IČO
* return: True/False
----------------------------------------------------------------
#### is_valid_pid(value):
Kontrola textové validity PID
* param value: PID 
* return: True/False
----------------------------------------------------------------
#### is_valid_uuid(value):
Kontrola validity uuid
* param value: uuid
* return: True/False
----------------------------------------------------------------
#### iso_to_local_datetime(isodate):
ISO string datum do lokálního datetime
* param isodate: Textové datum v ISO
* return: lokální datetime
----------------------------------------------------------------    
#### pid_check(pid):
Zkontroluje korektnost PID
* param pid: Vstupní PID
* return: True/False
----------------------------------------------------------------
#### pid_correct(pid):
Opraví PID
* param pid: Vstupní PID 
* return: Opravený PID
----------------------------------------------------------------    
#### pid_next():
Vygeneruje korektní PID
* return:    PID 
----------------------------------------------------------------
#### remove_empty(source_list):
Odstraní prázdné položky ze seznamu
* param source_list: zdrojový seznam
* return: cílový seznam
----------------------------------------------------------------
#### repair_ico(ico):
Opraví IČO
* param ico:  IČO 
* return: opravené IČO
----------------------------------------------------------------
#### to_base64(body):
Zajistí, aby data byla v base64
* param body: vstupní data 
* return: data v base64
----------------------------------------------------------------
#### today():
Vrací ISO 8601 text datum dnešního dne
* return:    ISO 8601 datum dnešního dne
----------------------------------------------------------------
#### tomorrow():
Vrací ISO 8601 datum zítřejšího dne
* return:    ISO 8601 datum
----------------------------------------------------------------
#### unique_list(input_list):
Vyřadí opakující se položky ze seznamu
* param input_list:   Vstupní seznam
* return: Unikátní seznam
----------------------------------------------------------------
#### url_safe(url):
Upraví URL, aby neobsahovalo nepovolené znaky
* param url: Vstupní URL
* return: Upravené URL
--------------------------------------------------------------------------------------------------------------------------------
#### uuid_next(uuid_type=1):
Vygeneruje UUID
* param uuid_type: Lze použít pouze typ 1 nebo 4
* return: uuid
--------------------------------------------------------------------------------------------------------------------------------
#### who_am_i():
Vrátí název aktuální funkce
* return: název funkce, odkud je voláno  
* například:   `__name__ = who_am_i()`  
--------------------------------------------------------------------------------------------------------------------------------
### Vereze 1.0.3
#### to_camel(s):
Převede text z hadí_notace do VelbloudíNotace
* param s: text v hadí notaci
* return: text ve velbloudí notaci  
--------------------------------------------------------------------------------------------------------------------------------
#### to_snake(s):
Převede text z VelbloudíNotace do hadí_notace 
* param s: text ve velbloudí notaci
* return: text v hadí notaci  
--------------------------------------------------------------------------------------------------------------------------------
#### to_camel_dict(d):
Rekurzivně převede klíče ve slovníku z hadí_notace do VelbloudíNotace
* param d: dictionary s klíči v hadí notaci
* return: dictionary s klíči ve velbloudí notaci  
--------------------------------------------------------------------------------------------------------------------------------
#### to_snake_dict(d):
Rekurzivně převede klíče ve slovníku z VelbloudíNotace do hadí_notace 
* param d: dictionary s klíči ve velbloudí notaci
* return: dictionary s klíči v hadí notaci  
--------------------------------------------------------------------------------------------------------------------------------
#### xml_to_dict(xml_text):
Parsuje XML string do XML dictionary 
podle pravidel viz https://github.com/martinblech/xmltodict
* param xml_text:    XML text
* return:    XML dictionary
--------------------------------------------------------------------------------------------------------------------------------
#### dict_to_xml(xml_dict):
Parsuje XML dict do XML textu podle 
pravidel viz https://github.com/martinblech/xmltodict
* param xml_dict:    XML dictionary
* return:    XML text
--------------------------------------------------------------------------------------------------------------------------------
### verze 1.0.4
#### order_to_cites(order: int):
Konvertuje celočíselnou hodnotu na písmennou
* param order: celočíselná hodnota např. 1458
* return:    znaková hodnota např. 'BDB'
--------------------------------------------------------------------------------------------------------------------------------
#### cites_to_order(cites: str):
Konvertuje písmennou hodnotu na celočíselnou
* param cites:   znaková hodnota např. 'BDB' 
* return:    celočíselná hodnota např. 1458



## Systémové proměnné

* **TZ**: Časová zóna. Implicitně 'Europe/Prague'
* **DEBUG**: Debug mode. Implictně `True`
* **LOG_FORMAT**: Formát logování. Implicitně `'%(asctime)s - %(levelname)s in %(module)s: %(message)s'`
* **LOG_DATE_FORMAT**: Formát data pro logování. Implicitně `'%d.%m.%Y %H:%M:%S'`
* **PID_PREFIX**: PID prefix. Implicitně `'SNT'`
