# generated by datamodel-codegen:
#   filename:  iscc-service-generator.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AnyUrl, BaseModel, Field, confloat, conint, constr


class Chain(Enum):
    """
    The blockchain on wich the ISCC-CODE will be declared.
    """

    PRIVATE = "PRIVATE"
    BITCOIN = "BITCOIN"
    ETHEREUM = "ETHEREUM"
    POLYGON = "POLYGON"


class IsccId(BaseModel):
    """
    An ISCC-ID
    """

    iscc_id: Optional[AnyUrl] = Field(
        None,
        description="A globaly unique, owned ISCC-ID (unconfirmed)",
        example="ISCC:MEADJVWXP67HW7NI",
    )
    iscc_code: str = Field(
        ...,
        description="The ISCC-CODE from wich the ISCC-ID will be minted.",
        example="ISCC:KQDZJFP6WBM3IIFZ7CRXCNDCNUU3ZEWGL5HAKHNMYHLN2WULPN3ZFHJO7AUS6VQQVM7Q",
    )
    chain: Chain = Field(
        ...,
        description="The blockchain on wich the ISCC-CODE will be declared.",
        example="ETHEREUM",
    )
    wallet: str = Field(
        ...,
        description="The wallet-address that will sign the ISCC declaration.",
        example="0xb794f5ea0ba39494ce839613fffba74279579268",
    )
    counter: Optional[int] = Field(
        None, description="The uniqueness counter of the ISCC-ID.", example=2
    )


class IsccRequest(BaseModel):
    """
    A request for generating an ISCC-CODE
    """

    source_file: Optional[bytes] = Field(None, description="The file used for generating the ISCC")
    source_url: Optional[AnyUrl] = Field(
        None,
        description="URL of file used for generating the ISCC",
        example="https://picsum.photos/200/300.jpg",
    )
    name: Optional[constr(min_length=1, max_length=128)] = Field(
        None,
        description=(
            "The title or name of the intangible creation manifested by the identified *digital"
            " content*. **Used as input for ISCC Meta-Code generation**."
        ),
        example="The Never Ending Story",
    )
    description: Optional[constr(min_length=1, max_length=1024)] = Field(
        None,
        description=(
            "Description of the *digital content* identified by the **ISCC**. **Used as input for"
            " ISCC Meta-Code generation**. Any user presentable text string (including Markdown"
            " text) indicative of the identity  of the referent may be used."
        ),
        example="a 1984 fantasy film co-written and directed by *Wolfgang Petersen*",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description=(
            "Descriptive, industry-sector or use-case specific structured JSON or JSON-LD metadata."
            " Used as sole input for Meta-Code and Meta-Hash generation if supplied."
        ),
        example={"custom_field": "custom_value"},
    )
    creator: Optional[str] = Field(
        None,
        description="An entity primarily responsible for making the resource.",
        example="Joanne K. Rowling",
    )
    license: Optional[AnyUrl] = Field(
        None,
        description=(
            "URI of license for the identified *digital content*. **Supports URI template"
            " `{iscc-id}`**."
        ),
        example="https://example.com/license-terms-for-this-item",
    )
    acquire: Optional[AnyUrl] = Field(
        None,
        description=(
            "This field must contain a valid URL referring to a page showing information about how"
            " one can acquire a license for the item. This may be a page of a web shop or NFT"
            " marketplace ready for providing a license. **Supports URI template `{iscc-id}`**."
        ),
        example="https://example.com/buy-license-for-item-here",
    )
    credit: Optional[str] = Field(
        None,
        description=(
            "A line of text that you expect users of the image (such as Google Images) to display"
            " alongside the image."
        ),
        example="Frank Farian - Getty Images",
    )
    rights: Optional[str] = Field(
        None,
        description=(
            "Contains any necessary copyright notice and should identify the current owner of the"
            " copyright of this work with associated intellectual property rights."
        ),
        example="© Copyright 2022 ISCC Foundation - www.iscc.codes",
    )


class _Type(Enum):
    """
    The type of digital content according to schema.org classes (TextDigitalDocument, ImageObject, AudioObject, VideoObject).
    """

    CreativeWork = "CreativeWork"
    TextDigitalDocument = "TextDigitalDocument"
    ImageObject = "ImageObject"
    AudioObject = "AudioObject"
    VideoObject = "VideoObject"


class IsccResponse(BaseModel):
    """
    Result of ISCC Processing
    """

    _context: Optional[AnyUrl] = Field(
        "http://purl.org/iscc/context",
        alias="@context",
        description="The [JSON-LD](https://json-ld.org/) Context URI for ISCC metadata.",
    )
    _type: Optional[_Type] = Field(
        "CreativeWork",
        alias="@type",
        description=(
            "The type of digital content according to schema.org classes (TextDigitalDocument,"
            " ImageObject, AudioObject, VideoObject)."
        ),
    )
    _schema: Optional[AnyUrl] = Field(
        "http://purl.org/iscc/schema",
        alias="$schema",
        description="The [JSON Schema](https://json-schema.org/) URI for ISCC metadata.",
    )
    iscc: Optional[constr(regex=r"^ISCC:[A-Z2-7]{10,73}$", min_length=15, max_length=73)] = Field(
        None,
        description=(
            "An **ISCC-CODE** in canonical representation. This is the minimal required field for a"
            " valid ISCC Metadata object."
        ),
        example="ISCC:KACYPXW445FTYNJ3CYSXHAFJMA2HUWULUNRFE3BLHRSCXYH2M5AEGQY",
    )
    name: Optional[constr(max_length=128)] = Field(
        None,
        description=(
            "The title or name of the intangible creation manifested by the identified *digital"
            " content*. **Used as input for ISCC Meta-Code generation**."
        ),
        example="The Never Ending Story",
    )
    description: Optional[constr(max_length=1024)] = Field(
        None,
        description=(
            "Description of the *digital content* identified by the **ISCC**. **Used as input for"
            " ISCC Meta-Code generation**. Any user presentable text string (including Markdown"
            " text) indicative of the identity  of the referent may be used."
        ),
        example="a 1984 fantasy film co-written and directed by *Wolfgang Petersen*",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description=(
            "Structured JSON or JSON-LD metadata. Used as sole input for Meta-Code and Meta-Hash"
            " generation if supplied."
        ),
        example={"custom_field": "custom_value"},
    )
    creator: Optional[str] = Field(
        None,
        description="An entity primarily responsible for making the resource.",
        example="Joanne K. Rowling",
    )
    license: Optional[AnyUrl] = Field(
        None,
        description=(
            "URI of license for the identified *digital content*. **Supports URI template"
            " `{iscc-id}`**."
        ),
        example="https://example.com/license-terms-for-this-item",
    )
    acquire: Optional[AnyUrl] = Field(
        None,
        description=(
            "This field must contain a valid URL referring to a page showing information about how"
            " one can acquire a license for the item. This may be a page of a web shop or NFT"
            " marketplace ready for providing a license. **Supports URI template `{iscc-id}`**."
        ),
        example="https://example.com/buy-license-for-item-here",
    )
    credit: Optional[str] = Field(
        None,
        description=(
            "A line of text that you expect users of the image (such as Google Images) to display"
            " alongside the image."
        ),
        example="Frank Farian - Getty Images",
    )
    rights: Optional[str] = Field(
        None,
        description=(
            "Contains any necessary copyright notice and should identify the current owner of the"
            " copyright of this work with associated intellectual property rights."
        ),
        example="© Copyright 2022 ISCC Foundation - www.iscc.codes",
    )
    preview: Optional[AnyUrl] = Field(
        None,
        description=(
            "URI for a small user-presentable thumbnail image that serves as a preview of the"
            " *digital content*. The URI may be a Data-URL"
            " [RFC2397](https://datatracker.ietf.org/doc/html/rfc2397)"
        ),
        example="https://picsum.photos/200/300.jpg",
    )
    content: Optional[AnyUrl] = Field(
        None, description="URI of the *digital content* that was used to create this ISCC."
    )
    created: Optional[datetime] = Field(
        None, description="Datetime the ISCC was created for the item."
    )
    filename: Optional[str] = Field(
        None,
        description=(
            "Filename of the referenced **digital content** (automatically used as fallback if the"
            " `name` field was not specified for ISCC processing)"
        ),
    )
    filesize: Optional[int] = Field(
        None, description="File size of media asset in number of bytes.", example="somefile.jpg"
    )
    mediatype: Optional[str] = Field(
        None,
        description=(
            "An [IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)"
            " (MIME type)"
        ),
        example="image/png",
    )
    duration: Optional[float] = Field(
        None, description="Duration of audio-visual media in secondes.", example=60.251
    )
    fps: Optional[confloat(ge=1.0)] = Field(
        None, description="Frames per second of video assets.", example=24
    )
    width: Optional[int] = Field(
        None, description="Width of visual media in number of pixels.", example=640
    )
    height: Optional[conint(ge=1)] = Field(
        None, description="Height of visual media in number of pixels.", example=480
    )
    characters: Optional[int] = Field(
        None,
        description="Number of text characters (code points after Unicode normalization)",
        example=55689,
    )
    pages: Optional[int] = Field(
        None, description="Number of pages (for paged documents only)", example=77
    )
    language: Optional[Union[str, List[str]]] = Field(
        None,
        description="Language(s) of content [BCP 47](https://tools.ietf.org/search/bcp47).",
        example="en-US",
    )
    features: Optional[List[Dict[str, Any]]] = Field(
        None, description="Granular features of the *digital content*."
    )
    generator: Optional[str] = Field(
        None,
        description="Name and version of the software that generated the ISCC",
        example="ISCC Generator Service - v1.5.0",
    )
    tophash: Optional[constr(min_length=40)] = Field(
        None,
        description=(
            "A [Multihash](https://multiformats.io/multihash/) of the concatenation (binding) of"
            " metahash and datahash (default blake3)."
        ),
        example="bdyqnosmb56tqudeibogyygmf2b25xs7wpg4zux4zcts2v6llqmnj4ja",
    )
    metahash: Optional[constr(min_length=40)] = Field(
        None,
        description=(
            "A [Multihash](https://multiformats.io/multihash/) of the supplied metadata (default"
            " blake3). The hash is created from `name` and `description` fields or `metadata` if"
            " supplied. For deterministic results [JSC"
            " RFC5452](https://datatracker.ietf.org/doc/html/rfc8785) canonicalization is applied"
            " to `metadata` before hashing if it is a JSON object."
        ),
        example="bdyqed6bziei6w4j2eilfyrwjbk4pb7mtthesakh5nuuisrfsh72365q",
    )
    datahash: Optional[constr(min_length=40)] = Field(
        None,
        description=(
            "A [Multihash](https://multiformats.io/multihash/) of the *digital content* (default"
            " blake3)."
        ),
        example="bdyqk6e2jxh27tingubae32rw3teutg6lexe23qisw7gjve6k4qpteyq",
    )


class Nft(BaseModel):
    """
    An ISCC NFT package to be used for NFT minting
    """

    iscc: Optional[str] = Field(
        None,
        description="The ISCC-ID or ISCC-CODE for which to create an NFT Package",
        example="ISCC:MEADJVWXP67HW7NI",
    )
    iscc_code: Optional[str] = Field(
        None,
        description="ISCC-CODE to be passed to the ISCC declaration contract.",
        example="ISCC:KQDZJFP6WBM3IIFZ7CRXCNDCNUU3ZEWGL5HAKHNMYHLN2WULPN3ZFHJO7AUS6VQQVM7Q",
    )
    token_id: Optional[constr(regex=r"^(0|[1-9][0-9]*)$")] = Field(
        None,
        description=(
            "Token-ID to be passed to the NFT minting contract. (The Token-ID is an integer"
            " representation (uint256) of the `ipfs_metadata_cid` without the static CID prefix."
        ),
        example="24264217585278480942562880083667472973488514177954865383155936279336351816001166239115842587",
    )
    ipfs_metadata_cid: Optional[str] = Field(
        None,
        description="The IPFS CIDv1 of the NFT Metadata ",
        example="bafkreiez43ignrqddzxy5faretffft3zbx43of4jxarbvav6jrqdlyfvpm",
    )
    ipfs_metadata_payload: Optional[str] = Field(
        None,
        description="The base64-encoded payload of the metadata.",
        example="ew0KICAidmVyc2lvbiI6ICIwLTAtMCIsDQogICJpc2NjIjogIktFRFpLTkRFWlFWQ0tXSEtWNDdOQUE0RzZGRUg1UVlPR002SVNGSjNZVFEzUFJUUVhORkY3TVkiLA0KICAidGl0bGUiOiAiSVNDQyBMb2dvIiwNCiAgImZpbGVuYW1lIjogImlzY2MtbG9nby5wbmciLA0KICAiZmlsZXNpemUiOiAyODkyMiwNCiAgIm1lZGlhdHlwZSI6ICJpbWFnZS9wbmciLA0KICAidG9waGFzaCI6ICJkYzgyZWIzMjk4MzAyZGVhYjIyOTFhNzBkMDcxYTc1YWNmYjJmZTA2YTg0OWExZGNiYTU0YWMyMGYxYTI4Y2ZiIiwNCiAgIm1ldGFoYXNoIjogIjJhYjEzNjJhOTYyNDUzOTIzMzM3YTRhYTA1NTQ1N2U4Y2Q2ZGQ5MjVmNjIwYThlNzA2YmJjNmYzZDdjNTNkYmMiLA0KICAiZGF0YWhhc2giOiAiZTFiN2M2NzBiYjRhNWZiM2QzZjA1Zjc4NTRiMThiOTBkMDg1NmEzYmNlNDA3ZjM5ZGM4YzY5NjJlNTE3MWM3ZCIsDQogICJnbXQiOiAiaW1hZ2UiLA0KICAid2lkdGgiOiAxMTgyLA0KICAiaGVpZ2h0IjogMzczDQp9DQo=",
    )
    ipfs_image_cid: Optional[str] = Field(
        None,
        description="The IPFS CIDv1 of the NFT image.",
        example="bafybeihcck6iocb2steuf4zwq53nfyce34xamke5za7gaq2qqoshmgab6u",
    )
    ipfs_image_uri: Optional[AnyUrl] = Field(
        None,
        description=(
            "The URI to the NFT image (either a local relative URL or a Data-URI depending on"
            " server configuration)"
        ),
        example="/media/d8541cb6f21e952c2c532535c77ac145c09ee1e4184e7f4b19d07c836f83d16a",
    )
